<?php
# $Id: editlang_functions.php,v 1.13.2.3 2004/02/02 15:18:12 yalnifj Exp $
//-----------------------------------------------------------------
function add_backslash_before_dollarsign($dstring)
{
  $dummy = str_replace(chr(92) . chr(36), chr(36), $dstring);
  $dummy = str_replace(chr(36), chr(92) . chr(36), $dummy);
  return $dummy;
}

//-----------------------------------------------------------------
function crlf_lf_to_br($dstring)
{
  $dummy = str_replace("\r\n", "<br />", $dstring);
  $dummy = str_replace("\n", "<br />", $dummy);
  return $dummy;
}

//-----------------------------------------------------------------
function mask_lt($dstring)
{
  $dummy = str_replace("<", "&lt;", $dstring);
  return $dummy;
}

//-----------------------------------------------------------------
function mask_gt($dstring)
{
  $dummy = str_replace(">", "&gt;", $dstring);
  return $dummy;
}

//-----------------------------------------------------------------
function mask_quot($dstring)
{
  $dummy = str_replace("\"", "&quot;", $dstring);
  return $dummy;
}

//-----------------------------------------------------------------
function mask_amp($dstring)
{
  $dummy = str_replace("&", "&amp;", $dstring);
  return $dummy;
}

//-----------------------------------------------------------------
function mask_all($dstring)
{
  $dummy = mask_lt(mask_gt(mask_quot(mask_amp($dstring))));
  return $dummy;
}

//-----------------------------------------------------------------
function LockFile($Temp_Filename)
{
  while (file_exists($Temp_Filename . ".tmp")){clearstatcache();} # wait till file is deleted
  $fp = fopen($Temp_Filename . ".tmp", "w");
  fclose($fp); # temp-file to block all access to $Filename
}

//-----------------------------------------------------------------
function UnLockFile($Temp_Filename)
{
  while (!@unlink($Temp_Filename . ".tmp")){clearstatcache();} # remove file block
}

//-----------------------------------------------------------------
function read_complete_file_into_array($dFileName, $string_needle)
{
  global $file_type, $language2, $PGV_BASE_DIRECTORY, $lang_shortcut;

  $Filename = $PGV_BASE_DIRECTORY . $dFileName;
  LockFile($Filename);

  $LineCounter = 0;
  $InfoArray = array();
  $dFound = ($fp = @fopen($Filename, "r"));

  if (!$dFound)
  {
    $dUserName = getUserName();
    $dUser = getUser($dUserName);
    $dUserRealName = $dUser["fullname"];

    $dFound = ($fp = @fopen($Filename, "w"));
    fwrite($fp, "<?php\r\n");

    switch ($file_type)
    {
      case "lang"		: fwrite($fp, "/*=============================================================" . "\r\n");
      			  	  fwrite($fp, "	charset=utf-8" . "\r\n");
      			  	  fwrite($fp, "	Project: phpGedView" . "\r\n");
      			  	  fwrite($fp, "   File:	" . $dFileName . "\r\n");
      			  	  fwrite($fp, "   Author:	John Finlay" . "\r\n");
      			  	  fwrite($fp, "   Translation:	" . $dUserRealName . "\r\n");
      			  	  fwrite($fp, "   Comments:	" . $language2 . " Language file for PHPGedView" . "\r\n");
      			  	  fwrite($fp, "   Change Log:	" . date("Y") . "-" . date("m") . "-" . date("d") . " - File created by " . $dUserRealName . "\r\n");
      			  	  fwrite($fp, "   		For other changes read:" . "\r\n");
      			  	  fwrite($fp, "   		languages/LANG_CHANGELOG.txt" . "\r\n");
      			  	  fwrite($fp, "=============================================================*/" . "\r\n");
      			  	  fwrite($fp, "# \$Id\$" . "\r\n");
      			  	  fwrite($fp, "if (preg_match(\"/lang\\...\\.php\$/\", \$_SERVER[\"PHP_SELF\"])>0) {" . "\r\n");
      			  	  fwrite($fp, "	print \"You cannot access a language file directly.\";" . "\r\n");
      			  	  fwrite($fp, "	exit;" . "\r\n");
      			  	  fwrite($fp, "}" . "\r\n");
      			  	  fwrite($fp, "//-- GENERAL HELP MESSAGES" . "\r\n");
      			  	  break;
      case "facts"		: fwrite($fp, "/*=============================================================" . "\r\n");
      			  	  fwrite($fp, "   charset=utf-8" . "\r\n");
      			  	  fwrite($fp, "   Project:	phpGedView" . "\r\n");
      			  	  fwrite($fp, "   File:	" . $dFileName . "\r\n");
      			  	  fwrite($fp, "	Author: John Finlay" . "\r\n");
      			  	  fwrite($fp, "   Translation:	" . $dUserRealName . "\r\n");
      			  	  fwrite($fp, "   Comments:	Defines an array of GEDCOM codes and the " . $language2 . " name facts that they represent." . "\r\n");
      			  	  fwrite($fp, "   Change Log:	" . date("Y") . "-" . date("m") . "-" . date("d") . " - File created by " . $dUserRealName . "\r\n");
      			  	  fwrite($fp, "   		For other changes read:" . "\r\n");
      			  	  fwrite($fp, "   		languages/LANG_CHANGELOG.txt" . "\r\n");
      			  	  fwrite($fp, "=============================================================*/" . "\r\n");
      			  	  fwrite($fp, "# \$Id\$" . "\r\n");
      			  	  fwrite($fp, "if (preg_match(\"/facts\\...\\.php\$/\", \$_SERVER[\"PHP_SELF\"])>0) {" . "\r\n");
      			  	  fwrite($fp, "	print \"You cannot access a language file directly.\";" . "\r\n");
      			  	  fwrite($fp, "	exit;" . "\r\n");
      			  	  fwrite($fp, "}" . "\r\n");
      			  	  fwrite($fp, "// -- Define a fact array to map Gedcom tags with their " . $language2 . " values" . "\r\n");
      			  	  break;
      case "configure_help"	: fwrite($fp, "/*=============================================================" . "\r\n");
      			  	  fwrite($fp, "   charset=utf-8" . "\r\n");
      			  	  fwrite($fp, "   Project:	phpGedView" . "\r\n");
      			  	  fwrite($fp, "   File:	" . $dFileName . "\r\n");
      			  	  fwrite($fp, "   Author:	John Finlay" . "\r\n");
      			  	  fwrite($fp, "   Translation:	" . $dUserRealName . "\r\n");
      			  	  fwrite($fp, "   Comments:	" . $language2 . " Language Configure Help file for PHPGedView" . "\r\n");
      			  	  fwrite($fp, "   Change Log:	" . date("Y") . "-" . date("m") . "-" . date("d") . " - File created by " . $dUserRealName . "\r\n");
      			  	  fwrite($fp, "   		For other changes read:" . "\r\n");
      			  	  fwrite($fp, "   		languages/LANG_CHANGELOG.txt" . "\r\n");
      			  	  fwrite($fp, "=============================================================*/" . "\r\n");
      			  	  fwrite($fp, "# \$Id\$" . "\r\n");
      			  	  fwrite($fp, "if (preg_match(\"/configure_help\\...\\.php\$/\", \$_SERVER[\"PHP_SELF\"])>0) {" . "\r\n");
      			  	  fwrite($fp, "	print \"You cannot access a language file directly.\";" . "\r\n");
      			  	  fwrite($fp, "	exit;" . "\r\n");
      			  	  fwrite($fp, "}" . "\r\n");
      			  	  fwrite($fp, "//-- CONFIGURE FILE MESSAGES" . "\r\n");
      			  	  break;
      case "help_text"		: fwrite($fp, "/*=============================================================" . "\r\n");
      			  	  fwrite($fp, "   charset=utf-8" . "\r\n");
      			  	  fwrite($fp, "   Project:	phpGedView" . "\r\n");
      			  	  fwrite($fp, "   File:	" . $dFileName . "\r\n");
      			  	  fwrite($fp, "   Author:	John Finlay" . "\r\n");
      			  	  fwrite($fp, "   Translation:	" . $dUserRealName . "\r\n");
      			  	  fwrite($fp, "   Comments:	" . $language2 . " Language Help-file for PHPGedView" . "\r\n");
      			  	  fwrite($fp, "   Change Log:	" . date("Y") . "-" . date("m") . "-" . date("d") . " - File created by " . $dUserRealName . "\r\n");
      			  	  fwrite($fp, "   		For other changes read:" . "\r\n");
      			  	  fwrite($fp, "   		languages/LANG_CHANGELOG.txt" . "\r\n");
      			  	  fwrite($fp, "=============================================================*/" . "\r\n");
      			  	  fwrite($fp, "# \$Id\$" . "\r\n");
      			  	  fwrite($fp, "\r\n");
      			  	  fwrite($fp, "//-- GENERAL HELP HEADER" . "\r\n");
      			  	  break;
      case "rs_lang"		: fwrite($fp, "/*=============================================================" . "\r\n");
      			  	  fwrite($fp, "	charset=utf-8" . "\r\n");
      			  	  fwrite($fp, "	Project: phpGedView" . "\r\n");
      			  	  fwrite($fp, "   File:	" . $dFileName . "\r\n");
      			  	  fwrite($fp, "	Author: John Finlay" . "\r\n");
      			  	  fwrite($fp, "	Developer: Roland Dalmulder" . "\r\n");
      			  	  fwrite($fp, "   Translation:	" . $dUserRealName . "\r\n");
      			  	  fwrite($fp, "   Comments:	" . $language2 . " Language file for PHPGedView Researchlog" . "\r\n");
      			  	  fwrite($fp, "   Change Log:	" . date("Y") . "-" . date("m") . "-" . date("d") . " - File created by " . $dUserRealName . "\r\n");
      			  	  fwrite($fp, "   		For other changes read:" . "\r\n");
      			  	  fwrite($fp, "   		languages/LANG_CHANGELOG.txt" . "\r\n");
      			  	  fwrite($fp, "=============================================================*/" . "\r\n");
      			  	  fwrite($fp, "# \$Id\$" . "\r\n");
      			  	  fwrite($fp, "\r\n");
      			  	  fwrite($fp, "// -- RS GENERAL MESSAGES" . "\r\n");
      			  	  break;
    }
    fwrite($fp, "\r\n");
    fwrite($fp, "?>");
    fclose($fp);

    $dFound = ($fp = @fopen($Filename, "r"));
  }

  if ($dFound)
  {
    while (!feof($fp))
    {
      $line = fgets($fp, (4 * 1024));
      if ($x = strpos(trim($line), $string_needle))
      {
      	if ($x == 1)
      	{
          $line_mine = $line;
          $line = trim($line);
          $key = trim(substr($line, 0, strpos($line, "]") + 1));
          $ct = preg_match("/=\s*\"(.*)\"/", $line, $match);
          # if ($ct>0) $content = trim($match[1]);
          if ($ct>0) $content = $match[1];
          else $content = "";
          $InfoArray[$LineCounter][0] = $key;				// keystring
          # print "#".$key."# ";
          $InfoArray[$LineCounter][1] = $content;			// message of keystring

          # print "#".$content."#<br />";
          if ($content != "")
          {
            $InfoArray[$LineCounter][2] = strpos($line_mine, $content);	// pos of the first char of the message
          }
          else $InfoArray[$LineCounter][2] = "";

          $InfoArray[$LineCounter][3] = $line_mine;			// complete line
        }
        else {$InfoArray[$LineCounter][0] = $line;}
      }
      else {$InfoArray[$LineCounter][0] = $line;}
      $LineCounter++;
    }
    fclose($fp);
  }
  else print "E R R O R !!!";
  # exit;

  UnLockFile($Filename);

  return $InfoArray;
}

//-----------------------------------------------------------------
function find_in_file($MsgNr, $dlang_file)
{
  global $PGV_BASE_DIRECTORY;
  $openfilename = $PGV_BASE_DIRECTORY . $dlang_file;
  $my_array = @file($openfilename);

  $my_Dummy = $my_array[$MsgNr];

  $my_Dummy = trim(substr($my_Dummy, strpos($my_Dummy, "=") + 1));
  $my_Dummy = substr($my_Dummy, strpos($my_Dummy, "\"") + 1);
  $my_Dummy = substr($my_Dummy, 0, strrpos($my_Dummy, ";") - 1);

  return $my_Dummy;
}

//-----------------------------------------------------------------
function find_key_in_new_language_old($new_array, $string_needle)
{
  $dummy = "";
  $dcount = 0;
  while ($new_array[$dcount] != "")
  {
    if ($new_array[$dcount][0] == $string_needle){return $dcount;}
    $dcount++;
  }
  return false;
}

//-----------------------------------------------------------------
function write_array_into_file($dFileName01, $writeArray, $add_new_message_at_line, $new_message_string)
{
  global $PGV_BASE_DIRECTORY;

  $Filename = $PGV_BASE_DIRECTORY . $dFileName01;
  # $Filename = $PGV_BASE_DIRECTORY . "languages/test.php";
  LockFile($Filename);

  $LineCounter = 0;
  $fp = fopen($Filename, "w");
  foreach($writeArray as $var)
  {
    if ($LineCounter == $add_new_message_at_line)
    {
      fwrite($fp, $new_message_string . "\r\n");
      $LineCounter++;
    }

    if (empty($var[1]))
    {
      if (isset($var[3]))
      {
        fwrite($fp, $var[3]);
      }
      else
      {
        fwrite($fp, $var[0]);
      }
    }
    else
    {
      fwrite($fp, substr($var[3], 0, $var[2]));
      fwrite($fp, $var[1]);
      fwrite($fp, "\";\r\n");
    }
    $LineCounter++;
  }
  fclose($fp);
  UnLockFile($Filename);
}

//-----------------------------------------------------------------
function read_export_file_into_array($dFileName, $string_needle)
{
  $Filename = $dFileName;

  $LineCounter = 0;
  $InfoArray = array();
  $dFound = ($fp = @fopen($Filename, "r"));

  if (!$dFound)
  {
    print "Error file not found"; Exit;
  }
  else
  {
    while (!feof($fp))
    {
      $line = fgets($fp, (4 * 1024));
      if ($x = strpos(trim($line), $string_needle))
      {
      	if ($x == 1)
      	{
          $line_mine = $line;
          $line = trim($line);
          $key = trim(substr($line, 0, strpos($line, "]") + 1));
          $ct = preg_match("/=\s*\"(.*)\"/", $line, $match);
          if ($ct>0) $content = $match[1];
          else $content = "";
          $InfoArray[$LineCounter][0] = $key;				// keystring
          $InfoArray[$LineCounter][1] = $content;			// message of keystring
        }
        $LineCounter++;
      }
    }
    fclose($fp);
  }

  return $InfoArray;
}

?>
