<?php
/*=================================================
	Project: phpGedView
	File: edituser.php
	Author: John Finlay
	Comments:
		Administrative User Interface.

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
===================================================*/
# $Id: edituser.php,v 1.13 2003/12/09 16:23:49 yalnifj Exp $

require "config.php";
require $PGV_BASE_DIRECTORY.$confighelpfile["english"];
if (file_exists($PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE])) require $PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE];

if (!isset($action)) $action="";

//-- make sure that they have admin status before they can use this page
//-- otherwise have them login again
$uname = getUserName();
if (empty($uname)) {
	header("Location: login.php?url=edituser.php");
	exit;
}
$user = getUser($uname);
	
print_header("PhpGedView User Administration");
print "<center>\n";

//-- section to update a user by first deleting them
//-- and then adding them again
if ($action=="edituser2") {
	if (($username!=$oldusername)&&(getUser($username)!==false)) {
		print "<font class=error>".$pgv_lang["duplicate_username"]."</font><br />";
	}
	else if ($pass1==$pass2) {
		$newuser = array();
		$olduser = getUser($oldusername);
		$newuser = $olduser;
		if (empty($pass1)) $newuser["password"]=$olduser["password"];
		else $newuser["password"]=crypt($pass1);
		deleteUser($oldusername);
		$newuser["username"]=$username;
		$newuser["fullname"]=$fullname;
		$newuser["rootid"][$GEDCOM] = $rootid;
		if (isset($user_language)) $newuser["language"]=$user_language;
		$newuser["email"] = $user_email;
		if (isset($user_theme)) $newuser["theme"] = $user_theme;
		addUser($newuser);
		$user = $newuser;
	}
	else {
		print "<font class=error>".$pgv_lang["password_mismatch"]."</font><br />";
		$action="edituser";
	}
}
//-- print the form to edit a user
?>
<script language="JavaScript">
	function checkform(frm) {
		if (frm.username.value=="") {
			alert("<?php print $pgv_lang["enter_username"]; ?>");
			frm.username.focus();
			return false;
		}
		if (frm.fullname.value=="") {
			alert("<?php print $pgv_lang["enter_fullname"]; ?>");
			frm.fullname.focus();
			return false;
		}
		if (frm.user_email.value=="") {
			alert("<?php print $pgv_lang["enter_email"]; ?>");
			frm.fullname.focus();
			return false;
		}
<?php if ($USE_RELATIONSHIP_PRIVACY) { ?>
		if (frm.gedcomid.value=="") {
			alert("<?php print $pgv_lang["enter_gedcomid"]; ?>");
			frm.gedcomid.focus();
			return false;
		}
<?php } ?>
		return true;
	}
	var pasteto;
	function open_find(textbox) {
		pasteto = textbox;
		findwin = window.open('findid.php', '', 'left=50,top=50,width=450,height=450,resizable=1,scrollbars=1');
	}
	function paste_id(value) {
		pasteto.value=value;
	}
</script>
<form name="editform" method="post" onsubmit="return checkform(this);">
<input type="hidden" name="action" value="edituser2">
<input type="hidden" name="oldusername" value="<?php print $uname; ?>">
<table>
	<tr><td class="facts_label" valign="top" align=right><?php print $pgv_lang["username"]?></td><td class="facts_value"><input type="text" name="username" value="<?php print $user['username']?>"><font class=error>*</font></td></tr>
	<tr><td class="facts_label" valign="top" align=right><?php print $pgv_lang["fullname"]?></td><td class="facts_value"><input type="text" name="fullname" value="<?php print $user['fullname']?>"><font class=error>*</font></td></tr>
	<tr><td class="facts_label" valign="top" align=right><?php print $pgv_lang["gedcomid"]?></td><td class="facts_value"><?php if (!empty($user['gedcomid'][$GEDCOM])) print_list_person($user['gedcomid'][$GEDCOM], array(get_person_name($user['gedcomid'][$GEDCOM]), $GEDCOM)); ?><br /></td></tr>
	<tr><td class="facts_label" valign="top" align=right><?php print $pgv_lang["rootid"]?></td><td class="facts_value"><input type="text" name="rootid" value="<?php if (isset($user['rootid'][$GEDCOM])) print $user['rootid'][$GEDCOM]; ?>"><font size="1"><a href="javascript:open_find(document.editform.rootid);"><?php print $pgv_lang["find_id"];?></a></font></td></tr>
	<tr><td class="facts_label" valign="top" align=right><?php print $pgv_lang["password"]?></td><td class="facts_value"><input type="password" name="pass1"></td></tr>
	<tr><td class="facts_label" valign="top" align=right><?php print $pgv_lang["confirm"]?></td><td class="facts_value"><input type="password" name="pass2"></td></tr>
	<tr><td class="facts_label" valign="top" align=left><?php print $pgv_lang["change_lang"]; ?>:</td><td class="facts_value" valign="top"><?php
      if ($ENABLE_MULTI_LANGUAGE)
      {
      	if (empty($LANG_FORM_COUNT))
      	{
      	  $LANG_FORM_COUNT = 1;
      	}
      	else
      	{
      	  $LANG_FORM_COUNT++;
      	}
      	print "<select name=\"user_language\" style=\"{ font-size: 9pt; }\">";
      	foreach ($pgv_language as $key => $value)
      	{
      	  print "\n\t\t\t<option value=\"$key\"";
      	  if ($key == $user["language"])
      	  {
      	    print " selected";
      	  }
      	  print ">" . $pgv_lang[$key] . "</option>";
      	}
      	print "</select>\n\t\t";
      }
      else print "&nbsp;";
    ?></td></tr>
    <tr><td class="facts_label" valign="top" align=left><?php print $pgv_lang["emailadress"];?></td><td class="facts_value" valign="top"><input type="text" name="user_email" value="<?php print $user["email"]; ?>" size="50"> <font class=error>*</font><br /><?php print $pgv_lang["pls_note03"];?></td></tr>
    <?php if ($ALLOW_USER_THEMES) { ?>
    <tr><td class="facts_label" valign="top" align=left><?php print $pgv_lang["user_theme"];?></td><td class="facts_value" valign="top">
    	<select name="user_theme">
    	<option value=""><?php print $pgv_lang["site_default"]; ?></option>
				<?php
					$themes = get_theme_names();
					foreach($themes as $themedir) {
						print "<option value=\"".$themedir["dir"]."\"";
						if ($themedir["dir"] == $user["theme"]) print " selected";
						print ">".$themedir["name"]."</option>\n";
					}
				?>
			</select>
	</td></tr>
	<?php } ?>
</table>
<input type="submit" value="<?php print $pgv_lang["update_user"]; ?>">
</form>
<?php print $pgv_lang["leave_blank"]; ?>
</center>
<?php
print_footer();
?>
