<?php
/*=================================================
	Project: phpGedView
	File: famlist.php
	Author: John Finlay
	Comments:
		Parses gedcom file and displays a list of the families in the file.

	Change Log:
		8/21/03 - File Created

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: findfamily.php,v 1.2 2003/12/09 16:23:49 yalnifj Exp $

require("config.php");
print_simple_header("Find Family List");
?>
<script type="text/javascript">
	function pasteid(id) {
		window.opener.pasteid(id);
		window.close();
	}
</script>
<?php
print "<center>\n";
print "\n\t<h2>".$pgv_lang["family_list"]."</h2>";
if (empty($surname_sublist)) $surname_sublist = "yes";
if (empty($show_all)) $show_all = "no";

$tfamlist = array();

if ((!$ALPHA_INDEX_LISTS)||($show_all=="yes")) {
	$tfamlist = get_fam_list();
	uasort($tfamlist, "itemsort");
}
else {
	$famalpha = get_fam_alpha();
	foreach($famalpha as $letter=>$list) {
		if (empty($alpha)) $alpha = $letter;
		print "<a href=\"findfamily.php?alpha=$letter&amp;surname_sublist=$surname_sublist\">$letter</a> | \n";
	}
	print "<a href=\"findfamily.php?show_all=yes&amp;surname_sublist=$surname_sublist\">".$pgv_lang["all"]."</a>\n";
	$tfamlist = get_alpha_fams($alpha);
	uasort($tfamlist, "itemsort");
}

print "<br /><br /><table class=\"list_table\"><tr>";
if (($surname_sublist=="yes")&&(empty($surname))&&($show_all=="no")) {
	print "<td class=\"list_label\" colspan=\"2\">".$pgv_lang["surnames"]."</td></tr><tr>\n";
	print "<td class=\"list_value\">\n";
	$oldsurname = "";
	$namecount = 0;
	$surnames = array();
	foreach($tfamlist as $gid=>$fam) {
		$name = preg_replace("/ [jJsS]r\.?,/", ",", $fam["name"]);
		$names = preg_split("/[,+]/", $name);
		$surname = $names[0];
		if (trim(strtoupper($oldsurname))!=trim(strtoupper($surname))) {
			if (!empty($oldsurname)) $surnames[$oldsurname] = $namecount;
			$namecount=1;
			$oldsurname = $surname;
		}
		else $namecount++;
	}
	if (!empty($oldsurname)) $surnames[$oldsurname] = $namecount;
	$i = 0;
	$count = count($surnames);
	foreach($surnames as $surname=>$namecount) {
		print "<a href=\"findfamily.php?alpha=$alpha&amp;surname_sublist=$surname_sublist&amp;surname=$surname\">$surname - [$namecount]</a><br />\n";
		$i++;
		if ($i==floor($count/2)) print "</td><td class=\"list_value\">\n";
	}
	print "</td>\n";
}
else {
	//-- if the surname is set then only get the names in that surname list
	if ((!empty($surname))&&($surname_sublist=="yes")) {
		$surname = stripslashes($surname);
		$newfamlist = array();
		foreach($tfamlist as $gid=>$fam) {
			$name = preg_replace("/ [jJsS]r\.?,/", ",", $fam["name"]);
			$names = preg_split("/[,+]/", $name);
			$sname = $names[0];
			if (trim(strtoupper($sname))==trim(strtoupper($surname))) $newfamlist[$gid] = $fam;
		}
		$tfamlist = $newfamlist;
	}
	$ct = count($tfamlist);
	$i=0;
	print "<td class=\"list_value\"><ul>\n";
	foreach($tfamlist as $gid=>$fam) {
		$showLiving = true;
		$display = true;
		if ($HIDE_LIVE_PEOPLE){
			$parents = find_parents($gid);
			if (!empty($parents["HUSB"])) $display = displayDetailsByID($parents["HUSB"]);
			if ($display) {
				if (!empty($parents["WIFE"])) $display = displayDetailsByID($parents["WIFE"]);
				if (!$display) $showLiving=showLivingNameByID($parents["WIFE"]);
			}
			else {
				$showLiving=showLivingNameByID($parents["HUSB"]);
			}
		}
	    if ($showLiving) {
			print "<li>";
			print "<a href=\"#\" onclick=\"pasteid('$gid'); return false;\">".$fam["name"]."</a>";
			print "</li>\n";
		}
		$i++;
	}
	print "</ul></td>\n";
}
print "</tr></table>";
if (!isset($alpha)) $alpha="";
if ($surname_sublist=="yes") print "<br /><a href=\"findfamily.php?alpha=$alpha&amp;surname_sublist=no\">".$pgv_lang["skip_surnames"]."</a><br />\n";
else print "<br /><a href=\"findfamily.php?alpha=$alpha&amp;surname_sublist=yes\">".$pgv_lang["show_surnames"]."</a><br />\n";
print "</center>\n";
print_simple_footer();

?>
