<?php
/***********************************************************
	File: findplace.php
	Project: phpGedView
	Author: John Finlay
	Posts to: none
	Comments:
		Popup window that will allow a user to search for a place

	Change Log:
		9/03/03 - File Created (yalnifj)

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

***********************************************************/
# $Id: findmedia.php,v 1.5 2003/12/17 23:51:30 yalnifj Exp $
require("config.php");
if (!isset($action)) $action="";
if (!isset($media)) $media="";
if (!isset($directory)) $directory = $MEDIA_DIRECTORY;
//-- prevent script from accessing an area outside of the media directory
if (preg_match("'^$MEDIA_DIRECTORY'", $directory)==0) $directory = $MEDIA_DIRECTORY;
if (!isset($thumbdir)) $thumbdir = $MEDIA_DIRECTORY."thumbs/";
if (!isset($level)) $level=0;

print_simple_header($pgv_lang["find_media"]);

//-- only allow users with edit privileges to access script.
if ((!userCanEdit(getUserName())) || (!$ALLOW_EDIT_GEDCOM)) {
	print $pgv_lang["access_denied"];
	print_simple_footer();
	exit;
}

?>
<script type="text/javascript">
	function pasteid(id) {
		window.opener.pasteid(id);
		window.close();
	}
	function openImage(filename, width, height) {
		height=height+50;
		screenW = screen.width;
	 	screenH = screen.height;
	 	if (width>screenW) width=screenW;
	 	if (height>screenH) height=screenH;
		if ((filename.search(/\.jpg$/gi)!=-1)||(filename.search(/\.gif$/gi)!=-1)) window.open('imageview.php?filename='+filename,'','top=50,left=50,height='+height+',width='+width+',scrollbars=1,resizable=1');
		else window.open(filename,'','top=50,left=50,height='+height+',width='+width+',scrollbars=1,resizable=1');
		return false;
	}
</script>
<div align="center">
<font class="subheaders"><?php print $pgv_lang["find_media"]; ?></font>
<?php
$badmedia = array(".","..","CVS","thumbs");
if (empty($action)) {
	$action="filter";
}
if ($action=="filter") {
	$medialist = array();
	
	$d = dir($directory);
	if ($level>0) {
		$levels = preg_split("'/'", $directory);
		$pdir = "";
		for($i=0; $i<count($levels)-2; $i++) $pdir.=$levels[$i]."/";
		$levels = preg_split("'/'", $thumbdir);
		$pthumb = "";
		for($i=0; $i<count($levels)-2; $i++) $pthumb.=$levels[$i]."/";
		print "<br /><a href=\"findmedia.php?directory=$pdir&thumbdir=$pthumb&level=".($level-1)."\">&lt;-- $pdir</a><br />\n";
	}
	print "\n\t<table class=\"list_table\">";
	while (false !== ($media = $d->read())) {
		if (!in_array($media, $badmedia)) {
			$mediafile = $directory.$media;
			$thumbnail = $thumbdir.$media;
			print "\n\t\t<tr>\n\t\t<td class=\"list_value\">";
			if (is_dir($mediafile)) print "<a href=\"findmedia.php?directory=$mediafile/&thumbdir=$thumbnail/&level=".($level+1)."\">$media</a><br />\n";
			else {
				$imgsize = getimagesize($mediafile);
				if ($imgsize) {
					$imgwidth = $imgsize[0]+50;
					$imgheight = $imgsize[1]+50;
				}
				else {
					$imgwidth = 300;
					$imgheight = 300;
				}
				if (file_exists($thumbnail)) print "<a href=\"#\" onclick=\"return openImage('".preg_replace("/'/", "\'", filename_encode($mediafile))."',$imgwidth, $imgheight);\"><img src=\"".filename_encode($thumbnail)."\" border=\"0\" width=\"50\"></a>\n";
				print "<a href=\"#\" onclick=\"pasteid('".preg_replace("/'/", "\'", filename_encode($mediafile))."');\">".stripslashes(filename_encode($media))."</a> -- ";
				print "<a href=\"#\" onclick=\"return openImage('".preg_replace("/'/", "\'", filename_encode($mediafile))."',$imgwidth, $imgheight);\">".$pgv_lang["view"]."</a><br />\n";
			}
			print "</td></tr>";
		}
	}
	print "</table>";
	$d->close();
}
print "</center>";
print_simple_footer();
?>
