<?php
/*=================================================
	Project: phpGedView
	File: functions.php
	Author:
		John Finlay
		Joe Witthuhn		jaw959@users.sourceforge.net
		Kurt Norgaz			kurtnorgaz
	Comments:
		Various functions used by all scripts and included by the config.php
		file.

	Change Log:
		8/09/03 - File Created from functions.php

	phpGedView: Genealogy Viewer
	Copyright (C) 2002 to 2003  John Finlay and Others

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: functions.php,v 1.242.2.8 2004/02/04 20:16:17 botak Exp $

if (strstr($_SERVER["PHP_SELF"],"functions.php")) {
	print "Why do you want to do that?";
	exit;
}

if (strstr($PHP_SELF, "gdbi.php")===false) require($PGV_BASE_DIRECTORY."functions_print.php");

//-- get the configuration file for the given GEDCOM
function get_config_file() {
	global $GEDCOMS, $GEDCOM, $PGV_BASE_DIRECTORY;

	if (count($GEDCOMS)==0) {
		return $PGV_BASE_DIRECTORY."config_gedcom.php";
	}
	if ((!empty($GEDCOM))&&(isset($GEDCOMS[$GEDCOM]))) return $GEDCOMS[$GEDCOM]["config"];
	foreach($GEDCOMS as $GEDCOM=>$gedarray) {
		$_SESSION["GEDCOM"] = $GEDCOM;
		return $PGV_BASE_DIRECTORY.$gedarray["config"];
	}
}

//-- get the privacy file for the given GEDCOM
function get_privacy_file() {
	global $GEDCOMS, $GEDCOM, $PGV_BASE_DIRECTORY;

	if (count($GEDCOMS)==0) {
		return $PGV_BASE_DIRECTORY."privacy.php";
	}
	if ((!empty($GEDCOM))&&(isset($GEDCOMS[$GEDCOM]))) {
		if (isset($GEDCOMS[$GEDCOM]["privacy"])) return $GEDCOMS[$GEDCOM]["privacy"];
		else return $PGV_BASE_DIRECTORY."privacy.php";
	}
	foreach($GEDCOMS as $GEDCOM=>$gedarray) {
		$_SESSION["GEDCOM"] = $GEDCOM;
		if (isset($gedarray["privacy"])) return $PGV_BASE_DIRECTORY.$gedarray["privacy"];
		else return $PGV_BASE_DIRECTORY."privacy.php";
	}
}

//-- get the time in microsecs
function getmicrotime(){
	list($usec, $sec) = explode(" ",microtime());
	return ((float)$usec + (float)$sec);
}

//-- update gedcom configurations in the config.php file
function store_gedcoms() {
	global $GEDCOMS, $pgv_lang;

	$configtext = implode('', file("config.php"));
	$pos1 = strpos($configtext, "//--START GEDCOM CONFIGURATIONS");
	$pos2 = strpos($configtext, "//--END GEDCOM CONFIGURATIONS");
	if ((!$pos1) || (!$pos2)) {
		print "<font class=\"error\">Unable to find gedcom configuration section in config.php<br /></font>\n";
		exit;
	}
	$gedcomtext = "//--START GEDCOM CONFIGURATIONS\n";
	$gedcomtext .= "\$GEDCOMS = array();\n";
	foreach($GEDCOMS as $GED) {
		$gedcomtext .= "\$gedarray = array();\n";
		$gedcomtext .= "\$gedarray[\"gedcom\"] = \"".$GED["gedcom"]."\";\n";
		$gedcomtext .= "\$gedarray[\"config\"] = \"".$GED["config"]."\";\n";
		$gedcomtext .= "\$gedarray[\"privacy\"] = \"".$GED["privacy"]."\";\n";
		$gedcomtext .= "\$gedarray[\"title\"] = \"".addslashes($GED["title"])."\";\n";
		$gedcomtext .= "\$gedarray[\"path\"] = \"".addslashes($GED["path"])."\";\n";
		$gedcomtext .= "\$GEDCOMS[\"".$GED["gedcom"]."\"] = \$gedarray;\n";
	}
	$configtext = substr($configtext, 0, $pos1). $gedcomtext. substr($configtext, $pos2);
	if (!is_writable("config.php")) {
			print $pgv_lang["not_writable"]."<br />\n";
			$_SESSION["config.php"]=$configtext;
			print "<br /><br /><a href=\"config_download.php?file=config.php\">".$pgv_lang["download_here"]." config.php</a><br /><br />\n";
	}
	if (is_writable("config.php")) {
		$fp = fopen("config.php", "wb");
		if (!$fp) {
			print "<font class=error>".$pgv_lang["config_write_error"]."<br /></font>\n";
		}
		else {
			fwrite($fp, $configtext);
			fclose($fp);
		}
	}
}

// -- check if a person is dead
function is_dead($indirec) {
	global $CHECK_CHILD_DATES;
	global $MAX_ALIVE_AGE;
	global $HIDE_LIVE_PEOPLE;
	global $pgv_lang;
	global $BUILDING_INDEX;

		$ct = preg_match("/0 @(.*)@ INDI/", $indirec, $match);
		if ($ct>0) {
			$pid = trim($match[1]);
		}

	if (empty($pid)) return false;
	//-- if using indexes then first check the indi_isdead array
	if (!$BUILDING_INDEX) {
		return is_dead_id($pid);
	}
	// -- check for a death record
	if (strstr($indirec, "1 DEAT")) return true;

	// If no death record than check all dates; the oldest one is the DOB
	$cyear = date("Y");
	$ct = preg_match_all("/\d DATE.* (\d\d\d\d)/", $indirec, $match, PREG_SET_ORDER);
	for($i=0; $i<$ct; $i++) {
		$byear = $match[$i][1];
		// If any date is prior to than MAX_ALIVE_AGE years ago assume they are dead
		if (($cyear-$byear) > $MAX_ALIVE_AGE) {
			return true;
		}
	}

	// If we found no dates then check the years of the person's children.
	if($CHECK_CHILD_DATES ) {
		//-- check the parents for dates
		$numfams = preg_match_all("/1\s*FAMC\s*@(.*)@/", $indirec, $fmatch, PREG_SET_ORDER);
		for($j=0; $j<$numfams; $j++) {
			$parents = find_parents($fmatch[$j][1]);
			if ($parents) {
				if (!empty($parents["HUSB"])) {
					$prec = find_person_record($parents["HUSB"]);
					$ct = preg_match_all("/\d DATE.* (\d\d\d\d)/", $prec, $match, PREG_SET_ORDER);
					for($i=0; $i<$ct; $i++) {
						$byear = $match[$i][1];
						// If any date is prior to than MAX_ALIVE_AGE years ago assume they are dead
						if (($cyear-$byear) > $MAX_ALIVE_AGE+20) {
							return true;
						}
					}
				}
				if (!empty($parents["WIFE"])) {
					$prec = find_person_record($parents["WIFE"]);
					$ct = preg_match_all("/\d DATE.* (\d\d\d\d)/", $prec, $match, PREG_SET_ORDER);
					for($i=0; $i<$ct; $i++) {
						$byear = $match[$i][1];
						// If any date is prior to than MAX_ALIVE_AGE years ago assume they are dead
						if (($cyear-$byear) > $MAX_ALIVE_AGE+20) {
							return true;
						}
					}
				}
			}
		}
		$children = array();
		// For each family in which this person is a spouse...
		$numfams = preg_match_all("/1\s*FAMS\s*@(.*)@/", $indirec, $fmatch, PREG_SET_ORDER);
		for($j=0; $j<$numfams; $j++) {
			// Get the family record
			$famrec = find_family_record($fmatch[$j][1]);

			//-- check for marriage date
			$marrec = get_sub_record(1, "1 MARR", $famrec);
			if ($marrec!==false) {
				$bt = preg_match_all("/\d DATE .*(\d\d\d\d)/", $marrec, $bmatch, PREG_SET_ORDER);
				for($h=0; $h<$bt; $h++) {
					$byear = $bmatch[$h][1];
					// if marriage was more than MAX_ALIVE_AGE-10 years ago assume the person has died
					if (($cyear-$byear) > ($MAX_ALIVE_AGE-10)) {
						return true;
					}
				}
			}
			//-- check spouse record for dates
			$parents = find_parents_in_record($famrec);
			if ($parents) {
				if ($parents["HUSB"]!=$pid) $spid = $parents["HUSB"];
				else $spid = $parents["WIFE"];
				$spouserec = find_person_record($spid);
				// Check dates
				$bt = preg_match_all("/\d DATE .*(\d\d\d\d)/", $spouserec, $bmatch, PREG_SET_ORDER);
				for($h=0; $h<$bt; $h++) {
					$byear = $bmatch[$h][1];
					// if any child was born more than MAX_ALIVE_AGE-10 years ago assume the parent has died
					if (($cyear-$byear) > $MAX_ALIVE_AGE) {
						return true;
					}
				}
			}
			// Get the set of children
			$ct = preg_match_all("/1 CHIL @(.*)@/", $famrec, $match, PREG_SET_ORDER);
			for($i=0; $i<$ct; $i++) {
				// Get each child's record
				$childrec = find_person_record($match[$i][1]);
				$children[] = $childrec;

				// Check each child's dates
				$bt = preg_match_all("/\d DATE .*(\d\d\d\d)/", $childrec, $bmatch, PREG_SET_ORDER);
				for($h=0; $h<$bt; $h++) {
					$byear = $bmatch[$h][1];
					// if any child was born more than MAX_ALIVE_AGE-10 years ago assume the parent has died
					if (($cyear-$byear) > ($MAX_ALIVE_AGE-10)) {
						return true;
					}
				}
			}
		}
		//-- check grandchildren for dates
		foreach($children as $child) {
			// For each family in which this person is a spouse...
			$numfams = preg_match_all("/1\s*FAMS\s*@(.*)@/", $child, $fmatch, PREG_SET_ORDER);
			for($j=0; $j<$numfams; $j++) {
				// Get the family record
				$famrec = find_family_record($fmatch[$j][1]);

				// Get the set of children
				$ct = preg_match_all("/1 CHIL @(.*)@/", $famrec, $match, PREG_SET_ORDER);
				for($i=0; $i<$ct; $i++) {
					// Get each child's record
					$childrec = find_person_record($match[$i][1]);

					// Check each grandchild's dates
					$bt = preg_match_all("/\d DATE .*(\d\d\d\d)/", $childrec, $bmatch, PREG_SET_ORDER);
					for($h=0; $h<$bt; $h++) {
						$byear = $bmatch[$h][1];
						// if any grandchild was born more than MAX_ALIVE_AGE-30 years ago assume the grandparent has died
						if (($cyear-$byear) > ($MAX_ALIVE_AGE-30)) {
							return true;
						}
					}
				}
			}
		}
	}

	return false;
}

// -- find and return a given individuals surname
function get_person_surname($pid) {
	$fullname = get_sortable_name($pid);
	$name = preg_split("/,/", $fullname);
	return $name[0];
}

// -- find and return a given individuals name
function get_person_name($pid) {
	global $NAME_REVERSE;
	global $NAME_FROM_GEDCOM;

	//-- get the name from the gedcom record
	if ($NAME_FROM_GEDCOM) {
		$indirec = find_person_record($pid);
		if (!$indirec) $indirec = find_record_in_file($pid);
		$ct = preg_match("/2 SURN (.*)/", $indirec, $match);
		if ($ct>0) {
			$gt = preg_match("/2 GIVN (.*)/", $indirec, $gmatch);
			$st = preg_match("/2 NSFX (.*)/", $indirec, $smatch);
			$name = rtrim($match[1]);
			if ($st>0) $name.=" ".rtrim($smatch[1]);
			if ($gt>0) $name.=", ".rtrim($gmatch[1]);
		}
		else {
			$nt = preg_match("/1 NAME (.*)/", $indirec, $match);
			if ($nt>0) {
				$names = preg_split("/\//", $match[1]);
				if (count($names)>1) {
					$name = trim($names[1]).",";
					$name .= " ".trim($names[0]);
					if (count($names)>2) $name .= " ".trim($names[2]);
				}
				else $name=$match[1];

			}
			else $name = "Individual $pid";
		}
		$name = preg_replace("'\/'", "", $name);
		$name = strtr($name, "\\", "");
		return $name;
	}

	//-- get the name from the indexes
	$fullname = get_sortable_name($pid);
	if ($fullname===false) {
		$NAME_FROM_GEDCOM = true;
		$fullname = get_person_name($pid);
		$NAME_FROM_GEDCOM = false;
	}
	$names = preg_split("/,/", $fullname);
	if (count($names)>1) {
		if (!$NAME_REVERSE) $name = "$names[1] $names[0]";
		else $name = "$names[0] $names[1]";
	}
	else $name = $names[0];

	return $name;
}

//-- get a gedcom sub record
function get_sub_record($level, $tag, $gedrec) {
	$pos1 = strpos($gedrec, $tag);
	if ($pos1===false) return false;
	$pos2 = strpos($gedrec, "\n$level", $pos1+1);
	if (!$pos2) $pos2 = strlen($gedrec);
	$subrec = substr($gedrec, $pos1, $pos2-$pos1);
	return $subrec;
}

// -- find and return a two element array containing the parents of the given family record
function find_parents($famid) {
	global $pgv_lang;

	$famrec = find_family_record($famid);
	if (empty($famrec)) return false;
	$parents = array();
	$ct = preg_match("/1 HUSB @(.*)@/", $famrec, $match);
	if ($ct>0) $parents["HUSB"]=$match[1];
	else $parents["HUSB"]="";
	$ct = preg_match("/1 WIFE @(.*)@/", $famrec, $match);
	if ($ct>0) $parents["WIFE"]=$match[1];
	else $parents["WIFE"]="";
	return $parents;
}

// -- find and return a two element array containing the parents of the given family record
function find_parents_in_record($famrec) {
	global $pgv_lang;

	if (empty($famrec)) return false;
	$parents = array();
	$ct = preg_match("/1 HUSB @(.*)@/", $famrec, $match);
	if ($ct>0) $parents["HUSB"]=$match[1];
	else $parents["HUSB"]="";
	$ct = preg_match("/1 WIFE @(.*)@/", $famrec, $match);
	if ($ct>0) $parents["WIFE"]=$match[1];
	else $parents["WIFE"]="";
	return $parents;
}

// -- find and return the family id for which the given individual is a child
function find_family_id($pid) {
	$families = find_family_ids($pid);
	if (count($families)>0) return trim($families[0]);
	else return false;
}

// -- find and return multiple family id for which the given individual is a child
function find_family_ids($pid) {
	$families = array();
	if (!$pid) return $families;

	$indirec = find_person_record($pid);
	$ct = preg_match_all("/1\sFAMC\s@(.*)@/", $indirec, $match, PREG_SET_ORDER);
	for($i=0; $i<$ct; $i++) {
		$families[$i]=$match[$i][1];
	}
	return $families;
}

// -- find and return the family id for which the given individual is a spouse
function find_sfamily_id($pid) {
	if (empty($pid)) return false;
	$indirec = find_person_record($pid);
	$ct = preg_match("/1\s*FAMS\s*@(.*)@/", $indirec, $match);
	if ($ct>0) return $match[1];
	else return false;
}

// -- find and return all of the family ids for which the given individual is a spouse
function find_sfamily_ids($pid) {
	$families = array();
	if (empty($pid)) return $families;
	$indirec = find_person_record($pid);
	$ct = preg_match_all("/1\s*FAMS\s*@(.*)@/", $indirec, $match,PREG_SET_ORDER);

	if ($ct>0){
		for($i=0; $i<$ct; $i++) {
			$families[$i] = $match[$i][1];
		}
	}
	return $families;
}

// -- read the file into a big string
function read_gedcom_file() {
	global $fcontents;
	global $GEDCOM, $GEDCOMS;
	global $pgv_lang;
	$fcontents = "";
	if (isset($GEDCOMS[$GEDCOM])) {
		$fp = fopen($GEDCOMS[$GEDCOM]["path"], "r");
		$fcontents = fread($fp, filesize($GEDCOMS[$GEDCOM]["path"]));
		fclose($fp);
	}
}

function find_highlighted_object($pid, $indirec) {
	global $MEDIA_DIRECTORY;

	if (!showFactDetails("OBJE", $pid)) return false;

	$object = array();
	//-- find the first object reference
	$opos1 = strpos($indirec, "1 OBJE");
	while($opos1) {
		$opos2 = strpos($indirec, "\n1", $opos1+1);
		if ($opos2) $objerec = substr($indirec, $opos1, $opos2-$opos1);
		else $objerec = substr($indirec, $opos1);
		$ct = preg_match("/\d _PRIM (.*)/", $objerec, $match);
		if (($ct==0)||(trim($match[1])=="Y")) {
			$ct = preg_match("/\d OBJE @(.*)@/", $objerec, $match);
			if ($ct>0) {
				$objerec=find_gedcom_record($match[1]);
			}
			$ft = preg_match("/\d _*FILE (.*)/", $objerec, $amatch);
			if ($ft>0) {
				$fullpath = trim($amatch[1]);
				$filename = "";
				if ((!strstr( $fullpath, "://"))&&(!strstr( $fullpath, "mailto:"))) {
					$filename=extract_filename($fullpath);
					$thumbnail = $MEDIA_DIRECTORY."thumbs/".$filename;
					$thumbnail = trim($thumbnail);
					if ((preg_match("'://'", $MEDIA_DIRECTORY)==0)&&(!file_exists(filename_decode($thumbnail)))) $thumbnail="";
					$object["thumb"]=$thumbnail;
					$filename = $MEDIA_DIRECTORY.$filename;
					$filename = trim($filename);
					if ((preg_match("'://'", $MEDIA_DIRECTORY)==0)&&(!file_exists(filename_decode($filename)))) $filename="";
					$object["file"]=$filename;
				}
			}
			return $object;
		}
		$opos1 = strpos($indirec, "1 OBJE", $opos1+5);
	}
	return false;
}

// -- this will define a useful array function that is not available in older versions of php
if (phpversion() < '4.1') {
	  eval('function array_key_exists($key, $arr) {
	      		global $pgv_lang;
				if (!is_array($arr)) {
	                print "<font class=\"error\">".$pgv_lang["not_an_array"]."</font>";
				   return false;
				}
				foreach (array_keys($arr) as $k) {
				   if ($k == $key) {
					  return true;
				   }
				}
				return false;
			 }');
   }

 //-- Compare facts function is used by the usort PHP function to sort fact baseds on date
 //-- it parses out the year and if the year is the same, it creates a timestamp based on
 //-- the current year and the month and day information of the fact
function compare_facts($a, $b) {
	$adate=0;
	$bdate=0;

	$cta = preg_match("/2 DATE (.*)/", $a[1], $match);
	if ($cta>0) $adate = trim($match[1]);
	$ctb = preg_match("/2 DATE (.*)/", $b[1], $match);
	if ($ctb>0) $bdate = trim($match[1]);

	//-- check if both had a date
	if($cta<$ctb) return 1;
	if($cta>$ctb) return -1;
	if(($cta==0)&&($ctb==0)) return 0;
	$afields = preg_split("/[\s\.]/", $adate);
	$yeara = $afields[count($afields)-1];
	$bfields = preg_split("/[\s\.]/", $bdate);
	$yearb = $bfields[count($bfields)-1];

	if ($yeara==$yearb) {
		$newa="";
		for($i=0; $i<count($afields)-1; $i++) {
			$newa.=$afields[$i]." ";
		}
		$newa.=date("Y");
		$newb="";
		for($i=0; $i<count($bfields)-1; $i++) {
			$newb.=$bfields[$i]." ";
		}
		$newb.=date("Y");

		$astamp = strtotime($newa);
		$bstamp = strtotime($newb);
		if ($astamp==$bstamp)	return 0;
		else return ($astamp < $bstamp) ? -1 : 1;
	}
	return ($yeara < $yearb) ? -1 : 1;
}

function get_cont($nlevel, $nrec) {
	global $WORD_WRAPPED_NOTES;
	$text = "";
	$tt = preg_match_all("/$nlevel CON[CT](.*)/", $nrec, $cmatch, PREG_SET_ORDER);
	for($i=0; $i<$tt; $i++) {
		if (strstr($cmatch[$i][0], "CONT")) $text.="<br />\n";
		else if ($WORD_WRAPPED_NOTES) $text.=" ";
		$conctxt = ltrim($cmatch[$i][1]);
		$conctxt = preg_replace("/[\r\n]/","",$conctxt);
		$conctxt = preg_replace("'(http://.*\s)'","<a href=\"$1\">$1</a>", $conctxt);
		$text.=$conctxt;
	}
	$text = preg_replace("/~~/", "<br />", $text);
	return $text;
}

//-- get the file path from a multimedia gedcom record
function extract_fullpath($mediarec) {
	preg_match("/(\d) _*FILE (.*)/", $mediarec, $amatch);
	$level = trim($amatch[1]);
	$fullpath = trim($amatch[2]);
	$filerec = get_sub_record($level, $amatch[0], $mediarec);
	$fullpath .= get_cont($level+1, $filerec);
	return $fullpath;
}

//-- get the desired filename from the full file path
function extract_filename($fullpath) {
	global $MEDIA_DIRECTORY_LEVELS;
	$filename="";
	$regexp = "'[/\\\]'";
	$ct = preg_match($regexp, $fullpath, $match);
	if ($ct>0) {
		$subelements = preg_split($regexp, $fullpath);
		$subelements = array_reverse($subelements);
		if ($MEDIA_DIRECTORY_LEVELS>=count($subelements)) $MEDIA_DIRECTORY_LEVELS=count($subelements);
		for($s=$MEDIA_DIRECTORY_LEVELS; $s>=0; $s--) {
			if ($s!=$MEDIA_DIRECTORY_LEVELS) $filename = $filename."/".$subelements[$s];
			else $filename = $subelements[$s];
		}
	}
	else $filename = $fullpath;
	//print "$filename<br />\n";
	return $filename;
}

//-- functions to take a Jewish date and display it in Hebrew.
//-- provided by: KosherJava

function getFullHebrewJewishDates($year, $month="", $day="", $altYear="", $altMonth="") {
	global $DISPLAY_JEWISH_GERESHAYIM, $TEXT_DIRECTION;
	$USE_FULL_PARTIAL_JEWISH_DATES = true;
	$sb = "<span lang=\"he-IL\" dir=\"rtl\">";
	if($day != "") {
		$sb .= getHebrewJewishDay($day);
		$sb .= "&#160;";
	}
	if($month != "") {
		if($day != "") { //jewish date is exact
			$sb .= getHebrewJewishMonth($month, $year);
			$sb .= "&#160;";
		} else { //only month and not day
			$sb .= getHebrewJewishMonth($month, $year);
			if($USE_FULL_PARTIAL_JEWISH_DATES) {
				if($altMonth != "" && $altMonth != $month) {
					$sb .= " / ";
					$sb .= getHebrewJewishMonth($altMonth, $altYear);
					//$sb .= getHebrewJewishMonth($altMonth, $year);
				}
			}
			$sb .= "&#160;";
		}
	}
	if($USE_FULL_PARTIAL_JEWISH_DATES) {
		if($month=="") {
			$sb .= getHebrewJewishYear($year - 1);
			$sb .= " / ";
			$sb .= getHebrewJewishYear($year);
		} else if($altMonth!=0 && $month != $altMonth && $altYear !=0 && $altYear != $year ) {
			$sb .= getHebrewJewishYear($year);
			$sb .= " / ";
			$sb .= getHebrewJewishYear($altYear);
		} else {
			$sb .= getHebrewJewishYear($year);
		}
	} else {
		$sb .= getHebrewJewishYear($year);
	}

	$sb .= "</span>";
	if($TEXT_DIRECTION == "ltr") { //only do this for ltr languages
		$sb.= "&lrm;"; //add entity to return to left to right direction
	}
	if($DISPLAY_JEWISH_GERESHAYIM == false) {
		$sb = preg_replace(array("/&quot;/", "/'/"), array("",""), $sb);
	}
	return $sb;
}

function getHebrewJewishDates($year, $month="", $day="", $altYear="", $altMonth="") {
	global $DISPLAY_JEWISH_GERESHAYIM, $TEXT_DIRECTION;
	$sb = "<span lang=\"he-IL\" dir=\"rtl\">";
	if($day != "") {
		$sb .= getHebrewJewishDay($day);
		$sb .= "&#160;";
	}
	if($month != "") {
		if($day != "") { //jewish date is exact
			$sb .= getHebrewJewishMonth($month, $year);
			$sb .= "&#160;";
		} else { //only month and not day
			$sb .= getHebrewJewishMonth($month, $year); //FIXME Since month is based on 1st of the Gregorian date,
			$sb .= "&#160;";							//		Would be nice to return both months.
		}
	}
	$sb .= getHebrewJewishYear($year);
	$sb .= "</span>";
	if($TEXT_DIRECTION == "ltr") { //only do this for ltr languages
		$sb.= "&lrm;"; //add entity to return to left to right direction
	}

	if($DISPLAY_JEWISH_GERESHAYIM == false) {
		$sb = preg_replace(array("/&quot;/", "/'/"), array("",""), $sb);
	}
	return $sb;
}

function getHebrewJewishYear($year) {
	global $DISPLAY_JEWISH_THOUSANDS;

	$jAlafim = "&#1488;&#1500;&#1508;&#1497;&#1501;"; //word ALAFIM in Hebrew for display on years evenly divisable by 1000
	$jHundreds = array("", "&#1511;", "&#1512;", "&#1513;", "&#1514;", "&#1514;&#1511;", "&#1514;&#1512;","&#1514;&#1513;", "&#1514;&#1514;", "&#1514;&#1514;&#1511;");
	$jTens = array("", "&#1497;", "&#1499;", "&#1500;", "&#1502;", "&#1504;", "&#1505;", "&#1506;", "&#1508;", "&#1510;");
	$jTenEnds = array("", "&#1497;", "&#1498;", "&#1500;", "&#1501;", "&#1503;", "&#1505;", "&#1506;", "&#1507;", "&#1509;");
	$tavTaz = array("&#1496;&quot;&#1493;", "&#1496;&quot;&#1494;");
	$jOnes = array("", "&#1488;", "&#1489;", "&#1490;", "&#1491;", "&#1492;", "&#1493;", "&#1494;", "&#1495;", "&#1496;");

	$singleDigitYear = isSingleDigitJeiwshYear($year);
	$thousands = $year / 1000; //get # thousands

	$sb = "";
	//append thousands to String
	if($year % 1000 == 0) { // in year is 5000, 4000 etc
		$sb .= $jOnes[$thousands];
		$sb .= "'";
		$sb .= "&#160;";
		$sb .= $jAlafim; //add # of thousands plus word thousand (overide alafim boolean)
	} else if($DISPLAY_JEWISH_THOUSANDS) { // if alafim boolean display thousands
		$sb .= $jOnes[$thousands];
		$sb .= "'"; //append thousands quote
		$sb .= "&#160;";
	}
	$year = $year % 1000;//remove 1000s
	$hundreds = $year / 100; // # of hundreds
	$sb .= $jHundreds[$hundreds]; //add hundreds to String
	$year = $year % 100; //remove 100s
	if($year == 15) { //special case 15
		$sb .= $tavTaz[0];
	} else if($year == 16) { //special case 16
		$sb .= $tavTaz[1];
	} else {
		$tens = $year / 10;
		if($year % 10 == 0) { // if evenly divisable by 10
			if($singleDigitYear == false) {
				$sb .= $jTenEnds[$tens]; // use end letters so that for example 5750 will end with an end nun
			} else {
				$sb .= $jTens[$tens]; // use standard letters so that for example 5050 will end with a regular nun
			}
		} else {
			$sb .= $jTens[$tens];
			$year = $year % 10;
			$sb .= $jOnes[$year];
		}
	}
	if($singleDigitYear == true) {
		$sb .= "'"; //append single quote
	} else { // append double quote before last digit
		$pos1 = strrpos($sb, "&");
		$sb = substr($sb, 0, $pos1) . "&quot;" . substr($sb, $pos1);
	}
	return $sb;
}

function getHebrewJewishMonth($month, $year) {
	$jMonths = array("&#1514;&#1513;&#1512;&#1497;",
			"&#1495;&#1513;&#1493;&#1503;",
			"&#1499;&#1505;&#1500;&#1493;",
			"&#1496;&#1489;&#1514;",
			"&#1513;&#1489;&#1496;",
			"&#1488;&#1491;&#1512; &#1488;'",
			"&#1488;&#1491;&#1512; &#1489;'",
			"&#1504;&#1497;&#1505;&#1503;",
			"&#1488;&#1497;&#1497;&#1512;",
			"&#1505;&#1497;&#1493;&#1503;",
			"&#1514;&#1502;&#1493;&#1494;",
			"&#1488;&#1489;",
			"&#1488;&#1500;&#1493;&#1500;",
			"&#1488;&#1491;&#1512;"); //last 1 is Adar for non leap year

	if (empty($month)) return "";
	if($month == 6) { // if Adar check for leap year
		if(isJewishLeapYear($year)) {
			return $jMonths[5]; //if it is leap year return default php "Adar A"
		} else { // non leap year
			return $jMonths[13];
		}
	} else { // non Adar months
		return $jMonths[$month - 1];
	}
}

function getHebrewJewishDay($day) {
	$jTens = array("", "&#1497;", "&#1499;", "&#1500;", "&#1502;", "&#1504;", "&#1505;", "&#1506;", "&#1508;", "&#1510;");
	$jTenEnds = array("", "&#1497;", "&#1498;", "&#1500;", "&#1501;", "&#1503;", "&#1505;", "&#1506;", "&#1507;", "&#1509;");
	$tavTaz = array("&#1496;&quot;&#1493;", "&#1496;&quot;&#1494;");
	$jOnes = array("", "&#1488;", "&#1489;", "&#1490;", "&#1491;", "&#1492;", "&#1493;", "&#1494;", "&#1495;", "&#1496;");

	if (empty($day)) return "";
	$sb = "";
	if($day < 10) { //single digit days get single quote appended
		$sb .= $jOnes[$day];
		$sb .= "'";
	} else if($day == 15) { //special case 15
		$sb .= $tavTaz[0];
	} else if($day == 16) { //special case 16
		$sb .= $tavTaz[1];
	} else {
		$tens = $day / 10;
		$sb .= $jTens[$tens];
		if($day % 10 == 0) { // 10 or 20 single digit append single quote
			$sb .= "'";
		} else if($day > 10) { // >10 display " between 10s and 1s
			$sb .= "&quot;";
		}
		$day = $day % 10; //discard 10s
		$sb .= $jOnes[$day];
	}
	return $sb;
}

function isJewishLeapYear($year) {
	if($year % 19 == 0 || $year % 19 == 3 || $year % 19 ==6 || $year % 19 == 8 || $year % 19 == 11
			|| $year % 19 == 14 || $year % 19 == 17) { // 3rd, 6th, 8th, 11th, 14th, 17th or 19th years of 19 year cycle
		return true;
	} else { // non leap year
		return false;
	}
}

function isSingleDigitJeiwshYear($year) {
	$shortYear = $year %1000; //discard thousands
	//next check for all possible single Hebrew digit years
	if($shortYear < 11 || ($shortYear <100 && $shortYear % 10 == 0)  || ($shortYear <= 400 && $shortYear % 100 == 0) ) {
		return true;
	} else {
		return false;
	}
}

function getJewishMonthName($month, $year) {
	global $JEWISH_ASHKENAZ_PRONUNCIATION;
	$ashkenazMonths = array("Tishrei", "Cheshvan", "Kislev", "Teves", "Shevat", "Adar I", "Adar II", "Nisan", "Iyar", "Sivan", "Tamuz", "Av", "Elul", "Adar");
	$sefardMonths = array("Tishrei", "Heshvan", "Kislev", "Tevet", "Shevat", "Adar I", "Adar II", "Nisan", "Iyar", "Sivan", "Tamuz", "Av", "Elul", "Adar");
	$monthNames = $ashkenazMonths;
	if($JEWISH_ASHKENAZ_PRONUNCIATION != true) {
		$monthNames = $sefardMonths;
	}
	if($month == 6) { // if Adar check for leap year
		if(isJewishLeapYear($year)) {
			return $monthNames[5];
		} else {
			return $monthNames[13];
		}
	} else {
		return $monthNames[$month - 1];
	}

}

function convert_date($dstr_beg, $dstr_end, $day, $month, $year) {
	global $pgv_lang, $DATE_FORMAT, $LANGUAGE, $CALENDAR_FORMAT, $monthtonum;

	$altDay="";
	$month = trim($month);
	$day = trim($day);
	$skipday = false;
	$skipmonth = false;
	if (empty($month)||!isset($monthtonum[strtolower($month)])) {
		$dstr_beg .= " ".$month." ";
		$month = "jan";
		$skipmonth=true;
	}
	if (empty($day)) {
		$day = 1;
		if ((!empty($month))&&(isset($monthtonum[$month]))){
			if (function_exists("cal_days_in_month")) $altDay = cal_days_in_month(CAL_GREGORIAN, $monthtonum[$month], $year);
			else $altDay = 30;
		}
		$skipday = true;
	}

	if ($CALENDAR_FORMAT=="jewish" && $LANGUAGE != "hebrew") {
		$month = $monthtonum[$month];
		$jd = gregoriantojd($month, $day, $year);
		$hebrewDate = jdtojewish($jd);
		list ($hebrewMonth, $hebrewDay, $hebrewYear) = split ('/', $hebrewDate);

		$altJd = gregoriantojd($month, $altDay, $year);
		$altHebrewDate = jdtojewish($altJd);
		list ($altHebrewMonth, $altHebrewDay, $altHebrewYear) = split ('/', $altHebrewDate);

		$hebrewMonthName = getJewishMonthName($hebrewMonth, $hebrewYear);
		if($skipday && !$skipmonth && $altHebrewMonth !=0 && $altHebrewYear !=0 && $hebrewMonth != $altHebrewMonth && $hebrewYear != $altHebrewYear) { //elul tishrai
			$hebrewMonthName .= " ";
			$hebrewMonthName .= $hebrewYear;
			$hebrewYear = " / ";
			$hebrewYear .= getJewishMonthName($altHebrewMonth, $altHebrewYear);
			$hebrewYear .= " ";
			$hebrewYear .= $altHebrewYear;
		} else if($skipday && !$skipmonth && $altHebrewMonth !=0 && $hebrewMonth != $altHebrewMonth) {
			$hebrewMonthName .= " / ";
			$hebrewMonthName .= getJewishMonthName($altHebrewMonth, $altHebrewYear);
		} else if($altHebrewYear !=0 && $hebrewYear != $altHebrewYear) {
			$hebrewYear .= " / ";
			$hebrewYear .= $altHebrewYear;
		}

		if ($skipday) $hebrewDay = "";
		if ($skipmonth) $hebrewMonthName = "";
		$newdate = preg_replace("/D/", $hebrewDay, $DATE_FORMAT);
		$newdate = preg_replace("/M/", $hebrewMonthName, $newdate);
		$newdate = preg_replace("/Y/", $hebrewYear, $newdate);
		$datestr = $dstr_beg . $newdate . $dstr_end;
	}
	else if ($CALENDAR_FORMAT=="jewish_and_gregorian" && $LANGUAGE != "hebrew") {
		$monthnum = $monthtonum[$month];
		$jd = gregoriantojd($monthnum, $day, $year);
		$hebrewDate = jdtojewish($jd);
		list ($hebrewMonth, $hebrewDay, $hebrewYear) = split ('/', $hebrewDate);

		$altJd = gregoriantojd($monthnum, $altDay, $year);
		$altHebrewDate = jdtojewish($altJd);
		list ($altHebrewMonth, $altHebrewDay, $altHebrewYear) = split ('/', $altHebrewDate);

		$hebrewMonthName = getJewishMonthName($hebrewMonth, $hebrewYear);

		if($skipday && !$skipmonth && $altHebrewMonth !=0 && $altHebrewYear !=0 && $hebrewMonth != $altHebrewMonth && $hebrewYear != $altHebrewYear) { //elul tishrai
			$hebrewMonthName .= " ";
			$hebrewMonthName .= $hebrewYear;
			$hebrewYear = " / ";
			$hebrewYear .= getJewishMonthName($altHebrewMonth, $altHebrewYear);
			$hebrewYear .= " ";
			$hebrewYear .= $altHebrewYear;
		} else if($skipday && !$skipmonth && $altHebrewMonth !=0 && $hebrewMonth != $altHebrewMonth) {
			$hebrewMonthName .= " / ";
			$hebrewMonthName .= getJewishMonthName($altHebrewMonth, $altHebrewYear);
		} else if($altHebrewYear !=0 && $hebrewYear != $altHebrewYear) {
			$hebrewYear .= " / ";
			$hebrewYear .= $altHebrewYear;
		}

		if ($skipday) $hebrewDay = "";
		if ($skipmonth) $hebrewMonthName = "";
		$newdate = preg_replace("/D/", $hebrewDay, $DATE_FORMAT);
		$newdate = preg_replace("/M/", $hebrewMonthName, $newdate);
		$newdate = preg_replace("/Y/", $hebrewYear, $newdate);
		if ($skipday) $day = "";
		if ($skipmonth) $month = "";
		$gdate = preg_replace("/D/", $day, $DATE_FORMAT);
		$gdate = preg_replace("/M/", $month, $gdate);
		$gdate = preg_replace("/Y/", $year, $gdate);
		$gdate = trim($gdate);
		$datestr = $dstr_beg . $newdate . " ($gdate)" . $dstr_end;
	}
	else if ($CALENDAR_FORMAT=="hebrew" || $CALENDAR_FORMAT=="jewish" && $LANGUAGE == "hebrew") {
		$month = $monthtonum[$month];
		$jd = gregoriantojd($month, $day, $year);
		$hebrewDate = jdtojewish($jd);
		list ($hebrewMonth, $hebrewDay, $hebrewYear) = split ('/', $hebrewDate);

		$altJd = gregoriantojd($month, $altDay, $year);
		$altHebrewDate = jdtojewish($altJd);
		list ($altHebrewMonth, $altHebrewDay, $altHebrewYear) = split ('/', $altHebrewDate);

		if ($skipday) $hebrewDay = "";
		if ($skipmonth) $hebrewMonth = "";
		//$newdate = getHebrewJewishDates($hebrewYear, $hebrewMonth, $hebrewDay);
		$newdate = getFullHebrewJewishDates($hebrewYear, $hebrewMonth, $hebrewDay, $altHebrewYear, $altHebrewMonth);
		$datestr = $dstr_beg . $newdate . $dstr_end;
	}
	else if ($CALENDAR_FORMAT=="hebrew_and_gregorian" || $CALENDAR_FORMAT=="jewish_and_gregorian" && $LANGUAGE == "hebrew") {
		$monthnum = $monthtonum[$month];
		$jd = gregoriantojd($monthnum, $day, $year);
		$hebrewDate = jdtojewish($jd);
		list ($hebrewMonth, $hebrewDay, $hebrewYear) = split ('/', $hebrewDate);

		$altJd = gregoriantojd($monthnum, $altDay, $year);
		$altHebrewDate = jdtojewish($altJd);
		list ($altHebrewMonth, $altHebrewDay, $altHebrewYear) = split ('/', $altHebrewDate);

		if ($skipday) $hebrewDay = "";
		if ($skipmonth) $hebrewMonth = "";
		//$newdate = getHebrewJewishDates($hebrewYear, $hebrewMonth, $hebrewDay);
		$newdate = getFullHebrewJewishDates($hebrewYear, $hebrewMonth, $hebrewDay, $altHebrewYear, $altHebrewMonth);
		if ($skipday) $day = "";
		if ($skipmonth) $month = "";
		$gdate = preg_replace("/D/", $day, $DATE_FORMAT);
		$gdate = preg_replace("/M/", $month, $gdate);
		$gdate = preg_replace("/Y/", $year, $gdate);
		$gdate = trim($gdate);
		$datestr = $dstr_beg  . " ". $newdate . " ($gdate) ". $dstr_end;
	}
	else if ($CALENDAR_FORMAT=="julian") {
		$monthnum = $monthtonum[$month];
		$jd = gregoriantojd($monthnum, $day, $year);
		$jDate = jdtpjulian($jd);
		list ($jMonth, $jDay, $jYear) = split ('/', $jDate);
		$jMonthName = jdmonthname ( $jd, 3);
		if ($skipday) $jDay = "";
		if ($skipmonth) $jMonthName = "";
		$newdate = preg_replace("/D/", $jDay, $DATE_FORMAT);
		$newdate = preg_replace("/M/", $jMonthName, $newdate);
		$newdate = preg_replace("/Y/", $jYear, $newdate);
		$datestr = $dstr_beg . $newdate . $dstr_end;
	}
	else if ($CALENDAR_FORMAT=="french") {
		$monthnum = $monthtonum[$month];
		$jd = gregoriantojd($monthnum, $day, $year);
		$frenchDate = jdtofrench($jd);
		list ($fMonth, $fDay, $fYear) = split ('/', $frenchDate);
		$fMonthName = jdmonthname ( $jd, 5);
		if ($skipday) $fDay = "";
		if ($skipmonth) $fMonthName = "";
		$newdate = preg_replace("/D/", $fDay, $DATE_FORMAT);
		$newdate = preg_replace("/M/", $fMonthName, $newdate);
		$newdate = preg_replace("/Y/", $fYear, $newdate);
		$datestr = $dstr_beg . $newdate . $dstr_end;
	}
	else {
		$temp_format = $DATE_FORMAT;
		if ($skipday) {
			$day = "";
			$temp_format = substr($temp_format, strpos($temp_format, "M"));
		}
		if ($skipmonth) {
			$month = "";
			$temp_format = substr($temp_format, strpos($temp_format, "Y"));
		}
		$newdate = $temp_format;
		if ($LANGUAGE=="chinese") {
			$day = convert_number($day);
			$yearStr = "".$year;
			print $yearStr;
			$year="";
			for($i=0; $i<strlen($yearStr); $i++) {
				$year .= convert_number($yearStr{$i});	
			}
		}
		$newdate = preg_replace("/D/", $day, $newdate);
		$newdate = preg_replace("/M/", $month, $newdate);
		$newdate = preg_replace("/Y/", $year, $newdate);
		$datestr = $dstr_beg . $newdate . $dstr_end;
	}
	return $datestr;
}

//-- end of Jewish date functions

//-- functions to take a date and display it in Turkish.
//-- provided by: KurtNorgaz
function getTurkishDate($datestr)
{
	global $pgv_lang;

	$array_short = array("jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "est");
	foreach($array_short as $value)
	{
	  $datestr = preg_replace("/$value([^a-zA-Z])/i", $pgv_lang[$value] . "\$1", $datestr);
	}

	$array_short = array("abt", "aft", "and", "bef", "bet", "cal", "from", "int", "to", "cir");
	# $datestr = str_replace("bef 1962", "bef 1000", $datestr); # <---------------------------------- delete

	foreach($array_short as $value)
	{
	  $oldDateStr = $datestr;
	  $newdatestr = preg_replace("/$value([^a-zA-Z])/i", "" . "\$1", $datestr);

	  if ($newdatestr != $datestr)
	  {
	    $pos_of_value = strpos(" " . $datestr, $value);
	    $datestr = $newdatestr;

	    # print "-".$pos_of_value."-<br>";
	    # print "-".$datestr."-<br>";
	    # print "-".$value ."-";
	    # exit;

	    switch ($value)
	    {
	      case "from"	: $datestr = trim($datestr);
	      			  $pos_of_to = strpos(" " . $datestr, "to");
	      			  $datestr_01 = trim(substr($datestr, 0, $pos_of_to - 1));
	      			  $datestr_02 = substr($datestr, $pos_of_to - 2);

	      			  if (strlen($datestr_01) > 0)
	      			  {
	      			    $last_char = $datestr[strlen($datestr_01)-1];
	      			  }
	      			  else $last_char = "";
	      			  switch ($last_char)
	      			  {
	      			    case "0" : if (strlen($datestr_01) > 1)
	      			    	       {
	      			    	       	 $last_two_char = substr($datestr_01,-2);
	      			    	       }
	      			    	       else $last_two_char = "";
	      			    	       switch ($last_two_char)
	      			    	       {
	      			                 case "00" : $extension = "den"; break;
	      			                 case "20" : $extension = "den"; break;
	      			                 case "50" : $extension = "den"; break;
	      			                 case "70" : $extension = "den"; break;
	      			                 case "80" : $extension = "den"; break;
	      			                 default   : $extension = "dan"; break;
	      			               }
	      			               break;
	      			    case "6" : $extension = "dan"; break;
	      			    case "9" : $extension = "dan"; break;
	      			    default  : $extension = "den"; break;
	      			  }
	      			  $datestr_01 .= stripslashes($pgv_lang[$value]);
	      			  $datestr_01 = str_replace("#EXT#", $extension, $datestr_01);

	      			  $datestr = $datestr_01 . $datestr_02;
	      			  break;

	      case "to"		: $datestr = trim($datestr);
	      			  if (strlen($datestr) > 0)
	      			  {
	      			    $last_char = $datestr[strlen($datestr)-1];
	      			  }
	      			  else $last_char = "";
	      			  switch ($last_char)
	      			  {
	      			    case "0" : $extension = "a"; break;
	      			    case "9" : $extension = "a"; break;
	      			    case "2" : $extension = "ye"; break;
	      			    case "7" : $extension = "ye"; break;
	      			    case "6" : $extension = "ya"; break;
	      			    default  : $extension = "e"; break;
	      			  }
	      			  $datestr .= stripslashes($pgv_lang[$value]);
	      			  $datestr = str_replace("#EXT#", $extension, $datestr);
	      			  break;

	      case "bef"	: $datestr = trim($datestr);
	      			  if (strlen($datestr) > 0)
	      			  {
	      			    $last_char = $datestr[strlen($datestr)-1];
	      			  }
	      			  else $last_char = "";
	      			  switch ($last_char)
	      			  {
	      			    case "0" : if (strlen($datestr) > 1)
	      			    	       {
	      			    	       	 $last_two_char = substr($datestr,-2);
	      			    	       }
	      			    	       else $last_two_char = "";
	      			    	       switch ($last_two_char)
	      			    	       {
	      			                 case "00" : $extension = "den"; break;
	      			                 case "20" : $extension = "den"; break;
	      			                 case "50" : $extension = "den"; break;
	      			                 case "70" : $extension = "den"; break;
	      			                 case "80" : $extension = "den"; break;
	      			                 default   : $extension = "dan"; break;
	      			               }
	      			               break;
	      			    case "6" : $extension = "dan"; break;
	      			    case "9" : $extension = "dan"; break;
	      			    default  : $extension = "den"; break;
	      			  }
	      			  $datestr .= stripslashes($pgv_lang[$value]);
	      			  $datestr = str_replace("#EXT#", $extension, $datestr);
	      			  break;

	      case "cir"	: $datestr .= stripslashes($pgv_lang[$value]);
	      			  break;

	      default		: $datestr = $oldDateStr;
	      			  break;
	    }
	  }
	  # $datestr = preg_replace("/$value([^a-zA-Z])/i", $pgv_lang[$value] . "\$1", $datestr);
	}

	return $datestr;
}

//-- end of Turkish date functions

//-- function to print a more complete date
function get_changed_date($datestr) {
	global $pgv_lang, $DATE_FORMAT, $LANGUAGE, $CALENDAR_FORMAT, $monthtonum;

	//-- check for DAY MONTH YEAR dates
	$ct = preg_match_all("/(\d{1,2})?\s?([a-zA-Z]{3})?\s?(\d{4})/", $datestr, $match, PREG_SET_ORDER);
	for($i=0; $i<$ct; $i++) {
		$day = $match[$i][1];
		$month = strtolower($match[$i][2]);
		$year = $match[$i][3];
		$pos1 = strpos($datestr, $match[$i][0]);
		$pos2 = $pos1 + strlen($match[$i][0]);
		$dstr_beg = substr($datestr, 0, $pos1);
		$dstr_end = substr($datestr, $pos2);
		$datestr = convert_date($dstr_beg, $dstr_end, $day, $month, $year);
	}

	if ($LANGUAGE == "turkish")
	{
	  $datestr = getTurkishDate($datestr);
	}
	else
	{
	  $array_short = array("jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec", "abt", "aft", "and", "bef", "bet", "cal", "est", "from", "int", "to", "cir");
	  foreach($array_short as $value)
	  {
	    $datestr = preg_replace("/(^|\W)$value([^a-zA-Z])/i", "\$1".$pgv_lang[$value]."\$2", $datestr);
	  }
	}

	return $datestr;
}

//-- function to calculate the relationship between two people
//-- $pid1 = the first person to compute the relationship from
//-- $pid2 = the second person to compute the relatiohip to
//-- $followspouse = whether to add spouses to the path
//-- $maxlenght = the maximim length of path
//-- $ignore_cache = enable or disable the relationship cache
//-- $path_to_find = which path in the relationship to find, 0 is the shortest path, 1 is the next shortest path, etc
function get_relationship($pid1, $pid2, $followspouse=true, $maxlength=0, $ignore_cache=false, $path_to_find=0) {
	global $TIME_LIMIT, $start_time, $pgv_lang, $NODE_CACHE, $USE_RELATIONSHIP_PRIVACY;

	$pid1 = strtoupper($pid1);
	$pid2 = strtoupper($pid2);
	//print "\n<!-- ";
	$indirec = find_person_record($pid2);
	//-- check the cache
	if ($USE_RELATIONSHIP_PRIVACY && !$ignore_cache) {
		if(isset($NODE_CACHE["$pid1-$pid2"])) {
			if (($maxlength==0)||(count($NODE_CACHE["$pid1-$pid2"]["path"])<=$maxlength)) return $NODE_CACHE["$pid1-$pid2"];
		}
		//-- check the cache for person2s children
		$famids = array();
		$ct = preg_match_all("/1\sFAMS\s@(.*)@/", $indirec, $match, PREG_SET_ORDER);
		for($i=0; $i<$ct; $i++) {
			$famids[$i]=$match[$i][1];
		}
		foreach($famids as $fam) {
			$famrec = find_family_record($fam);
			$ct = preg_match_all("/1 CHIL @(.*)@/", $famrec, $match, PREG_SET_ORDER);
			for($i=0; $i<$ct; $i++) {
				$child = $match[$i][1];
				if (!empty($child)){
					if(isset($NODE_CACHE["$pid1-$child"])) {
						if (($maxlength==0)||(count($NODE_CACHE["$pid1-$child"]["path"])+1<=$maxlength)) {
							$node1 = $NODE_CACHE["$pid1-$child"];
							$node1["path"][] = $pid2;
							$node1["pid"] = $pid2;
							$ct = preg_match("/1 SEX F/", $indirec, $match);
							if ($ct>0) $node1["relations"][] = "mother";
							else $node1["relations"][] = "father";
							$NODE_CACHE["$pid1-$pid2"] = $node1;
							return $node1;
						}
					}
				}
			}
		}
	}
	//-- end cache checking

	//-- get the birth year of p2 for calculating heuristics
	$birthrec = get_sub_record(1, "1 BIRT", $indirec);
	$byear2 = -1;
	if ($birthrec!==false) {
		$dct = preg_match("/2 DATE .*(\d\d\d\d)/", $birthrec, $match);
		if ($dct>0) $byear2 = $match[1];
	}
	if ($byear2==-1) {
		$numfams = preg_match_all("/1\s*FAMS\s*@(.*)@/", $indirec, $fmatch, PREG_SET_ORDER);
		for($j=0; $j<$numfams; $j++) {
			// Get the family record
			$famrec = find_family_record($fmatch[$j][1]);

			// Get the set of children
			$ct = preg_match_all("/1 CHIL @(.*)@/", $famrec, $cmatch, PREG_SET_ORDER);
			for($i=0; $i<$ct; $i++) {
				// Get each child's record
				$childrec = find_person_record($cmatch[$i][1]);
				$birthrec = get_sub_record(1, "1 BIRT", $childrec);
				if ($birthrec!==false) {
					$dct = preg_match("/2 DATE .*(\d\d\d\d)/", $birthrec, $bmatch);
					if ($dct>0) $byear2 = $bmatch[1]-25;
				}
			}
		}
	}
	//-- end of approximating birth year

	//-- current path nodes
	$p1nodes = array();
	//-- ids visited
	$visited = array();

	//-- set up first node for person1
	$node1 = array();
	$node1["path"] = array();
	$node1["path"][] = $pid1;
	$node1["length"] = 0;
	$node1["pid"] = $pid1;
	$node1["relations"] = array();
	$node1["relations"][] = "self";
	$p1nodes[] = $node1;

	$visited[$pid1] = true;

	$found = false;
	$count=0;
	while(!$found) {
		//-- the following 2 lines ensure that the user can abort a long relationship calculation
		//-- refer to http://www.php.net/manual/en/features.connection-handling.php for more
		//-- information about why these lines are included
		if (headers_sent()) {
			print " ";
			if ($count%100 == 0) flush();
		}
		$count++;
		//if ($count>1000) return false;
		$end_time = getmicrotime();
		$exectime = $end_time - $start_time;
		if ($exectime > $TIME_LIMIT-1) {
			print "<font class=\"error\">".$pgv_lang["timeout_error"]."</font>\n";
			//print_r($p1nodes);
			return false;
		}
		if (count($p1nodes)==0) return false;
		$shortest = -1;
		foreach($p1nodes as $index=>$node) {
			if ($shortest == -1) $shortest = $index;
			else {
				$node1 = $p1nodes[$shortest];
				if ($node1["length"] > $node["length"]) $shortest = $index;
			}
		}
		$node = $p1nodes[$shortest];
		if ($USE_RELATIONSHIP_PRIVACY) {
			$NODE_CACHE["$pid1-".$node["pid"]] = $node;
		}
		if (($maxlength==0)||(count($node["path"])<=$maxlength)) {
			//print "\n<br />Checking node ".$node["pid"];
			//print_r($node);
			if ($node["pid"]==$pid2) {
				//if ($path_to_find>0) $path_to_find--;
				//else $found=true;
			}
			else {
				//-- hueristic values
				$fatherh = 1;
				$motherh = 1;
				$siblingh = 2;
				$spouseh = 2;
				$childh = 3;

				//-- generate heuristic values based of the birthdates of the current node and p2
				$indirec = find_person_record($node["pid"]);
				$byear1 = -1;
				$birthrec = get_sub_record(1, "1 BIRT", $indirec);
				if ($birthrec!==false) {
					$dct = preg_match("/2 DATE .*(\d\d\d\d)/", $birthrec, $match);
					if ($dct>0) $byear1 = $match[1];
				}
				if (($byear1!=-1)&&($byear2!=-1)) {
					$yeardiff = $byear1-$byear2;
					//print "<br />byear1:$byear1, byear2:$byear2, yeardiff:$yeardiff\n";
					if ($yeardiff < -140) {
						$fatherh = 20;
						$motherh = 20;
						$siblingh = 15;
						$spouseh = 15;
						$childh = 1;
					}
					else if ($yeardiff < -100) {
						$fatherh = 15;
						$motherh = 15;
						$siblingh = 10;
						$spouseh = 10;
						$childh = 1;
					}
					else if ($yeardiff < -60) {
						$fatherh = 10;
						$motherh = 10;
						$siblingh = 5;
						$spouseh = 5;
						$childh = 1;
					}
					else if ($yeardiff < -20) {
						$fatherh = 5;
						$motherh = 5;
						$siblingh = 3;
						$spouseh = 3;
						$childh = 1;
					}
					else if ($yeardiff<20) {
						$fatherh = 3;
						$motherh = 3;
						$siblingh = 1;
						$spouseh = 1;
						$childh = 5;
					}
					else if ($yeardiff<60) {
						$fatherh = 1;
						$motherh = 1;
						$siblingh = 5;
						$spouseh = 2;
						$childh = 10;
					}
					else if ($yeardiff<100) {
						$fatherh = 1;
						$motherh = 1;
						$siblingh = 10;
						$spouseh = 3;
						$childh = 15;
					}
					else {
						$fatherh = 1;
						$motherh = 1;
						$siblingh = 15;
						$spouseh = 4;
						$childh = 20;
					}
				}
				//-- check all parents and siblings of this node
				$famids = array();
				$ct = preg_match_all("/1\sFAMC\s@(.*)@/", $indirec, $match, PREG_SET_ORDER);
				for($i=0; $i<$ct; $i++) {
					$famids[$i]=$match[$i][1];
				}
				foreach($famids as $fam) {
					$famrec = find_family_record($fam);
					$parents = find_parents_in_record($famrec);
					if ((!empty($parents["HUSB"]))&&(!isset($visited[$parents["HUSB"]]))) {
						$node1 = $node;
						$node1["length"]+=$fatherh;
						$node1["path"][] = $parents["HUSB"];
						$node1["pid"] = $parents["HUSB"];
						$node1["relations"][] = "father";
						$p1nodes[] = $node1;
						if ($node1["pid"]==$pid2) {
							if ($path_to_find>0) $path_to_find--;
							else {
								$found=true;
								$node = $node1;
							}
						}
						else $visited[$parents["HUSB"]] = true;
					}
					if ((!empty($parents["WIFE"]))&&(!isset($visited[$parents["WIFE"]]))) {
						$node1 = $node;
						$node1["length"]+=$motherh;
						$node1["path"][] = $parents["WIFE"];
						$node1["pid"] = $parents["WIFE"];
						$node1["relations"][] = "mother";
						$p1nodes[] = $node1;
						if ($node1["pid"]==$pid2) {
							if ($path_to_find>0) $path_to_find--;
							else {
								$found=true;
								$node = $node1;
							}
						}
						else $visited[$parents["WIFE"]] = true;
					}
					$ct = preg_match_all("/1 CHIL @(.*)@/", $famrec, $match, PREG_SET_ORDER);
					for($i=0; $i<$ct; $i++) {
						$child = $match[$i][1];
						if ((!empty($child))&&(!isset($visited[$child]))) {
							$node1 = $node;
							$node1["length"]+=$siblingh;
							$node1["path"][] = $child;
							$node1["pid"] = $child;
							$node1["relations"][] = "sibling";
							$p1nodes[] = $node1;
							if ($node1["pid"]==$pid2) {
								if ($path_to_find>0) $path_to_find--;
								else {
									$found=true;
									$node = $node1;
								}
							}
							else $visited[$child] = true;
						}
					}
				}
				//-- check all spouses and children of this node
				$famids = array();
				$ct = preg_match_all("/1\sFAMS\s@(.*)@/", $indirec, $match, PREG_SET_ORDER);
				for($i=0; $i<$ct; $i++) {
					$famids[$i]=$match[$i][1];
				}
				foreach($famids as $fam) {
					$famrec = find_family_record($fam);
					if ($followspouse) {
						$parents = find_parents_in_record($famrec);
						if ((!empty($parents["HUSB"]))&&(!isset($visited[$parents["HUSB"]]))) {
							$node1 = $node;
							$node1["length"]+=$spouseh;
							$node1["path"][] = $parents["HUSB"];
							$node1["pid"] = $parents["HUSB"];
							$node1["relations"][] = "spouse";
							$p1nodes[] = $node1;
							if ($node1["pid"]==$pid2) {
								if ($path_to_find>0) $path_to_find--;
								else {
									$found=true;
									$node = $node1;
								}
							}
							else $visited[$parents["HUSB"]] = true;
						}
						if ((!empty($parents["WIFE"]))&&(!isset($visited[$parents["WIFE"]]))) {
							$node1 = $node;
							$node1["length"]+=$spouseh;
							$node1["path"][] = $parents["WIFE"];
							$node1["pid"] = $parents["WIFE"];
							$node1["relations"][] = "spouse";
							$p1nodes[] = $node1;
							if ($node1["pid"]==$pid2) {
								if ($path_to_find>0) $path_to_find--;
								else {
									$found=true;
									$node = $node1;
								}
							}
							else $visited[$parents["WIFE"]] = true;
						}
					}
					$ct = preg_match_all("/1 CHIL @(.*)@/", $famrec, $match, PREG_SET_ORDER);
					for($i=0; $i<$ct; $i++) {
						$child = $match[$i][1];
						if ((!empty($child))&&(!isset($visited[$child]))) {
							$node1 = $node;
							$node1["length"]+=$childh;
							$node1["path"][] = $child;
							$node1["pid"] = $child;
							$node1["relations"][] = "child";
							$p1nodes[] = $node1;
							if ($node1["pid"]==$pid2) {
								if ($path_to_find>0) $path_to_find--;
								else {
									$found=true;
									$node = $node1;
								}
							}
							else $visited[$child] = true;
						}
					}
				}
			}
		}
		unset($p1nodes[$shortest]);
	} //-- end while loop
	if ($USE_RELATIONSHIP_PRIVACY) {
		$NODE_CACHE["$pid1-".$node["pid"]] = $node;
	}
	if (headers_sent()) {
		print "<!-- Visited ".count($visited)." nodes<br />\nRequired $count iterations.<br />\n";
		print "-->\n";
	}
	return $node;
}

//-- comparison function for usort
function itemsort($a, $b) {
	global $ALPHABET_upper, $ALPHABET_lower, $LANGUAGE;

	//-- setup the language alphabet string
	$alphabet = $ALPHABET_upper[$LANGUAGE].$ALPHABET_lower[$LANGUAGE];

	//-- get rid of jr. Jr. Sr. sr. II, III and van, van der, de lowercase surname prefixes
	$aname = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/", "/^[a-z]*/"), array(" "," "," "), $a["name"]);
	$bname = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/", "/^[a-z]*/"), array(" "," "," "), $b["name"]);

	//-- get the name lengths
	$alen = strlen($aname);
	$blen = strlen($bname);
	//-- loop through the characters in the string and if we find one that is different between the strings
	//-- return the difference
	for($i=0; ($i<$alen)&&($i<$blen); $i++) {
		$aletter = $aname{$i};	//-- get the first letter
		$bletter = $bname{$i};

		//-- if it is an extended UTF-8 char then get the 2 bytes for the char
		if (ord($aletter)==195) $aletter = substr($aname, $i, 2);
		if (ord($bletter)==195) $bletter = substr($bname, $i, 2);

		//-- get the position of the letter in the alphabet string
		$apos = strpos($alphabet, $aletter);
		$bpos = strpos($alphabet, $bletter);
		if ($apos!=$bpos) return ($apos-$bpos);
	}
	//-- if we made it through the loop then check if one name is longer than the
	//-- other, the shorter one should be first
	if ($alen!=$blen) return ($alen-$blen);

	//-- the strings are exactly the same so return 0
	return 0;
}

//-- comparison function for usort
function placesort($a, $b) {
	if (empty($a)) return -1;
	if (empty($b)) return 1;
	if ((ord($a{0})==195)&&(ord($b{0})!=195)) return 1;
	if ((ord($a{0})!=195)&&(ord($b{0})==195)) return -1;
	if ((ord($a{0})==195)&&(ord($b{0})==195)) return (ord($a{1})<ord($b{1}));
	return strcasecmp($a, $b);
}

//-------------------------------------------- find_record_in_file
//-- this function finds a gedcom record in the gedcom file
function find_record_in_file($gid) {
	global $GEDCOMS, $GEDCOM;

	$fpged = fopen($GEDCOMS[$GEDCOM]["path"], "r");
	if (!$fpged) return false;
	$BLOCK_SIZE = 1024*4;	//-- 4k bytes per read
	$fcontents = "";
	while(!feof($fpged)) {
		$fcontents .= fread($fpged, $BLOCK_SIZE);
		$pos1 = strpos($fcontents, "0 @$gid@", 0);
		if ($pos1===false) $fcontents = "";
		else {
			$pos2 = strpos($fcontents, "\n0", $pos1+1);
			while((!$pos2)&&(!feof($fpged))) {
				$fcontents .= fread($fpged, $BLOCK_SIZE);
				$pos2 = strpos($fcontents, "\n0", $pos1+1);
			}
			if ($pos2) $indirec = substr($fcontents, $pos1, $pos2-$pos1);
			else $indirec = substr($fcontents, $pos1);
			return $indirec;
			break;
		}
	}
	fclose($fpged);
	return @find_person_record($gid);
}

//-------------------------------------------- write_changes
//-- this function writes the $pgv_changes back to the
//-- file
function write_changes() {
	global $GEDCOMS, $GEDCOM, $pgv_changes, $INDEX_DIRECTORY, $CONTACT_EMAIL, $PGV_DATABASE;

	//-- write the changes file
	$changestext = "<?php\n\$pgv_changes = array();\n";
	foreach($pgv_changes as $gid=>$changes) {
		if (count($changes)>0) {
			$changestext .= "\$pgv_changes[\"$gid\"] = array();\n";
			foreach($changes as $change) {
				$changestext .= "\$change = array();\n";
				$changestext .= "\$change[\"gid\"] = '".$change["gid"]."';\n";
				$changestext .= "\$change[\"gedcom\"] = '".$change["gedcom"]."';\n";
				$changestext .= "\$change[\"type\"] = '".$change["type"]."';\n";
				$changestext .= "\$change[\"status\"] = '".$change["status"]."';\n";
				$changestext .= "\$change[\"user\"] = '".$change["user"]."';\n";
				$changestext .= "\$change[\"time\"] = '".$change["time"]."';\n";
				if ($PGV_DATABASE=="index") $change["undo"] = addslashes($change["undo"]);
				$changestext .= "\$change[\"undo\"] = '".addslashes($change["undo"])."';\n";
				$changestext .= "\$pgv_changes[\"$gid\"][] = \$change;\n";
			}
		}
	}
	$changestext .= "\n?>\n";
	$fp = fopen($INDEX_DIRECTORY."pgv_changes.php", "wb");
	if ($fp===false) {
		print "ERROR 6: Unable to open changes file resource.  Unable to complete request.\n";
		return false;
	}
	$fw = fwrite($fp, $changestext);
	if ($fw===false) {
		print "ERROR 7: Unable to write to changes file.\n";
		fclose($fp);
		return false;
	}
	fclose($fp);
	//mail($CONTACT_EMAIL, "
	return true;
}

//-- function to get the names of all of the themes as an array
function get_theme_names() {
	$themes = array();
	$d = dir("themes");
	while (false !== ($entry = $d->read())) {
		if ($entry!="." && $entry!=".." && $entry!="CVS" && is_dir("themes/$entry")) {
			$theme = array();
			$themefile = implode("", file("themes/$entry/theme.php"));
			$tt = preg_match("/theme_name\s+=\s+\"(.*)\";/", $themefile, $match);
			if ($tt>0) $themename = trim($match[1]);
			else $themename = "themes/$entry";
			$theme["name"] = $themename;
			$theme["dir"] = "themes/$entry/";
			$themes[] = $theme;
		}
	}
	$d->close();
	return $themes;
}

//-- format a fact for calendar viewing
function get_calendar_fact($factrec, $action, $filter) {
	global $pgv_lang, $factarray, $year, $month, $day, $TEMPLE_CODES, $CALENDAR_FORMAT, $monthtonum, $TEXT_DIRECTION;
	$skipfacts = array("CHAN", "BAPL", "SLGC", "SLGS", "ENDL");

	$text = "";
	$ft = preg_match("/1\s(_?.{3,4})\s(.*)/", $factrec, $match);
	if ($ft>0) $fact = $match[1];
	else $fact="";
	$fact = trim($fact);
	if (!in_array($fact, $skipfacts)) {
		if ($fact=="EVEN") {
			$ct = preg_match("/2 TYPE (.*)/", $factrec, $tmatch);
			if ($ct>0) {
				$factref = trim($tmatch[1]);
				if (isset($factarray["$factref"])) $text .= $factarray["$factref"];
				else $text .= $factref;
			}
			else $text .= $factarray[$fact];
		}
		else $text .= $factarray[$fact];
		$ct = preg_match("/\d DATE (.*)/", $factrec, $match);
		if ($ct>0) {
			$text .= " - <font class=\"date\">".get_changed_date($match[1])."</font>";
			$yt = preg_match("/ (\d\d\d\d)/", $match[1], $ymatch);
			if ($yt>0) {
				$age = $year - $ymatch[1];
				$yt = preg_match("/(...) \d\d\d\d/", $match[1], $bmatch);
				if ($yt>0) {
					if (isset($monthtonum[strtolower(trim($bmatch[1]))])) {
						$emonth = $monthtonum[strtolower(trim($bmatch[1]))];
						if ($emonth<$monthtonum[strtolower($month)]) $age--;
					}
				}
				$yt = preg_match("/(.+) ... \d\d\d\d/", $match[1], $bmatch);
				if ($yt>0) {
					if ($bmatch[1]>$day) $age--;
				}
				if (($filter=="recent")&&($age>100)) return "";
				//$text .= " (".convert_number($age)." ".$pgv_lang["year_anniversary"].")";
				$text .= " (" . str_replace("#year_var#", convert_number($age), $pgv_lang["year_anniversary"]).")";
				if($TEXT_DIRECTION == "rtl"){
					$text .= "&lrm;";
	       		}
			}
			if ($action=='today') {
				// -- find place for each fact
				$ct = preg_match("/2 PLAC (.*)/", $factrec, $match);
				if ($ct>0) $text .= "<br />".$match[1];
				// -- find temple code for lds facts
				$ct = preg_match("/2 TEMP (.*)/", $factrec, $match);
				if ($ct>0) {
					$tcode = $match[1];
					$tcode = trim($tcode);
					if (array_key_exists($tcode, $TEMPLE_CODES)) $text .= "<br />".$pgv_lang["temple"].": ".$TEMPLE_CODES[$tcode];
					else $text .= "<br />".$pgv_lang["temple_code"].$tcode;
				}
			}
		}
		$text .= "<br />";
	}
	return $text;
}

//-- this function will convert a digit number to a number in a different language
function convert_number($num) {
	global $pgv_lang, $LANGUAGE;

	if ($LANGUAGE == "chinese") {
		if (empty($num)) return $num;
		$numstr = "$num";
		$zhnum = "";
		//-- currently limited to numbers <10000
		if (strlen($numstr)>4) return $numstr;

		$ln = strlen($numstr);
		$numstr = strrev($numstr);
		for($i=0; $i<$ln; $i++) {
			if (($i==1)&&($numstr{$i}!="0")) $zhnum = $pgv_lang["10"].$zhnum;
			if (($i==2)&&($numstr{$i}!="0")) $zhnum = $pgv_lang["100"].$zhnum;
			if (($i==3)&&($numstr{$i}!="0")) $zhnum = $pgv_lang["1000"].$zhnum;
			if (($i!=1)||($numstr{$i}!=1)) $zhnum = $pgv_lang[$numstr{$i}].$zhnum;
		}
		return $zhnum;
	}
	return $num;
}

//-- this function encodes a string in quoted_printable format
//-- found at http://us3.php.net/bin2hex
function hex4email ($string,$charset) {
	global $LANGUAGE;

	//-- check if the string has extended characters in it
	$str = utf8_decode($string);
	//-- if the strings are the same no conversion is necessary
	if ($str==$string) return $string;
	//-- convert to string into quoted_printable format
	$string = bin2hex ($string);
	$encoded = chunk_split($string, 2, '=');
	$encoded = preg_replace ("/=$/","",$encoded);
	$string = "=?$charset?Q?=" . $encoded . "?=";
	return $string;
}

//-- this function encodes a string for the particular filesystem it is on
function filename_decode($filename) {
	if (preg_match("/Win32/", $_SERVER["SERVER_SOFTWARE"])>0) return utf8_decode($filename);
	else return $filename;
}

//-- this function decodes a string for the particular filesystem it is on
function filename_encode($filename) {
        if (preg_match("/Win32/", $_SERVER["SERVER_SOFTWARE"])>0) return utf8_encode($filename);
        else return $filename;
}

//-- this function strips the prefixes of lastnames
function strip_prefix($lastname){
	$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/", "/^[a-z. ]*/"), array(",","",""), $lastname);
	$name = trim($name);
	$names = preg_split("/,/", $name);
	return $names;
}

//-- This function finds and returns all of the media objects in a given gedcom record
function find_media_in_record($gedrec) {
	global $medialist, $MEDIA_DIRECTORY, $ct, $PGV_IMAGE_DIR, $PGV_GEDCOM_IMG;

	$pos1=0;
	while($pos1 = strpos($gedrec, " OBJE", $pos1)) {
		while(($pos1>0)&&($gedrec[$pos1]!="\n")) $pos1--;
		if ($pos1>0) $pos1++;
		$level = $gedrec[$pos1];
		$pos2 = strpos($gedrec, "\n$level ", $pos1+5);
		if ($pos2!==false) {
			$mediarec = substr($gedrec, $pos1, $pos2-$pos1);
			$pos1 = $pos2;
		}
		else {
			$mediarec = substr($gedrec, $pos1);
			$pos1 = strlen($gedrec);
		}
		$embed = preg_match("/(\d) _*FILE (.*)/", $mediarec, $embmatch);
		if ($embed>0) {
			$level = $embmatch[1];
			$tt = preg_match("/\d TITL (.*)/", $mediarec, $match);
			$fullpath = extract_fullpath($mediarec);
			$filename = "";
			if ((strstr( $fullpath, "://"))||(strstr( $fullpath, "mailto:"))) {
				$filename=$fullpath;
				$thumbnail="$PGV_IMAGE_DIR/$PGV_GEDCOM_IMG";
			}
			else {
				$filename = extract_filename($fullpath);
				$thumbnail = $MEDIA_DIRECTORY."thumbs/".$filename;
				$thumbnail = trim($thumbnail);
				$filename = $MEDIA_DIRECTORY.$filename;
				$filename = trim($filename);
			}
			if ($tt>0) $title = trim($match[1]);
			else $title="";
			if (empty($title)) $title = $filename;
			$linked = preg_match("/0 @(.*)@ OBJE/", $mediarec, $match);
			if ($linked>0) {
				$linkid = trim($match[1]);
				$links = findLinkedRecords("OBJE @$linkid@");
				if (!isset($foundlist[$filename])) {
					$media = array();
					$media["file"] = $filename;
					$media["thumb"] = $thumbnail;
					$media["title"] = $title;
					$media["link"] = $links;
					$media["gedcom"] = $mediarec;
					$media["level"] = $level;
					$medialist[$ct]=$media;
					$foundlist[$filename] = $ct;
					$ct++;
				}
				else {
					$medialist[$foundlist[$filename]]["link"]=$links;
				}
			}
			else {
				$tt = preg_match("/0 @(.*)@ (.*)/", $gedrec, $match);
				if ($tt>0) $id = $match[1];
				else $id=$ct;
				$type = trim($match[2]);
				if (!isset($foundlist[$filename])) {
					$media = array();
					$media["file"] = $filename;
					$media["thumb"] = $thumbnail;
					$media["title"] = $title;
					$media["gedcom"] = $mediarec;
					$media["level"] = $level;
					$media["link"] = array();
					$media["link"][$id] = $type;
					$media["level"] = $level;
					$medialist[$ct]=$media;
					$foundlist[$filename] = $ct;
					$ct++;
				}
				else {
					$medialist[$foundlist[$filename]]["link"][$id]=$type;
				}
			}
		}
	}
}
?>
