<?php
/*=================================================
	Project: phpGedView
	File: functions_blocks.php
	Author:
		John Finlay
		Joe Witthuhn		jaw959@users.sourceforge.net
		Kurt Norgaz			kurtnorgaz
	Comments:
		Various functions used to create blocks and modules for the
		MyGedView page.  These functions can be used to create custom
		blocks in other applications as well.

	Change Log:
		11/06/03 - File Created from functions.php

    phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: functions_blocks.php,v 1.41.2.1 2004/02/02 15:18:12 yalnifj Exp $

if (strstr($_SERVER["PHP_SELF"],"functions")) {
	print "Now, why would you want to do that.  You're not hacking are you?";
	exit;
}

//-- upcoming events block
//-- this block prints a list of the upcoming events of living people in your gedcom
function print_upcoming_events($block=true) {
	global $pgv_lang, $month, $year, $day, $monthtonum, $HIDE_LIVE_PEOPLE, $SHOW_ID_NUMBERS;
	
	$filter = "living";
	$action = "block";
	$monthstart = mktime(1,0,0,$monthtonum[strtolower($month)],$day,$year);
	$mmon = strtolower(date("M", $monthstart));
	$myindilist = array();
	$myfamlist = array();
	$query = "2 DATE [0-9]{1,2} $mmon";
	$myindilist = search_indis($query);
	$myfamlist = search_fams($query);
	if ((count($myindilist)>0)||(count($myfamlist)>0)) {
	print "<b>".$pgv_lang["upcoming_events"]."</b><br />";
	if ($block) print "<div id=\"events\" class=\"details1\" style=\"height: 250px; overflow: auto;\">\n";
	$oldmonth=$month;
	$oldyear = $year;
	$oldday = $day;
	for($k=0; $k<30; $k++) {
		$mday = date("j", $monthstart);
		$mmon = strtolower(date("M", $monthstart));
		$day = $mday;
		$year = (int)date("Y", $monthstart);
		if ($mmon!=strtolower($month)) {
			$query = "2 DATE [0-9]{1,2} $mmon";
			$myindilist = search_indis($query);
			$myfamlist = search_fams($query);
			$month=$mmon;
		}
		$dayindilist = array();
		if ($mday<10) $query = "2 DATE 0?$mday $mmon";
		else $query = "2 DATE $mday $mmon";
		foreach($myindilist as $gid=>$indi) {
			if (preg_match("/$query/i", $indi["gedcom"])>0) $dayindilist[$gid]=$indi;
		}
		$dayfamlist = array();
		foreach($myfamlist as $gid=>$fam) {
			if (preg_match("/$query/i", $fam["gedcom"])>0) $dayfamlist[$gid]=$fam;
		}
		if ((count($dayindilist)>0)||(count($dayfamlist)>0)) {
			$daytext = "";
			foreach($dayindilist as $gid=>$indi) {
				$disp = true;
				if (($filter=="living")&&($indi["isdead"]==1)) $disp = false;
				else if ($HIDE_LIVE_PEOPLE) $disp = displayDetailsByID($gid);
		    	if ($disp) {
					$indilines = split("\n", $indi["gedcom"]);
					$factrec = "";
					$lct = count($indilines);
					$text = "";
					for($i=1; $i<=$lct; $i++) {
						if ($i<$lct) $line = $indilines[$i];
						if (empty($line)) $line = " ";
						if ($i==$lct||($line{0}=="1")) {
							if (!empty($factrec)) {
								$ct = preg_match("/$query/i", $factrec, $match);
								if ($ct>0) {
									$text .= get_calendar_fact($factrec, $action, $filter);
								}
							}
							$factrec="";
						}
						$factrec.=$line."\n";
					}
					if (!empty($text)) {
						$daytext .= "<a href=\"individual.php?pid=$gid&amp;GEDCOM=".$indi["file"]."\"><b>".$indi["name"]."</b>";
						if ($SHOW_ID_NUMBERS) $daytext .= " ($gid)";
						$daytext .= "</a><br />\n";
						$daytext .= "<div class=\"indent\">";
						$daytext .= $text;
						$daytext .= "</div><br />";
					}
				}
			}
			foreach($dayfamlist as $gid=>$fam) {
				$indilines = split("\n", $fam["gedcom"]);
				$factrec = "";
				$lct = count($indilines);
				$text = "";
				for($i=1; $i<=$lct; $i++) {
					if ($i<$lct) $line = $indilines[$i];
					if (empty($line)) $line = " ";
					if ($i==$lct||($line{0}=="1")) {
						if (!empty($factrec)) {
							$ct = preg_match("/$query/i", $factrec, $match);
							if ($ct>0) {
								$text .= get_calendar_fact($factrec, $action, $filter);
							}
						}
						$factrec="";
					}
					$factrec.=$line."\n";
				}
				if (!empty($text)) {
					$display = true;
					$parents = find_parents($gid);
					if (!empty($parents["HUSB"])) {
						if (($filter=="living")&&(is_dead_id($parents["HUSB"])==1)) $display = false;
						else if ($HIDE_LIVE_PEOPLE) $display = displayDetailsByID($parents["HUSB"]);
					}
					if ($display) {
						if (!empty($parents["WIFE"])) {
							if (($filter=="living")&&(is_dead_id($parents["WIFE"])==1)) $display = false;
							else if ($HIDE_LIVE_PEOPLE) $display = displayDetailsByID($parents["WIFE"]);
						}
					}
		    		if ($display) {
						$daytext .= "<a href=\"family.php?famid=$gid&amp;GEDCOM=".$fam["file"]."\"><b>".$fam["name"]."</b>";
						$daytext .= "</a><br />\n";
						$daytext .= "<div class=\"indent\">";
						$daytext .= $text;
						$daytext .= "</div><br />";
					}
				}
			}
			if (!empty($daytext)) {
				//print "<font class=\"date\">".get_changed_date("$mday $mmon $myear")."</font>";
				//print "<br />\n";
				print $daytext;
			}
		}
		$monthstart += (60*60*24);
	}
	if ($block) print "</div>\n";
	$day = $oldday;
	$month = $oldmonth;
	$year = $oldyear;
	}
}

//-- today's events block
//-- this block prints a list of today's upcoming events of living people in your gedcom
function print_todays_events($block=true) {
	global $pgv_lang, $month, $year, $day, $monthtonum, $HIDE_LIVE_PEOPLE, $SHOW_ID_NUMBERS;
	
	$filter = "living";
	$action = "today";
	$dayindilist = array();
	$dayfamlist = array();
	if ($day<10) $query = "2 DATE 0?$day $month";
	else $query = "2 DATE $day $month";
	$dayindilist = search_indis($query);
	$dayfamlist = search_fams($query);
	if ((count($dayindilist)>0)||(count($dayfamlist)>0)) {
		if ($block) print "<div id=\"events\" class=\"details1\" style=\"height: 250px; overflow: auto;\">\n";
		$daytext = "";
		foreach($dayindilist as $gid=>$indi) {
			$disp = true;
			if (($filter=="living")&&($indi["isdead"]==1)) $disp = false;
			else if ($HIDE_LIVE_PEOPLE) $disp = displayDetailsByID($gid);
	    	if ($disp) {
				$indilines = split("\n", $indi["gedcom"]);
				$factrec = "";
				$lct = count($indilines);
				$text = "";
				for($i=1; $i<=$lct; $i++) {
					if ($i<$lct) $line = $indilines[$i];
					if (empty($line)) $line = " ";
					if ($i==$lct||($line{0}=="1")) {
						if (!empty($factrec)) {
							$ct = preg_match("/$query/i", $factrec, $match);
							if ($ct>0) {
								$text .= get_calendar_fact($factrec, $action, $filter);
							}
						}
						$factrec="";
					}
					$factrec.=$line."\n";
				}
				if (!empty($text)) {
					$daytext .= "<a href=\"individual.php?pid=$gid&amp;GEDCOM=".$indi["file"]."\"><b>".$indi["name"]."</b>";
					if ($SHOW_ID_NUMBERS) $daytext .= " ($gid)";
					$daytext .= "</a><br />\n";
					$daytext .= "<div class=\"indent\">";
					$daytext .= $text;
					$daytext .= "</div><br />";
				}
			}
		}
		foreach($dayfamlist as $gid=>$fam) {
			$indilines = split("\n", $fam["gedcom"]);
			$factrec = "";
			$lct = count($indilines);
			$text = "";
			for($i=1; $i<=$lct; $i++) {
				if ($i<$lct) $line = $indilines[$i];
				if (empty($line)) $line = " ";
				if ($i==$lct||($line{0}=="1")) {
					if (!empty($factrec)) {
						$ct = preg_match("/$query/i", $factrec, $match);
						if ($ct>0) {
							$text .= get_calendar_fact($factrec, $action, $filter);
						}
					}
					$factrec="";
				}
				$factrec.=$line."\n";
			}
			if (!empty($text)) {
				$display = true;
				$parents = find_parents($gid);
				if (!empty($parents["HUSB"])) {
					if (($filter=="living")&&(is_dead_id($parents["HUSB"])==1)) $display = false;
					else if ($HIDE_LIVE_PEOPLE) $display = displayDetailsByID($parents["HUSB"]);
				}
				if ($display) {
					if (!empty($parents["WIFE"])) {
						if (($filter=="living")&&(is_dead_id($parents["WIFE"])==1)) $display = false;
						else if ($HIDE_LIVE_PEOPLE) $display = displayDetailsByID($parents["WIFE"]);
					}
				}
	    		if ($display) {
					$daytext .= "<a href=\"family.php?famid=$gid&amp;GEDCOM=".$fam["file"]."\"><b>".$fam["name"]."</b>";
					$daytext .= "</a><br />\n";
					$daytext .= "<div class=\"indent\">";
					$daytext .= $text;
					$daytext .= "</div><br />";
				}
			}
		}
		if (!empty($daytext)) {
			print "<b>".$pgv_lang["on_this_day"]."</b><br />";
			print $daytext;
		}
		if ($block) print "</div>\n";
	}
}

//-- logged in users
//-- prints a list of other users who are logged in
function print_logged_in_users($block=true) {
	global $pgv_lang, $PGV_SESSION_TIME;
	
	$users = getUsers();
	$loggedusers = array();
	foreach($users as $user) {
	//	print time().' - '.$user["sessiontime"].' = '.(time() - $user["sessiontime"]).' < '.$PGV_SESSION_TIME.' ';
		if ($user["loggedin"]=="Y") {
			if (time() - $user["sessiontime"] > $PGV_SESSION_TIME) userLogout($user["username"]);
			else  $loggedusers[] = $user;
		}
	}
	if (count($loggedusers)<2) return;
	print "<b>".$pgv_lang["users_logged_in"]." (".count($loggedusers).")</b><br />\n";
	if ($block) print "<div id=\"users\" class=\"details2\" style=\"height: 150px; overflow: auto;\">\n";
	foreach($loggedusers as $user) {
		print "<br />".$user["fullname"]." (".$user["username"].")<br />";
		if (getUserName()!=$user["username"]) {
			//print "<a href=\"#\" onclick=\"return chat('".$user["username"]."');\">".$pgv_lang["chat"]."</a> | ";
			print "<a href=\"#\" onclick=\"return message('".$user["username"]."');\">".$pgv_lang["message"]."</a><br />";
		}
	}
	if ($block) print "</div>\n";
}

//-- print user messages
function print_user_messages($block = true) {
	global $pgv_lang, $PGV_IMAGE_DIR, $PGV_HLINE_IMG;
	
	$usermessages = getUserMessages(getUserName());
		print "<b>".$pgv_lang["my_messages"]." (".count($usermessages).")</b><br />\n";
		if ($block) print "<div id=\"users\" class=\"details2\" style=\"height: 150px; overflow: auto;\">\n";
		if (count($usermessages)==0) print $pgv_lang["no_messages"];
		foreach($usermessages as $key=>$message) {
			if (!empty($message["created"])) $time = strtotime($message["created"]);
			else $time = time();
			$day = date("j", $time);
			$mon = date("M", $time);
			$year = date("Y", $time);
			$tempuser = getUser($message["from"]);
			print "<div class=\"person_box\">\n";
			print "<font class=\"date\">".$pgv_lang["date_created"]."</font> ".get_changed_date("$day $mon $year")." <script language=\"JavaScript\">printTime('".$message["created"]."');</script><br />\n";
			print "<font class=\"date\">".$pgv_lang["message_from"]."</font> ";
			if ($tempuser) {
				print $tempuser["fullname"];
				print " (".htmlspecialchars($message["from"]).")<br />\n";
			}
			else {
				print "<a href=\"mailto:".$message["from"]."\">".$message["from"]."</a><br />\n";
			}
			print "<font class=\"date\">".$pgv_lang["message_to"]."</font> ".$message["to"]."<br />\n";
			print "<font class=\"date\">".htmlspecialchars($pgv_lang["message_subject"])."</font> ".$message["subject"]."<br /><br />\n";
			$message["body"] = nl2br(htmlspecialchars($message["body"]));
			$message["body"] = preg_replace("/(http:.*)(<)/", "<a href=\"$1\">$1</a>$2", $message["body"]);
			print $message["body"]."<br /><br />\n";
			if (preg_match("/RE:/", $message["subject"])==0) $message["subject"]="RE:".$message["subject"];
			if ($tempuser) print "<a href=\"#\" onclick=\"reply('".$message["from"]."', '".$message["subject"]."'); return false;\">".$pgv_lang["reply"]."</a> | ";
			if (isset($message["id"])) $key = $message["id"];
			print "<a href=\"mygedview.php?action=deletemessage&message_id=$key\" onclick=\"return confirm('".$pgv_lang["confirm_message_delete"]."');\">".$pgv_lang["delete"]."</a><br /></div><br />\n";
		}
		$users = getUsers();
		if (count($users)>1) {
			print "<form name=\"messageform\" onsubmit=\"return false;\">".$pgv_lang["message"]." <select name=\"touser\">\n";
			$username = getUserName();
			foreach($users as $user) {
				if ($username!=$user["username"]) {
					print "<option value=\"".$user["username"]."\"";
					print ">".$user["fullname"]." (".$user["username"].")</option>\n";
				}
			}	
			print "</select><input type=\"button\" value=\"".$pgv_lang["send"]."\" onclick=\"message(document.messageform.touser.options[document.messageform.touser.selectedIndex].value, 'messaging2', ''); return false;\">\n</form>\n";
		}
		if ($block) print "</div>\n";
}

//-- print user favorites
function print_user_favorites($block = true) {
	global $pgv_lang, $PGV_IMAGE_DIR, $PGV_HLINE_IMG, $GEDCOM;
	
	$userfavs = getUserFavorites(getUserName());
	if (!is_array($userfavs)) $userfavs = array();
	print "<b>".$pgv_lang["my_favorites"]." (".count($userfavs).")</b><br />\n";
	if ($block) print "<div id=\"users\" class=\"details2\" style=\"height: 150px; overflow: auto;\">\n";
	if (count($userfavs)==0) print $pgv_lang["no_favorites"];
	print "<table width=\"100%\">";
	$mygedcom = $GEDCOM;
	if ($block) $style = 1;
	else $style = 2;
	foreach($userfavs as $key=>$favorite) {
		if ($favorite["type"]=="INDI") {
			$GEDCOM = $favorite["file"];
			print "<tr><td>";
			if (isset($favorite["id"])) $key=$favorite["id"];
			print_favorite($favorite["gid"], $style, $key);
			print "</td></tr>\n";
		}
	}
	$GEDCOM = $mygedcom;
	print "</table>\n";
	?>
<script type="text/javascript">
var pasteto;
function open_find(textbox) {
	pasteto = textbox;
	findwin = window.open('findid.php', '', 'left=50,top=50,width=450,height=450,resizable=1,scrollbars=1');
}
function paste_id(value) {
	pasteto.value=value;
	document.addfavform.submit();
}
</script>
<?php
	print "<form name=\"addfavform\" method=\"get\" action=\"mygedview.php\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"addfav\">\n";
	print "<input type=\"text\" name=\"gid\" size=\"3\" value=\"\" /><font size=\"1\"><a href=\"javascript:open_find(document.addfavform.gid);\">".$pgv_lang["find_id"]."</a></font>";
	print " <input type=\"submit\" value=\"".$pgv_lang["add"]."\" style=\"font-size: 8pt; \">\n";
	print "\n</form>\n";
	if ($block) print "</div>\n";
}

// -- find and print a given individuals information for a favorites
function print_favorite($pid, $style=2, $fv_id) {
	global $factarray, $TEMPLE_CODES, $SHOW_PEDIGREE_PLACES, $LINK_ICONS, $SHOW_LIVING_NAMES, $PRIV_PUBLIC;
	global $pgv_lang, $MULTI_MEDIA, $SHOW_HIGHLIGHT_IMAGES, $show_full,  $SHOW_ID_NUMBERS, $PGV_IMAGE_DIR;
	global $PGV_PEDIGREE_IMG, $PGV_SEARCH_IMG, $CONTACT_METHOD, $CONTACT_EMAIL, $THEME_DIR, $SHOW_GEDCOM_RECORD, $ENABLE_CLIPPINGS_CART, $GEDCOM, $bwidth;

	if (!isset($show_full)) $show_full=true;
	$indirec=find_person_record($pid);
	$disp = displayDetails($indirec);
	if (!$indirec) $indirec = find_record_in_file($pid);
	$isF = "";
	if (preg_match("/1 SEX F/", $indirec)>0) $isF="F";

	print "\n\t\t\t<div id=\"out-$pid\" class=\"person_box$isF\" style=\"padding: 2px;\"><table cellspacing=\"5\" cellpadding=\"0\" border=\"0\" width=\"100%\"><tr><td valign=\"top\">";
	//-- find the name
	$name = get_person_name($pid);
	//-- check if the persion is visible
	if (!$disp) {
		if (showLivingName($indirec)) {
			print "<a href=\"individual.php?pid=$pid\"><font id=\"namedef-$pid\" class=\"name$style\">";
			print $name;
			print "</font>";
			if ($SHOW_ID_NUMBERS) print "<font class=\"details$style\"> ($pid)</font>";
			print "</a>";
		}
		else {
			$user = getUser($CONTACT_EMAIL);
			print "<a href=\"#\" onclick=\"if (confirm('".preg_replace("'<br />'", " ", $pgv_lang["privacy_error"])."\\n\\n".str_replace("#user[fullname]#", $user["fullname"], $pgv_lang["clicking_ok"])."')) ";
			if ($CONTACT_METHOD!="none") {
				if ($CONTACT_METHOD=="mailto") print "window.location = 'mailto:".$user["email"]."'; ";
				else print "message('$CONTACT_EMAIL', '$CONTACT_METHOD'); ";
			}
			print "return false;\"><font id=\"namedef-$pid\" class=\"name$style\">".$pgv_lang["living"]."</font></a>\n";
		}
		if ($show_full) {
			print "<br /><font id=\"fontdef-$pid\" class=\"details$style\">";
			print $pgv_lang["private"];
			print "</font>";
		}
		print "\n\t\t\t</td></tr></table></div>";
		return;
	}
	print "<a href=\"individual.php?pid=$pid\"><font id=\"namedef-$pid\" class=\"name$style\">";
	print $name;
	print "</font>";
	if ($SHOW_ID_NUMBERS) print "<font class=\"details$style\"> ($pid)</font>";
	print "</a>";
	if ($show_full) {
		print "<br /><span id=\"fontdef-$pid\" class=\"details$style\">";
		$bpos1 = strpos($indirec, "1 BIRT");
		if ($bpos1) {
			if (showFact("BIRT", $pid)) print_simple_fact($indirec, "BIRT", $pid);
		}
		//-- no birth check for christening or baptism
		else {
			$bpos1 = strpos($indirec, "1 CHR");
			if ($bpos1) {
				if (showFact("CHR", $pid)) print_simple_fact($indirec, "CHR", $pid);
			}
			else {
				$bpos1 = strpos($indirec, "1 BAPM");
				if ($bpos1) {
					if (showFact("BAPM", $pid)) print_simple_fact($indirec, "BAPM", $pid);
				}
			}
		}
		print "<br />";
		$bpos1 = strpos($indirec, "1 DEAT");
		if ($bpos1) {
			if (showFact("DEAT", $pid)) print_simple_fact($indirec, "DEAT", $pid);
		}
		print "</span>";
	}
	print "\n\t\t\t</td>";
	print "<td>";
	if ($MULTI_MEDIA && $SHOW_HIGHLIGHT_IMAGES && $show_full) {
		$object = find_highlighted_object($pid, $indirec);
		if (!empty($object["thumb"])) {
			$size = @getimagesize($object["thumb"]);
			$class = "pedigree_image_portrait";
			if ($size[0]>$size[1]) $class = "pedigree_image_landscape";
			print "<img id=\"box-$pid-thumb\" name=\"box-$pid-thumb\" src=\"".$object["thumb"]."\" vspace=\"0\" hspace=\"0\" class=\"$class\" alt =\"\" />\n";
		}
	}
	print "</td>";
	print "<td align=\"right\">";
	print "<font size=\"1\"><a href=\"mygedview.php?action=deletefav&fv_id=".$fv_id."\" onclick=\"return confirm('".$pgv_lang["confirm_fav_remove"]."');\">".$pgv_lang["remove"]."</a><br />\n";
	print "<a href=\"#\" ";
	if ($LINK_ICONS=="mouseover") print "onmouseover=\"show_family_box('".$pid."', '";
	if ($LINK_ICONS=="click") print "onclick=\"toggle_family_box('".$pid."', '";
	if ($style==1) print "box$pid";
	else print "relatives";
	print "');";
	print " return false;\" ";
	//if ($LINK_ICONS=="mouseover") 
	print "onmouseout=\"family_box_timeout('".$pid."');";
	print " return false;\"";
	print "><img src=\"$PGV_IMAGE_DIR/small/$PGV_PEDIGREE_IMG\" width=\"25\" border=\"0\" vspace=\"0\" hspace=\"0\" alt=\"".$pgv_lang["person_links"]."\" title=\"".$pgv_lang["person_links"]."\" /></a>";
	print "</font>\n";
	print "\n\t\t<div id=\"I".$pid."links\" style=\"position:absolute; left: -15px; top:15px; width: ".($bwidth*1.25)."px; visibility:hidden; text-align: left; z-index:'100';\">";
	print "\n\t\t\t<table class=\"person_box\" width=\"100%\"><tr><td><font class=\"details1\">";
	$ct = preg_match_all("/1\s*FAMS\s*@(.*)@/", $indirec, $match, PREG_SET_ORDER);
	for ($i=0; $i<$ct; $i++) {
		$famid = $match[$i][1];
		$famrec = find_family_record($famid);
		if ($famrec) {
			$parents = find_parents_in_record($famrec);
			$spouse = $parents["WIFE"];
			if ((empty($spouse))||($spouse==$pid)) $spouse=$parents["HUSB"];
			if (!empty($spouse)) {
				print "<a href=\"family.php?famid=$famid\" onmouseover=\"clear_family_box_timeout('".$pid."');\" onmouseout=\"family_box_timeout('".$pid."');\"><b>".$pgv_lang["fam_spouse"]."</b></a> <br /><a href=\"individual.php?pid=$spouse\" onmouseover=\"clear_family_box_timeout('".$pid."');\" onmouseout=\"family_box_timeout('".$pid."');\">";
				if (($SHOW_LIVING_NAMES>=$PRIV_PUBLIC) || (displayDetailsByID($spouse))||(showLivingNameByID($spouse))) print get_person_name($spouse);
				else print $pgv_lang["living"];
				print "</a><br />\n";
			}
			$num = preg_match_all("/1\s*CHIL\s*@(.*)@/", $famrec, $smatch,PREG_SET_ORDER);
			for($j=0; $j<$num; $j++) {
				$cpid = $smatch[$j][1];
				print "\n\t\t\t\t&nbsp;&nbsp;<a href=\"individual.php?pid=$cpid\" onmouseover=\"clear_family_box_timeout('".$pid."');\" onmouseout=\"family_box_timeout('".$pid."');\">";
				if (($SHOW_LIVING_NAMES>=$PRIV_PUBLIC) || (displayDetailsByID($cpid))||(showLivingNameByID($cpid))) print get_person_name($cpid);
				else print $pgv_lang["living"];
				print "<br /></a>";
			}
		}
	}
	print "</font></td>\n<td><font class=\"details1\">";
	include $THEME_DIR."sublinks.html";
	print "</font></td>\n</tr></table>\n\t\t</div>";
	print "</td></tr></table></div>";
}

//-- function to print the welcome block
function print_welcome_block($block = true) {
	global $pgv_lang, $day, $month, $year, $PGV_IMAGE_DIR, $PGV_INDIS_IMG, $PGV_PEDIGREE_IMG, $user, $GEDCOM;
	
	if (!$block) print "<table><tr><td>";
	print "<center><b>".$pgv_lang["welcome"]." ".$user["fullname"];
	print "\n<br />".get_changed_date("$day $month $year")." - <script language=\"JavaScript\">printTimeNow();</script>\n";
	print "\n</b><br />";
	if (!$block) print "</center></td><td>";
	print "<table cellspacing=\"5\" width=\"100%\"><tr><td valign=\"middle\" align=\"center\" class=\"details2\"><a href=\"edituser.php\"><img src=\"$PGV_IMAGE_DIR/small/$PGV_INDIS_IMG\" border=\"0\" /><br />".$pgv_lang["myuserdata"]."</a></td>";
	if (!empty($user["gedcomid"][$GEDCOM])) print "<td valign=\"middle\" align=\"center\" class=\"details2\"><a href=\"index.php?rootid=".$user["gedcomid"][$GEDCOM]."\"><img src=\"$PGV_IMAGE_DIR/small/$PGV_PEDIGREE_IMG\" border=\"0\" /><br />".$pgv_lang["my_pedigree"]."</a></td><td valign=\"middle\" align=\"center\" class=\"details2\"><a href=\"individual.php?pid=".$user["gedcomid"][$GEDCOM]."\"><img src=\"$PGV_IMAGE_DIR/small/$PGV_INDIS_IMG\" border=\"0\" /><br />".$pgv_lang["my_indi"]."</a>\n";
	print "</td></tr></table>";
	if (!$block) print "</td></tr></table>";
}

//-- function to display a random picture from the gedcom
function print_random_media($block = true) {
	global $pgv_lang, $GEDCOM, $medialist;
	
	$medialist = array();
	
	get_media_list();
	$ct = count($medialist);
	//$medialist = array_values($medialist);
	if ($ct>0) {
		if ($block) print "<div id=\"users\" class=\"details2\" style=\"height: 150px; overflow: auto;\">\n";
		print "<center><b>".$pgv_lang["random_picture"]."</b><br />\n";
		$index = rand(0,$ct-1);
		$value = $medialist[$index];
	    if (file_exists($value["file"])) {
			$imgsize = getimagesize($value["file"]);
			$imgwidth = $imgsize[0]+50;
			$imgheight = $imgsize[1]+50;
		}
		else {
			$imgwidth=100;
			$imgheight=100;
		}
	    print "<table><tr><td valign=\"top\"";
	    if ($block) print " align=\"center\" class=\"details1\"";
	    else print " class=\"details2\"";
	    print ">";
	    print "<a href=\"#\" onclick=\"return openImage('".$value["file"]."',$imgwidth, $imgheight);\">";
	    if ($block) {
		    if (file_exists(filename_decode($value["thumb"]))) print "<img src=\"".$value["thumb"]."\" border=0 class=\"thumbnail\"></a>";
	    }
	    else {
		    if (file_exists(filename_decode($value["file"]))) print "<img src=\"".$value["file"]."\" border=0 class=\"image\"></a>";
	    }
	    if ($block) print "<br />";
	    else print "</td><td class=\"details2\">";
	    print "<a href=\"#\" onclick=\"return openImage('".$value["file"]."',$imgwidth, $imgheight);\">";
	    if ($value["title"]!=$value["file"]) print "<b>".$value["title"]."</b><br />";
	    print "</a>";
	    $links = $value["link"];
	    foreach($links as $id=>$type) {
	    	if (($type=="INDI")&&(displayDetailsByID($id))) print " <a href=\"individual.php?pid=".$id."\">".$pgv_lang["view_person"]." -".get_person_name($id)."</a>";
	    	if ($type=="FAM") print " <a href=\"family.php?famid=".$id."\">".$pgv_lang["view_family"]." - ".get_family_descriptor($id)."</a>";
	    	if ($type=="SOUR") print " <a href=\"source.php?sid=".$id."\">".$pgv_lang["view_source"]." - ".get_source_descriptor($id)."</a>";
	    }
	    print "<br /><div class=\"indent\">";
	    print_fact_notes($value["gedcom"], $value["level"]);
	    print "</div>";
	    print "</td></tr></table>\n";
		if ($block) print "</div>\n";
		print "</center>";
	}
}

?>
