<?php
/*=================================================
	Project: phpGedView
	File: functions.php
	Author:
		John Finlay
		Joe Witthuhn		jaw959@users.sourceforge.net
		Kurt Norgaz		kurtnorgaz@users.sourceforge.net
	Comments:
		Various functions used by all scripts and included by the config.php
		file.

	Change Log:
		8/09/03 - File Created from standard version functions.php

	phpGedView: Genealogy Viewer
	Copyright (C) 2002 to 2003  John Finlay and Others

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: functions_index.php,v 1.66.2.4 2004/02/02 15:18:12 yalnifj Exp $
if (strstr($_SERVER["PHP_SELF"],"functions")) {
	print "Now, why would you want to do that.  You're not hacking are you?";
	exit;
}

function check_db() {
	global $GEDCOM, $GEDCOMS, $INDEX_DIRECTORY, $BUILDING_INDEX, $indilist, $famlist, $sourcelist, $otherlist;

	$indexfile = $INDEX_DIRECTORY.$GEDCOM."_index.php";

	//-- check for index files and update them if necessary
	if (!isset($BUILDING_INDEX)) {
		$updateindex=false;
		if ((file_exists($indexfile))&&(file_exists($GEDCOMS[$GEDCOM]["path"]))) {
			$indextime = filemtime($indexfile);
			$gedtime = filemtime($GEDCOMS[$GEDCOM]["path"]);
			if ($indextime < $gedtime) $updateindex=true;
		}
		else {
			$updateindex=true;
		}

		if (file_exists($indexfile)) {
			//require($indexfile);
			$fp = fopen($indexfile, "r");
		        $fcontents = fread($fp, filesize($indexfile));
		        fclose($fp);
			$lists = unserialize($fcontents);
			unset($fcontents);
			$indilist = $lists["indilist"];
			$famlist = $lists["famlist"];
			$sourcelist = $lists["sourcelist"];
			$otherlist = $lists["otherlist"];
		}
	}
	return true;
}

function check_for_import($ged) {
	global $GEDCOM, $GEDCOMS, $INDEX_DIRECTORY, $BUILDING_INDEX, $indilist, $famlist, $sourcelist, $otherlist;
	
	$indexfile = $INDEX_DIRECTORY.$ged."_index.php";
	if (isset($BUILDING_INDEX)) return true;
	if (!file_exists($indexfile)) return false;
	return true;
}

function print_execution_stats() {
	global $start_time, $pgv_lang;

	$end_time = getmicrotime();
	$exectime = $end_time - $start_time;
	print "<br /><br />".$pgv_lang["exec_time"];
	printf(" %.3f sec.<br />", $exectime);
}

//-- check if a person is dead using their ID
function is_dead_id($pid) {
	global $HIDE_LIVE_PEOPLE;
	global $indilist, $BUILDING_INDEX;

	if ($HIDE_LIVE_PEOPLE){
		//-- if using indexes then first check the indi_isdead array
		if ((!$BUILDING_INDEX)&&(is_array($indilist))) {
			if (!empty($pid)) return $indilist[$pid]["isdead"];
		}
		return is_dead(find_person_record($pid));
	}
	return true;
}

// -- find and return a given family's information
function find_family_record($famid) {
	global $famlist;

	if (isset($famlist[$famid])) return preg_replace("/\\\'/", "'", $famlist[$famid]["gedcom"]);

	return false;
}

// -- find and return a given individuals information
function find_person_record($pid) {
	global $indilist;

	if (isset($indilist[$pid])) return preg_replace("/\\\'/", "'", $indilist[$pid]["gedcom"]);
	$pid = strtoupper($pid);
	if (isset($indilist[$pid])) return preg_replace("/\\\'/", "'", $indilist[$pid]["gedcom"]);

	return false;
}

// -- find and return a given ids record
function find_gedcom_record($pid) {
	global $indilist, $famlist, $sourcelist, $otherlist;

	if (empty($pid)) return false;

	if (isset($indilist[$pid])) return preg_replace("/\\\'/", "'", $indilist[$pid]["gedcom"]);
	if (isset($famlist[$pid])) return preg_replace("/\\\'/", "'", $famlist[$pid]["gedcom"]);
	if (isset($sourcelist[$pid])) return preg_replace("/\\\'/", "'", $sourcelist[$pid]["gedcom"]);
	if (isset($otherlist[$pid])) return preg_replace("/\\\'/", "'", $otherlist[$pid]["gedcom"]);
	$pid = strtoupper($pid);
	if (isset($indilist[$pid])) return preg_replace("/\\\'/", "'", $indilist[$pid]["gedcom"]);
	if (isset($famlist[$pid])) return preg_replace("/\\\'/", "'", $famlist[$pid]["gedcom"]);
	if (isset($sourcelist[$pid])) return preg_replace("/\\\'/", "'", $sourcelist[$pid]["gedcom"]);
	if (isset($otherlist[$pid])) return preg_replace("/\\\'/", "'", $otherlist[$pid]["gedcom"]);

	return false;
}

// -- find and return given source information
function find_source_record($sid) {
	global $fcontents, $sourcelist;
	global $pgv_lang;

	if ($sid=="") return false;
	if (isset($sourcelist[$sid])) return preg_replace("/\\\'/", "'", $sourcelist[$sid]["gedcom"]);

	return false;
}

//-- find and return the id of the first person in the gedcom
function find_first_person() {
	global $fcontents, $indilist;

	foreach($indilist as $key=>$indi) return $key;
}

// -- find and return a given individuals name surname, givennames suffix
if (!isset($BUILDING_INDEX)) {
	function get_sortable_name($pid) {
		global $indilist;
		if ($pid=="") return false;
		$pid = strtoupper($pid);
		if (isset($indilist[$pid])) return $indilist[$pid]["name"];
		return false;
	}

	function get_family_descriptor($fid) {
		global $famlist, $indilist, $pgv_lang;
		if (empty($fid)) return "";
		$fam = $famlist[$fid];
		$name = "";
		if (!empty($fam["HUSB"])) $name = $indilist[$fam["HUSB"]]["name"];
		else $name = "(".$pgv_lang["unknown"].")";
		$name .= " + ";
		if (!empty($fam["WIFE"])) $name .= $indilist[$fam["WIFE"]]["name"];
		else $name .= "(".$pgv_lang["unknown"].")";
		return $name;
	}

	function get_source_descriptor($sid) {
		global $sourcelist;
		if (isset($sourcelist[$sid]["name"])) return $sourcelist[$sid]["name"];
	}
}
else {
	function get_sortable_name($pid) {
		global $fcontents;
		global $pgv_lang;

		if ($pid=="") return false;
		$pos1 = strpos($fcontents, "0 @$pid@ INDI");
		if (!$pos1) {
			print "Unable to find individual with id $pid";
			return false;
		}
		$pos2 = strpos($fcontents, "0 @", $pos1+1);
		$indirec = substr($fcontents, $pos1, $pos2-$pos1);
		$ct = preg_match("/2 SURN (.*)/", $indirec, $match);
		if ($ct>0) {
			$gt = preg_match("/2 GIVN (.*)/", $indirec, $gmatch);
			$st = preg_match("/2 NSFX (.*)/", $indirec, $smatch);
			$name = rtrim($match[1]);
			if ($st>0) $name.=" ".rtrim($smatch[1]);
			if ($gt>0) $name.=", ".rtrim($gmatch[1]);
		}
		else {
			$nt = preg_match("/1 NAME (.*)/", $indirec, $match);
			if ($nt>0) {
				$names = preg_split("/\//", $match[1]);
				if (count($names)>1) {
					$name = trim($names[1]).",";
					$name .= " ".trim($names[0]);
					if (count($names)>2) $name .= " ".trim($names[2]);
				}
				else $name=$match[1];

			}
			else $name = "Individual $gid";
		}
		$name = preg_replace("'\/'", "", $name);
		$name = preg_replace('/"/', '\"', $name);
		return $name;
	}

	function get_family_descriptor($fid) {
		global $pgv_lang;
		$parents = find_parents($fid);
		return get_sortable_name($parents["HUSB"])." + ".get_sortable_name($parents["WIFE"]);
	}

	function get_source_descriptor($sid) {
		global $pgv_lang;
		$source = find_source_record($sid);
		if ($source) {
			$ct = preg_match("/1 ABBR (.*)/", $source, $match);
			if ($ct > 0) return $match[1];
			else {
				$ct = preg_match("/1 TITL (.*)/", $source, $match);
				if ($ct > 0) {
					$title = $match[1];
					$ct = preg_match_all("/2 CON[C|T] (.*)/", $factrec, $match, PREG_SET_ORDER);
					for($i=0; $i<$ct; $i++) {
						$title .= $match[$i][1];
					}
					return $title;
				}
			}
		}
		return $sid;
	}
}

//=================== IMPORT FUNCTIONS
//-- function to import a record into the database
function import_record($indirec) {
	global $gid, $type,$indilist,$famlist,$sourcelist,$otherlist;
	global $TBLPREFIX, $GEDCOM_FILE, $FILE, $FP, $pgv_lang, $USE_RIN, $CREATE_GENDEX, $gdfp;

	$ct = preg_match("/0 @(.*)@ (.*)/", $indirec, $match);
	if ($ct > 0) {
		$gid = $match[1];
		$type = trim($match[2]);
	}
	else {
		$ct = preg_match("/0 (.*)/", $indirec, $match);
		$gid = trim($match[1]);
		$type = trim($match[1]);
	}
	if ($type == "INDI") {
		$nametag="";
		$surname="";
		$nt = preg_match("/1 NAME (.*)/", $indirec, $ntmatch);
		if ($nt>0) {
			$nametag = trim($ntmatch[1]);
		}
		$ct = preg_match("/2 SURN (.*)/", $indirec, $match);
		if ($ct>0) {
			$gt = preg_match("/2 GIVN (.*)/", $indirec, $gmatch);
			$st = preg_match("/2 NSFX (.*)/", $indirec, $smatch);
			$name = trim($match[1]);
			$surname = $name;
			if (empty($name)) $name = "(".$pgv_lang["unknown"].")";
			if ($st>0) $name.=" ".rtrim($smatch[1]);
			if ($gt>0) $name.=", ".rtrim($gmatch[1]);
		}
		else {
			if ($nt>0) {
				$names = preg_split("/\//", $ntmatch[1]);
				if (count($names)>1) $name = trim($names[1]);
			}
			if (empty($name)) $name = "(".$pgv_lang["unknown"].")";
			$surname = trim($name);
			$st = preg_match("/2 NSFX (.*)/", $indirec, $smatch);
			if ($st>0) $name.=" ".rtrim($smatch[1]);
			if ($nt>0) {
				$name .= ", ".trim($names[0]);
				if (count($names)>2) $name .= " ".trim($names[2]);
			}
		}
		$name = preg_replace("'\/'", "", $name);
		$ct = preg_match_all("/1 FAMS @(.*)@/", $indirec, $match, PREG_SET_ORDER);
		$sfams = "";
		for($j=0; $j<$ct; $j++) {
			$sfams .= $match[$j][1].";";
		}
		$ct = preg_match_all("/1 FAMC @(.*)@/", $indirec, $match, PREG_SET_ORDER);
		$cfams = "";
		for($j=0; $j<$ct; $j++) {
			$cfams .= $match[$j][1].";";
		}
		$isdead = 0;

		$indi = array();
		$indi["name"] = $name;
		$indi["isdead"] = $isdead;
		$indi["gedcom"] = $indirec;
		$indi["file"] = $FILE;
		if ($USE_RIN) {
			$ct = preg_match("/1 RIN (.*)/", $indirec, $match);
			if ($ct>0) $rin = trim($match[1]);
			else $rin = $gid;
			$indi["rin"] = $rin;
		}
		$indilist["$gid"] = $indi;
		// -- the next section is to generate a gedex file
		if ($CREATE_GENDEX) {
			$birthdate = "";
			$birthplace = "";
			$deathdate = "";
			$deathplace = "";
			$bpos1 = strpos($indirec, "1 BIRT");
			if ($bpos1) {
				$birthrec = get_sub_record(1, "1 BIRT", $indirec);
				if ($birthrec!==false) {
					$dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
					if ($dct>0) $birthdate = trim($match[1]);
					$pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
					if ($pct>0) $birthplace = trim($match[1]);
				}
			}
			//-- no birth check for christening or baptism
			else {
				$bpos1 = strpos($indirec, "1 CHR");
				if ($bpos1) {
					$birthrec = get_sub_record(1, "1 CHR", $indirec);
					if ($birthrec!==false) {
						$dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
						if ($dct>0) $birthdate = trim($match[1]);
						$pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
						if ($pct>0) $birthplace = trim($match[1]);
					}
				}
			}
			$bpos1 = strpos($indirec, "1 DEAT");
			if ($bpos1) {
				$birthrec = get_sub_record(1, "1 DEAT", $indirec);
				if ($birthrec!==false) {
					$dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
					if ($dct>0) $deathdate = trim($match[1]);
					$pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
					if ($pct>0) $deathplace = trim($match[1]);
				}
			}
			//-- no birth check for christening or baptism
			else {
				$bpos1 = strpos($indirec, "1 BURI");
				if ($bpos1) {
					$birthrec = get_sub_record(1, "1 BURI", $indirec);
					if ($birthrec!==false) {
						$dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
						if ($dct>0) $deathdate = trim($match[1]);
						$pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
						if ($pct>0) $deathplace = trim($match[1]);
					}
				}
			}
			fwrite($gdfp, utf8_decode("individual.php?pid=$gid|$surname|$nametag|$birthdate|$birthplace|$deathdate|$deathplace|\r\n"));
		}
	}
	else if ($type == "FAM") {
		$parents = array();
		$ct = preg_match("/1 HUSB @(.*)@/", $indirec, $match);
		if ($ct>0) $parents["HUSB"]=$match[1];
		else $parents["HUSB"]=false;
		$ct = preg_match("/1 WIFE @(.*)@/", $indirec, $match);
		if ($ct>0) $parents["WIFE"]=$match[1];
		else $parents["WIFE"]=false;
		$ct = preg_match_all("/\d CHIL @(.*)@/", $indirec, $match, PREG_SET_ORDER);
		$chil = "";
		for($j=0; $j<$ct; $j++) {
			$chil .= $match[$j][1].";";
		}
		$fam = array();
		$fam["HUSB"] = $parents["HUSB"];
		$fam["WIFE"] = $parents["WIFE"];
		$fam["CHIL"] = $chil;
		$fam["gedcom"] = $indirec;
		$fam["file"] = $FILE;
		$famlist[$gid] = $fam;
	}
	else if ($type=="SOUR") {
		$et = preg_match("/1 ABBR (.*)/", $indirec, $smatch);
		if ($et>0) $name = $smatch[1];
		$tt = preg_match("/1 TITL (.*)/", $indirec, $smatch);
		if ($tt>0) $name = $smatch[1];
		else $name = $gid;
		$source = array();
		$source["name"] = $name;
		$source["gedcom"] = $indirec;
		$source["file"] = $FILE;
		$sourcelist[$gid] = $source;
	}
	else if (preg_match("/_/", $type)==0) {
		$source = array();
		$source["type"] = $type;
		$source["gedcom"] = $indirec;
		$source["file"] = $FILE;
		$otherlist[$gid] = $source;
	}
}

function update_isdead($gid, $indi) {
	global $FP, $USE_RIN, $indilist;

	$isdead = 0;
	$isdead = is_dead($indi["gedcom"]);
	if (empty($isdead)) $isdead = 0;
	$indi["isdead"] = $isdead;
	$indilist[$gid] = $indi;
}

function update_family_name($gid, $fam) {
	global $indilist, $pgv_lang, $FP, $famlist;

	$name = "";
	if (!empty($fam["HUSB"])) $name = $indilist[$fam["HUSB"]]["name"];
	else $name = "(".$pgv_lang["unknown"].")";
	$name .= " + ";
	if (!empty($fam["WIFE"])) $name .= $indilist[$fam["WIFE"]]["name"];
	else $name .= "(".$pgv_lang["unknown"].")";
	$famlist[$gid]["name"] = $name;
}

//-- function that checks if the database exists and creates tables
function setup_database($stage) {
	global $FP, $INDEX_DIRECTORY, $pgv_lang, $FILE;
	$indexfile = $INDEX_DIRECTORY.$FILE."_index.php";
	$FP = fopen($indexfile, "ab");
	if (!$FP) {
		print "<font class=\"error\">".$pgv_lang["unable_to_create_index"]."</font>";
		exit;
	}
}

//-- check if a gedcom already exists
function check_dataset($FILE) {
	global $INDEX_DIRECTORY, $FP, $pgv_lang;
	$indexfile = $INDEX_DIRECTORY.$FILE."_index.php";
	if (filesize($indexfile)>0) return true;
	return false;
}

//-- erase the data for a gedcom file
function empty_database($FILE) {
	global $INDEX_DIRECTORY, $FP, $pgv_lang;

	$indexfile = $INDEX_DIRECTORY.$FILE."_index.php";
	fclose($FP);
	$FP = fopen($indexfile, "wb");
//	fwrite($FP, "<?php\r\n\$indilist = array();\r\n\$famlist = array();\r\n\$sourcelist = array();\r\n\$otherlist = array();\r\n\r\n");
	if (!$FP) {
		print "<font class=\"error\">".$pgv_lang["unable_to_create_index"]."</font>";
		exit;
	}
}

//-- cleanup the database
function cleanup_database() {
	global $FP, $indilist, $famlist, $sourcelist, $otherlist;

	/*$lists = array("indilist"=>$indilist, "famlist"=>$famlist, "sourcelist"=>$sourcelist, "otherlist"=>$otherlist);
	fwrite($FP, serialize($lists));
	*/
	fwrite($FP, 'a:4:{s:8:"indilist";');
	fwrite($FP, serialize($indilist));
	fwrite($FP, 's:7:"famlist";');
	fwrite($FP, serialize($famlist));
	fwrite($FP, 's:10:"sourcelist";');
	fwrite($FP, serialize($sourcelist));
	fwrite($FP, 's:9:"otherlist";');
	fwrite($FP, serialize($otherlist));
	fwrite($FP, '}');
	fclose($FP);
}

//-- get the indilist from the datastore
function get_indi_list() {
	global $indilist;

	return $indilist;
}

//-- get the famlist from the datastore
function get_fam_list() {
	global $famlist;

	return $famlist;
}

//-- get the otherlist from the datastore
function get_other_list() {
	global $otherlist;

	return $otherlist;
}

//-- get the sourcelist from the datastore
function get_source_list() {
	global $sourcelist;

	return $sourcelist;
}

//-- search through the gedcom records for individuals
function search_indis($query) {
	global $indilist;

	$query = preg_replace("'/'", "\\/", $query);
	$myindilist = array();
	foreach($indilist as $gid=>$indi) {
		$ct = preg_match("/($query)/i", $indi["gedcom"], $recmatch);
		if ($ct>0) $myindilist[$gid] = $indi;
	}

	return $myindilist;
}

//-- search through the gedcom records for families
function search_fams($query) {
	global $famlist;

	$query = preg_replace("'/'", "\\/", $query);
	$myfamlist = array();
	foreach($famlist as $gid=>$fam) {
		$ct = preg_match("/($query)/i", $fam["gedcom"], $recmatch);
		$fam["name"] = get_family_descriptor($gid);
		if ($ct>0) $myfamlist[$gid] = $fam;
	}

	return $myfamlist;
}

//-- search through the gedcom records for sources
function search_sources($query) {
	global $sourcelist;

	$query = preg_replace("'/'", "\\/", $query);
	$mysourcelist = array();
	foreach($sourcelist as $gid=>$source) {
		$ct = preg_match("/($query)/i", $source["gedcom"], $recmatch);
		if ($ct>0) $mysourcelist[$gid] = $source;
	}

	return $mysourcelist;
}

function find_places($list) {
	global $placelist, $numfound, $j, $level, $parent, $positions, $found;

	foreach ($list as $key=>$value) {
		print " ";
		// -- put all the places into an array
		$ct = preg_match_all("/\d PLAC (.*)/", $value["gedcom"], $match, PREG_SET_ORDER);
		for($i=0; $i<$ct; $i++) {
			$place = $match[$i][1];
			$place=trim($place);

			$place=preg_replace("/[\"\><']/", "", $place);
			$levels = preg_split ("/,/", $place);		// -- split the place into comma seperated values
			$levels = array_reverse($levels);				// -- reverse the array so that we get the top level first
			$good=true;
			for($k=0; $k<$level; $k++) {
				if (!isset($levels[$k])) $good=false;
				else {
					$levels[$k]=trim($levels[$k]);
					if ($levels[$k]!=$parent[$k]) $good=false;
				}
			}
			if ($good) $positions[] = $key;
			if ((isset($levels[$level]))&&($good)) {
				$numfound++;
				$levels[$level]=trim($levels[$level]);
				/*if(!case_in_array($levels[$level], $placelist)) {
					$placelist[]=$levels[$level];		// -- if it isn't in the array already add it
				}*/
				if (stristr($found, $levels[$level].";")===false) {
					$placelist[]=$levels[$level];
					$found .= $levels[$level]."; ";
				}
			}
		}//--end for
	}//-- end while
}

//-- find all of the places
function get_place_list() {
	global $GEDCOM, $TBLPREFIX, $placelist, $positions, $indilist, $famlist, $sourcelist, $otherlist;

	// --- find all of the place in the file
	find_places($indilist);
	find_places($famlist);
	find_places($sourcelist);
	find_places($otherlist);
	$positions = array_unique($positions);
	$positions = array_values($positions);
}

//-- get all of the place connections
function get_place_positions($parent, $level) {
	global $positions;
	return $positions;
}

function search_places($list, $splace) {
	global $placelist;
	$k=0;
	foreach ($list as $key=>$value) {
		//print " ";
		//if ($k%4000 == 0) print "\n";
		// -- put all the places into an array
		if (empty($splace)) $ct = preg_match_all("/\d PLAC (.*)/", $value["gedcom"], $match, PREG_SET_ORDER);
		else $ct = preg_match_all("/\d PLAC (.*$splace.*)/i", $value["gedcom"], $match, PREG_SET_ORDER);
		for($i=0; $i<$ct; $i++) {
			$place = $match[$i][1];
			$place=trim($place);

			$place=preg_replace("/[\.\"\><]/", "", $place);
			$levels = preg_split ("/,/", $place);		// -- split the place into comma seperated values
			$levels = array_reverse($levels);				// -- reverse the array so that we get the top level first
			$placetext="";
			$j=0;
			foreach($levels as $level) {
				if ($j>0) $placetext .= ", ";
				$placetext .= trim($level);
				$j++;
			}
			$placelist[] = $placetext;
			$k++;
		}//--end for
	}//-- end while
}

//-- find all of the places
function find_place_list($place) {
	global $GEDCOM, $TBLPREFIX, $placelist, $indilist, $famlist, $sourcelist, $otherlist;

	// --- find all of the place in the file
	search_places($indilist, $place);
	search_places($famlist, $place);
	search_places($sourcelist, $place);
	search_places($otherlist, $place);
	$placelist = array_unique($placelist);
	natcasesort($placelist);
}

function findLinkedRecords($query) {
	global $indilist, $famlist, $sourcelist;
	$link = array();

	$sql = array(search_indis($query), search_fams($query), search_sources($query));
	foreach($sql as $list) {
		foreach($list as $key=>$value) {
			preg_match("/0 @(.*)@ (.*)/", $value["gedcom"], $match);
			$gid = $match[1];
			$type = trim($match[2]);
			if ($type=="INDI") {
				if (displayDetailsById($gid)||showLivingNameById($gid)) {
					$link[$gid]=$type;
				}
			}
			else if ($type=="FAM") {
				$parents = find_parents_in_record($value["gedcom"]);
				$disp = false;
				if (displayDetailsById($parents["HUSB"])||showLivingNameById($parents["HUSB"])) {
					$disp = true;
				}
				if ($disp) {
					if (displayDetailsById($parents["WIFE"])||showLivingNameById($parents["WIFE"])) {
						$link[$gid]=$type;
					}
				}
			}
			else $link[$gid]=$type;
		}
	}
	return $link;
}

function find_media($list, $type) {
	global $ct, $medialist, $MEDIA_DIRECTORY, $foundlist, $PGV_IMAGE_DIR, $PGV_GEDCOM_IMG;

	foreach ($list as $key=>$value) {
		print " ";
		find_media_in_record($value["gedcom"]);
	}
}

//-- find all of the media
function get_media_list() {
	global $GEDCOM, $TBLPREFIX, $medialist, $indilist, $sourcelist, $famlist, $otherlist, $ct;

	$ct=0;
	find_media($indilist, 'INDI');
	find_media($famlist, 'FAM');
	find_media($sourcelist, 'SOUR');
	find_media($otherlist, 'OTHER');
}

//-- get the first character in the list
function get_indi_alpha() {
	global $indilist, $CHARACTER_SET;

	uasort($indilist, "itemsort");
	$indialpha = array();
	foreach($indilist as $gid=>$indi) {
		$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/", "/^[a-z. ]*/"), array("","",""), $indi["name"]);
		$letter = substr($name, 0, 1);
		if ($CHARACTER_SET=="UTF-8") {
			$ord = ord($letter);
			//196 ordinal required for Turkish
			//215 ordinal required for Hebrew
			if ($ord==195 || $ord ==196 || $ord ==215) $letter = substr($indi["name"], 0, 2);
			else $letter = strtoupper($letter);
		}
		else $letter = strtoupper($letter);
		if (!isset($indialpha[$letter])) {
			$indialpha[$letter]= "$gid";
		}
		else {
			$indialpha[$letter] .= ",$gid";
		}
	}

	ksort($indialpha);
	return $indialpha;
}

//-- find all of the individuals who start with the given letter
function get_alpha_indis($letter) {
	global $indialpha, $indilist;

	$tindilist = array();
	$list = $indialpha[$letter];
	$gids = preg_split("/,/", $list);
	foreach($gids as $gid) {
		$tindilist[$gid] = $indilist[$gid];
	}
	return $tindilist;
}

//-- get the first character in the list
function get_fam_alpha() {
	global $famlist, $CHARACTER_SET;

	uasort($famlist, "itemsort");
	$famalpha = array();
	foreach($famlist as $gid=>$fam) {
		$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/", "/^[a-z. ]*/"), array("","",""), $fam["name"]);
		$letter = substr($name, 0, 1);
		if ($CHARACTER_SET=="UTF-8") {
			$ord = ord($letter);
			//196 ordinal required for Turkish
			//215 ordinal required for Hebrew
			if ($ord==195 || $ord ==196 || $ord ==215) $letter = substr($fam["name"], 0, 2);
			else $letter = strtoupper($letter);
		}
		else $letter = strtoupper($letter);
		if (!isset($famalpha[$letter])) {
			$famalpha[$letter]= "$gid";
		}
		else {
			$famalpha[$letter] .= ",$gid";
		}
	}
	ksort($famalpha);
	return $famalpha;
}

//-- find all of the individuals who start with the given letter
function get_alpha_fams($letter) {
	global $famalpha, $famlist;

	$tfamlist = array();
	$list = $famalpha[$letter];
	$gids = preg_split("/,/", $list);
	foreach($gids as $gid) {
		$tfamlist[$gid] = $famlist[$gid];
	}
	return $tfamlist;
}

//-- function to find the gedcom id for the given rin
function find_rin_id($rin) {
	global $indilist;

	foreach($indilist as $gid=>$indi) {
		if ($indi["rin"]==$rin) return $gid;
	}
	return $rin;
}

function delete_gedcom($ged) {
	global $INDEX_DIRECTORY, $favorites;

	if (isset($pgv_changes)) {
		//-- erase any of the changes
		foreach($pgv_changes as $cid=>$changes) {
			if ($changes[0]["gedcom"]==$ged) unset($pgv_changes[$cid]);
		}
		write_changes();
		$oldfavs = $favorites;
		if (!empty($favorites)) {
			foreach($oldfavs as $fv_id=>$fav) {
				if ($fav["file"]==$ged) deleteFavorite($fv_id);
			}
		}
	}

	@unlink($INDEX_DIRECTORY.$ged."_conf.php");
	@unlink($INDEX_DIRECTORY.$ged."_index.php");
}
?>