<?php
/*=================================================
	Project: phpGedView
	File: gdbi.php
	Author:
		John Finlay 	(yalnifj)
	Comments:
		This file defines a protocol for interfacing
		GDBI requests over a http connection.
		When $action is 'get' then the gedcom record with 
		the given $xref is retrieved.  When $action is 'update'
		the gedcom record matching $xref is replaced with the
		data in $gedrec.  When $action is 'append' the gedcom 
		record in $gedrec is appended to the end of the
		gedcom file.  When action is 'delete' the gedcom
		record with $xref is removed from the file.

	Change Log:
		File Created: 4/29/03
		
    phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: gdbi.php,v 1.36.2.1 2004/01/26 22:33:33 yalnifj Exp $
require "config.php";
require $PGV_BASE_DIRECTORY."gdbi_functions.php";
header("Content-Type: text/plain; charset=$CHARACTER_SET");

$pgv_user = getUserName();

if (empty($action)) {
	print "ERROR 1: No action specified.\n";
}
else if ($action=='version') {
	print "SUCCESS\n$VERSION $VERSION_RELEASE\n";
}
else if ($action=='connect') {
	if (!empty($username)) {
		$userStat = authenticateUser($username,$password);
		if (!$userStat) {
			print "ERROR 10: Username and password key failed to authenticate.";
		}
		else {
			$canedit = userCanEdit($username);
			if ($canedit) {
				$stat = newConnection();
				if ($stat!==false) print "SUCCESS\n".$stat;
			}
			else {
				print "ERROR 11: Username $username does not have write permissions.\n";
			}
		}
	}
	else {
		print "ERROR 9: Could not connect to GEDCOM.  No username specified.\n";
	}
}
else if (empty($pgv_user)){
	print "ERROR 12: use 'connect' action to initiate a session.\n";
}
else if ($action=='listgedcoms') {
	print "SUCCESS\n";
	foreach($GEDCOMS as $ged=>$gedarray) {
		print "$ged\t".$gedarray["title"]."\n";
	}
}
else if ($action=='get') {
	if (!empty($xref)) {
		$xrefs = preg_split("/;/", $xref);
		$success = true;
		$gedrecords="";
		foreach($xrefs as $xref1) {
			$gedrec = "";
			$xref1 = trim($xref1);
			if (!empty($xref1)) {
				if (isset($pgv_changes[$xref1."_".$GEDCOM])) $gedrec = @find_record_in_file($xref1);
				if (empty($gedrec)) $gedrec = @find_gedcom_record($xref1);
				if (!empty($gedrec)) {
					$gedrec = trim($gedrec);
					preg_match("/0 @(.*)@ (.*)/", $gedrec, $match);
					$type = trim($match[2]);
					if ($type=='INDI') {
						if (displayDetails($gedrec)) $gedrecords = $gedrecords . "\n".$gedrec;
						else {
							$success=false;
							print "ERROR 18: Access denied for individual xref:$xref1.\n";
						}
					}
					else $gedrecords = $gedrecords . "\n".$gedrec;
				}
				else {
					$success=false;
					print "\nERROR 4: Could not find gedcom record with xref:$xref1\n";
				}
			}
		} //-- end for loop
		if ($success) {
			$ct = preg_match_all("/ FILE (.*)/", $gedrecords, $match, PREG_SET_ORDER);
			for($i=0; $i<$ct; $i++) {
				$mediaurl = $SERVER_URL.$MEDIA_DIRECTORY.extract_filename($match[$i][1]);
				$gedrecords = str_replace($match[$i][1], $mediaurl, $gedrecords);
			}
			print "SUCCESS\n".trim($gedrecords);
		}
	}
	else {
		print "ERROR 3: No gedcom id specified.  Please specify a xref.\n";
	}
}
else if ($action=='getvar') {
	if ((!empty($var))&&(isset($$var))) {
		print "SUCCESS\n".$$var;
	}
	else {
		print "ERROR 13: Invalid variable specified.  Please provide a variable.\n";
	}
}
else if ($action=='update') {
	if (!empty($xref)) {
		if (!empty($gedrec)) {
			$gedrec = preg_replace(array("/\\\\+r/","/\\\\+n/"), array("\r","\n"), $gedrec);
			$success = replace_gedrec($xref, $gedrec);
			if ($success) print "SUCCESS\n";
		}
		else {
			print "ERROR 8: No gedcom record provided.  Unable to process request.\n";
		}
	}
	else {
		print "ERROR 3: No gedcom id specified.  Please specify a xref.\n";
	}
}
else if ($action=='append') {
	if (!empty($gedrec)) {
		$gedrec = preg_replace(array("/\\\\+r/","/\\\\+n/"), array("\r","\n"), $gedrec);
		$xref = append_gedrec($gedrec);
		if ($xref) print "SUCCESS\n$xref\n";
	}
	else {
		print "ERROR 8: No gedcom record provided.  Unable to process request.\n";
	}
}
else if ($action=='delete') {
	if (!empty($xref)) {
		$success = delete_gedrec($xref);
		if ($success) print "SUCCESS\n";
	}
	else {
		print "ERROR 3: No gedcom id specified.  Please specify a xref.\n";
	}
}
else if ($action=='getnext') {
	$myindilist = get_indi_list();
	$gedrec="";
	if (!empty($xref)) {
		$xref1 = get_next_xref($xref);
		if (isset($pgv_changes[$xref1."_".$GEDCOM])) $gedrec = @find_record_in_file($xref1);
		if (empty($gedrec)) $gedrec = @find_gedcom_record($xref1);
		print "SUCCESS\n".trim($gedrec);
	}
	else {
		print "ERROR 3: No gedcom id specified.  Please specify a xref.\n";
	}
}
else if ($action=='getprev') {
	$myindilist = get_indi_list();
	$gedrec="";
	if (!empty($xref)) {
		$xref1 = get_prev_xref($xref);
		if (isset($pgv_changes[$xref1."_".$GEDCOM])) $gedrec = @find_record_in_file($xref1);
		if (empty($gedrec)) $gedrec = @find_gedcom_record($xref1);
		print "SUCCESS\n".trim($gedrec);
	}
	else {
		print "ERROR 3: No gedcom id specified.  Please specify a xref.\n";
	}
}
else if ($action=='search') {
	if (!empty($query)) {
		$sindilist = search_indis($query);
		uasort($sindilist, "itemsort");
		print "SUCCESS\n";
		foreach($sindilist as $xref=>$indi) {
			print "$xref\n";
		}
	}
	else {
		print "ERROR 15: No query specified.  Please specify a query.\n";
	}
}
else if ($action=='soundex') {
	if ((!empty($lastname))||(!empty($firstname))) {
		$myindilist = get_indi_list();
		$sindilist = array();
		// -- only get the names who match soundex
		foreach ($myindilist as $key => $value) {
			$save = false;
			$name = preg_replace("/ [jJsS]r\.?,/", ",", $value["name"]);
			$names = preg_split("/,/", $name);
			if (soundex($names[0])==soundex($lastname)) {
				$save = true;
				if (!empty($firstname)) {
					$save = false;
					$firstnames = preg_split("/\s/", trim($firstname));
					if (isset($names[1])) $fnames = preg_split("/\s/", trim($names[1]));
					else $fnames = preg_split("/\s/", trim($names[0]));
					for($i=0; $i<count($fnames); $i++) {
						for($j=0; $j<count($firstnames); $j++) {
							if (soundex($fnames[$i])==soundex($firstnames[$j])) $save = true;
						}
					}
				}
			}
			if ($save) $sindilist["$key"] = $value;
		}
		print "SUCCESS\n";
		uasort($sindilist, "itemsort");
		reset($sindilist);
		foreach($sindilist as $xref=>$indi) {
			print "$xref\n";
		}
	}
	else {
		print "ERROR 16: No names specified.  Please specify a firstname or a lastname.\n";
	}
}
else if ($action=='getxref') {
	if (empty($position)) $position='first';
	if (empty($type)) $type='INDI';
	if ((empty($type))||(!in_array($type, array("INDI","FAM","SOUR","REPO","NOTE","OBJE","OTHER")))) {
		print "ERROR 18: Invalid \$type specification.  Valid types are INDI, FAM, SOUR, REPO, NOTE, OBJE, or OTHER\n";
		exit;
	}
	$myindilist = array();
	if ($type!="OTHER") {
		$ct = preg_match_all("/0 @(.*)@ $type/", $fcontents, $match, PREG_SET_ORDER);
		for($i=0; $i<$ct; $i++) {
			$xref1 = trim($match[$i][1]);
			$myindilist[$xref1] = $xref1;
		}
	}
	else {
		$ct = preg_match_all("/0 @(.*)@ (.*)/", $fcontents, $match, PREG_SET_ORDER);
		for($i=0; $i<$ct; $i++) {
			$xref1 = trim($match[$i][1]);
			$xtype = trim($match[$i][2]);
			if (($xtype!="INDI")&&($xtype!="FAM")&&($xtype!="SOUR")) $myindilist[$xref1] = $xref1;
		}
	}
	reset($myindilist);
	if ($position=='first') {
		$xref = current($myindilist);
		print "SUCCESS\n$xref\n";
	}
	else if ($position=='last') {
		$xref = end($myindilist);
		print "SUCCESS\n$xref\n";
	}
	else if ($position=='next') {
		if (!empty($xref)) {
			$xref1 = get_next_xref($xref, $type);
			if ($xref1!==false) print "SUCCESS\n$xref1\n";
		}
		else {
			print "ERROR 3: No gedcom id specified.  Please specify a xref.\n";
		}
	}
	else if ($position=='prev') {
		if (!empty($xref)) {
			$xref1 = get_prev_xref($xref, $type);
			if ($xref1!==false) print "SUCCESS\n$xref1\n";
		}
		else {
			print "ERROR 3: No gedcom id specified.  Please specify a xref.\n";
		}
	}
	else if ($position=='all') {
		print "SUCCESS\n";
		foreach($myindilist as $key=>$value) {
			print "$key\n";
		}
	}
	else if ($position=='new') {
		if ((empty($type))||(!in_array($type, array("INDI","FAM","SOUR","REPO","NOTE","OBJE","OTHER")))) {
			print "ERROR 18: Invalid \$type specification.  Valid types are INDI, FAM, SOUR, REPO, NOTE, OBJE, or OTHER\n";
			exit;
		}
		$gedrec = "0 @REF@ $type";
		$xref = append_gedrec($gedrec);
		if ($xref) print "SUCCESS\n$xref\n";
	}
	else {
		print "ERROR 17: Unknown position reference.  Valid values are first, last, prev, next.\n";
	}
}
else if ($action=="uploadmedia") {
	$error="";
	$upload_errors = array($pgv_lang["file_success"], $pgv_lang["file_too_big"], $pgv_lang["file_too_big"],$pgv_lang["file_partial"], $pgv_lang["file_missing"]);
	if (isset($_FILES['mediafile'])) {
		if (!move_uploaded_file($_FILES['mediafile']['tmp_name'], $MEDIA_DIRECTORY.$_FILES['mediafile']['name'])) {
			$error .= "ERROR 19: ".$pgv_lang["upload_error"]." ".$upload_errors[$_FILES['mediafile']['error']];
		}
	}
	if (isset($_FILES['thumbnail'])) {
		if (!move_uploaded_file($_FILES['thumbnail']['tmp_name'], $MEDIA_DIRECTORY."thumbs/".$_FILES['thumbnail']['name'])) {
			$error .= "\nERROR 19: ".$pgv_lang["upload_error"]." ".$upload_errors[$_FILES['thumbnail']['error']];
		}
	}
	if (!empty($error)) print $error."\n"; 
	else {
		print "SUCCESS\n";
	}
}
else {
	print "ERROR 2: Unable to process request.  Unknown action.\n";
}
?>