<?php
/***********************************************************
	File: gdbi_interface.php
	Project: phpGedView
	Author: John Finlay
	Dependencies: ldslit MySQL Database, lit_functions.php
	Posts to: none
	Incoming Variables: none
	Outgoing Variables: none
	Comments:
		Popup window that will allow a user to search for a work id

	Change Log:
		9/03/02 - File Created (JRF)
		5/30/03 - Added search filter and birth dates

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

***********************************************************/
# $Id: gdbi_interface.php,v 1.45.2.2 2004/01/29 18:29:26 yalnifj Exp $
require("config.php");
require("gdbi_functions.php");
require($PGV_BASE_DIRECTORY.$factsfile["english"]);
require($PGV_BASE_DIRECTORY.$factsfile[$LANGUAGE]);

if (!isset($action)) $action="";
if (!isset($linenum)) $linenum="";

$textfacts = array("CAST","DSCR","EDUC","IDNO","NATI","NCHI","NMR","OCCU","PROP","RELI","RESI","SSN","TITL", "_MILI");
$emptyfacts = array("BIRT","CHR","DEAT","BURI","CREM","ADOP","BAPM","BARM","BASM","BLES","CHRA","CONF","FCOM","ORDN","NATU","EMIG","IMMI","CENS","PROB","WILL","GRAD","RETI","BAPL","CONL","ENDL","SLGC","EVEN","MARR","SLGS","MARL","ANUL","CENS","DIV","DIVF","ENGA","MARB","MARC","MARS","OBJE","CHAN");
$templefacts = array("SLGC","SLGS","BAPL","ENDL","CONL");
$nondatefacts = array("OBJE","NOTE","SOUR");

print_simple_header("GDBI Interface 1.0b");

?>
<script language="JavaScript">
var pastefield;
function findPlace(field) {
	pastefield = field;
	window.open('findplace.php?place='+field.value, '', 'top=55,left=55,width=500,height=500,scrollbars=1,resizeable=1');
	return false;
}
function findMedia(field) {
	pastefield = field;
	window.open('findmedia.php', '', 'top=55,left=55,width=500,height=500,scrollbars=1,resizeable=1');
	return false;
}
function findSource(field) {
	pastefield = field;
	window.open('findsource.php', '', 'top=55,left=55,width=500,height=500,scrollbars=1,resizeable=1');
	return false;
}
function findFamily(field) {
	pastefield = field;
	window.open('findfamily.php', '', 'top=55,left=55,width=500,height=500,scrollbars=1,resizeable=1');
	return false;
}
function pasteid(value) {
	pastefield.value = value;
}
</script>
<?php
//-- check if user has acces to the gedcom record
$disp = false;
if (!empty($pid)){
	if (!isset($pgv_changes[$pid."_".$GEDCOM])) $gedrec = find_gedcom_record($pid);
	else $gedrec = find_record_in_file($pid);
	$ct = preg_match("/0 @$pid@ (.*)/", $gedrec, $match);
	if ($ct>0) {
		$type = trim($match[1]);
		//-- if the record is for an INDI then check for display privileges for that indi
		if ($type=="INDI") {
			$disp = displayDetailsById($pid);
		}
		//-- for FAM check for display privileges on both parents
		else if ($type=="FAM") {
			//-- check if we can display both parents
			$parents = find_parents_in_record($gedrec);
			$disp = displayDetailsById($parents["HUSB"]);
			if ($disp) {
				$disp = displayDetailsById($parents["WIFE"]);
			}
		}
		else {
			$disp=true;
		}
	}
}
else {
	print "<span class=\"error\">The \$pid variable was empty.  Unable to perform $action.</span>";
	print_simple_footer();
	$disp = true;
}

if ((!userCanEdit(getUserName()))||(!$disp)||(!$ALLOW_EDIT_GEDCOM)) {
	//print "pid: $pid<br />";
	//print "gedrec: $gedrec<br />";
	print $pgv_lang["access_denied"];
	print_simple_footer();
	exit;
}

if (!isset($type)) $type="";
if ($type=="INDI") {
	print "<b>".stripslashes(get_person_name($pid))."</b>";
}
else if ($type=="FAM") {
	print "<b>".get_person_name($parents["HUSB"])." + ".get_person_name($parents["WIFE"])."</b>";
}
else if ($type=="SOUR") {
	print "<b>".get_source_descriptor($pid)."</b>";
}
else if (strstr($action,"addchild")) {
	print "<b>".$pgv_lang["add_child"]."</b>\n";
}
else if (strstr($action,"addspouse")) {
	print "<b>".$pgv_lang["add_".strtolower($tag)]."</b>\n";
}
else {
	print "<b>".$factarray[$type]."</b>";
}

if ($action=="delete") {
	if (!empty($linenum)) {
		if ($linenum==0) {
			if (delete_gedrec($pid)) print $pgv_lang["gedrec_deleted"];
		}
		else {
			$gedlines = preg_split("/\n/", $gedrec);
			$newged = "";
			for($i=0; $i<$linenum; $i++) {
				$newged .= $gedlines[$i]."\n";
			}
			if (isset($gedlines[$linenum])) {
				$fields = preg_split("/\s/", $gedlines[$linenum]);
				$glevel = $fields[0];
				$i++;
				if ($i<count($gedlines)) {
					while((isset($gedlines[$i]))&&($gedlines[$i]{0}>$glevel)) $i++;
					while($i<count($gedlines)) {
						$newged .= $gedlines[$i]."\n";
						$i++;
					}
				}
			}
			if (replace_gedrec($pid, $newged)) print "<br /><br />".$pgv_lang["gedrec_deleted"];
		}
	}
}
else if ($action=="edit") {
	print "<form method=\"post\" action=\"gdbi_interface.php\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"update\">\n";
	print "<input type=\"hidden\" name=\"linenum\" value=\"$linenum\">\n";
	print "<input type=\"hidden\" name=\"pid\" value=\"$pid\">\n";
	print "<table class=\"facts_table\">";
	$gedlines = split("\n", $gedrec);	// -- find the number of lines in the record
	$fields = preg_split("/\s/", $gedlines[$linenum]);
	$glevel = $fields[0];
	$level = $glevel;
	$type = trim($fields[1]);
	$level1type = $type;
	$tags=array();
	$i = $linenum;
	do {
		$text = "";
		for($j=2; $j<count($fields); $j++) {
			if ($j>2) $text .= " ";
			$text .= $fields[$j];
		}
		$iscont = false;
		while(($i+1<count($gedlines))&&(preg_match("/".($level+1)." (CON[CT])\s?(.*)/", $gedlines[$i+1], $cmatch)>0)) {
			$iscont=true;
			if ($cmatch[1]=="CONT") $text.="\r\n";
			if ($WORD_WRAPPED_NOTES) $text .= " ";
			$text .= $cmatch[2];
			$i++;
		}
		$islink = 0;
		if (preg_match("/^@(.*)@/", $text)>0) $islink=1;
		print "<tr><td class=\"facts_label\"><input type=\"hidden\" name=\"glevels[]\" value=\"$level\"><input type=\"hidden\" name=\"islink[]\" value=\"$islink\"><input type=\"hidden\" name=\"tag[]\" value=\"$type\">";
		if (isset($factarray["$type"])) print $factarray["$type"];
		else print $type;
		print "</td>";
		$tags[]=$type;
		print "<td class=\"facts_value\">";
		if (!empty($text)) {
			if ($type=="TEMP") {
				print "<select name=\"text[]\">\n";
				print "<option value=\"\">".$pgv_lang["no_temple"]."</option>\n";
				foreach($TEMPLE_CODES as $code=>$temple) {
					print "<option value=\"$code\"";
					if ($code==trim($text)) print " selected";
					print ">$temple</option>\n";
				}
				print "</select>\n";
			}
			else if ($type=="SOUR") {
				$ct = preg_match("/@(.*)@/", $text, $smatch);
				if ($ct>0) {
					$sname = get_source_descriptor($smatch[1]);
					print "<input type=\"text\" id=\"text$i\" size=\"3\" name=\"text[]\" value=\"$smatch[1]\">\n";
					print "<a href=\"#\" onclick=\"return findSource(document.getElementById('text$i'));\">".$pgv_lang["find_id"]."</a> ";
					print $sname;
				}
			}
			else if (($type=="NOTE")&&($islink)) {
				$ct = preg_match("/@(.*)@/", $text, $smatch);
				if ($ct>0) {
					print "<input type=\"hidden\" name=\"text[]\" value=\"$smatch[1]\">\n";
					$noterec = find_gedcom_record($smatch[1]);
					$nt = preg_match("/0 @$smatch[1]@ NOTE (.*)/", $noterec, $n1match);
					print "<textarea name=\"NOTE[$smatch[1]]\" rows=\"8\" cols=\"50\">";
					if ($nt>0) print trim($n1match[1]);
					print preg_replace("/<br \/>/", "", get_cont(1, $noterec));
					print "\n</textarea>\n";
				}
			}
			else {
				if ((!$iscont)&&($type!="NOTE")) print "<input id=\"text$i\" type=\"text\" name=\"text[]\" size=\"40\" value=\"$text\">\n";
				else print "<textarea id=\"text$i\" name=\"text[]\" rows=\"4\" cols=\"50\">$text</textarea>\n";
			}
			if ($type=="PLAC") {
				print " <a href=\"#\" onclick=\"return findPlace(document.getElementById('text$i'));\">".$pgv_lang["find_place"]."</a>\n";
			}
		}
		else {
			print "<input type=\"hidden\" name=\"text[]\" value=\"$text\">\n";
		}
		print "</td></tr>\n";
		$i++;
		if (isset($gedlines[$i])) {
			$fields = preg_split("/\s/", $gedlines[$i]);
			$level = $fields[0];
			if (isset($fields[1])) $type = trim($fields[1]);
		}
	} while (($level>$glevel)&&($i<count($gedlines)));
	if (in_array($tags[0], $templefacts)) {
		if (!in_array("TEMP", $tags)) {
			//-- temple
			print "<tr><td class=\"facts_label\"><input type=\"hidden\" name=\"glevels[]\" value=\"2\"><input type=\"hidden\" name=\"islink[]\" value=\"0\"><input type=\"hidden\" name=\"tag[]\" value=\"TEMP\">".$factarray["TEMP"]."</td>";
			print "<td class=\"facts_value\">";
			print "<select name=\"text[]\">\n";
			print "<option value=\"\">".$pgv_lang["no_temple"]."</option>\n";
			foreach($TEMPLE_CODES as $code=>$temple) {
				print "<option value=\"$code\"";
				if ($code==trim($text)) print " selected";
				print ">$temple</option>\n";
			}
			print "</select>\n";
			print "</td></tr>";
		}
	}

	if (!in_array($level1type, $nondatefacts)) {
		if (!in_array("DATE", $tags)) {
			//-- date
			print "<tr><td class=\"facts_label\"><input type=\"hidden\" name=\"glevels[]\" value=\"2\"><input type=\"hidden\" name=\"islink[]\" value=\"0\"><input type=\"hidden\" name=\"tag[]\" value=\"DATE\">".$factarray["DATE"]."</td>";
			print "<td class=\"facts_value\">";
			print "<input type=\"text\" name=\"text[]\">\n";
			print "</td></tr>";
		}
		if (!in_array("PLAC", $tags)) {
			//-- place
			print "<tr><td class=\"facts_label\"><input type=\"hidden\" name=\"glevels[]\" value=\"2\"><input type=\"hidden\" name=\"islink[]\" value=\"0\"><input type=\"hidden\" name=\"tag[]\" value=\"PLAC\">".$factarray["PLAC"]."</td>";
			print "<td class=\"facts_value\">";
			print "<input type=\"text\" id=\"place\" name=\"text[]\">\n";
			print " <a href=\"#\" onclick=\"return findPlace(document.getElementById('place'));\">".$pgv_lang["find_place"]."</a>\n";
			print "</td></tr>";
		}
	}
	print "</table>";
	//-- Add new source to fact
	print "<a href=\"#\" onclick=\"return expand_layer('newsource');\"><img id=\"newsource_img\" src=\"$PGV_IMAGE_DIR/$PGV_PLUS_IMG\" border=\"0\" width=\"11\" height=\"11\" alt=\"\" />".$pgv_lang["add_source"]."</a><br />";
	print "<div id=\"newsource\" style=\"display: none;\">\n";
	print "<table class=\"facts_table\">\n";
	print "<tr><td class=\"facts_label\">".$pgv_lang["source"];
	print "<input type=\"hidden\" name=\"glevels[]\" value=\"2\">";
	print "<input type=\"hidden\" name=\"islink[]\" value=\"1\">";
	print "<input type=\"hidden\" name=\"tag[]\" value=\"SOUR\">";
	print "</td>\n";
	print "<td class=\"facts_value\"><input type=\"text\" id=\"newsour\" name=\"text[]\" size=\"5\">";
	print "<a href=\"#\" onclick=\"return findSource(document.getElementById('newsour'));\">".$pgv_lang["find_id"]."</a> ";
	print "</td></tr>\n";
	print "<tr><td class=\"facts_label\">".$factarray["PAGE"];
	print "<input type=\"hidden\" name=\"glevels[]\" value=\"3\">";
	print "<input type=\"hidden\" name=\"islink[]\" value=\"0\">";
	print "<input type=\"hidden\" name=\"tag[]\" value=\"PAGE\">";
	print "</td>\n";
	print "<td class=\"facts_value\"><textarea name=\"text[]\" rows=\"5\" cols=\"50\"></textarea></td></tr>\n";
	print "</table></div>";
	//-- Add new note to fact
	print "<a href=\"#\" onclick=\"return expand_layer('newnote');\"><img id=\"newnote_img\" src=\"$PGV_IMAGE_DIR/$PGV_PLUS_IMG\" border=\"0\" width=\"11\" height=\"11\" alt=\"\" />".$pgv_lang["add_note"]."</a><br />";
	print "<div id=\"newnote\" style=\"display: none;\">\n";
	print "<table class=\"facts_table\">\n";
	print "<tr><td class=\"facts_label\">".$pgv_lang["note"];
	print "<input type=\"hidden\" name=\"glevels[]\" value=\"2\">";
	print "<input type=\"hidden\" name=\"islink[]\" value=\"0\">";
	print "<input type=\"hidden\" name=\"tag[]\" value=\"NOTE\">";
	print "</td>\n";
	print "<td class=\"facts_value\"><textarea name=\"text[]\" rows=\"5\" cols=\"50\"></textarea></td></tr>\n";
	print "</table></div>";
	print "<br /><input type=\"submit\" value=\"".$pgv_lang["save"]."\"><br />\n";
	print "</form>\n";
}
else if ($action=="add") {
	print "<form method=\"post\" action=\"gdbi_interface.php\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"update\">\n";
	print "<input type=\"hidden\" name=\"linenum\" value=\"new\">\n";
	print "<input type=\"hidden\" name=\"pid\" value=\"$pid\">\n";
	print "<table class=\"facts_table\">";
	$islink=0;
	if ($fact=="SOUR") $islink=1;
	print "<tr><td class=\"facts_label\"><input type=\"hidden\" name=\"glevels[]\" value=\"1\"><input type=\"hidden\" name=\"islink[]\" value=\"$islink\"><input type=\"hidden\" name=\"tag[]\" value=\"$fact\">".$factarray["$fact"]."</td>";
	print "<td class=\"facts_value\">";
	if (in_array($fact, $textfacts)) {
		print "<input type=\"text\" name=\"text[]\" size=\"40\">\n";
	}
	else if ($fact=="NOTE") {
		print "<textarea name=\"text[]\" rows=\"7\" cols=\"50\"></textarea>\n";
	}
	else if ($fact=="SOUR") {
		print "<input type=\"text\" id=\"newsour\" name=\"text[]\" size=\"5\">\n";
		print "<a href=\"#\" onclick=\"return findSource(document.getElementById('newsour'));\">".$pgv_lang["find_id"]."</a> ";
	}
	else {
		print "<input type=\"hidden\" name=\"text[]\" value=\"\">\n";
	}
	print "</td></tr>";
	if ($fact=="EVEN") {
		//-- custom event type
		print "<tr><td class=\"facts_label\"><input type=\"hidden\" name=\"glevels[]\" value=\"2\"><input type=\"hidden\" name=\"islink[]\" value=\"0\"><input type=\"hidden\" name=\"tag[]\" value=\"TYPE\">".$factarray["TYPE"]."</td>";
		print "<td class=\"facts_value\">";
		print "<input type=\"text\" name=\"text[]\">\n";
		print "</td></tr>";
	}
	if (in_array($fact, $templefacts)) {
		//-- temple
		print "<tr><td class=\"facts_label\"><input type=\"hidden\" name=\"glevels[]\" value=\"2\"><input type=\"hidden\" name=\"islink[]\" value=\"0\"><input type=\"hidden\" name=\"tag[]\" value=\"TEMP\">".$factarray["TEMP"]."</td>";
		print "<td class=\"facts_value\">";
		print "<select name=\"text[]\">\n";
		print "<option value=\"\">".$pgv_lang["no_temple"]."</option>\n";
		if (!isset($text)) $text = "";
		foreach($TEMPLE_CODES as $code=>$temple) {
			print "<option value=\"$code\"";
			if ($code==trim($text)) print " selected";
			print ">$temple</option>\n";
		}
		print "</select>\n";
		print "</td></tr>";
	}
	if ($fact=="OBJE") {
		print "<tr><td class=\"facts_label\"><input type=\"hidden\" name=\"glevels[]\" value=\"2\"><input type=\"hidden\" name=\"islink[]\" value=\"0\"><input type=\"hidden\" name=\"tag[]\" value=\"FORM\">".$factarray["FORM"]."</td>";
		print "<td class=\"facts_value\">";
		print "<input type=\"text\" name=\"text[]\">\n";
		print "</td></tr>";
		print "<tr><td class=\"facts_label\"><input type=\"hidden\" name=\"glevels[]\" value=\"2\"><input type=\"hidden\" name=\"islink[]\" value=\"0\"><input type=\"hidden\" name=\"tag[]\" value=\"FILE\">".$factarray["FILE"]."</td>";
		print "<td class=\"facts_value\">";
		print "<input type=\"text\" name=\"text[]\" size=\"40\" id=\"file\">\n";
		print " <a href=\"#\" onclick=\"return findMedia(document.getElementById('file'));\">".$pgv_lang["find_media"]."</a>\n";
		print "</td></tr>";
		print "<tr><td class=\"facts_label\"><input type=\"hidden\" name=\"glevels[]\" value=\"2\"><input type=\"hidden\" name=\"islink[]\" value=\"0\"><input type=\"hidden\" name=\"tag[]\" value=\"TITL\">".$factarray["TITL"]."</td>";
		print "<td class=\"facts_value\">";
		print "<input type=\"text\" name=\"text[]\" size=\"40\">\n";
		print "</td></tr>";
	}
	if ($fact=="SOUR") {
		print "<tr><td class=\"facts_label\">".$factarray["PAGE"];
		print "<input type=\"hidden\" name=\"glevels[]\" value=\"2\">";
		print "<input type=\"hidden\" name=\"islink[]\" value=\"0\">";
		print "<input type=\"hidden\" name=\"tag[]\" value=\"PAGE\">";
		print "</td>\n";
		print "<td class=\"facts_value\"><textarea name=\"text[]\" rows=\"5\" cols=\"50\"></textarea></td></tr>\n";
	}
	if (!in_array($fact, $nondatefacts)) {
		//-- date
		print "<tr><td class=\"facts_label\"><input type=\"hidden\" name=\"glevels[]\" value=\"2\"><input type=\"hidden\" name=\"islink[]\" value=\"0\"><input type=\"hidden\" name=\"tag[]\" value=\"DATE\">".$factarray["DATE"]."</td>";
		print "<td class=\"facts_value\">";
		print "<input type=\"text\" name=\"text[]\">\n";
		print "</td></tr>";
		//-- place
		print "<tr><td class=\"facts_label\"><input type=\"hidden\" name=\"glevels[]\" value=\"2\"><input type=\"hidden\" name=\"islink[]\" value=\"0\"><input type=\"hidden\" name=\"tag[]\" value=\"PLAC\">".$factarray["PLAC"]."</td>";
		print "<td class=\"facts_value\">";
		print "<input type=\"text\" id=\"place\" name=\"text[]\">\n";
		print " <a href=\"#\" onclick=\"return findPlace(document.getElementById('place'));\">".$pgv_lang["find_place"]."</a>\n";
		print "</td></tr>";
	}
	print "</table>";
	//-- Add new source to fact
	if ($fact!="SOUR") {
		print "<a href=\"#\" onclick=\"return expand_layer('newsource');\"><img id=\"newsource_img\" src=\"$PGV_IMAGE_DIR/$PGV_PLUS_IMG\" border=\"0\" width=\"11\" height=\"11\" alt=\"\" />".$pgv_lang["add_source"]."</a><br />";
		print "<div id=\"newsource\" style=\"display: none;\">\n";
		print "<table class=\"facts_table\">\n";
		print "<tr><td class=\"facts_label\">".$pgv_lang["source"];
		print "<input type=\"hidden\" name=\"glevels[]\" value=\"2\">";
		print "<input type=\"hidden\" name=\"islink[]\" value=\"1\">";
		print "<input type=\"hidden\" name=\"tag[]\" value=\"SOUR\">";
		print "</td>\n";
		print "<td class=\"facts_value\"><input type=\"text\" id=\"newsour\" name=\"text[]\" size=\"5\">";
		print "<a href=\"#\" onclick=\"return findSource(document.getElementById('newsour'));\">".$pgv_lang["find_id"]."</a> ";
		print "</td></tr>\n";
		print "<tr><td class=\"facts_label\">".$factarray["PAGE"];
		print "<input type=\"hidden\" name=\"glevels[]\" value=\"3\">";
		print "<input type=\"hidden\" name=\"islink[]\" value=\"0\">";
		print "<input type=\"hidden\" name=\"tag[]\" value=\"PAGE\">";
		print "</td>\n";
		print "<td class=\"facts_value\"><textarea name=\"text[]\" rows=\"5\" cols=\"50\"></textarea></td></tr>\n";
		print "</table></div>";
	}
	//-- Add new note to fact
	if ($fact!="NOTE") {
		print "<a href=\"#\" onclick=\"return expand_layer('newnote');\"><img id=\"newnote_img\" src=\"$PGV_IMAGE_DIR/$PGV_PLUS_IMG\" border=\"0\" width=\"11\" height=\"11\" alt=\"\" />".$pgv_lang["add_note"]."</a><br />";
		print "<div id=\"newnote\" style=\"display: none;\">\n";
		print "<table class=\"facts_table\">\n";
		print "<tr><td class=\"facts_label\">".$pgv_lang["note"];
		print "<input type=\"hidden\" name=\"glevels[]\" value=\"2\">";
		print "<input type=\"hidden\" name=\"islink[]\" value=\"0\">";
		print "<input type=\"hidden\" name=\"tag[]\" value=\"NOTE\">";
		print "</td>\n";
		print "<td class=\"facts_value\"><textarea name=\"text[]\" rows=\"5\" cols=\"50\"></textarea></td></tr>\n";
		print "</table></div>";
	}
	print "<br /><input type=\"submit\" value=\"".$pgv_lang["add_fact"]."\"><br />\n";
	print "</form>\n";
}
else if ($action=="addchild") {
	print_indi_form("addchildaction", $famid);
}
else if ($action=="addspouse") {
	print_indi_form("addspouseaction", $famid, "", $tag);
}
else if ($action=="addfamlink") {
	print "<form method=\"post\" name=\"addchildform\" action=\"gdbi_interface.php\">\n";
        print "<input type=\"hidden\" name=\"action\" value=\"linkfamaction\">\n";
        print "<input type=\"hidden\" name=\"pid\" value=\"$pid\">\n";
	print "<input type=\"hidden\" name=\"tag\" value=\"$tag\">\n";
        print "<table class=\"facts_table\">";
	print "<tr><td class=\"facts_label\">".$pgv_lang["family"]."</td>";
	print "<td class=\"facts_value\"><input type=\"text\" name=\"famid\" size=\"5\">";
	print "<a href=\"#\" onclick=\"findFamily(document.addchildform.famid); return false;\">".$pgv_lang["find_family"]."</a>";
	print "\n</td></tr>";
	print "</table>\n";
        print "<input type=\"submit\" value=\"".$pgv_lang["set_link"]."\"><br />\n";
        print "</form>\n";
}
else if ($action=="linkfamaction") {
	$itag = "FAMC";
	if ($tag=="HUSB" || $tag=="WIFE") $itag="FAMS";
	if (preg_match("/1 $itag @$famid@/", $gedrec)==0) {
		$gedrec = trim($gedrec)."\r\n1 $itag @$famid@";
		replace_gedrec($pid, $gedrec);
	}
	if (!isset($pgv_changes[$famid."_".$GEDCOM])) $gedrec = find_gedcom_record($famid);
        else $gedrec = find_record_in_file($famid);
        if (!empty($gedrec)) {
        	$gedrec = trim($gedrec);
		if (preg_match("/1 $tag @$pid@/", $gedrec)==0) {
	        	$gedrec .= "\r\n1 $tag @$pid@";
        		replace_gedrec($famid, $gedrec);
		}
        }

}
else if ($action=="update") {
	//print_r($glevels);
	//print_r($tag);
	//print_r($text);
	$gedrec = addslashes($gedrec);
	$gedlines = preg_split("/\n/", trim($gedrec));
	//-- for new facts set linenum to number of lines
	if ($linenum=="new") $linenum = count($gedlines);
	$newged = "";
	for($i=0; $i<$linenum; $i++) {
		$newged .= $gedlines[$i]."\n";
	}
	//-- for edits get the level from the line
	if (isset($gedlines[$linenum])) {
		$fields = preg_split("/\s/", $gedlines[$linenum]);
		$glevel = $fields[0];
		$i++;
		while(($i<count($gedlines))&&($gedlines[$i]{0}>$glevel)) $i++;
	}
	for($j=0; $j<count($glevels); $j++) {
		//-- update external note records first
		if (($islink[$j])&&($tag[$j]=="NOTE")) {
			if (empty($NOTE[$text[$j]])) {
				delete_gedrec($text[$j]);
				$text[$j] = "";
			}
			else {
				$noterec = find_gedcom_record($text[$j]);
				$newnote = "0 @$text[$j]@ NOTE\r\n";
				$newline = "1 CONC ".$NOTE[$text[$j]];
				$newlines = preg_split("/\r?\n/", $newline);
				for($k=0; $k<count($newlines); $k++) {
					if ($k>0) $newlines[$k] = "1 CONT ".$newlines[$k];
					if (strlen($newlines[$k])>255) {
						while(strlen($newlines[$k])>255) {
							$newnote .= substr($newlines[$k], 0, 255)."\r\n";
							$newlines[$k] = substr($newlines[$k], 255);
							$newlines[$k] = "1 CONC ".$newlines[$k];
						}
						$newnote .= trim($newlines[$k])."\r\n";
					}
					else {
						$newnote .= trim($newlines[$k])."\r\n";
					}
				}
				$notelines = preg_split("/\r?\n/", $noterec);
				for($k=1; $k<count($notelines); $k++) {
					if (preg_match("/1 CON[CT] /", $notelines[$k])==0) $newnote .= trim($notelines[$k])."\r\n";
				}
				replace_gedrec($text[$j], stripslashes($newnote));
			}
		} //-- end of external note handling code
		if ((!empty($text[$j]))||(in_array($tag[$j], $emptyfacts))) {
			if ($islink[$j]) $text[$j]="@".$text[$j]."@";
			$newline = $glevels[$j]." ".$tag[$j];
			if (!empty($text[$j])) $newline .= " ".$text[$j];
			$newlines = preg_split("/\r?\n/", $newline);
			for($k=0; $k<count($newlines); $k++) {
				if ($k>0) $newlines[$k] = ($glevels[$j]+1)." CONT ".$newlines[$k];
				if (strlen($newlines[$k])>255) {
					while(strlen($newlines[$k])>255) {
						$newged .= substr($newlines[$k], 0, 255)."\r\n";
						$newlines[$k] = substr($newlines[$k], 255);
						$newlines[$k] = ($glevels[$j]+1)." CONC ".$newlines[$k];
					}
					$newged .= trim($newlines[$k])."\r\n";
				}
				else {
					$newged .= trim($newlines[$k])."\r\n";
				}
			}
		}
	}
	while($i<count($gedlines)) {
		$newged .= trim($gedlines[$i])."\r\n";
		$i++;
	}
	if (replace_gedrec($pid, stripslashes($newged))) print "<br /><br />".$pgv_lang["update_successful"];
}
else if ($action=="addchildaction") {
	$gedrec = "0 @REF@ INDI\r\n1 NAME ".trim($NAME)."\r\n";
	if (!empty($NPFX)) $gedrec .= "2 NPFX $NPFX\r\n";
	if (!empty($GIVN)) $gedrec .= "2 GIVN $GIVN\r\n";
	if (!empty($NICK)) $gedrec .= "2 NICK $NICK\r\n";
	if (!empty($SURN)) $gedrec .= "2 SURN $SURN\r\n";
	if (!empty($NSFX)) $gedrec .= "2 NSFX $NSFX\r\n";
	$gedrec .= "1 SEX $SEX\r\n";
	if ((!empty($birthdate))||(!empty($birthplace))) {
		$gedrec .= "1 BIRT\r\n";
		if (!empty($birthdate)) $gedrec .= "2 DATE $birthdate\r\n";
		if (!empty($birthplace)) $gedrec .= "2 PLAC $birthplace\r\n";
	}
	if ((!empty($deathdate))||(!empty($deathplace))) {
		$gedrec .= "1 DEAT\r\n";
		if (!empty($deathdate)) $gedrec .= "2 DATE $deathdate\r\n";
		if (!empty($deathplace)) $gedrec .= "2 PLAC $deathplace\r\n";
	}
	if (!empty($famid)) $gedrec .= "1 FAMC @$famid@\r\n";
	$xref = append_gedrec($gedrec);
	if ($xref) {
		print "<br /><br />".$pgv_lang["update_successful"];
		$gedrec = "";
		if (!empty($famid)) {
			if (!isset($pgv_changes[$famid."_".$GEDCOM])) $gedrec = find_gedcom_record($famid);
			else $gedrec = find_record_in_file($famid);
			if (!empty($gedrec)) {
				$gedrec = trim($gedrec);
				$gedrec .= "\r\n1 CHIL @$xref@";
				replace_gedrec($famid, $gedrec);
			}
		}
	}
}
else if ($action=="addspouseaction") {
	$gedrec = "0 @REF@ INDI\r\n1 NAME ".trim($NAME)."\r\n";
	if (!empty($NPFX)) $gedrec .= "2 NPFX $NPFX\r\n";
	if (!empty($GIVN)) $gedrec .= "2 GIVN $GIVN\r\n";
	if (!empty($NICK)) $gedrec .= "2 NICK $NICK\r\n";
	if (!empty($SURN)) $gedrec .= "2 SURN $SURN\r\n";
	if (!empty($NSFX)) $gedrec .= "2 NSFX $NSFX\r\n";
	$gedrec .= "1 SEX $SEX\r\n";
	if ((!empty($birthdate))||(!empty($birthplace))) {
		$gedrec .= "1 BIRT\r\n";
		if (!empty($birthdate)) $gedrec .= "2 DATE $birthdate\r\n";
		if (!empty($birthplace)) $gedrec .= "2 PLAC $birthplace\r\n";
	}
	if ((!empty($deathdate))||(!empty($deathplace))) {
		$gedrec .= "1 DEAT\r\n";
		if (!empty($deathdate)) $gedrec .= "2 DATE $deathdate\r\n";
		if (!empty($deathplace)) $gedrec .= "2 PLAC $deathplace\r\n";
	}
	$xref = append_gedrec($gedrec);
	if ($xref) print "<br /><br />".$pgv_lang["update_successful"];
	else exit;
	if ($famid=="new") {
		$famrec = "0 @new@ FAM\r\n";
		if ($tag=="HUSB") {
			$famrec .= "1 HUSB @$xref@\r\n";
			$famrec .= "1 WIFE @$pid@\r\n";
		}
		else {
			$famrec .= "1 WIFE @$xref@\r\n";
			$famrec .= "1 HUSB @$pid@\r\n";
		}
		$famid = append_gedrec($famrec);
	}
	else if (!empty($famid)) {
		$famrec = "";
		$famrec = find_record_in_file($famid);
		if (!empty($famrec)) {
			$famrec = trim($famrec);
			$famrec .= "\r\n1 $tag @$xref@\r\n";
			replace_gedrec($famid, $famrec);
		}
	}
	if ((!empty($famid))&&($famid!="new")) {
		$gedrec = "";
		$gedrec = find_record_in_file($xref);
		$gedrec = trim($gedrec);
		$gedrec .= "\r\n1 FAMS @$famid@\r\n";
		replace_gedrec($xref, $gedrec);
	}
	if (!empty($pid)) {
		$indirec="";
		if (!isset($pgv_changes[$famid."_".$GEDCOM])) $indirec = find_gedcom_record($pid);
		else $indirec = find_record_in_file($pid);
		if ($indirec) {
			$indirec = trim($indirec);
			$indirec .= "\r\n1 FAMS @$famid@\r\n";
			replace_gedrec($pid, $indirec);
		}
	}
}
else if ($action=="deleteperson") {
	if (!empty($gedrec)) {
		$success = true;
		$ct = preg_match_all("/1 FAM. @(.*)@/", $gedrec, $match, PREG_SET_ORDER);
		for($i=0; $i<$ct; $i++) {
			$famid = $match[$i][1];
			if (!isset($pgv_changes[$famid."_".$GEDCOM])) $famrec = find_gedcom_record($famid);
			else $famrec = find_record_in_file($famid);
			$lines = preg_split("/\n/", $famrec);
			$newfamrec = "";
			foreach($lines as $line) {
				if (preg_match("/@$pid@/", $line)==0) $newfamrec .= $line."\n";
			}
			//-- if there is not at least two people in a family then the family is deleted
			$pt = preg_match_all("/1 .{4} @(.*)@/", $newfamrec, $pmatch, PREG_SET_ORDER);
			if ($pt<2) {
				for ($j=0; $j<$pt; $j++) {
					$xref = $match[$j][1];
					if($xref!=$pid) {
						if (!isset($pgv_changes[$xref."_".$GEDCOM])) $indirec = find_gedcom_record($xref);
						else $indirec = find_record_in_file($xref);
						$indirec = preg_replace("/1 .* @$famid@\s*/", "", $indirec);
						replace_gedrec($xref, $indirec);
					}
				}
				$success = $success && delete_gedrec($famid);
			}
			else $success = $success && replace_gedrec($famid, $newfamrec);
		}
		if ($success) {
			$success = $success && delete_gedrec($pid);
		}
		if ($success) print "<br /><br />".$pgv_lang["gedrec_deleted"];
	}
}
else if ($action=="deletesource") {
	if (!empty($gedrec)) {
		$success = true;
		$query = "SOUR @$pid@";
		// -- array of names
		$myindilist = array();
		$myfamlist = array();

		$myindilist = search_indis($query);
		foreach($myindilist as $key=>$value) {
			if (!isset($pgv_changes[$key."_".$GEDCOM])) $indirec = $value["gedcom"];
			else $indirec = find_record_in_file($key);
			$lines = preg_split("/\n/", $indirec);
			$newrec = "";
			$skipline = false;
			$glevel = 0;
			foreach($lines as $line) {
				if ((preg_match("/@$pid@/", $line)==0)&&(!$skipline)) $newrec .= $line."\n";
				else {
					if (!$skipline) {
						$glevel = $line{0};
						$skipline = true;
					}
					else {
						if ($line{0}<=$glevel) {
							$skipline = false;
							$newrec .= $line."\n";
						}
					}
				}
			}
			$success = $success && replace_gedrec($key, $newrec);
		}
		$myfamlist = search_fams($query);
		foreach($myfamlist as $key=>$value) {
			if (!isset($pgv_changes[$key."_".$GEDCOM])) $indirec = $value["gedcom"];
			else $indirec = find_record_in_file($key);
			$lines = preg_split("/\n/", $indirec);
			$newrec = "";
			$skipline = false;
			$glevel = 0;
			foreach($lines as $line) {
				if ((preg_match("/@$pid@/", $line)==0)&&(!$skipline)) $newrec .= $line."\n";
				else {
					if (!$skipline) {
						$glevel = $line{0};
						$skipline = true;
					}
					else {
						if ($line{0}<=$glevel) {
							$skipline = false;
							$newrec .= $line."\n";
						}
					}
				}
			}
			$success = $success && replace_gedrec($key, $newrec);
		}
		if ($success) {
			$success = $success && delete_gedrec($pid);
		}
		if ($success) print "<br /><br />".$pgv_lang["gedrec_deleted"];
	}
}
else if ($action=="editname") {
	$gedlines = preg_split("/\n/", trim($gedrec));
	$fields = preg_split("/\s/", $gedlines[$linenum]);
	$glevel = $fields[0];
	$i = $linenum+1;
	$namerec = $gedlines[$linenum];
	while(($i<count($gedlines))&&($gedlines[$i]{0}>$glevel)) {
		$namerec.="\n".$gedlines[$i];
		$i++;
	}
	print_indi_form("editnameaction", "", $namerec);
}
else if ($action=="editnameaction") {
	$gedlines = preg_split("/\n/", trim($gedrec));
	$fields = preg_split("/\s/", $gedlines[$linenum]);
	$glevel = $fields[0];
	$i=0;
	$newged = "";
	while($i<$linenum) {
		$newged = $gedlines[$i]."\n";
		$i++;
	}
	$i = $linenum+1;
	$namerec = $gedlines[$linenum];
	while(($i<count($gedlines))&&($gedlines[$i]{0}>$glevel)) {
		$namerec.="\n".$gedlines[$i];
		$i++;
	}
	$newged .= "1 NAME ".trim($NAME)."\r\n";
	if (!empty($NPFX)) $newged .= "2 NPFX $NPFX\r\n";
	if (!empty($GIVN)) $newged .= "2 GIVN $GIVN\r\n";
	if (!empty($NICK)) $newged .= "2 NICK $NICK\r\n";
	if (!empty($SURN)) $newged .= "2 SURN $SURN\r\n";
	if (!empty($NSFX)) $newged .= "2 NSFX $NSFX\r\n";
	while($i<count($gedlines)) {
		$newged .= trim($gedlines[$i])."\r\n";
		$i++;
	}
	if (replace_gedrec($pid, stripslashes($newged))) print "<br /><br />".$pgv_lang["update_successful"];
}
print "<center><br /><br /><br />";
print "<a href=\"#\" onclick=\"window.opener.showchanges(); window.close();\">".$pgv_lang["close_window"]."</a><br /></center>\n";
print_simple_footer();

?>
