<?php
/*=================================================
	Project: phpGedView
	File: gdbi_test.php
	Author:
		John Finlay 	(yalnifj)
	Comments:
		This file defines a protocol for interfacing
		GDBI requests over a http connection.
		When $action is 'get' then the gedcom record with 
		the given $gid is retrieved.  When $action is 'update'
		the gedcom record matching $gid is replaced with the
		data in $gedrec.  When $action is 'append' the gedcom 
		record in $gedrec is appended to the end of the
		gedcom file.  When action is 'delete' the gedcom
		record with $gid is removed from the file.

	Change Log:
		File Created: 8/7/03
		
    phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: gdbi_test.php,v 1.4 2003/12/09 16:23:49 yalnifj Exp $

?>
<html>
<head>
	<title>GDBI CGAP Simple Client</title>
</head>
<body>
<table>
	<h2>GDBI CGAP Simple Client</h2>
	This is a command tester for the GDBI CGI Gedcom Access Protocol (CGAP).  The CGAP provides a protocol for remote clients to access a web-accessible gedcom datastore through a CGAP server implementation.
	<tr><th>Connect</th></tr>
	<tr><td>
		<form method="post" action="gdbi.php">
			<input type="hidden" name="action" value="connect">
			Username: <input type="text" name="username"><br />
			Password: <input type="password" name="password"><br />
			<input type="submit">
		</form>
	</td></tr>
	<tr><th>Get</th></tr>
	<tr><td>
		<form method="post" action="gdbi.php">
			<input type="hidden" name="action" value="get">
			PHPSESSID: <input type="text" name="PHPSESSID"><br />
			xref: <input type="text" name="xref"><br />
			<input type="submit">
		</form>
	</td></tr>
	<tr><th>Update</th></tr>
	<tr><td>
		<form method="post" action="gdbi.php">
			<input type="hidden" name="action" value="update">
			PHPSESSID: <input type="text" name="PHPSESSID"><br />
			xref: <input type="text" name="xref"><br />
			gedcom: <textarea name="gedrec" rows="10" cols="50"></textarea><br />
			<input type="submit">
		</form>
	</td></tr>
	<tr><th>Append</th></tr>
	<tr><td>
		<form method="post" action="gdbi.php">
			<input type="hidden" name="action" value="append">
			PHPSESSID: <input type="text" name="PHPSESSID"><br />
			gedcom: <textarea name="gedrec" rows="10" cols="50"></textarea><br />
			<input type="submit">
		</form>
	</td></tr>
	<tr><th>Delete</th></tr>
	<tr><td>
		<form method="post" action="gdbi.php">
			<input type="hidden" name="action" value="delete">
			PHPSESSID: <input type="text" name="PHPSESSID"><br />
			xref: <input type="text" name="xref"><br />
			<input type="submit">
		</form>
	</td></tr>
</table>	
</body>
</html>