<?php
/***********************************************************
	File: imageview.php
	Project: phpGedView
	Author: John Finlay
	Posts to: none
	Comments:
		Popup window that will allow a user to search for a place

	Change Log:
		9/03/03 - File Created (yalnifj)

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

***********************************************************/
# $Id: imageview.php,v 1.16 2004/01/08 20:19:00 yalnifj Exp $
require("config.php");

print_simple_header("Image Viewer");
?>
<script type="text/javascript">
	var zoom = 100;
	function zoomin() {
		i = document.getElementById('theimage');
		zoom=zoom+10;
		i.style.width=zoom+'%';
		i.style.height=zoom+'%';
		document.getElementById('zoomval').value=zoom;
	}
	function zoomout() {
		i = document.getElementById('theimage');
		zoom=zoom-10;
		if (zoom<10) zoom=10;
		i.style.width=zoom+'%';
		i.style.height=zoom+'%';
		document.getElementById('zoomval').value=zoom;
	}
	function setzoom(perc) {
		i = document.getElementById('theimage');
		zoom=parseInt(perc);
		if (zoom<10) zoom=10;
		i.style.width=zoom+'%';
		i.style.height=zoom+'%';
	}
	function resetimage() {
		setzoom('100');
		document.getElementById('zoomval').value=zoom;
		i = document.getElementById('theimage');
		i.style.left='0px';
		i.style.top='0px';
	}
	var oldMx = 0;
	var oldMy = 0;
	var movei = "";
	function panimage() {
		if (movei=="") {
			oldMx = msX;
			oldMy = msY;
		}
		i = document.getElementById('theimage');
		//alert(i.style.top);
		movei = i;
		return false;
	}
	function releaseimage() {
		movei = "";
		return true;
	}
	// Main function to retrieve mouse x-y pos.s
	function getMouseXY(e) {
	  if (IE) { // grab the x-y pos.s if browser is IE
	    msX = event.clientX + document.documentElement.scrollLeft;
	    msY = event.clientY + document.documentElement.scrollTop;
	  } else {  // grab the x-y pos.s if browser is NS
	    msX = e.pageX;
	    msY = e.pageY;
	  }
	  // catch possible negative values in NS4
	  if (msX < 0){msX = 0;}
	  if (msY < 0){msY = 0;}
	  if (movei!="") {
		ileft = parseInt(movei.style.left);
		itop = parseInt(movei.style.top);
		ileft = ileft - (oldMx-msX);
		itop = itop - (oldMy-msY);
		movei.style.left = ileft+"px";
		movei.style.top = itop+"px";
		oldMx = msX;
		oldMy = msY;
		return false;
	  }
	}

var IE = document.all?true:false;
if (!IE) document.captureEvents(Event.MOUSEMOVE | Event.MOUSEUP)
document.onmousemove = getMouseXY;
document.onmouseup = releaseimage;
</script>
<?php
print "<form name=\"zoomform\" onsubmit=\"setzoom(document.getElementById('zoomval').value); return false;\">";
if ((empty($filename))||(!@fclose(@fopen(filename_decode($filename),"r")))) print "<font class=\"error\">Missing Image File $filename</font>";
else {
	print "<font size=6><a href=\"#\" onclick=\"zoomin(); return false;\">+</a> <a href=\"#\" onclick=\"zoomout();\">-</a> </font>";
	print "<input type=\"text\" size=\"2\" name=\"zoomval\" id=\"zoomval\" value=\"100\">%\n";
	print "<input type=\"button\" value=\"".$pgv_lang["reset"]."\" onclick=\"resetimage(); return false;\">";
	$imgsize = @getimagesize(filename_decode($filename));
	if ($imgsize) {
		$imgwidth = $imgsize[0]+5;
		$imgheight = $imgsize[1]+5;
	}
	print '<br /><div id="imagecropper" style="position: absolute; border: outset white 3px; background-color: black; overflow: auto; vertical-align: middle; text-align: center; width: '.$imgwidth.'px; height: '.$imgheight.'px; ">';
	print "\n<img id=\"theimage\" src=\"$filename\" style=\"position: absolute; left: 0px; top: 0px; width: 100%; height: 100%; cursor: move;\" onmousedown=\"panimage(); return false;\" />\n";
	print '</div>';
}
print "</form>";
print_simple_footer();
?>
