<?php
/*=================================================
	Project: phpGedView-MySQL
	File: importgedcom.php
	Author: John Finlay
	Comments:
		Parses gedcom file and places data into MySQL tables.

	Change Log:
		12/11/02 - File Created
		2/14/03 - Added support for multiple gedcoms (yalnifj)
		
	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: importgedcom.php,v 1.19 2004/01/11 18:17:12 yalnifj Exp $

$BUILDING_INDEX = true;
require("config.php");

if (!isset($stage)) $stage = -1;
if (empty($ged)) $ged = $GEDCOM;
$GEDCOM_FILE = $GEDCOMS[$ged]["path"];
$FILE = $ged;
$TITLE = $GEDCOMS[$ged]["title"];
require($GEDCOMS[$ged]["config"]);
if (!userIsAdmin(getUserName())) header("Location: login.php?url=importgedcom.php?ged=$ged");

print_header($pgv_lang["building_indi"]);
print "<h2>Import GEDCOM</h2>";
if (isset($GEDCOM_FILE)) {
	if ((!strstr($GEDCOM_FILE, "://"))&&(!file_exists($GEDCOM_FILE))) {
		print "<font color=\"red\"><b>Could not locate gedcom file at $GEDCOM_FILE<br /></b></font>\n";
		unset($GEDCOM_FILE);
	}
}
print "GEDCOM_FILE: $GEDCOM_FILE<br />\n";
print "FILE: $FILE<br />";
print "TITLE: $TITLE<br />";

if ($stage==-1) {
	print $pgv_lang["run_tools"]."<br />\n";
	print "<ul><li><a href=\"addmedia.php?ged=$ged\" target=\"tool\">".$pgv_lang["addmedia"]."</a></li>\n";
	print "<li><a href=\"dateconvert.php?ged=$ged\" target=\"tool\">".$pgv_lang["dateconvert"]."</a></li>\n";
	print "<li><a href=\"xreftorin.php?ged=$ged\" target=\"tool\">".$pgv_lang["xreftorin"]."</a></li></ul>\n";
	print $pgv_lang["tools_readme"]."<br /><br />\n";
	print "<a href=\"importgedcom.php?stage=0&ged=$ged\">".$pgv_lang["continue"]."</a><br />\n";
	print_footer();
	exit;
}

setup_database($stage);
if ($stage==0) {
	//-- check if this GEDCOM is already being used
	$dataset_exists = check_dataset($FILE);
	if (($dataset_exists)&&(!isset($erase_dataset))) {
	?>
		<form method="post">
			<input type="hidden" name="ged" value="<?php print $ged;?>">
			<input type="hidden" name="erase_dataset" value="Yes">
			<?=$pgv_lang["dataset_exists"]?> <i><?php print $FILE; ?></i>.<br /><br />
			<?=$pgv_lang["empty_dataset"]?> <br />
			<input type="submit" value="<?php print $pgv_lang["yes"];?>"><br /><br />
		</form>
	<?php
	print_footer();
	exit;
	}

	if (!isset($erase_dataset)) $erase_dataset="No";
	//-- clear all of the things from the old dataset
	if ($erase_dataset=="Yes") {
		empty_database($FILE);
		//-- erase any of the changes
		foreach($pgv_changes as $cid=>$changes) {
			if ($changes[0]["gedcom"]==$ged) unset($pgv_changes[$cid]);
		}
		write_changes();
	}
	$stage=1;
}

print "\n\t<center><h2>".$pgv_lang["importing_records"]."</h2></center>\n\t<br /><br />";
print $pgv_lang["please_be_patient"]."<br /><br />";
print "\n".$pgv_lang["reading_file"]." $GEDCOM_FILE<br />\n";
$GEDCOM=$GEDCOM_FILE;
print $pgv_lang["flushing"]."<br />\n";
flush();

// ------------------------------------------------------ Begin importing data
// -- array of names
if (!isset($indilist)) $indilist = array();
if (!isset($famlist)) $famlist = array();
if (isset($_SESSION["indilist"])) $indilist = $_SESSION["indilist"];
if (isset($_SESSION["famlist"])) $famlist = $_SESSION["famlist"];
if ($CREATE_GENDEX) $gdfp = fopen($INDEX_DIRECTORY."GENDEX_$FILE.txt", "wb");
$sourcelist = array();
$otherlist = array();
$oldtime=time();

if ($stage==1) {
	if (!isset($record_count)) $record_count=0;
	$i=$record_count;
	$fpged = fopen($GEDCOM, "r");
	$BLOCK_SIZE = 1024*4;	//-- 4k bytes per read
	if (!isset($fcontents)) $fcontents = "";
	if (!isset($TOTAL_BYTES)) $TOTAL_BYTES = 0;
	fseek($fpged, $TOTAL_BYTES);
	while(!feof($fpged)) {
		$fcontents .= fread($fpged, $BLOCK_SIZE);
		$TOTAL_BYTES += $BLOCK_SIZE;
		$pos1 = 0;
		while($pos1!==false) {
			$pos2 = strpos($fcontents, "\n0", $pos1+1);
			while((!$pos2)&&(!feof($fpged))) {
				$fcontents .= fread($fpged, $BLOCK_SIZE);
				$TOTAL_BYTES += $BLOCK_SIZE;
				$pos2 = strpos($fcontents, "\n0", $pos1+1);
			}
			if ($pos2) $indirec = substr($fcontents, $pos1, $pos2-$pos1);
			else $indirec = substr($fcontents, $pos1);
			if (preg_match("/1 BLOB/", $indirec)==0) import_record(trim($indirec));
			$i++;
			$pos1 = $pos2;
			if ($i%100==0) {
				$newtime = time();
				$exectime = $newtime - $oldtime;
				print "<br />".$pgv_lang["found_record"]." $i - ".$pgv_lang["id"].":$gid ".$pgv_lang["type"].":$type\n";
				print "<br />".$pgv_lang["exec_time"]." $exectime sec.\n - Bytes Read: $TOTAL_BYTES";
				flush();
			}
		}
		$fcontents = substr($fcontents, $pos2);
		$end_time = getmicrotime();
		$checktime = $end_time - $start_time;
		if (($TIME_LIMIT>0)&&($checktime > $TIME_LIMIT-1)) {
			$_SESSION["indilist"] = $indilist;
			$_SESSION["famlist"] = $famlist;
			print "<br /><br />".$pgv_lang["processed_for"];
			printf(" %.3f sec.", $exectime);
			print "<br /><br />\n";
			print "<form method=\"post\">";
			print "<input type=\"hidden\" name=\"ged\" value=\"$ged\">\n";
			print "<input type=\"hidden\" name=\"TOTAL_BYTES\" value=\"$TOTAL_BYTES\">\n";
			print "<input type=\"hidden\" name=\"fcontents\" value=\"$fcontents\">\n";
			print "<input type=\"hidden\" name=\"record_count\" value=\"$i\">\n";
			print "<input type=\"hidden\" name=\"stage\" value=\"$stage\">\n";
			print "<input type=\"submit\" value=\"".$pgv_lang["continue"]."\">\n";
			print "</form>\n";
			fclose($fpged);
			cleanup_database();
			print_footer();
			exit;
		}
	}
	fclose($fpged);
	$stage=2;
	$record_count=0;
}
if ($CREATE_GENDEX) fclose($gdfp);
if ($stage==2) {
	print "<br /><br /><b>".$pgv_lang["updating_is_dead"]."</b>\n";
	$i=0;
	foreach($indilist as $gid=>$indi) {
		if ($i>=$record_count) {
			update_isdead($gid, $indi);
			if ($i%100==0) {
				$newtime = time();
				$exectime = $newtime - $oldtime;
				print "<br />".$pgv_lang["found_record"]." $i - ".$pgv_lang["id"].":$gid \n";
				print "<br />".$pgv_lang["exec_time"]." $exectime sec.\n";
				flush();
			}
		}
		$i++;
		$end_time = getmicrotime();
		$checktime = $end_time - $start_time;
		if (($TIME_LIMIT>0)&&($checktime > $TIME_LIMIT-1)) {
			$_SESSION["indilist"] = $indilist;
			$_SESSION["famlist"] = $famlist;
			print "<br /><br />".$pgv_lang["processed_for"];
			printf(" %.3f sec.", $exectime);
			print "<br /><br />\n";
			print "<form method=\"post\">";
			print "<input type=\"hidden\" name=\"ged\" value=\"$ged\">\n";
			print "<input type=\"hidden\" name=\"record_count\" value=\"$i\">\n";
			print "<input type=\"hidden\" name=\"stage\" value=\"$stage\">\n";
			print "<input type=\"submit\" value=\"".$pgv_lang["continue"]."\">\n";
			print "</form>\n";
			cleanup_database();
			print_footer();
			exit;
		}
	}
	$stage=3;
	$record_count=0;
}
if ($stage==3) {
	print "<br /><br /><b>".$pgv_lang["updating_family_names"]."</b>\n";
	$i=0;
	foreach($famlist as $gid=>$fam) {
		if ($i>=$record_count) {
			update_family_name($gid, $fam);
			if ($i%100==0) {
				$newtime = time();
				$exectime = $newtime - $oldtime;
				print "<br />".$pgv_lang["found_record"]." $i - ".$pgv_lang["id"].":$gid \n";
				print "<br />".$pgv_lang["exec_time"]." $exectime sec.\n";
				flush();
			}
		}
		$i++;
		$end_time = getmicrotime();
		$checktime = $end_time - $start_time;
		if (($TIME_LIMIT>0)&&($checktime > $TIME_LIMIT-1)) {
			$_SESSION["famlist"] = $famlist;
			print "<br /><br />".$pgv_lang["processed_for"];
			printf(" %.3f sec.", $exectime);
			print "<br /><br />\n";
			print "<form method=\"post\">";
			print "<input type=\"hidden\" name=\"ged\" value=\"$ged\">\n";
			print "<input type=\"hidden\" name=\"record_count\" value=\"$i\">\n";
			print "<input type=\"hidden\" name=\"stage\" value=\"$stage\">\n";
			print "<input type=\"submit\" value=\"".$pgv_lang["continue"]."\">\n";
			print "</form>\n";
			cleanup_database();
			print_footer();
			exit;
		}
	}
	$stage=4;
	$record_count=0;
}
cleanup_database();
unset($_SESSION["famlist"]);
unset($_SESSION["indilist"]);
print "<br /><br /><font color=blue><b>".$pgv_lang["import_complete"]."</b></font>\n";
print "<br /><br /><a href=\"index.php?GEDCOM=$ged\">".$pgv_lang["click_here_to_go_to_pedigree_tree"]."</a><br />\n";
print_footer();
?>

