<?php
/*=================================================
	Project: phpGedView
	File: index.php
	Author: John Finlay
	Input Variables: $rootid
	Comments:
		Parses gedcom file and displays a pedigree tree.  Specify a $rootid to
		root the pedigree tree at a certain person with id = $rootid in the
		GEDCOM file.

	Change Log:
		5/30/02 - File Created
		6/12/02 - Fixed Netscape 6 popup div problem - Darn you netscape ;-)
					 - Added ability to change the spacing between the boxes in the
					 - config file.
		6/18/02 - Added user ability to specify border color on boxes
		9/24/02 - Added support for language files
		12/10/02 - Added better multiple spouse support
		1/28/03 - fixed for safe mode
		2004-01-06 - Added lines for Help-pop-ups

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
===================================================*/
# $Id: index.php,v 1.102.2.4 2004/01/29 17:45:18 yalnifj Exp $
// -- include config file
require("config.php");
require($PGV_BASE_DIRECTORY.$factsfile["english"]);
require($PGV_BASE_DIRECTORY.$factsfile[$LANGUAGE]);

$log2 = log(2);
function adjust_subtree($index, $diff) {
	global $offsetarray, $treeid, $PEDIGREE_GENERATIONS, $log2, $talloffset,$boxspacing, $mdiff, $SHOW_EMPTY_BOXES;
	$f = ($index*2)+1; //-- father index
	$m = $f+1; //-- mother index

	if (!$SHOW_EMPTY_BOXES && empty($treeid[$index])) return;
	if (empty($offsetarray[$index])) return;
	$offsetarray[$index]["y"] += $diff;
	if ($f<count($treeid)) adjust_subtree($f, $diff);
	if ($m<count($treeid)) adjust_subtree($m, $diff);
}

function collapse_tree($index, $curgen, $diff) {
	global $offsetarray, $treeid, $PEDIGREE_GENERATIONS, $log2, $talloffset,$boxspacing, $mdiff, $minyoffset;

	//print "$index:$curgen:$diff<br />\n";
	$f = ($index*2)+1; //-- father index
	$m = $f+1; //-- mother index
	if (empty($treeid[$index])) {
		$pgen=$curgen;
		$genoffset=0;
		while($pgen<=$PEDIGREE_GENERATIONS) {
			$genoffset += pow(2, ($PEDIGREE_GENERATIONS-$pgen));
			$pgen++;
		}
		if ($talloffset==1) $diff+=.5*$genoffset;
		else $diff+=$genoffset;
		if (isset($offsetarray[$index]["y"])) $offsetarray[$index]["y"]-=($boxspacing*$diff)/2;
		return $diff;
	}
	if ($curgen==$PEDIGREE_GENERATIONS) {
		$offsetarray[$index]["y"] -= $boxspacing*$diff;
		//print "UP $index BY $diff<br />\n";
		return $diff;
	}
	$odiff=$diff;
	$fdiff = collapse_tree($f, $curgen+1, $diff);
	if (($curgen<($PEDIGREE_GENERATIONS-1))||($index%2==1)) $diff=$fdiff;
	if (isset($offsetarray[$index]["y"])) $offsetarray[$index]["y"] -= $boxspacing*$diff;
	//print "UP $index BY $diff<br />\n";
	$mdiff = collapse_tree($m, $curgen+1, $diff);
	$zdiff = $mdiff - $fdiff;
	if (($zdiff>0)&&($curgen<$PEDIGREE_GENERATIONS-2)) {
		$offsetarray[$index]["y"] -= $boxspacing*$zdiff/2;
		//print "UP $index BY ".($zdiff/2)."<br />\n";
		if ((empty($treeid[$m]))&&(!empty($treeid[$f]))) adjust_subtree($f, -1*($boxspacing*$zdiff/4));
		$diff+=($zdiff/2);
	}
	return $diff;
}

$show_famlink = true;
if ((isset($view))&&($view=="preview")) {
	$baseyoffset = -20;
	$show_famlink = false;
	$basexoffset = 5;
}

if (!isset($show_full)) $show_full=$PEDIGREE_FULL_DETAILS;
if ($show_full=="") $show_full = 0;
if (!isset($talloffset)) $talloffset = $PEDIGREE_LAYOUT;
if ($talloffset=="") $talloffset = 0;

if ((!isset($PEDIGREE_GENERATIONS))||($PEDIGREE_GENERATIONS=="")) $PEDIGREE_GENERATIONS=$DEFAULT_PEDIGREE_GENERATIONS;

if ($PEDIGREE_GENERATIONS > $MAX_PEDIGREE_GENERATIONS) {
	$PEDIGREE_GENERATIONS = $MAX_PEDIGREE_GENERATIONS;
}

$OLD_PGENS = $PEDIGREE_GENERATIONS;

//-- if the $rootid is not already there then find the first person in the file and make him the root
if (empty($rootid)) {
	$user = getUser(getUserName());
	if ((!empty($user["rootid"][$GEDCOM]))&&(find_person_record($user["rootid"][$GEDCOM]))) $rootid=$user["rootid"][$GEDCOM];
	else if ((!empty($user["gedcomid"][$GEDCOM]))&&(find_person_record($user["gedcomid"][$GEDCOM]))) $rootid=$user["gedcomid"][$GEDCOM];
	//-- allow users to overide default id in the config file.
	else if ((isset($PEDIGREE_ROOT_ID))&&(find_person_record($PEDIGREE_ROOT_ID)!="")) $rootid=$PEDIGREE_ROOT_ID;
	else {
		$rootid = find_first_person();
	}
}
else {
	if (preg_match("/[A-Za-z]+/", $rootid)==0) $rootid = $GEDCOM_ID_PREFIX.$rootid;
}

if ($USE_RIN) {
	$indirec = find_person_record($rootid);
	if ($indirec==false) $rootid = find_rin_id($rootid);
}
if ((DisplayDetailsByID($rootid))||(showLivingNameByID($rootid))) $name = get_person_name($rootid);
else $name = $pgv_lang["private"];

// -- print html header information
print_header($name." ".$pgv_lang["index_header"]);
print "\n\t<div class=\"pedigree_form\" style=\"position: absolute; top: ".($baseyoffset+30)."px; left: ".($basexoffset+10)."px;\">";
print "<h2>".$name."<br />".str_replace("#PEDIGREE_GENERATIONS#", convert_number($PEDIGREE_GENERATIONS), $pgv_lang["gen_ped_chart"])."</h2>";
// -- print the form to change the number of displayed generations
if ($view!="preview") {
	?>
	<script type="text/javascript">
	<!--
	var pasteto;
	function open_find(textbox) {
		pasteto = textbox;
		findwin = window.open('findid.php', '', 'left=50,top=50,width=450,height=450,resizable=1,scrollbars=1');
	}
	function paste_id(value) {
		pasteto.value=value;
	}
	//-->
	</script>
	<?php
	print "\n\t<form name=\"people\" method=\"get\" action=\"index.php\">";
	print "<select name=\"show_full\" onchange=\"document.people.submit();\">\n";
	print "<option value=\"1\"";
	if ($show_full==1) print " selected=\"selected\"";
	print ">".$pgv_lang["show_details"]."</option>\n";
	print "<option value=\"0\"";
	if ($show_full==0) print " selected=\"selected\"";
	print ">".$pgv_lang["hide_details"]."</option>\n";
	print "</select>\n";
	print_help_link("show_full_help", "qm");
	print "<select name=\"talloffset\" onchange=\"document.people.submit();\">\n";
	print "<option value=\"0\"";
	if ($talloffset==0) print " selected=\"selected\"";
	print ">".$pgv_lang["portrait"]."</option>\n";
	print "<option value=\"1\"";
	if ($talloffset==1) print " selected=\"selected\"";
	print ">".$pgv_lang["landscape"]."</option>\n";
	print "</select>\n";
	print_help_link("talloffset_help", "qm");
	print "<br />";
	print "\n\t\t".$pgv_lang["root_person"]." <input type=\"text\" name=\"rootid\" size=\"3\" value=\"$rootid\" /><font size=\"1\"><a href=\"javascript:open_find(document.people.rootid);\">".$pgv_lang["find_id"]."</a></font>";
	print_help_link("rootid_help", "qm");
	print "<br />";
	print "\n\t\t".$pgv_lang["generations"]." <select name=\"PEDIGREE_GENERATIONS\" onchange=\"document.people.submit();\">\n";
	for ($p=3; $p<=$MAX_PEDIGREE_GENERATIONS; $p++) {
	 	print "<option value=\"$p\"";
		if ($OLD_PGENS==$p) print " selected=\"selected\"";
		print ">".convert_number($p)."</option>\n";
	}
	print "</select>\n";
	print_help_link("PEDIGREE_GENERATIONS_help", "qm");
	print "<br />\n\t\t<input type=\"submit\" value=\"".$pgv_lang["view"]."\" />";
	print "\n\t\t</form>";
	print_help_link("pedigree_help", "page_help");
}
print "</div>\n";

//-- adjustments for hide details
if ($show_full==false) {
	$bheight=25;
	$bwidth-=40;
	//$baseyoffset+=125;
}
//-- adjustments for portrait mode
if ($talloffset==0) {
	$bxspacing+=12;
	$basexoffset+=50;
	$bwidth+=20;
}

$pbwidth = $bwidth;
$pbheight = $bheight-1;
$pbwidth = $bwidth+6;
$pbheight = $bheight+5;

// -- the $treeid array will hold all of the individual ids to be displayed on the pedigree chart
// -- the id in position 0 is the root person.  The other positions are filled according to the following algorithm
// -- if an individual is at position $i then individual $i's father will occupy position ($i*2)+1 and $i's mother
// -- will occupy ($i*2)+2
$treeid = array();
$treeid[0]=$rootid;
// -- maximum size of the id array is 2^$PEDIGREE_GENERATIONS - 1
$treesize = pow(2, (int)($PEDIGREE_GENERATIONS))-1;
// -- fill in the id array
for($i=0; $i<($treesize/2); $i++) {
	if ($treeid[$i]) {
		print " ";
		$famids = find_family_ids($treeid[$i]);
		if (count($famids)>0) {
			$parents=false;
			$j=0;
			while((!$parents)&&($j<count($famids))) {
				$parents = find_parents($famids[$j]);
				$j++;
			}

			if ($parents) {
				$treeid[($i*2)+1]=$parents["HUSB"];		// -- set father id
				$treeid[($i*2)+2]=$parents["WIFE"];		// -- set mother id
			}
		}
		else {
			$treeid[($i*2)+1]=false;		// -- father not found
			$treeid[($i*2)+2]=false;		// -- mother not found
		}
	}
	else {
		$treeid[($i*2)+1]=false;		// -- father not found
		$treeid[($i*2)+2]=false;		// -- mother not found
	}
}

//-- detect the highest generation that actually has a person in it and use it for the pedigree generations
if (!$SHOW_EMPTY_BOXES) {
	for($i=($treesize-1); empty($treeid[$i]); $i--);
	$PEDIGREE_GENERATIONS = ceil(log($i+1)/$log2);
	if ($PEDIGREE_GENERATIONS<2) $PEDIGREE_GENERATIONS = 2;
	$treesize = pow(2, (int)($PEDIGREE_GENERATIONS))-1;
	//print "$i:$PEDIGREE_GENERATIONS";
}


if (($PEDIGREE_GENERATIONS < 5)&&($show_full==false)) {
	$baseyoffset+=($PEDIGREE_GENERATIONS*$pbheight/2)+35;
}
if ($PEDIGREE_GENERATIONS<=2) {
	$basexoffset+=170*(4-$PEDIGREE_GENERATIONS);
}
if ($PEDIGREE_GENERATIONS==3) {
	$baseyoffset+=$pbheight;
}

//-- adjustments for RTL
if ($TEXT_DIRECTION=="rtl") {
	if (($PEDIGREE_GENERATIONS<5)&&($view!="preview")) {
		$baseyoffset+=55;
//		$basexoffset+=55;
	}
}

// -- this next section will create and position the DIV layers for the pedigree tree
$curgen = 1;			// -- variable to track which generation the algorithm is currently working on
$yoffset=0;				// -- used to offset the position of each box as it is generated
$xoffset=0;
$prevyoffset=0;		// -- used to track the y position of the previous box
$offsetarray = array();
$minyoffset = 0;
if ($treesize<3) $treesize=3;
// -- loop through all of id's in the array starting at the last and working to the first
//-- calculation the box positions
for($i=($treesize-1); $i>=0; $i--) {
	// -- check to see if we have moved to the next generation
	if ($i < floor($treesize / (pow(2, $curgen)))) {
		$curgen++;
	}
	//-- box position in current generation
	$boxpos = $i-pow(2, $PEDIGREE_GENERATIONS-$curgen);
	//-- offset multiple for current generation
	$genoffset = pow(2, $curgen-$talloffset);
	$boxspacing = $pbheight+$byspacing;
	// -- calculate the yoffset		Position in the generation		Spacing between boxes		put child between parents
	$yoffset = $baseyoffset+($boxpos * ($boxspacing * $genoffset))+(($boxspacing/2)*$genoffset)+($boxspacing * $genoffset);
	if ($talloffset==0) {
		//-- compact the tree
		if ($curgen<$PEDIGREE_GENERATIONS) {
			$parent = floor(($i-1)/2);
			if ($i%2 == 0) $yoffset=$yoffset - (($boxspacing/2) * ($curgen-1));
			else $yoffset=$yoffset + (($boxspacing/2) * ($curgen-1));

			$pgen = $curgen;
			while($parent>0) {
				if ($parent%2 == 0) $yoffset=$yoffset - (($boxspacing/2) * $pgen);
				else $yoffset=$yoffset + (($boxspacing/2) * $pgen);
				$pgen++;
				if ($pgen>3) {
					/*$temp = pow(4, $pgen-4);
					if ($pgen==6) $temp=11;
					if ($pgen==7) $temp=26;
					if ($pgen==8) $temp=57;
					*/
					$temp=0;
					for($j=1; $j<($pgen-2); $j++) $temp += (pow(2, $j)-1);
					if ($parent%2 == 0) $yoffset=$yoffset - (($boxspacing/2) * $temp);
					else $yoffset=$yoffset + (($boxspacing/2) * $temp);
				}
				$parent = floor(($parent-1)/2);
			}
			if ($curgen>3) {
				$temp=0;
					for($j=1; $j<($curgen-2); $j++) $temp += (pow(2, $j)-1);
				if ($i%2 == 0) $yoffset=$yoffset - (($boxspacing/2) * $temp);
				else $yoffset=$yoffset + (($boxspacing/2) * $temp);
			}
		}
	}
	// -- calculate the xoffset
	$xoffset = 20+$basexoffset+ (($PEDIGREE_GENERATIONS - $curgen) * (($pbwidth+$bxspacing)/(2-$talloffset)));
	$offsetarray[$i]["x"]=$xoffset;
	$offsetarray[$i]["y"]=$yoffset;
}

//-- collapse the tree if boxes are missing
if (!$SHOW_EMPTY_BOXES) {
	if ($PEDIGREE_GENERATIONS>1) collapse_tree(0, 1, 0);
}

//-- calculate the smallest yoffset and adjust the tree to that offset
$minyoffset = 0;
for($i=0; $i<count($treeid); $i++) {
	if ($SHOW_EMPTY_BOXES || !empty($treeid[$i])) {
		if (!empty($offsetarray[$i])) {
			if (($minyoffset==0)||($minyoffset>$offsetarray[$i]["y"]))  $minyoffset = $offsetarray[$i]["y"];
		}
	}
}

$ydiff = $baseyoffset+35-$minyoffset;
adjust_subtree(0, $ydiff);

//print_r($offsetarray);

//-- print the boxes
$curgen = 1;
$yoffset=0;				// -- used to offset the position of each box as it is generated
$xoffset=0;
$prevyoffset=0;		// -- used to track the y position of the previous box
$maxyoffset = 0;
for($i=($treesize-1); $i>=0; $i--) {
	// -- check to see if we have moved to the next generation
	if ($i < floor($treesize / (pow(2, $curgen)))) {
		$curgen++;
	}
	$prevyoffset = $yoffset;
	$xoffset = $offsetarray[$i]["x"];
	$yoffset = $offsetarray[$i]["y"];
	// -- if we are in the middle generations then we need to draw the connecting lines
	if (($curgen >(1+$talloffset)) && ($curgen < $PEDIGREE_GENERATIONS)) {
		if ($i%2==1) {
			if ($SHOW_EMPTY_BOXES || ($treeid[$i]) || ($treeid[$i+1])) {
				$vlength = ($prevyoffset-$yoffset);
				if (!$SHOW_EMPTY_BOXES && (empty($treeid[$i+1]))) {
					$parent = ceil(($i-1)/2);
					$vlength = $offsetarray[$parent]["y"]-$yoffset;
				}
				print "<div id=\"line$i\" style=\"position:absolute; left:".($xoffset-1)."px; top:".($yoffset+$pbheight/2)."px; z-index: 0;\">";
				print "<img src=\"$PGV_IMAGE_DIR/$PGV_VLINE_IMG\" width=\"3\" height=\"".$vlength."\" alt=\"\" />";
				print "</div>";
			}
		}
	}
	// -- draw the box
	if (!empty($treeid[$i]) || $SHOW_EMPTY_BOXES) {
		if ($yoffset>$maxyoffset) $maxyoffset=$yoffset;
		$widthadd = 0;
		if (($curgen==1)&&(find_family_id($treeid[$i]))) $widthadd = 20;
		if (($curgen >2) && ($curgen < $PEDIGREE_GENERATIONS)) $widthadd = 10;
		print "\n\t\t<div id=\"box";
		if (empty($treeid[$i])) print "$i";
		else print $treeid[$i];
		print "\" style=\"position:absolute; left:".$xoffset."px; top:".$yoffset."px; width:".($pbwidth+$widthadd)."px; height:".$pbheight."px; z-index: 0;\">";
		print "\n\t\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" dir=\"ltr\">";
		if (($curgen >(1+$talloffset)) && ($curgen < $PEDIGREE_GENERATIONS)) {
			print "<tr><td>";
			print "\n\t\t\t<img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" align=\"left\" hspace=\"0\" vspace=\"0\" alt=\"\" />";
			print "\n\t\t\t</td><td width=\"100%\" dir=\"$TEXT_DIRECTION\">";
		}
		else print "<tr><td width=\"100%\" dir=\"$TEXT_DIRECTION\">";
		$mfstyle = "";
		if (!empty($treeid[$i])) {
			$indirec = find_person_record($treeid[$i]);
			$ct = preg_match("/1 SEX F/", $indirec);
			if ($ct>0) $mfstyle="F";
		}
		print_pedigree_person($treeid[$i], 1, $show_famlink);
		if (($curgen==1)&&(find_family_id($treeid[$i]))) {
			$did = 1;
			if ($i > ($treesize/2) + ($treesize/4)-1) $did++;
			print "\n\t\t\t\t</td><td valign=\"middle\">";
			if ($view!="preview") print "<a href=\"index.php?PEDIGREE_GENERATIONS=$OLD_PGENS&amp;rootid=".$treeid[$did]."&amp;show_full=$show_full&amp;talloffset=$talloffset\" onmouseover=\"swap_image('arrow$i',1);\" onmouseout=\"swap_image('arrow$i',1);\">";
			print "<img id=\"arrow$i\" src=\"$PGV_IMAGE_DIR/$PGV_RARROW_IMG\" border=\"0\" alt=\"\"/>";
			if ($view!="preview") print "</a>";
		}
		print "\n\t\t\t</td></tr></table>\n\t\t</div>";
	}
}

$indirec = find_person_record($rootid);
if (displayDetails($indirec) || showLivingName($indirec)) {
	// -- print left arrow for decendants so that we can move down the tree
	$yoffset += ($pbheight / 2)-10;
	$famids = find_sfamily_ids($rootid);
	$cfamids = find_family_ids($rootid);
	if ($famids||$cfamids) {
		print "\n\t\t<div id=\"childarrow\" style=\"position:absolute; left:".$basexoffset."px; top:".$yoffset."px; width:10px; height:10px; \">";
		if ($view!="preview") print "<a href=\"#\" onclick=\"return togglechildrenbox();\" onmouseover=\"swap_image('larrow',0);\" onmouseout=\"swap_image('larrow',0);\">";
		print "<img id=\"larrow\" src=\"$PGV_IMAGE_DIR/$PGV_LARROW_IMG\" border=\"0\" alt=\"\" />";
		if ($view!="preview") print "</a>";
		print "\n\t\t</div>";
		$yoffset += ($pbheight / 2)+10;
		print "\n\t\t<div id=\"childbox\" style=\"position: absolute; left:".$xoffset."px; top:".$yoffset."px; width:".$pbwidth."px; height:".$pbheight."px; visibility: hidden;\">";
		print "\n\t\t\t<table class=\"person_box\"><tr><td>";
		for($f=0; $f<count($famids); $f++) {
			$famrec = find_family_record($famids[$f]);
			if ($famrec) {
				$parents = find_parents($famids[$f]);
				if($parents) {
					if($rootid!=$parents["HUSB"]) $spid=$parents["HUSB"];
					else $spid=$parents["WIFE"];
					if (!empty($spid)) {
						print "\n\t\t\t\t<a href=\"index.php?PEDIGREE_GENERATIONS=$OLD_PGENS&amp;rootid=$spid&amp;show_full=$show_full&amp;talloffset=$talloffset\"><font class=\"name1\">";
						if (displayDetailsById($spid) || showLivingNameById($spid)) {
							$name = get_person_name($spid);
							$name = rtrim($name);
							print $name;
						}
						else print $pgv_lang["living"];
						print "<br /></font></a>";
					}

				}
				$num = preg_match_all("/1\s*CHIL\s*@(.*)@/", $famrec, $smatch,PREG_SET_ORDER);
				for($i=0; $i<$num; $i++) {
					$pid = $smatch[$i][1];
					print "\n\t\t\t\t&nbsp;&nbsp;<a href=\"index.php?PEDIGREE_GENERATIONS=$OLD_PGENS&amp;rootid=$pid&amp;show_full=$show_full&amp;talloffset=$talloffset\"><font class=\"name1\">&lt; ";
					if (displayDetailsById($pid) || showLivingNameById($pid)) {
						$name = get_person_name($pid);
						$name = rtrim($name);
						print $name;
					}
					else print $pgv_lang["living"];
					print "<br /></font></a>";
				}
			}
		}
		$famids = find_family_ids($rootid);
		for($f=0; $f<count($famids); $f++) {
			$famrec = find_family_record($famids[$f]);
			if ($famrec) {
				$num = preg_match_all("/1\s*CHIL\s*@(.*)@/", $famrec, $smatch,PREG_SET_ORDER);
				if ($num>1) print "<font class=\"name1\"><br />".$pgv_lang["siblings"]."<br /></font>";
				for($i=0; $i<$num; $i++) {
					$pid = $smatch[$i][1];
					if ($pid!=$rootid) {
						print "\n\t\t\t\t&nbsp;&nbsp;<a href=\"index.php?PEDIGREE_GENERATIONS=$OLD_PGENS&amp;rootid=$pid&amp;show_full=$show_full&amp;talloffset=$talloffset\"><font class=\"name1\"> ";
						if (displayDetailsById($pid) || showLivingNameById($pid)) {
							$name = get_person_name($pid);
							$name = rtrim($name);
							print $name;
						}
						else print $pgv_lang["living"];
						print "<br /></font></a>";
					}
				}
			}
		}
		print "\n\t\t\t</td></tr></table>";
		print "\n\t\t</div>";
	}
}
// -- print html footer
$maxyoffset += $pbheight*2;
if ($maxyoffset<600) $maxyoffset=600;
print "\n\t\t<div id=\"footerbox\" style=\"position:absolute; left:0px; top:".$maxyoffset."px; width:100%; z-index: 0; \">";
$without_close=true;
print_footer();
print "\n\t</div>\n</body>\n</html>";


?>
