<?php
/*=================================================
   Project: phpGedView
   File: individual.php
   Author: John Finlay
   Input Variables: $pid
   Comments:
	  Parses gedcom file and displays information about an individual.  You
	  must supply a $pid value with the identifier for the individual whose
	  information is desired.

   Change Log:
	  6/3/02 - File Created
	  6/18/02 - Changed to table layout
	  8/5/02 - Moved factarray to seperate file
	  8/15/02 - Adjusted to work with note records
			made more gedcom 5.0 compliant
	  9/24/02 - Added support for language files
	  2/14/03 - Added persons name to page title
	  3/4/03 - Fixed bug where last fact was dropped, added nav link to close
			relatives (yalnifj)
	  5/13/03 - Making the close relatives tab show up when details are private
	  5/30/03 - Showing error message when !showLivingName
	  6/3/03 - Adding options to hide specific facts and details

   phpGedView: Genealogy Viewer
	Copyright (C) 2002 to 2003  John Finlay and Others

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
===================================================*/
# $Id: individual.php,v 1.149.2.2 2004/02/03 21:22:55 botak Exp $

require("config.php");
require($PGV_BASE_DIRECTORY.$factsfile["english"]);
require($PGV_BASE_DIRECTORY.$factsfile[$LANGUAGE]);

$researchlog = FALSE;
if (file_exists("rs_folders.php")) {
	$username = getUserName();
	if (($SHOW_RESEARCH_LOG==$PRIV_PUBLIC)||(userIsAdmin($username))||(!empty($username)&&($SHOW_RESEARCH_LOG==$PRIV_USER))) {
		require("rs_functions.php");
		$researchlog = TRUE;
	}
}

function factsort($a, $b) {
   global $factarray;

   return strnatcasecmp($factarray[$a], $factarray[$b]);
}

// -- array of GEDCOM elements that will be found but should not be displayed
$nonfacts = array();
$nonfacts[] = "FAMS";
$nonfacts[] = "FAMC";
$nonfacts[] = "MAY";
$nonfacts[] = "BLOB";
$nonfacts[] = "CHIL";
$nonfacts[] = "HUSB";
$nonfacts[] = "WIFE";
$nonfacts[] = "";

$nonfamfacts[] = "UID";
$nonfamfacts[] = "";

$addfacts = array("BIRT","CHR","DEAT","BURI","CREM","ADOP","BAPM","BARM","BASM","BLES","CHRA","CONF","FCOM","ORDN","NATU","EMIG","IMMI","CENS","PROB","WILL","GRAD","RETI","CAST","DSCR","EDUC","IDNO",
   "NATI","NCHI","NMR","OCCU","PROP","RELI","RESI","SSN","TITL","BAPL","CONL","ENDL","SLGC","_MILI");
usort($addfacts, "factsort");

$sexarray = array();
$sexarray["M"] = $pgv_lang["male"];
$sexarray["F"] = $pgv_lang["female"];
$indifacts = array();            // -- array to store the fact records in for sorting and displaying
$globalfacts = array();
$otheritems = array();            //-- notes, sources, media objects

$FACT_COUNT=0;
$NAME_COUNT=1;

//-- function to print a name record
function print_name_record($factrec, $linenum) {
   global $pgv_lang, $pid, $factarray, $NAME_COUNT, $view;
   if ((!showFact("NAME", $pid))||(!showFactDetails("NAME", $pid))) return false;
   $lines = split("\n", $factrec);
   if (($NAME_COUNT==0)&&(count($lines) < 4)) return;
   $NAME_COUNT++;
   print "<div";
   if (preg_match("/PGV_OLD/", $factrec)>0) print " style=\"border: solid red 1px;\"";
   if (preg_match("/PGV_NEW/", $factrec)>0) print " style=\"border: solid blue 1px;\"";
   print ">";
   print "\n\t\t<font class=\"label\">".$pgv_lang["name"]." </font>";
   $ct = preg_match_all("/2 ([_A-Z]+) (.*)/", $factrec, $nmatch, PREG_SET_ORDER);
   for($i=0; $i<$ct; $i++) {
	  print "\n\t\t\t<br />&nbsp;&nbsp;&nbsp;<span class=\"label\">";
	  $fact = trim($nmatch[$i][1]);
	  if (($fact!="SOUR")&&($fact!="NOTE")) {
		  if (isset($pgv_lang[$fact])) print $pgv_lang[$fact];
		  else if (isset($factarray[$fact])) print $factarray[$fact];
		  else print $fact;
		  print ":</span><span class=\"field\"> ";
		  if (isset($nmatch[$i][2])) print stripslashes(trim($nmatch[$i][2]));
		  print " </span>";
	  }
   }
   $ct = preg_match("/\d (NOTE)|(SOUR)/", $factrec);
   if ($ct>0) {
	  // -- find sources for this name
	  print "<br /><div class=\"indent\">";
	  print_fact_sources($factrec, 2);
	  //-- find the notes for this name
	  print "&nbsp;&nbsp;&nbsp;";
	  print_fact_notes($factrec, 2);
	  print "</div>";
   }
   if (($view!="preview") && (userCanEdit(getUserName())) && (preg_match("/PGV_OLD/", $factrec)==0)) {
	   print "<br /><font size=1><a href=\"#\" onclick=\"edit_name('$pid', $linenum); return false;\">".$pgv_lang["edit_name"]."</a> | ";
	   print "<a href=\"#\" onclick=\"delete_record('$pid', $linenum); return false;\">".$pgv_lang["delete_name"]."</a></font>\n";
   }
   print "<br />";
   print "</div>\n";
}


//-- function to print a sex record
function print_sex_record($factrec, $linenum) {
   global $pgv_lang, $sexarray, $pid, $sex;
   if ((!showFact("SEX", $pid))||(!showFactDetails("SEX", $pid))) return false;
   $ft = preg_match("/\d\s(_?.{3,4})\s(.*)/", $factrec, $match);
   $sex = trim($match[2]);
   print "<font class=\"label\">".$pgv_lang["sex"]."    </font><font class=\"field\">".$sexarray[$sex]."<br /></font>";
   // -- find sources
   print "&nbsp;&nbsp;&nbsp;";
   print_fact_sources($factrec, 2);
   //-- find the notes
   print "&nbsp;&nbsp;&nbsp;";
   print_fact_notes($factrec, 2);
   print "<br />";
}

// -- print the persons name
$indirec = find_person_record($pid);
if (!$indirec) $indirec = find_record_in_file($pid);
if (($USE_RIN)&&($indirec==false)) {
   $pid = find_rin_id($pid);
   $indirec = find_person_record($pid);
}

$bpos1 = strpos($indirec, "1 BIRT");
if ($bpos1) {
	$birthrec = get_sub_record(1, "1 BIRT", $indirec);
	if ($birthrec!==false) {
		$dct = preg_match("/2 DATE.*(\d\d\d\d)/", $birthrec, $match);
		if ($dct>0) $birthyear = trim($match[1]);
		$dct = preg_match("/2 DATE.*(...) \d\d\d\d/", $birthrec, $match);
		if ($dct>0) {
			if (isset($monthtonum[strtolower(trim($match[1]))])) {
				$birthmonth = $monthtonum[strtolower(trim($match[1]))];
			}
		}
	}
}

if (userCanEdit(getUserName())) {
   if ((isset($show_changes))&&(isset($pgv_changes[$pid."_".$GEDCOM]))) {
	  $newrec = find_record_in_file($pid);
	  $indilines = split("\n", $newrec);   // -- find the number of lines in the individuals record
	  $lct = count($indilines);
	  $factrec = "";   // -- complete fact record
	  $line = "";   // -- temporary line buffer
	  $f=0;
	  $newfacts = array();
	  $newother = array();
	  $newglobal = array();
	  $linenum = 0;
	  for($i=1; $i<=$lct; $i++) {
		 if ($i<$lct) $line = preg_replace("/\r/", "", $indilines[$i]);
		 else $line=" ";
		 if (empty($line)) $line=" ";
		 if (($i==$lct)||($line{0}==1)) {
			$ft = preg_match("/1\s(_?.{3,4})\s(.*)/", $factrec, $match);
			if ($ft>0) $fact = $match[1];
			else $fact="";
			$fact = trim($fact);
			// -- handle special name fact case
			if ($fact=="NAME") {
	            $newglobal[] = array($linenum, $factrec);
			}
			// -- handle special source fact case
			else if ($fact=="SOUR") {
			   $newother[]=array($linenum, $factrec);
			}
			// -- handle special media object case
			else if ($fact=="OBJE") {
			   $newother[]=array($linenum, $factrec);
			}
			// -- handle special note fact case
			else if ($fact=="NOTE") {
			   $newother[]=array($linenum, $factrec);
			}
			// -- handle special sex case
			else if ($fact=="SEX") {
	            $newglobal[] = array($linenum, $factrec);
			}
			else {
			   $newfacts[$f]=array($linenum, $factrec);
			   $f++;
			}
			$factrec = $line;
			$linenum = $i;
		 }
		 else $factrec .= "\n".$line;
	  }
   }
}

$name = get_person_name($pid);
$disp = displayDetails($indirec);
if (!$disp && !showLivingName($indirec)) $name = $pgv_lang["living"];
print_header(stripslashes($name)." - $pid - ".$pgv_lang["indi_info"]);

if (!$disp && !showLivingName($indirec)) {
   print_privacy_error($CONTACT_EMAIL);
   print_footer();
   exit;
}

$famc = find_family_id($pid);
$fams = find_sfamily_id($pid);

//-- find all the fact information
$indilines = split("\n", $indirec);   // -- find the number of lines in the individuals record
$lct = count($indilines);
$factrec = "";   // -- complete fact record
$line = "";   // -- temporary line buffer
$f=0;      // -- counter
$o = 0;
$g = 0;
$linenum=1;
for($i=1; $i<=$lct; $i++) {
   if ($i<$lct) $line = preg_replace("/\r/", "", $indilines[$i]);
   else $line=" ";
   if (empty($line)) $line=" ";
   if (($i==$lct)||($line{0}==1)) {
	  $ft = preg_match("/1\s(_?.{3,4})\s(.*)/", $factrec, $match);
	  if ($ft>0) $fact = $match[1];
	  else $fact="";
	  $fact = trim($fact);
	  // -- handle special name fact case
	  if ($fact=="NAME") {
		 $globalfacts[$g] = array($linenum, $factrec);
		 $g++;
	  }
	  // -- handle special source fact case
	  else if ($fact=="SOUR") {
		 $otheritems[$o] = array($linenum, $factrec);
		 $o++;
	  }
	  // -- handle special media object case
	  else if ($fact=="OBJE") {
		 $otheritems[$o] = array($linenum, $factrec);
		 $o++;
	  }
	  // -- handle special note fact case
	  else if ($fact=="NOTE") {
		 $otheritems[$o] = array($linenum, $factrec);
		 $o++;
	  }
	  // -- handle special sex case
	  else if ($fact=="SEX") {
		 $globalfacts[$g] = array($linenum, $factrec);
		 $g++;
	  }
	  else {
		 $indifacts[$f]=array($linenum, $factrec);
		 $f++;
	  }
	  $factrec = $line;
	  $linenum = $i;
   }
   else $factrec .= "\n".$line;
}
//-- loop through new facts and add them to the list if they are any changes
if (isset($newfacts)) {
	//-- compare new and old facts of the Personal Fact and Details tab 1
   for($i=0; $i<count($indifacts); $i++) {
	  $found=false;
	  foreach($newfacts as $newfact) {
		 if (trim($newfact[1])==trim($indifacts[$i][1])) {
			$found=true;
			break;
		 }
	  }
	  if (!$found) {
		 $indifacts[$i][1].="\nPGV_OLD\n";
	  }
   }
   foreach($newfacts as $newfact) {
	  $found=false;
	  foreach($indifacts as $fact) {
		 if (trim($fact[1])==trim($newfact[1])) {
			$found=true;
			break;
		 }
	  }
	  if (!$found) {
		 $newfact[1].="\nPGV_NEW\n";
		 $indifacts[$f]=$newfact;
		 $f++;
	  }
   }
   //-- compare new and old facts of the Notes Sources and Media tab 2
   for($i=0; $i<count($otheritems); $i++) {
	  $found=false;
	  foreach($newother as $newfact) {
		 if (trim($newfact[1])==trim($otheritems[$i][1])) {
			$found=true;
			break;
		 }
	  }
	  if (!$found) {
		 $otheritems[$i][1].="\nPGV_OLD\n";
	  }
   }
   foreach($newother as $newfact) {
	  $found=false;
	  foreach($otheritems as $fact) {
		 if (trim($fact[1])==trim($newfact[1])) {
			$found=true;
			break;
		 }
	  }
	  if (!$found) {
		 $newfact[1].="\nPGV_NEW\n";
		 $otheritems[$f]=$newfact;
		 $f++;
	  }
   }
   //-- compare new and old facts of the Global facts
   for($i=0; $i<count($globalfacts); $i++) {
	  $found=false;
	  foreach($newglobal as $newfact) {
		 if (trim($newfact[1])==trim($globalfacts[$i][1])) {
			$found=true;
			break;
		 }
	  }
	  if (!$found) {
		 $globalfacts[$i][1].="\nPGV_OLD\n";
	  }
   }
   foreach($newglobal as $newfact) {
	  $found=false;
	  foreach($globalfacts as $fact) {
		 if (trim($fact[1])==trim($newfact[1])) {
			$found=true;
			break;
		 }
	  }
	  if (!$found) {
		 $newfact[1].="\nPGV_NEW\n";
		 $globalfacts[$f]=$newfact;
		 $f++;
	  }
   }
}

//-- find family as spouse
$ct = preg_match_all("/1\s+FAMS\s+@(.*)@/", $indirec, $fmatch, PREG_SET_ORDER);
for($j=0; $j<$ct; $j++) {
   $famid = $fmatch[$j][1];
   $famrec = find_family_record($famid);
   $parents=find_parents_in_record($famrec);
   if ($parents['HUSB']==$pid) $spouse=$parents['WIFE'];
   else $spouse=$parents['HUSB'];
   $indilines = split("\n", $famrec);   // -- find the number of lines in the individuals record
   $lct = count($indilines);
   $factrec = "";   // -- complete fact record
   $line = "";   // -- temporary line buffer
   $linenum = 0;
   for($i=1; $i<=$lct; $i++) {
	  if ($i<$lct) $line = preg_replace("/\r/", "", $indilines[$i]);
	  else $line=" ";
	  if (empty($line)) $line=" ";
	  if (($i==$lct)||($line{0}==1)) {
		 $ft = preg_match("/1\s(_?.{3,4})\s(.*)/", $factrec, $match);
		 if ($ft>0) $fact = $match[1];
		 else $fact="";
		 $fact = trim($fact);
		 // -- handle special source fact case
		 if (($fact!="SOUR") && ($fact!="OBJE") && ($fact!="NOTE") && ($fact!="CHAN") && ($fact!="_UID") && ($fact!="RIN")) {
			if ((!in_array($fact, $nonfacts))&&(!in_array($fact, $nonfamfacts))) {
			   $factrec.="\nPGV_SPOUSE: $spouse\n";
			   $factrec.="PGV_FAMILY_ID: $famid\n";
			   $indifacts[$f]=array($linenum, $factrec);
			   $f++;
			}
		 }
		 $factrec = $line;
		 $linenum = $i;
	  }
	  else $factrec .= "\n".$line;
   }
}
usort($indifacts, "compare_facts");

print "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"facts_table\"><tr>";
if (($disp) && ($MULTI_MEDIA && $SHOW_HIGHLIGHT_IMAGES)) {
   $firstmediarec = find_highlighted_object($pid, $indirec);
   if ($firstmediarec) {
	  $filename = $firstmediarec["file"];
	  if (empty($filename)) $filename = $firstmediarec["thumb"];
	  if (!empty($filename)) {
		 print "\n\t<td rowspan=2 width=100 valign=top><img src=\"$filename\" align=\"left\" class=\"image\" alt=\"".$firstmediarec["file"]."\" /></td>";
	  }
   }
}

print "<td valign=\"top\"><font class=\"name_head\">".stripslashes($name)."</font><br />";
if ($disp) {
   if (userCanEdit(getUserName())&&($view!="preview")) {
	  if (isset($pgv_changes[$pid."_".$GEDCOM])) print "<a href=\"individual.php?pid=$pid&amp;show_changes=yes\">".$pgv_lang["show_changes"]."</a><br />";
	  print "<a href=\"#\" onclick=\"return deleteperson('$pid');\">".$pgv_lang["delete_person"]."</a><br />\n";
   }
   foreach ($globalfacts as $key => $value) {
	  $ft = preg_match("/\d\s(_?.{3,4})\s(.*)/", $value[1], $match);
	  if ($ft>0) $fact = $match[1];
	  else $fact="";
	  $fact = trim($fact);
	  if ($fact=="SEX") print_sex_record($value[1], $value[0]);
	  if ($fact=="NAME") print_name_record($value[1], $value[0]);
	  $FACT_COUNT++;
   }
}
$visibility = "visible";
$position = "relative";
if ($view!="preview") {
   print "\n\t\t</td><td ";
   if ($TEXT_DIRECTION=="rtl") print "align=\"left\"";
   else print "align=\"right\"";
   print "> \n";
   include $sublinks;
   $visibility = "hidden";
   $position = "absolute";
}
?>
</td></tr><tr><td valign="bottom" colspan="2">
<script language="JavaScript" type="text/javascript">
<!--
// -- javascript function to open a window with the raw gedcom in it
function show_gedcom_record() {
	var recwin = window.open("gedrecord.php?pid=<?php print $pid ?>", "", "top=50,left=50,width=300,height=400,scrollbars=1,scrollable=1,resizable=1");
}

   function switch_tab(tab) {
	  var pagetab0=document.getElementById("pagetab0");
	  var pagetab1=document.getElementById("pagetab1");
	  var pagetab2=document.getElementById("pagetab2");
	  var pagetab3=document.getElementById("pagetab3");
	  var pagetab0bottom=document.getElementById("pagetab0bottom");
	  var pagetab1bottom=document.getElementById("pagetab1bottom");
	  var pagetab2bottom=document.getElementById("pagetab2bottom");
	  var pagetab3bottom=document.getElementById("pagetab3bottom");
	  if (tab==0) {
		 MM_showHideLayers('facts', ' ', 'show',' ');
		 MM_showHideLayers('nso', ' ', 'hide',' ');
		 MM_showHideLayers('relatives', ' ', 'hide',' ');
		  MM_showHideLayers('researchlog', ' ','hide',' ');
		 pagetab0.className='tab_cell_active';
		 pagetab1.className='tab_cell_inactive';
		 pagetab2.className='tab_cell_inactive';
		 if (pagetab3) pagetab3.className='tab_cell_inactive';
		 pagetab0bottom.className='tab_active_bottom';
		 pagetab1bottom.className='tab_inactive_bottom';
		 pagetab2bottom.className='tab_inactive_bottom';
		 if (pagetab3)  pagetab3bottom.className='tab_inactive_bottom';
	  }
	  else if (tab==1) {
		 MM_showHideLayers('facts', ' ', 'hide',' ');
		 MM_showHideLayers('nso', ' ', 'show',' ');
		 MM_showHideLayers('relatives', ' ', 'hide',' ');
		  MM_showHideLayers('researchlog', ' ','hide',' ');
		 pagetab0.className='tab_cell_inactive';
		 pagetab1.className='tab_cell_active';
		 pagetab2.className='tab_cell_inactive';
		 if (pagetab3)  pagetab3.className='tab_cell_inactive';
		pagetab0bottom.className='tab_inactive_bottom';
		 pagetab1bottom.className='tab_active_bottom';
		 pagetab2bottom.className='tab_inactive_bottom';
		 if (pagetab3) pagetab3bottom.className='tab_inactive_bottom';
	  }
	  else if (tab==2) {
		 MM_showHideLayers('facts', ' ', 'hide',' ');
		 MM_showHideLayers('nso', ' ', 'hide',' ');
		 MM_showHideLayers('relatives', ' ', 'show',' ');
		 MM_showHideLayers('researchlog', ' ','hide',' ');
		 pagetab0.className='tab_cell_inactive';
		 pagetab1.className='tab_cell_inactive';
		 pagetab2.className='tab_cell_active';
		 if (pagetab3) pagetab3.className='tab_cell_inactive';
		 pagetab0bottom.className='tab_inactive_bottom';
		 pagetab1bottom.className='tab_inactive_bottom';
		 pagetab2bottom.className='tab_active_bottom';
		 if (pagetab3) pagetab3bottom.className='tab_inactive_bottom';
	  }
	 else if (tab==3) {
	   MM_showHideLayers('facts', ' ', 'hide',' ');
	   MM_showHideLayers('nso', ' ', 'hide',' ');
	   MM_showHideLayers('relatives', ' ', 'hide',' ');
	   MM_showHideLayers('researchlog', ' ','show',' ');
	   pagetab0.className='tab_cell_inactive';
	   pagetab1.className='tab_cell_inactive';
	   pagetab2.className='tab_cell_inactive';
	   pagetab3.className='tab_cell_active';
	   pagetab0bottom.className='tab_inactive_bottom';
	   pagetab1bottom.className='tab_inactive_bottom';
	   pagetab2bottom.className='tab_inactive_bottom';
		 pagetab3bottom.className='tab_active_bottom';
	}
	  return false;
   }

   function showchanges() {
	  window.location = '<?php print $PHP_SELF."?".preg_replace("/&amp;/", "&", $QUERY_STRING)."&show_changes=yes"; ?>';
   }
   //-->
</script>
<?php
if ($view!="preview") {
?>
<table class="tabs_table" cellspacing="0">
   <tr>
	  <td id="pagetab0" class="tab_cell_active" onclick="return switch_tab(0);"><a href="#" onclick="return switch_tab(0);"><?php print $pgv_lang["personal_facts"]?></a></td>
	  <td id="pagetab1" class="tab_cell_inactive" onclick="return switch_tab(1);"><a href="#" onclick="return switch_tab(1);"><?php print $pgv_lang["notes_sources_media"]?></a></td>
	  <td id="pagetab2" class="tab_cell_inactive" onclick="return switch_tab(2);"><a href="#" onclick="return switch_tab(2);"><?php print $pgv_lang["relatives"]?></a></td>
	  <?php if ($researchlog == TRUE){?>
	   <td id="pagetab3" class="tab_cell_inactive" onclick="return switch_tab(3);"><a href="#" onclick="return switch_tab(3)"><?php print $pgv_lang["research_log"]?></a></td>
	  <?php }?>
	</tr>
	<tr>
	  <td id="pagetab0bottom" class="tab_active_bottom"><br /></td>
	  <td id="pagetab1bottom" class="tab_inactive_bottom"><br /></td>
	  <td id="pagetab2bottom" class="tab_inactive_bottom"><br /></td>
	   <?php if ($researchlog == TRUE){?>
		  <td id="pagetab3bottom" class="tab_inactive_bottom"><br /></td>
	   <?php }?>
	  <td class="tab_inactive_bottom_right"><br /></td>
   </tr>
</table>

<?php
}
print "</td></tr></table>\n";
//--------------------------------Start 1st tab individual page
//--- Personal Facts and Details
print "\n\t<div id=\"facts\" class=\"tab_page\" style=\"position: $position; top: auto; left: ".$basexoffset."px; visibility: visible; z-index: 1; \">\n\t";
if ($view=="preview") print "<font class=\"subheaders\">".$pgv_lang["personal_facts"]."</font>";
print "\n\t<table class=\"facts_table\">";
if (!$disp) {
	$user = getUser($CONTACT_EMAIL);
   print "<tr><td class=\"facts_value\">";
   print_privacy_error($CONTACT_EMAIL);
   print "</td></tr>";
}
else {
   foreach ($indifacts as $key => $value) {
	  if (preg_match("/PGV_FAMILY_ID: (.*)/", $value[1], $match)>0) print_fact($value[1],trim($match[1]),$value[0]);
	  else print_fact($value[1],$pid,$value[0]);
	  $FACT_COUNT++;
   }
}
//-- new fact link
if (($view!="preview") &&(userCanEdit(getUserName()))) {
   print "<tr><td class=\"facts_label\">".$pgv_lang["add_fact"]."</td>";
   print "<td class=\"facts_value\">";
   print "<form method=\"get\" name=\"newfactform\">\n";
   print "<select id=\"newfact\" name=\"newfact\">\n";
   foreach($addfacts as $fact) {
	  print "<option value=\"$fact\">".$factarray[$fact]."</option>\n";
   }
   print "<option value=\"EVEN\">".$pgv_lang["custom_event"]."</option>\n";
   print "</select>";
   print "<input type=\"button\" value=\"".$pgv_lang["add"]."\" onclick=\"add_record('$pid', 'newfact');\">\n";
   print "</form>\n";
   print "</td></tr>\n";
}
print "\n\t</table>\n<br />";
if ($view!="preview") {
	$without_close=true;
	print "<table width=\"100%\"><tr><td align=\"center\">\n";
	print_footer();
	print "</td></tr></table>";
}
print "</div>\n";

//--------------------------------Start 2nd tab individual page
//--- Notes, Sources, and Media
print "\n\t<div id=\"nso\" class=\"tab_page\" style=\"position: $position; top: auto; left: ".$basexoffset."px; visibility: $visibility; z-index: 2; \">";
if ($view=="preview") print "<font class=\"subheaders\">".$pgv_lang["notes_sources_media"]."</font>";
print "\n\t<table class=\"facts_table\">";
if (!$disp) {
   print "<tr><td class=\"facts_value\">";
   print_privacy_error($CONTACT_EMAIL);
   print "</td></tr>";
}
else {
   if (count($otheritems)>0) {
	  foreach ($otheritems as $key => $factrec) {
		 $ft = preg_match("/\d\s(_?.{3,4})\s(.*)/", $factrec[1], $match);
		 if ($ft>0) $fact = $match[1];
		 else $fact="";
		 $fact = trim($fact);
		 if ($fact=="SOUR") {
			print_main_sources($factrec[1], 1, $pid, $factrec[0]);
		 }
		 else if ($fact=="OBJE") {
			print_main_media($factrec[1], 1, $pid, $factrec[0]);
		 }
		 else if ($fact=="NOTE") {
			print_main_notes($factrec[1], 1, $pid, $factrec[0]);
		 }
		 $FACT_COUNT++;
	  }
   }
   else {
	  print "<tr><td></td></tr>";
   }
   //-- new item form
   if (($view!="preview") && (userCanEdit(getUserName()))) {
	  print "<tr><td class=\"facts_label\">".$pgv_lang["add_fact"]."</td>";
	  print "<td class=\"facts_value\">";
	  print "<form method=\"get\" name=\"newnsoform\">\n";
	  print "<select id=\"newnso\" name=\"newnso\">\n";
	  print "<option value=\"NOTE\">".$factarray["NOTE"]."</option>\n";
	  print "<option value=\"OBJE\">".$factarray["OBJE"]."</option>\n";
	  print "<option value=\"SOUR\">".$factarray["SOUR"]."</option>\n";
	  print "</select>";
	  print "<input type=\"button\" value=\"".$pgv_lang["add"]."\" onclick=\"add_record('$pid', 'newnso');\">\n";
	  print "</form>\n";
	  print "</td></tr>\n";
   }
}
print "\n\t</table>\n<br />";
if ($view!="preview") {
	$without_close=true;
	print "<table width=\"100%\"><tr><td align=\"center\">\n";
	print_footer();
	print "</td></tr></table>";
}
print "</div>\n";

//--------------------------------Start 3rd tab individual page
//--- Close relatives
print "\n\t<div id=\"relatives\" class=\"tab_page\" style=\"position: $position; top: auto; left: ".$basexoffset."px; visibility: $visibility; z-index: 3; \">";
//-- print the names of the parents
   $hfamids = find_family_ids($pid);
   $hparents=false;
   if (count($hfamids)>0) {
	  $hparents=false;
	  for($j=0; $j<count($hfamids); $j++) {
		 if (!empty($hfamids[$j])) {
			$famlink = get_sub_record(1, "1 FAMC @".$hfamids[$j]."@", $indirec);
			print "<table><tr><td><img src=\"$PGV_IMAGE_DIR/$PGV_CFAMILY_IMG\" border=\"0\" class=\"icon\" alt=\"\" /></td><td><div class=\"subheaders\"><a href=\"family.php?famid=$hfamids[$j]\">";
			$ft = preg_match("/2 PEDI (.*)/", $famlink, $fmatch);
			if ($ft>0) print $pgv_lang[trim($fmatch[1])]." ";
			print $pgv_lang["as_child"];
			print "</a></div></td></tr></table>";
			print "\n\t<table class=\"facts_table\">";
			$famrec = find_family_record($hfamids[$j]);
			$hparents = find_parents_in_record($famrec);
			$newhparents = $hparents;
			if (userCanEdit(getUserName())) {
   				if ((isset($show_changes))&&(isset($pgv_changes[$hfamids[$j]."_".$GEDCOM]))) {
	   				$newrec = find_record_in_file($hfamids[$j]);
	   				$newhparents = find_parents_in_record($newrec);
	   				$newchil = array();
	   				$num = preg_match_all("/1\s*CHIL\s*@(.*)@/", $newrec, $smatch,PREG_SET_ORDER);
					for($i=0; $i<$num; $i++) {
						$newchil[] = $smatch[$i][1];
					}
   				}
			}
			if ($hparents) {
	            $styleadd="";
	            if ($hparents['HUSB']!=$newhparents['HUSB']) {
		            $styleadd="red";
		            if (!empty($newhparents['HUSB'])) {
						print "<tr><td class=\"facts_labelblue\">".$pgv_lang["father"]."</td><td class=\"facts_value, person_box\">";
						print_pedigree_person($newhparents['HUSB'],2,$view!="preview");
						print "</td></tr>\n";
					}
	            }
				if (!empty($hparents['HUSB'])) {
					print "<tr><td class=\"facts_label$styleadd\">".$pgv_lang["father"]."</td><td class=\"facts_value, person_box\">";
					print_pedigree_person($hparents['HUSB'],2,$view!="preview");
					print "</td></tr>\n";
				}
				$styleadd="";
	            if ($hparents['WIFE']!=$newhparents['WIFE']) {
		            $styleadd="red";
		            if (!empty($newhparents['WIFE'])) {
						print "<tr><td class=\"facts_labelblue\">".$pgv_lang["mother"]."</td><td class=\"facts_value$styleadd, person_boxF\">";
						print_pedigree_person($newhparents['WIFE'],2,$view!="preview");
						print "</td></tr>\n";
					}
	            }
				if (!empty($hparents['WIFE'])) {
					print "<tr><td class=\"facts_label$styleadd\">".$pgv_lang["mother"]."</td><td class=\"facts_value$styleadd, person_boxF\">";
					print_pedigree_person($hparents['WIFE'],2,$view!="preview");
					print "</td></tr>\n";
				}
			}
			//-- print the siblings
			$chil = array();
			$num = preg_match_all("/1\s*CHIL\s*@(.*)@/", $famrec, $smatch,PREG_SET_ORDER);
			for($i=0; $i<$num; $i++) {
				$spid = $smatch[$i][1];
				if ($spid!=$pid) {
					$chil[] = $spid;
					$styleadd="";
					if (isset($newchil)&&(!in_array($spid, $newchil))) $styleadd="red";
					print "<tr><td class=\"facts_label$styleadd\">";
					$srec = find_person_record($spid);
					$isf="";
					$ct = preg_match("/1 SEX F/", $srec);
					if ($ct>0) {
						print $pgv_lang["sister"];
						$isf="F";
					}
					else print $pgv_lang["brother"];
					print "</td><td class=\"facts_value$styleadd, person_box$isf\">";
					print_pedigree_person($spid,2,$view!="preview");
					print "</td></tr>\n";
				}
			}
			if (isset($newchil)) {
				for($i=0; $i<count($newchil); $i++) {
					if (!in_array($newchil[$i], $chil)) {
						print "<tr><td class=\"facts_labelblue\">";
						$srec = find_record_in_file($newchil[$i]);
						$isf="";
						$ct = preg_match("/1 SEX F/", $srec);
						if ($ct>0) {
							print $pgv_lang["sister"];
							$isf="F";
						}
						else print $pgv_lang["brother"];
						print "</td><td class=\"facts_valueblue, person_box$isf\">";
						print_pedigree_person($newchil[$i],2,$view!="preview");
						print "</td></tr>\n";
					}
				}
			}
			if (($view!="preview") && (userCanEdit(getUserName()))) {
				print "<tr><td class=\"facts_label\">".$pgv_lang["add_child"]."</td><td class=\"facts_value\"><a href=\"#\" onclick=\"return addnewchild('$hfamids[$j]');\">".$pgv_lang["add_child_to_family"]."</a></td></tr>\n";
			}
			print "\n\t</table>";
		}
	}
  }

//-- print the spouses and children
$famids = find_sfamily_ids($pid);
if (count($famids)>0) {
  $hparents=false;
  for($f=0; $f<count($famids); $f++) {
	 if (!empty($famids[$f])) {
		$famrec = find_family_record($famids[$f]);
		if ($famrec) {
		   print "<table><tr><td><img src=\"$PGV_IMAGE_DIR/$PGV_SFAMILY_IMG\" border=\"0\" class=\"icon\" alt=\"\" /></td><td><div class=\"subheaders\"><a href=\"family.php?famid=$famids[$f]\">".$pgv_lang["as_spouse"]."</a></div></td></tr></table>";
		   print "\n\t<table class=\"facts_table\">";
		   $parents = find_parents_in_record($famrec);
		   $newparents = $parents;
		   unset($newchil);
			if (userCanEdit(getUserName())) {
   				if ((isset($show_changes))&&(isset($pgv_changes[$famids[$f]."_".$GEDCOM]))) {
	   				$newrec = find_record_in_file($famids[$f]);
	   				$newparents = find_parents_in_record($newrec);
	   				$newchil = array();
	   				$num = preg_match_all("/1\s*CHIL\s*@(.*)@/", $newrec, $smatch,PREG_SET_ORDER);
					for($i=0; $i<$num; $i++) {
						$newchil[] = $smatch[$i][1];
					}
   				}
			}
			if($parents) {
				if($pid!=$parents["HUSB"]) {
					$spid=$parents["HUSB"];
					$spousetag = "HUSB";
				}
				else {
					$spid=$parents["WIFE"];
					$spousetag = "WIFE";
				}
				if (!empty($spid)) {
					$styleadd="";
					if ((!is_array($newparents))||(!in_array($spid, $newparents))) {
						if($pid!=$newparents["HUSB"]) $nspid=$newparents["HUSB"];
						else $nspid=$newparents["WIFE"];
						print "<tr><td class=\"facts_labelblue\">";
						$srec = find_person_record($nspid);
						$isf="";
						$ct = preg_match("/1 SEX F/", $srec);
						if ($ct>0) {
							print $pgv_lang["wife"];
							$isf="F";
						}
						else print $pgv_lang["husband"];
						print "</td><td class=\"facts_valueblue, person_box$isf\">";
						print_pedigree_person($spid, 2,$view!="preview");
						print "</td></tr>\n";
						$styleadd="red";
					}
					print "<tr><td class=\"facts_label$styleadd\">";
					$srec = find_person_record($spid);
					$isf="";
					$ct = preg_match("/1 SEX F/", $srec);
					if ($ct>0) {
						print $pgv_lang["wife"];
						$isf="F";
					}
					else print $pgv_lang["husband"];
					print "</td><td class=\"facts_value$styleadd, person_box$isf\">";
					print_pedigree_person($spid, 2,$view!="preview");
					print "</td></tr>\n";
				}
				else {
					print "<tr><td class=\"facts_label\">";
					if ($spousetag=="WIFE") print $pgv_lang["add_wife"];
					else print $pgv_lang["add_husb"];
					print "</td><td class=\"facts_value\">";
					print "<a href=\"#\" onclick=\"return addnewspouse('$famids[$f]', '$spousetag');\">".$pgv_lang["add_".strtolower($spousetag)."_to_family"]."</a>";
					print "</td></tr>\n";
				}
			}
		   $num = preg_match_all("/1\s*CHIL\s*@(.*)@/", $famrec, $smatch,PREG_SET_ORDER);
		   $chil = array();
		   for($i=0; $i<$num; $i++) {
			  $spid = $smatch[$i][1];
			  $chil[] = $spid;
			  $styleadd="";
			  if (isset($newchil)&&(!in_array($spid, $newchil))) $styleadd="red";
			  print "<tr><td class=\"facts_label$styleadd\">";
			  $srec = find_person_record($spid);
			  $ct = preg_match("/1 SEX F/", $srec);
			  $isf="";
			  if ($ct>0) {
				  print $pgv_lang["daughter"];
				  $isf="F";
			  }
			  else print $pgv_lang["son"];
			  print "</td><td class=\"facts_value$styleadd, person_box$isf\">";
			  print_pedigree_person($spid,2,$view!="preview");
			  print "</td></tr>\n";
		   }
		   if (isset($newchil)) {
				for($i=0; $i<count($newchil); $i++) {
					if (!in_array($newchil[$i], $chil)) {
						print "<tr><td class=\"facts_labelblue\">";
						$srec = find_record_in_file($newchil[$i]);
						$ct = preg_match("/1 SEX F/", $srec);
						$isf="";
						if ($ct>0) {
							print $pgv_lang["sister"];
							$isf="F";
						}
						else print $pgv_lang["brother"];
						print "</td><td class=\"facts_valueblue, person_box$isf\">";
						print_pedigree_person($newchil[$i],2,$view!="preview");
						print "</td></tr>\n";
					}
				}
			}
		   if (($view!="preview") && (userCanEdit(getUserName()))) {
			  print "<tr><td class=\"facts_label\">".$pgv_lang["add_child"]."</td><td class=\"facts_value\"><a href=\"#\" onclick=\"return addnewchild('$famids[$f]');\">".$pgv_lang["add_child_to_family"]."</a></td></tr>\n";
		   }
		   print "</table>";
		}
	 }
  }
}
print "<br />\n";
if (($view!="preview") && (userCanEdit(getUserName()))) {
   print "<a href=\"#\" onclick=\"return add_famc('$pid');\">".$pgv_lang["link_as"].$pgv_lang["child"]."</a><br />\n";
   if ($sex!="F") {
	   print "<a href=\"#\" onclick=\"return add_fams('$pid','HUSB');\">".$pgv_lang["link_as"].$pgv_lang["husband"]."</a><br />\n";
	   print "<a href=\"#\" onclick=\"return addspouse('$pid','WIFE');\">".$pgv_lang["add_new_wife"]."</a><br />\n";
   }
   if ($sex!="M") {
	   print "<a href=\"#\" onclick=\"return add_fams('$pid','WIFE');\">".$pgv_lang["link_as"].$pgv_lang["wife"]."</a><br />\n";
	   print "<a href=\"#\" onclick=\"return addspouse('$pid','HUSB');\">".$pgv_lang["add_new_husb"]."</a><br />\n";
   }
}
$without_close=true;
print "<table width=\"100%\"><tr><td align=\"center\">\n";
print_footer();
print "</td></tr></table>";
print "</div>";

//--------------------------------Start 4th tab individual page
//--- ResearchLog
if ($researchlog == TRUE) {
   print "\n\t<div id=\"researchlog\" class=\"tab_page\" style=\"position: $position; top: auto; left: ".$basexoffset."px; visibility: $visibility; z-index: 4; \">";
  if ($view=="preview"){
	 print "<font class=\"subheaders\">".$pgv_lang["research_log"]."</font>";
  }
   if (!$disp) {
	  print_privacy_error($CONTACT_EMAIL);
   }
  else {
	  // Check if there are any logs for this person
	  print "\n\t<table class=\"list_table\">";
	  print "\n\t\t<tr><td class=\"list_label\">".$pgv_lang["edit"]."</td><td class=\"list_label\">".$pgv_lang["delete"]."</td><td class=\"list_label\">ID</td><td class=\"list_label\">".$pgv_lang["completed"]."</td><td class=\"list_label\">".$pgv_lang["modified"]."</td><td class=\"list_label\">".$pgv_lang["created"]."</td><td class=\"list_label\">".$pgv_lang["source"]."</td><td class=\"list_label\">".$pgv_lang["people"]."</td></tr>";
	find_log($pid);
	  print "\n\t</table>";
	print "\n\t<br /><hr /><br /><a href=\"rs_editlog.php?pid=$pid\">".$pgv_lang["log_entry"]."</a><br /><br />";
   }
  print "<table width=\"100%\"><tr><td align=\"center\">\n";
  print_footer();
  print "</td></tr></table>";
  print "</div>\n";
}
?>

</body>
</html>
