<?php
/*=================================================
   charset=utf-8
   Project:	phpGedView
   File:	configure_help.da.php
   Author:	John Finlay
   Translation:	Arne Eckmann
   Comments:	Danish Language Configure Help file for PHPGedView
   Change Log:	5/1/03 - File Created
===================================================*/
# $Id: configure_help.da.php,v 1.26.2.3 2004/02/03 21:36:07 botak Exp $
if (preg_match("/configure_help\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}
//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"]			= "Konfigurer PHPGedView";
$pgv_lang["default_user"]		= "Opret hovedadministratoren.";
$pgv_lang["about_user"]			= "Du skal først oprette din hovedadministrator.  Denne bruger har rettigheder til at opdatere konfigurationsfiler, se private data, og oprette andre brugere.";
$pgv_lang["fullname"]			= "Fuldt navn:";
$pgv_lang["confirm"]			= "Bekræft Password:";
$pgv_lang["can_admin"]			= "Brugeren kan administrere:";
$pgv_lang["can_edit"]			= "Brugeren kan redigere:";
$pgv_lang["add_user"]			= "Tilføj ny bruger";
$pgv_lang["current_users"]		= "Nuværende brugerliste";
$pgv_lang["leave_blank"]		= "Lad password være tom, hvis du vil bevare det eksisterende password.";
$pgv_lang["other_theme"]		= "Other, please type in";
$pgv_lang["performing_update"]		= "Opdaterer.";
$pgv_lang["config_file_read"]		= "Config fil indlæst.";
$pgv_lang["does_not_exist"]		= "eksisterer ikke";
$pgv_lang["config_write_error"]		= "Fejl ved skrivning af konfigurationsfil.  Tjek rettigheder og prøv igen.";
$pgv_lang["db_setup_bad"]		= "Der er fejl i din nuværende database konfiguration.  Tjek venligst din databases forbindelsesparametre og omfigurer.";
$pgv_lang["click_here_to_continue"]	= "Klik her for at fortsætte.";
$pgv_lang["PGV_DATABASE_help"]		= "Dette instruerer phpGedView om hvilken databasetype du vil bruge til de gedcomfiler du importerer. Vælg 'Indeksfiler' for at bruge indeksfiler, der opbevares i index mappen, eller vælg 'MySQL' for at bruge en MySQL database. Dette indstiller \$PGV_DATABASE variable i config.php filen.";
$pgv_lang["PGV_DATABASE_help"]		= "Fortæller phpGedView hvilken databasetype du vil bruge til de GEDCOM filer du importerer ind i systemet. Vælg 'Indexfiler' hvis du vil bruge indexfiler der opbevares i index mappen, eller vælg 'MySQL' for at bruge en MySQL database. Dette indstiller \$PGV_DATABASE variable i config.php filen.";
$pgv_lang["PGV_DATABASE"]		= "PhpGedView database";
$pgv_lang["hebrew_and_gregorian"]	= "Hebræisk og Gregoriansk";
$pgv_lang["mouseover"]			= "Når musen føres henover";
$pgv_lang["mousedown"]			= "Når musen sænkes";
$pgv_lang["click"]			= "Ved klik på musen";
$pgv_lang["disabled"]			= "Fravalgt";
$pgv_lang["mailto"]			= "Mailto link";
$pgv_lang["messaging"]			= "PhpGedView interne beskeder";
$pgv_lang["messaging2"]			= "Interne beskeder med e-Email";
$pgv_lang["no_messaging"]		= "Ingen kontaktmetode";
$pgv_lang["no_logs"]			= "Ingen logning";
$pgv_lang["daily"]			= "Daglig";
$pgv_lang["weekly"]			= "Ugentlig";
$pgv_lang["monthly"]			= "Månedlig";
$pgv_lang["yearly"]			= "Årlig";

$pgv_lang["jewish_and_gregorian"]	= "Jødisk og Gregoriansk";
$pgv_lang["config_hebrew"]		= "Hebræisk";
$pgv_lang["jewish"]			= "Jødisk";
$pgv_lang["config_french"]		= "Fransk";
$pgv_lang["julian"]			= "Juliansk";
$pgv_lang["gregorian"]			= "Gregoriansk";
$pgv_lang["confirm_gedcom_delete"]	= "Er du sikker på du vil slette denne gedcomfil?";
$pgv_lang["show_phpinfo"]		= "Vis PHPInfo siden";
$pgv_lang["ged_config"]			= "Konfigurationsfil";
$pgv_lang["ged_title"]			= "Gedcom titel";
$pgv_lang["ged_gedcom"]			= "Gedcomfil";
$pgv_lang["current_gedcoms"]		= "Nuværende gedcomfiler";
$pgv_lang["ged_download"]		= "Download";
$pgv_lang["admin_gedcoms"]		= "Klik her, for at redigere gedcomfiler";
$pgv_lang["index"]			= "Indeksfiler";
$pgv_lang["mysql"]			= "MySQL";
$pgv_lang["config_help"]		= "Konfigurationshjælp";
$pgv_lang["DBHOST"] = "MySQL Database Host:";
$pgv_lang["DBHOST_help"] = "DNS eller IP address på den computer hvor din MySQL databaseserver er installeret.  Dette indstiller \$DBHOST variablen i config.php filen.";
$pgv_lang["DBUSER"] = "MySQL Database brugernavn:";
$pgv_lang["DBUSER_help"] = "Det MySQL database brugernavn, der er nødvendig for login på din database.  Dette indstiller \$DBUSER variablen i config.php filen.";
$pgv_lang["DBPASS"] = "MySQL Database password:";
$pgv_lang["USE_RIN"] = "Brug RIN# istedet for GEDCOM ID:";
$pgv_lang["USE_RIN_help"] = "Vælg JA for at bruge RIN nummeret instedet for GEDCOM ID når der spørges efter personers ID i konfigurationsfiler, brugerindstilliger, og træer. Dette er praktiskt for genealogiprogrammer som ikke eksporterer GEDCOM med samtidig person ID men altid bruger den samme RIN.<br /><br />Dette indstiller \$USE_RIN variable i config.php filen";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"] = "Max efterkommergenerationer";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"] = "Sætter det maksimale antal generationer der skal vises i efterkommertræer.<br /><br />Dette indstiller \$MAX_DESCENDANCY_GENERATIONS variable i config.php filen.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"] = "Max anetræsgenerationer";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"] = "Sætter maximalt antal generationer der skal vises i anetræer.<br /><br />Dette indstiller \$MAX_PEDIGREE_GENERATIONS variable i config.php filen.";
$pgv_lang["DBPASS_help"] = "MySQL database password for den bruger du indtastede i brugernavnfeltet.  Dette indstiller \$DBPASS variablen i config.php filen.";
$pgv_lang["SHOW_EMPTY_BOXES"] = "Vis tomme bokse i efterkommertræ:";
$pgv_lang["SHOW_EMPTY_BOXES_help"] = "Bestemmer hvorvidt der skal vises tomme bokse i anetræer eller ej.<br /><br />Dette indstiller \$SHOW_EMPTY_BOXES variable i config.php filen.";
$pgv_lang["ZOOM_BOXES"] = "Zoom bokse på træer:";
$pgv_lang["ZOOM_BOXES_help"] = "Gør det muligt for en bruger at zoome bokse i træer og få yderligere information. Vælg \"Fravalgt\" for at fravælge denne feature. Vælg \"Når musen føres henover\" for at få zoomet bokse når brugeren bevæger musen henover ikonet i boksen. Vælg \"Ved klik på mus\" for at få zoomet bokse når en bruger klikker på ikonet i boksen.<br /><br />Dette indstiller \$ZOOM_BOXES variable i config.php fil.";
$pgv_lang["LINK_ICONS_help"] = "Gør det muligt for brugere at vælge link til andre træer og nære slægtninge til den pågældende person. Vælg \"Fravalgt\" for at fravælge denne feature. Vælg \"Når musen føres henover\" for at få link til at lave popup når brugeren bevæger musen henover ikonet i boksen. Vælg \"Ved klik på mus\" for at få popup når en bruger klikker på ikonet i boksen.<br /><br />Dette indstiller \$LINK_ICONS variable i config.php filen.";
$pgv_lang["LINK_ICONS"] = "PopUp link på træer:";
$pgv_lang["DBNAME"] = "Database Name:";
$pgv_lang["DBNAME_help"] = "Den database i MySQL serveren, som du vil have phpGedView til at bruge.  Det brugernavn du indtastede i brugerfeltet må have ret til at lave create, insert, update, delete, og select på denne database.  Dette indstiller \$DBNAME variablen i config.php filen.";
$pgv_lang["TBLPREFIX"] = "Database Table Prefiks:";
$pgv_lang["TBLPREFIX_help"] = "Et prefiks der påhæftes de MySQL tabeller som phpGedView har oprettet.  Ved at ændre denne værdi kan du sætte adskillige phpGedView sites op til at bruge den samme database men med forskellige tabeller.  Dette indstiller \$TBLPREFIX variablen i config.php filen.";
$pgv_lang["DEFAULT_GEDCOM"] = "Default GEDCOM:";
$pgv_lang["DEFAULT_GEDCOM_help"] = "PhpGedViews MySQL version gør det muligt at arbejde med flere datasæt samtidigt.  Brug denne variable til at fastsætte hvilket GEDCOM datasæt nye brugere får tildelt som udgangspunkt, når de første gang kommer til din site.  Hvis boksen efterlades tom, vælges automatisk den gedcom der først blev importeret.  Hvis du tillader en bruger at skifte GEDCOM, vil der være et link på alle sider, der tillader dem at skifte mellem de GEDCOM datasæt de bruger.  Dette indstiller \$DEFAULT_GEDCOM variablen i config.php filen.";
$pgv_lang["ALLOW_CHANGE_GEDCOM"] = "Tillad besøgende at skifte gedcom:";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"] = "Upload først din gedcom fil til et sted der kan nås af din servers php installation.  Indtast derefter stien til filen her.  Dette indstiller \$ALLOW_CHANGE_GEDCOM variablen i config.php filen.";
$pgv_lang["GEDCOM"] = "Gedcom sti:";
$pgv_lang["gedcom_path_help"] = "Upload først din gedcom fil til et sted der kan nås af din servers php installation.  Indtast derefter stien til filen her.  Dette indstiller \$GEDCOM variablen i config.php filen.<br /><br />Læs <a href=\"readme.txt\">Readme.txt</a> filen for yderligere hjælp.";
$pgv_lang["CHARACTER_SET"] = "Karaktersæt:";
$pgv_lang["ALLOW_EDIT_GEDCOM"] = "Aktiver onlineredigering";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"] = "Aktiverer online redigering for denne gedcom så brugere med redigeringsrettigheder kan opdatere denne gedcom online.<br /><br />Dette indstiller \$ALLOW_EDIT_GEDCOM variable i config.php filen.";
$pgv_lang["CHARACTER_SET_help"] = "Dette er din gedcom fils karaktersæt.  UTF-8 anbefales, og skulle fungere for de fleste sites.  Hvis du eksporterer din gedcom i IBM Windows karaktersættet (codepage), skal du skrive WINDOWS her.<br />Dette indstiller \$CHARACTER_SET variablen i config.php filen.<br /><br />NOTE: PHP understøtter IKKE UNICODE (UTF-16) så det nytter ikke noget at klage over dette til PHP folk :-)";
$pgv_lang["LANGUAGE"] = "Sprog:";
$pgv_lang["LANGUAGE_help"] = "Vælg det sprog din site bruger som udgangspunkt.  Brugerne har mulighed for at ignorere denne indstilling og istedet selv vælge sprog, enten ved at lade deres browsers sprogpreference styre, eller ved selv at vælge sprog på siden, hvis ENABLE_MULTI_LANGUAGE = true.<br />Dette indstiller \$LANGUAGE variablen i config.php filen.";
$pgv_lang["SHOW_PEDIGREE_PLACES"] = "Stednavnsniveauer der vises i personboksene:";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"] = "Viser hvor meget stednavninformation der vises i træernes personbokse. Vælges 9 vil alle stednavnsniveauer blive vist. Vælges 0, skjules stednavne totalt. Vælges 1, vises  første niveau, 2 viser 2 niveauer osv.<br /><br />Dette indstiller \$SHOW_PEDIGREE_PLACES variable i config.php filen";
$pgv_lang["SHOW_ID_NUMBERS_help"] = "Vis ID numre i parenteser efter personnavn..<br /><br />Dette indstiller  \$SHOW_ID_NUMBERS variable i config.php filen.";
$pgv_lang["SHOW_ID_NUMBERS"] = "Vis ID numre ved navne:";
$pgv_lang["NAME_FROM_GEDCOM"] = "Hent displaynavn fra GEDCOM:";
$pgv_lang["NAME_FROM_GEDCOM_help"] = "Som standard bruger phpGedView det navn der er gemt i indexes til at finde en persons navn. Med visse gedcom formater og sprog vises det sorterbare navn der gemmes indexes ikke tilfredsstillende, og den bedste måde at få navnet vist korrekt, er at hente det fra gedcomfilen. Spanske navne er et godt eksempel. Et spansk navn kan bestå af Fornavn Fars efternavn Mors efternavn. Når Indexes bruges til sortering og fremvisning, vil navnet blive vist som Fornavn Mors efternavn Fars efternavn, og dette er ikke korrekt. Hentes navnet derimod i gedcomfilen, vil det blive vist korrekt. Men, samtidig sløver det også phpGedView, når navnet skal hentes fra gedcomfilen.<br /><br />Dette indstiller \$NAME_FROM_GEDCOM variable i config.php filen";
$pgv_lang["CALENDAR_FORMAT"] = "Kalenderformat";
$pgv_lang["CALENDAR_FORMAT_help"] = "Tillader dig at specificere hvilken type kalender du vil bruge sammen med denne gedcomfil. Hebræisk er det samme som den jødiske kalender med hebræiske tegn. Note: Værdierne for jødisk / hebræiske datoer er beregnet fra de Gregorianske / Julianske datoer. Eftersom den jødiske kalenderdag starter ved mørkningen vil alle begivenheder der finder sted mellem mørkningen og midnat blive vist en dag tidligere end den korrekte jødiske dato. Gamle browsere kan have problemer med at vise hebræisk. Visse gamle browsere viser hebræisk baglæns eller slet ikke.<br /><br />Dette indstiller \$CALENDAR_FORMAT variable i config.php filen";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"] = "Jødisk Ashkenazi udtale:";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"] = "Vis hebræiske tusinder:";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"] = "Vis Alafim i Hebræiske kalendere. Sættes den til ja, vises året 1969 som <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; men sættes den til nej, vises året som <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Dette har ingen indflydelse på den jødiske år indstilling. Året bliver vist som 5729 uanset denne indstilling.<br />Dette indstiller  \$DISPLAY_JEWISH_THOUSANDS variable i config.php filen.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"] = "Vis hebræisk Geyrshayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"] = "Viser enkelt og dobbelt anførselsten ved visning af hebræiske datoer. Ved ja-indstilling vises d. 8 februar 1969 som <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; hvorimod nej-indstillingenviser datoen som <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Dette påvirker ikke jødisk år indstillingen fordi der ikke bruges anførselstegn i jødiske datoer, der vises med Latin tegnsættet.<br />Dette indstiller \$DISPLAY_JEWISH_GERESHAYIM variable i config.php filen.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "Brug jødisk Ashkenazi udtale.<br />Hvis sat til ja vil månederne Cheshvan og Teves være stavet med Ashkenazi udtale. Hvis sat til nej vil månederne være stavet Hesvan og Tevet. <br />Dette vedrører kun den jødiske indstilling. Med hebræisk indstilling bruges det hebræiske alfabet.<br />Dette indstiller \$JEWISH_ASHKENAZ_PRONUNCIATION variable i config.php filen.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"] = "Tillad brugere at skifte sprog:";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "Sættes til 'ja' hvis brugerne skal have mulighed for at vælge et andet sprog fra en dropdown liste på siden, eller være styret af sprogpreferencen i brugernes browsere.<br />Dette indstiller \$ENABLE_MULTI_LANGUAGE variablen i config.php filen.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"] = "Antal generationer i anetræ:";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"] = "Sæt antallet af generationer, der som udgangspunkt skal vises i anetræer<br />Dette indstiller \$DEFAULT_PEDIGREE_GENERATIONS variablen i config.php filen.";
$pgv_lang["PEDIGREE_ROOT_ID"] = "Standard proband i anetræ og efterkommervisning:";
$pgv_lang["PEDIGREE_ROOT_ID_help"] = "Sætter ID på den person, der som udgangspunkt er valgt som proband ved visning af anetræ og og efterkommervisning<br />Dette indstiller \$PEDIGREE_ROOT_ID variablen i config.php filen.";
$pgv_lang["GEDCOM_ID_PREFIX"] = "Gedcom ID præfiks:";
$pgv_lang["GEDCOM_ID_PREFIX_help"] = "Med mindre brugerne selv tilføjer et præfiks når de indtaster en ID, vil dette præfiks blive brugt i forbindelse med anetræer, efterkommertræer, slægtsrelationstr&aeli;er, og andre træer.<br /><br />Dette indstiller \$GEDCOM_ID_PREFIX variable i config.php filen.";
$pgv_lang["PEDIGREE_FULL_DETAILS"] = "Viser fødsel og død detaljer på anetræer og efterkommervisninger:";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] = "Fortæller, hvorvidt en persons fødsel og død detaljer skal vises som udgangspunkt<br />Dette indstiller \$PEDIGREE_FULL_DETAILS variablen i config.php filen.";
$pgv_lang["PEDIGREE_LAYOUT"] = "Standard anetræ layout:";
$pgv_lang["PEDIGREE_LAYOUT_help"] = "Dette bestemmer om anetræet skal udprintes i landskabs eller portræt orientering.<br /><br />Dette indstiller \$PEDIGREE_LAYOUT variable i config.php filen. ";
$pgv_lang["AUTHENTICATION_MODULE"] = "Authentication Module Fil:";
$pgv_lang["AUTHENTICATION_MODULE_help"] = "Dette er en fil, fra hvilken der kan indlæses authentication funktioner.  Ved at implementere funktionerne i denne fil, kan brugere tilpasse phpGedView til at bruge nogle andre metoder til at authenticate brugere og gemme brugere i andre brugerdatabaser.  Man kan håbe, at andre brugere er indstillet på at dele deres custom authentication moduler med andre phpGedView brugere.<br /><br />Dette indstiller \$AUTHENTICATION_MODULE variablen i config.php filen.";
$pgv_lang["PRIVACY_MODULE"] = "Privacy fil:";
$pgv_lang["PRIVACY_MODULE_help"] = "En fil, fra hvilken der kan indlæses privacy funktioner. Se <a href=\"http://gendorbendor.sourceforge.net\">http://gendorbendor.sourceforge.net</a> for yderligere information og for at downloade alternative privacy add-ons.<br />Dette indstiller \$PRIVACY_MODULE variablen i config.php filen.";
$pgv_lang["HIDE_LIVE_PEOPLE"] = "Skjul nulevende personer:";
$pgv_lang["HIDE_LIVE_PEOPLE_help"] = "Denne funktion instruerer PhpGedView om at skjule personlige detaljer nulevende personer.  Nulevende personer defineres som de, der ikke har en begivenhed registreret længere tilbage end for $MAX_ALIVE_AGE år år siden, og som ikke har nogen børn, der blev født for mere end $MAX_ALIVE_AGE år siden.<br />Dette indstiller \$HIDE_LIVE_PEOPLE variablen i config.php filen.";
$pgv_lang["REQUIRE_AUTHENTICATION_help"] = "Ved at sætte denne mulighed tvinges alle besøgende til login før de kan se data på sitet.<br /><br />Dette indstiller \$REQUIRE_AUTHENTICATION variable i config.php file.";
$pgv_lang["REQUIRE_AUTHENTICATION"] = "Kræv login af besøgende:";
$pgv_lang["CHECK_CHILD_DATES"] = "Check børns data:";
$pgv_lang["CHECK_CHILD_DATES_help"] = "Undersøger børnenes data, når det skal bestemmes om en person opfattes som nulevende eller død.  På ældre PC'er og store gedcom filer kan sådanne undersøgelser sinke din sites svartider.<br />Dette indstiller \$CHECK_CHILD_DATES variablen i config.php filen.";
$pgv_lang["MAX_ALIVE_AGE"] = "Den alder, hvor en person må anses for at være død:";
$pgv_lang["MAX_ALIVE_AGE_help"] = "Dette er den maksimale alder, hvor der kan eksistere en begivenhed på personen, eller den maksimale alder på personens børn, der bruges til at bestemme om en person skal anses for at være død eller ej.<br />Dette indstiller \$MAX_ALIVE_AGE variablen i config.php filen.";
$pgv_lang["SHOW_GEDCOM_RECORD"] = "Tillad brugere at se GEDCOM records:";
$pgv_lang["SHOW_GEDCOM_RECORD_help"] = "Sættes denne til yes, bliver der placeret link på personer, kilder, og familier, der gør det muligt for brugere at åbne et separat vindue med GEDCOM koden taget direkte fra gedcom filen.<br />Dette indstiller \$SHOW_GEDCOM_RECORD variablen i config.php filen.";
$pgv_lang["INDEX_DIRECTORY"] = "Indekseringsfilernes mappe:";
$pgv_lang["INDEX_DIRECTORY_help"] = "Dette er stien til en - læse og skrivbar - mappe, hvor PhpGedView skal gemme indekseringsfiler (husk stiens afsluttende \"/\")<br />Dette indstiller \$INDEX_DIRECTORY variablen i config.php filen.";
$pgv_lang["ALPHA_INDEX_LISTS"] = "Opdel lange lister efter efternavnes første bogstav:";
$pgv_lang["ALPHA_INDEX_LISTS_help"] = "For meget lange person og familielister, sæt denne option til true for at splitte listen i sider opdelt efter det første bogstav i efternavnet. <br />Dette indstiller \$ALPHA_INDEX_LISTS variablen i config.php filen.";
$pgv_lang["MULTI_MEDIA"] = "Aktiver multimedia features:";
$pgv_lang["MULTI_MEDIA_help"] = "GEDCOM 5.5 tillader dig at linke billeder, videoer, og andre multimedia objekter i din GEDCOM.  Hvis du ikke har inkluderet multimedia objekter i din gedcom, kan du fravælge multimedia features ved at sætte denne værdi til 'no'. <br />Se multimedia afsnittet i <a href=\"readme.txt\">readme.txt</a> filen for yderligere oplysning om at inkludere media på dit site.<br />Dette indstiller \$MULTI_MEDIA variablen i config.php filen.";
$pgv_lang["MEDIA_DIRECTORY"] = "MultiMedia mappe:";
$pgv_lang["MEDIA_DIRECTORY_help"] = "Stien til en læselig mappe, hvor PhpGedView skal kigge efter lokale multimedia filer (inklusiv den afsluttende skråstreg \"/\")<br />Dette indstiller \$MEDIA_DIRECTORY variablen i config.php filen.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"] = "Antallet af multi-media mappeniveauer:";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"] = "Værdien 0 ignoreres i alle mapper i media objektets fil sti.  Værdien 1 vil også bruge den første mappe der indeholder dette billede.  Ved at øge værdien øges antallet af mappeniveauer der skal inkluderes i stien.  <br />Eksempel: hvis du linker et billede i din gedcom med en sti som C:\\Documents and Settings\\User\\My Documents\\My Pictures\\Genealogy\\Surname Line\\grandpa.jpg vil en værdi af 0 svare til denne sti ./media/grandpa.jpg.  En værdi af 1 vil svare til  ./media/Surname Line/grandpa.jpg, etc.  De fleste mennesker vil kunne klare sig med værdien 0.  Men, forskellige media objekter der hedder det samme, vil så overskrive hinanden.  Denne indstilling tillader dig at organisere dine media således at navnesammenfald ikke giver problemer.<br />Dette indstiller \$MEDIA_DIRECTORY_LEVELS variablen i config.php filen.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"] = "Vis udvalgte billeder i personernes bokse:";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] = "Hvis du har aktiveret multimedia på dit site, kan PhpGedView vise små billeder (thumbnail) ved siden af personernes navne i tableauer og træer og bokse.  For indeværende bruger PhpGedView det første multimedia objekt der er listet i en gedcom record som det udvalgte billede.  For personer med flere billeder, skal du arrangere multimedia objekterne således at det billede du ønsker udvalgt er placeret f&oring;r de andre.<br />Se multimedia afsnittet i <a href=\"readme.txt\">readme.txt</a> filen for yderligere oplysning om at inkludere media på dit site.<br />Dette indstiller \$SHOW_HIGHLIGHT_IMAGES variablen i config.php filen.";
$pgv_lang["ENABLE_CLIPPINGS_CART"] = "Aktiver udklipsmappe:";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] = "Udklipsmappen tillader de besøgende på din site at tage udklip af dine data og tilføje disse til en udklipsfil, de senere kan downloades som en gedcom fil og importeres ind i deres egen slægtsprogram.<br />Dette indstiller \$ENABLE_CLIPPINGS_CART variablen i config.php filen.";
$pgv_lang["HIDE_GEDCOM_ERRORS"] = "Skjul GEDCOM fejlmeldinger:";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"] = "Ved at vælge 'yes' her, skjules de fejlmelding som PhpGedView laver, når der stødes på en ukendt gedcom tag i din gedcom fil.  PhpGedView bestræber sig på at følge GEDCOM 5.5 standarden, men visse slægtsprogrammer tilføjer deres egne specielle tags.  Se <a href=\"readme.txt\">readme.txt</a> filen for yderligere information.<br />Dette indstiller \$HIDE_GEDCOM_ERRORS variablen i config.php filen.";
$pgv_lang["WORD_WRAPPED_NOTES"] = "Tilføj mellemrum hvor noter er wrapped:";
$pgv_lang["WORD_WRAPPED_NOTES_help"] = "Visse slægtsforskningsprogrammer wrapper noter i mellemrum mellem ord, mens andre slægtsforskningsprogrammer wrapper noter hvor som helst.  Disse forskelle kan bevirke at PhpGedView utilsigtet kan komme til at sammenskrive ord, der ikke skal sammenskrives.  Hvis du vælger 'yes' her, vil der blive tilføjet et mellemrum i det punkt hvor ord er wrapped i gedcom.<br />Dette indstiller \$WORD_WRAPPED_NOTES variablen i config.php filen.";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Vis ? hjælpelink på siderne:";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "Denne valgmulighed aktiverer sp&oring;rgsmålstegns hjælpelink på de angivne sider, således besøgende kan få relevant hjælp omkring de pgl. siders valgmuligheder.&lt;br /&gt;&lt;br /&gt; Dette indstiller \$SHOW_CONTEXT_HELP variable i config.php filen.";
$pgv_lang["HOME_SITE_URL"] = "Hjemmeside URL:";
$pgv_lang["HOME_SITE_URL_help"] = "Denne URL er inkluderet i det medleverede temas headers, og bruges til at generere et link til din hjemmeside.<br />Dette indstiller \$HOME_SITE_URL variablen i config.php filen.";
$pgv_lang["HOME_SITE_TEXT"] = "Hjemmeside betegnelse:";
$pgv_lang["HOME_SITE_TEXT_help"] = "Teksten på det link, der henviser til din hjemmeside.<br />Dette indstiller \$HOME_SITE_TEXT variablen i config.php filen.";
$pgv_lang["CONTACT_EMAIL"] = "Slægtskontakter e-mail:";
$pgv_lang["CONTACT_EMAIL_help"] = "Den e-mail adresse besøgende kan bruge til kontakt vedrørende din sites slægtsmateriale.<br />Dette indstiller \$CONTACT_EMAIL variablen i config.php filen.";
$pgv_lang["WEBMASTER_EMAIL"] = "Support kontakt:";
$pgv_lang["WEBMASTER_EMAIL_help"] = "Den e-mail adresse besøgende kan bruge til kontakt vedrørende tekniske spørgsmål eller fejl de er stødt på under besøget på din site.<br />Dette indstiller \$WEBMASTER_EMAIL variablen i config.php filen.";
$pgv_lang["CONTACT_EMAIL"] = "Slætsforskningskontakt:";
$pgv_lang["CONTACT_EMAIL_help"] = "The User visitors should contact about the genealogical data on this site.<br /><br />dette indstiller \$CONTACT_EMAIL variable i config.php filen.";
$pgv_lang["CONTACT_METHOD"] = "Kontaktmetode:";
$pgv_lang["CONTACT_METHOD_help"] = "Den metode besøgende bruger til at kontakte \"Contact User\" om slægtsforskningsspørgsmål. 'Mailto' muligheden tilføjer et mailto link som besøgende kan klikke på for at sende en e-mail med deres mailprogram. 'Besked' muligheden bruger PhpGedViews beskedsystem, og der sendes ingen e-mail. 'Besked med e-mail' muligheden er standard og bruger PhpGedViews beskedsystem, men sender også kopier af beskedderne med e-mail.  Vælges ingen besked muligheden, kan besøgende ikke kontakte dig.<br /><br />Dette indstiller \$CONTACT_METHOD variable i config.php filen.";
$pgv_lang["SUPPORT_METHOD"] = "Supportmetode:";
$pgv_lang["SUPPORT_METHOD_help"] = "Den metode beøgende bruger til at kontakte \"Support\" om slægtsforskning. 'Mailto' muligheden tilføjer et mailto link som besøgende kan klikke på for at sende en e-mail med deres mailprogram. 'Besked' muligheden bruger PhpGedViews beskedsystem, og der sendes ingen e-mail. 'Besked med e-mail' muligheden er standard og bruger PhpGedViews beskedsystem, men sender også kopier af beskedderne med e-mail.  Vælges ingen besked muligheden, kan besøgende ikke kontakte dig.<br /><br />Dette indstiller \$SUPPORT_METHOD variable i config.php filen.";
$pgv_lang["FAVICON"] = "Favorit icon:";
$pgv_lang["FAVICON_help"] = "Peger på det ikon du vil have vist i dine besøgendes \"foretrukne\" menu, når de føjer din site til deres \"foretrukne\" men.<br />Dette indstiller \$FAVICON variablen i config.php filen.";
$pgv_lang["THEME_DIR"] = "Tema mappe:";
$pgv_lang["PGV_SESSION_SAVE_PATH"] = "Session Save Path";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"] = "Sti til der hvor phpGedViews sessionfiler gemmes. Det er ikke alle webhoteller der har konfigureret deres PHP korrekt, og derved kan sessiondata gå tabt ved sideskift. Denne indstilling gør det muligt for administratorer at kompensere for denne webhotel fejl, ved istedet at gemme sessionfiler i en lokal mappe på deres egen site. Til det formål er ./index/ mappen et oplagt valg, hvis det er nødvendigt at ændre denne sti. Som udgangspunkt skal boksen være tom, idet indstillingen fra php.ini filen så bruges. Boksen skal kun udfyldes, hvis sessiondata går tabt.<br /><br />Dette indstiller \$PGV_SESSION_SAVE_PATH variable i config.php filen.";
$pgv_lang["SERVER_URL_help"] = "Hvis du bruger https eller en anden port end standard porten, er du nødt til indtaste den URL pgl. URL her. <br /><br />Dette indstiller \$SERVER_URLvariable i config.php filen.";
$pgv_lang["SERVER_URL"] = "Session URL:";
$pgv_lang["SHOW_STATS"] = "Vis udførselsstatistik:";
$pgv_lang["SHOW_STATS_help"] = "Vis runtime-statistik og antal database queries i bunden af hver side.<br /><br />Dette indstiller \$SHOW_STATS variable i config.php filen.";
$pgv_lang["USE_REGISTRATION_MODULE"] = "Tillad brugere at rekvirere en brugerkonto:";
$pgv_lang["USE_REGISTRATION_MODULE_help"] = "Giver brugere mulighed for at skrive sig selv op til en konto på sitet. Registreringen skal godkendes af en administrator før kontoen bliver aktiveret.<br /><br />Dette indstiller \$USE_REGISTRATION_MODULE variable i config.php filen.";
$pgv_lang["ALLOW_USER_THEMES"] = "Tillad brugere at vælge deres eget tema:";
$pgv_lang["ALLOW_USER_THEMES_help"] = "Giver brugere mulighed for selv at vælge deres eget tema.<br /><br />Dette indstiller \$ALLOW_USER_THEMES variable i config.php filen.";
$pgv_lang["CREATE_GENDEX"] = "Lav Gendex fil";
$pgv_lang["CREATE_GENDEX_help"] = "Vis PhpGedView generere Gendex filer når en Gedcom importeres. Gendex filer gemmes i index mappen.<br /><br />Dette indstiller \$CREATE_GENDEX variable i config.php filen.";
$pgv_lang["gedcom_title_help"] = "Indtast en titel, der beskriver dit indhold i denne GEDCOM file.";
$pgv_lang["LOGFILE_CREATE"] = "Arkiver logfiler:";
$pgv_lang["LOGFILE_CREATE_help"] = "Hvor tit skal programmet arkivere logfiler.<br /><br />Dette indstiller \$LOGFILE_CREATE variable i config.php filen.";
$pgv_lang["PGV_SESSION_TIME_help"] = "Den tid i sekunder, som en PhpGedView session forebliver aktiv før der kræves nyt login. Standard er 30 minutter.<br /><br />Dette sætter \$PGV_SESSION_TIME variable i config.php filen";
$pgv_lang["PGV_SESSION_TIME"] = "Session timeout";
$pgv_lang["THEME_DIR_help"] = "Den mappe hvor dine PhpGedView tema filer opbevarest.  Du kan ændre og/eller tilpasse et hvilket som helst af de standard temaer der leveres med PhpGedView for at give din site et særligt udseende.  Se tema tilpasningsafsnittet i <a href=\"readme.txt\">readme.txt</a> filen for yderligere information.<br />Dette indstiller \$THEME_DIR variablen i config.php filen.";
$pgv_lang["TIME_LIMIT"] = "PHP time limit:";
$pgv_lang["TIME_LIMIT_help"]	= "Den maksimale tid i sekunder, som PhpGedView skal have lov til at arbejde.  Som udgangspunkt er det sat til 1 minut.  Afhængig af størrelsen på din gedcom fil, kan du evt. øge denne tidsbegrænsning når du har brug for at indeksere.  Hvis denne værdi sættes til 0, tillader du PHP at køre uendeligt.<br />ADVARSEL: Hvis værdien sættes til 0 eller sættes for højt, kan få din site til at \"hænge\" på visse operativsystemer indtil scriptet afsluttes.  At sætte værdien til 0 betyder at scriptet ikke afsluttes før en netværksadministrator stopper processen eller genstarter serveren.  Det kan tage meget lang tid at lave et stort anetræ, så ved at sætte denne værdi så lav som muligt, kan det sikre mod at en eller anden får din webserver til at bryde sammen, ved at forsøge, at lave et 1000 generationers træ.";

$pgv_lang["welcome"]		= "Velkommen til din nye PhpGedView website.  Eftersom du kan se denne tekst, har du haft succes med at installere PhpGedView på din webserver, og kan nu konfigurere PhpGedView efter dine ønsker.<br />";
$pgv_lang["welcome_help"]	= "Dette hjælpevindue kan hjælpe dig gennem konfigurationsprocessen. Ved indtastning/valg af de forskellige felter, vil dette vindue indeholde oplysninger om det pågældende felt. Det er okay at lukke vinduet. For at åbne det igen, skal der klikkes på en af \"?\" spørgsmålstegnene ud for det pgl. felt.";
$pgv_lang["review_readme"]	= "Læs venligst <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> filen før du fortsætter med at konfigurere PhpGedView.<br /><br />Du kan altid vende tilbage til dette konfigurationsafsnit ved at pege på configure.php filen i din browsers adresselinje.<br /><br />Du kan få hjælp til hvert punkt ved at klikke på &quot;?&quot; på hver enkel cellemærkat.";
$pgv_lang["save_config"]	= "Gem konfiguration";
$pgv_lang["reset"]		= "Reset";
$pgv_lang["download_gedconf"]	= "Download GEDCOM konfiguration.";
$pgv_lang["download_here"]	= "Klik her for at downloade fil.";
$pgv_lang["not_writable"]	= "Det har vist sig, at PHP ikke kan skrive i konfigurationsfilen. Du kan derfor bruge download knappen til gemme dine indstillinger i en fil, som du bagefter uploade manuelt.";
$pgv_lang["download_file"]	= "Download fil";
$pgv_lang["upload_to_index"]	= "Upload filen til din index mappe:";

//-- edit privacy messages
$pgv_lang["add_new_pp_setting"]			= "Tilføj ny [\$person_privacy] - indstilling";
$pgv_lang["add_new_up_setting"]			= "Tilføj ny [\$user_privacy] - indstilling";
$pgv_lang["add_new_pf_setting"]			= "Tilføj ny [\$person_facts] - indstilling";
$pgv_lang["add_new_pf_setting_source"]		= "Tilføj nyt emnes faktaindstilling for kilder";
$pgv_lang["add_new_pf_setting_indi"]		= "Tilføj nyt emnes faktainstilling for individer";
$pgv_lang["privacy_indi_id"]			= "Individ - ID";
$pgv_lang["privacy_source_id"]			= "Kilde - ID";
$pgv_lang["privacy_indi_source"]		= "Individ / Kilde";
$pgv_lang["privacy_indi"]			= "Individ";
$pgv_lang["privacy_source"]			= "Kilde";
$pgv_lang["choice"]				= "Valg";
$pgv_lang["unable_to_find_privacy_indi"]	= "Kan ikke finde individ med id";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Vis nulevendes navne";
$pgv_lang["SHOW_RESEARCH_LOG"]			= "Vis forskningslog";
$pgv_lang["fact_details"]			= "Vis detaljerede fakta";
$pgv_lang["privacy_header"]			= "Rediger privalivsindstillinger indeni";
$pgv_lang["fact_show"]				= "Vis fakta";
$pgv_lang["save_and_import"]			= "Efter du har gemt denne GEDCOM konfiguration er det nødvendigt at importere GEDCOM ved at klikke på <b>Importer Gedcom</b> knappen eller fra <b>Administration->Administrer Gedcomfiler->Importer Gedcom</b>";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Brug privatliv på relationer";
$pgv_lang["help_info"]				= "Du kan få hjælp for hver enhed ved at klikke på det røde &quot;?&quot; ved benævnelsen ud for hver celle.";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "Vis nulevendes navne<br /><br />Skal nulevende personers navne vises til enhver?.<br /><br />Dette indstiller \$SHOW_LIVING_NAMES variable i den valgte privatlivs fil.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "Check ægteskabs relationer<br /><br />Check slægtninge gennem ægteskabsrelationer.<br /><br />Dette indstiller \$CHECK_MARRIAGE_RELATIONS variabler i den valgte privatlivsfil.";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "Vis afdøde personer<br /><br />Indstiller privatlivsniveauet for alle afdøde personer.";
$pgv_lang["person_privacy_help"]		= "\"person_privacy\" indstillingen giver administratorer mulighed for at ændre privalivs indstillingen for en bestemt person i gedcomfilen. Lad os sige du f.eks. har et barn, der døde som spæd. Normalt vil enhver kunne se alle detaljer der vises til enhver, fordi barnet er dødt. Men, for dig og familien er disse detaljer stadig private. Du vil ikke fjerne dødsindførslen, men du vil skjule detaljerne og bevare dem som private. Hvis dette barn har ID I100 skal du indsætte flg. privatlivsindstillinger: <br /><br />ID: I100<br />Vis til:\"Vis kun til godkendte brugere\"<br /><br />Dette virker også den anden vej. Hvis du vil vise enhver detaljer om en person (ID 101) som du ved er død, men som ikke er registreret som død, kan du tilføje flg.:<br /><br />ID: I101<br />Vis til: \"Vis til enhver\"<br /><br />Dette indstiller \$person_privacy variable i den valgte privatlivsfil.";
$pgv_lang["user_privacy_help"]			= "\"user_privacy\" indstillingen giver administratorer mulighed for at omgå den normale privatlivsindstilling for et individ i gedcomfilen baseret på en brugers brugernavn.<br /><br />Så hvis du ikke vil have  at brugernavnet \"John\" kan se dine private oplysninger, og du har ID I100 i gedcomfilen, kan du konfigurere således:<br /><br />Brugernavn: John<br />ID: I100<br />Vis?: \"Gem\"<br /><br />hvorefter dine data kun vil være skjult for brugernavnet \"John\".<br /><br />For at vise I101's data (der normalt vil være skjult fordi I101 er nulevende) til brugernavnet \"John\" skal du indstille:<br /><br />Brugernavn: John<br />ID: I101<br />Vis?: \"Vis\"<br /><br />Dette indstiller \$user_privacy variable i den valgte privatlivsfil.";
$pgv_lang["global_facts_help"]			= "\"global_facts\" indstillingen definerer fakta, der på global niveau skal skjules hos alle individer i gedcomfilen.<br /><br />[\"Benævnelse på fakta\"] elementet bestemmer hvilken fakta der skal skjules. [\"Valg\"] elementet vælger selve fakta eller relaterede detaljer. [\"Vis til\"] elementet bestemmer på hvilket adgangsniveau fakta vises.<br /><br /> \$global_facts array er beregnet til - på basis af GEDCOM tag - at skjule visse fakta for alle individer, hvadenten disse er nulevende eller døde. SSN tag er som udgangspunkt skjult for almindelige besøgende. Dette forhindrer folk i at stjæle social security numbers og dermed stjæle dine afdødes identitet, hvilket formentlig er mest relevant for USA's vedkommende. <br />Hvis du vil skjule alle ægteskabsdata i din gedcomfil for almindelige besøgende, kan du indstille:<br /><br />Navn på fakta: (MARR) - Marriage<br />Valg: \"Vis fakta\"<br />Vis til?: \"Vis kun til godkendte brugere\"<br /><br />Disse indstillinger skjuler ægteskaber (og relateret detaljer) for alle, der ikke lige netop er administratorer.<br /><br />Dette indstiller \$global_facts variable i den valgte privatlivsfil.";
$pgv_lang["person_facts_help"]			= "\"person_facts\" indstillinger definer fakta som skjules for en specifik person i gedcom samt på hvilket niveau disse fakta skjules.<br /><br />Det første element er personens ID, det næste element data.<br />Elementet [\"Valg\"] vælger data eller relaterede detaljer. Elementet [\"Vis til\"] bestemmer på hvilket adgangsniveau disse data vises.<br /><br /> \$person_facts array fungerer på samme måde som \$global_facts array med den forskel, at du også kan specificere GEDCOM ID påden person hvor data skal skjules. Du kan altså skjule æteskabs record for en bestemt person.<br /><br />Dette indstiller \$person_facts variable i den valgte privatlivsfil.";
$pgv_lang["find_sourceid"]			= "Find kilde ID";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "Brug relationsbetinget privatlivsfil<br /><br /> 'Nej' betyder at godkendte brugere kan se alle nulevende personers data.<br />'Ja' betyder, at brugere kun kan se private informationer om nulevende personer de er beslægtede med.<br /><br />Dette indstiller \$USE_RELATIONSHIP_PRIVACY variable i den valgte privatlivsfil.";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "Max. relation path length<br /><br />Second cousins.<br /><br />Dette indstiller \$MAX_RELATION_PATH_LENGTH variable i den valgte privatlivsfil.";
$pgv_lang["SHOW_RESEARCH_LOG_help"]		= "Vis research log<br /><br />Hvilken brugertype kan se research log, hvis det er installeret.<br /><br />Dette indstiller \$SHOW_RESEARCH_LOG variable i den valgte privatlivsfil.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Max. relationsstilængde";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Check ægteskabs relationer";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Vis afdøde personer";
$pgv_lang["name_of_fact"]			= "Benævnelse på fakta";
$pgv_lang["user_name"]				= "Brugernavn";
$pgv_lang["accessible_by"]			= "Vis til?";
$pgv_lang["show_question"]			= "Vis?";
$pgv_lang["hide"]				= "Skjul";
$pgv_lang["hide"]				= "Gem";
$pgv_lang["person_privacy_settings"]		= "[\$person_privacy] - indstilling";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Rediger eksisterende [\$person_privacy] - indstillinger";
$pgv_lang["person_facts_settings"]		= "[\$person_facts] - indstilliger";
$pgv_lang["edit_exist_person_facts_settings"]	= "Rediger eksisterende [\$person_facts] - indstillinger";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Rediger eksisterende [\$user_privacy] - indstillinger";
$pgv_lang["global_facts_settings"]		= "[\$global_facts] - indstillinger";
$pgv_lang["edit_exist_global_facts_settings"]	= "Rediger eksisterende [\$global_facts] - indstillinger";
$pgv_lang["user_privacy_settings"]		= "[\$user_privacy] - indstillinger";
$pgv_lang["general_settings"]			= "Generel privatlivs - indstilling";
$pgv_lang["file_read_error"]			= "F E J L !!! Privatlivsfilen kunne ikke læses!";
$pgv_lang["add_new_gf_setting"]			= "Tilføj ny [\$global_facts] - indstilling";
$pgv_lang["save_changed_settings"]		= "Gem ændringer";
$pgv_lang["PRIV_NONE"]				= "Vis kun til administratorer";
$pgv_lang["PRIV_HIDE"]				= "Skjul selv for administrative brugere";
$pgv_lang["PRIV_PUBLIC"]			= "Vis til enhver";
$pgv_lang["PRIV_USER"]				= "Vis kun til godkendte brugere";
$pgv_lang["edit_privacy"]			= "Konfiguration af privatlivsfilen [\"#PRIVACY_MODULE#\"]";
$pgv_lang["edit_privacy_title"]			= "Rediger Gedcom Privatlivsindstilling - [#PRIVACY_MODULE#]";

//-- language edit utility
$pgv_lang["edit_langdiff"]		= "Rediger indholdet i sprogfilen";
$pgv_lang["edit_lang_utility"]		= "Sprogfil redigeringsenhed";
$pgv_lang["edit_lang_utility_help"]	= "Du kan bruge dette værktøj til at redigere indholdet i en sprogfil ved hjælp af indholdet i den engelske sprogfil.<br />Du får vist indholdet fra den originale engelske sprogfil, og indholdet fra den sprogfil du har valgt.<br />Ved at klikke på en tekst fra den valgte sprogfil, får du åbnet et nyt vindue, i hvilket du kan redigere<br /> og gemme teksten i det valgte sprog.";
$pgv_lang["language_to_edit"]		= "Sprog der skal redigeres";
$pgv_lang["file_to_edit"]		= "Sprogfiltype der skal redigeres";
$pgv_lang["lang_save"]			= "Gem";
$pgv_lang["contents"]			= "Indhold";
$pgv_lang["listing"]			= "Liste";
$pgv_lang["no_content"]			= "Intet indhold";
$pgv_lang["editlang_help"]		= "Rediger tekst fra sprogfil";
$pgv_lang["cancel"]			= "Annuller";
$pgv_lang["savelang_help"]		= "Gem redigeret tekst";
$pgv_lang["original_message"]		= "Original tekst";
$pgv_lang["message_to_edit"]		= "Tekst der skal redigeres";
$pgv_lang["changed_message"]		= "Indhold ændret";
$pgv_lang["message_empty_warning"] 	= "-> Advarsel!!! Denne besked er tom indeni [#LANGUAGE_FILE#] <-";
$pgv_lang["export_lang_utility"]	= "Sprogfils eksportredskab";
$pgv_lang["language_to_export"]		= "Sprog der skal eksporteres";
$pgv_lang["export"]			= "Eksport";
$pgv_lang["compare_lang_utility"]	= "Sprogfil sammenligningsredskab";
$pgv_lang["export_lang_utility_help"]	= "I dette modul kan du vælge et sprog og klikke på eksportknappen for at eksportere hjælpetekster fra den valgte configuration_help sprogfil til brug for dokumentation";
$pgv_lang["export_ok"]			= "Hjælpetekster blev eksporteret";
$pgv_lang["compare_lang_utility_help"]	= "Dette modul kan sammenligne to sprogfiler og lave en liste over tilføjelser og subtraktioner mellem disse.<br /><br />Se [languages/LANG_CHANGELOG.txt] for andre sprog ændringer.|";
$pgv_lang["new_language"]		= "Nyt sprog";
$pgv_lang["old_language"]		= "Gammelt sprog";
$pgv_lang["compare"]			= "Sammenlign";
$pgv_lang["comparing"]			= "Sprogfiler, der er sammenlignet";
$pgv_lang["additions"]			= "Tilføjelser";
$pgv_lang["no_additions"]		= "Ingen tilføjelser";
$pgv_lang["subtractions"]		= "Subtraktioner";
$pgv_lang["no_subtractions"]		= "Ingen subtraktioner";
$pgv_lang["lang_back"]			= "Returner til hovedmenuen for redigering og konfiguration af sprogfiler";
$pgv_lang["lang_filename"]		= "Sprogfil";
$pgv_lang["facts_filename_help"]	= "Navn og sti på filen med oversættelser af GEDCOM-Tags.";
$pgv_lang["help_filename"]		= "Hjælp fil";
$pgv_lang["help_filename_help"]	= "Navn og sti til filen med oversættelser af hjælpetekst.";
$pgv_lang["facts_filename"]		= "Factsfil";
$pgv_lang["lang_filename_help"]		= "Navn og sti på standard sprogoversættelsesfilen.";
$pgv_lang["config_filename"]		= "Filnavn på konfigurationshjælp ";
$pgv_lang["config_filename_help"]	= "Navn og sti på den oversatte konfigurationshjælpefil.";
$pgv_lang["flagsfile"]			= "Flagfilnavn";
$pgv_lang["flagsfile_help"]		= "Navn og sti på den nationale flagbilledfil for det valgte sprog.";
$pgv_lang["text_direction"]		= "Tekstretning";
$pgv_lang["name_reverse_help"]		= "Der eksisterer ingen hjælp endnu :-(";
$pgv_lang["lang_save_success"]		= "Det lykkedes at gemme ændringerne i [#PGV_LANG#]";
$pgv_lang["translation_forum"]		= "Link til PhpGedViews oversættelsesforum på SourceForge";
$pgv_lang["translation_forum_help"]	= "Dette link åbner et nyt browservindue, der viderestiller dig til PhpGedViews oversættelsesforum (http://sourceforge.net/forum/forum.php?forum_id=294245), hvor du - på engelsk - kan diskutere oversættelsesspecifikke problemer :-)";
$pgv_lang["how_upgrade_help"]		= "Opgraderingsværktøjet<br />Opgraderingsværktøjet kan opgradere din nuværende phpGedView til en nyere version du har downloaded.<br /><br />Download en ny version?<br />En ny version kan enten direkte hentes fra http://sourceforge.net/projects/phpgedview/ eller du kan få opgraderingsværkt&oslash:jet til at undersøge, om der findes en nyere version. Hvis der findes en nyere version vil tilgængelige downloads blive vist. Der kan enten være tale om zip eller gz filer eller begge dele.<br /><br />Hvad skal opgraderes?<br />* PhpGedView<br />Denne mulighed vil opgradere alle filer i PhpGedViews kerne, dog ikke config.php, privacy.php og authenticate.php. Endvidere opgraderes images mappen.<br />* Indeksfiler<br />Denne mulighed opgraderer /index mappen. Brug denne mulighed varsomt, idet mange eksisterende filer bliver overskrevet.<br />* Sprog<br />Denne mulighed opgraderer /languages mappen.<br />* Temaer<br />Denne mulighed opgraderer /themes mappen. Brug denne mulighed varsomt, idet mange brugerændringer i temaerne bliver overskrevet.* Konfigurationsfil<br />Denne mulighed tjekker din nuværende konfigurationsfil med den nye konfigurationsfil og opdaterer din nuværende konfigurationsfil med alle nye tilføjelser, der er fundet i den nye konfigurationsfil. Dette sikrer, at du har den seneste konfigurationsfil, hvor dine egne instillinger er bevaret.<br />* Privatlivsfil(er)<br />Denne mulighed tjekker din nuværende privatlivsfile(r) med den nye privatlivsfil og opdaterer din nuværende fil(er) med alle nye tilføjelser fra den nye privatlivsfil. Dette sikrer, at du har den nyeste fil, hvor dine egne privatlivsindstillinger er bevaret.<br />* Manualer<br />Denne mulighed opgraderer /doc mappen.<br />* Forskningslog<br />Denne mulighed opgraderer Forskningslog modulet.<br />* Lav backup<br />Denne mulighed laver backup af de gamle filer, og gemmer denne backup i /backup mappen.<br />Hvordan bærer man sig af med at opgradere?<br />1. Vælg de dele du vil opgradere<br />2. Klik Gem<br /><br />Processens fremskridt vises i bunden af siden.";
$pgv_lang["rtl"]			= "højre til venstre";
$pgv_lang["file_does_not_exist"]	= "FEJL! Filen findes ikke ...";
$pgv_lang["alphabet_lower"]		= "Alfabetets små bogstaver";
$pgv_lang["alphabet_lower_help"]	= "Dette sprogs alfabets små bogstaver. Dette alfabet bruges til at sortere navne med små bostaver i det valgte sprogs korrekte alfabetiske rækkefølge. ";
$pgv_lang["lang_config_write_error"]	= "Fejl ved skrivning af sprogindstillinger til filen [language_settings.php]. Tjek skriverettigheder og prøv igen.";
$pgv_lang["alphabet_upper"]		= "Alfabetets store bogstaver";
$pgv_lang["alphabet_upper_help"]	= "Dette sprogs alfabets store bogstaver. Dette alfabet bruges til at sortere navne med store bostaver i det valgte sprogs korrekte alfabetiske rækkefølge. ";
$pgv_lang["ltr"]			= "venstre til højre";
$pgv_lang["week_start_help"]		= "Der eksisterer ingen hjælp endnu :-(";
$pgv_lang["name_reverse"]		= "Omvendt navnefølge";
$pgv_lang["date_format_help"]		= "Der eksisterer ingen hjælp endnu :-(";
$pgv_lang["week_start"]			= "Ugestart";
$pgv_lang["date_format"]		= "Datoformat";
$pgv_lang["text_direction_help"]	= "Der eksisterer ingen hjælp endnu :-(";
$pgv_lang["original_lang_name_help"]	= "Der eksisterer ingen hjælp endnu :-(";
$pgv_lang["lang_shortcut"]		= "Genvej for sprogfiler";
$pgv_lang["lang_shortcut_help"]		= "Der eksisterer ingen hjælp endnu :-(";
$pgv_lang["original_lang_name"]		= "Oprindelig betegnelse for sproget #D_LANGNAME# ";
$pgv_lang["lang_name_chinese"]		= "kinesisk";
$pgv_lang["lang_name_danish"]		= "dansk";
$pgv_lang["lang_name_dutch"]		= "hollandsk";
$pgv_lang["lang_name_english"]		= "engelsk";
$pgv_lang["lang_name_french"]		= "fransk";
$pgv_lang["lang_name_german"]		= "tysk";
$pgv_lang["lang_name_hebrew"]		= "hebræisk";
$pgv_lang["lang_name_italian"]		= "italiensk";
$pgv_lang["lang_name_norwegian"]	= "norsk";
$pgv_lang["lang_name_polish"]		= "polsk";
$pgv_lang["lang_name_portuguese-br"]	= "Brasiliansk Portugesisk";
$pgv_lang["lang_name_portuguese"]	= "Portugesisk";
$pgv_lang["lang_name_russian"]		= "russisk";
$pgv_lang["lang_name_spanish"]		= "spansk";
$pgv_lang["lang_name_spanish-ar"]	= "latinamerikansk spansk";
$pgv_lang["lang_name_swedish"]		= "svensk";
$pgv_lang["lang_name_turkish"]		= "tyrkisk";
$pgv_lang["lang_back_admin"]		= "Retur til administrationsmenuen";
$pgv_lang["lang_language"]		= "Sprog";
$pgv_lang["export_filename"]		= "Navn å filen, der indeholder de eksporterede data: ";
$pgv_lang["lang_edit"]			= "Rediger";
$pgv_lang["edit_settings"]		= "Redigeringsindstillinger";
$pgv_lang["active_help"]		= "Tillad brugere at vælge dette sprog, hvis det er tilladt at ændre sprog.";
$pgv_lang["active"]			= "Aktiv";
$pgv_lang["config_lang_utility"]	= "Konfiguration af understøttede sprog";
$pgv_lang["config_lang_utility_help"]	= "Dette modu hjælper dig med at slå de understøttede sprog i PhpGedView til eller fra. <br /><br /> ";

?>