<?php
/*=================================================
   charset=utf-8
   Projekt:	phpGedView
   Datei:	configure_help.ge.php
   Autor:	John Finlay
   Übersetzung:	Norgaz Kurt
   		Peter Pluntke
   Bemerkungen:	Deutsche Sprachdatei für die Konfiguration und Hilfedatei von PHPGedView
   Aufzeichnung der Änderungen:	30.05.2003 Datei erstellt
   				27.07.2003 Komplette Übersetzung der Datei
   				17.10.2003 Ergänzung der fehlenden Begriffe
===================================================*/
# $Id: configure_help.ge.php,v 1.35.2.3 2004/01/28 15:08:52 pluntke Exp $
if (preg_match("/configure_help\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}
//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"]			= "PHPGedView konfigurieren";
$pgv_lang["default_user"]		= "Erstellen Sie den Hauptadministrator.";
$pgv_lang["about_user"]			= "Sie müssen zunächst den Hauptadministrator erstellen. Dieser Benutzer wird das Recht erhalten, die Konfigurationsdateien zu verändern, private Daten zu sehen oder andere Benutzer zu erstellen.";
$pgv_lang["fullname"]			= "Kompletter Name:";
$pgv_lang["confirm"]			= "Passwort bestätigen:";
$pgv_lang["can_admin"]			= "Benutzer hat Administrationsrechte:";
$pgv_lang["can_edit"]			= "Benutzer darf editieren:";
$pgv_lang["add_user"]			= "Neuen Benutzer hinzufügen";
$pgv_lang["current_users"]		= "Aktuelle Benutzerliste";
$pgv_lang["leave_blank"]                = "Passwort leer lassen, um das aktuelle Passwort beizubehalten.";
$pgv_lang["other_theme"]                = "Anderes Darstellungsthema. Bitte Verzeichnis eingeben.";
$pgv_lang["performing_update"]		= "Update wird durchgeführt.";
$pgv_lang["config_file_read"]		= "Konfigurationsdatei wurde gelesen.";
$pgv_lang["does_not_exist"]		= "existiert nicht";
$pgv_lang["config_write_error"]		= "Fehler beim Schreiben der Konfigurationsdatei. Bitte Lese- und Schreib-Berechtigungen überprüfen und neu versuchen.";
$pgv_lang["db_setup_bad"]		= "Ihre aktuelle Datenbank-Konfiguration ist unzulässig. Bitte überprüfen Sie ihre Datenbankverbindungsparameter und konfigurieren Sie diese neu.";
$pgv_lang["click_here_to_continue"]	= "Hier klicken, um fortzufahren.";
$pgv_lang["config_help"]		= "Hilfe zur Konfiguration";
$pgv_lang["index"]			= "Index Dateien";
$pgv_lang["mysql"]			= "MySQL";
$pgv_lang["admin_gedcoms"]		= "Hier klicken, um Gedcoms zu verwalten.";
$pgv_lang["current_gedcoms"]		= "Vorhandene Gedcoms";
$pgv_lang["ged_download"]		= "Download";
$pgv_lang["ged_gedcom"]			= "Gedcom-Datei";
$pgv_lang["ged_title"]			= "Gedcom Bezeichnung";
$pgv_lang["ged_config"]			= "Konfigurations-Datei";
$pgv_lang["show_phpinfo"]		= "PHPInfo-Seite anzeigen";
$pgv_lang["confirm_gedcom_delete"]	= "Wollen Sie diese Gedcom Datei wirklich löschen";
$pgv_lang["gregorian"]			= "Gregorianisch";
$pgv_lang["julian"]			= "Julianisch";
$pgv_lang["config_french"]		= "Französisch";
$pgv_lang["jewish"]			= "Jüdisch";
$pgv_lang["config_hebrew"]		= "Hebräisch";
$pgv_lang["jewish_and_gregorian"]	= "Jüdisch and Gregorianisch";
$pgv_lang["hebrew_and_gregorian"]	= "Hebräisch and Gregorianisch";
$pgv_lang["disabled"]			= "Deaktiviert";
$pgv_lang["mouseover"]			= "Bei \"Mouse Over\"";
$pgv_lang["mousedown"]			= "Bei \"Mouse Down\"";
$pgv_lang["click"]			= "Bei \"Mouse Click\"";
$pgv_lang["mailto"]			= "E-Mail Verknüpfung";
$pgv_lang["messaging"]			= "Interne Nachrichten-Funktion von PhpGedView";
$pgv_lang["messaging2"]			= "Interne Nachrichten-Funktion und E-Mail Verknüpfung";
$pgv_lang["no_messaging"]		= "keine Nachrichten-Funktion";
$pgv_lang["no_logs"]			= "Logging deaktivieren";
$pgv_lang["daily"]			= "Täglich";
$pgv_lang["weekly"]			= "Wöchentlich";
$pgv_lang["monthly"]			= "Monatlich";
$pgv_lang["yearly"]			= "Jährlich";

$pgv_lang["PGV_DATABASE"]		= "PhpGedView Daten-Speicher:";
$pgv_lang["PGV_DATABASE_help"]		= "Die Art der Datenspeicherung, die Sie für Ihre Gedcom Dateien wünschen. Wählen Sie \"Index Dateien\", um Index-Dateien im Index-Verzeichnis zu erstellen oder wählen Sie \"MySQL\", um eine MySQL-Datenbank zu verwenden.<br />Diese Einstellung verändert die Variable \$PGV_DATABASE in der Datei \"config.php\".";
$pgv_lang["DBHOST"]			= "Host für die MySQL Datenbank:";
$pgv_lang["DBHOST_help"]		= "Die DNS- oder IP-Adresse Ihres MySQL-Datenbank-Servers.<br />Diese Einstellung verändert die Variable \$DBHOST in der Datei \"config.php\".";
$pgv_lang["DBUSER"]			= "Benutzername der MySQL Datenbank:";
$pgv_lang["DBUSER_help"]                = "Der Benutzername der benötigt wird, um eine Verbindung zu Ihrer MySQL-Datenbank herzustellen.<br />Diese Einstellung verändert die Variable \$DBUSER in der Datei \"config.php\".";
$pgv_lang["DBPASS"]			= "Passwort der MySQL Datenbank:";
$pgv_lang["DBPASS_help"]                = "Das Passwort das für den oben von Ihnen angegebenen Benutzernamen benötigt wird, um eine Verbindung zu Ihrer MySQL-Datenbank herzustellen.<br />Diese Einstellung verändert die Variable \$DBPASS in der Datei \"config.php\".";
$pgv_lang["DBNAME"]			= "Name der Datenbank:";
$pgv_lang["DBNAME_help"]                = "Die Datenbank auf Ihrem MySQL-Server, die Sie mit PHPGedView nutzen möchten.<br /><br />Der Benutzername aus dem Benutzerfeld muss über Generierungs-, Einfügungs-, Update-, Lösch- und Auswahlrechte innerhalb dieser Datenbank verfügen.<br /><br />Diese Einstellung verändert die Variable \$DBNAME in der Datei \"config.php\".";
$pgv_lang["TBLPREFIX"]			= "Prefix der Datenbank Tabelle:";
$pgv_lang["TBLPREFIX_help"]		= "Ein Prefix der an die MySQL-Tabellen angehängt wird, die von PHPGedView erstellt werden. Durch Ändern dieses Wertes können Sie mehrere PHPGedView-Sites bestimmen, die die gleiche Datenbank jedoch unterschiedliche Tabellen benutzen.<br />Diese Einstellung verändert die Variable \$TBLPREFIX in der Datei \"config.php\".";
$pgv_lang["DEFAULT_GEDCOM"]		= "Standard GEDCOM:";
$pgv_lang["DEFAULT_GEDCOM_help"]        = "Die MySQL-Version von PHPGedView erlaubt es Ihnen, mit mehreren GEDCOM-Datenbanken in ein und der selben PHPGedView-Installation zu arbeiten.<br />Benutzen Sie dieses Feld, um eine Standard-GEDCOM-Datenbank zu bestimmen, die für alle Besucher genutzt wird, die das erste Mal auf Ihre Website gelangen. <br />Ein leeres Feld bewirkt, dass die erste importierte GEDCOM-Datenbank hierfür genutzt wird.<br />Falls Sie den Besuchern erlauben, die GEDCOM-Datenbanken zu wechseln, wird auf jeder generierten Seite eine Verknüpfung angezeigt, die es erlaubt, die aktuell benutzte GEDCOM-Datenbank zu wechseln.<br />Diese Einstellung verändert die Variable \$DEFAULT_GEDCOM in der Datei \"config.php\".";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]        = "Besuchern erlauben die GEDCOM-Datei zu wechseln:";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "Die Einstellung \"JA\" erlaubt den Benutzern die verwendete GEDCOM-Datei selbst auszuwählen, sofern Ihre Konfiguration mehrere GEDCOM-Dateien enthält. Diese Einstellung verändert die Variable \$ALLOW_CHANGE_GEDCOM in der Datei \"config.php\".";
$pgv_lang["GEDCOM"]			= "Pfad und Name der GEDCOM-Datei:";
$pgv_lang["gedcom_path_help"]		= "Bitte speichern Sie Ihre GEDCOM-Datei zunächst an einer Stelle auf Ihrem Servers, auf die man mit PHP zugreifen kann. Dann geben Sie hier den Pfad zu dieser Datei ein. Diese Einstellung verändert die Variable \$GEDCOM in der Datei \"config.php\".<br /><br />Für weitere Hilfe schauen Sie in  die Datei <a href=\"readme.txt\">\"Readme.txt\"</a>";
$pgv_lang["CHARACTER_SET"]		= "Kodierung der Schriftzeichen:";
$pgv_lang["CHARACTER_SET_help"]		= "Dies ist die Bezeichnung für die Kodierung, mit der Sie Ihre GEDCOM-Datei gespeichert haben. UTF-8 ist die Standardeinstellung  und sollte auf fast allen Websites funktionieren. Falls Sie ihre GEDCOM-Datei mit IBM-Windows Kodierung exportiert haben, sollten Sie hier WINDOWS angeben.<br />Diese Einstellung verändert die Variable \$CHARACTER_SET in der Datei \"config.php\".<br /><br />Bitte beachten Sie: PHP unterstützt ->KEIN<- UNICODE (UTF-16)! Also versuchen Sie dies nicht und beschweren Sie sich bei den PHP-Machern :-)";
$pgv_lang["LANGUAGE"]			= "Sprache:";
$pgv_lang["LANGUAGE_help"]		= "Bestimmen Sie die Standardsprache für Ausgaben auf dieser Site. Die Benutzer haben die Möglichkeit, diese Einstellung durch Konfiguration ihres Browsers oder durch Auswahl der Anzeigesprache im unteren Bereich der Seiten zu verändern, falls die Variable \$ENABLE_MULTI_LANGUAGE in der Datei \"config.php\" auf \"true\" steht.<br />Diese Einstellung verändert die Variable \$LANGUAGE in der Datei \"config.php\".";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Besuchern den Wechsel der Anzeige-Sprache erlauben:";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "\"Ja\" wählen, um den Besuchern zu ermöglichen, eine andere Anzeigesprache aus einer Dropdown-Liste auszuwählen. Als Voreinstellung wird bei \"JA\" die Standardsprache ihres Browsers gewählt.<br />Diese Einstellung definiert den Wert der Variable \$ENABLE_MULTI_LANGUAGE in der Datei \"config.php\".";
$pgv_lang["CALENDAR_FORMAT"]		= "Kalender Format:";
$pgv_lang["CALENDAR_FORMAT_help"]	= "Geben Sie das gewünschte Kalender-Format für diese Gedcom-Datei an. Hebreisch entspricht dem Jüdischen Kalender aber mit Hebreischen Schriftzeichen. Bitte beachten: Die Werte für Jüdische und Hebräische Daten werden aus den Gegorianischen/Julianischen Daten berechnet. Da der Jüdische Kalendertag mit dem Abend beginnt, wird jedes Ereignis zwischen Abend und Mitternacht mit dem Datum einen Tag vor dem korrekten Jüdischen Datum angezeigt. Hebräische Darstellung kann bei einigen älteren Browsern zu Schwierigkeiten führen (Darstellung rückwärts oder gar keine Darstellung).<br /><br />Diese Einstellung verändert die Variable \$CALENDAR_FORMAT in der Datei config.php.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]		= "Hebräische Tausender anzeigen:";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "Alafim in Hebräischen Kalendern anzeigen. Bei \"Ja\" wird das Jahr 1969 als <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; angezeigt, während es bei \"Nein\" als <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; angezeigt wird. Dies hat keinen Einfluss auf die Jüdische Jahreseinstellung. Das Jahr wird als 5729 angezeigt unabhängig von dieser Einstellung<br />Bitte beachten: Diese Einstellung entspricht der php 5.0 Kalender-Einstellung CAL_JEWISH_ADD_ALAFIM.<br />Diese Einstellung verändert die Variable \$DISPLAY_JEWISH_THOUSANDS in der Datei config.php.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Hebräische Gershayim anzeigen:";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "Einfache und doppelte Hochkommata in Hebräischen Daten anzeigen. Bei \"Ja\" wird der 8. Februar 1969 als <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; angezeigt, bei \"Nein\" als <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Dies hat keinen Einfluss auf die Jüdische Jahreseinstellung, da Hochkommata bei der dortigen lateinischen Darstellung nicht genutzt werden.<br />Bitte beachten: Diese Einstellung entspricht den php 5.0 Kalender-Einstellungen CAL_JEWISH_ADD_ALAFIM_GERESH und CAL_JEWISH_ADD_GERESHAYIM und beeinflusst BEIDE Werte.<br />Diese Einstellung verändert die Variable \$DISPLAY_JEWISH_GERESHAYIM in der Datei config.php.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Jüdische Ashkenaz Schreibweise:";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]	= "Jüdische Ashkenazi Schreibweise benutzen.<br />Bei \"Ja\" werden die Monate Cheshvan und Teves in der Ashkenazi Schreibweise verwendet. Bei \"Nein\" werden die Monate als Hesvan und Tevet angezeigt. <br />Dies beeinflusst nur die Jüdische Einstellung. Im Hebräischen wird das Hebräische Alphabet benutzt.<br />Diese Einstellung verändert die Variable \$JEWISH_ASHKENAZ_PRONUNCIATION in der Datei config.php.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Anzahl standardmäßig dargestellter Generationen in der Stammbaum-Darstellung:";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "Bestimmt die Anzahl standardmäßig dargestellter Generationen, die in der Stammbaumdarstellung gleichzeitig angezeigt werden.<br />Diese Einstellung definiert den Wert der Variable \$DEFAULT_PEDIGREE_GENERATIONS in der Datei \"config.php\".";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Maximale Anzahl Generationen im Stammbaum:";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "Verändert die Anzahl der Generationen, die maximal in der Stammbaum Ansicht angezeigt werden.<br /><br />Diese Einstellung verändert die Variable \$MAX_PEDIGREE_GENERATIONS in der Datei config.php.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Maximale Anzahl Generationen im Nachfahrenbaum:";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "Verändert die Anzahl der Generationen, die maximal im Nachfahrenbaum angezeigt werden.<br /><br />Diese Einstellung verändert die Variable \$MAX_DESCENDANCY_GENERATIONS in der Datei config.php.";
$pgv_lang["USE_RIN"]			= "RIN# anstelle von GEDCOM ID verwenden:";
$pgv_lang["USE_RIN_help"]		= "Bei \"Ja\" wird die RIN Nummer anstelle der GEDCOM ID verwendet, wenn in Konfigurationen, Benutzer-Einstellungen und Diagrammen nach Personen gefragt wird. Dies ist hilfreich für Genealogie Software die GEDCOM-Dateien nicht mit einheitlichen IDs  aber immer mit den gleiche RIN für Personen exportiert.<br /><br />Diese Einstellung verändert die Variable \$USE_RIN in der Datei config.php.";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "GEDCOM-Personennummer der standardmäßig ausgewählten Person für Stammbaum und Nachfahrenbaum:";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "Bestimmt die ID der Person, die standardmäßig als Startperson in der Stammbaum- und Nachfahrenbaum-Darstellung verwendet wird.<br />Dieses Feld verändert die Variable \$PEDIGREE_ROOT_ID in der Datei \"config.php\".";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "GEDCOM ID Prefix:";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "In Stammbäumen, Nachfahrenbäumen, Verwandtschafts- und anderen Darstellungen wird dieses Prefix der ID vorangestellt, die der Besucher zur Personen-Auswahl eingeben kann, sofern er das Prefix nicht selbst voranstellt.<br /><br />Diese Einstellung verändert die Variable \$GEDCOM_ID_PREFIX in der Datei config.php.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Geburts- und Todesdetails im Stammbaum und Nachfahrenbaum anzeigen:";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]	= "Dieses Feld bestimmt, ob die Einzelheiten der Geburts- und Sterbedaten von Personen standardmäßig dargestellt werden oder nicht.<br />Dieses Feld verändert die Variable \$PEDIGREE_FULL_DETAILS in der Datei \"config.php\".";
$pgv_lang["PEDIGREE_LAYOUT"]		= "Standard Stammbaum Layout";
$pgv_lang["PEDIGREE_LAYOUT_help"]	= "Hier stellen Sie ein, ob der Stammbaum im Hochformat oder Querformat generiert werden soll.<br /><br />Diese Einstellung verändert die Variable \$PEDIGREE_LAYOUT in der Datei config.php.";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Leere Boxen im Stammbaum anzeigen:";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "Gibt an, ob leere Boxen im Stammbaum angezeigt werden sollen.<br /><br />Diese Einstellung verändert die Variable \$SHOW_EMPTY_BOXES in der Datei config.php.";
$pgv_lang["ZOOM_BOXES"]			= "Boxen in Diagrammen zoombar:";
$pgv_lang["ZOOM_BOXES_help"]		= "Erlaubt dem Besucher in Boxen eines Diagramms für mehr Informationen hineinzuzoomen. Auf \"Deaktiviert\" stellen, um dieses Feature abzuschalten. Auf \"MouseOver\" stellen, um den Zoom beim Überfahren des Icons mit der Maus auszulösen. Auf \"Click\" stellen, um den Zoom durch Klick auf das Icon auszulösen.<br /><br />Diese Einstellung verändert die Variable \$ZOOM_BOXES in der Datei config.php.";
$pgv_lang["LINK_ICONS"]			= "PopUp Links in Diagrammen:";
$pgv_lang["LINK_ICONS_help"]		= "Erlaubt die Auswahl von Links zu anderen Diagrammen und zu nahen Verwandten einer Person. Auf \"Deaktiviert\" stellen, um dieses Feature abzuschalten.Auf \"MouseOver\" stellen, um ein Popup-Fenster mit den Links anzuzeigen, wenn der Benutzer mit der Maus über das Symbol in der Personen-Box fährt. Auf  \"Click\" stellen, um das Popup-Fenster durch Klick auf das Symbol aufzurufen.<br /><br />Diese Einstellung verändert die Variable \$LINK_ICONS in der Datei config.php.";
$pgv_lang["AUTHENTICATION_MODULE"]	= "Dateiname der Authentifizierungs-Modul-Datei:";
$pgv_lang["AUTHENTICATION_MODULE_help"]	= "In diesem Feld bestimmen Sie den Namen der Datei, aus der die Funktionen zur Authentifizierung gelesen werden, die Ihren Besuchern Zugriff auf bestimmte geschützte Personendaten innerhalb PHPGedView bieten. Durch hinzufügen von Funktionen in diese Datei können Sie andere Authentifizierungsmethoden und andere Datenbanken zur Speicherung von Besucher-Zugansdaten bestimmen, als diejenigen aus der Originaldatei, die mit PHPGedView standardmäßig ausgeliefert wird.<br /><br />In der Hoffnung, dass eines Tages Betreiber von PHPGedView-Sites, ihre selbsterstellten Authentifizierungsmodule, den anderen Betreibern von PHPGedView-Sites zur Einbindung in deren Websites zur Verfügung stellen werden.<br /><br />Dieses Feld definiert den Inhalt der Variable \$AUTHENTICATION_MODULE in der Datei \"config.php\".";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Lebende Personen verbergen:";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "Diese Option dient dazu, Daten von lebenden Personen vor den Augen \"gewöhnlicher\" Besucher zu verbergen. Lebende Personen sind für PHPGedView diejenigen, die Einträge in Ihrem Datensatz haben, die jünger sind, als das in der Variable \$MAX_ALIVE_AGE definierte Alter und keine Kinder haben, die vor mehr als in der Variable \$MAX_ALIVE_AGE angegebenen Jahren geboren wurden.<br />Dieses Feld definiert den Inhalt der Variable \$HIDE_LIVE_PEOPLE in der Datei \"config.php\".";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Besucher Login notwendig:";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]= "Wenn diese Einstellung aktiv ist, muss sich ein Besucher erst anmelden, bevor ihm irgendwelche Daten dieser Seite gezeigt werden.<br /><br />Diese Einstellung verändert die Variable \$REQUIRE_AUTHENTICATION in der Datei config.php.";
$pgv_lang["CHECK_CHILD_DATES"]		= "Daten der Kinder überprüfen:";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "Überprüft die Daten der Kinder einer Person, um zu bestimmen, ob eine Person schon verstorben ist oder nicht. Falls sich Ihre Website auf einem älteren Server befindet und Sie eine große GEDCOM-Datenbanken nutzen, kann die Einstellung \"Ja\" bewirken, dass die Antwortzeit Ihres Servers verzögert wird.<br />Dieses Feld definiert den Inhalt der Variable \$CHECK_CHILD_DATES in der Datei \"config.php\".";
$pgv_lang["MAX_ALIVE_AGE"]		= "Alter, ab dem angenommen wird, dass eine Person verstorben ist:";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "Das maximale Alter einer Person, das maximale Alter eines persönlichen Eintrages einer Person oder das maxiamale Alter der Kinder dieser Person, damit angenommen wird, dass diese Person mittlerweile verstorben ist und ihr Datensatz nicht mehr dem Datenschutz unterliegt.<br />Dieses Feld definiert den Inhalt der Variable \$MAX_ALIVE_AGE in der Datei \"config.php\".";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Besuchern erlauben die GEDCOM-Roh-Daten anzusehen:";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "Bei \"Ja\" wird eine Verknüpfung auf den Seiten von Personen, Quellen und Familien eingefügt, die ein neues Fenster mit den jeweiligen Roh-Daten aus der Gedcom-Datei öffnet.<br />Dieses Feld definiert den Inhalt der Variable \$SHOW_GEDCOM_RECORD in der Datei \"config.php\".";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Online Editieren erlauben:";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "Ermöglich das Online Editieren für diese Gedcom-Datei, mittels dessen Besucher mit Edit-Rechten die Gedcom-Datei online verändern können.<br /><br />Diese Einstellung verändert die Variable  \$ALLOW_EDIT_GEDCOM in der Datei config.php.";
$pgv_lang["INDEX_DIRECTORY"]		= "Verzeichnis der Index-Dateien:";
$pgv_lang["INDEX_DIRECTORY_help"]	= "Der Pfad zu einem Verzeichnis mit Lese- und Schreibrechten, in dem PHPGedView die Index-Dateien speichern soll (einschließlich des führenden \"/\").<br />Dieses Feld definiert den Inhalt der Variable \$INDEX_DIRECTORY in der Datei \"config.php\".";
$pgv_lang["ALPHA_INDEX_LISTS"]		= "Lange Namens-Listen in Anfangsbuchstaben-Listen aufteilen:";
$pgv_lang["ALPHA_INDEX_LISTS_help"]	= "Für lange Listen von Personen und Familien bewirkt das Setzen dieses Feldes auf  \"Ja\", dass die Listen-Darstellung der Individuen und Familien in einzelne Seiten nach den Anfangsbuchstaben ihrer Nachnamen aufgepalten werden.<br />Dieses Feld definiert den Inhalt der Variable \$ALPHA_INDEX_LISTS in der Datei \"config.php\".";
$pgv_lang["NAME_FROM_GEDCOM"]		= "Angezeigten Namen aus GEDCOM verwenden:";
$pgv_lang["NAME_FROM_GEDCOM_help"]	= "Normalerweise verwendet phpGedView für Personen den Namen, der in der Index-Datei gespeichert wurde. Bei manchen Gedcom-Formaten oder -Sprachen wird dieser Name aus der Index-Datei nicht korrekt angezeigt und der beste Weg für eine korrekte Darstellung wäre direkt aus der Gedcom-Datei. Z.B. bestehen Spanische Nachnamen oft aus Vornamen - Nachname des Vaters - Nachname der Mutter. Bei Verwendung der Indexdateien würden die Nachnamen des Vaters und der Mutter vertauscht. Nur durch Auslesen des Namens aus der Gedcom-Datei  würde dieser korrekt dargestellt. Allerdings wird das Programm und die Anzeige dadurch etwas langsamer.<br /><br />Diese Einstellung verändert die Variable \$NAME_FROM_GEDCOM in der Datei config.php.";
$pgv_lang["SHOW_ID_NUMBERS"]		= "ID Nummern bei Namen anzeigen:";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "Anzeige der ID Nummern in Klammern hinter den Personen-Namen in den Diagrammen.<br /><br />Diese Einstellung verändert die Variable \$SHOW_ID_NUMBERS in der Datei config.php.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "Anzahl der angezeigten Ebenen der hierarchischen Orts-Angaben:";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "Hier stellen Sie ein, wie viele Informationen zu den Orts-Angaben in den Personen-Boxen im Diagramm angezeigt werden. Die Einstellung \"9\" sorgt für vollständige Orts-Angaben. Die Einstellung \"0\" unterdrückt die Orts-Angabe komplett. Die Einstellung \"1\" zeigt nur eine Ebene, die Einstellung \"2\" zeigt die ersten beiden Ebenen usw. (bezieht sich auf die Unterteilung durch Kommata, z.B. Bonn, Rheinland-Pfalz, Deutschland)<br /><br />Diese Einstellung verändert die Variable \$SHOW_PEDIGREE_PLACES in der Datei config.php.";
$pgv_lang["MULTI_MEDIA"]		= "Multimediaunterstützung aktivieren:";
$pgv_lang["MULTI_MEDIA_help"]		= "Die Spezifikation von GEDCOM 5.5 erlaubt Ihnen Fotos, Videos und andere Multimedia-Objekte in Ihre GEDCOM-Datenbank hinzuzufügen. Falls Sie keine Multimedia-Objekte in ihre GEDCOM-Datenbank hinzugefügt haben, können Sie die Multimedia-Unterstützung von PHPGedView durch Setzen dieses Feldes auf N(ein) abschalten.<br />Lesen Sie im Abschnitt \"multimedia\" der Datei <a href=\"readme.txt\">readme.txt</a>, um mehr darüber zu erfahren, wie Sie Multimedia-Dateien in Ihre Website einfügen können.<br />Dieses Feld definiert den Inhalt der Variable \$MULTI_MEDIA in der Datei \"config.php\".";
$pgv_lang["MEDIA_DIRECTORY"]		= "Verzeichnis der Multimedia-Dateien";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "Der Pfad zu einem Verzeichnis mit Leserechten auf einem Server, in dem PHPGedView nach den Multimedia-Dateien suchen soll, die in den jeweiligen Datensätzen der enthaltenen Personen einer GEDCOM-Datenbank definiert wurden (einschließlich des führenden \"/\").<br />Dieses Feld definiert den Inhalt der Variable \$MEDIA_DIRECTORY in der Datei \"config.php\".";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "Multimedia Verzeichnis-Tiefe";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]= "Ein Wert von 0 wird alle Unterverzeichniss im Verzeichnis für Multimedia-Objekte ignorieren. Ein Wert von 1 wird zusätzlich das erste Unterverzeichnis dieses Multimedia-Verzeichnisses beachten. Die Erhöhung dieser Zahl, wird die Anzahl der übergeordneten zu überwachenden Verzeichnisse dieses Pfades erhöhen.<br />Ein Beispiel: Wenn Sie innerhalb Ihrer Gedcom-Datei auf ein Foto mit folgenden Pfad verlinken: C:\\Dokumente und Einstellungen\\BENUTZER\\Eigene Dateien\\Eigene Bilder\\Genealogie\\Nachname\\grossvater.jpg dann wird ein Wert von 0 diesen Pfad folgendermaßen interpretieren: ./media/grossvater.jpg. Ein Wert von 1 jedoch, wird diesen Pfad folgendermaßen interpretieren: ./media/Nachname/grossvater.jpg, usw. Den meisten Verwaltern von phpGedView wird hier ein eingestellter Wert von 0 ausreichen. Es kann jedoch sein, dass einige Multimedia-Objekte den gleichen Namen haben können und sich somit gegenseitig aufheben. Dieses Wert ermöglicht Ihnen, Ihre Multimedia-Objekte zu verwalten, ohne einen Namenskonflikt zu erzeugen.<br />Dieses Feld definiert den Inhalt der Variable \$MEDIA_DIRECTORY_LEVELS in der Datei \"config.php\".";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "Definierte Fotos in den Personenboxen anzeigen:";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]	= "Falls Sie die Darstellung für Multimedia-Dateien auf Ihrer Website aktiviert haben, können Sie PHPGedView veranlassen, neben dem Namen der in den Boxen eines Stammbaumes oder Nachfahrenbaumes dargestellten Personen eine verkleinerte Darstellung eines Bildes (english Thumbnail) anzuzeigen.<br />Aktuell benutzt PHPGedView hierfür (highlighted image) das erste Multimedia-Objekt (Foto), das im GEDCOM-Datensatz der dargestellten Person vorkommt. Denjenigen, die mehrere Fotos als Multimedia-Objekte dem Datensatz einer Person hinzugefügt haben, sei empfohlen, die Liste der Multimedia-Objekte in einem Datensatz so anzuordnen, dass das darzustellende Foto an erster Stelle der Multimedia-Objekte der Person erscheint.<br />Für Benutzer von PAF 5.5 sei angemerkt, dass PHPGedView in der aktuellen Version die Definition des darzustellenden Fotos einer Person, die von PAF durch die Anweisung \"_PRIM\" definiert wird, unterstützt. Somit haben Sie innerhalb des Fensters \"Multimedia-Sammlung\" von PAF die Möglichkeit mehrere Fotos zu einer Person hinzuzuspeichern und durch die Anweisung \"festlegen\" das Foto zu bestimmen, das in der Stammbaum- oder Nachfahrenbaum-Darstellung und auch im jeweiligen persönlichen Datenblatt der jeweiligen Person angezeigt wird, zu bestimmen.<br />Lesen Sie im Abschnitt \"multimedia\" der Datei <a href=\"readme.txt\">readme.txt</a>, um mehr darüber zu erfahren, wie Sie Multimedia-Dateien in Ihre Website einfügen können.<br />Diese Einstellung definiert den Wert der Variable \$SHOW_HIGHLIGHT_IMAGES in der Datei \"config.php\".";
$pgv_lang["ENABLE_CLIPPINGS_CART"]	= "Ausschnittssammelbehäter aktivieren:";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]	= "Der Ausschnittssammelbehälter ermöglicht Besuchern Ihrer Website Datensätze zu ausgewählten Personen aus ihrer gesamten GEDCOM-Datenbank in eine neue GEDCOM-Datenbank zu exportieren, die diese dann als Datei auf ihren Computer übertragen (downloaden) können, um diese Datensätze in ihr eigenes Genealogie-Programm zu importieren.<br />Diese Einstellung definiert den Wert der Variable \$ENABLE_CLIPPINGS_CART in der Datei \"config.php\".";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "GEDCOM-Fehler verbergen:";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "Bei \"Ja\" werden alle Fehlermeldungen, die von PHPGedView verursacht werden, nicht dargestellt. Solche Fehler können dann entstehen, wenn PHPGedView eine Anweisung innerhalb der von Ihnen gewählten GEDCOM-Datenbank nicht interpretieren kann. PHPGedView wurde so programmiert, dass möglichst alle Anweisungen des GEDCOM 5.5 Standards unterstützt werden. Jedoch verwenden einige Genealogie-Programme ihre eigenen Anweisungen (TAGS). Schauen Sie in die Datei <a href=\"readme.txt\">readme.txt</a> um mehr hierüber zu erfahren.<br />Diese Einstellung definiert den Wert der Variable \$HIDE_GEDCOM_ERRORS in der Datei \"config.php\".";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Leerzeichen an umgebrochene Notizinformationen anfügen:";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "Manche Genealogie-Programme kappen die Notizen zu Datensätzen am Ende von ganzen Wörtern, während andere an einer beliebigen Stelle des Textes einen Zeilenumbruch einfügen. Dies kann PHPGedView veranlassen, Wörter aneinander anzuhängen, ohne ein Leerzeichen zwischen diese zu setzen. Bei \"Ja\" wird PHPGedView bei der Ausgabe von Notizen ein Leerzeichen zwischen zwei Wörter einfügen, die durch einen Zeilenumbruch getrennt wurden.<br />Diese Einstellung definiert den Wert der Variable \$WORD_WRAPPED_NOTES in der Datei \"config.php\".";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "\"?\"-Hilfe-Links auf den Seiten anzeigen:";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "Diese Option aktiviert Fragezeichen als Hilfe-Links auf den Seiten, auf die die Besucher klicken können, um einen Hilfe-Text für die jeweilige Funktion angezeigt zu bekommen.<br /><br />Diese Einstellung verändert die Variable \$SHOW_CONTEXT_HELP in der Datei config.php file.";
$pgv_lang["HOME_SITE_URL"]		= "URL der Hauptseite der WebSite:";
$pgv_lang["HOME_SITE_URL_help"]		= "Eine URL die in den Header des gewählten Darstellungsthemas hinzugefügt wird, um eine Verknüpfung zur Starseite Ihrer Homepage zu erstellen.<br />Diese Einstellung definiert den Wert der Variable \$HOME_SITE_URL in der Datei \"config.php\".";
$pgv_lang["HOME_SITE_TEXT"]		= "Text für Hauptseite der WebSite:";
$pgv_lang["HOME_SITE_TEXT_help"]	= "Textausgabe für die Verknüpfung, die zur Startseite Ihrer Homepage verweist.<br />Diese Einstellung definiert den Wert der Variable \$HOME_SITE_TEXT in der Datei \"config.php\".";
$pgv_lang["CONTACT_EMAIL"]		= "Ihre Kontakt-Emailadresse für genealogische Fragen:";
$pgv_lang["CONTACT_EMAIL_help"]		= "Die E-Mail-Adresse die Ihre Besucher kontaktieren sollen, falls sie Fragen zu den genealogischen Daten auf Ihrer Website haben.<br />Diese Einstellung definiert den Wert der Variable \$CONTACT_EMAIL in der Datei \"config.php\".";
$pgv_lang["CONTACT_METHOD"]		= "Kontakt Methode (genealogische Fragen):";
$pgv_lang["CONTACT_METHOD_help"]	= "Die Methode, mit der die Kontakt-Verknüpfungen für genealogische Fragen arbeiten. Mit \"E-Mail\" wird eine Verknüfung eingefügt, mit der eine gewöhnliche E-Mail versendet werden kann. Mit \"interne Nachrichten-Funktion\" wird der in PhpGedView integrierte Nachrichten-Transfer benutzt und es wird keine gewöhnliche E-Mail Versendet. Bei \"interne Nachrichten und E-Mail\" werden beide vorgenannten Methoden parallel genutzt. Mit \"keine Nachrichten-Funktion\" wird die Möglichkeit, dass Besucher Ihnen Nachrichten von diesen Seiten aus senden, unterbunden.<br /><br />Diese Einstellung verändert die Variable \$CONTACT_METHOD in der Datei config.php.";
$pgv_lang["WEBMASTER_EMAIL"]		= "Email-Adresse des Webmasters:";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "Die E-Mail- Adresse die Ihre Besucher kontaktieren sollen, falls sie technische Fragen haben oder Fehler auf Ihrer Website finden und diese Ihnen mitteilen möchten.<br />Diese Einstellung verändert die Variable \$WEBMASTER_EMAIL in der Datei \"config.php\".";
$pgv_lang["SUPPORT_METHOD"]		= "Support Kontakt Methode:";
$pgv_lang["SUPPORT_METHOD_help"]	= "Die Methode, mit der die Kontakt-Verknüpfungen für Support-Fragen arbeiten. Mit \"E-Mail\" wird eine Verknüfung eingefügt, mit der eine gewöhnliche E-Mail versendet werden kann. Mit \"interne Nachrichten-Funktion\" wird der in PhpGedView integrierte Nachrichten-Transfer benutzt und es wird keine gewöhnliche E-Mail Versendet. Bei \"interne Nachrichten und E-Mail\" werden beide vorgenannten Methoden parallel genutzt. Mit \"keine Nachrichten-Funktion\" wird die Möglichkeit, dass Besucher Ihnen Nachrichten von diesen Seiten aus senden, unterbunden.<br /><br />Diese Einstellung verändert die Variable \$SUPPORT_METHOD in der Datei config.php.";
$pgv_lang["FAVICON"]			= "Pfad und Dateiname der FavIcon-Grafik:";
$pgv_lang["FAVICON_help"]		= "Ändern Sie diesen Wert, um auf die ICON-Grafik zu verweisen, die in der Liste der Favoriten/Lesezeichen derjenigen erscheinen, die ihre Website zur Liste ihrer Favoriten/Lesezeichen hinzufügen.<br />Diese Einstellung definiert den Wert der Variable \$FAVICON in der Datei \"config.php\".";
$pgv_lang["THEME_DIR"]			= "Themen Verzeichnis:";
$pgv_lang["THEME_DIR_help"]		= "Das Verzeichnis in dem Ihr gewünschtes Darstellungsthema für PHPGedView-Seiten abgelegt ist. Sie können ein beliebiges Standardthema, das mit PHPGedView geliefert wurde, so anpassen, dass Ihre Website ein einzigartiges Erscheinungsbild abgibt. Lesen Sie im Abschnitt \"customization\" der Datei <a href=\"readme.txt\">readme.txt</a>, um mehr darüber zu erfahren.<br />Diese Einstellung definiert den Wert der Variable \$THEME_DIR in der Datei \"config.php\".";
$pgv_lang["TIME_LIMIT"]			= "PHP Zeitlimit:";
$pgv_lang["TIME_LIMIT_help"]		= "Die maximale Dauer in Sekunden die Sie PHPGedView zur Beendigung eines Prozesses zur Vefügung stellen möchten. Die Standardeinstellung beträgt 60 Sekunden. Abhängig von der Größe Ihrer GEDCOM-Datenbank müssen Sie diese Zeit vielleicht erhöhen, falls Sie die Index-Dateien neu erstellen sollten. Setzen Sie diesen Wert auf 0, falls PHPGedView unendlich lange laufen soll.<br />VORSICHT: Sollten Sie diesen Wert auf 0 oder zu hoch ansetzen, könnte dies das \"HÄNGEN\" Ihrer Website auf einigen Systemen bewirken, bis das Script endgültig fertiggestellt ist. Das Setzen dieses Wertes auf 0 bedeutet, dass das Script nie beendet wird, bis der Administrator Ihres Servers den Prozess manuell löscht oder den Servernn, indem er einen Stammbaum für 1000 Generationen aufruft.<br /><br />Diese Einstellung definiert den Wert der Variable \$TIME_LIMIT in der Datei \"config.php\".";
$pgv_lang["PGV_SESSION_SAVE_PATH"]	= "Pfad für die Session-Speicherung:";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]	= "Der Pfad zum Speichern der \"Session\"-Dateien. Auf einigen Hosts ist PHP nicht sorgfältig konfiguriert und die Sitzungs-Daten werden zwischen den Seiten-Aufrugen nicht gespeichert. Hier können Sie die Standard-Einstellung überschreiben um ein eigenes lokales Verzeichnis zu verwenden. Ein geeignetes Verzeichnis wäre ./index/, falls eine Änderung notwendig ist. Normalerweise bleibt dieses Feld leer und es wird ein Pfad verwendet, der in der php.ini-Datei eingetragen ist.<br /><br />Diese Einstellung verändert die Variable \$PGV_SESSION_SAVE_PATH in der Datei config.php.";
$pgv_lang["SERVER_URL"]			= "Server URL:";
$pgv_lang["SERVER_URL_help"]		= "Wenn Sie https oder einen anderen Port benutzen, müssen Sie hier die URL eingeben, über die Ihr Server erreicht werden kann.<br /><br />Diese Einstellung verändert die Variable \$SERVER_URL in der Datei config.php.";
$pgv_lang["PGV_SESSION_TIME"]		= "Session Timeout:";
$pgv_lang["PGV_SESSION_TIME_help"]	= "Die Zeit nach der man sich für eine PhpGedView-Sitzung erneut anmelden muss (login). Standard-Wert ist 30 Minuten<br /><br />Diese Einstellung verändert die Variable \$PGV_SESSION_TIME in der Datei config.php.";
$pgv_lang["SHOW_STATS"]			= "Aufruf-Statistik anzeigen:";
$pgv_lang["SHOW_STATS_help"]		= "Ablauf-Statistiken und Datenbank-Abfragen am unteren Seitenrand aller Seiten einblenden.<br /><br />Diese Einstellung verändert die Variable \$SHOW_STATS in der Datei config.php.";
$pgv_lang["USE_REGISTRATION_MODULE"]	= "Besuchern erlauben eine Registrierung anzufordern:";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "Erlaubt den Benutzern, sich selbst für einen Benutzerzugang zu diesen Seiten zu registrieren. Der Administrator muss diese Registrierung freischalten, bevor sie aktiv wird<br /><br />Diese Einstellung verändert die Variable \$USE_REGISTRATION_MODULE in der Datei config.php.";
$pgv_lang["ALLOW_USER_THEMES"]		= "Besuchern die Auswahl eines Themes erlauben:";
$pgv_lang["ALLOW_USER_THEMES_help"]	= "Erlaubt den Benutzern eigene Themes auszuwählen.<br /><br />Diese Einstellung verändert die Variable \$ALLOW_USER_THEMES in der Datei config.php.";
$pgv_lang["CREATE_GENDEX"]		= "Gendex Files erstellen:";
$pgv_lang["CREATE_GENDEX_help"]		= "PhpGedView kann Gendex files erstellen, wenn eine Gedcom-Datei importiert wird. Diese werden dann im Index-Verzeichnis gespeichert.<br /><br />Diese Einstellung verändert die Variable \$CREATE_GENDEX in der Datei config.php.";
$pgv_lang["gedcom_title_help"]		= "Geben Sie eine Bezeichnung ein, die den Inhalt dieser GEDCOM Datei beschreibt.";
$pgv_lang["LOGFILE_CREATE"]		= "Log-Dateien erzeugen:";
$pgv_lang["LOGFILE_CREATE_help"]	= "Bestimmt, in welchem Rhythmus eine neue Log-Datei erzeugt wird.<br /><br />Diese Einstellung verändert die Variable \$LOGFILE_CREATE in der Datei config.php.";

$pgv_lang["welcome"]			= "Willkommen auf Ihrer neuen PhpGedView-Website. Da sie diese Seite angezeigt bekommen, haben Sie PhpGedView auf Ihrem Webserver schon erfolgreich installiert und sind nun bereit, es nach Ihren Vorstellungen zu konfigurieren.<br />";
$pgv_lang["welcome_help"]		= "Dieses Hilfe-Fenster wird Ihnen bei der Konfiguration zur Seite stehen. Wenn Sie das Eingabe-Feld wechseln erscheint hier jeweils ein Hilfetext zu dem Feld, in dem sie die Eingabemarke befindet. Sie können das Fenster schließen; um es wieder zu öffnen klicken Sie auf das \"?\" neben einem Eingabefeld.";
$pgv_lang["review_readme"]		= "Sie sollten zunächst die Datei <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> durchlesen, bevor Sie die Konfiguration von PhpGedView fortsetzen.<br /><br />Sie können jederzeit diese Konfigurationsseite aufrufen, wenn Sie sich über Anmelden erfolgreich angemeldet haben, Administratorenrechte besitzen, auf Verwalten klicken und dort den Menupunkt Konfiguration anklicken. (editconfig.php)<br /><br />Hilfe erhalten Sie, wenn Sie auf das jeweilige Fragezeichen (?) hinter der linken Einstellungsbezeichnung klicken.";
$pgv_lang["save_config"]		= "Konfiguration speichern";
$pgv_lang["reset"]			= "Reset";
$pgv_lang["download_here"]		= "Hier Klicken, um die Datei herunterzuladen.";
$pgv_lang["download_gedconf"]		= "GEDCOM Konfiguration herunterladen.";
$pgv_lang["not_writable"]		= "Die Konfiguration lässt sich nicht speichern. Mit dem Download-Button können Sie Ihre Einstellungen in eine Datei speichern, die Sie anschließend manuell hochladen müssen.";
$pgv_lang["download_file"]		= "Datei Download";
$pgv_lang["upload_to_index"]		= "Datei kann anschließend auch manuell in Ihr Index-Verzeichnis hochgeladen werden: ";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Konfiguration der Datenschutzdatei";
$pgv_lang["edit_privacy_title"]			= "Konfiguration der Datenschutzdatei - [#PRIVACY_MODULE#]";
$pgv_lang["PRIV_PUBLIC"]			= "Allen Besuchern zeigen";
$pgv_lang["PRIV_USER"]				= "Nur angemeldeten Besuchern zeigen";
$pgv_lang["PRIV_NONE"]				= "Nur Administratoren zeigen";
$pgv_lang["PRIV_HIDE"]				= "Auch vor Administratoren verbergen";
$pgv_lang["save_changed_settings"]		= "Änderungen speichern";
$pgv_lang["add_new_pp_setting"]			= "Neue Einstellung für ein Element hinzufügen";
$pgv_lang["add_new_up_setting"]			= "Neue Einstellung für einen Benutzer hinzufügen";
$pgv_lang["add_new_gf_setting"]			= "Neue globale Einstellung hinzufügen";
$pgv_lang["add_new_pf_setting"]			= "Neue Einstellung für Ereignisse hinzufügen";
$pgv_lang["add_new_pf_setting_indi"]		= "Neue Einstellung für Ereignisse von Personen hinzufügen";
$pgv_lang["add_new_pf_setting_source"]		= "Neue Einstellung für Ereignisse von Quellen hinzufügen";
$pgv_lang["privacy_indi_id"]			= "Personen - ID";
$pgv_lang["privacy_source_id"]			= "Quellen - ID";
$pgv_lang["privacy_indi_source"]		= "Person / Quelle";
$pgv_lang["privacy_indi"]			= "Person";
$pgv_lang["privacy_source"]			= "Quelle";
$pgv_lang["file_read_error"]			= "F E H L E R !!! Die Datenschutz - Datei konnte nicht gelesen werden!";
$pgv_lang["general_settings"]			= "Allgemeine Datenschutz-Einstellungen";
$pgv_lang["person_privacy_settings"]		= "Element-Einstellungen";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Vorhandene Einstellungen für Elemente bearbeiten";
$pgv_lang["user_privacy_settings"]		= "Benutzer-Einstellungen";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Vorhandene Einstellungen für Benutzer bearbeiten";
$pgv_lang["global_facts_settings"]		= "Globale Einstellungen";
$pgv_lang["edit_exist_global_facts_settings"]	= "Vorhandene globale Einstellungen bearbeiten";
$pgv_lang["person_facts_settings"]		= "Ereignis-Einstellungen";
$pgv_lang["edit_exist_person_facts_settings"]	= "Vorhandene Ereignis-Einstellungen bearbeiten";
$pgv_lang["accessible_by"]			= "Wem zeigen?";
$pgv_lang["hide"]				= "Verbergen";
$pgv_lang["show_question"]			= "Anzeigen?";
$pgv_lang["user_name"]				= "Benutzername";
$pgv_lang["name_of_fact"]			= "Ereignis - Bezeichnung";
$pgv_lang["choice"]				= "Auswahl";
$pgv_lang["fact_show"]				= "Ereignis zeigen";
$pgv_lang["fact_details"]			= "Ereignis-Details zeigen";
$pgv_lang["privacy_header"]			= "Datenschutz - Einstellungen bearbeiten in";
$pgv_lang["unable_to_find_privacy_indi"]	= "Zu folgender ID kann keine Person gefunden werden:";
$pgv_lang["save_and_import"]			= "Nach dem Speichern dieser GEDCOM Konfiguration müssen Sie die Daten importieren, indem  Sie auf den <strong>\"Diese GEDCOM-Datei importieren\"</strong> Button klicken oder über fogende Menüpunkte: <strong>Verwalten->Gedcom Datei Management->Gedcom Import</strong>";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Namen lebender Personen anzeigen";
$pgv_lang["SHOW_RESEARCH_LOG"]			= "Nachforschungs - Protokoll anzeigen";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Verwandtschafts - Datenschutz einschalten";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Max. Länge der Verwandtschaft";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Verwandtschaft anhand von Eheschließungen überprüfen";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Verstorbene Personen anzeigen";
$pgv_lang["help_info"]				= "Hilfe erhalten Sie, wenn Sie auf das jeweilige rote Fragezeichen (?) hinter der Einstellungsbezeichnung klicken.";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "Namen lebender Personen anzeigen<br /><br />Mit dieser Einstellung können Sie definieren, wem die Namen lebender Personen angezeigt werden.<br />Üblicherweise sollte diese Variable die Einstellung \"Nur angemeldeten Benutzern zeigen\" haben. Dies dient dem Datenschutz lebender Personen, die in Ihrer GEDCOM-Datenbank enthalten sind, denn Sie können selber bestimmen, wem Sie den allgemeinen Zugriff auf Ihre Ahnenforschungsdaten geben.<br />Die Einstellung \"Nur Administratoren zeigen\" verhindert die Anzeige der Namen lebender Personen auch für angemeldete Besucher, die jedoch keinen Administratorenstatus haben.<br /><br />Diese Einstellung verändert die Variable \$SHOW_LIVING_NAMES in der gewählten Datenschutz - Datei.";
$pgv_lang["SHOW_RESEARCH_LOG_help"]		= "Nachforschungs - Protokoll anzeigen.<br /><br />Dieses Feld bestimmt, welchen Benutzern das Nachforschungsprotokoll angezeigt werden soll.<br />Dieses Feld ist nur von Bedeutung, wenn das Project \"research-log\" in PHPGedView eingebunden wurde.<br /><br />Diese Einstellung verändert die Variable \$SHOW_RESEARCH_LOG in der gewählten Datenschutz - Datei.";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "Verwandtschafts - Datenschutz einschalten.<br /><br />\"Nein\" bedeutet, dass alle authentifizierten Benutzer alle Daten lebender Personen zu sehen bekommen.<br /><br />\"Ja\" bedeutet, dass authentifizierte Benutzer nur die Daten lebender Personen zu sehen bekommen, mit denen sie verwandt sind.<br />Der Verwandtschaftsgrad wird mit der Einstellung \"Max. Länge der Verwandtschaft\" eingestellt.<br /><br />Diese Einstellung verändert die Variable \$USE_RELATIONSHIP_PRIVACY in der gewählten Datenschutz - Datei.";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "Maximalen Verwandtschaftsgrad einstellen.<br /><br />Der Verwandtschaftsgrad bis zu der die Daten lebender Personen authentifizierten Benutzern angezeigt werden.<br />Dieser Wert ist nur relevant, wenn der Verwandtschafts - Datenschutz eingeschaltet wurde.<br /><br />Diese Einstellung verändert die Variable \$MAX_RELATION_PATH_LENGTH in der gewählten Datenschutz - Datei.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "Verwandtschaft anhand von Eheschließungen überprüfen<br /><br />Soll der Verwandtschaftsgrad auch durch Zurhilfenahme von Eheschließungsdaten geprüft werden?<br /><br />Diese Einstellung verändert die Variable \$CHECK_MARRIAGE_RELATIONS in der gewählten Datenschutz - Datei.";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "Verstorbene Personen anzeigen<br /><br />Setzt die Datenschutz-Einstellungen für alle verstorbenen Personen.";
$pgv_lang["person_privacy_help"]		= "Die \"person_privacy\" - Einstellung ermöglicht dem Administrator, voreingestellte Datenschutz - Einstellungen für Personen aus der GEDCOM-Datenbank zu überschreiben.<br /><br />Wenn z.B. einer Person in der Datenbank ein Kind zugeordnet ist, das im Kleinkindalter verstarb, dann werden normalerweise die Daten dieses Kindes allen (auch nichteingetragenen) Besuchern der Website angezeigt, da es schon verstorben ist.<br />Aber die Daten der Eltern sind nicht öffentlich zugänglich, da diese noch leben.<br />Nun möchten Sie den Sterbe - Eintrag dieses Kindes nicht aus der Datenbank entfernen, jedoch alle Daten dieses Kindes unter Datenschutz stellen.<br /><br />Hat dieses Kind z.B. die ID 100, dann geben Sie auf dieser Seite zur Bearbeitung der Datenschutz - Einstellungen folgendes ein:<br /><br />Identifikationsnummer: I100<br />Wem zeigen: \"Nur angemeldeten Benutzern anzeigen\"<br /><br />Dann bekommen nur registrierte Besucher der Website, nach einem Login, die Daten dieses Kindes zu sehen.<br /><br />Dies funktioniert natürlich auch anders herum:<br /><br />Um alle Daten einer Person (ID 101), die z.B. nicht mehr lebt aber deren Sterbedaten unbekannt sind, dennoch für alle Benutzer sichtbar zu machen, bearbeiten Sie die Datenschutz - Einstellungen wie folgt:<br /><br />Identifikationsnummer: I101<br />Wem zeigen: \"Allen Besuchern anzeigen\"<br /><br />Dann bekommen ALLE Besucher der Website die Daten dieser Person zu sehen.<br /><br />Diese Einstellung verändert die Variablen \$person_privacy in der gewählten Datenschutz - Datei.";
$pgv_lang["user_privacy_help"]			= "Die \"user_privacy\" - Einstellung ermöglicht dem Administrator, voreingestellte Datenschutz - Einstellungen zur Anzeige der Daten von Personen für ausgewählte registrierte Besucher zu verändern.<br /><br />Wenn z.B. ein registierter Benutzer mit dem Benutzernamen \"John\" nach seinem Login die Daten einer bestimmten Person (z.B. ID 100) nicht sehen können soll, dann geben Sie auf der Seite zur Bearbeitung der Datenschutz - Einstellungen folgendes ein:<br /><br />Benutzername: John<br />Identifikationsnummer: I100<br />Anzeigen?: \"Verbergen\"<br /><br />Dadurch erreichen Sie, dass alle Details der Person mit der ID 100 NUR vor den Augen des Besuchers \"John\" verborgen werden.<br /><br />Dies funktioniert natürlich auch anders herum:<br /><br />Um alle Daten einer Person (ID 101), die normalerweise verborgen blieben (Person lebt noch oder Verwandschaftsgrad zu gering), dennoch für Benutzer \"John\" sichtbar zu machen, bearbeiten Sie die Datenschutz - Einstellungen wie folgt:<br /><br />Benutzername: John<br />Identifikationsnummer: I101<br />Anzeigen?: \"Anzeigen\"<br /><br />Dann werden alle Details der Person mit der ID 101 dem Besucher \"John\" angezeigt.<br /><br />Diese Einstellung verändert die Variablen \$user_privacy in der gewählten Datenschutz - Datei.";
$pgv_lang["global_facts_help"]			= "Die \"global_facts\" - Einstellung ermöglicht dem Administrator, voreingestellte Datenschutz - Einstellungen zur Anzeige von Ereignissen GLOBAL zu verändern.<br /><br />Die Einstellung [\"Ereignis-Bezeichnung\"] legt fest, welches Ereignis angezeigt/unterdrückt werden soll.<br />Die Einstellung [\"Auswahl\"] legt fest, ob Sie das Ereignis selbst, oder zusätzlich gespeicherte Daten meinen.<br />Die Einstellung [\"Wem zeigen ?\"] legt fest, wem die Details des Ereignisses angezeigt werden.<br /><br />Diese Einstellungen sind hauptsächlich vorgesehen, um bestimmte Ereignisse lebender und verstorbener Personen aus der GEDCOM-Datenbank grundsätzlich zu verbergen.<br />Standardmäßig ist die Unterdrückung der SSN (Sozialversicherungsnummer - vor allem in den USA relevant) voreingestellt.<br />Falls Sie z.B. alle Eheschließungen innerhalb der GEDCOM-Datenbank vor nicht authentifizierten Besuchern verbergen möchten, könnten Sie folgende Eingaben auf der Seite zur Bearbeitung der Datenschutz - Einstellungen machen:<br /><br />Ereignis-Bezeichnung: (MARR) - Heirat<br />Auswahl: \"Ereignis zeigen\"<br />Wem zeigen?: \"Nur angemeldeten Besuchern zeigen\"<br /><br />Ereignis-Bezeichnung: (MARR) - Heirat<br />Auswahl: \"Ereignis-Details zeigen\"<br />Wem zeigen?: \"Nur angemeldeten Besuchern zeigen\"<br /><br />Dann werden alle Eheschließungen inklusive ihrer Details nur den Besuchern angezeigt, die authentifiziert (eingeloggt) sind.<br /><br />Unter \"global_facts\" können Sie - im Gegensatz zu den übrigen Einstellungen - bestimmte Ereignisse sogar vor dem Administrator verbergen. Dies dient dazu überflüssige Angaben komplett zu unterdrücken.<br /><br />Diese Einstellung verändert die Variablen \$global_facts in der gewählten Datenschutz - Datei.";
$pgv_lang["person_facts_help"]			= "Die \"person_facts\" - Einstellung ermöglicht dem Administrator, voreingestellte Datenschutz - Einstellungen zur Anzeige von personenbezogenen Ereignissen zu verändern.<br /><br />Das erste Element ist die ID der Person, das Zweite ist das Ereignis.<br />Die Einstellung [\"Auswahl\"] legt fest, ob Sie das Ereignis selbst, oder zusätzlich gespeicherte Daten meinen.<br />Die Einstellung [\"Wem zeigen ?\"] legt fest, wem das Ereignis angezeigt wird.<br /><br />Die \$person_facts - Einstellung funktioniert genauso, wie die \$global_facts - Einstellung nur mit dem Unterschied, dass Sie zusätzlich die ID-Nummer der Person aus der GEDCOM-Datenbank auswählen müssen, deren Ereignisse Sie verbergen oder zeigen möchten.<br />Das Eheschließungs-Ereignis (einschließlich Details) der Person mit der ID-Nummer 100 verbergen Sie z.B. vor nicht authentifizierten (nicht eingeloggten) Besuchern durch:<br /><br />Identifikationsnummer: I100<br />Ereignis-Bezeichnung: (MARR) - Heirat<br />Auswahl: \"Ereignis zeigen\"<br />Wem zeigen?: \"Nur angemeldeten Besuchern zeigen\"<br /><br />Identifikationsnummer: I100<br />Ereignis-Bezeichnung: (MARR) - Heirat<br />Auswahl: \"Ereignis-Details zeigen\"<br />Wem zeigen?: \"Nur angemeldeten Besuchern zeigen\"<br /><br />Diese Einstellung verändert die Variablen \$person_facts in der gewählten Datenschutz - Datei.";
$pgv_lang["find_sourceid"]			= "Quelle auswählen";

//-- language edit utility
$pgv_lang["edit_langdiff"]		= "Sprach-Dateien bearbeiten und konfigurieren";
$pgv_lang["edit_lang_utility"]		= "Bearbeitungsmodul für Sprach-Dateien";
$pgv_lang["edit_lang_utility_help"]	= "Dieses Modul dient zum Bearbeiten der Sprachdateien.<br />Es zeigt den Inhalt der englischen Original-Datei und den Inhalt der ausgewählten Sprachdatei an.<br />Durch einen Klick auf den Inhalt der ausgewählten Datei öffnet sich ein neues Fenster, in dem die Übersetzung geschrieben oder der vorhandene Text bearbeitet und anschließend gespeichert werden kann.";
$pgv_lang["language_to_edit"]		= "Zu bearbeitende Sprache";
$pgv_lang["file_to_edit"]		= "Zu bearbeitende Sprachdatei";
$pgv_lang["lang_save"]			= "Speichern";
$pgv_lang["contents"]			= "Inhalt";
$pgv_lang["listing"]			= "Eintragung";
$pgv_lang["no_content"]			= "kein Inhalt";
$pgv_lang["editlang_help"]		= "Sprachdatei bearbeiten";
$pgv_lang["cancel"]			= "Abbrechen";
$pgv_lang["savelang_help"]		= "Änderung speichern";
$pgv_lang["original_message"]		= "Original Inhalt";
$pgv_lang["message_to_edit"]		= "Zu ändernder Inhalt";
$pgv_lang["changed_message"]		= "Geänderter Inhalt";
$pgv_lang["message_empty_warning"]	= "-&gt; Achtung!!! Diese Nachricht ist in der Datei [#LANGUAGE_FILE#] leer &lt;-";
$pgv_lang["language_to_export"]		= "Zu exportierende Sprache";
$pgv_lang["export_lang_utility"]	= "Exportmodul für Sprach-Dateien";
$pgv_lang["export"]			= "Exportieren";
$pgv_lang["export_lang_utility_help"]	= "Mit diesem Modul können Sie eine Sprache auswählen und auf den Export-Button klicken, um die Hilfetexte der gewählten 'configuration_help' Sprachdatei zwecks Erstellung einer Anleitung in Ihrer Sprache zu exportieren.";
$pgv_lang["export_ok"]			= "Die Hilfetexte wurden exportiert";
$pgv_lang["compare_lang_utility"]	= "Vergleichsmodul für Sprach-Dateien";
$pgv_lang["compare_lang_utility_help"]	= "Dieses Modul vergleicht zwei Sprachdateien und zeigt die Unterschiede an.<br /><br />Beachten Sie auch die Datei [#languages/LANG_CHANGELOG.txt#], bezüglich weiterer Änderungen.";
$pgv_lang["new_language"]		= "Neue Sprache";
$pgv_lang["old_language"]		= "Alte Sprache";
$pgv_lang["compare"]			= "Vergleichen";
$pgv_lang["comparing"]			= "Die Sprach-Dateien werden verglichen";
$pgv_lang["additions"]			= "Ergänzungen";
$pgv_lang["no_additions"]		= "Keine Ergänzungen";
$pgv_lang["subtractions"]		= "Entfernte Teile";
$pgv_lang["no_subtractions"]		= "Keine entfernten Teile";
$pgv_lang["config_lang_utility"]	= "Konfiguration der unterstützten Sprachen";
$pgv_lang["config_lang_utility_help"]	= "Dieses Modul hilft Ihnen die Einstellungen der von PhpGedView unterstützten Sprachen zu bearbeiten.<br /><br />";
$pgv_lang["active"]			= "Aktiviert";
$pgv_lang["active_help"]		= "Erlauben Sie den Besuchern, diese Sprache auszuwählen, sofern der Sprachwechsel generell erlaubt ist.";
$pgv_lang["edit_settings"]		= "Einstellungen bearbeiten";
$pgv_lang["lang_edit"]			= "Bearbeiten";
$pgv_lang["lang_language"]		= "Sprache";
$pgv_lang["export_filename"]		= "Name der Datei, welche die exportierten Daten enthält:";
$pgv_lang["lang_back"]			= "Zurück zum Hauptmenu, um die Sprach-Dateien zu bearbeiten und zu konfigurieren";
$pgv_lang["lang_back_admin"]		= "Zurück zum Verwaltungsmenu";
$pgv_lang["lang_name_chinese"]		= "Chinesisch";
$pgv_lang["lang_name_danish"]		= "Dänish";
$pgv_lang["lang_name_dutch"]		= "Holländisch";
$pgv_lang["lang_name_english"]		= "Englisch";
$pgv_lang["lang_name_french"]		= "Französisch";
$pgv_lang["lang_name_german"]		= "Deutsch";
$pgv_lang["lang_name_hebrew"]		= "Hebräisch";
$pgv_lang["lang_name_italian"]		= "Italiänisch";
$pgv_lang["lang_name_norwegian"]	= "Norwegisch";
$pgv_lang["lang_name_polish"]		= "Polnisch";
$pgv_lang["lang_name_portuguese"]	= "Portugiesisch";
$pgv_lang["lang_name_portuguese-br"]	= "Brasilianisches Portugiesisch";
$pgv_lang["lang_name_russian"]		= "Russisch";
$pgv_lang["lang_name_spanish"]		= "Spanisch";
$pgv_lang["lang_name_spanish-ar"]	= "Latein-Amerikanisches Spanisch";
$pgv_lang["lang_name_swedish"]		= "Schwedisch";
$pgv_lang["lang_name_turkish"]		= "Türkisch";
$pgv_lang["original_lang_name"]		= "Original-Name der Sprache auf #D_LANGNAME#";

$pgv_lang["lang_shortcut"]		= "Abkürzung für Sprachdateien";

$pgv_lang["lang_filename"]		= "Sprachdatei";
$pgv_lang["lang_filename_help"]		= "Name und Pfad der Datei mit den allgemeinen Übersetzungen.";
$pgv_lang["config_filename"]		= "Konfigurations-Sprachdatei";
$pgv_lang["config_filename_help"]	= "Name und Pfad der Datei mit den Übersetzungen für die Konfiguration.";
$pgv_lang["facts_filename"]		= "Ereignisdatei";
$pgv_lang["facts_filename_help"]	= "Name und Pfad der Datei mit den Übersetzungen für die GEDCOM-Ereignisse.";
$pgv_lang["help_filename"]		= "Dateiname der Hilfedatei";
$pgv_lang["help_filename_help"]	= "Name und PFad der Datei mit den Übersetzungen der Hilfe-Texte.";
$pgv_lang["flagsfile"]			= "Flaggendatei";
$pgv_lang["flagsfile_help"]		= "Name und Pfad der Bilddatei für die Nationalflagge der ausgewählten Sprache.";
$pgv_lang["text_direction"]		= "Schreibrichtung";

$pgv_lang["date_format"]		= "Datumsformat";

$pgv_lang["week_start"]			= "1. Tag der Woche";
$pgv_lang["week_start_help"]		= "Der Tag der Woche, mit dem in diesem Sprachraum eine neue Woche beginnt. In vielen Sprachen beginnt die Woche Sonntags, aber in anderen auch am Montag oder an anderen Tagen.";
$pgv_lang["name_reverse"]		= "Nachname zuerst";
$pgv_lang["name_reverse_help"]		= "In einigen Sprachen wird üblicherweise der Nachname vor den Vornamen gestellt, währen er normalerweise hinten steht. Wählen Sie diese Option, um den Nachnamen zuerst anzuzeigen.";
$pgv_lang["ltr"]			= "Links nach rechts";
$pgv_lang["rtl"]			= "Rechts nach links";
$pgv_lang["file_does_not_exist"]	= "FEHLER! Diese Datei existiert nicht...";
$pgv_lang["alphabet_upper"]		= "Alphabet Großbuchstaben";
$pgv_lang["alphabet_upper_help"]	= "Großbuchstaben-Alphabet. Dieses Alphabet wird benutzt, um die groß geschriebenen Namen in den Namen-Listen von PhpGedView zu sortieren (in der gewählte Sprache).";
$pgv_lang["alphabet_lower"]		= "Alphabet Kleinbuchstaben";
$pgv_lang["alphabet_lower_help"]	= "Kleinbuchstaben-Alphabet. Dieses Alphabet wird benutzt, um die klein geschriebenen Namen in den Namen-Listen von PhpGedView zu sortieren (in der gewählte Sprache).";
$pgv_lang["lang_config_write_error"]	= "Fehler beim Versuch, die Spracheinstellungen in die Datei [language_settings.php] zu schreiben. Prüfen Sie die Zugriffsrechte und probieren Sie es erneut.";
$pgv_lang["lang_save_success"]		= "Die Änderungen für #PGV_LANG# wurden erfolgreich gespeichert.";
$pgv_lang["translation_forum"]		= "Link zum PhpGedView Übersetzungs-Forum bei SourceForge.net";
$pgv_lang["translation_forum_help"]	= "Dieser link öffnet ein neues Browserfenster, in dem Sie zum Übersetzungs-Forum von PhpGedView (http://sourceforge.net/forum/forum.php?forum_id=294245) geleitet werden, wo Probleme bezüglich der Übersetzung von PhpGedView besprochen werden können.";

// Help message upgrade utility
$pgv_lang["how_upgrade_help"]		= "Das Upgrade-Tool<br />Das Upgrade-Tool überwacht die Aktualisierung Ihres bestehenden phpGedView auf eine neuere Version, die Sie aus dem Internet heruntergeladen haben.<br /><br />Eine neue Version herunterladen ?<br />Eine neue Version können Sie entweder direkt von http://sourceforge.net/projects/phpgedview/ herunterladen oder das Upgrade-Tool kann selbst nach einer neuen Version suchen. Falls eine neue Version exisitert, werden die verfügbaren Downloads angezeigt (zip-Dateien oder gz-Dateien oder beides).<br /><br />Was wird aktualisiert ?<br />* PhpGedView<br />Dies wird alle Kern-Dateien von PhpGedView außer config.php, privacy.php und authenticate.php aktualisieren. Auch die images-Verzeichnisse werden aktualisiert.<br />* Index Dateien<br />Dies aktualisiert das Verzeichnis /index. Benutzen Sie diese Option mit Vorsicht, da alle existierenden Dateien überschrieben werden.<br />* Sprachen<br />Aktualisiert das Verzeichnis /languages.<br />* Themes<br />Aktualisiert das Verzeichnis /themes. Ebenfalls mit Vorsicht zu benutzen, da eventuelle Anpassungen überschrieben werden.<br />* Konfigurations-Datei<br />Dies überprüft Ihre aktuelle Konfigurations-Datei und aktualisiert nur die Änderungen aus der neuen Datei in Ihre Datei hinein. So wird sichergestellt, dass Sie die neueste Konfigurations-Datei mit Ihren eigenen Einstellungen haben.<br />* Privacy Datei(en)<br />Überprüft Ihre aktuelle(n) Privacy-Datei(en) und aktualisiert nur die Änderungen aus der neuen Datei in Ihre Datei hinein. So wird sichergestellt, dass Sie die neueste Privacy-Datei mit Ihren eigenen Einstellungen haben.<br />* Handbücher<br />Aktualisiert das Verzeichnis /doc.<br />* Researchlog<br />Aktualisiert das Researchlog Plugin.<br />* Sicherung erstellen<br />Diese Option erstellt eine Kopie der alten Dateien im Verzeichnis /backup.<br /><br />Wie kann ich aktualisieren ?<br />1. Wählen Sie die Programm-Teile, die Sie aktualisieren möchten ?<br />2. Klicken Sie auf Speichern<br /><br />Der Fortschritt der Aktualisierung wird am unteren Seitenrand angezeigt.";

?>