<?php
/*=================================================
   charset=utf-8
   Project: 	phpGedView
   File: 		configure_help.nl.php
   Author: 	Erik Bent/Boudewijn Sjouke
   Comments:	Dutch Language Configure Help file for PHPGedView
   Change Log:	2003-05-16 - File Created
   		2003-12-05 - Updated to version 2.61b6 by Jans B. Luder
   		2003-12-24 - Updated to version 2.65 by Boudewijn Sjouke
   		2004-01-05 - Updated to version 2.65 Final by Jans B. Luder
   		2004-01-22 - Updated to version 2.65.1 Final by Boudewijn en Jans
===================================================*/
# $Id: configure_help.nl.php,v 1.23.2.4 2004/02/01 18:46:21 sjouke Exp $
if (preg_match("/configure_help\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}
//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"]			= "Instellen PHPGedView";
$pgv_lang["default_user"]		= "Aanmaken van de beheerder.";
$pgv_lang["about_user"]			= "U moet eerst de beheerder aanmaken. De beheerder heeft de rechten om de instellingen te wijzigen, priv&eacute; gegevens te bekijken en andere gebruikers aan te maken.";
$pgv_lang["fullname"]			= "Volledige naam:";
$pgv_lang["confirm"]			= "Geef wachtwoord opnieuw:";
$pgv_lang["can_admin"]			= "Gebruiker mag beheer taken uitvoeren:";
$pgv_lang["can_edit"]			= "Gebruiker mag wijzigen:";
$pgv_lang["add_user"]			= "Toevoegen van een nieuwe gebruiker";
$pgv_lang["current_users"]		= "Huidige gebruikers";
$pgv_lang["leave_blank"]		= "Laat het wachtwoord leeg als u het huidige wachtwoord wilt behouden.";
$pgv_lang["other_theme"]		= "Ander, typ in";
$pgv_lang["performing_update"]		= "Update uitvoeren.";
$pgv_lang["config_file_read"]		= "Lezen instellingenbestand.";
$pgv_lang["does_not_exist"]		= "bestaat niet";
$pgv_lang["config_write_error"]		= "Fout bij schrijven van configuratie bestand. Kontroleer de eigenschappen en probeer het opnieuw.";
$pgv_lang["db_setup_bad"]		= "De huidige database configuratie is corrupt. Controleer de database verbindingsparameters en configureer opnieuw.";
$pgv_lang["click_here_to_continue"]	= "Klik hier om door te gaan.";
$pgv_lang["config_help"]		= "Configuratie uitleg";
$pgv_lang["index"]			= "Indexbestanden";
$pgv_lang["mysql"]			= "MySQL";
$pgv_lang["admin_gedcoms"]		= "Klik hier om de Gedcoms te beheren.";
$pgv_lang["current_gedcoms"]		= "Huidige Gedcoms";
$pgv_lang["ged_download"]		= "Download";
$pgv_lang["ged_gedcom"]			= "Gedcom bestand";
$pgv_lang["ged_title"]			= "Gedcom titel";
$pgv_lang["ged_config"]			= "Bestand Instellingen";
$pgv_lang["show_phpinfo"]		= "Toon PHPInfo";
$pgv_lang["confirm_gedcom_delete"]	= "Weet u zeker dat u dit Gedcom bestand wilt verwijderen?";
$pgv_lang["gregorian"]			= "Gregoriaans";
$pgv_lang["julian"]			= "Juliaans";
$pgv_lang["config_french"]		= "Frans";
$pgv_lang["jewish"]			= "Joods";
$pgv_lang["config_hebrew"]		= "Hebreews";
$pgv_lang["jewish_and_gregorian"]	= "Joods en Gregoriaans";
$pgv_lang["hebrew_and_gregorian"]	= "Hebreeuws en Gregoriaans";
$pgv_lang["disabled"]			= "Uitgeschakeld";
$pgv_lang["mouseover"]			= "Door muisaanwijzer erover";
$pgv_lang["mousedown"]			= "Door muisknop ingedrukt";
$pgv_lang["click"]			= "Door muisklik";
$pgv_lang["mailto"]	 		= "Mailen naar";
$pgv_lang["messaging"]			= "PhpGedView Interne Berichten";
$pgv_lang["messaging2"]			= "Interne Berichten en Emails";
$pgv_lang["no_messaging"]		= "Geheel geen contact";
$pgv_lang["no_logs"]			= "Log-bestand uitschakelen";
$pgv_lang["daily"]			= "Dagelijks";
$pgv_lang["weekly"]			= "Wekelijks";
$pgv_lang["monthly"]			= "Maandelijks";
$pgv_lang["yearly"]			= "Jaarlijks";

$pgv_lang["PGV_DATABASE"] 		= "PHPGedView gegevensopslag:";
$pgv_lang["PGV_DATABASE_help"] 		= "Hiermee stelt u in, welke type gegevens-opslag u wilt gebruiken voor de GEDCOM bestanden, die u importeert. Selecteer &quot;Indexbestanden&quot; voor opslag in de Index-map, selecteer &quot;MySQL&quot; om een MySQL-database te gebruiken. Dit stelt de \$PGV_DATABASE variabele in, in het config.php bestand.";
$pgv_lang["DBHOST"] 			= "MySQL database machine:";
$pgv_lang["DBHOST_help"] 		= "De DNS naam of het ip adres van the computer waar de MySQL database staat. Dit zet de \$DBHOST variabele in het config.php bestand.";
$pgv_lang["DBUSER"] 			= "MySQL database gebruikersnaam:";
$pgv_lang["DBUSER_help"] 		= "De MySQL database gebruikersnaam die nodig is om in te loggen op de database.  Dit zet de \$DBUSER variabele in het config.php bestand.";
$pgv_lang["DBPASS"] 			= "MySQL database wachtwoord:";
$pgv_lang["DBPASS_help"] 		= "Het MySQL database wachtwoord van de gebruiker. Dit zet de \$DBPASS variabele in het config.php bestand.";
$pgv_lang["DBNAME"] 			= "Database naam:";
$pgv_lang["DBNAME_help"] 		= "De database in de MySQL machine die phpGedView moet gebruiken. De gebruikersnaam in het gebruikersveld moet create, insert, update, delete, en select privilege op deze database hebben. Dit zet de \$DBNAME variabele in het config.php bestand.";
$pgv_lang["TBLPREFIX"]			= "Database tabellen voorvoegsel:";
$pgv_lang["TBLPREFIX_help"]		= "Een voorvoegsel voor de MySQL tabellen die gemaakt zijn door phpGedView. Door het veranderen van deze waarde kunt u meerdere phpGedView sites gebruik laten maken van dezelfde database maar met verschillende tabellen.  Dit zet de \$TBLPREFIX variabele in het config.php bestand.";
$pgv_lang["DEFAULT_GEDCOM"]		= "Standaard GEDCOM:";
$pgv_lang["DEFAULT_GEDCOM_help"]	= "De MySQL versie van phpGedView bevat de mogelijkheid om met meerdere gedcom datasets in dezelfde database te stoppen. Gebruik deze variabele om een standaard GEDCOM dataset voor alle gebruikers in te stellen. Een lege waarde zal de eerst geïmporteerde gedcom gebruiken. Als de gebruiker de mogelijkheid heeft om de GEDCOM te wijzigen dan staat er op iedere pagina een link met de mogelijkheid om de gedcom te wijzigen. Dit zet de \$DEFAULT_GEDCOM variabele in het config.php bestand.";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]	= "Sta bezoekers toe om GEDCOM\'s te wijzigen:";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "Upload uw GEDCOM bestand eerst naar een locatie, die door PHP op uw server kan worden bereikt. Type het pad naar de locatie hier in. Dit stelt de \$ALLOW_CHANGE_GEDCOM variabele in, in het config.php bestand.";
$pgv_lang["GEDCOM"]			= "Gedcom pad:";
$pgv_lang["gedcom_path_help"]		= "Upload eerst uw gedcom bestand naar een lokatie op de server die door php bereikt kan worden. Voer dan het pad naar dat bestand en de bestandsnaam hier in. Dit zet de \$GEDCOM variabele in het config.php bestand<br /><br />Zie het <a href=\"readme.txt\">readme.txt</a> bestand voor meer uitleg.";
$pgv_lang["CHARACTER_SET"]		= "Karakterset codering:";
$pgv_lang["CHARACTER_SET_help"]		= "Dit is de karakterset van uw gedcom bestand. UTF-8 is de standaard en moet voor bijna alle sites werken. Als het gedcom bestand de ibm-windows codering gebruikt dan moet u hier WINDOWS neerzetten.<br />Dit zet de \$CHARACTER_SET variabele in het config.php bestand.<br /><br />NOTE: PHP ondersteunt geen UNICODE (UTF-16); zet dat er dus niet en om vervolgens te gaan klagen bij de PHP ondersteuners :-)";
$pgv_lang["LANGUAGE"]			= "Taal:";
$pgv_lang["LANGUAGE_help"]		= "Stelt de standaard taal in voor de website. Gebruikers hebben de mogelijkheid om deze instelling aan te passen via de browser instellingen of via het formulier aan de onderkant van de pagina indien ENABLE_MULTI_LANGUAGE = true.<br />Dit zet de \$LANGUAGE variabele in het config.php bestand.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Laat de gebruiker de taal wijzigen:";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "Zet dit op &quot;yes&quot; om de gebruikers de mogelijkheid te geven een andere taal te kiezen via de lijst aan de onderkant van het scherm. De standaard is de taal instelling van de browser.<br />Dit zet de \$ENABLE_MULTI_LANGUAGE variabele in het config.php bestand.";
$pgv_lang["CALENDAR_FORMAT"]		= "Formaat kalender:";
$pgv_lang["CALENDAR_FORMAT_help"]	= "Hiermee specificeert u het type kalender, dat u wilt gebruiken met dit GEDCOM bestand. Hebreeuws is hetzelfde als de Joodse kalender, maar dan met Hebreeuwse karakters. Let op: de Joods/Hebreeuwse datums worden berekend met behulp van Gregoriaanse/Juliaanse datums. Omdat de Joodse kalender bij zonsondergang start, wordt bij gebeurtenissen die plaatsvinden tussen zonsondergang en middernacht een datum weergegeven die een dag eerder ligt dan de juiste Joodse datum. Verder kan weergave van Hebreeuws een probleem zijn voor oude Internet Verkenners. Ze tonen het Hebreeuws achterstevoren of geheel niet.<br /><br />Dit stelt de \$CALENDAR_FORMAT variabele in, in het config.php bestand.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Geef Hebreeuwse duizendtallen weer:";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "Toon Alafim in Hebreewse kalenders. \"JA\" geeft het jaar 1969 weer als <span lang=\"he-IL\" dir=\'rtl\'>&#1492;\'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; , \"NEE\" als <span lang=\"he-IL\" dir=\'rtl\'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Dit beinvloedt de waarde van het Joodse jaar niet, deze blijft ongewijzigd 5729 ongeacht deze instelling.<br />Dit stelt de variabele \$DISPLAY_JEWISH_THOUSANDS in, in het config.php bestand.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Toon Hebreeuws Gershayim:";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "Toon dubbele en enkele aanhalingstekens bij het weergeven van Hebreeuwse datums. Deze waarde op JA toont de datum van 8 februari 1969 als <span lang=\'he-IL\' dir=\'rtl\'>&#1499;\'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; deze waarde op NEE toont het als <span lang=\'he-IL\' dir=\'rtl\'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Dit heeft geen invloed op het Joodse jaartal, omdat aanhalingstekens in Joodse datums worden weergegeven met de Latin karakterset.<br />Let op: Deze waarde is gelijk aan de PHP 5.0 kalender constanten CAL_JEWISH_ADD_ALAFIM_GERESH en CAL_JEWISH_ADD_GERESHAYIM. Deze waarde beinvloedt beide.<br />Dit stelt de \$DISPLAY_JEWISH_GERESHAYIM variabele in, in het config.php bestand.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Joods Ashkenaz woordgebruik:";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "Kies Joods Ashkenazi woordgebruik.<br /> Bij &quot;JA&quot; worden de maanden Cheshvan en Teves gespeld met Ashkenazi woordgebruik. Bij &quot;NEE&quot; blijven deze ongewijzigd.<br />Dit heeft alleen effect op de Joodse instelling. Indien ingesteld op Hebreeuws, wordt het Hebreeuwse alfabet gebruikt.<br />Dit stelt de \$JEWISH_ASHKENAZ_PRONUNCIATION variabele in, in het config.php bestand.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Generaties kwartierstaat:";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "Zet het aantal generaties dat standaard afgebeeld moet worden in de kwartierstaat.<br />Dit zet de \$DEFAULT_PEDIGREE_GENERATIONS variabele in het config.php bestand.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Max. aantal generaties kwartierstaat:";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "Stelt het maximum aantal generaties in, dat in de kwartierstaat wordt getoond.<br /><br />Dit stelt de \$MAX_PEDIGREE_GENERATIONS variabele in, in het config.php bestand.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Max. aantal generaties nakomelingen:";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "Stelt het maximum aantal generaties in, dat in de grafiek nakomelingen wordt getoond.<br /><br />Dit stelt de \$MAX_DESCENDANCY_GENERATIONS variabele in, in het config.php bestand.";
$pgv_lang["USE_RIN"]			= "Gebruik RIN in plaats van GEDCOM-ID:";
$pgv_lang["USE_RIN_help"]		= "Kies &quot;JA&quot; om RIN-nrs. te gebruiken in plaats van GEDCOM-ID&quot;s. Deze worden gebruikt in configuratiebestanden, gebruikersinstellingen en overzichten. Dit is nuttig voor genealogieprogramma's, die geen bijbehorende ID&quot;s exporteren maar altijd dezelfde RIN gebruiken.<br /><br />Dit stelt de \$USE_RIN variabele in, in het config.php bestand.";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "Beginpersoon voor kwartierstaat en nakomeling grafieken:";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "Zet het ID van de beginpersoon voor kwartierstaat en nakomeling grafieken.<br />Dit zet de \$PEDIGREE_ROOT_ID variabele in het config.php bestand.";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "GEDCOM ID voorvoegsel:";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "Bij weergave van de kwartierstaat, nakomelingen, verwantschap en andere weergaves wordt gebruikers gevraagd een ID in te voeren. Als hierbij geen voorvoegsel wordt ingevoerd, wordt deze toegevoegd.<br /><br /> Dit stelt de \$GEDCOM_ID_PREFIX variabele in, in het config.php bestand.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]	= "Laat geboorte- en overlijdensgegevens zien op voorouder kaart:";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] = "Geeft aan of de geboorte- en overlijdensgegevens van een persoon zichtbaar worden.<br />Dit zet de \$PEDIGREE_FULL_DETAILS variabele in het config.php bestand.";
$pgv_lang["PEDIGREE_LAYOUT"] 		= "Standaard opmaak kwartierstaat:";
$pgv_lang["PEDIGREE_LAYOUT_help"] 	= "Geeft aan of de kwartierstaat staand of liggend moet worden gegenereerd. <br /><br />Dit stelt de \$PEDIGREE_LAYOUT variabele in, in het config.php bestand.";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Toon lege vakken in de kwartierstaat:";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "Kies hier, of lege vakken worden getoond in de kwartierstaat grafiek.<br /><br />Dit stelt de \$SHOW_EMPTY_BOXES variabele in, in het config.php bestand.";
$pgv_lang["ZOOM_BOXES"]			= "Inzoomen op vakken in de weergave:";
$pgv_lang["ZOOM_BOXES_help"]		= "Geeft een gebruiker de mogelijkheid om in te zoomen op de vakken en zodoende meer informatie te tonen. \"Uitschakelen\"zet deze functie uit, \"Door muisaanwijzer erover\" activeert de functie wanneer het pijltje op het scherm op het icoon komt, \"Door muisknop ingedrukt\" activeert de zoomfunctie, zolang de knop blijft ingedrukt, \"Door muisklik\" wordt de functie afwisselend aan en uit geschakeld.<br /><br /> Dit stelt de \$ZOOM_BOXES variabele in, in het config.php bestand.";
$pgv_lang["LINK_ICONS"]			= "Popup met links in weergaves:";
$pgv_lang["LINK_ICONS_help"]		= "Geeft een gebruiker de mogelijkheid om door te springen naar andere weergaves en verwanten van de persoon. \"Uitschakelen\" zet deze functie uit, \"Door muisaanwijzer erover\" activeert de functie wanneer het pijltje op het scherm op het icoon komt, \"Door muisknop ingedrukt\" activeert de functie, zolang de knop blijft ingedrukt, \"Door muisklik\" wordt de functie afwisselend aan en uit geschakeld.<br /><br /> Dit stelt de \$LINK_ICONS variabele in, in het config.php bestand.";
$pgv_lang["AUTHENTICATION_MODULE"]	= "Autorisatiemodule:";
$pgv_lang["AUTHENTICATION_MODULE_help"] = "Bestand met de autorisatie functies. Door de implementatie van de functies in dit bestand kunnen gebruikers phpGedView aanpassen met een andere autorisatie methode en/of gebruikers in een andere database zetten. Hopenlijk zullen gebruikers hun aangepaste authorisatie module delen met andere phpGedView gebruikers.<br /><br />Dit zet de \$AUTHENTICATION_MODULE variabele in het config.php bestand.";
$pgv_lang["PRIVACY_MODULE"]		= "Privacybestand:";
$pgv_lang["PRIVACY_MODULE_help"]	= "Bestand waar de privacy funkties instaan. Zie <a href=\"http://gendorbendor.sourceforge.net\">http://gendorbendor.sourceforge.net</a> voor meer informatie en om een alternative privacy toevoeging op te halen.<br />Dit zet de \$PRIVACY_DEF_FILE variabele in het config.php bestand.";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Gebruik privacy-instellingen:";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "Met deze optie kunt u de privacy-module inschakelen en de details van levende personen verbergen.Levende personen hebben geen gebeurtenis die meer dan het aantal jaren, zoals gedefinieerd in de variabele \$MAX_ALIVE_AGE geleden gebeurd zijn en geen kinderen geboren zijn.<br />In de privacymodule kunt u de privacy-instellingen verder bewerken.<br />Dit stelt de \$HIDE_LIVE_PEOPLE variabele in, in het config.php bestand.";
$pgv_lang["REQUIRE_AUTHENTICATION"]	= "Vereis Bezoekersauthenticatie:";
$pgv_lang["REQUIRE_AUTHENTICATION_help"] = "Door deze optie in te schakelen worden alle bezoekers in te loggen, voordat ze gegevens op de site kunnen bekijken.<br /><br />Hiermee wordt de \$REQUIRE_AUTHENTICATION variabele in het config.php bestand gezet.";
$pgv_lang["CHECK_CHILD_DATES"]		= "Controleer datums van de kinderen:";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "Controleer de datums van de kinderen om te bepalen of een persoon overleden is. Op oudere systemen en grote gedcom bestand verlaagt dit de response tijd van uw website.<br />Dit zet de \$CHECK_CHILD_DATES variabele in het config.php bestand.";
$pgv_lang["MAX_ALIVE_AGE"]		= "Leeftijd waarboven iemand geacht wordt overleden te zijn:";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "De maximum leeftijd die een persoon kan hebben of de maximum leeftijd van hun kinderen om te bepalen waarneer iemand overleden is of niet.<br />Dit zet de \$MAX_ALIVE_AGE variabele in het config.php bestand.";
$pgv_lang["SHOW_GEDCOM_RECORD"]		= "Sta toe dat gebruikers de GEDCOM regels zien:";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "Door dit op 'yes' te zetten worden er links geplaats bij personen, gezinnen en bronnen die gebruikers een nieuw window geven met de gegevens uit het gedcom bestand.<br />Dit zet de \$SHOW_GEDCOM_RECORD variabele in het config.php bestand.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Sta wijzigen toe:";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "Stelt functionaliteit ter beschikking om in de toepassing gegevens te wijzigen. De desbetreffende gebruikers moeten hier dan nog expliciet voor worden geautoriseerd.<br /><br />Dit stelt de \$ALLOW_EDIT_GEDCOM variabele in, in het config.php bestand.";
$pgv_lang["INDEX_DIRECTORY"]		= "Map voor index bestanden:";
$pgv_lang["INDEX_DIRECTORY_help"]	= "Het pad naar een lees en schrijf map waar PhpGedView de index bestanden moet opslaan (inclusief de \"/\" aan het eind).<br />Dit zet de \$INDEX_DIRECTORY variabele in het config.php bestand.";
$pgv_lang["ALPHA_INDEX_LISTS"]		= "Splits lange lijsten volgens de eerste letter:";
$pgv_lang["ALPHA_INDEX_LISTS_help"]	= "Zet dit op 'true' voor erg lange persoon- en gezins lijsten. De lijst wordt dan gesplits in meerdere paginas volgens de eerste letter van de achternaam. <br />Dit zet de \$ALPHA_INDEX_LISTS variabele in het config.php bestand.";
$pgv_lang["NAME_FROM_GEDCOM"]		= "Haal weergegeven naam uit GEDCOM:";
$pgv_lang["NAME_FROM_GEDCOM_help"]	= "Standaard toont phpGedView van een persoon de naam, die in de indexbestanden is opgeslagen. Bij sommige GEDCOM formaten en talen, wordt de in de index opgeslagen naam niet correct weergegeven. Spaanse namen zijn hier een voorbeeld van. Deze kunnen het formaat aannemen van \"Voornaam Vader\'s achternaam Moeder\'s achternaam\". De (niet correcte) weergave uit de indexbestanden zou dan zijn: \"Voornaam Moeder\'s achternaam Vader\'s achternaam). Uit de GEDCOM wordt dan de correcte naam opgehaald. Let op: dit vertraagt de werking van het programma.<br /><br />Dit stelt de \$NAME_FROM_GEDCOM variabele in, in het config.php bestand.";
$pgv_lang["SHOW_ID_NUMBERS"]		= "Toon ID-nummers bij namen:";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "Toon ID-nummers tussen haakjes achter de persoonsnaam in de vakken.<br /><br />Dit stelt de \$SHOW_ID_NUMBERS variabele in, in het config.php bestand.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]	= "Toon plaatsen in persoonsvakken:";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "Stelt in, hoeveel niveaus van plaatsinformatie worden weergegeven bij geboorte- en overlijdensdata in de kwartierstaat- en nakomelingengrafieken. De waarde 9 laat alle niveaus zien, de waarde 0 geen enkele. De waarde 1 toont alleen het eerste niveau, 2 ook het tweede, etc. <br /><br />Dit stelt de \$SHOW_PEDIGREE_PLACES variabele in, in het config.php bestand.";
$pgv_lang["MULTI_MEDIA"]		= "Multimedia mogelijkheden aanzetten:";
$pgv_lang["MULTI_MEDIA_help"]		= "GEDCOM 5.5 bevat de mogelijkheid om plaatjes, videos en andere multimedia objecten op te nemen in het GEDCOM bestand. Als u geen multimedia objecten in uw gedcom bestand heeft dan kunt u deze variabele op 'no' zetten om de multimedia mogelijkheden uit te zetten.<br />Zie de multimedia paragraaf het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie over het opnemen van media in uw website.<br />Dit zet de \$MULTI_MEDIA variabele in het config.php bestand.";
$pgv_lang["MEDIA_DIRECTORY"]		= "Multimedia mappen:";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "Het pad naar een directory waar PhpGedView de lokale media gegevens ophaalt (met de laatste \"/\".<br />Dit zet de \$MEDIA_DIRECTORY variabele in het config.php bestand.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]	= "Aantal niveaus van de Multimedia mappen:";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "Een waarde van 0 zal alle mappen overslaan in het pad van het media object. Een waarde van 1 zal ook de eerste map van het object gebruiken. Door het verhogen van het getal wordt het aantal mappen verhoogt dat gebruikt wordt.<br />Bijvoorbeeld: als er een link naar het opject staat met het pad C:\\Documents and Settings\\User\\My Documents\\My Pictures\\Genealogy\\Surname Line\\grandpa.jpg dan zal een waarde van 0 vertaald worden in het pad ./media/grandpa.jpg. Een waarde van 1 zal vertaald worden naar ./media/Surname Line/grandpa.jpg, enz. De meeste mensen zullen met een 0 kunnen volstaan. Maar het is mogelijk dat sommige media objecten met dezelfde naam elkaar overschrijven. Dit maakt het mogelijk om enige struktuur aan te brengen in de media map en voorkomt het voorkomen van dubbele namen.<br />Dit zet de \$MEDIA_DIRECTORY_LEVELS variabele in het config.php bestand.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]	= "Laat het eerste plaatje in het persoonsvak zien:";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] = "Als de multimedia mogelijkheden op uw site zijn ingeschakeld, dan kunt u PhpGedView een miniatuur afbeelding, in overzichten en vakjes, laten tonen naast de naam van de persoon.  Op dit moment gebruikt PhpGedView het eerste multimedia object, genoemd de gedcom record, als de voorkeurs afbeelding.  Voor personen met meerdere afbeeldingen, zou u de multimedia objecten zodanig moeten indelen, dat de afbeelding die u wilt tonen, vooraan in de lijst staat.<br />Bekijk ook de multimedia sectie in het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie over het gebruik van media op uw site.<br />Dit zet de \$SHOW_HIGHLIGHT_IMAGES variabele in het config.php bestand.";
$pgv_lang["ENABLE_CLIPPINGS_CART"]	= "Plakboek aanzetten:";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] = "Het plakboek maakt het voor bezoekers mogelijk om mensen toe te voegen aan een gedcom knipbestand dat ze kunnen downloaden als een gedcom bestand en in hun genealogie software kunnen inlezen.<br />Dit zet de \$ENABLE_CLIPPINGS_CART variabele in het config.php bestand.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]		= "Verberg GEDCOM fouten:";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "Door dit op 'yes' te zetten worden fouten niet getoond als PhpGedView een gedcom tag tegekomt die het niet begrijpt. PhpGedView probeert uit alle macht om te voldoen aan de GEDCOM 5.5 standaard, maar veel genealogie programma's bevatten aangepaste tags. Zie het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie.<br />Dit zet de \$HIDE_GEDCOM_ERRORS variabele in het config.php bestand.";
$pgv_lang["WORD_WRAPPED_NOTES"]		= "Toevoegen van spaties indien opmerkingen worden afgebroken:";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "Sommige genealogie programma's breken opmerkingen af op woorden terwijl andere de opmerkingen op een willekeurige plek afbreken. Hierdoor is het mogelijk dat PhpGedView woorden aan elkaar plakt. Door dit op 'yes' te zetten wordt er een spatie tussen woorden gezet.<br />Dit zet de \$WORD_WRAPPED_NOTES variabele in het config.php bestand.";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "Door middel van deze optie kunt op op de pagina's vraagtekens weergeven naat de verschillende koppelingen en velden. Bezoekers kunnen hierop klikken en krijgen dan informatie over het desbetreffende item.<br /><br />Dit stelt de \$SHOW_CONTEXT_HELP variabele in, in het config.php bestand.";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Toon \"?\" help-koppelingen op de pagina's";
$pgv_lang["HOME_SITE_URL"]		= "Website URL";
$pgv_lang["HOME_SITE_URL_help"]		= "Het adres dat in de standaard thema bestanden zorgt voor een link naar uw website.<br />Dit zet de \$HOME_SITE_URL variabele in het config.php bestand.";
$pgv_lang["HOME_SITE_TEXT"]		= "Website tekst";
$pgv_lang["HOME_SITE_TEXT_help"]	= "De tekst die gebruikt wordt voor de link naar uw website.<br />Dit zet de \$HOME_SITE_TEXT variabele in het config.php bestand.";
$pgv_lang["CONTACT_EMAIL"]		= "Email genealogie gegevens:";
$pgv_lang["CONTACT_EMAIL_help"]		= "Het email adres dat gebruikt moet worden als er vragen zijn over de genealogische gegevens op deze website.<br />Dit zet de \$CONTACT_EMAIL variabele in het config.php bestand.";
$pgv_lang["CONTACT_METHOD"] 		= "Contactmethode:";
$pgv_lang["CONTACT_METHOD_help"] 	= "De methode die bezoekers zullen gebruiken om contact op te nemen met de \"Contact User\" over genealogische vragen.  De 'mailto' optie zal een 'mailto link' toevoegen, waarop de bezoekers kunnen klikken om u een email te sturen, d.m.v. hun eigen mail programma.  De 'berichten' optie zal het ingebouwde PhpGedView berichten system gebruiken en er worden geen emails verzonden.  De 'berichten met emails' optie is de standaard optie en zal het PhpGedView berichten systeem gebruiken, maar zal eveneens een kopie van de berichten per email verzenden.  Als u de optie voor 'geen berichten' kiest, zal er geen mogelijkheid zijn voor de bezoekers om contact met u op te nemen.<br /><br />Dit zet de \$CONTACT_METHOD variabele in het config.php bestand.";
$pgv_lang["WEBMASTER_EMAIL"]		= "E-mail Site Beheerder:";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "Het email adres dat gebruikt moet worden als er vragen zijn over de techniek of als er fouten worden gevonden op de website.<br />Dit zet de \$WEBMASTER_EMAIL variabele in het config.php bestand.";
$pgv_lang["SUPPORT_METHOD"] 		= "Ondersteuningsmethode:";
$pgv_lang["SUPPORT_METHOD_help"] 	= "De methode die bezoekers zullen gebruiken om contact op te nemen met de \"Support User\" over genealogische vragen.  De 'mailto' optie zal een 'mailto link' toevoegen, waarop de bezoekers kunnen klikken om u een email te sturen, d.m.v. hun eigen mail programma.  De 'berichten' optie zal het ingebouwde PhpGedView berichten system gebruiken en er worden geen emails verzonden.  De 'berichten met emails' optie is de standaard optie en zal het PhpGedView berichten systeem gebruiken, maar zal eveneens een kopie van de berichten per email verzenden.  Als u de optie voor 'geen berichten' kiest, zal er geen mogelijkheid zijn voor de bezoekers om contact met u op te nemen.<br /><br />Dit zet de \$SUPPORT_METHOD variabele in het config.php bestand.";
$pgv_lang["FAVICON"]			= "Favorieten ikoon:";
$pgv_lang["FAVICON_help"]		= "Wijzig dit in het ikoon dat getoont moet worden in de favorieten als mensen de website markeren.<br />Dit zet de \$FAVICON variabele in het config.php bestand.";
$pgv_lang["THEME_DIR"]			= "Themamap:";
$pgv_lang["THEME_DIR_help"]		= "De map waar de PhpGedView thema bestanden staan. U kunt elk standaard thema aanpassen die met PhpGedView worden meegeleverd om uw website op een unieke manier te tonen. Zie de thema aanpassing paragraaf in het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie.<br />Dit zet de \$THEME_DIR variabele in het config.php bestand.";
$pgv_lang["TIME_LIMIT"]			= "PHP tijdslimiet:";
$pgv_lang["TIME_LIMIT_help"]		= "De maximale tijd in seconden dat PhpGedView mag draaien. De standaard tijd is één minuut. Afhankelijk van het formaat van het gedcom bestand is het mogelijk dat deze waarde verhoogt moet worden tijdens het opbouwen van de indexen. Met de waarde 0 mag PHP altijd blijven draaien.<br />OPGELET: door deze waarde op 0 te zetten of een andere hoge waarde is het mogelijk dat de website blijft hangen op bepaalde bewerkingen zolang het script draait. Door de waarde op 0 te zetten is het mogelijk dat het script nooit gestopt wordt behalve als het door de server beheerder wordt gestopt of de machine herstart. Een grote genealogie tabel kan zeer lang draaien; door deze waarde zo laag mogelijk te houden wordt voorkomen dat iemand de webserver niet kan laten stoppen door een 1000 generatie lijst op te vragen.";
$pgv_lang["PGV_SESSION_SAVE_PATH"]	= "Map voor sessiebestanden:";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"] = "De map, waarin de PHPGedView sessiebestanden worden opgeslagen. Op sommige computers is PHP niet goed ingesteld en worden sessiegegevens niet bewaard tijdens schermwisselingen. Door deze instelling is het mogelijk om zelf te bepalen in welke map deze bestanden worden opgeslagen. De ./INDEX/ map is een goede keuze als aanpassing nodig is. Als deze waarde leeg wordt gelaten, wordt de map gebruikt die in het php.ini bestand is aangegeven.<br /><br /> Dit stelt de \$PGV_SESSION_SAVE_PATH variabele in, in het config/php bestand.";
$pgv_lang["SERVER_URL"] 		= "Sessie URL:";
$pgv_lang["SERVER_URL_help"] 		= "Type hier de URL van uw server, als u https of een andere dan de standaardpoort gebruikt.<br /><br />Dit stelt de \$SERVER_URL variabele in, in het config.php bestand.";
$pgv_lang["PGV_SESSION_TIME"]		= "Sessie verlopen:";
$pgv_lang["PGV_SESSION_TIME_help"]	= "De tijd in seconden, dat een PHPGedView sessie actief blijft, voordat opnieuw aanmelden noodzakelijk is. Standaard is 30 minuten.<br /><br />Dit stelt de \$PGV_SESSION_TIME variabele in, in het config.php bestand.";
$pgv_lang["SHOW_STATS"]			= "Toon verwerkingsgegevens:";
$pgv_lang["SHOW_STATS_help"]		= "Toont verwerkingsgegevens en database bevragingen onderaan ieder scherm..<br /><br />Dit stelt de \$SHOW_STATS variabele in, in het config.php bestand.";
$pgv_lang["USE_REGISTRATION_MODULE"] 	= "Gebruikers toestaan om gebruikersnamen te registreren:";
$pgv_lang["USE_REGISTRATION_MODULE_help"] = "Geeft gebruikers de mogelijkheid zich op de site te registreren. Beheerders moeten de registratie goedkeuren opdat die actief wordt. <br /><br />Dit stelt de \$USE_REGISTRATION_MODULE variabele in, in het config.php bestand.";
$pgv_lang["ALLOW_USER_THEMES"] 		= "Gebruikers toestaan om hun eigen site-opmaak te kiezen:";
$pgv_lang["ALLOW_USER_THEMES_help"] 	= "Geeft gebruikers de mogelijkheid hun eigen opmaak-thema te kiezen.<br /><br />Dit stelt de \$ALLOW_USER_THEMES variabele in, in het config.php bestand.";
$pgv_lang["CREATE_GENDEX"] 		= "Gendexbestanden maken:";
$pgv_lang["CREATE_GENDEX_help"] 	= "Laat PHPGedview GENDEX bestanden aanmaken zodra een GEDCOM-bestand wordt ge&iuml;mporteerd. Deze worden opgeslagen in de index-map.<br /><br />Dit stelt de \$CREATE_GENDEX variabele in, in het config.php bestand.";
$pgv_lang["gedcom_title_help"] 		= "Voer een titel in, welke de inhoude van dit GEDCOM bestand beschrijft.";
$pgv_lang["LOGFILE_CREATE"] 		= "Archiveer Log Bestanden:";
$pgv_lang["LOGFILE_CREATE_help"] 	= "Geef aan hoe vaak het programma de log bestanden moet archiveren.<br /><br />Dit zet de \$LOGFILE_CREATE variabele in het config.php bestand.";

$pgv_lang["welcome"] 			= "Welkom bij uw nieuwe PhpGedView website. U ziet deze pagina omdat u PhpGedView met succes op uw webserver heeft ge&iuml;nstalleerd en kunt nu beginnen met het instellen volgens uw wensen.<br />";
$pgv_lang["welcome_help"]		= "Dit Help-venster zal u behulpzaam zijn bij het configuratie proces.  Omdat u diverse velden moet invullen, kan dit venster u van aanvullende informatie voorzien, over het veld waarin u bent. U knt dit venster sluiten, om het weer te openen klik op een van de \"?\" vraagtekens naast het label van het veld.";
$pgv_lang["review_readme"] 		= "U moet eerst het <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> bestand bekijken voordat u verder gaat met het instellen van PhpGedView.<br /><br />U kunt altijd terugkeren naar deze instellingen pagina door met de browser het configure.php bestand te openen.<br /><br />U kunt bij iedere onderdeel help krijgen door op de &quot;?&quot; te drukken.";
$pgv_lang["save_config"] 		= "Instellingen opslaan";
$pgv_lang["reset"] 			= "Reset";
$pgv_lang["download_here"]		= "Klik hier om het bestand te downloaden.";
$pgv_lang["download_gedconf"]		= "Download de GEDCOM configuratie.";
$pgv_lang["not_writable"]		= "Er is geconstateerd dat PHP geen schrijftoegang heeft tot uw configuratie bestand. Klik op de download-knop om het bestand elders te plaatsen. Later kan dit handmatig op de juiste locatie geplaatst worden.";
$pgv_lang["download_file"]		= "Download bestand.";
$pgv_lang["upload_to_index"]		= "Upload het bestand naar de index-map.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]		= "Wijzig privacy";
$pgv_lang["edit_privacy_title"]			= "Wijzig GEDCOM privacy instellingen - [#PRIVACY_MODULE#]";
$pgv_lang["PRIV_PUBLIC"]		= "Zichtbaar voor ALLE bezoekers";
$pgv_lang["PRIV_USER"]			= "Alleen zichtbaar voor geautoriseerde gebruikers";
$pgv_lang["PRIV_NONE"]			= "Alleen zichtbaar voor beheerders";
$pgv_lang["PRIV_HIDE"]				= "Verberg, zelfs voor beheerders";
$pgv_lang["save_changed_settings"]	= "Wijzigingen opslaan";
$pgv_lang["add_new_pp_setting"]		= "Nieuwe privacy instelling voor persoon toevoegen";
$pgv_lang["add_new_up_setting"]		= "Nieuwe privacy instelling voor gebruiker toevoegen";
$pgv_lang["add_new_gf_setting"]		= "Nieuwe algemene instelling voor gegevens toevoegen";
$pgv_lang["add_new_pf_setting"]		= "Nieuwe specifieke instelling voor gegevens toevoegen";
$pgv_lang["add_new_pf_setting_source"]		= "Voeg nieuwe instelling toe voor gegevens van een bron";
$pgv_lang["privacy_source"]			= "Bron";
$pgv_lang["privacy_indi"]			= "Persoon";
$pgv_lang["privacy_indi_source"]		= "Persoon / Bron";
$pgv_lang["privacy_source_id"]			= "Bron - ID";
$pgv_lang["privacy_indi_id"]			= "Persoons - ID";
$pgv_lang["add_new_pf_setting_indi"]		= "Voeg nieuw instelling toe voor gegevens van een persoon";

$pgv_lang["file_read_error"]		= "F O U T !!! Kon het Privacy-bestand niet lezen!";
$pgv_lang["general_settings"]		= "Algemene Privacy - instellingen";
$pgv_lang["person_privacy_settings"]		= "Privacy instellingen voor een persoon";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Wijzig bestaande privacy instellingen voor persoon";
$pgv_lang["user_privacy_settings"]		= "Privacy instellingen voor een gebruiker";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Wijzig bestaande privacy instellingen voor een gebruiker";
$pgv_lang["global_facts_settings"]		= "Algemene instellingen voor gegevens";
$pgv_lang["edit_exist_global_facts_settings"]	= "Wijzig bestaande algemene instellingen voor gegevens";
$pgv_lang["person_facts_settings"]		= "Specifieke instellingen voor gegevens";
$pgv_lang["edit_exist_person_facts_settings"]	= "Wijzig bestaande specifieke instellingen voor gegevens van een persoon";
$pgv_lang["accessible_by"]			= "Zichtbaar voor?";
$pgv_lang["hide"]				= "Verbergen";
$pgv_lang["show_question"]			= "Zichtbaar?";
$pgv_lang["user_name"]				= "Gebruikersnaam";
$pgv_lang["name_of_fact"]			= "Omschrijving Gegevens";
$pgv_lang["choice"]				= "Keuze";
$pgv_lang["fact_show"]				= "Gegeven zichtbaar";
$pgv_lang["fact_details"]			= "Details gegeven zichtbaar";
$pgv_lang["privacy_header"]			= "Wijzig interne privacy instellingen";
$pgv_lang["unable_to_find_privacy_indi"]	= "Kon geen persoon met dit id vinden";
$pgv_lang["save_and_import"]			= "Nadat u deze GEDCOM configuratie heeft opgeslagen, moet u opnieuw de GEDCOM importeren door op de knop <b>Importeer Gedcom</b> te klikken of te gaan naar <b>Beheren->Beheer Gedcoms->Importeren Gedcom bestand</b>";

$pgv_lang["SHOW_LIVING_NAMES"]			= "Namen levende personen zichtbaar";
$pgv_lang["SHOW_RESEARCH_LOG"]			= "Onderzoekslog-bestand zichtbaar";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Gebruik relatie privacy";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Max. lengte relatie-pad";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Controleer relaties door huwelijk";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Overleden personen zichtbaar";

$pgv_lang["help_info"]				= "U kunt hulp krijgen, voor elk onderwerp, door te klikken op het rode &quot;?&quot; naast het label van elk veld.";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "Namen levende personen zichtbaar<br /><br />Moeten de namen van nog levende personen zichtbaar zijn voor ALLE bezoekers.<br /><br />Dit zet de \$SHOW_LIVING_NAMES variabele in het gekozen privacy bestand.";
$pgv_lang["SHOW_RESEARCH_LOG_help"]		= "Onderzoek log-bestand zichtbaar<br /><br />Welke soort gebruiker mag het onderzoek log-bestand bekijken, indien het is ge&iuml;nstalleerd.<br /><br />Dit zet de \$SHOW_RESEARCH_LOG variabele in het gekozen privacy bestand.";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "Gebruik relatie privacy<br /><br />Een 'Nee' waarde betekent dat geautoriseerde gebruikers de details van alle levende personen kunnen zien.<br />Een 'Ja' waarde betekent dat gebruikers alleen de prive informatie kunnen zien van levende personen, aan wie ze verwant zijn.<br /><br />Dit zet de \$USE_RELATIONSHIP_PRIVACY variabele in het gekozen privacy bestand.";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "Max. lengte relatie-pad<br /><br />Achter neven of nichten.<br /><br />Dit zet de \$MAX_RELATION_PATH_LENGTH variabele in het gekozen privacy bestand.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "Controleer relaties door huwelijk<br /><br />Controleer de verwantschap door huwelijks relaties.<br /><br />Dit zet de \$CHECK_MARRIAGE_RELATIONS variabele in het gekozen privacy bestand.";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "Overleden personen zichtbaar<br /><br />Stel het privacy toegangs niveau in voor alle overleden personen";
$pgv_lang["person_privacy_help"]		= "De \"person_privacy\" instellingen geven beheerders de mogelijkheid om de standaard privacy instellingen voor een bepaalde persoon, in het gedcom-bestand, te niet te doen. Veronderstel bijv. dat er een kind is, dat jong overleed. Normaal gesproken, zouden de details zichtbaar zijn voor alle gebruikers, aangezien het kind is overleden. Maar de rest van de familie is nog steeds prive. U wilt niet de gegevens van het overlijden van het kind verwijderen, maar u wilt de details verbergen en prive maken. Veronderstel dat het kind het ID I100 had, dan zou u de volgende privacy instellingen moeten invoeren: <br /><br />ID: I100<br />Zichtbaar voor: \"Alleen zichtbaar voor geautoriseerde gebruikers\"<br /><br />Omgekeerd werkt dit eveneens. Als ik de details openbaar wil maken van iemand (ID 101), waarvan ik weet dat hij dood is, maar waarvan ik geen overlijdensdatum heb, kan ik het volgende toevoegen:<br /><br />ID: I101<br />Zichtbaar voor: \"Zichtbaar voor ALLE bezoekers\"<br /><br />Dit zet de \$person_privacy variabele in het gekozen privacy bestand.";
$pgv_lang["user_privacy_help"]			= "De \"user_privacy\" instellingen geven beheerders de mogelijkheid om de standaard privacy instellingen te niet te doen, voor personen in het gedcom bestand, gebaseerd op de gebruikersnaam van de gebruiker.<br /><br />Dus, als ik niet wil dat de gebruikersnaam \"John\" mijn details kan zien, en ik heb het ID 100 in het GEDCOM bestand, kan ik het als volgt instellen:<br /><br />Gebruiker naam: John<br />ID: I100<br />Zichtbaar?: \"Verbergen\"<br /><br />en mijn details zullen alleen verborgen zijn voor de Gebruikernaam \"John\".<br /><br />Om de details van I101 (welke normaal gesproken verborgen zijn, omdat I101 nog in leven is) zichtbaar te maken voor de gebruikernaam \"John\" stel het als volgt in:<br /><br />Gebruikernaam: John<br />ID: I101<br />Zichtbaar?: \"Toon\"<br /><br />Dit zet de \$user_privacy variabele in het gekozen privacy bestand.";
$pgv_lang["global_facts_help"]			= "Met de \"global_facts\" instellingen regelt u, op globaal niveau, welke gegevens van alle personen in het gedcom bestand verborgen moeten blijven.<br /><br />Het [\"Omschrijving gegevens\"] element bepaalt welk gegeven verborgen moet blijven. Het element [\"Keuze\"] kiest het gegeven, of de daaraan gerelateerde details. Het element [\"Zichtbaar voor\"] bepaalt bij welk toegangs niveau het gegeven zichtbaar is.<br /><br />Het \$global_facts array is bedoeld om bepaalde gegevens van alle personen te verbergen, zowel van levende als overleden personen, zoals opgeslagen per GEDCOM tag. Standaard is al de SSN (sofi-nummer) tag verborgen voor publieke bezoekers. Dit is om te voorkomen dat dit soort gegevens kan worden gestolen en dat misbruik wordt gemaakt van bijv. Sofi-nummers van overleden verwanten. Dit is waarschijnlijk het meest relevant voor de V.S. <br />Indien ik alle huwelijken voor publieke bezoekers zou willen verbergen, kon ik het volgende instellen:<br /><br />Omschrijving gegevens: (MARR) - Huwelijk<br />Keuze: \"Gegeven zichtbaar\"<br />Zichtbaar voor?: \"Alleen zichtbaar voor geautoriseerde gebruikers\"<br /><br />Omschrijving gegevens: (MARR) - Huwelijk<br />Keuze: \"Details gegevens zichtbaar\"<br />Zichtbaar voor?: \"Alleen zichtbaar voor geautoriseerde gebruikers\"<br /><br />Met deze instellingen zijn alle huwelijken (en gerelateerde details) verborgen, behalve voor de beheerder.<br /><br />Dit zet de \$global_facts variabele in het gekozen privacy bestand.";
$pgv_lang["person_facts_help"]			= "Met de \"person_facts\" instellingen regelt u, per bepaald persoon in de gedcom, welke gegevens en op welk niveau, verborgen zijn.<br /><br />Het eerste element is het ID van de persoon, het tweede element is het gegeven.<br />Het element [\"Keuze\"] kiest het gegeven, of de daaraan gerelateerde details. Het element [\"Zichtbaar voor\"] bepaalt bij welk toegangs niveau het gegeven zichtbaar is.<br /><br />Het \$person_facts array werkt op dezelfde wijze als de \$global_facts array, behalve dat u hier ook het GEDCOM ID van de persoon, waarvan u gegevens wilt verbergen, instelt. Dus kan ik bijvoorbeeld de gegevens van het huwelijk van een bepaald persoon verbergen.<br /><br />Dit zet de \$person_facts variabele in het gekozen privacy bestand.";
$pgv_lang["find_sourceid"]			= "Zoek bron-ID";

//-- language edit utility
$pgv_lang["edit_langdiff"]		= "Bewerk en configureer de taalbestanden";
$pgv_lang["edit_lang_utility"]		= "Bewerkingsprogramma taalbestand";
$pgv_lang["edit_lang_utility_help"]	= "U kunt dit programma gebruiken om een taalbestand te wijzigen aan de hand van het Engelstalige bestand.<br />Het programma geeft een lijst weer van het Engelse taalbestand en van het door u gekozen taalbestand.<br />U kunt een bericht in het gekozen taalbestand wijzigen door erop te klikken en de tekst vervolgens aan te passen. Daarna kunt u de wijzigingen opslaan.";
$pgv_lang["language_to_edit"]		= "Taal om te wijzigen";
$pgv_lang["file_to_edit"]		= "Taalbestandstype om te wijzigen";
$pgv_lang["lang_save"]			= "Opslaan";
$pgv_lang["contents"]			= "Inhoud";
$pgv_lang["listing"]			= "Lijst";
$pgv_lang["no_content"]			= "Geen inhoud";
$pgv_lang["editlang_help"]		= "Wijzig bericht in taalbestand";
$pgv_lang["cancel"]			= "Afbreken";
$pgv_lang["savelang_help"]		= "Sla aangepast bericht op";
$pgv_lang["original_message"]		= "Orgineel bericht";
$pgv_lang["message_to_edit"]		= "Te wijzigen bericht";
$pgv_lang["changed_message"]		= "Gewijzigde inhoud";
$pgv_lang["message_empty_warning"] 	= "WAARSCHUWING! De tekst van deze boodschap ontbreekt in [#LANGUAGE_FILE#]";
$pgv_lang["language_to_export"]		= "Kies taal voor export";
$pgv_lang["export_lang_utility"]	= "Hulpprogramma export taalbestand";
$pgv_lang["export"]			= "Export";
$pgv_lang["export_lang_utility_help"]	= "Kies een taal om de helpinformatie uit het gekozen configuration_help taalbestand te exporteren naar een documentatiebestand.";
$pgv_lang["export_ok"]			= "Helpinformatie is geexporteerd.";
$pgv_lang["compare_lang_utility"]	= "Hulpprogramma vergelijking taalbestanden";
$pgv_lang["compare_lang_utility_help"]	= "Deze module vergelijkt twee taalbestanden en maakt een lijst van verschillen.<br /><br />In het bestand [#languages/LANG_CHANGELOG.txt#] in de languages-map staan nog andere wijzigingen vermeld.";
$pgv_lang["new_language"]		= "Nieuwe taal";
$pgv_lang["old_language"]		= "Oude taal";
$pgv_lang["compare"]			= "Vergelijk";
$pgv_lang["comparing"]			= "Vergeleken taalbestanden";
$pgv_lang["additions"]			= "Toevoegingen";
$pgv_lang["no_additions"]		= "Geen toevoegingen";
$pgv_lang["subtractions"]		= "Verwijderingen";
$pgv_lang["no_subtractions"]		= "Geen verwijderingen";
$pgv_lang["config_lang_utility"]	= "Gebruikte Taal Configuratie";
$pgv_lang["config_lang_utility_help"]	= "Met behulp van deze module kunt u eenvoudig de ondersteunde talen in PhpGedView in- of uitschakelen.<br /><br />Tevens kunt u een aantal land- en taalspecifieke instellingen aanpassen.";
$pgv_lang["active"]			= "Actief";
$pgv_lang["active_help"]		= "Sta de gebruikers toe deze taal te kiezen, indien het is toegestaan om een andere taal te selecteren.";
$pgv_lang["edit_settings"]		= "Wijzig instellingen";
$pgv_lang["lang_edit"]			= "Wijzig";
$pgv_lang["lang_language"]		= "Taal";
$pgv_lang["export_filename"]		= "Naam van het bestand met de ge-exporteerde gegevens:";
$pgv_lang["lang_back"]			= "Terug naar het Hoofdmenu om taalbestanden te wijzigen en te configureren";
$pgv_lang["lang_back_admin"]		= "Terug naar menu Beheren";
$pgv_lang["lang_name_danish"]		= "Deens";
$pgv_lang["lang_name_german"]		= "Duits";
$pgv_lang["lang_name_english"]		= "Engels";
$pgv_lang["lang_name_spanish"]		= "Spaans";
$pgv_lang["lang_name_spanish-ar"]	= "Latijns-Amerikaans Spaans";
$pgv_lang["lang_name_portuguese-br"]	= "Braziliaans - Portugees";
$pgv_lang["lang_name_portuguese"]	= "Portugees";
$pgv_lang["lang_name_french"]		= "Frans";
$pgv_lang["lang_name_italian"]		= "Italiaans";
$pgv_lang["lang_name_dutch"]		= "Nederlands";
$pgv_lang["lang_name_norwegian"]	= "Noors";
$pgv_lang["lang_name_polish"]		= "Pools";
$pgv_lang["lang_name_swedish"]		= "Zweeds";
$pgv_lang["lang_name_turkish"]		= "Turks";
$pgv_lang["lang_name_chinese"]		= "Chinees";
$pgv_lang["lang_name_hebrew"]		= "Hebreeuws";
$pgv_lang["lang_name_russian"]		= "Russisch";
$pgv_lang["original_lang_name"]		= "Originele naam van de taal in het #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "Hiermee geeft u aan, hoe deze taal in die taal zelf wordt genoemd.";
$pgv_lang["lang_shortcut"]		= "Afkorting van de taal";
$pgv_lang["lang_shortcut_help"]		= "Met deze optie stelt u in, hoe de taal in twee letters wordt afgekort.";
$pgv_lang["lang_filename"]		= "Taalbestand";
$pgv_lang["lang_filename_help"]		= "Naam en pad van het bestand met de vertalingen voor het programma.";
$pgv_lang["config_filename"]		= "Configuratie- en Help-bestand:";
$pgv_lang["config_filename_help"]	= "Naam en pad van het bestand met de vertalingen van de Configuratie- en Help-bestanden .";
$pgv_lang["facts_filename"]		= "Feiten-bestand";
$pgv_lang["facts_filename_help"]	= "Naam en pad van het bestand met de vertalingen van de GEDCOM-feiten.";
$pgv_lang["help_filename"]		= "Help-bestand";
$pgv_lang["help_filename_help"]	= "Naam en pad van het bestand met de helptekst.";
$pgv_lang["flagsfile"]			= "Vlag-bestand:";
$pgv_lang["flagsfile_help"]		= "Naam en pad van het afbeeldingsbestand van de nationale vlag van de geselecteerde taal.";
$pgv_lang["text_direction"]		= "Richting van de tekst:";
$pgv_lang["text_direction_help"]	= "Hiermee stelt u in, op welke wijze teksten worden weergegeven.";
$pgv_lang["date_format"]		= "Datumformaat:";
$pgv_lang["date_format_help"]		= "Verschillende landen hebben verschillende manieren, om de datum te tonen. In het Nederlands is dit standaard \"Dag Maand Jaar\", terwijl in het Engels vaak \"Maand Dag Jaar\" wordt gehanteerd. Hiermee stelt u in, hoe PHPGedView de datum in het Nederlands toont.";
$pgv_lang["week_start"]			= "Week begint op:";
$pgv_lang["week_start_help"]		= "De dag van de week, waarop in deze taal een week begint. In de meeste landen start de week op zondag, maar sommigen starten op maandag of een andere dag.";
$pgv_lang["name_reverse"]		= "Achternaam eerst:";
$pgv_lang["name_reverse_help"]		= "In sommige talen wordt de achternaam eerst genoemd, voor de voornaam, in plaats van andersom, wat standaard is. Met deze optie stelt u in dat de achternaam eerst wordt weergegeven.";
$pgv_lang["ltr"]			= "v.l.n.r.:";
$pgv_lang["rtl"]			= "v.r.n.l.:";
$pgv_lang["file_does_not_exist"]	= "FOUT! Het bestand bestaat niet!...";
$pgv_lang["alphabet_upper"]		= "Alfabet hoofdletters";
$pgv_lang["alphabet_upper_help"]	= "Alfabet van hoofdletters in deze taal. Dit alfabet wordt gebruikt voor het sorteren van namen in hoofdletters in de namenlijsten van PHPGedView.";
$pgv_lang["alphabet_lower"]		= "Alfabet kleine letters";
$pgv_lang["alphabet_lower_help"]	= "Alfabet van kleine letters in deze taal. Dit alfabet wordt gebruikt voor het sorteren van namen in kleine letters in de namenlijsten van PHPGedView.";
$pgv_lang["lang_config_write_error"]	= "Fout bij het wegschrijven van de taalinstellingen in het bestand  [language_settings.php]. Controleer de schrijfrechten en probeer het opnieuw.";
$pgv_lang["translation_forum_help"]	= "Deze link opent een nieuw venster in uw Windows Verkenner, naar het vertalersforum van PHPGedView (http://sourceforge.net/forum/forum.php?forum_id=294245). Hier kunt u vragen stellen over vertalingen, problemen voorleggen en (als u wilt) u aanmelden voor het leveren van een bijdrage aan de vertalingen.";
$pgv_lang["lang_set_file_read_error"]	= "F O U T !!! Kan het bestand [language_settings.php] niet lezen!";
$pgv_lang["system_time"]		= "Huidige systeemtijd: ";
$pgv_lang["translation_forum"]		= "Koppeling naar het vertalersforum op de PHPGedView site van SourceForge";
$pgv_lang["lang_save_success"]		= "Wijzigingen in #PGV_LANG# succesvol weggeschreven";

// Help message upgrade utility
$pgv_lang["how_upgrade_help"]		= "<b>DE OPWAARDEERMODULE</b><br /><br />De opwaardeermodule zorgt voor het aanpassen van uw huidige versie van PHPGedView met de programma\'s uit de nieuwe versie die u heeft gedownload.<br /><br /><b>Nieuwe versie downloaden</b><br />Een nieuwe versie kan direct worden verkregen via http://sourceforge.net/projects/phpgedview/. Ook kunt het opwaardeerprogramma laten controleren of een nieuwe versie voorhanden is. Als dat het geval is, worden de beschikbare versies getoond. Dit zijn dan of zip- of gz-bestanden, of beide.<br /><br /><b>Wat wordt opgewaardeerd</b><br /><br />* PhpGedView<br />Dit waardeert alle basisprogramma\'s op van PHPGedview, exclusief config.php, privacy.php en authenticate.php. Dit past indien nodig eveneens de images-map aan.<br /><br />* Indexbestanden<br />Dit past de map /index aan. Let op: bestaande bestanden worden overschreven!<br /><br />* Talen<br />Dit past de /languages map aan.<br /><br />* Thema\'s<br />Dit past de /themes map aan. Let op: alle aanpassingen die u zelf aan de thema\'s heeft gemaakt, worden overschreven.<br /><br />* Configuratiebestand<br />Dit controleert uw huidige configuratiebestand en past het aan met wijzigingen die in het nieuwe configuratiebestand worden gevonden. Dit zorgt ervoor, dat u over de laatste versie van het configuratiebestand beschikt, maar uw eigen instellingen behoudt.<br /><br />* Privacybestand<br />Dit controleert uw huidige privacybestand(en) en past ze aan met wijzigingen die in het nieuwe privacybestand worden gevonden. Dit zorgt ervoor, dat u over de laatste versie van het privacybestand beschikt, maar uw eigen instellingen behoudt.<br /><br />* Handleidingen<br />Dit past de /doc map aan.<br /><br />* Research logboek<br />Dit past de research logboekmodule aan.<br /><br />* Backup maken<br />Dit maakt een backup van de oude bestanden in de /backup map.<br /><br /><b>Hoe opwaarderen</b><br /><br />1. Selecteer de onderdelen die u wilt opwaarderen.<br /><br />2. Klik op Opslaan<br /><br />De voortgang wordt op het scherm weergegeven.";


?>