<?php
/*=================================================
   charset=utf-8
   Project:	phpGedView
   File:	configure_help.sv.php
   Author:	John Finlay
   Translation:	Daniel Melander
   Continued
   translation:	Patrik Hansson
   Comments:	Swedish Language Configure Help file for PHPGedView.
   		Svensk språkfil för konfigurationshjälp till PHPGedView.
   Change Log:	2003-07-27 - File Created
                2003-10-30 - Updated to v2.52
		2003-12-05 - Updated to v2.61
		2004-01-13 - Updated to v2.65
===================================================*/
# $Id: configure_help.sv.php,v 1.19.2.6 2004/02/02 15:18:12 yalnifj Exp $
if (preg_match("/configure_help\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}
//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"]                          = "Konfigurera PHPGedView";
$pgv_lang["default_user"]                       = "Skapa standard administratör.";
$pgv_lang["about_user"]                         = "Du måste först skapa en administratörsanvändare.  Denna användare kommer att ha rättigheter att uppdatera konfigurationsfilerna, Inspektera privata data, och skapa nya användare.";
$pgv_lang["fullname"]                           = "Fullständigt namn:";
$pgv_lang["confirm"]                            = "Bekräfta lösenord:";
$pgv_lang["can_admin"]                          = "Användare får administrera:";
$pgv_lang["can_edit"]                           = "Användare kan ändra data:";
$pgv_lang["add_user"]                           = "Lägg till ny användare";
$pgv_lang["current_users"]                      = "Nuvarande användarlista";
$pgv_lang["leave_blank"]			= "Lämna lösenordfältet tomt om du vill behålla det aktuella lösenordet.";
$pgv_lang["other_theme"]                        = "Egen sökväg";
$pgv_lang["performing_update"]                  = "Updatering pågår.";
$pgv_lang["config_file_read"]                   = "Läst konfigurationsfil.";
$pgv_lang["does_not_exist"]                     = "finns ej";
$pgv_lang["config_write_error"]                 = "Fel vid skrivning till konfigurationsfil.  Kontrollera filrättigheter och försök igen.";
$pgv_lang["db_setup_bad"]                       = "Din nuvarande databaskonfiguration är felaktig.  Kontrollera databasanslutningens inställningar och försök igen.";
$pgv_lang["click_here_to_continue"]             = "Klicka är för att fortsätta.";
$pgv_lang["config_hebrew"]			= "Hebreisk";
$pgv_lang["PGV_DATABASE"]			= "PhpGedView datakälla";
$pgv_lang["PGV_DATABASE_help"]			= "Detta talar om för phpGedView vilken typ av datakälla du önskar använda för de GEDCOM filer du importerar i systemet. Välj \'Index filer\' för att använda index sparad i filer i index katalogen. Alternativt väljer du \'MySQL\' för att använda en MySQL databas. Detta ställer in variabeln \$PGV_DATABASE i config.php filen.";
$pgv_lang["hebrew_and_gregorian"]		= "Hebreisk och Gregoriansk";
$pgv_lang["disabled"]				= "Avaktiverad";
$pgv_lang["click"]				= "Vid musklick";
$pgv_lang["mailto"]				= "Meddelandelänk";
$pgv_lang["messaging"]				= "PhpGedView Interna meddelande";
$pgv_lang["messaging2"]				= "Interna meddelande med email";
$pgv_lang["no_messaging"]			= "Ingen kontakt metod";
$pgv_lang["no_logs"]				= "Stäng av loggning";
$pgv_lang["daily"]				= "Daglig";
$pgv_lang["weekly"]				= "Veckovis";
$pgv_lang["monthly"]				= "Månatlig";
$pgv_lang["yearly"]				= "Årlig";
$pgv_lang["mousedown"]				= "Vid mus nedtryckt";
$pgv_lang["mouseover"]				= "Vid mus över";
$pgv_lang["mouseover"]				= "On Mouse Over";
$pgv_lang["jewish_and_gregorian"]		= "Judisk och Gregoriansk";
$pgv_lang["julian"]				= "Juliansk";
$pgv_lang["config_french"]			= "Fransk";
$pgv_lang["jewish"]				= "Judisk";
$pgv_lang["gregorian"]				= "Gregoriansk";
$pgv_lang["show_phpinfo"]			= "Visa PHPInfo sida";
$pgv_lang["confirm_gedcom_delete"]		= "Är du säker på att du vill radera denna GEDCOM fil";
$pgv_lang["ged_download"]			= "Ladda ner";
$pgv_lang["ged_gedcom"]				= "Gedcomfil";
$pgv_lang["ged_config"]				= "Konfigurationsfil";
$pgv_lang["ged_title"]				= "Gedcom titel";
$pgv_lang["config_help"]                        = "Konfigurationshjälp";
$pgv_lang["index"]				= "Index filer";
$pgv_lang["current_gedcoms"]			= "Aktuell GEDCOM";
$pgv_lang["admin_gedcoms"]			= "Administrerar GEDCOM filer";
$pgv_lang["mysql"]				= "MySQL";
$pgv_lang["DBHOST"]                             = "MySQL Databasvärd:";
$pgv_lang["DBHOST_help"]                        = "DNS eller IP adress till datorn med MySQL databasservern.  Detta ställer in \$DBHOST variabeln i config.php filen.";
$pgv_lang["DBUSER"]                             = "MySQL databasens användarnamn:";
$pgv_lang["DBUSER_help"]                        = "MySQL databasens användarnamn som krävs för att logga in på databasen.  Detta ställer in \$DBUSER variabeln i config.php filen.";
$pgv_lang["DBPASS"]                             = "MySQL databasens lösenord:";
$pgv_lang["DBPASS_help"]                        = "MySQL databasens lösenord för den användare du angivit i användarnamnfältet.  This sets the \$DBPASS variable in the config.php file.";
$pgv_lang["DBNAME"]                             = "Databasnamn:";
$pgv_lang["DBNAME_help"]                        = "Databasen i MySQL-servern du angivit att phpGedView skall använda.  Användarnamnet du anger i användarfältet måste a create, insert, update, delete, och select rättigheter på denna databas.  Detta ställer in \$DBNAME variabeln i config.php filen.";
$pgv_lang["TBLPREFIX"]                          = "Databasens tabellprefix:";
$pgv_lang["TBLPREFIX_help"]                     = "Ett prefix som läggs till de MySQL-tabeller skapade av phpGedView.  genom att ändra detta värde can du ställa in flera phpGedView siter som använder samma database men olika tabeller.  Detta ställer in \$TBLPREFIX variabeln i config.php filen.";
$pgv_lang["DEFAULT_GEDCOM"]                     = "Standard GEDCOM:";
$pgv_lang["DEFAULT_GEDCOM_help"]                = "MySQL versionen av phpGedView tillåter att du kan arbeta med flera olika gedcomfiler i samma instans av phpGedView.  Använd denna variabel för att ställa in standard GEDCOM-fil för alla användare när de först kommer till din site.  Ett blankt värde kommer välja den första gedcomfil som var importerad.  Om du tillåter användare att ändra GEDCOM-fil, kommer det finnas en länk på varje sida för att förenkla byte mellan de olika GEDCOM filer de använder.  Detta ställer in \$DEFAULT_GEDCOM variabeln i config.php filen.";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]                = "Tillåt besökare att ändra GEDCOM:";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]           = "Genom att sätta detta värde till \"yes\" tillåter du besökare till din sida att byta mellan olika gedcomfiler om du har fler än en gedcom konfigurerad.  Detta ställer in \$ALLOW_CHANGE_GEDCOM variabeln i config.php filen.";
$pgv_lang["GEDCOM"]                             = "Sökväg till GEDCOM:";
$pgv_lang["gedcom_path_help"]                   = "Ladda först upp den gedcom-fil till en plats nåbar via php på din server.  Ange sedan sökvägen till gedcom-filen här.  Detta ställer in \$GEDCOM variabeln i config.php filen.<br /><br />See the <a href=\"readme.txt\">Readme.txt</a> file for more help.";
$pgv_lang["CHARACTER_SET"]                      = "Teckentabell:";
$pgv_lang["CHARACTER_SET_help"]                 = "Detta anger kodningen för den teckentabell din gedcom-fil använder.  UTF-8 är standard och borde fungera för nästan alla sidor.  Om du exporterade din gedcom-fil med IBM Windows kodning, bör du ange WINDOWS här.<br />Detta ställer in \$CHARACTER_SET variabeln i config.php filen.<br /><br />OBS: PHP stödjer INTE UNICODE (UTF-16) så testa det inte, klaga istället på skaparna av PHP :-)";
$pgv_lang["LANGUAGE"]                           = "Språk:";
$pgv_lang["LANGUAGE_help"]                      = "Ange standardspråk för din site.  Användare kan om de vill byta språk genom att ändra i deras browserinställningar eller via droplistan längst ner på varje sida om variabeln ENABLE_MULTI_LANGUAGE = true.<br />Detta ställer in \$LANGUAGE variabeln i config.php filen.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]              = "Tillåt användare att byta språk:";
$pgv_lang["CALENDAR_FORMAT"]			= "Kalenderformat";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Judisk Ashkenaz uttal";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "Använd judiskt Ashkenaziutal.<br />Om satt till ja kommer månaderna Cheshvan and Teves att stavas med Ashkenaziutal. Satt till nej kommer månaderna stavas som Hesvan and Tevet. <br />Detta ställer bara in de judiska inställningarna. Den hebreiska inställningen använder det hebreiska alfabetet.<br />Detta ställer in \$JEWISH_ASHKENAZ_PRONUNCIATION variabeln i config.php filen.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Visa hebreisk Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "Visa dubbel och enkelcitationstecken när Hebreiska datum visas. Sätts denna inställning till Ja kommmer datumet February 8th 1969 att visas som <span lang=\'he-IL\' dir=\'rtl\'>&#1499;\'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; medans ett Nej gör så att det visas som <span lang=\'he-IL\' dir=\'rtl\'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Denna inställning har ingen inverkan på den judiska årsinställningen eftersom citationstecken inte används för att visa judiska datum med det latinska alfabetet.<br />OBS: Denna inställing är liknar kalenderkonstanterna CAL_JEWISH_ADD_ALAFIM_GERESH och CAL_JEWISH_ADD_GERESHAYIM i php 5.0. Denna inställning påverka båda två.<br />Detta ställer in \$DISPLAY_JEWISH_GERESHAYIM variabeln i config.php filen.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]		= "Visa hebreiska tusental.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "Visa Alafim i Hebreiska kalendrar. Sätts detta val i Ja kommer år 1969 visas som <span lang=\"he-IL\" dir=\'rtl\'>&#1492;\'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; medans nej leder till att året visas som <span lang=\"he-IL\" dir=\'rtl\'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Denna inställningen har ingen inverkan på den judiska årsinställningen. Året kommer visas som 5729 oavsätt hur denna inställning sätts.<br />OBS: Denna inställning är lik kalenderkonstanten CAL_JEWISH_ADD_ALAFIM i php 5.0.<br />Denna inställning ställer in \$DISPLAY_JEWISH_THOUSANDS variabeln i config.php filen.";
$pgv_lang["CALENDAR_FORMAT_help"]		= "Låter dig välja kalender typ som används med denna gedcomfil. Hebreisk är samma som den Judiska fast med hebreiska tecken. Observera: Värdena för den Judiska/Hebreiska datumen räknas ut ifrån de Gregorianska/Julianska datumen. Eftersom den Judiska kalendern startar vid skymningen kommer alla händelser som utspelar sig från skymning till midnatt att visas en dag tidigare än det korrekta judiska datumet. Hebreiska kan vara problematiskt i äldre webläsare. Vissa gamla webläsare visar Hebreiska baklänges eller inte alls.<br /><br />Detta sätter variabeln \$CALENDAR_FORMAT i config.php filen.";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]         = "Sätt till 'yes' om du vill tillåta användare byta språk via en droplista på botten av varje sida eller det standardspråk användare ställt in i sin webläsare.<br />Detta ställer in \$ENABLE_MULTI_LANGUAGE variabeln i config.php filen.";

$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "Ange maximalt antal generationer som skall visas i stamträd.<br /><br />Detta ställer in \$MAX_PEDIGREE_GENERATIONS variabeln i config.php filen.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]       = "Antal generationer i släktträd som standard:";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]  = "Ställer in det antal generationer som kommer att visas i släktträden som standard<br />Detta ställer in \$DEFAULT_PEDIGREE_GENERATIONS variabeln i config.php filen.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Max antal generationer i släktträd:";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Max antal generationer i anträd:";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "Ange maximalt antal generationer som skall visas i trädet över ättlingar.<br /><br />Detta ställer in  \$MAX_DESCENDANCY_GENERATIONS variabeln i config.php filen.";
$pgv_lang["USE_RIN_help"]			= "Sätt till JA om du använder RIN-nummer instället för GEDCOM ID när ID för personer efterfrågas i configurationsfiler, användarinställningar och diagram. Detta är användbart för genealogiprogram som inte exporterar GEDCOM-filer med olika RIN för varje person ID.<br /><br />Detta ställer in \$USE_RIN variabeln i config.php filen.";
$pgv_lang["USE_RIN"]				= "Använd RIN# instället för GEDCOM ID:";
$pgv_lang["PEDIGREE_ROOT_ID"]                   = "Standardperson för utgångspunkt i släktträden:";
$pgv_lang["PEDIGREE_ROOT_ID_help"]              = "Anger ID för den person som skall vara utgångspunkt för alla släktträd som standard<br />Detta ställer in \$PEDIGREE_ROOT_ID variabeln i config.php filen.";
$pgv_lang["GEDCOM_ID_PREFIX_help"]		= "På släkträd och andra diagram där användare efterfrågas att mata in ett ID kommer detta prefix användas om inget annat anges.<br /><br />Detta ställer in \$GEDCOM_ID_PREFIX variabeln i config.php filen.<br />";
$pgv_lang["GEDCOM_ID_PREFIX"]			= "GEDCOM ID Prefix:";
$pgv_lang["PEDIGREE_FULL_DETAILS"]              = "Visa automatiskt detaljer om födelse och död i släktträden:";
$pgv_lang["LINK_ICONS_help"]			= "Tillåter användaren att välja länkar till andra diagram och nära släktingar till personen. Sätt till \"Avaktiverad\" för att avaktivera denna funktion. Sätt till \"MouseOver\" för att popup-länkarna skall visas när musmarkören befinner sig ovanför rutans ikon. Sätt till \"Klick\" för att popup-länkarna skall visas när användaren klickar på rutans ikon.<br /><br />Detta ställer in \$LINK_ICONS variabeln i config.php filen.";
$pgv_lang["LINK_ICONS"]				= "PopUp-länkar på diagram:";
$pgv_lang["ZOOM_BOXES_help"]			= "Tillåter en användare att zooma på diagram för att få mer information. Sätt till \"Avaktiverad\" för att avaktivera denna funktion. Sätt till \"MouseOver\" för att zooma rutor när musmarkören befinner sig ovanför rutans ikon. Sätt till \"Klicka\" för att zooma när användaren klickar på rutans inkon.<br /><br />Detta ställer in \$ZOOM_BOXES variabeln i config.php filen.";
$pgv_lang["ZOOM_BOXES"]				= "Zooma rutor i diagram:";
$pgv_lang["SHOW_EMPTY_BOXES_help"]		= "Anger om tomma rutor skall visas i släktträd.<br /><br />Detta ställer in \$SHOW_EMPTY_BOXES variabeln i config.php filen.";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"]         = "Anger om detaljer om födelse och död skall visas eller ej för en person i stamträd som standard<br />Detta ställer in \$PEDIGREE_FULL_DETAILS variabeln i config.php filen.";
$pgv_lang["PEDIGREE_LAYOUT"]			= "Standard anträds layout:";
$pgv_lang["PEDIGREE_LAYOUT_help"]		= "Denna inställning talar om om anträdet ska skapas i stående eller liggande format.<br /><br />Detta sätter \$PEDIGREE_LAYOUT variabeln i config.php filen.";
$pgv_lang["SHOW_EMPTY_BOXES"]			= "Visa tomma rutor i stamträd.";
$pgv_lang["AUTHENTICATION_MODULE"]              = "Autentiseringsfil:";
$pgv_lang["AUTHENTICATION_MODULE_help"]         = "Fil från vilken alla verifieringsfunktioner hämtas.  Genom att implementera egna versioner av funktionerna i denna fil kan du få phpGedView att använda en annan metod för att verifiera användare samt hur och var användarinformation skall sparas och hämtas.  Förhoppningsvis kommer användare att vilja dela med sig av sina egna specialiserad autentiseringsmoduler med andra phpGedView-användare.<br /><br />Detta ställer in \$AUTHENTICATION_MODULE variabeln i config.php filen.";
$pgv_lang["HIDE_LIVE_PEOPLE"]                   = "Göm levande personer:";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]              = "Detta val talar om ifall PhpGedView skall dölja ev. integritetskränkande detaljer för personer som fortfarande lever.  Levande personer är definierade som en person som inte har några händelser yngre än $MAX_ALIVE_AGE år sedan, samt inte har några barn yngre än $MAX_ALIVE_AGE år.<br />Detta val ställer in \$HIDE_LIVE_PEOPLE variabeln i config.php filen.";
$pgv_lang["REQUIRE_AUTHENTICATION"]		= "Kräver besökarens verifiering";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "Sätta på denna optionen tvingar all besökare att logga in innan de se någon data på denna sajten.<br /><br />Detta sätter variabeln \$REQUIRE_AUTENTICATION i filen config.php";
$pgv_lang["CHECK_CHILD_DATES"]                  = "Kontrollera datum hos barn:";
$pgv_lang["CHECK_CHILD_DATES_help"]             = "Kontrollerar datumen för händelser hos barn för att kunna kontrollera om personen kan tänkas vara i livet eller ej.  På äldre system och stora GEDCOM-filer kan denna kontroll leda till en dålig och långsammare responstid för din site.<br />Detta val ställer in \$CHECK_CHILD_DATES variabeln i config.php filen.";
$pgv_lang["MAX_ALIVE_AGE"]                      = "Åldersgräns då person antas vara död:";
$pgv_lang["MAX_ALIVE_AGE_help"]                 = "Åldersgräns varefter en person automatiskt anses vara död.<br />Detta val ställer in \$MAX_ALIVE_AGE variabeln i config.php filen.";
$pgv_lang["SHOW_GEDCOM_RECORD"]                 = "Tillåt användare att se rådata i GEDCOM-poster:";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]            = "Genom att sätta detta val till yes kommer en länk placeras på alla sidor för personer, källor och familjer som tillåter användaren att läsa rådata från gedcomfilen om personen eller källan i fråga i ett separat fönster.<br />Detta val ställer in \$SHOW_GEDCOM_RECORD variabeln i config.php filen.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]			= "Tillåt online redigering:";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]		= "Tillåter online redigerings möjligheten för denna gedcomfil. Det innebär att användare med redigerings privilegium kan uppdatera denna gedcomfil online.<br /><br />Detta slår på variabeln \$ALLOW_EDIT_GEDCOM i config.php filen.";
$pgv_lang["INDEX_DIRECTORY"]                    = "Katalog för indexfiler:";
$pgv_lang["INDEX_DIRECTORY_help"]               = "Sökvägen till den katalog med läs och skrivrättigheter som PhpGedView skall använda för att lagra indexfiler (inkludera avslutande \"/\")<br />Detta ställer in \$INDEX_DIRECTORY variabeln i config.php filen.";
$pgv_lang["ALPHA_INDEX_LISTS"]                  = "Dela upp långa listor baserat på första bokstaven i namnet:";
$pgv_lang["ALPHA_INDEX_LISTS_help"]             = "Om du har väldigt långa listor med individer and familjer, sätt detta värde till \"true\" för att dela upp listorna i flera sidor baserade på första bokstaven i efternamnet.<br />This sets the \$ALPHA_INDEX_LISTS variable in the config.php file.";
$pgv_lang["NAME_FROM_GEDCOM"]			= "Hämta titelnamn ifrån GEDCOM filen:";
$pgv_lang["NAME_FROM_GEDCOM_help"]		= "Som standard använder phpGedView namnet som finns lagrat i indexen för att få tag på en persons namn. Med vissa gedcomformat och språk visas inte sorterade namn på ett korrekt sätt och det bästa sättet är då att hämta det korrekta namnet direkt från gedcom filen istället. Spanska namn är ett utmärkt exempel på detta. Ett spanskt namn kan ha formen Förnamn Faderns Efternamn Moderns Efternamn. Används indexen för att sortera och visa detta namn skulle det felaktigt visas som Förnamn Moderns Efternamn Faderns Efternamn. Används istället namnet lagrat i gedcomfilen visas däremot namnen korrekt. En nackdel med denna metod är dock att programmets prestanda försämras.<br /><br />Detta ställer in \$NAME_FROM_GEDCOM variabeln i config.php filen.";
$pgv_lang["SHOW_ID_NUMBERS_help"]		= "Visa ID nummer i en parantes efter personnamnet på stamträden.<br /><br />Detta sätter på variabeln \$SHOW_ID_NUMBERS i config.php filen.";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]		= "Denna sätter nivån av platsinformation som visas i en personruta på släktträd. Värdet 9 motsvarar all platsinformation medans 0 kommer att dölja all platsinformation. Värdet 1 visar första nivån av platsinformationen, Värdet 2 visar dom första 2 nivåerna, osv.<br /><br />Detta sätter variabeln \$SHOW_PEDIGREE_PLACES i config.php filen.";
$pgv_lang["SHOW_PEDIGREE_PLACES"]		= "Plats detaljnivå";
$pgv_lang["SHOW_ID_NUMBERS"]			= "Visa ID nummer brevid namnet:";
$pgv_lang["MULTI_MEDIA"]                        = "Använd multimediafunktioner:";
$pgv_lang["MULTI_MEDIA_help"]                   = "GEDCOM 5.5 formatet tillåter dig att länka in bilder, filmer och andra multimediaobjekt i GEDCOM-filen.  Om du inte inkluderar multimediaobjekt i dina gedcom-filer kan du stänga av denna funktion genom att sätta detta värde till 'no'. <br />Se sektionen om multimedia i <a href=\"readme.txt\">readme.txt</a> filenför mer information om att inkludera mediafiler i din site.<br />Detta ställer in \$MULTI_MEDIA variabeln i config.php filen.";
$pgv_lang["MEDIA_DIRECTORY"]                    = "MultiMediakatalog:";
$pgv_lang["MEDIA_DIRECTORY_help"]               = "Sökvägen till den katalog där PhpGedView skall leta efter lokala multimediafiler (inkludera avslutande \"/\")<br />Detta ställer in \$MEDIA_DIRECTORY variabeln i config.php filen.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]             = "Antal katalognivåer för MultiMedia som används:";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]        = "Genom att sätta detta värde till 0 kommer alla kataloger i mediafilens sökväg i gedcomfilen att ignoreras. Sätts värdet till 1 kommer den första katalogen i sökvägen att användas.  Ett högra värde innebär fler inkluderade kataloger i den medifilens sökväg.  <br />Till exempel: Om du har en länk till en bild i din gedcomfil med en sökväg liknande C:\\Documents and Settings\\User\\My Documents\\My Pictures\\Genealogy\\Surname Line\\grandpa.jpg kommer ett värdet 0 översättas till en denna sökväg ./media/grandpa.jpg.  Värdet 1 kommer översättas till ./media/Surname Line/grandpa.jpg, etc.  För de allra flesta kommer värdet 0 fungera bra.  Men har man flera filer med samma namn men i olika kataloger kan ett högre värde vara bra för att förhindra att filerna skrivs över varandra.  Denna inställning tillåter dig därför att organisera din mediafiler i olika kataloger för att förenkla administration och förhindrande av namndubletter.<br />Detta val ställer in \$MEDIA_DIRECTORY_LEVELS variabeln i config.php filen.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"]              = "Visa miniatyrbilder i personrutorna:";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]         = "Om du använder multimediafiler kan du med detta val tala om för PhpGedView att den skall visa en liten bild bredvid en persons namn.  För tillfället använder PhpGedView det förs angivna bildobjektet i gedcom posten för detta ändamål.  För personer med flera bilder bör du arrangera bilderna så att den bild du vill använda som thumbnail hamnar först i listan, föra andra bilder.<br />Se sektionen om multimedia i <a href=\"readme.txt\">readme.txt</a> filen för mer information om att inkludera bilder på din site.<br />Detta ställer in \$SHOW_HIGHLIGHT_IMAGES variabeln i config.php filen.";
$pgv_lang["ENABLE_CLIPPINGS_CART"]              = "Tillåt urklipskorgen:";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]         = "Urklippskorgen tillåter besökare på din site att lägga till personer i en urklippskorg. Urklippskorgen kan sedan besökaren ladda ner form av en gedcomfil som de sedan kan importera i sina egna genealogiska program.<br />Detta ställer in \$ENABLE_CLIPPINGS_CART variabeln i config.php filen.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]                 = "Göm GEDCOM-fel:";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]            = "Sätt detta värde till 'yes' om du vill att gömma alla felmeddelanden som PhpGedView producerar om det inte förstår ett attribut i din gedcomfil.  PhpGedView försöker hela tiden att följa GEDCOM 5.5 standarden, men vissa genealogiska program inkluderar sina egna ickestandardiserade attribut.  Se <a href=\"readme.txt\">readme.txt</a> filen för mer information.<br />Detta ställer in \$HIDE_GEDCOM_ERRORS variabeln i config.php filen.";
$pgv_lang["WORD_WRAPPED_NOTES"]                 = "Lägg till tomrum där anteckningar blir wrappade:";
$pgv_lang["WORD_WRAPPED_NOTES_help"]            = "Vissa genealogiska program bryter rader vid ordgränserna medan andra bryter mitt i orden.  Detta fenomen kan få PhpGedView att skriva ihop två ord.  Genom att sätta detta värde till 'yes' kommer ett mellanslag att läggas till där meningar radbryts i gedcomfilen.<br />Detta ställer in \$WORD_WRAPPED_NOTES variabeln i config.php filen.";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Visa ? hjälplänkar på sidorna:";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "Detta val kommer att sätta på frågeteckenhjälplänkarna på sidorna intill valmöjligheterna så att besökare kan få hjälptexter om valen på sidorna.<br /><br />Detta sätter \$SHOW_CONTEXT_HELP variabeln i filen config.php.";
$pgv_lang["HOME_SITE_URL"]                      = "URL till huvudsida:";
$pgv_lang["HOME_SITE_URL_help"]                 = "En URL inkluderad i den medföljande temats sidhuvud som används för att generera en länk till din huvudsida.<br />Detta ställer in \$HOME_SITE_URL variabeln i config.php filen.";
$pgv_lang["HOME_SITE_TEXT"]                     = "Länktitel för URL till huvudsida:";
$pgv_lang["HOME_SITE_TEXT_help"]                = "Den text som kommer att användas som titel för länken till din huvudsida.<br />Detta ställer in \$HOME_SITE_TEXT variabeln i config.php filen.";
$pgv_lang["CONTACT_EMAIL"]                      = "Släktforskningskontakt:";
$pgv_lang["CONTACT_EMAIL_help"]                 = "E-mail adressen som besökare kan använda för att kontakta dig om frågor gällande dina genealogiska data på din sida.<br />Detta val stääller in \$CONTACT_EMAIL variabeln i config.php filen.";
$pgv_lang["CONTACT_METHOD"]			= "Kontakt metod";
$pgv_lang["CONTACT_METHOD_help"]		= "Metoden som besökare kommer att använda för att kontakta 'Kontakt användaren' om släktforskningsfrågor. Maila till alternativet kommer att lägga till en maila till länk som besökare kan klicka på för att sända mail via deras mailklient. Meddelande alternativet använder det inbyggda PhpGedView meddelandesystemet vilket medför att inga mail komme ratt skickas. Alternativet meddelande med email är standard alternativet och medför att man använder PhpGedViews meddelande system men kommer också att skicka en kopia av meddelandet via email. Om man alternativ Inga meddelande finns det ingen möjlighet för besökare att kontakta dig.<br /><br />Detta sätter variabeln \$CONTACT_METHOD i config.php filen.";
$pgv_lang["WEBMASTER_EMAIL"]                    = "E-mail till Webmaster:";
$pgv_lang["WEBMASTER_EMAIL_help"]               = "E-mail-adressen besökera kan använda för att kontakta dig angående tekniska frågor eller fel på din site.<br />Detta val ställer in \$WEBMASTER_EMAIL variabeln i config.php filen.";
$pgv_lang["SUPPORT_METHOD"]			= "Support metod:";
$pgv_lang["SUPPORT_METHOD_help"]		= "Metoden som besökare kommer att använda för att kontakta 'Support användaren' om släktforskningsfrågor. Maila till alternativet kommer att lägga till en maila till länk som besökare kan klicka på för att sända mail via deras mailklient. Meddelande alternativet använder det inbyggda PhpGedView meddelandesystemet vilket medför att inga mail komme ratt skickas. Alternativet meddelande med email är standard alternativet och medför att man använder PhpGedViews meddelande system men kommer också att skicka en kopia av meddelandet via email. Om man alternativ Inga meddelande finns det ingen möjlighet för besökare att kontakta dig.<br /><br />Detta sätter variabeln \$SUPPORT_METHOD i config.php filen.";
$pgv_lang["FAVICON"]                            = "Favoritikon:";
$pgv_lang["FAVICON_help"]                       = "Ändra denna sökväg så att den pekar på den ikon du vill skall visas i besökares favoriter när lagt till din sida bland sina bokmärken.<br />Detta ställer in \$FAVICON variabeln i config.php filen.";
$pgv_lang["THEME_DIR"]                          = "Katalog för teman:";
$pgv_lang["THEME_DIR_help"]                     = "Katalogen där dina PhpGedView-teman är lagrade.  Du kan designa om vilken som helst av de medföljande temanen för att sätta din egna unika prägel på din PhpGedView site.  Se sektionen om att skräddarsy teman i <a href=\"readme.txt\">readme.txt</a> filen för mer information.<br />Detta val ställer in \$THEME_DIR variabeln i config.php filen.";
$pgv_lang["TIME_LIMIT"]                         = "PHP-tidsgräns:";
$pgv_lang["TIME_LIMIT_help"]                    = "Den maximala tid i sekunder som PhpGedView är tillåten att köra vid ett anrop.  Standardvärdet är en minut (60s).  Beroende på storleken på din gedcomfil kan du behöva öka tidsgränsen när du behöver uppdatera och genera index mm för din gedcomfil.  Sätt detta värde för att tillåta PHP att köra under obegränsad tid.<br />VARNING: Att sätta värdet till 0, eller för högt kan leda till att din sida i vissa operativsystem slutar svara ända tills det att skriptet avslutas.  Att sätta värdet till 0 innebära att phpskriptet i vissa situtationer aldrig kommer avslutas förren serveradminsitratören dödar processen eller startar om servern.  Ett stort släktträd kan ta rätt lång tid på sig att köra, varför ett lågt värde kan hjälpa till att förhindra att en illvillig person krashar din servern genom att fråga efter ett släktträd på tusentals generationer.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]		= "Sökvägen för att spara phpGedView sessionsfiler. Vissa webbhotell har inte configurerat PHP på ett korrekt sätt varför sessioner inte behålls mellan sidförflyttingar. Detta val gör det möjligt för administratörer att åtgärda detta genom att spara sessionsfilerna i en lokal katalog. ./index/ katalogen är ett bra val om du behöver ändra detta. Som standard lämans fältet tomt vilket innebär att standardsäkvägen angiven i php.ini kommer användas.<br /><br />Detta ställer in \$PGV_SESSION_SAVE_PATH variabeln i config.php filen.";
$pgv_lang["SERVER_URL"]			= "Server URL:";
$pgv_lang["SERVER_URL_help"]			= "Om du använder https eller en annan än standard porten, behöver du ange en URL för att få åtkomst till din server.<br /><br />Detta sätter variablen \$SERVER_URL i config.php filen.";
$pgv_lang["PGV_SESSION_TIME"]		= "Sessionens Timeout:";
$pgv_lang["PGV_SESSION_SAVE_PATH"]		= "Sessions data sökväg:";
$pgv_lang["SHOW_STATS_help"]			= "Visa körtid and antalet databasfrågor längstner på varje sida.<br /><br />Detta ställer in \$SHOW_STATS variabeln i config.php filen.";
$pgv_lang["USE_REGISTRATION_MODULE"]		= "Tillåt användare att begära kontoregistrering:";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "Ger användare möjligheten att registrera sig själva för ett konto på sajten. Administratören behöver godkänna registreringen innan den blir aktiv.<br /><br />Detta sätter variabeln \$USE_REGISTRATION i filen config.php";
$pgv_lang["ALLOW_USER_THEMES"]			= "Tillåt användaren att välja sitt eget tema.";
$pgv_lang["ALLOW_USER_THEMES_help"]		= "Ger användaren möjligheten att välja sitt eget tema.<br /><br />Detta sätter variabeln \$ALLOW_USER_THEMES i filen config.php";
$pgv_lang["CREATE_GENDEX"]			= "Skapa Gendex fil:";
$pgv_lang["CREATE_GENDEX_help"]			= "Visa PhpGedView skapa Gendexfil när en Gedcomfil importeras. Gendex filer sparas i Indexkatalogen.<br /><br />Detta sätter variabeln \$CREATE_GENDEX i config.php filen.";
$pgv_lang["gedcom_title_help"]			= "Skriv in en titel som beskriver innehållet i denna Gedcomfil.";
$pgv_lang["LOGFILE_CREATE"]			= "Arkivera loggfiler:";
$pgv_lang["LOGFILE_CREATE_help"]		= "Hur ofta ska programmet arkivera logfiler?<br /><br />Detta sätter variabeln \$LOGFILE_CREATE i config.php filen.";
$pgv_lang["PGV_SESSION_TIME_help"]		= "Tiden i sekunder en session i PhpGedView varar innan en ny inloggning krävs. Default tiden är 30 minuter.<br /><br />Detta sätter variabeln \$PGV_SESSION_TIME i config.php filen.";
$pgv_lang["SHOW_STATS"]				= "Visa processstatistik:";

$pgv_lang["welcome"]                            = "Välkommen till din nya PhpGedView websida.  Eftersom du kan se denna sida har du framgångsrikt installerat PhpGedView på din webserver. Du är nu redo att börja konfigurera PhpGedView så som du vill ha det.<br />";
$pgv_lang["review_readme"]                      = "Du bör först läsa igenom <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> filen innan du fortsätter med att konfigurera PhpGedView.<br /><br />Du kan återkomma till denna konfiguration när som helst genom att browsa in till configure.php filen.<br /><br />Du kan få hjälp med varje konfigurationsinställning genom att klicka på &quot;<b>?</b>&quot; vid rubriken för varje ruta.<br /><br />";

$pgv_lang["save_config"]                        = "Spara konfigurationen";
$pgv_lang["reset"]                              = "Återställ";
$pgv_lang["download_here"]			= "Klicka här för att ladda ner filen.";
$pgv_lang["download_gedconf"]			= "Ladda ner GEDCOM inställningarna.";
$pgv_lang["not_writable"]			= "Din inställningsfil är inte skrivbar. Du kan använda nerladdningsknappen för att spara dina inställningar så att du kan ladda upp dom manuellt.";
$pgv_lang["download_file"]			= "Ladda ner fil";
$pgv_lang["upload_to_index"]			= "Ladda upp filen till index katalogen:";

$pgv_lang["welcome_help"]			= "Detta hjälpfönster vill guida dig igenom konfigurationsprocessen. När du flyttar dig mellan olika fält kommer detta fönster att visa hjälpinformation om fältet du är i. Du kan stänga fönstret, om du vill öppna det igen så tryck på '?' intill fältetetiketten.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Konfigurering av privacy-filen [\"#PRIVACY_MODULE#\"]";
$pgv_lang["edit_privacy_title"]			= "Editera Gedcom integritetsinställningar - [#PRIVACY_MODULE#]";
$pgv_lang["PRIV_PUBLIC"]			= "Visa allmänheten:";
$pgv_lang["PRIV_USER"]				= "Visa endast för registrerade användare";
$pgv_lang["PRIV_NONE"]				= "Visa endast för administratörer";
$pgv_lang["PRIV_HIDE"]				= "Dölj till och med för administratörer";
$pgv_lang["save_changed_settings"]		= "Spara ändringar";
$pgv_lang["add_new_pp_setting"]			= "Lägg till ny[\$person_privacy] - inställning";
$pgv_lang["add_new_up_setting"]			= "Lägg till ny[\$user_privacy] - inställning";
$pgv_lang["add_new_gf_setting"]			= "Lägg till ny[\$global_facts] - inställning";
$pgv_lang["add_new_pf_setting"]			= "Lägg till ny[\$person_facts] - inställning";
$pgv_lang["privacy_indi_id"]			= "Individ - ID";
$pgv_lang["privacy_source_id"]			= "Källa - ID";
$pgv_lang["privacy_indi_source"]		= "Individer / Källor";
$pgv_lang["privacy_indi"]			= "Individ";
$pgv_lang["privacy_source"]			= "Källa";
$pgv_lang["add_new_pf_setting_indi"]		= "Lägg till ny [\$person_facts] - inställning för individer";
$pgv_lang["add_new_pf_setting_source"]		= "Lägg till [\$person_facts] - inställning för källor";
$pgv_lang["file_read_error"]			= "FEL!!! kunde inte läsa privacy-filen!";
$pgv_lang["general_settings"]			= "Allmäna integritetsinställningar";
$pgv_lang["person_privacy_settings"]		= "[\$person_privacy] - inställningar";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Ändra existerande [\$person_privacy] - inställningar";
$pgv_lang["user_privacy_settings"]		= "[\$user_privacy] - inställningar";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Ändra existerande [\$user_privacy] - inställningar";
$pgv_lang["global_facts_settings"]		= "[\$global_facts] - inställningar";
$pgv_lang["edit_exist_global_facts_settings"]	= "Ändra existerande [\$global_facts] - inställningar";
$pgv_lang["person_facts_settings"]		= "[\$person_facts] - inställningar";
$pgv_lang["edit_exist_person_facts_settings"]	= "Ändra existerande [\$person_facts] - inställningar";
$pgv_lang["accessible_by"]			= "Visa för?";
$pgv_lang["hide"]				= "Göm";
$pgv_lang["show_question"]			= "Visa?";
$pgv_lang["user_name"]				= "Användarnamn";
$pgv_lang["name_of_fact"]			= "Namn på faktum";
$pgv_lang["choice"]				= "Val";
$pgv_lang["fact_show"]				= "Visa fakta";
$pgv_lang["fact_details"]			= "Visa faktadetaljer";
$pgv_lang["privacy_header"]			= "Ändra integritetsinställningar inuti";
$pgv_lang["unable_to_find_privacy_indi"]	= "Kan inte hitta personen med id";
$pgv_lang["save_and_import"]			= "Efter du har sparat denna GEDCOM konfiguration behöver du importera GEDCOM filen genom att klicka på<br />Import gedcom Knappen<br />eller genom att gå till<br />Admin->Manage Gedcoms->Import<br />";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Visa de levandes namn";
$pgv_lang["SHOW_RESEARCH_LOG"]			= "Visa forskningslog";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Använd relationsintegritet";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Max. relationsväglängd";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Kontrollera vigselrelation";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Visa döda personer";
$pgv_lang["help_info"]				= "Du kan få hjälp för varje sak genom att trycka på '?' vid etiketten för varje fält.";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "Visa levandes namn<br /><br />Skall levande personers namn visas för allmänheten?<br /><br />Detta sätter variabeln \$SHOW_LIVING_NAMES i den valda integritetsfilen.";
$pgv_lang["SHOW_RESEARCH_LOG_help"]		= "Visa forskningsloggen<br /><br />Vilken typ av användare kan titta i forskningloggen om den är installerad.<br /><br />Detta sätter variabeln \$SHOW_RESEARCH_LOG i den valda integritetsfilen.";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "Använd Relationsintegritet<br /><br />Ett 'Nej' värde betyder att registrerade användare kan se detaljerna på alla levande personer.<br /><br />Ett 'Ja' värde betyder att användare kan bara se den privata informationen för levande personer de är släkt med.<br /><br />Detta sätter variablen \$USE_RELATIONSHIP_PRIVACY i den valda integritetsfilen.";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "Max. Relationsvägslängd<br /><br />Nästkusiner.<br /><br />Detta sätter variablen \$MAX_RELATION_PATH_LENGTH i den valda integritetfilen.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "Kontrollera vigselrealtioner<br /><br />Kontrollera släktförhållande genom vigselrelationer.<br /><br />Detta sätter variabeln \$CHECK_MARRIAGE_RELATIONS i den valda initigritetsfilen.<br /><br />";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "Visa döda personer<br /><br />Sätt integritetsaccessnivå för alla döda personer";
$pgv_lang["person_privacy_help"]		= "Inställningarna för 'person_privacy' ger administratören möjlighet att åsidosätta standard inställningarna för en specifik person i GEDCOMfilen. Tillexempel om du har en barn som dött tidigt. Normalt skulle detta barns data visas för alla men du och alla andra i familjen visas det ingen data för. Du vill kanske inte ta bort dödposten för barnet men du vill gömma detaljerna för icke registrerade användare. Om barnet har ID 1100 skall du skriva in följande inställningar:<br /><br />ID:1100<br />Visa för: 'Visa endast för registrerade användare'<br /><br />Detta fungerar på andra hållet också. Om man vill visa detaljerna för någon(ID101) som jag vet är död men som jag inte har något dödsdatum för kan jag lägga till följande:<br /><br />ID:101<br />Visa för: 'Visa för alla'<br /><br />Detta sätter variabeln \$person_privacy i den valda integritetsfilen.";
$pgv_lang["user_privacy_help"]			= "Inställningarna för 'user_privacy' ger administratören möjlighet att åsidosätta standard inställningarna för en specifik person i GEDCOMfilen baserat på användarnamn.<br />Tillexempel om du inte vill att användarnamnet 'John' ska kunna se mina detaljer och mitt id är ID 100 i GEDCOMfilen kan jag konfigurera det så här:<br /><br />Användarnamn: John<br />ID:100<br />Show?: 'Hide'<br />och detljerna kommer inte att synas för användarnamnet 'John' endast.<br /><br />För att visa detaljerna för ID 101 (Vilket normalt inte skulle synas) för användarnamnet 'John':<br /><br />Användarnamn: John<br />ID:101<br />Show?: 'Show'<br />och detljerna kommer att synas endast för användarnamnet 'John'.<br /><br />Detta sätter variabeln \$user_privacy i den valda integritetsfilen.";
$pgv_lang["global_facts_help"]			= "Inställningar i 'global_facts' definierar på en global nivå vilka data som ska var dolda för alla personer i en GEDCOM.<br /><br />['Name of fact'] element bestämmer vilka fakta som ska vara dolda.<br />['Val'] elementet väljer antingen hela faktan eller releaterade detaljer. ['Show to'] elementet bestämmer på vilken åtkomstnivå faktan visas.<br /><br />\$global_facts vektorn är tänkt att dölja vissa fakta för alla personer levande eller döda via GEDCOM tag. SSN taggen är dold för alla användare från början. Detta ä för att hindra stöld av personnummer för att byta identitet av dina döda släktingar, detta problem är troligen mest relevant för USA.<br />Om jag vill dölja alla vigselfakta för den allmänna användaren i min GEDCOMfilen Kan jag sätta:<br /><br />Namn på fakta:(MARR) - Vigsel<br />Val: 'Visa fakta'<br />Visa för?: 'Visa endast för registrerade användare'<br /><br />Dessa inställningar kommer att dölja vigslar(och dess detaljer) för alla som inte är administratör.<br /><br />Detta sätter variablen \$global_facts i den valda integritetsfilen.";
$pgv_lang["person_facts_help"]			= "Inställningar i 'person_facts' definierar vilka fakta som är dolda för en specifik person i en GEDCOM fil och på vilken nivå de är dolda.<br /><br />Det första elementet är IDt för personen det andra elementet är faktan.<br />['Val'] elementet väljer antingen hela faktan eller releaterade detaljer. ['Show to'] elementet bestämmer på vilken åtkomstnivå faktan visas.<br /><br />\$person_facts vektorn fungerar på samma sätt som \$global_facts vektorn förutom att du dessutom anger GEDCOM ID för person som du vill dölja fakta för. Så att jag kan dölja vigselfaktan för en specifik person.<br /><br />Detta sätter variablen \$person_facts i den valda integritetsfilen.";
$pgv_lang["find_sourceid"]			= "Hitta källid";

//-- language edit utility
$pgv_lang["edit_langdiff"]		= "Ändra översättningsfiler";

$pgv_lang["edit_lang_utility"]		= "Editor för översättningsfiler";
$pgv_lang["language_to_edit"]		= "Välj språk";
$pgv_lang["contents"]			= "Innehåll";
$pgv_lang["listing"]			= "Visar";
$pgv_lang["lang_save"]			= "Spara";
$pgv_lang["file_to_edit"]		= "Välj översättningsfil";
$pgv_lang["edit_lang_utility_help"]	= "Du kan använda denna editor för att ändra på innehållet i översättnings filerna genom att jämföra med den Engelska.<br />Den visar innehållet i den Engelska orginalfilen och den valda översättningsfilen.<br />Efter att du klickar på översättningstexten kommer ett nytt fönster att öppnas där du kan ändra på texten samt spara den.";
$pgv_lang["original_message"]		= "Orginaltext";
$pgv_lang["cancel"]			= "Avbryt";
$pgv_lang["savelang_help"]		= "Spara översättning";
$pgv_lang["no_content"]			= "Inget innehåll";
$pgv_lang["editlang_help"]		= "Ändra på översättning";
$pgv_lang["message_to_edit"]		= "Översättning";
$pgv_lang["changed_message"]		= "Ändrat innehåll";

$pgv_lang["message_empty_warning"]	= "-> Varning!!! Detta meddelande är tomt inuti[#LANGUAGE_FILE#]<-";
$pgv_lang["language_to_export"]		= "Språk att exportera";
$pgv_lang["export_lang_utility"]	= "Exportverktyg för språkfiler";
$pgv_lang["export"]			= "Exportera";
$pgv_lang["export_lang_utility_help"]	= "I denna modul kan du välja ett språk för att sedan klicka på export knappen för att exportera hjälpmeddelandena från den valda konfigurationen för att skapa dokument.";
$pgv_lang["export_ok"]			= "Hjälpmeddelandena är exporterade.";
$pgv_lang["compare_lang_utility"]	= "Jämförelseredskap för språkfiler";
$pgv_lang["compare_lang_utility_help"]	= "Denna modulen jämför två språkfiler och ger ut en lista på skillnader.<br /><br />Se språkets [languages/LANG_CHANGELOG.txt] för andra språkändringar";
$pgv_lang["new_language"]		= "Nytt språk";
$pgv_lang["old_language"]		= "Gammalt språk";
$pgv_lang["compare"]			= "Jämför";
$pgv_lang["comparing"]			= "Språkfiler som jämförs";
$pgv_lang["additions"]			= "Tillägg";
$pgv_lang["no_additions"]		= "Inga Tillägg";
$pgv_lang["subtractions"]		= "Borttagna";
$pgv_lang["no_subtractions"]		= "Inget borttaget";
$pgv_lang["config_lang_utility"]	= "Konfiguration av vilka språk som ska stödjas";
$pgv_lang["config_lang_utility_help"]	= "Denna modul hjälper dig att sätta på och stänga av vilka språk som ska stödjas.<br /><br />";
$pgv_lang["active"]			= "Aktiverad";
$pgv_lang["active_help"]		= "Tillåt användare att välja detta språk om språkändringar är tillåtna.";
$pgv_lang["edit_settings"]		= "Ändra inställningar";
$pgv_lang["lang_edit"]			= "Ändra";
$pgv_lang["lang_language"]		= "Språk";
$pgv_lang["export_filename"]		= "Namn på filen som innehåller den exporterade datan:";
$pgv_lang["lang_back"]			= "Tillbaka till huvudmenyn för editering och konfigurering av språkfiler";
$pgv_lang["lang_back_admin"]		= "Tillbaka till administratörsmenyn";
$pgv_lang["lang_name_chinese"]		= "Kinesiska";
$pgv_lang["lang_name_danish"]		= "Danska";
$pgv_lang["lang_name_dutch"]		= "Holländska";
$pgv_lang["lang_name_english"]		= "Engelska";
$pgv_lang["lang_name_french"]		= "Franska";
$pgv_lang["lang_name_german"]		= "Tyska";
$pgv_lang["lang_name_hebrew"]		= "Hebreiska";
$pgv_lang["lang_name_italian"]		= "Italienska";
$pgv_lang["lang_name_norwegian"]	= "Norska";
$pgv_lang["lang_name_polish"]		= "Polska";
$pgv_lang["lang_name_portuguese"]	= "Portugisiska";
$pgv_lang["lang_name_portuguese-br"]	= "Brasiliansk Portugisiska";
$pgv_lang["lang_name_russian"]		= "Ryska";
$pgv_lang["lang_name_spanish"]		= "Spanska";
$pgv_lang["lang_name_spanish-ar"]	= "Latinamerikansk spanska";
$pgv_lang["lang_name_swedish"]		= "Svenska";
$pgv_lang["lang_name_turkish"]		= "Turkiska";
$pgv_lang["original_lang_name"]		= "Ursprungligt namn på språket i #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "Ingen hjälp ännu :-(";
$pgv_lang["lang_shortcut"]		= "Genväg för språkfiler";
$pgv_lang["lang_shortcut_help"]		= "Ingen hjälp ännu :-(";
$pgv_lang["lang_filename"]		= "Språkfil";
$pgv_lang["lang_filename_help"]		= "Namn och sökväg för standardspråkfil vid översättning.";
$pgv_lang["config_filename"]		= "Konfigurationshjälpens filnamn";
$pgv_lang["config_filename_help"]	= "Namn och sökväg till Konfigurationhjälpens översättningsfil.";
$pgv_lang["facts_filename"]		= "Faktafil";
$pgv_lang["facts_filename_help"]	= "Namn och sökväg till GEDCOM-faktans översättningsfil.";
$pgv_lang["help_filename"]		= "Hjälpfil";
$pgv_lang["help_filename_help"]	= "Namn och sökväg till filen med överssättningen till hjälp texten.";
$pgv_lang["flagsfile"]			= "Flaggfilens namn";
$pgv_lang["flagsfile_help"]		= "Namn och sökväg till den nationella flaggan för det valda språket.";
$pgv_lang["text_direction"]		= "Textorientering";
$pgv_lang["text_direction_help"]	= "Ingen hjälp ännu :-(";
$pgv_lang["date_format"]		= "Datumformat";
$pgv_lang["date_format_help"]		= "Ingen hjälp ännu :-(";
$pgv_lang["week_start"]			= "Veckan startar på";
$pgv_lang["week_start_help"]		= "Ingen hjälp ännu :-(";
$pgv_lang["name_reverse"]		= "Ändring av ordning på namnen";
$pgv_lang["name_reverse_help"]		= "Ingen hjälp ännu :-(";
$pgv_lang["ltr"]			= "Från vänster till höger";
$pgv_lang["rtl"]			= "Från höger till vänster";
$pgv_lang["file_does_not_exist"]	= "Fel! Filen finns inte...";
$pgv_lang["alphabet_upper"]		= "Stora bokstäver";
$pgv_lang["alphabet_upper_help"]	= "Stora bokstäver i detta språket. Detta alfabet används för sortering av namn med stora bokstäver i namnlistorna för PhpGedViewi det valda språket.";
$pgv_lang["alphabet_lower"]		= "Små bokstäver";
$pgv_lang["alphabet_lower_help"]	= "Små bokstäver i detta språket. Detta alfabet används för sortering av små bokstäver i namnlistorna i PhpGedView för det valda språket.";
$pgv_lang["lang_config_write_error"]	= "Fel vid skrivning av inställningar i språkfilen [language_settings.php]. Kontrollera skrivrättighter och försök igen.";
$pgv_lang["lang_save_success"]		= "Lyckad sparning av ändringar i #PGV_LANG#";
$pgv_lang["translation_forum"]		= "Länk till PhpGedViews översätningsforum på SourceForge";
$pgv_lang["translation_forum_help"]	= "Länken öppnar ett nytt fönster till översättningsforumet för PhpGedView (http://sourceforge.net/forum/forum.php?forum_id=294245) där kan du diskutera översättningsspecifika problem :-)";
$pgv_lang["system_time"]		= "Nuvarande systemtid:";
$pgv_lang["gedcom_not_imported"]	= "Denna gedcom har inte blivit importerad ännu.";
$pgv_lang["lang_set_file_read_error"]	= "Error!!! Kan inte läsa [language_settings.php]!";
$pgv_lang["how_upgrade_help"]		= "Uppgraderingsverktyget<br />Uppgraderingsredskapet tar hand om uppgraderingen av din existerande phpGedView till en ny version som du har laddat ner.<br /><br />Ladda ner en ny version?<br /><br />En ny version kan antingen laddas ner direkt från http://sourceforge.net/projects/phpgedview/ eller så kan du låta uppgraderingsredskapet kontrollera om det finns en ny version. Om en ny version finns så kommer de tillgängliga versionerna att visas. Dessa kan antingen vara i zip eller gz eller i båda formaten.<br /><br />Vad ska uppgraderas?<br />*PhpGedView<br />Detta kommer att uppgradera alla kärnfiler utom config.php, privacy.php och authenticate.php. Den uppgraderar också Images foldern.<br />*Indexfiler<br />Detta uppgradera foldern /index. Använd detta med försiktighet, eftersom redan existerande filer kommer att bli överskrivna.<br />*Språk<br />Detta uppgradera /languages foldern.<br />*Teman<br />Detta uppgraderar /themes foldern. Använd detta med försiktighet, eftersom alla egna ändringar i temana kommet att skrivas över.<br />*Konfigurationsfilen<br />Detta kontrollerar din nuvarande konfigurationsfil mot den nya och uppdaterar din nuvarande med alla nya ändringar. Detta gör att du har den senaste filen med dina egna inställningar kvar.<br />*Privatlivsfilen<br />Detta kontrollerar din nuvarande privatlivsfil(er) mot den nya och uppdaterar din nuvarande med alla nya ändringar. Detta gör att du har den senaste filen med dina egna inställningar kvar.<br />*Manualer<br />Detta uppgraderar /doc mappen.<br />*Forskningsloggen<br />Detta uppgraderar Forskningsloggspluginet.<br />* Skapa backup<br />Detta kommer att skapa en backup av de gamla filerna i /backup mappen.<br />Hur uppgraderar man?<br />1. Välj de delar du vill uppgradera.<br />2. Klicka på spara<br /><br />Det visas sedan hur det går på nedre delen av sidan.";

?>
