<?php
/*=================================================
   charset=utf-8
   Project:	phpGedView
   File:	lang.en.php
   Author:	John Finlay
   Comments:	English Language file for PHPGedView
   Change Log:	See LANG_CHANGELOG.txt
2004-01-12 "qm" and "page_help" added (Jans)
2004-01-13 $pgv_lang["individuals"] added for placelist (Jans)
2004-01-15 $pgv_lang["default_form_info"] and $pgv_lang["gedcom_form_info"] added for extra info on Place Hierarchie
===================================================*/
# $Id: lang.en.php,v 1.144.2.3 2004/02/02 15:18:13 yalnifj Exp $
if (preg_match("/lang\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["page_help"]			= "Help";

//-- CONFIG FILE MESSAGES
$pgv_lang["error_title"]		= "ERROR: Cannot open GEDCOM file";
$pgv_lang["error_header"] 		= "The GEDCOM file, [#GEDCOM#], does not exist at the specified location.";
$pgv_lang["for_support"]		= "For technical support and information contact";
$pgv_lang["for_contact"]		= "For help with genealogy questions contact";
$pgv_lang["for_all_contact"]		= "For technical support or genealogy questions, please contact";
$pgv_lang["build_title"]		= "Building Index Files";
$pgv_lang["build_error"]		= "GEDCOM file has been updated.";
$pgv_lang["please_wait"]		= "Please wait while Index files must be rebuilt.";
$pgv_lang["choose_gedcom"]		= "Choose a GEDCOM dataset";
$pgv_lang["username"]			= "Username:";
$pgv_lang["password"]			= "Password:";
$pgv_lang["login"]			= "Login";
$pgv_lang["login_aut"]			= "Edit User";
$pgv_lang["logout"]			= "Logout";
$pgv_lang["admin"]			= "Admin";
$pgv_lang["logged_in_as"]		= "Logged in as ";
$pgv_lang["my_pedigree"]		= "My Pedigree";
$pgv_lang["my_indi"]			= "My Indi";
$pgv_lang["yes"]			= "Yes";
$pgv_lang["no"]				= "No";
$pgv_lang["add_gedcom"]			= "Add another GEDCOM";
$pgv_lang["no_support"]			= "We have detected that your browser does not support the standards used by this PhpGedView website.  Most browsers support these standards in their newer versions. Please upgrade your browser to a newer version.";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]	= "Pedigree Tree";
$pgv_lang["gen_ped_chart"]	= "#PEDIGREE_GENERATIONS# Generation Pedigree Chart";
$pgv_lang["generations"]	= "Generations";
$pgv_lang["view"]		= "View";
$pgv_lang["fam_spouse"]		= "Family with spouse:";
$pgv_lang["root_person"]	= "Root Person ID:";
$pgv_lang["hide_details"]	= "Hide Details";
$pgv_lang["show_details"]	= "Show Details";
$pgv_lang["person_links"]	= "Links to charts, families, and close relatives of this person. Click this icon to view this page starting at this person.";
$pgv_lang["zoom_box"]		= "Zoom in/out on this box.";
$pgv_lang["portrait"]		= "Portrait";
$pgv_lang["landscape"]		= "Landscape";
$pgv_lang["start_at_parents"]	= "Start at parents";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Unable to find family with id";
$pgv_lang["unable_to_find_indi"]	= "Unable to find individual with id";
$pgv_lang["unable_to_find_record"]	= "Unable to find record with id";
$pgv_lang["unable_to_find_source"]	= "Unable to find source with id";
$pgv_lang["unable_to_find_repo"]	= "Unable to find Repository with id";
$pgv_lang["repo_name"]			= "Repository Name:";
$pgv_lang["address"]			= "Address:";
$pgv_lang["phone"]			= "Phone:";
$pgv_lang["source_name"]		= "Source Name:";
$pgv_lang["title"]			= "Title:";
$pgv_lang["author"]			= "Author:";
$pgv_lang["publication"]		= "Publication:";
$pgv_lang["call_number"]		= "Call Number:";
$pgv_lang["living"]			= "Living";
$pgv_lang["private"]			= "Private";
$pgv_lang["birth"]			= "Birth:";
$pgv_lang["death"]			= "Death:";
$pgv_lang["descend_chart"]		= "Descendancy Chart";
$pgv_lang["individual_list"]		= "Individual List";
$pgv_lang["family_list"]		= "Family List";
$pgv_lang["source_list"]		= "Source List";
$pgv_lang["place_list"]			= "Place Hierarchy";
$pgv_lang["media_list"]			= "MultiMedia List";
$pgv_lang["search"]			= "Search";
$pgv_lang["clippings_cart"]		= "Family Tree Clippings Cart";
$pgv_lang["not_an_array"]		= "Not an Array";
$pgv_lang["print_preview"]		= "Print Preview";
$pgv_lang["change_lang"]		= "Change Language";
$pgv_lang["print"]			= "Print";
$pgv_lang["total_queries"]		= "Total Database Queries: ";
$pgv_lang["back"]			= "Back";

//-- INDIVUDUAL FILE MESSAGES
$pgv_lang["male"]			= "Male";
$pgv_lang["female"]			= "Female";
$pgv_lang["temple"]			= "LDS Temple";
$pgv_lang["temple_code"]		= "LDS Temple Code:";
$pgv_lang["status"]			= "Status";
$pgv_lang["source"]			= "Source:";
$pgv_lang["citation"]			= "Citation:";
$pgv_lang["text"]			= "Source Text:";
$pgv_lang["note"]			= "Note:";
$pgv_lang["unrecognized_code"]		= "Unrecognized GEDCOM Code";
$pgv_lang["indi_info"]			= "Individual Information";
$pgv_lang["pedigree_chart"]		= "Pedigree Chart";
$pgv_lang["desc_chart2"]		= "Descendancy Chart";
$pgv_lang["family"]			= "Family";
$pgv_lang["as_spouse"]			= "Family with Spouse";
$pgv_lang["as_child"]			= "Family with Parents";
$pgv_lang["view_gedcom"]		= "View GEDCOM Record";
$pgv_lang["add_to_cart"]		= "Add to Clippings Cart";
$pgv_lang["still_living_error"]		= "This person is still living or does not have a birth or death date recorded.  All details of living persons are hidden from public view.<br />For more information contact";
$pgv_lang["privacy_error"]		= "Details on this person are private.<br />";
$pgv_lang["more_information"]		= "For more information contact";
$pgv_lang["name"]			= "Name:";
$pgv_lang["given_name"]			= "Given Name:";
$pgv_lang["surname"]			= "Surname:";
$pgv_lang["suffix"]			= "Suffix:";
$pgv_lang["object_note"]		= "Object Note:";
$pgv_lang["sex"]			= "Sex:";
$pgv_lang["personal_facts"]		= "Personal Facts and Details";
$pgv_lang["type"]			= "Type";
$pgv_lang["date"]			= "Date";
$pgv_lang["place_description"]		= "Place / Description";
$pgv_lang["parents"] 			= "Parents:";
$pgv_lang["siblings"] 			= "Sibling";
$pgv_lang["father"] 			= "Father";
$pgv_lang["mother"] 			= "Mother";
$pgv_lang["relatives"]			= "Close Relatives";
$pgv_lang["child"]			= "Child";
$pgv_lang["spouse"]			= "Spouse";
$pgv_lang["surnames"]			= "Surnames";
$pgv_lang["adopted"]			= "Adopted";
$pgv_lang["foster"]			= "Foster";
$pgv_lang["sealing"]			= "Sealing";
$pgv_lang["link_as"]			= "Link this person to an existing family as a ";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Family Information";
$pgv_lang["family_group_info"]		= "Family Group Information";
$pgv_lang["husband"]			= "Husband";
$pgv_lang["wife"]			= "Wife";
$pgv_lang["marriage"]			= "Marriage:";
$pgv_lang["lds_sealing"]		= "LDS Sealing:";
$pgv_lang["marriage_license"]		= "Marriage License:";
$pgv_lang["media_object"]		= "Multimedia Object:";
$pgv_lang["children"]			= "Children";
$pgv_lang["no_children"]		= "No Children";
$pgv_lang["parents_timeline"]		= "Show parents on<br />timeline chart";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Clippings Cart";
$pgv_lang["clip_explaination"]		= "The Family Tree Clippings Cart allows you to taking &quot;clippings&quot; from this family tree and bundle them up into a single GEDCOM file for downloading.<br /><br />";
$pgv_lang["item_with_id"]		= "Item with id";
$pgv_lang["error_already"]		= "is already in your clippings cart.";
$pgv_lang["which_links"]		= "Which links from this family would you also like to add?";
$pgv_lang["just_family"]		= "Add just this family record.";
$pgv_lang["parents_and_family"]		= "Add the parents with this family record.";
$pgv_lang["parents_and_child"]		= "Add parents and children records with this family record.";
$pgv_lang["parents_desc"]		= "Add parents and all descendant records with this family record.";
$pgv_lang["continue"]			= "Continue Adding";
$pgv_lang["which_p_links"]		= "Which links from this person would you also like to add?";
$pgv_lang["just_person"]		= "Add just this person.";
$pgv_lang["person_parents_sibs"]	= "Add this person, his parents, and siblings.";
$pgv_lang["person_ancestors"]		= "Add this person and his direct line ancestors.";
$pgv_lang["person_ancestor_fams"]	= "Add this person, his direct line ancestors, and their families.";
$pgv_lang["person_spouse"]		= "Add this person, his spouse, and children.";
$pgv_lang["person_desc"]		= "Add this person, his spouse, and all descendant records.";
$pgv_lang["unable_to_open"]		= "Unable to open Clippings folder for writing";
$pgv_lang["person_living"]		= "This person is living. Personal details will not be included.";
$pgv_lang["person_private"]		= "Details about this person are private. Personal details will not be included.";
$pgv_lang["family_private"]		= "Details about this family are private. Family details will not be included.";
$pgv_lang["download"]			= "Right click (control-click on a Mac) on the links below and select &quot;Save target as&quot; to download the files.";
$pgv_lang["media_files"]		= "Media Files referenced in this GEDCOM";
$pgv_lang["cart_is_empty"]		= "Your tree clippings cart is empty.";
$pgv_lang["id"]				= "ID";
$pgv_lang["name_description"]		= "Name / Description";
$pgv_lang["remove"]			= "Remove";
$pgv_lang["empty_cart"]			= "Empty Cart";
$pgv_lang["download_now"]		= "Download Now";
$pgv_lang["indi_downloaded_from"]	= "This Individual was downloaded from:";
$pgv_lang["family_downloaded_from"]	= "This Family was downloaded from:";
$pgv_lang["source_downloaded_from"]	= "This Source was downloaded from:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]			= "Place connections found<br />View Results Now";
$pgv_lang["top_level"]				= "Top Level";
$pgv_lang["form"]				= "Places are encoded in the form: ";
$pgv_lang["default_form"]			= "City, County, State/Province, Country";
$pgv_lang["default_form_info"]			= "(Default)";
$pgv_lang["gedcom_form_info"]			= "(Gedcom)";
$pgv_lang["unknown"]				= "Unknown";
$pgv_lang["individuals"]			= "Individuals";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]			= "MultiMedia Object List";
$pgv_lang["media_found"]			= "Media Objects found";
$pgv_lang["view_person"]			= "View Person";
$pgv_lang["view_family"]			= "View Family";
$pgv_lang["view_source"]			= "View Source";
$pgv_lang["prev"]				= "< Previous";
$pgv_lang["next"]				= "Next >";
$pgv_lang["file_not_found"]			= "File not found.";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]			= "Search GEDCOM file";
$pgv_lang["enter_terms"]			= "Enter Search Terms:";
$pgv_lang["soundex_search"]			= "Soundex Name Search:";
$pgv_lang["search_results"]			= "Search Results";
$pgv_lang["sources"]				= "SOURCES";
$pgv_lang["firstname_search"]			= "Given: ";
$pgv_lang["lastname_search"]			= "Last: ";
$pgv_lang["search_place"]			= "Place: ";
$pgv_lang["search_year"]			= "Year: ";
$pgv_lang["lastname_empty"]			= "Please enter a last name.";
$pgv_lang["no_results"]				= "No results found.";
$pgv_lang["soundex_results"]			= "Perhaps the following soundex matches will be helpful.";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]			= "Sources found";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]			= "Source Information";
$pgv_lang["other_records"]			= "Other Records that link to this source:";
$pgv_lang["people"]				= "People";
$pgv_lang["families"]				= "Families";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]			= "Building Individual and Family Index";
$pgv_lang["building_index"]			= "Building Index Lists";
$pgv_lang["importing_records"]			= "Importing Records into Database";
$pgv_lang["detected_change"]			= "phpGedView detected a change in the GEDCOM file #GEDCOM#. Index files must now be rebuilt before proceeding.";
$pgv_lang["please_be_patient"]			= "PLEASE BE PATIENT";
$pgv_lang["reading_file"]			= "Reading Gedcom File";
$pgv_lang["flushing"]				= "Flushing contents";
$pgv_lang["found_record"]			= "Found record";
$pgv_lang["exec_time"]				= "Total Execution time:";
$pgv_lang["unable_to_create_index"]		= "Unable to create index file.  Make sure write permissions are available to the phpGedViewDirectory.  Permissions may be restored once index files are written.";
$pgv_lang["indi_complete"]			= "Individual Index file update complete.";
$pgv_lang["family_complete"]			= "Family Index file update complete.";
$pgv_lang["source_complete"]			= "Source Index file update complete.";
$pgv_lang["tables_exist"]			= "PHPGedView Tables already exist in the database";
$pgv_lang["you_may"]				= "You may:";
$pgv_lang["drop_tables"]			= "Drop the current tables";
$pgv_lang["import_multiple"]			= "Import and work with multiple gedcoms";
$pgv_lang["explain_options"]			= "If you choose to drop the tables all of the data will be replaced with this gedcom.<br />If you choose to import and work with multiple gedcoms, phpGedView will erase any data that was imported using a gedcom with the same file name.  This option allows you to store multiple GEDCOM data in the same tables and easily switch between them.";
$pgv_lang["path_to_gedcom"]			= "Enter the path to your GEDCOM file:";
$pgv_lang["gedcom_title"]			= "Enter a title that describes the data in this GEDCOM file:";
$pgv_lang["dataset_exists"]			= "A GEDCOM with this filename has already been imported into the database.";
$pgv_lang["empty_dataset"]			= "Do you want to empty the dataset?";
$pgv_lang["index_complete"]			= "Index Complete.";
$pgv_lang["click_here_to_go_to_pedigree_tree"]	= "Click here to go the the pedigree tree.";
$pgv_lang["updating_is_dead"]			= "Updating is dead status for INDI ";
$pgv_lang["import_complete"]			= "Import Complete";
$pgv_lang["updating_family_names"]		= "Updating family names for FAM ";
$pgv_lang["processed_for"]			= "Processed file for ";
$pgv_lang["run_tools"]				= "Do you want to run one of the following tools on your GEDCOM before it is imported:";
$pgv_lang["addmedia"]				= "Add Media Tool";
$pgv_lang["dateconvert"]			= "Date Conversion Tool";
$pgv_lang["xreftorin"]				= "Convert XREF IDs to RIN number";
$pgv_lang["tools_readme"]			= "See the tools secion of the #README.TXT# file for more information.";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]				= "Total Families";
$pgv_lang["total_indis"]			= "Total Individuals";
$pgv_lang["starts_with"]			= "Starts With:";
$pgv_lang["person_list"]			= "Person List:";
$pgv_lang["paste_person"]			= "Paste Person";
$pgv_lang["notes_sources_media"]		= "Notes, Sources, and Media";
$pgv_lang["name_contains"]			= "Name Contains:";
$pgv_lang["filter"]				= "Filter";
$pgv_lang["find_individual"]			= "Find Individual ID";
$pgv_lang["find_sourceid"]			= "Find Source ID";
$pgv_lang["skip_surnames"]			= "Skip Surname Lists";
$pgv_lang["show_surnames"]			= "Show Surname Lists";
$pgv_lang["all"]				= "ALL";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]				= "Age";
$pgv_lang["timeline_title"]			= "PhpGedView Timeline";
$pgv_lang["timeline_chart"]			= "Timeline Chart";
$pgv_lang["remove_person"]			= "Remove Person";
$pgv_lang["show_age"]				= "Show Age Marker";
$pgv_lang["add_another"]			= "Add Another person to chart:<br />Person ID:";
$pgv_lang["find_id"]				= "Find ID";
$pgv_lang["show"]				= "Show";
$pgv_lang["year"]				= "Year:";
$pgv_lang["timeline_instructions"]		= "In the most recent browsers you can click and drag the boxes around on the chart.";
$pgv_lang["zoom_in"]				= "Zoom In";
$pgv_lang["zoom_out"]				= "Zoom Out";

//-- MONTH NAMES
$pgv_lang["jan"]			= "January";
$pgv_lang["feb"]			= "February";
$pgv_lang["mar"]			= "March";
$pgv_lang["apr"]			= "April";
$pgv_lang["may"]			= "May";
$pgv_lang["jun"]			= "June";
$pgv_lang["jul"]			= "July";
$pgv_lang["aug"]			= "August";
$pgv_lang["sep"]			= "September";
$pgv_lang["oct"]			= "October";
$pgv_lang["nov"]			= "November";
$pgv_lang["dec"]			= "December";
$pgv_lang["abt"]			= "about";
$pgv_lang["aft"]			= "after";
$pgv_lang["and"]			= "and";
$pgv_lang["bef"]			= "before";
$pgv_lang["bet"]			= "between";
$pgv_lang["cal"]			= "calculated";
$pgv_lang["est"]			= "estimated";
$pgv_lang["from"]			= "from";
$pgv_lang["int"]			= "interpreted";
$pgv_lang["to"]				= "to";
$pgv_lang["cir"]			= "circa";
$pgv_lang["apx"]			= "approx.";

//-- Admin File Messages
$pgv_lang["select_an_option"]		= "Select an option below:";
$pgv_lang["readme_documentation"]	= "README Documentation";
$pgv_lang["configuration"]		= "Configuration";
$pgv_lang["rebuild_indexes"]		= "Rebuild Indexes";
$pgv_lang["user_admin"]			= "User Administration";
$pgv_lang["user_created"]		= "User created successfully.";
$pgv_lang["user_create_error"]		= "Unable to add user.  Please go back and try again.";
$pgv_lang["password_mismatch"]		= "Passwords do not match.";
$pgv_lang["enter_username"]		= "You must enter a username.";
$pgv_lang["enter_fullname"]		= "You must enter a full name.";
$pgv_lang["enter_password"]		= "You must enter a password.";
$pgv_lang["confirm_password"]		= "You must confirm the password.";
$pgv_lang["update_user"]		= "Update User";
$pgv_lang["save"]			= "Save";
$pgv_lang["delete"]			= "Delete";
$pgv_lang["edit"]			= "Edit";
$pgv_lang["full_name"]			= "Full Name";
$pgv_lang["can_admin"]			= "Can Admin";
$pgv_lang["can_edit"]			= "Can Edit";
$pgv_lang["confirm_user_delete"]	= "Are you sure you want to delete the user";
$pgv_lang["create_user"]		= "Create User";
$pgv_lang["no_login"]			= "Unable to authenticate user.";
$pgv_lang["import_gedcom"]		= "Import this GEDCOM File";
$pgv_lang["duplicate_username"]		= "Duplicate username.  A user with that username already exists.  Please go back and choose another username.";
$pgv_lang["gedcomid"]			= "Gedcom INDI record ID";
$pgv_lang["enter_gedcomid"]		= "You must enter a Gedcom ID.";
$pgv_lang["user_info"]			= "My User Information";
$pgv_lang["rootid"]			= "Pedigree Chart Root Person";
$pgv_lang["download_gedcom"]		= "Download Gedcom";
$pgv_lang["upload_gedcom"]		= "Upload Gedcom";
$pgv_lang["add_new_gedcom"]		= "Create a New Gedcom";
$pgv_lang["gedcom_file"]		= "Gedcom File:";
$pgv_lang["enter_filename"]		= "You must enter a GEDCOM file name.";
$pgv_lang["file_exists"]		= "There is already a GEDCOM with that file name. Please choose a different file name or delete the old file.";
$pgv_lang["new_gedcom_title"]		= "Genealogy from [#GEDCOMFILE#]";
$pgv_lang["upload_error"]		= "There was an error uploading you gedcom file.";
$pgv_lang["upload_help"]		= "Select a file from your local computer to upload to your server.  All files will be uploaded to the directory:";
$pgv_lang["add_gedcom_instructions"]	= "Enter a filename for this new GEDCOM.  The new GEDCOM file will be created in the Index directory: ";
$pgv_lang["file_success"]		= "File successfully uploaded";
$pgv_lang["file_too_big"]		= "Uploaded file exceeds the allowed size";
$pgv_lang["file_partial"]		= "File was only partially uploaded, please try again";
$pgv_lang["file_missing"]		= "No file was received. Upload again.";
$pgv_lang["manage_gedcoms"]		= "Manage Gedcoms";
$pgv_lang["research_log"]		= "Research Log";
$pgv_lang["administration"]		= "Administration";
$pgv_lang["ansi_to_utf8"]		= "Convert this ANSI (ISO-8859-1) encoded GEDCOM to UTF-8?";
$pgv_lang["utf8_to_ansi"]		= "Do you want to convert this GEDCOM from UTF-8 to ANSI (ISO-8859-1)?";
$pgv_lang["user_manual"]		= "PhpGedView User Manual";
$pgv_lang["upgrade"]			= "Upgrade PhpGedView/ResearchLog";
$pgv_lang["view_logs"]			= "View logfiles";
$pgv_lang["step1"]				= "Step 1 of 4:";
$pgv_lang["step2"]				= "Step 2 of 4:";
$pgv_lang["step3"]				= "Step 3 of 4:";
$pgv_lang["step4"]				= "Step 4 of 4:";
$pgv_lang["step5"]				= "Step 5 of 5:";


//-- Relationship chart messages
$pgv_lang["relationship_chart"]		= "Relationship Chart";
$pgv_lang["person1"]			= "Person 1";
$pgv_lang["person2"]			= "Person 2";
$pgv_lang["no_link_found"]		= "No link from the two individuals could be found.";
$pgv_lang["sibling"]			= "Sibling";
$pgv_lang["follow_spouse"]		= "Check relationships by marriage.";
$pgv_lang["timeout_error"]		= "The script timed out before a relationship could be found.";
$pgv_lang["son"]			= "Son";
$pgv_lang["daughter"]			= "Daughter";
$pgv_lang["brother"]			= "Brother";
$pgv_lang["sister"]			= "Sister";
$pgv_lang["relationship_to_me"]		= "Relationship to Me";
$pgv_lang["next_path"]			= "Find Next Path";
$pgv_lang["show_path"]			= "Show Path";

//-- gedcom edit utility
$pgv_lang["check_delete"]		= "Are you sure you want to delete this gedcom fact?";
$pgv_lang["access_denied"]		= "<b>Access Denied</b><br />You do not have access to this resource.";
$pgv_lang["gedrec_deleted"]		= "GEDCOM record successully deleted.";
$pgv_lang["gedcom_deleted"]		= "GEDCOM [#GED#] successully deleted.";
$pgv_lang["changes_exist"]		= "Changes have been made to this GEDCOM.";
$pgv_lang["accept_changes"]		= "Accept / Reject Changes";
$pgv_lang["show_changes"]		= "This record has been updated.  Click here to show changes.";
$pgv_lang["review_changes"]		= "Review GEDCOM Changes";
$pgv_lang["undo_successful"]		= "Undo Successful";
$pgv_lang["undo"]			= "Undo";
$pgv_lang["view_change_diff"]		= "View Change Diff";
$pgv_lang["changes_occurred"]		= "The following changes occured to this individual:";
$pgv_lang["find_place"]			= "Find Place";
$pgv_lang["close_window"]		= "Close Window";
$pgv_lang["close_window_without_refresh"] = "Close Window Without Reloading";
$pgv_lang["place_contains"]		= "Place Contains:";
$pgv_lang["accept_gedcom"]		= "To reject a change, click the undo link next to it.  To accept all the changes for a gedcom, reimport the gedcom file.";
$pgv_lang["ged_import"]			= "Import Gedcom";
$pgv_lang["now_import"]			= "Now you should import the gedcom records into phpGedView by clicking on the import link below.";
$pgv_lang["add_fact"]			= "Add new fact";
$pgv_lang["add"]			= "Add";
$pgv_lang["custom_event"]		= "Custom Event";
$pgv_lang["update_successful"]		= "Update Successful";
$pgv_lang["add_child"]			= "Add child";
$pgv_lang["add_child_to_family"]	= "Add a child to this family";
$pgv_lang["must_provide"]		= "You must provide a ";
$pgv_lang["delete_person"]		= "Delete this Individual";
$pgv_lang["confirm_delete_person"]	= "Are you sure you want to delete this person from the GEDCOM file?";
$pgv_lang["find_media"]			= "Find Media";
$pgv_lang["set_link"]			= "Set Link";
$pgv_lang["add_source"]			= "Add Source to Fact";
$pgv_lang["add_note"]			= "Add Note to Fact";
$pgv_lang["delete_source"]		= "Delete this Source";
$pgv_lang["confirm_delete_source"]	= "Are you sure you want to delete this source from the GEDCOM file?";
$pgv_lang["add_husb"]			= "Add husband";
$pgv_lang["add_husb_to_family"]		= "Add a husband to this family";
$pgv_lang["add_wife"]			= "Add wife";
$pgv_lang["add_wife_to_family"]		= "Add a wife to this family";
$pgv_lang["find_family"]		= "Find Family";
$pgv_lang["add_new_wife"]		= "Add a new wife";
$pgv_lang["add_new_husb"]		= "Add a new husband";
$pgv_lang["edit_name"]			= "Edit Name";
$pgv_lang["delete_name"]		= "Delete Name";
$pgv_lang["no_temple"]			= "No Temple - Living Ordinance";
$pgv_lang["add_unlinked_person"]	= "Add a New unlinked person";

//-- calendar.php messages
$pgv_lang["on_this_day"]		= "On This Day, in Your History...";
$pgv_lang["in_this_month"]		= "In This Month, in Your History...";
$pgv_lang["year_anniversary"]		= "#year_var# year anniversary";
$pgv_lang["day"]			= "Day:";
$pgv_lang["month"]			= "Month:";
$pgv_lang["anniversary_calendar"]	= "Anniversary Calendar";
$pgv_lang["sunday"]			= "Sunday";
$pgv_lang["monday"]			= "Monday";
$pgv_lang["tuesday"]			= "Tuesday";
$pgv_lang["wednesday"]			= "Wednesday";
$pgv_lang["thursday"]			= "Thursday";
$pgv_lang["friday"]			= "Friday";
$pgv_lang["saturday"]			= "Saturday";
$pgv_lang["viewday"]			= "View Day";
$pgv_lang["viewmonth"]			= "View Month";
$pgv_lang["all_people"]			= "All People";
$pgv_lang["living_only"]		= "Living People";
$pgv_lang["recent_events"]		= "Recent Events (&lt; 100 yrs)";

//-- upload media messages
$pgv_lang["upload_media"]		= "Upload Media Files";
$pgv_lang["media_file"]			= "Media File";
$pgv_lang["thumbnail"]			= "Thumbnail";
$pgv_lang["upload_successful"]		= "Upload Successfull";

//-- user self registration module
$pgv_lang["requestpassword"]		= "Request new password";
$pgv_lang["requestaccount"]		= "Request new user account";
$pgv_lang["register_info_01"]		= "The amount of data that can be publicly viewed on this website may be limited due to applicable law concerning privacy protection. Most people do not want their personal data publicly available on the Internet. It could be misused for spam or identity theft.<br /><br />To gain access to the private data, you must have an account on this website. To gain an account you may register yourself by providing the requested information. After the administrator has checked your registration and approved it, you will be able to login and view the private data.<br /><br />If the relationship privacy is activated you will only be able to access your own close relative's private information after logging in. The administrator can also provide access to database editing, so you can change or add information.<br /><br />NOTE: You only will receive access to the private data if you can prove that you are a close relative of a person in the database.<br /><br />If you are not a close relative you will probably not be given an account, so you should save yourself the trouble.<br />If you need any further support, please use the link below to contact the webmaster.<br /><br />";
$pgv_lang["register_info_02"]		= "";
$pgv_lang["pls_note01"]			= "Please note: The system is case-sensitive!";
$pgv_lang["min6chars"]			= "Password has to contain at least 6 characters";
$pgv_lang["pls_note02"]			= "Please note: Passwords should contain only letters and numbers. Inclusion of other characters in your password may result in inability to access from some systems.";
$pgv_lang["pls_note03"]			= "This email address will be verified before account activation. It will not be displayed on the site. A message will be sent to this Email address with your registration data";
$pgv_lang["emailadress"]		= "Email Address:";
$pgv_lang["pls_note04"]			= "Fields marked with * are mandatory.";
$pgv_lang["pls_note05"]			= "Pending completion of the form on this page and verification of your answers, you will be sent a confirmation message to the email address you specify on this page. Using the confirmation email, you will activate your account; if you fail to activate your account within seven days, it will be purged (you may attempt to register the account again at that time). To use this site, you will need to know your login name and password. You must specify an existing, valid email address on this page in order to receive the account confirmation email.<br /><br />If you encounter an issue in registering an account on this website, please submit a Support Request to the webmaster.";

$pgv_lang["mail01_line01"]		= "Hello #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "A request was made at ( #SERVER_NAME# ) to login with your Email address ( #user_email# ).";
$pgv_lang["mail01_line03"]		= "The following data was used.";
$pgv_lang["mail01_line04"]		= "Please click on the link below and fill in the requested data to verify your Account and Email address.";
$pgv_lang["mail01_line05"]		= "If you didn't request this data you can just delete this message.";
$pgv_lang["mail01_line06"]		= "You won't get any mail again from this system, because the account will be deleted without verification within seven days.";

$pgv_lang["mail01_subject"]		= "Your registration at #SERVER_NAME#";

$pgv_lang["mail02_line01"]		= "Hello Administrator ...";
$pgv_lang["mail02_line02"]		= "A new user made a new user-registration at ( #SERVER_NAME# ).";
$pgv_lang["mail02_line03"]		= "The user received an email with the necessary data to verify their account.";
$pgv_lang["mail02_line04"]		= "As soon as the user has done this verification you will be informed by mail to give this user the permission to login to your site.";

$pgv_lang["mail02_subject"]		= "New registration at #SERVER_NAME#";

$pgv_lang["hashcode"]			= "Verfification code:";
$pgv_lang["thankyou"]			= "Hello #user_fullname# ...<br />Thank you for your registration";
$pgv_lang["pls_note06"]			= "Now you will receive a confirmation email to the email address ( #user_email# ). Using the confirmation email, you will activate your account; if you fail to activate your account within seven days, it will be purged (you can register the account again at that point). To login to this site, you will need to know your login name and password.";

$pgv_lang["registernew"]		= "New Account confirmation";
$pgv_lang["user_verify"]		= "User verification";
$pgv_lang["send"]			= "Send";

$pgv_lang["pls_note07"]			= "Please type in your username, your password and the verification code you received by email from this system to verify your account request.";
$pgv_lang["pls_note08"]			= "The data for the user #user_name# was checked.";

$pgv_lang["mail03_line01"]		= "Hello Administrator ...";
$pgv_lang["mail03_line02"]		= "#newuser[username]# ( #newuser[fullname]# ) has verified the registration data.";
$pgv_lang["mail03_line03"]		= "Please click on the link below to login to your site edit the user and give him the permission to login to your site.";

$pgv_lang["mail03_subject"]		= "New verification at #SERVER_NAME#";

$pgv_lang["pls_note09"]			= "You were identified as a registered user.";
$pgv_lang["pls_note10"]			= "The Administrator has been informed.<br />As soon as he gives you the permission to login you can login with your username and password.";
$pgv_lang["data_incorrect"]		= "Data was not correct!<br />Please try again!";
$pgv_lang["user_not_found"]		= "Could not verify the information you entered.  Please go back and try again.";

$pgv_lang["lost_pw_reset"]		= "Lost password request";

$pgv_lang["pls_note11"]			= "To have your password reset, supply the username and email address for your user account. <br /><br />We will send you a special URL via email, which contains a confirmation hash for your account. By visiting the provided URL, you will be permitted to change your password and login to this site. For reasons of security, you should not provide this confirmation hash to anyone, including the administrators of this site (we won't ask for it).<br /><br />If you require assistance from the administrator of this site, please contact the site administrator.";
$pgv_lang["enter_email"]		= "You must enter an email address.";

$pgv_lang["mail04_line01"]		= "Hello #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "A new password was requested for your username!";
$pgv_lang["mail04_line03"]		= "Recommendation:";
$pgv_lang["mail04_line04"]		= "Now please click on the link below, login with the new Password and change it to keep the integrity of your data secure.";

$pgv_lang["mail04_subject"]		= "Data request at #SERVER_NAME#";

$pgv_lang["pwreqinfo"]			= "Hello...<br /><br />A mail was sent to the email address (#user[email]#) including the new password.<br /><br />Please check your mail account because the mail should be received in the next few minutes.<br /><br />Recommendation:<br /><br />After you have requested the mail you should login to this site with your new password and change it to keep the integrity of your data sequrity.";

$pgv_lang["editowndata"]		= "My Account";
$pgv_lang["savedata"]			= "Save changed data";
$pgv_lang["datachanged"]		= "User data was changed!";
$pgv_lang["datachanged_name"]		= "You may need to relogin with your new username.";
$pgv_lang["myuserdata"]			= "My Account";
$pgv_lang["verified"]			= "User verified himself:";
$pgv_lang["verified_by_admin"]		= "User Approved by Admin:";
$pgv_lang["user_theme"]			= "My Theme";
$pgv_lang["mygedview"]			= "MyGedView";
$pgv_lang["passwordlength"]		= "Password must contain at least 6 characters.";
$pgv_lang["admin_approved"]		= "Your account at #SERVER_NAME# has been approved";
$pgv_lang["you_may_login"]		= " by the site administrator.  You may now login to the PhpGedView Site by going to the link below:";


//-- mygedview page
$pgv_lang["welcome"]			= "Welcome";
$pgv_lang["upcoming_events"]		= "Upcoming Events";
$pgv_lang["chat"]			= "Chat";
$pgv_lang["users_logged_in"]		= "Users Logged In";
$pgv_lang["message"]			= "Send Message";
$pgv_lang["my_messages"]		= "My Messages";
$pgv_lang["date_created"]		= "Date Sent:";
$pgv_lang["message_from"]		= "Email Address:";
$pgv_lang["message_from_name"]		= "Your Name:";
$pgv_lang["message_to"]			= "Message To:";
$pgv_lang["message_subject"]		= "Subject:";
$pgv_lang["message_body"]		= "Body:";
$pgv_lang["no_to_user"]			= "No recipient user was provided.  Cannot continue.";
$pgv_lang["provide_email"]		= "Please provide your email address so that we may contact you in response to this message.  If you do not provide your email address we will not be able to respond to your inquiry.  You email address will not be used in any other way besides responding to this inquiry.";
$pgv_lang["reply"]			= "Reply";
$pgv_lang["message_deleted"]		= "Message Deleted";
$pgv_lang["message_sent"]		= "Message Sent";
$pgv_lang["reset"]			= "Reset";
$pgv_lang["site_default"]		= "Site Default";
$pgv_lang["mygedview_desc"]		= "Your MyGedView page allows you to keep bookmarks of your favorite people, track upcoming events, and collaborate with other PhpGedView users.";
$pgv_lang["no_messages"]		= "You have no pending messages.";
$pgv_lang["clicking_ok"]		= "Clicking OK, will open another window where you may contact #user[fullname]#";
$pgv_lang["my_favorites"]		= "My Favorites";
$pgv_lang["no_favorites"]		= "You have not selected any favorites.  To add an Individual to your favorites, find the details of the individual you want to add and then click on the \"Add to My Favorites\" link or use the ID box below to add an Individual by their ID number.";
$pgv_lang["add_to_my_favorites"]	= "Add to My Favorites";
$pgv_lang["confirm_fav_remove"]		= "Are you sure you want to remove this item from your favorites?";
$pgv_lang["portal"]			= "Portal";
$pgv_lang["invalid_email"]		= "Please enter a valid email address.";
$pgv_lang["enter_subject"]		= "Please enter a message subject.";
$pgv_lang["enter_body"]			= "Please enter some message text before sending.";
$pgv_lang["confirm_message_delete"]	= "Are you sure you want to delete this message?  It cannot be retrieved later.";
$pgv_lang["message_email1"]		= "The following message has been sent to your PhpGedView User account from ";
$pgv_lang["message_email2"]		= "You sent the following message to a PhpGedView User account:";
$pgv_lang["message_email3"]		= "You sent the following message to a PhpGedView administrator:";
$pgv_lang["viewing_url"]		= "This message was sent while viewing the following url: ";
$pgv_lang["messaging2_help"]		= "When you send this message you will receive a copy sent via email to the email address you provided.";
$pgv_lang["random_picture"]		= "Random Picture";
$pgv_lang["message_instructions"]	= "<b>Please Note:</b> Private information of living individuals will only be given to family relatives and close friends.  You will be asked to very your relationship before you will receive any private data.  Sometimes information of dead persons may also be private.  If this is the case, it is because there is not enough information known about the person to determine if they are alive or not and we probaby do not have more information on this person.<br /><br />Before asking a question, please verify that you are inquiring about the correct person by checking dates, places, and close relatives.  If you are submitting changes to the genealogical data, please include the sources where you obtained the data.<br /><br />";

//-- upgrade.php messages
$pgv_lang["upgrade_util"]		= "Upgrade Util";
$pgv_lang["no_upgrade"]			= "There are no files to upgrade.";
$pgv_lang["use_version"]		= "You are using version:";
$pgv_lang["current_version"]		= "Current stable version:";
$pgv_lang["upgrade_download"]		= "Download:";
$pgv_lang["upgrade_tar"]		= "TAR";
$pgv_lang["upgrade_zip"]		= "ZIP";
$pgv_lang["latest"]				= "You are running the latest version of PhpGedView.";
$pgv_lang["location"]			= "Location of upgrade files: ";
$pgv_lang["include"]			= "Include:";
$pgv_lang["options"]			= "Options:";
$pgv_lang["inc_phpgedview"]		= " PhpGedView";
$pgv_lang["inc_languages"]		= " Languages";
$pgv_lang["inc_config"]			= " Configuration file";
$pgv_lang["inc_researchlog"]	= " Researchlog";
$pgv_lang["inc_index"]			= " Index files";
$pgv_lang["inc_themes"]			= " Themes";
$pgv_lang["inc_docs"]			= " Manuals";
$pgv_lang["inc_privacy"]		= " Privacy file(s)";
$pgv_lang["inc_backup"]			= " Create backup";
$pgv_lang["upgrade_help"]		= " Help me";
$pgv_lang["cannot_read"]		= "Cannot read file:";
$pgv_lang["not_configured"]		= "You do not have PhpGedView configured yet.";
$pgv_lang["location_upgrade"]	= "Please fill in the location of your upgrade files.";
$pgv_lang["new_variable"]		= "Found new variable: ";
$pgv_lang["config_open_error"] 		= "There has been error opening the config file.";
$pgv_lang["config_write_error"] 	= "Error!!! Cannot write to the configuration file.";
$pgv_lang["config_update_ok"]		= "Configuration file updated successfully.";
$pgv_lang["config_uptodate"]		= "Your configuration file is up-to-date.";
$pgv_lang["processing"]			= "Processing...";
$pgv_lang["privacy_open_error"] 	= "There has been error opening the file [#PRIVACY_MODULE#].";
$pgv_lang["privacy_write_error"]	= "ERROR!!! Unable to write to the file [#PRIVACY_MODULE#].<br />Make sure write permissions are available to the file.<br />Permissions may be restored once privacy file is written.";
$pgv_lang["privacy_update_ok"]		= "Privacy file: [#PRIVACY_MODULE#] updated successfully.";
$pgv_lang["privacy_uptodate"]		= "Your [#PRIVACY_MODULE#] file is up-to-date.";
$pgv_lang["heading_privacy"]		= "Privacy file(s):";
$pgv_lang["heading_phpgedview"]		= "PhpGedView files:";
$pgv_lang["heading_image"]		= "Image files:";
$pgv_lang["heading_index"] 		= "Index files:";
$pgv_lang["heading_language"]		= "Language files:";
$pgv_lang["heading_theme"]		= "Theme files:";
$pgv_lang["heading_docs"]		= "Manuals:";
$pgv_lang["heading_researchlog"]	= "Research Log files:";
$pgv_lang["heading_researchloglang"]	= "Research Log language files:";
$pgv_lang["copied_success"]		= "copied successfully.";
$pgv_lang["backup_copied_success"]		= "backup file created successfully.";
$pgv_lang["folder_created"]		= "Created folder";
$pgv_lang["process_error"]		= "There is a problem processing the page. A newer version cannot be determined.";

if (file_exists($PGV_BASE_DIRECTORY . "languages/lang.en.extra.php")) require $PGV_BASE_DIRECTORY . "languages/lang.en.extra.php";

?>