<?php
/*=================================================
   charset=utf-8
   Project:	phpGedView
   File:	lang.fr.php
   Author:	John Finlay
   Comments:	French Language file for PHPGedView
   Change Log:	10/1/02 - File Created
		03/2/03 - Update (6 new items and some corrections) by Julien Damon
		28/6/03 - Update (relative to 2.12 specs) by Julien Damon
		18/7/03 - Update (relative to 2.13 specs) by Julien Damon
===================================================*/
# $Id: lang.fr.php,v 1.15.2.1 2004/01/26 22:33:38 yalnifj Exp $
if (preg_match("/lang\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}
//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";

//-- CONFIG FILE MESSAGES
$pgv_lang["error_title"]		= "ERREUR : Impossible d'ouvrir le fichier GEDCOM.";
$pgv_lang["error_header"] 		= "Le fichier GEDCOM $GEDCOM n'existe pas &agrave; l'emplacement indiqu&eacute;.";
$pgv_lang["for_support"]		= "Pour le support et les informations, contacter";
$pgv_lang["build_title"]		= "Construction des fichiers d'index";
$pgv_lang["build_error"]		= "Un nouveau fichier GEDCOM a &eacute;t&eacute; d&eacute;tect&eacute;.";
$pgv_lang["please_wait"]		= "Veuillez patienter pendant que les fichiers d'index sont reconstruits.";
$pgv_lang["choose_gedcom"]		= "Choisir un fichier GEDCOM";
$pgv_lang["username"]			= "Nom d'utilisateur:";
$pgv_lang["password"]			= "Mot de passe:";
$pgv_lang["login"]			= "Connexion";
$pgv_lang["logout"]			= "D&eacute;connexion";
$pgv_lang["admin"]			= "Administration";
$pgv_lang["logged_in_as"]		= "Nom de la connexion:";
$pgv_lang["my_pedigree"]		= "Mon arbre d'ascendance";
$pgv_lang["my_indi"]			= "Mon 'de cujus'";
$pgv_lang["yes"]			= "Oui";
$pgv_lang["no"]				= "Non";
$pgv_lang["add_gedcom"]			= "Ajouter un autre fichier GEDCOM";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Arbre d'ascendance";
$pgv_lang["gen_ped_chart"]		= "Arbre de $PEDIGREE_GENERATIONS g&eacute;n&eacute;rations";
$pgv_lang["generations"]		= "Nbre de g&eacute;n&eacute;rations";
$pgv_lang["view"]			= "Afficher";
$pgv_lang["fam_spouse"]			= "Famille avec le conjoint:";
$pgv_lang["root_person"]		= "ID 'de cujus':&nbsp;";
$pgv_lang["hide_details"]		= "Masquer les d&eacute;tails";
$pgv_lang["show_details"]		= "Afficher les d&eacute;tails";
$pgv_lang["person_links"]		= "Liens vers les arbres, familles, et proches parents de la personne.";
$pgv_lang["zoom_box"]			= "Zoom avant/arri&egrave;re sur cette case.";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Aucun lien n'existe avec une famille";
$pgv_lang["unable_to_find_indi"]	= "Aucun lien n'existe avec un individu";
$pgv_lang["unable_to_find_record"]	= "Aucun lien n'a &eacute;t&eacute; trouv&eacute;";
$pgv_lang["unable_to_find_source"]	= "Aucune source n'a &eacute;t&eacute; trouv&eacute;e";
$pgv_lang["unable_to_find_repo"]	= "Aucun d&eacute;p&ocirc;t d'archives n'a &eacute;t&eacute; trouv&eacute;";
$pgv_lang["repo_name"]			= "D&eacute;p&ocirc;t d'archives&nbsp;:";
$pgv_lang["address"]			= "Adresse&nbsp;:";
$pgv_lang["phone"]			= "T&eacute;l&eacute;phone&nbsp;:";
$pgv_lang["source_name"]		= "Nom de la source&nbsp;:";
$pgv_lang["title"]			= "Titre&nbsp;:";
$pgv_lang["author"]			= "Auteur&nbsp;:";
$pgv_lang["publication"]		= "Publication&nbsp;:";
$pgv_lang["call_number"]		= "Num&eacute;ro de r&eacute;f&eacute;rence&nbsp;:";
$pgv_lang["living"]			= "Vivant";
$pgv_lang["private"]			= "D&eacute;tails priv&eacute;s";
$pgv_lang["birth"]			= "Naissance&nbsp;:";
$pgv_lang["death"]			= "D&eacute;c&egrave;s&nbsp;:";
$pgv_lang["descend_chart"]		= "Arbre de descendance";
$pgv_lang["individual_list"]		= "Liste des individus";
$pgv_lang["family_list"]		= "Liste des familles";
$pgv_lang["source_list"]		= "Liste des sources";
$pgv_lang["place_list"]			= "Liste des lieux";
$pgv_lang["media_list"]			= "Multim&eacute;dia";
$pgv_lang["search"]			= "Recherche";
$pgv_lang["clippings_cart"]		= "Extraction de donn&eacute;es";
$pgv_lang["not_an_array"]		= "N'est pas un tableau";
$pgv_lang["print_preview"]		= "Pr&eacute;visualisation de l'impression";
$pgv_lang["change_lang"]		= "Changer de langue";
$pgv_lang["print"]			= "Imprimer";
$pgv_lang["total_queries"]		= "Requ&ecirc;te(s) sur la base de donn&eacute;es&nbsp;:";
$pgv_lang["back"]			= "Retour";

//-- INDIVIDUAL FILE MESSAGES
$pgv_lang["male"]			= "masculin";
$pgv_lang["female"]			= "f&eacute;minin";
$pgv_lang["temple"]			= "Temple de l'Eglise des Mormons";
$pgv_lang["temple_code"]		= "Code du temple de l'Eglise des Mormons&nbsp;:";
$pgv_lang["status"]			= "Statut";
$pgv_lang["source"]			= "Source&nbsp;:";
$pgv_lang["citation"]			= "Citation&nbsp;:";
$pgv_lang["text"]			= "Texte&nbsp;:";
$pgv_lang["note"]			= "Note&nbsp;:";
$pgv_lang["unrecognized_code"]		= "Code GEDCOM inconnu";
$pgv_lang["indi_info"]			= "Informations de l'individu";
$pgv_lang["pedigree_chart"]		= "Arbre d'ascendance";
$pgv_lang["desc_chart2"]		= "Arbre de descendance";
$pgv_lang["family"]			= "Famille";
$pgv_lang["as_spouse"]			= "Famille <br />de l'individu";
$pgv_lang["as_child"]			= "Famille<br />des parents";
$pgv_lang["view_gedcom"]		= "Afficher les balises GEDCOM";
$pgv_lang["add_to_cart"]		= "Extraire des donn&eacute;es";
$pgv_lang["still_living_error"]		= "Cette personne vit toujours ou n'a pas de date de naissance ou de d&eacute;c&egrave;s connue. Toutes les informations sur les personnes vivantes sont masqu&eacute;es.<br />Pour plus d'informations contacter&nbsp;:&nbsp;";
$pgv_lang["privacy_error"]	    	= "Les d&eacute;tails qui concernent cette personne sont priv&eacute;s.<br />Pour plus d'informations contactez&nbsp;:&nbsp;";
$pgv_lang["name"]			= "Nom&nbsp;:";
$pgv_lang["given_name"]			= "Pr&eacute;nom&nbsp;:";
$pgv_lang["surname"]			= "Nom de famille&nbsp;:";
$pgv_lang["suffix"]			= "Suffixe&nbsp;:";
$pgv_lang["object_note"]		= "Note sur l'objet&nbsp;:";
$pgv_lang["sex"]			= "Sexe&nbsp;:";
$pgv_lang["personal_facts"]		= "Faits et d&eacute;tails personnels";
$pgv_lang["type"]			= "Type";
$pgv_lang["date"]			= "Date";
$pgv_lang["place_description"]		= "Lieu / Description";
$pgv_lang["parents"] 			= "Parents:";
$pgv_lang["siblings"] 			= "Fr&egrave;re/soeur";
$pgv_lang["father"] 			= "P&egrave;re";
$pgv_lang["mother"] 			= "M&egrave;re";
$pgv_lang["relatives"]			= "Proches parents";
$pgv_lang["child"]			= "Enfant";
$pgv_lang["spouse"]			= "Conjoint";
$pgv_lang["surnames"]			= "Noms de famille";
$pgv_lang["adopted"]			= "Adopt&eacute;";
$pgv_lang["foster"]			= "Parrain";
$pgv_lang["sealing"]			= "Scellement";
$pgv_lang["link_as"]			= "Relier cette personne &agrave; une famille existante comme&nbsp;";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Informations de la famille";
$pgv_lang["family_group_info"]		= "Informations sur la famille";
$pgv_lang["husband"]			= "Epoux";
$pgv_lang["wife"]			= "Epouse";
$pgv_lang["marriage"]			= "Mariage&nbsp;:";
$pgv_lang["lds_sealing"]		= "C&eacute;r&eacute;monie de l'Eglise des Mormons&nbsp;:";
$pgv_lang["marriage_license"]		= "Autorisation l&eacute;gale de mariage&nbsp;:";
$pgv_lang["media_object"]		= "Objet multim&eacute;dia&nbsp;:";
$pgv_lang["children"]			= "Enfants";
$pgv_lang["no_children"]		= "Aucun enfant connu";
$pgv_lang["parents_timeline"]		= "Afficher les parents sur<br /> le diagramme chronologique";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Extraction de donn&eacute;es";
$pgv_lang["clip_explaination"]		= "Vous pouvez extraire des informations de l'arbre g&eacute;n&eacute;alogique en s&eacute;lectionnant des parties de cet arbre et en cr&eacute;ant un fichier GEDCOM que vous t&eacute;l&eacute;chargerez.<br /><br />";
$pgv_lang["item_with_id"]		= "El&eacute;ment avec son identificateur";
$pgv_lang["error_already"]		= "a d&eacute;j&agrave; &eacute;t&eacute; s&eacute;lectionn&eacute;.";
$pgv_lang["which_links"]		= "Quels autres parents de cette famille souhaitez-vous ajouter&nbsp;?";
$pgv_lang["just_family"]		= "Ajouter seulement cette famille.";
$pgv_lang["parents_and_family"]		= "Ajouter les parents avec cette famille.";
$pgv_lang["parents_and_child"]		= "Ajouter les parents et les enfants avec la famille.";
$pgv_lang["parents_desc"]		= "Ajouter les parents et tous les descendants avec la famille.";
$pgv_lang["continue"]			= "Poursuivre la s&eacute;lection";
$pgv_lang["which_p_links"]		= "Quels autres parents de cette personne souhaitez-vous ajouter&nbsp;?";
$pgv_lang["just_person"]		= "Ajouter seulement cette personne.";
$pgv_lang["person_parents_sibs"]	= "Ajouter cette personne, ses parents, ses fr&egrave;res et soeurs.";
$pgv_lang["person_ancestors"]		= "Ajouter cette personne et ses ascendants.";
$pgv_lang["person_ancestor_fams"]	= "Ajouter cette personne, ses ascendants et leurs familles.";
$pgv_lang["person_spouse"]		= "Ajouter cette personne, son conjoint et les enfants.";
$pgv_lang["person_desc"]		= "Ajouter cette personne, son conjoint et toute leur descendance.";
$pgv_lang["unable_to_open"]		= "Impossible d'ouvrir le fichier pour l'extraction";
$pgv_lang["person_living"]		= "Cette personne est vivante. Les d&eacute;tails personnels ne seront pas inclus.";
$pgv_lang["person_private"]		= "Les d&eacute;tails qui concernent cette personne sont priv&eacute;s. Les d&eacute;tails personnels ne seront pas inclus.";
$pgv_lang["download"]			= "Faire un 'clic droit' (contr&ocirc;le-clic sur Macintoch) sur le lien ci-dessous et s&eacute;lectionnez &quot;Enregistrer la cible sous...&quot; pour t&eacute;l&eacute;charger le fichier.";
$pgv_lang["media_files"]		= "Fichiers multim&eacute;dias r&eacute;f&eacute;renc&eacute;s dans ce fichier GEDCOM";
$pgv_lang["cart_is_empty"]		= "Votre s&eacute;lection est vide.";
$pgv_lang["id"]				= "Identificateur";
$pgv_lang["name_description"]		= "Nom / Description";
$pgv_lang["remove"]			= "Retirer";
$pgv_lang["empty_cart"]			= "Vider la s&eacute;lection";
$pgv_lang["download_now"]		= "T&eacute;l&eacute;charger maintenant";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "lien(s) trouv&eacute;(s) avec ces lieux. <br />Afficher le r&eacute;sultat maintenant.";
$pgv_lang["top_level"]			= "Niveau sup&eacute;rieur";
$pgv_lang["form"]			= "Les lieux sont class&eacute;s dans cet ordre&nbsp;:";
$pgv_lang["default_form"]		= "Pays, d&eacute;partement/r&eacute;gion, commune";
$pgv_lang["unknown"]			= "Inconnu";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]		= "Liste des objets multim&eacute;dias";
$pgv_lang["media_found"]		= "objets multim&eacute;dias trouv&eacute;s";
$pgv_lang["view_person"]		= "Afficher la personne";
$pgv_lang["view_family"]		= "Afficher la famille";
$pgv_lang["view_source"]		= "Afficher la source";
$pgv_lang["prev"]			= "< Pr&eacute;c&eacute;dent";
$pgv_lang["next"]			= "Suivant >";
$pgv_lang["file_not_found"]		= "Fichier non trouv&eacute;.";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]		= "Recherche dans le fichier GEDCOM";
$pgv_lang["enter_terms"]		= "Entrez vos crit&egrave;res de recherche&nbsp;:";
$pgv_lang["soundex_search"]		= "Recherche du nom par la m&eacute;thode SOUNDEX&nbsp;:";
$pgv_lang["search_results"]		= "R&eacute;sultat de la recherche";
$pgv_lang["sources"]			= "SOURCES";
$pgv_lang["firstname_search"]		= "Pr&eacute;nom&nbsp;:";
$pgv_lang["lastname_search"]		= "Nom&nbsp;:";
$pgv_lang["search_place"]		= "Lieu&nbsp;:";
$pgv_lang["search_year"]		= "Ann&eacute;e&nbsp;:";
$pgv_lang["lastname_empty"]		= "Veuillez entrer un nom de famille.";
$pgv_lang["no_results"]			= "Recherche infructueuse.";
$pgv_lang["soundex_results"]		= "Les correspondances Soundex suivantes pr&eacute;sentent un int&eacute;r&ecirc;t.";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]		= "Sources trouv&eacute;es";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Information sur la source";
$pgv_lang["other_records"]		= "Autres enregistrements li&eacute;s &agrave; cette source&nbsp;:";
$pgv_lang["people"]			= "INDIVIDUS";
$pgv_lang["families"]			= "FAMILLES";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]		= "Cr&eacute;ation des index pour les individus et les familles";
$pgv_lang["building_index"]		= "Construction de la liste des index";
$pgv_lang["importing_records"]		= "Import d'enregistrements dans la base de donn&eacute;es";
$pgv_lang["detected_change"]		= "phpGedView a d&eacute;tect&eacute; une modification du fichier GEDCOM $GEDCOM.  Les fichiers index doivent &ecirc;tre reconstruits avant de continuer.";
$pgv_lang["please_be_patient"]		= "VEUILLEZ PATIENTER";
$pgv_lang["reading_file"]		= "Lecture du fichier GEDCOM";
$pgv_lang["flushing"]			= "Purge du fichier";
$pgv_lang["found_record"]		= "enregistrement(s) trouv&eacute;(s)";
$pgv_lang["exec_time"]			= "Temps total d'ex&eacute;cution&nbsp;:";
$pgv_lang["unable_to_create_index"]	= "Impossible de cr&eacute;er l'index.<br />Assurez-vous que la permission d'&eacute;crire dans le r&eacute;pertoire phpGedView existe.";
$pgv_lang["indi_complete"]		= "La mise &agrave; jour de l'index des individus est termin&eacute;e.";
$pgv_lang["family_complete"]		= "La mise &agrave; jour de l'index des familles est termin&eacute;e.";
$pgv_lang["source_complete"]		= "La mise &agrave; jour de l'index des sources est termin&eacute;e.";
$pgv_lang["tables_exist"]		= "Les tables PHPGedView existent d&eacute;j&agrave; dans la base de donn&eacute;es";
$pgv_lang["you_may"]			= "Vous pouvez:";
$pgv_lang["drop_tables"]		= "Supprimer les tables existantes";
$pgv_lang["import_multiple"]		= "Importer vos donn&eacute;es et fonctionner avec plusieurs fichiers GEDCOM";
$pgv_lang["explain_options"]		= "Si vous choisissez de supprimer les tables tout leur contenu actuel sera remplac&eacute; par les donn&eacute;es de ce GEDCOM.<br />Si vous choisissez d'ajouter ce GEDCOM et de fonctionner avec plusieurs GEDCOMs, phpGedView effacera toutes les donn&eacute;es qui ont &eacute;t&eacute; introduites &agrave; partir d'un nom de fichier GEDCOM identique. Cette option vous permet d'enregistrer plusieurs fichiers GEDCOM dans les m&ecirc;mes tables et de passer facilement d'un fichier &agrave; l'autre.";
$pgv_lang["path_to_gedcom"]		= "Entrer le chemin d'acc&egrave;s &agrave; votre fichier GEDCOM:";
$pgv_lang["gedcom_title"]		= "Entrer un titre descriptif des donn&eacute;es de ce fichier GEDCOM:";
$pgv_lang["dataset_exists"]		= "Un fichier GEDCOM de m&ecirc;me nom a d&eacute;j&agrave; &eacute;t&eacute; introduit dans la base de donn&eacute;es.";
$pgv_lang["empty_dataset"]		= "Voulez-vous vider le fichier?";
$pgv_lang["index_complete"]		= "Index cr&eacute;&eacute;.";
$pgv_lang["click_here_to_go_to_pedigree_tree"] = "Cliquer ici pour acc&egrave;der &agrave; l'arbre g&eacute;n&eacute;alogique.";
$pgv_lang["updating_is_dead"]		= "Mise &agrave; jour '&eacute;tat d&eacute;c&eacute;d&eacute;' pour INDI";
$pgv_lang["import_complete"]		= "Import termin&eacute;";
$pgv_lang["updating_family_names"]	= "Mise &agrave; jour des noms de famille pour FAM";
$pgv_lang["processed_for"]		= "Fichier trait&eacute; pour";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= " familles";
$pgv_lang["total_indis"]		= " individus";
$pgv_lang["starts_with"]		= "Commence par&nbsp;:";
$pgv_lang["person_list"]		= "Liste des individus&nbsp;:";
$pgv_lang["paste_person"]		= "Ajouter la personne";
$pgv_lang["notes_sources_media"]	= "Notes, sources et m&eacute;dias";
$pgv_lang["name_contains"]		= "Le nom contient:";
$pgv_lang["filter"]			= "Filtre";
$pgv_lang["find_individual"]		= "Chercher l'individu (ID)";
$pgv_lang["skip_surnames"]		= "Ne pas afficher la liste des noms";
$pgv_lang["show_surnames"]		= "Afficher les listes de noms";
$pgv_lang["all"]			= "TOUS";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "&acirc;ge&nbsp;:";
$pgv_lang["timeline_title"]		= "Diagramme chronologique de phpGedView";
$pgv_lang["timeline_chart"]		= "Diagramme chronologique";
$pgv_lang["remove_person"]		= "Retirer cette personne";
$pgv_lang["show_age"]			= "Afficher le marqueur d'ge";
$pgv_lang["add_another"]		= "Ajoutez une autre personne au diagramme&nbsp;: <br />IDentificateur de la personne&nbsp;:";
$pgv_lang["find_id"]			= "Rechercher l'IDentificateur";
$pgv_lang["show"]			= "Afficher";
$pgv_lang["year"]			= "Ann&eacute;e&nbsp;:";
$pgv_lang["timeline_instructions"]	= "Avec les navigateurs les plus r&eacute;cents, vous pouvez cliquer sur les cadres et les faire glisser.";
$pgv_lang["zoom_in"]			= "Zoom avant";
$pgv_lang["zoom_out"]			= "Zoom arri&egrave;re";

//-- MONTH NAMES
$pgv_lang["jan"]			= "Janvier";
$pgv_lang["feb"]			= "F&eacute;vrier";
$pgv_lang["mar"]			= "Mars";
$pgv_lang["apr"]			= "Avril";
$pgv_lang["may"]			= "Mai";
$pgv_lang["jun"]			= "Juin";
$pgv_lang["jul"]			= "Juillet";
$pgv_lang["aug"]			= "Ao&ucirc;t";
$pgv_lang["sep"]			= "Septembre";
$pgv_lang["oct"]			= "Octobre";
$pgv_lang["nov"]			= "Novembre";
$pgv_lang["dec"]			= "D&eacute;cembre";
$pgv_lang["abt"]			= "vers";
$pgv_lang["aft"]			= "apr&egrave;s";
$pgv_lang["and"]			= "et";
$pgv_lang["bef"]			= "avant";
$pgv_lang["bet"]			= "entre";
$pgv_lang["cal"]			= "date calcul&eacute;e";
$pgv_lang["est"]			= "date estim&eacute;e";
$pgv_lang["from"]			= "de";
$pgv_lang["int"]			= "interpr&eacute;t&eacute;e";
$pgv_lang["to"]				= "&agrave;";
$pgv_lang["cir"]			= "circa";
$pgv_lang["apx"]			= "approx.";

//-- Admin File Messages
$pgv_lang["select_an_option"]		= "Choisir l'une des options ci-dessous:";
$pgv_lang["readme_documentation"]	= "Lire la documentation README";
$pgv_lang["configuration"]		= "Configuration";
$pgv_lang["rebuild_indexes"]		= "Reconstruire les index";
$pgv_lang["user_admin"]			= "Administration des utilisateurs";
$pgv_lang["user_created"]		= "Nouvel utilisateur ajout&eacute; avec succ&egrave;s.";
$pgv_lang["user_create_error"]		= "Impossible d'ajouter cet utilisateur. Revenir en arri&egrave;re et r&eacute;-essayer.";
$pgv_lang["password_mismatch"]		= "Mot de passe sans correspondance.";
$pgv_lang["enter_username"]		= "Vous devez entrer un nom d'utilisateur.";
$pgv_lang["enter_fullname"]		= "Vous devez entrer un pr&eacute;nom et un nom.";
$pgv_lang["enter_password"]		= "Vous devez entrer un mot de passe.";
$pgv_lang["confirm_password"]		= "Vous devez confirmer le mot de passe.";
$pgv_lang["update_user"]		= "Mise &agrave; jour de l'utilisateur";
$pgv_lang["save"]			= "Sauvegarder";
$pgv_lang["delete"]			= "Supprimer";
$pgv_lang["edit"]			= "Modifier";
$pgv_lang["full_name"]			= "Pr&eacute;nom et nom";
$pgv_lang["can_admin"]			= "Droit d'administrer";
$pgv_lang["can_edit"]			= "Droit de modifier";
$pgv_lang["confirm_user_delete"]	= "Etes-vous certain de vouloir supprimer cet utilisateur?";
$pgv_lang["create_user"]		= "Ajouter un utilisateur";
$pgv_lang["no_login"]			= "Authentification de l'utilisateur impossible.";
$pgv_lang["import_gedcom"]		= "Importer un fichier GEDCOM";
$pgv_lang["duplicate_username"]		= "Utilisateur d&eacute;j&agrave; existant.  Un utilisateur existe d&eacute;j&agrave; sous ce nom.  Veuillez retourner &agrave; la page pr&eacute;c&eacute;dente et choisir un autre nom.";
$pgv_lang["gedcomid"]			= "Gedcom INDI pour l'identificateur(ID)";
$pgv_lang["enter_gedcomid"]		= "Vous devez entrer un identificateur(ID) Gedcom.";
$pgv_lang["user_info"]			= "Mes informations personnelles";
$pgv_lang["rootid"]			= "ID du 'de cujus'";
$pgv_lang["download_gedcom"]		= "T&eacute;l&eacute;charger le fichier Gedcom sur votre syst&egrave;me";
$pgv_lang["upload_gedcom"]		= "Charger le fichier Gedcom sur le serveur";
$pgv_lang["gedcom_file"]		= "Fichier Gedcom&nbsp;:";
$pgv_lang["upload_error"]		= "Une erreur est survenue lors du chargement de votre fichier gedcom sur le serveur.";
$pgv_lang["upload_help"]		= "S&eacute;lectionner un fichier local sur votre ordinateur afin de le charger sur le serveur. Celui-ci remplacera automatiquement votre fichier gedcom et vous dirigera vers la reconstruction de l'index.";
$pgv_lang["file_success"]		= "Fichier charg&eacute; avec succ&egrave;s";
$pgv_lang["file_too_big"]		= "Le fichier charg&eacute; d&eacute;passe la taille autoris&eacute;e";
$pgv_lang["file_partial"]		= "Fichier re&ccedil;u partiellement. Veuillez recommencer.";
$pgv_lang["file_missing"]		= "Fichier non re&ccedil;u. Veuillez recommencer.";
$pgv_lang["manage_gedcoms"]		= "G&eacute;rer les fichiers Gedcom";
$pgv_lang["show_phpinfo"]		= "Afficher PHPInfo";
$pgv_lang["research_log"]		= "Rechercher dans le journal";
$pgv_lang["administration"]		= "Administration";

//-- Relationship chart messages
$pgv_lang["relationship_chart"]		= "Tableau des liens de parent&eacute;";
$pgv_lang["person1"]			= "Personne no. 1";
$pgv_lang["person2"]			= "Personne no. 2";
$pgv_lang["no_link_found"]		= "Aucun lien n'a &eacute;t&eacute; trouv&eacute; entre les deux individus.";
$pgv_lang["sibling"]			= "Fr&egrave;re/Soeur";
$pgv_lang["follow_spouse"]		= "V&eacute;rifier les liens par mariage.";
$pgv_lang["timeout_error"]		= "La recherche s'est achev&eacute;e avant qu'un lien de parent&eacute; ne soit trouv&eacute;.";
$pgv_lang["son"]			= "Fils";
$pgv_lang["daughter"]			= "Fille";
$pgv_lang["brother"]			= "Fr&egrave;re";
$pgv_lang["sister"]			= "Soeur";

//-- gedcom edit utility
$pgv_lang["check_delete"]		= "Etes-vous certain de vouloir supprimer cet enregistrement GEDCOM ?";
$pgv_lang["access_denied"]		= "<b>Acc&egrave;s interdit</b><br />Vous n'avez pas acc&egrave;s cette ressource";
$pgv_lang["gedrec_deleted"]		= "Enregistrement GEDCOM supprim&eacute; avec succ&egrave;s.";
$pgv_lang["changes_exist"]		= "Ce fichier GEDCOM a &eacute;t&eacute; modifi&eacute;.";
$pgv_lang["accept_changes"]		= "Accepter / Rejeter les modifications";
$pgv_lang["show_changes"]		= "Cet enregistrement a &eacute;t&eacute; mise &agrave; jour. Cliquer ici pour afficher les modifications.";
$pgv_lang["review_changes"]		= "Revoir les modifications GEDCOM";
$pgv_lang["undo_successful"]		= "Annulation r&eacute;ussie";
$pgv_lang["undo"]			= "Annuler";
$pgv_lang["view_change_diff"]		= "Voir les diff&eacute;rences";
$pgv_lang["changes_occurred"]		= "Les modifications suivantes ont &eacute;t&eacute; faites pour cet individu:";
$pgv_lang["find_place"]			= "Trouver le lieu";
$pgv_lang["close_window"]		= "Fermer la fen&ecirc;tre";
$pgv_lang["place_contains"]		= "Le lieu contient:";
$pgv_lang["accept_gedcom"]		= "Pour rejeter une modification, cliquer sur le lien 'Annuler' affich&eacute; &agrave; c&ocirc;t&eacute;. Pour accepter tous les changements faits sur le fichier, importer &agrave; nouveau le fichier.";
$pgv_lang["ged_import"]			= "Importer un fichier Gedcom";
$pgv_lang["now_import"]			= "Maintenant vous devez importer les enregistrements gedcom dans phpGedView en cliquant sur le lien ci-dessous.";
$pgv_lang["add_fact"]			= "Ajouter un nouvel enregistrement";
$pgv_lang["add"]			= "Ajouter";
$pgv_lang["custom_event"]		= "Ev&eacute;nement personnalis&eacute;";
$pgv_lang["update_successful"]		= "Mise &agrave; jour r&eacute;ussie";
$pgv_lang["add_child"]			= "Ajouter un enfant";
$pgv_lang["add_child_to_family"]	= "Ajouter un enfant &agrave; cette famille";
$pgv_lang["must_provide"]		= "Vous devez fournir un";
$pgv_lang["delete_person"]		= "Supprimer cet individu";
$pgv_lang["confirm_delete_person"]	= "Confirmez-vous la suppression de cette personne dans le fichier GEDCOM?";
$pgv_lang["find_media"]			= "Rechercher un m&eacute;dia";
$pgv_lang["set_link"]			= "Mettre un lien";
$pgv_lang["add_source"]			= "Ajouter une source &agrave; l'enregistrement";
$pgv_lang["add_note"]			= "Ajouter une note &agrave; l'enregistrement";
$pgv_lang["delete_source"]		= "Supprimer cette source";
$pgv_lang["confirm_delete_source"]	= "Voulez-vous vraiment supprimer cette source du fichier GEDCOM?";
$pgv_lang["add_husb"]			= "Ajouter un &eacute;poux";
$pgv_lang["add_husb_to_family"]		= "Ajouter un &eacute;poux &agrave; cette famille";
$pgv_lang["add_wife"]			= "Ajouter une &eacute;pouse";
$pgv_lang["add_wife_to_family"]		= "Ajouter une &eacute;pouse &agrave; cette famille";
$pgv_lang["find_family"]		= "Chercher la famille";
$pgv_lang["add_new_wife"]		= "Ajouter une nouvelle &eacute;pouse";
$pgv_lang["add_new_husb"]		= "Ajouter un nouvel &eacute;poux";
$pgv_lang["edit_name"]			= "Modifier le nom";
$pgv_lang["delete_name"]		= "Supprimer le nom";

//-- calendar.php messages
$pgv_lang["on_this_day"]		= "Ce jour-l&agrave; dans l'histoire de votre famille...";
$pgv_lang["year_anniversary"]		= "#year_var# anniversaire";
$pgv_lang["day"]			= "Jour:";
$pgv_lang["month"]			= "Mois:";
$pgv_lang["anniversary_calendar"] 	= "Calendrier anniversaire";
$pgv_lang["sunday"]			= "Dimanche";
$pgv_lang["monday"]			= "Lundi";
$pgv_lang["tuesday"]			= "Mardi";
$pgv_lang["wednesday"]			= "Mercredi";
$pgv_lang["thursday"]			= "Jeudi";
$pgv_lang["friday"]			= "Vendredi";
$pgv_lang["saturday"]			= "Samedi";
$pgv_lang["viewday"]			= "Afficher le jour";
$pgv_lang["viewmonth"]			= "Afficher le mois";
$pgv_lang["all_people"]			= "Tous les individus";
$pgv_lang["living_only"]		= "Les personnes vivantes";
$pgv_lang["recent_events"]		= "Ev&eacute;nements r&eacute;cents (< 100 ans)";

//-- upload media messages
$pgv_lang["upload_media"]		= "T&eacute;l&eacute;charger des fichiers multim&eacute;dias sur le serveur";
$pgv_lang["media_file"]			= "Fichier multim&eacute;dia";
$pgv_lang["thumbnail"]			= "Vignette";
$pgv_lang["upload_successful"]		= "T&eacute;l&eacute;chargement correctement termin&eacute;";

//-- user self registration module
$pgv_lang["requestpassword"]		= "Demande de nouveau mot de passe";
$pgv_lang["requestaccount"]		= "Demande de nouveau compte d'utilisateur";
$pgv_lang["pls_note01"]			= "Merci de noter que le syst&egrave;me distingue majuscules et minuscules!";
$pgv_lang["min6chars"]			= "Le mot de passe doit comprendre au moins 6 caract&egrave;res";
$pgv_lang["pls_note02"]			= "Merci de noter que le mot de passe ne doit contenir que des lettres et des chiffres. L'ajout d'autres caract&egrave;res peut conduire &agrave; une impossibilit&eacute; d'acc&egrave;s avec certains syst&egrave;mes.";
$pgv_lang["pls_note03"]			= "Cette adresse courriel doit &ecirc;tre v&eacute;rifi&eacute;e avant d'activer le compte. Elle ne sera pas affich&eacute;e sur le site. Vous recevrez un message &agrave; cette adresse avec les informations d'enregistrement de votre compte.";
$pgv_lang["emailadress"]		= "Adresse courriel:";
$pgv_lang["pls_note04"]			= "Les champs marqu&eacute;s d'un * doivent obligatoirement &ecirc;tre renseign&eacute;s.";
$pgv_lang["pls_note05"]			= "En attente de la fin du formulaire d'enregistrement et de la v&eacute;rification de vos r&eacute;ponses, un message de confirmation sera envoy&eacute; &agrave; l'adresse que vous indiquez sur cette page. Par le message de confirmation, vous pourrez activer votre compte; si l'activation n'est pas faite dans les sept prochains jours, il sera annul&eacute; (vous devrez refaire son enregistrement). Pour utiliser ce site, vous devez conna&icirc;tre votre identificateur de connexion et votre mot de passe. Vous devez indiquer une adresse courriel valide sur cette page afin de recevoir un message de confirmation.<br /><br />En cas de probl&egrave;me d'enregistrement d'un compte sur ce site, merci de soumettre votre demande au webmestre.";

$pgv_lang["mail01_line01"]		= "Bonjour #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "Une demande a &eacute;t&eacute; adress&eacute;e &agrave; ( $HOME_SITE_URL ) pour une connexion avec votre adresse courriel ( #user_email# ).";
$pgv_lang["mail01_line03"]		= "Les informations suivantes ont &eacute;t&eacute; utilis&eacute;es.";
$pgv_lang["mail01_line04"]		= "Merci de cliquer sur le lien ci-dessous et de renseigner les champs demand&eacute;s pour v&eacute;rifier votre compte et l'adresse courriel.";
$pgv_lang["mail01_line05"]		= "Si vous n'avez pas demand&eacute; ces informations vous pouvez supprimer ce message.";
$pgv_lang["mail01_line06"]		= "Vous ne recevrez plus de messages de ce syst&egrave;me parce que ce compte sera supprim&eacute; sans v&eacute;rification dans sept jours.";
$pgv_lang["mail01_subject"]		= "Votre inscription sur $HOME_SITE_URL";

$pgv_lang["mail02_line01"]		= "Bonjour &agrave; l'administrateur ...";
$pgv_lang["mail02_line02"]		= "Un nouvel utilisateur s'est inscrit sur ( $HOME_SITE_URL ).";
$pgv_lang["mail02_line03"]		= "L'utilisateur a re&ccedil;u un message avec les informations n&eacute;cessaires &agrave; la v&eacute;rification de son compte.";
$pgv_lang["mail02_line04"]		= "D&egrave;s que l'utilisateur aura fait la v&eacute;rification vous serez inform&eacute; par message afin que vous puissiez l'autoriser &agrave; se connecter &agrave; votre site.";
$pgv_lang["mail02_subject"]		= "Nouvelle inscription sur $HOME_SITE_URL";

$pgv_lang["hashcode"]			= "Code de v&eacute;rification:";
$pgv_lang["thankyou"]			= "Bonjour #user_fullname# ...<br />Merci pour votre inscription";
$pgv_lang["pls_note06"]			= "Vous allez maintenant recevoir un message de confirmation &agrave; l'adresse ( #user_email# ). En utilisant ce message vous pourrez activer votre compte; si vous n'activez pas votre compte avant sept jours, il sera supprim&eacute; (vous pourrez vous enregister &agrave; nouveau dans ce cas). Pour vous connecter au site, votre nom de connexion et votre mot de passe sont n&eacute;cessaires.";

$pgv_lang["registernew"]		= "Confirmation du nouveau compte";
$pgv_lang["user_verify"]		= "V&eacute;rification de l'utilisateur";
$pgv_lang["send"]			= "Envoyer";

$pgv_lang["pls_note07"]			= "Merci d'entrer votre nom d'utilisateur, votre mot de passe et le code de v&eacute;rification que vous avez re&ccedil;u par courriel afin de v&eacute;rifier votre demande de compte.";
$pgv_lang["pls_note08"]			= "Les informations de l'utilisateur #user_name# ont &eacute;t&eacute; contr&ocirc;l&eacute;es.";

$pgv_lang["mail03_line01"]		= "Bonjour &agrave; l'administrateur ...";
$pgv_lang["mail03_line02"]		= "#newuser[username]# ( #newuser[fullname]# ) a v&eacute;rifi&eacute; les informations de son inscription.";
$pgv_lang["mail03_line03"]		= "Merci de cliquer sur le lien ci-dessous pour vous connecter au site et donner &agrave; l'utilisateur l'autorisation de se connecter.";
$pgv_lang["mail03_subject"]		= "Nouvelle v&eacute;rification sur $HOME_SITE_URL";

$pgv_lang["pls_note09"]			= "Vous avez &eacute;t&eacute; identifi&eacute; comme un utilisateur inscrit.";
$pgv_lang["pls_note10"]			= "L'administrateur a &eacute;t&eacute; inform&eacute;.<br />Vous pourrez vous connecter avec votre identificateur de connexion et votre mot de passe d&egrave;s qu'il vous en aura donn&eacute; l'autorisation.";
$pgv_lang["data_incorrect"]		= "Informations incorrectes!<br />Merci de r&eacute;essayer!";
$pgv_lang["user_not_found"]		= "Utilisateur inexistant!";
$pgv_lang["lost_pw_reset"]		= "Demande de mot de passe perdu";
$pgv_lang["pls_note11"]			= "La perte de votre mot de passe est un probl&egrace;me de s&eacute;curit&eacute; s&eacute;rieux. Si vous ne prot&eacute;gez pas votre mot de passe, vous mettez en p&eacute;ril votre compte, vos donn&eacute;es et ce site.<br /><br />Pour restaurer votre mot de passe, fournissez votre nom d'utilisateur PHPGedView sur ce site et l'adresse courriel associ&eacute;e &agrave; ce compte (informations donn&eacute;es au moment de votre inscription, ou modifi&eacute;es ensuite via la page de gestion de votre compte. Apr&egrave;s avoir entr&eacute; ces informations, cliquez sur le bouton #pgv_lang[lost_pw_reset]#.<br /><br />En entrant votre identificateur correct et l'adresse courriel associ&eacute;e, vous recevrez par message un URL sp&eacute;cial qui contiendra un code de confirmation de votre compte. En visitant l'URL fourni, vous pourrez changer votre mot de passe et vous connecter. Par mesure de s&eacute;curit&eacute;, vous ne devez fournir votre code de confirmation &agrave; personne, m&ecirc;me pas aux administrateurs de ce site (nous ne le demanderons pas).<br /><br />Si vous n'&ecirc;tes pas certain de l'adresse courriel que vous avez associ&eacute;e &agrave; ce compte, vous pouvez essayer toutes vos adresses courriel. Le message qui contient le code pour le mot de passe ne sera envoy&eacute; qu'&agrave; l'adresse correspondante, seulement si vous donnez l'identifiant correct et l'adresse associ&eacute;e pour ce compte. Si vous avez besoin d'aide de la part de l'administrateur du site, faites une demande d'assistance.";
$pgv_lang["enter_email"]		= "Vous devez entrer une adresse courriel.";

$pgv_lang["mail04_line01"]		= "Bonjour #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "Un nouveau mot de passe a &eacute;t&eacute demand&eacute; pour votre compte!";
$pgv_lang["mail04_line03"]		= "Recommendation:";
$pgv_lang["mail04_line04"]		= "Cliquez maintenant sur le lien ci-dessous, connectez-vous avec le nouveau mot de passe et changez le pour maintenir l'int&eacute;grit&eacute; de vos donn&eacute;es.";
$pgv_lang["mail04_subject"]		= "Demande d'informations pour $HOME_SITE_URL";

$pgv_lang["pwreqinfo"]			= "Bonjour...<br /><br />Un message a &eacute;t&eacute; envoy&eacute; &agrave; l'adresse (#user[email]#) avec le nouveau mot de passe.<br /><br />Merci de v&eacute;rifier votre messagerie car vous devriez recevoir ce message dans les prochaines minutes.<br /><br />Recommendation:<br /><br />Apr&egrave;s avoir r&eacute;cup&eacute;r&eacute; ce message, connectez-vous &agrave; ce site et changez votre mot de passe pour conserver l'int&eacute;grit&eacute; de vos donn&eacute;es.";

$pgv_lang["editowndata"]		= "Mon compte";
$pgv_lang["savedata"]			= "Sauvegarde des donn&eacute;es modifi&eacute;es";
$pgv_lang["datachanged"]		= "Les donn&eacute;es ont &eacute;t&eacute; modifi&eacute;es!";
$pgv_lang["datachanged_name"]		= "Il vous sera peut-&ecirc;tre n&eacute;cessaire de vous reconnecter avec votre nouvel identificateur.";
$pgv_lang["myuserdata"]			= "Mon compte";
$pgv_lang["verified"]			= "V&eacute;rification par l'utilisateur:";
$pgv_lang["verified_by_admin"]		= "Utilisateur approuv&eacute; par l'administrateur:";
$pgv_lang["user_theme"]			= "Mon th&egrave;me";
$pgv_lang["mygedview"]			= "MonGedView";
$pgv_lang["passwordlength"]		= "Le mot de passe doit contenir au moins 6 caract&egrave;res.";

//-- mygedview page
$pgv_lang["welcome"]			= "Bienvenue";
$pgv_lang["upcoming_events"]		= "Prochains anniversaires d'&eacute;v&eacute;nements";
$pgv_lang["chat"]			= "Discussion";
$pgv_lang["users_logged_in"]		= "Utilisateurs connect&eacute;s";
$pgv_lang["message"]			= "Envoi de message";
$pgv_lang["my_messages"]		= "Mes messages";
$pgv_lang["date_created"]		= "Date d'envoi:";
$pgv_lang["message_from"]		= "Message de:";
$pgv_lang["message_to"]			= "Message &agrave;:";
$pgv_lang["message_subject"]		= "Objet:";
$pgv_lang["message_body"]		= "Texte:";
$pgv_lang["no_to_user"]			= "Pas de destinataire. Impossible de continuer.";
$pgv_lang["provide_email"]		= "Merci d'indiquer votre adresse courriel pour vous contacter en r&eacute;ponse &agrave; ce message. Sans adresse courriel, nous ne pouvons pas vous r&eacute;pondre. Votre adresse ne sera utilis&eacute;e que pour faire cette r&eacute;ponse.";
$pgv_lang["reply"]			= "R&eacute;ponse";
$pgv_lang["message_deleted"]		= "Message supprim&eacute;";
$pgv_lang["message_sent"]		= "Message envoy&eacute;";
$pgv_lang["reset"]			= "Restaurer";
$pgv_lang["site_default"]		= "Par d&eacute;faut pour le site";
$pgv_lang["mygedview_desc"]		= "Votre page MonGedView vous permet de conserver des liens favoris pour certains individus, de suivre les prochains anniversaires d'&eacute;v&eacute;nements, et d'&eacute;changer avec d'autres utilisateurs de cette base de donn&eacute;es PhpGedView.";
$pgv_lang["no_messages"]		= "Vous n'avez pas de messages en attente.";
$pgv_lang["clicking_ok"]		= "En cliquant sur OK, vous ouvrirez une autre fen&ecirc;tre o&ugrave; vous pourrez contacter #user[fullname]#";
$pgv_lang["my_favorites"]		= "Mes favoris";
$pgv_lang["no_favorites"]		= "Vous n'avez pas s&eacute;lectionn&eacute; de favoris. Pour ajouter un individu &agrave; vos favoris, recherchez les informations d&eacute;taill&eacute;es de l'individu que vous souhaitez ajouter et cliquez sur le lien 'Ajouter &agrave; mes favoris' ou utilisez la case ID ci-dessous pour coder un IDentificateur d'individu.";
$pgv_lang["add_to_my_favorites"] 	= "Ajouter &agrave; mes favoris";
$pgv_lang["confirm_fav_remove"]		= "Etes-vous certain de vouloir retirer cette ligne de vos favoris?";
$pgv_lang["portal"]			= "Portail";
$pgv_lang["invalid_email"]		= "Merci de fournir une adresse courriel valide.";
$pgv_lang["enter_subject"]		= "Merci d'entrer l'objet du message.";
$pgv_lang["enter_body"]			= "Merci d'entrer un texte de message avant de faire l'envoi.";
$pgv_lang["confirm_message_delete"]	= "Etes-vous certain de vouloir supprimer ce message?  Il ne sera pas possible de le retrouver apr&egrave;s sa suppression.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]		= "Configuration de l'acc&egrave;s aux donn&eacute;es priv&eacute;es";
$pgv_lang["PRIV_PUBLIC"]		= "accessible au public";
$pgv_lang["PRIV_USER"]			= "accessible seulement aux utilisateurs autoris&eacute;s";
$pgv_lang["PRIV_NONE"]			= "accessible seulement aux administrateurs";
$pgv_lang["save_changed_settings"]	= "Sauvegarder les valeurs modifi&eacute;es";
$pgv_lang["add_new_pp_setting"]		= "Ajouter une nouvelle valeur pour [\$person_privacy]";
$pgv_lang["add_new_up_setting"]		= "Ajouter une nouvelle valeur pour [\$user_privacy]";
$pgv_lang["add_new_gf_setting"]		= "Ajouter une nouvelle valeur pour [\$global_facts]";
$pgv_lang["add_new_pf_setting"]		= "Ajouter une nouvelle valeur pour [\$person_facts]";

if (file_exists($PGV_BASE_DIRECTORY . "languages/lang.fr.extra.php")) require $PGV_BASE_DIRECTORY . "languages/lang.fr.extra.php";

?>