<?php
/*=================================================
   charset=utf-8
   Project:	phpGedView
   File:	lang.no.php
   Author:	John Finlay
   Translator:	Geir Håkon Eikland
   Comments:	Norwegian Language file for PHPGedView
   Change Log:	See LANG_CHANGELOG.txt
===================================================*/
# $Id: lang.no.php,v 1.3.2.2 2004/01/29 18:29:26 yalnifj Exp $

if (preg_match("/lang\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["page_help"]			= "Hjelp";

//-- CONFIG FILE MESSAGES
$pgv_lang["error_title"]		= "FEIL: kan ikke åpne GEDCOM filen";
$pgv_lang["error_header"] 		= "GEDCOM filen, $GEDCOM, finnes ikke på det angitte stedet.";
$pgv_lang["for_support"]		= "For hjelp og informasjon kontakt";
$pgv_lang["for_contact"]		= "For hjelp med slektsspørsmål kontakt";
$pgv_lang["for_all_contact"]	= "For hjelp og slektsspørsmål, kontakt";
$pgv_lang["build_title"]		= "Bygger opp indeksfiler";
$pgv_lang["build_error"]		= "En ny GEDCOM fil er funnet.";
$pgv_lang["please_wait"]		= "Vent litt - Indeksfilene bygges opp igjen.";
$pgv_lang["choose_gedcom"]		= "Velg et GEDCOM datasett";
$pgv_lang["username"]			= "Brukernavn:";
$pgv_lang["password"]			= "Passord:";
$pgv_lang["login"]				= "Logg inn";
$pgv_lang["login_aut"]			= "Endre bruker-konto";
$pgv_lang["logout"]				= "Logg ut";
$pgv_lang["admin"]				= "Administrasjon";
$pgv_lang["logged_in_as"]		= "Logget på som ";
$pgv_lang["my_pedigree"]		= "Mitt slektstre";
$pgv_lang["my_indi"]			= "Mitt IndividID";
$pgv_lang["yes"]				= "Ja";
$pgv_lang["no"]					= "Nei";
$pgv_lang["add_gedcom"]			= "Legg til en gedcomfil";
$pgv_lang["no_support"]			= "Vi har oppdaget at nettleseren din ikke støtter funksjoner på denne siden. De fleste nettlesere støtter dette i nyere versjoner. Vennligst oppgrader nettleser din til en nyere versjon.";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Slektstre";
$pgv_lang["gen_ped_chart"]		= "#PEDIGREE_GENERATIONS# generasjoners slektstre";
$pgv_lang["generations"]		= "Generasjoner";
$pgv_lang["view"]				= "Vis";
$pgv_lang["fam_spouse"]			= "Familie med partner:";
$pgv_lang["root_person"]		= "Hoved ID:";
$pgv_lang["hide_details"]		= "Skjul detaljer";
$pgv_lang["show_details"]		= "Vis detaljer";
$pgv_lang["person_links"]		= "Link til slekts/etterkommer-trær, familie(r), og nære slektninger til denne person.";
$pgv_lang["zoom_box"]			= "Zoom denne boksen inn/ut";
$pgv_lang["portrait"]			= "Portrett";
$pgv_lang["landscape"]			= "Landskap";
$pgv_lang["start_at_parents"]	= "Gå til foreldre";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Kan ikke finne familien med id ";
$pgv_lang["unable_to_find_indi"]	= "Kan ikke finne personen med id ";
$pgv_lang["unable_to_find_record"]	= "Kan ikke finne posten med id ";
$pgv_lang["unable_to_find_source"]	= "Kan ikke finne kilden med id ";
$pgv_lang["unable_to_find_repo"]	= "Kan ikke finne Database med id ";
$pgv_lang["repo_name"]			= "Databasens navn:";
$pgv_lang["address"]			= "Adresse:";
$pgv_lang["phone"]				= "Tlf:";
$pgv_lang["source_name"]		= "Kildenavn:";
$pgv_lang["title"]				= "Tittel:";
$pgv_lang["author"]				= "Forfatter:";
$pgv_lang["publication"]		= "Publikasjon:";
$pgv_lang["call_number"]		= "Arkivnummer:";
$pgv_lang["living"]				= "Lever";
$pgv_lang["private"]			= "Privat";
$pgv_lang["birth"]				= "Født:";
$pgv_lang["death"]				= "Død:";
$pgv_lang["descend_chart"]		= "Etterkommere";
$pgv_lang["individual_list"]	= "Personliste";
$pgv_lang["family_list"]		= "Familieliste";
$pgv_lang["source_list"]		= "Kildeliste";
$pgv_lang["place_list"]			= "Stedsnavn";
$pgv_lang["media_list"]			= "MultiMedia liste";
$pgv_lang["search"]				= "Søke";
$pgv_lang["clippings_cart"]		= "Familietre utklippsmappe";
$pgv_lang["not_an_array"]		= "Ikke en tabell";
$pgv_lang["print_preview"]		= "Forhåndsvisning av utskrift";
$pgv_lang["change_lang"]		= "Change language";
$pgv_lang["print"]				= "Skriv ut";
$pgv_lang["total_queries"]		= "Antall Database oppslag:";
$pgv_lang["back"]				= "Tilbake";

//-- INDIVDUAL FILE MESSAGES
$pgv_lang["male"]				= "Mann";
$pgv_lang["female"]				= "Kvinne";
$pgv_lang["temple"]				= "LDS Temple";
$pgv_lang["temple_code"]		= "LDS Temple Code:";
$pgv_lang["status"]				= "Status";
$pgv_lang["source"]				= "Kilde:";
$pgv_lang["citation"]			= "Bilde:";
$pgv_lang["text"]				= "Tekst:";
$pgv_lang["note"]				= "Note:";
$pgv_lang["unrecognized_code"]	= "Ukjent GEDCOM kode";
$pgv_lang["indi_info"]			= "Person-informasjon";
$pgv_lang["pedigree_chart"]		= "Slektstre";
$pgv_lang["desc_chart2"]		= "Etterkommere";
$pgv_lang["family"]				= "Familie";
$pgv_lang["as_spouse"]			= "Familie med ektefelle/partner";
$pgv_lang["as_child"]			= "Familie med foreldre";
$pgv_lang["view_gedcom"]		= "Vis GEDCOM post";
$pgv_lang["add_to_cart"]		= "Legg til i utklippsmappen";
$pgv_lang["still_living_error"]	= "Personen lever enda og vil ikke ha personlige datoer registrert. Alle detaljer om levende personer er skjult for offentligheten.<br />For ytterligere informasjon kontakt:";
$pgv_lang["privacy_error"]		= "Detaljer om denne person er privat.<br />";
$pgv_lang["more_information"]	= "For mere informasjon, kontakt:";
$pgv_lang["name"]				= "Navn:";
$pgv_lang["given_name"]			= "Fornavn:";
$pgv_lang["surname"]			= "Etternavn:";
$pgv_lang["suffix"]				= "Initialer:";
$pgv_lang["object_note"]		= "Objekt Notat:";
$pgv_lang["sex"]				= "Kjønn:";
$pgv_lang["personal_facts"]		= "Personlige fakta og detaljer";
$pgv_lang["type"]				= "Type";
$pgv_lang["date"]				= "Dato";
$pgv_lang["place_description"]	= "Sted / Beskrivelse";
$pgv_lang["parents"] 			= "Foreldre:";
$pgv_lang["siblings"] 			= "Søsken";
$pgv_lang["father"] 			= "Far";
$pgv_lang["mother"] 			= "Mor";
$pgv_lang["relatives"]			= "Nære slektninger";
$pgv_lang["child"]				= "Barn";
$pgv_lang["spouse"]				= "Ektefelle/partner";
$pgv_lang["surnames"]			= "Etternavn";
$pgv_lang["adopted"]			= "Adoptert";
$pgv_lang["foster"]				= "Foster";
$pgv_lang["sealing"]			= "Forsegling";
$pgv_lang["link_as"]			= "Knytt denne person til en eksisterende familie som ";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Familieinformasjon";
$pgv_lang["family_group_info"]	= "Familiegruppe-informasjon";
$pgv_lang["husband"]			= "Ektemann:";
$pgv_lang["wife"]				= "Hustru:";
$pgv_lang["marriage"]			= "Bryllup:";
$pgv_lang["lds_sealing"]		= "LDS Sealing:";
$pgv_lang["marriage_license"]	= "Ekteskapsattest:";
$pgv_lang["media_object"]		= "Multimedieobjekt:";
$pgv_lang["children"]			= "Barn";
$pgv_lang["no_children"]		= "Ingen barn";
$pgv_lang["parents_timeline"]	= "Vis foreldre på<br />en tidslinje";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Utklippsmappe";
$pgv_lang["clip_explaination"]	= "Familietreets utklippsmappe gir deg muligheten til å ta 'utklipp' fra dette familietre og samle disse i en enkelt GEDCOM fil, som kan downloades.<br /><br />";
$pgv_lang["item_with_id"]		= "Objekt med id";
$pgv_lang["error_already"]		= "finnes fra før i utklippsmappen.";
$pgv_lang["which_links"]		= "Hvilken link fra denne familie vil du legge til?";
$pgv_lang["just_family"]		= "Legg til kun denne familie-posten.";
$pgv_lang["parents_and_family"]	= "Legg til foreldrene til denne familie-posten.";
$pgv_lang["parents_and_child"]	= "Legg til foreldre og barn til denne familie-posten.";
$pgv_lang["parents_desc"]		= "Legg til foreldre og alle etterkommere til denne familie-posten.";
$pgv_lang["continue"]			= "Fortsett med å legge til";
$pgv_lang["which_p_links"]		= "Hvilke linker fra denne person vil du legge til?";
$pgv_lang["just_person"]		= "Legg kun til denne person.";
$pgv_lang["person_parents_sibs"]	= "Legg til denne person, samt foreldre og søsken.";
$pgv_lang["person_ancestors"]		= "Legg til denne person, samt slektninger i direkte linje.";
$pgv_lang["person_ancestor_fams"]	= "Legg til denne person, og slektninger i direkte linje samt deres familier.";
$pgv_lang["person_spouse"]		= "Legg til denne person, samt ektefelle/partner og barn.";
$pgv_lang["person_desc"]		= "Legg til denne person, ektefelle/partner, og alle etterkommere.";
$pgv_lang["unable_to_open"]		= "Kan ikke kopieres til utklippsmappen";
$pgv_lang["person_living"]		= "Denne personen lever fortsatt. Personlige data vises derfor ikke.";
$pgv_lang["person_private"]		= "Denne personens data er privat. Personlige data vises derfor ikke.";
$pgv_lang["family_private"]		= "Detaljer om denne familien er private. Familiedetaljer vises derfor ikke.";
$pgv_lang["download"]			= "Høyreklikk (control-click på Mac) på linken under og Velg 'Lagre som' for å downloade filene.";
$pgv_lang["latest"]				= "Du bruker den nyeste versjonen av phpGedView.";
$pgv_lang["location"]			= "Plassering av oppgraderingsfiler:";
$pgv_lang["include"]			= "Inkluder:";
$pgv_lang["inc_phpgedview"]		= "PhpGedView";
$pgv_lang["inc_languages"]		= "Språk";
$pgv_lang["inc_config"]			= "Konfigurasjonsfil";
$pgv_lang["inc_researchlog"]	= "Forsker-logg";
$pgv_lang["inc_index"]			= "Indeksfiler";
$pgv_lang["inc_themes"]			= "Temaer";
$pgv_lang["inc_docs"]			= "Dokumentasjon";
$pgv_lang["inc_privacy"]		= "Personvern-fil(er)";
$pgv_lang["cannot_read"]		= "Kan ikke lese fil:";
$pgv_lang["not_configured"]		= "Du har ikke konfigurert PhpGedView enda. ";
$pgv_lang["location_upgrade"]	= "Oppgi plassering av dine oppgraderingsfiler.";
$pgv_lang["new_variable"]		= "Ny variable er funnet:";
$pgv_lang["config_open_error"]	= "Det oppstod FEIL under åpning av konfigurasjonsfilen.";
$pgv_lang["config_write_error"] = "FEIL! Det kan ikke skrives til konfigurasjonsfilen.";
$pgv_lang["config_update_ok"]	= "Oppdatering av konfigurasjonsfilen er vellykket.";
$pgv_lang["config_uptodate"]	= "Konfigurasjonsfilen din er oppdatert.";
$pgv_lang["processing"]			= "Arbeider...";
$pgv_lang["privacy_open_error"] = "Det oppstod en feil under åpning av \".\$privacyfile.\" filen.";
$pgv_lang["privacy_write_error"]	= "FEIL! Kan ikke skrive til \".\$privacyfile.\" filen.";
$pgv_lang["privacy_update_ok"]	= "Oppdatering av personvern-filen: \".\$privacyfile.\" vellykket.";
$pgv_lang["privacy_uptodate"]	= "\".\$privacyfile.\" filen er oppdatert.";
$pgv_lang["heading_privacy"]	= "Privatlivsfil(er):";
$pgv_lang["heading_phpgedview"]	= "PhpGedView filer:";
$pgv_lang["heading_image"]		= "Bildefiler:";
$pgv_lang["heading_index"] 		= "Indeksfiler:";
$pgv_lang["heading_language"]	= "Språkfiler:";
$pgv_lang["heading_theme"]		= "Temafiler";
$pgv_lang["heading_docs"]		= "Dokumentasjon:";
$pgv_lang["heading_researchlog"]	= "Forskningslogg-filer:";
$pgv_lang["heading_researchloglang"]	= "Forskningslogg språkfiler:";
$pgv_lang["copied_success"]		= "Kopiering vellykket.";
$pgv_lang["folder_created"]		= "Opprettet mappe";
$pgv_lang["media_files"]		= "Media filer det er referense til i denne GEDCOM";
$pgv_lang["cart_is_empty"]		= "Utklippsmappen din er tom.";
$pgv_lang["id"]					= "ID";
$pgv_lang["name_description"]	= "Navn / Beskrivelse";
$pgv_lang["remove"]				= "Fjern";
$pgv_lang["empty_cart"]			= "Tøm mappen";
$pgv_lang["download_now"]		= "Download nå";
$pgv_lang["indi_downloaded_from"]	= "Denne Personen er hentet fra:";
$pgv_lang["family_downloaded_from"]	= "Denne Familien er hentet fra:";
$pgv_lang["source_downloaded_from"]	= "Denne Kilden er hentet fra:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= " koblinger til stedsnavn funnet<br />- Se på resultatet nå";
$pgv_lang["top_level"]			= "Toppnivå";
$pgv_lang["form"]				= "Stedsnavn vises som: ";
$pgv_lang["default_form"]		= "By/sted/gård, kommune, land";
$pgv_lang["unknown"]			= "Ukjent";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]		= "MultiMedia objektliste";
$pgv_lang["media_found"]		= " media-objekter funnet";
$pgv_lang["view_person"]		= "Vis person";
$pgv_lang["view_family"]		= "Vis familie";
$pgv_lang["view_source"]		= "Vis kilde";
$pgv_lang["prev"]				= "< Forrige";
$pgv_lang["next"]				= "Neste >";
$pgv_lang["file_not_found"]		= "Fant ikke fil.";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]		= "Søk i GEDCOM fil";
$pgv_lang["enter_terms"]		= "Tast inn søkeord:";
$pgv_lang["search_msg"]			= "VENT litt - Søker...";
$pgv_lang["soundex_search"]		= "Lydmalende navnsøking:";
$pgv_lang["search_results"]		= "Søkeresultat(er):";
$pgv_lang["sources"]			= "KILDER";
$pgv_lang["firstname_search"]	= "Fornavn:";
$pgv_lang["lastname_search"]	= "Etternavn:";
$pgv_lang["search_place"]		= "Sted:";
$pgv_lang["search_year"]		= "År:";
$pgv_lang["lastname_empty"]		= "Tast inn etternavn.";
$pgv_lang["no_results"]			= "Intet funnet.";
$pgv_lang["soundex_results"]	= "Du kan kanskje bruke følgende lydmalende resultat.";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["source_list"]		= "Kildeliste";
$pgv_lang["sources_found"]		= " kilder funnet";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Kildeinformasjon";
$pgv_lang["other_records"]		= "Andre poster som refererer til denne kilden:";
$pgv_lang["people"]				= "PERSONER";
$pgv_lang["families"]			= "FAMILIER";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]		= "Lager person- og familie-indeks";
$pgv_lang["building_index"]		= "Lager indekslister";
$pgv_lang["importing_records"]	= "Importerer poster til databasen";
$pgv_lang["detected_change"]	= "phpGedView har oppdaget en endring i GEDCOM fil #GEDCOM#. Indeks filer må bygges opp igjen før du kan fortsette.";
$pgv_lang["please_be_patient"]	= "Vennligst VENT...";
$pgv_lang["reading_file"]		= "Leser inn Gedcom fil";
$pgv_lang["flushing"]			= "Henter ut data";
$pgv_lang["found_record"]		= "Fant post";
$pgv_lang["exec_time"]			= "Utføringstid:";
$pgv_lang["unable_to_create_index"]	= "Indeksfil kan ikke opprettes. Sørg for nødvendige skrive-tillatelser på phpGedView mappen.  Skrivebeskyttelsen kan evt. etableres igjen når indeksfilene er opprettet.";
$pgv_lang["indi_complete"]		= "Oppdatering av personindeksfil er ferdig.";
$pgv_lang["family_complete"]	= "Oppdatering av familieindeksfil er ferdig.";
$pgv_lang["source_complete"]	= "Oppdatering av kildeindeksfil er ferdig.";
$pgv_lang["tables_exist"]		= "PHPGedView tabeller finnes allerede i databasen";
$pgv_lang["you_may"]			= "Du kan:";
$pgv_lang["drop_tables"]		= "Ikke bruk eksisterende tabeller";
$pgv_lang["import_multiple"]	= "Importer, og arbeid med forskjellige gedcom filer";
$pgv_lang["explain_options"]	= "Hvis du velger å ikke bruke tabellene, vil alle data bli hentet fra denne gedcom.<br />Hvis du velger å importere og arbeide med flere gedcom filer samtidig, vil phpGedView slette alle data, som ble importeret fra gedcom fil(er) med samme navn. Dette valget gjør det mulig å legge flere GEDCOM datasett i de samme tabell og lett skifte mellom disse.";
$pgv_lang["path_to_gedcom"]		= "Tast inn stien til din GEDCOM fil:";
$pgv_lang["gedcom_title"]		= "Tast inn en tittel, som beskriver dataene i denne GEDCOM fil:";
$pgv_lang["dataset_exists"]		= "Der er allerede importeret en GEDCOM fil til databasen med dette navnet.";
$pgv_lang["empty_dataset"]		= "Vil du tømme datasettet?";
$pgv_lang["index_complete"]		= "Indeksering ferdig.";
$pgv_lang["click_here_to_go_to_pedigree_tree"] = "Klikk her for å gå til slekstreet.";
$pgv_lang["updating_is_dead"]	= "oppdaterer \"er død\" status for person";
$pgv_lang["import_complete"]	= "Import ferdig";
$pgv_lang["updating_family_names"]	= "Oppdaterer familienavn for FAM";
$pgv_lang["processed_for"]		= "Behandlet fil for ";
$pgv_lang["run_tools"]			= "Vil du utføre en av følgende rutiner på GEDCOM-filen din før den blir importert:";
$pgv_lang["addmedia"]			= "Legg til Media-rutine";
$pgv_lang["dateconvert"]		= "Dato konverterings-rutine";
$pgv_lang["xreftorin"]			= "Konvertere XREF-IDer til RIN-nummer";
$pgv_lang["tools_readme"]		= "Se verktøy/rutine-delen i <a href=\"readme.txt\">readme.txt</a>-filen for mere informasjon.";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= "Totalt antall familier";
$pgv_lang["total_indis"]		= "Totalt antall personer";
$pgv_lang["starts_with"]		= "Starter med:";
$pgv_lang["person_list"]		= "Personliste:";
$pgv_lang["paste_person"]		= "Legg inn person";
$pgv_lang["notes_sources_media"]	= "Noter, kilder, og media";
$pgv_lang["name_contains"]		= "Navn inneholder:";
$pgv_lang["filter"]				= "Søk";
$pgv_lang["find_individual"]	= "Finn person";
$pgv_lang["skip_surnames"]		= "Vis utvidet liste";
$pgv_lang["show_surnames"]		= "Vis kun etternavn";
$pgv_lang["all"]				= "ALLE";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]				= "Alder";
$pgv_lang["timeline_title"]		= "phpGedView tidslinje";
$pgv_lang["timeline_chart"]		= "Tidslinje";
$pgv_lang["remove_person"]		= "Fjern person";
$pgv_lang["show_age"]			= "Vis aldersmarkør";
$pgv_lang["add_another"]		= "Legg til en person til skjemaet:<br />Person ID:";
$pgv_lang["find_id"]			= "Finn ID";
$pgv_lang["show"]				= "Vis";
$pgv_lang["year"]				= "År:";
$pgv_lang["timeline_instructions"]	= "De nyeste nettlesere tillater at man kan klikke og flytte rundt boksene.";
$pgv_lang["zoom_out"]			= "Zoom ut";
$pgv_lang["zoom_in"]			= "Zoom inn";

//-- MONTH NAMES
$pgv_lang["jan"]				= "januar";
$pgv_lang["feb"]				= "februar";
$pgv_lang["mar"]				= "mars";
$pgv_lang["apr"]				= "april";
$pgv_lang["may"]				= "mai";
$pgv_lang["jun"]				= "juni";
$pgv_lang["jul"]				= "juli";
$pgv_lang["aug"]				= "august";
$pgv_lang["sep"]				= "september";
$pgv_lang["oct"]				= "oktober";
$pgv_lang["nov"]				= "november";
$pgv_lang["dec"]				= "desember";
$pgv_lang["abt"]				= "ca.";
$pgv_lang["aft"]				= "etter";
$pgv_lang["and"]				= "og";
$pgv_lang["bef"]				= "før";
$pgv_lang["bet"]				= "mellom";
$pgv_lang["cal"]				= "beregnet";
$pgv_lang["est"]				= "anslått";
$pgv_lang["from"]				= "fra";
$pgv_lang["int"]				= "tolket";
$pgv_lang["to"]					= "til";
$pgv_lang["cir"]				= "cirka";
$pgv_lang["apx"]				= "omtrent";

//-- Admin File Messages
$pgv_lang["select_an_option"]	= "Velg et av følgende valg:";
$pgv_lang["readme_documentation"]	= "README dokumentasjon";
$pgv_lang["configuration"]		= "Konfigurasjon";
$pgv_lang["rebuild_indexes"]	= "Lag indeksene på nytt";
$pgv_lang["user_admin"]			= "Bruker-administrasjon";
$pgv_lang["user_created"]		= "Bruker er opprettet.";
$pgv_lang["user_create_error"]	= "Bruker kan ikke opprettes. Gå tilbake og prøv på nytt.";
$pgv_lang["password_mismatch"]	= "De to passordene er forskjellige.";
$pgv_lang["enter_username"]		= "Du må oppgi et brukernavn.";
$pgv_lang["enter_fullname"]		= "Du må oppgi et fullt navn.";
$pgv_lang["enter_password"]		= "Du må oppgi et passord.";
$pgv_lang["confirm_password"]	= "Du må bekrefte passord.";
$pgv_lang["update_user"]		= "Oppdaterer bruker";
$pgv_lang["delete"]				= "Slett";
$pgv_lang["edit"]				= "Endre";
$pgv_lang["full_name"]			= "Fullt navn";
$pgv_lang["can_admin"]			= "Har Admin rettigheter";
$pgv_lang["can_edit"]			= "Har rettighet til å endre";
$pgv_lang["confirm_user_delete"]	= "Er du sikker på at du vil slette brukeren";
$pgv_lang["create_user"]		= "Opprett bruker";
$pgv_lang["no_login"]			= "Bruker kan ikke godkjennes.";
$pgv_lang["login"]				= "Logg inn";
$pgv_lang["import_gedcom"]		= "Importer en GEDCOM fil";
$pgv_lang["duplicate_username"]	= "!! Det finnes allerede et slikt brukernavn. Gå tilbake og velg et annet brukernavn.";
$pgv_lang["gedcomid"]			= "Gedcom INDI post ID";
$pgv_lang["enter_gedcomid"]		= "Du må oppgi en Gedcom ID.";
$pgv_lang["user_info"]			= "Min brukerinformasjon";
$pgv_lang["research_log"]		= "Forskningslogg";
$pgv_lang["administration"]		= "Administrasjon";
$pgv_lang["ansi_to_utf8"]		= "Konvertere denne ANSI (ISO-8859-1) kodet GEDCOM til UTF-8?";
$pgv_lang["utf8_to_ansi"]		= "Konvertere denne GEDCOM fra UTF-8 til ANSI (ISO-8859-1)?";
$pgv_lang["user_manual"]		= "PhpGedView brukerdokumentasjon";
$pgv_lang["upgrade"]			= "Oppdater phpGedView";
$pgv_lang["manage_gedcoms"]		= "Administrer gedcomfiler";
$pgv_lang["rootid"]				= "Slektstreets hovedID";
$pgv_lang["download_gedcom"]	= "Download Gedcom";
$pgv_lang["upload_gedcom"]		= "Upload Gedcom";
$pgv_lang["add_new_gedcom"]		= "Lag ny gedcomfil";
$pgv_lang["file_exists"]		= "Det finnes allerede en gedcomfil med dette navnet. Velg et annet navn, eller slett den gamle filen.";
$pgv_lang["new_gedcom_title"]	= "Slektstre fra [#GEDCOMFILE#]";
$pgv_lang["enter_filename"]		= "Du må oppgi et GEDCOM filnavn.";
$pgv_lang["gedcom_file"]		= "Gedcom fil:";
$pgv_lang["add_gedcom_instructions"]	= "Tast inn et filnavn for denne nye gedcomfilen. Den nye gedcomfil blir opprettet i index-mappen:";
$pgv_lang["upload_error"]		= "Det oppstod en FEIL under upload av din gedcom fil.";
$pgv_lang["upload_help"]		= "Velg en fil fra din lokale PC som du vil uploade til din server. Denne gedcom fil vil erstatte den nåværende gedcom fil og automatisk føre deg videre til indekseringsavsnittet.";
$pgv_lang["file_success"]		= "Filen er lastet opp";
$pgv_lang["file_too_big"]		= "Opplastet fil overskrider tillatt størrelse";
$pgv_lang["file_partial"]		= "Filen ble kun delvis opplastet, forsøk på nytt";
$pgv_lang["file_missing"]		= "Det ble ikke mottatt noen fil. Hent filen på nytt.";
$pgv_lang["save"]				= "Lagre";
$pgv_lang["view_logs"]			= "Vis logg-filer";

//-- language edit utility

//-- Relationship chart messages
$pgv_lang["relationship_chart"]	= "Slektsskap";
$pgv_lang["person1"]			= "Person 1";
$pgv_lang["person2"]			= "Person 2";
$pgv_lang["no_link_found"]		= "Kan ikke finne noen forbindelse mellom de to personene.";
$pgv_lang["sibling"]			= "Søsken";
$pgv_lang["follow_spouse"]		= "Finn forbindelse via giftemål.";
$pgv_lang["timeout_error"]		= "FEIL: Script fikk timeout før der ble funnet en forbindelse.";
$pgv_lang["son"]				= "Sønn";
$pgv_lang["daughter"]			= "Datter";
$pgv_lang["brother"]			= "Bror";
$pgv_lang["sister"]				= "Søster";
$pgv_lang["relationship_to_me"]	= "Slektsforhold til meg";
$pgv_lang["next_path"]			= "Finn neste sti";
$pgv_lang["show_path"]			= "Vis sti";

//-- gedcom edit utility
$pgv_lang["check_delete"]		= "Er du sikker på at du vil slette disse gedcom dataene?";
$pgv_lang["access_denied"]		= "<b>Adgang nektet</b><br />Du har ikke adgangsrett til denne ressursen.";
$pgv_lang["changes_exist"]		= "Det er gjort endringer i denne GEDCOM.";
$pgv_lang["accept_changes"]		= "Godta/Avvis endringer";
$pgv_lang["gedrec_deleted"]		= "GEDCOM post er nå slettet.";
$pgv_lang["gedcom_deleted"]		= "GEDCOM [#GED#] er nå slettet.";
$pgv_lang["show_changes"]		= "Denne posten er oppdatert. Klikk her for å se endringer.";
$pgv_lang["review_changes"]		= "Vis igjen GEDCOM endringer";
$pgv_lang["undo_successful"]	= "Angring vellykket";
$pgv_lang["undo"]				= "Angre";
$pgv_lang["changes_occurred"]	= "Følgende endringer er gjort for denne person:";
$pgv_lang["find_place"]			= "Finn stedsnavn";
$pgv_lang["close_window"]		= "Lukk vindu";
$pgv_lang["close_window_without_refresh"]	= "Lukk vindu uten skjermoppdatering";
$pgv_lang["view_change_diff"]	= "Vis endring(er), forskjell(er)";
$pgv_lang["place_contains"]		= "Stedsnavn inneholder:";
$pgv_lang["accept_gedcom"]		= "Angre en endring ved å klikke på angre-linken ved siden av endring. Godta alle endringer i gedcom, ved å importere gedcomfilen på nytt.";
$pgv_lang["ged_import"]			= "Importer Gedcom";
$pgv_lang["now_import"]			= "Nå skal du importere gedcomfilens innhold inn i phpGedView ved å klikke på import-linken under.";
$pgv_lang["add_note"]			= "Legg til note i fakta";
$pgv_lang["delete_source"]		= "Slett denne kilden";
$pgv_lang["confirm_delete_source"]	= "Er du sikker på at du vil slette denne kilden fra GEDCOM filen?";
$pgv_lang["add_husb"]			= "Legg til ektemann";
$pgv_lang["add_husb_to_family"]	= "Legg til en far til denne familien";
$pgv_lang["add_wife"]			= "Legg til hustru";
$pgv_lang["add_wife_to_family"]	= "Legg til en hustru/mor til denne familien";
$pgv_lang["find_family"]		= "Finn familie";
$pgv_lang["add_new_wife"]		= "Legg til en ny hustru";
$pgv_lang["add_new_husb"]		= "Legg til en ny ektemann";
$pgv_lang["edit_name"]			= "Rediger navn";
$pgv_lang["delete_name"]		= "Slett navn";
$pgv_lang["no_temple"]			= "No Temple - Living Ordinance";
$pgv_lang["add_source"]			= "Legg til kilden til fakta";
$pgv_lang["set_link"]			= "Lag kobling";
$pgv_lang["find_media"]			= "Finn media";
$pgv_lang["confirm_delete_person"]	= "Er du sikker på at du vil slette denne personen fra gedcomfilen?";
$pgv_lang["must_provide"]		= "Du må ha et ";
$pgv_lang["delete_person"]		= "Slett denne person";
$pgv_lang["update_successful"]	= "Oppdatering vellykket";
$pgv_lang["add_unlinked_person"]	= "Legg til en ukoblet person";
$pgv_lang["add_child_to_family"]	= "Legg til et barn til denne familien";
$pgv_lang["add_child"]			= "Legg til barn";
$pgv_lang["add_fact"]			= "Legg til data";
$pgv_lang["add"]				= "Legg til";
$pgv_lang["custom_event"]		= "Endre begivenhet";
$pgv_lang["upload_successful"]	= "Upload vellykket";

//-- user self registration module
$pgv_lang["requestpassword"]	= "Bestille nytt passord";
$pgv_lang["requestaccount"]		= "Bestille ny brukerkonto";
$pgv_lang["register_info_01"]	= "Hvor mye data som kan vise offentlig på denne vevsiden kan være begrenset i henhold til lov om personvern. Mange personer vil ikke at deres personlige data ligger åpent på Internett. Det kan bli misbrukt til  spam eller identitetstyver.<br /><br />For å få tilgang på private data, må du ha en konto på denne vedsiden. For å få en konto kan du registere deg ved å fylle ut nødvendig informasjon. Etter at administratoren har sjekket registreringen din og godkjent den, vil du kunne logge deg inn og se private data.<br /><br />Dersom slektsskaps-personvern er aktivert vil du etter å ha logget deg inn, bare få tilgang til din nærmeste slekts private opplysning. Administratoren kan også gi deg tilgang til å gjøre endringer eller legge til informasjon i databasen.<br /><br />NB: Du vil også få tilgang til de private dataene dersom du kan bevise at du er nær slektning til en i databasen.<br /><br />Hvis du ikke er en nær slektning vil nok ikke kunne få tilgang, og du kan spare deg å bryet med å prøve.<br />Dersom du trenger mer support, kan du bruke linken under til å kontakte vevansvarlig.<br /><br />";
$pgv_lang["register_info_02"]	= "";
$pgv_lang["pls_note01"]			= "NB: Systemet skiller mellem store og små bokstaver!";
$pgv_lang["min6chars"]			= "Passord må inneholde minst 6 tegn";
$pgv_lang["pls_note02"]			= "NB: Passordet må kun inneholde bokstaver og tall. Andre tegn kan resultere i at man ikke kan få adgang på visse system.";
$pgv_lang["pls_note03"]			= "Denne e-post-adresse undersøkes før en konto aktiveres. E-post-adressen vises ikke på dette siden. Du vil få tilsendt en e-post til denne adressen, med dine registreringsdata.";
$pgv_lang["emailadress"]		= "E-post-adresse:";
$pgv_lang["pls_note04"]			= "Felt er som er markeret med * må fylles ut.";
$pgv_lang["pls_note05"]			= "Vedr. fullføringen av skjemaet på denne siden og verifisering av dine svar, vil du få tilsendt en bekreftelse til den e-post-adressen du har opplyst her. Ved hjelp av denne e-posten kan du aktivere din konto. Hvis du ikke aktiverer kontoen innen syv dager, vil kontoen bli slettet (på dette tidspunkt kan du så opprette kontoen igjen). For å kunne bruke denne siden, har du bruk for ditt brukernavn og passord. Du må oppgi en eksisterende og gyldig e-postadresse for å kunne motta en e-post med bekreftelse på kontoen.<br /><br />Hvis du får problemer i forbindelse med å opprette en konto her, så gi vevansvarlig beskjed om det.";
$pgv_lang["mail01_line01"]		= "Hei #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "En forespørsel er gjort på ( #SERVER_NAME# ) om å få brukerID med din e-post-adresse ( #user_email# ).";
$pgv_lang["mail01_line03"]		= "Følgende data ble brukt.";
$pgv_lang["mail01_line04"]		= "Vennligst klikk på linken under og fyll ut med de riktige data for å bekrefte din konto og e-post-adresse.";
$pgv_lang["mail01_line05"]		= "Dersom du ikke har bedt om å få en konto, kan du bare slette denne e-posten.";
$pgv_lang["mail01_line06"]		= "Du vil ikke få tilsendt ytterligere e-poster herfra, fordi kontoen i mangel av din bekreftelse vil bli slettet etter syv dager.";
$pgv_lang["mail01_subject"]		= "Din registrering hos #SERVER_NAME#";
$pgv_lang["mail02_line01"]		= "Hei administrator ...";
$pgv_lang["mail02_line02"]		= "En ny bruker har registreret seg hos ( #SERVER_NAME# ).";
$pgv_lang["mail02_line03"]		= "Brukeren har fått tilsendt en e-post med de nødvendige data for å bekrefte ønske om konto.";
$pgv_lang["mail02_subject"]		= "Ny registrering hos #SERVER_NAME#";
$pgv_lang["mail02_line04"]		= "Så snart brukeren har foretatt denne bekreftelsen, får du beskjed pr. e-post om å gi denne bruker tillatelse til login på din side.";
$pgv_lang["hashcode"]			= "Kontrollkode";
$pgv_lang["thankyou"]			= "Hei #user_fullname# ...<br />Takk for din registrering";
$pgv_lang["pls_note06"]			= "Du vil nå få tilsendt en bekreftelses-e-post til adressen ( #user_email# ). Ved hjelp av denne e-posten kan du aktivere din konto. Hvis du ikke aktiverer din konto innen syv dager, vil den bli slettet (du kan registrere kontoen igjen etter de syv dagene, om du ønsker det). Login til denne siden, krever at du oppgir ditt brukernavn og passord.<br /><br /><br /><br />";
$pgv_lang["registernew"]		= "Bekreftelse av ny konto.";
$pgv_lang["user_verify"]		= "Bruker-godkjenning";
$pgv_lang["pls_note08"]			= "Data for brukeren #user_name# er undersøkt.";
$pgv_lang["send"]				= "Send";
$pgv_lang["pls_note07"]			= "Tast inn ditt brukernavn, ditt passord og den kontrollkode du fikk tilsendt pr. e-post, som kontroll av at ønsket om opprettelse av konto kom fra deg.";
$pgv_lang["mail03_line01"]		= "Hei administrator ...";
$pgv_lang["mail03_line02"]		= "#newuser[username]# ( #newuser[fullname]# ) har bekreftet registreringsdata.";
$pgv_lang["mail03_line03"]		= "Klikk på linken under login på siden din, rediger så brukeren og gi vedkommende tillatelse til login på siden din.";
$pgv_lang["mail03_subject"]		= "Ny bekreftelse hos #SERVER_NAME#";
$pgv_lang["pls_note09"]			= "Du er gjenkjent som en registreret bruker.";
$pgv_lang["pls_note10"]			= "Administrator har fått beskjed.<br />Så snart vedkommende har gitt sin tillatelse, kan du logge inn med ditt brukernavn og passord.";
$pgv_lang["pls_note11"]			= "Å glemme eller miste sitt passord er et alvorlig sikkerhetsproblem. Ved å unnlate å beskytte ditt passords integritet, har du risikert å sette din konto og denne sidens sikkerhet over styr.<br /><br />For å få ditt passord nullstilt, må du opplyse ditt phpGedView brukerkontonavn (brukernavn) og den e-post-adresse du opplyste da du opprettet denne brukerkontoen, eller som du senere har endret den til i oppsettet. Klikk på #pgv_lang[lost_pw_reset]#-knappen når denne informasjon er inntastet.<br /><br />Dersom du har tastet inn korrekt brukernavn og tilhørende e-post-adresse, sender vi deg en spesiell link med e-post, som inneholder en kontrollkode til din konto. Ved å benytte denne linken, får du mulighet til å endre ditt passord og login til denne siden. Av sikkerhetsmessige årsaker skal du ikke opplyse denne kontrollkode til noen, og heller ikke denne sides administratorer (Vi vil ikke be om det).<br /><br />Hvis du er usikker på hvilken e-post-adresse du har brukt i forbindelse med denne konto, kan du prøve alle dine e-post-adresser. Kontrollkoden blir kun sendt til den e-postkontoen som er registrert på din konto, og kun hvis du opplyser korrekt brukernavn og e-post-adresse for kontoen.";
$pgv_lang["data_incorrect"]		= "Data var ugyldig!<br />- Prøv igjen!";
$pgv_lang["user_not_found"]		= "Det er ikke funnet en slik bruker!";
$pgv_lang["lost_pw_reset"]		= "Tapt passord forespørsel";
$pgv_lang["enter_email"]		= "Du må taste inn en e-post-adresse.";
$pgv_lang["mail04_line01"]		= "Hei #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "Det ble bestilt et nytt passord til ditt brukernavn!";
$pgv_lang["mail04_line03"]		= "Anbefaling:";
$pgv_lang["mail04_subject"]		= "Data anmodning fra #SERVER_NAME#";
$pgv_lang["pwreqinfo"]			= "Hei...<br /><br />En e-post med det nye passordet ble sendt til e-post-adressen (#user[email]#).<br /><br />Vær vennlig å sjekke din e-post-konto, fordi denne e-posten skulle være framme i løpet av de neste minuttene.<br /><br />Anbefaling:<br /><br />Etter at du har mottatt denne e-post, bør du logge deg inn på denne siden med ditt nye passord og endre det, for derved å bevare integriteten til din datasikkerhet.";
$pgv_lang["mail04_line04"]		= "Vennligst klikk på linken under. Logg inn med det nye Passordet og angi et nytt, for å bevare dine datas integritet.";
$pgv_lang["verified_by_admin"]	= "Bruker godkjent av administrator:";
$pgv_lang["user_theme"]			= "Mitt tema";
$pgv_lang["mygedview"]			= "Min GedView";
$pgv_lang["passwordlength"]		= "Passord må være på minst 6 tegn.";
//$pgv_lang["admin_approved"]	= "Din konto hos http://".$_SERVER["SERVER_NAME"]." er blitt godkjent";
$pgv_lang["admin_approved"]		= "Din konto hos #SERVER_NAME# er blitt godkjent";
$pgv_lang["you_may_login"]		= " av sidens administrator. Du kan nå logge deg på PhpGedView ved å følge linken under:";
$pgv_lang["editowndata"]		= "MinKonto";
$pgv_lang["savedata"]			= "Lagre endrede data";
$pgv_lang["datachanged"]		= "Brukerdata er endret!";
$pgv_lang["datachanged_name"]	= "Det vil evt. være nødvendig å logge inn med ditt nye brukernavn.";
$pgv_lang["myuserdata"]			= "Min konto";
$pgv_lang["verified"]			= "Brukeren godkjenner seg selv:";
$pgv_lang["welcome"]			= "Velkommen";
$pgv_lang["upcoming_events"]	= "Kommende begivenheter";
$pgv_lang["users_logged_in"]	= "Brukere logget inn";
$pgv_lang["chat"]				= "Chat";
$pgv_lang["message"]			= "Send beskjed";
$pgv_lang["my_messages"]		= "Mine beskjeder";
$pgv_lang["message_body"]		= "Selve beskjeden:";
$pgv_lang["provide_email"]		= "Vennligst oppgi din e-post-adresse, så vi kan besvare denne henvendelse. Hvis du ikke oppgir din e-post-adresse, har vi ikke mulig til å besvare denne forespørselen. Din e-post-adresse vil ikke bli brukt til annet enn å besvare denne forespørselen.";
$pgv_lang["message_subject"]	= "Emne:";
$pgv_lang["message_to"]			= "Beskjed til:";
$pgv_lang["date_created"]		= "Dato sendt:";
$pgv_lang["message_from"]		= "Beskjed fra:";
$pgv_lang["message_from_name"]	= "Ditt navn:";
$pgv_lang["date_created"]		= "Dato sendt";
$pgv_lang["no_to_user"]			= "Det ble ikke oppgitt en annen bruker som mottaker. - Kan ikke fortsette.";
$pgv_lang["reply"]				= "Svar";
$pgv_lang["message_deleted"]	= "Beskjed slettet";
$pgv_lang["message_sent"]		= "Beskjed sendt";
$pgv_lang["reset"]				= "Nullstill/tøm";
$pgv_lang["site_default"]		= "Standard side";
$pgv_lang["mygedview_desc"]		= "Min GedView gir deg mulighet til å markere dine personlige favoritter, bli påminnet om kommende begivenheter, og samarbeide med andre phpGedView brukere.";
$pgv_lang["no_messages"]		= "Det er ingen beskjeder til deg.";
$pgv_lang["clicking_ok"]		= "Ved klikk på OK, åpnes det et nytt vindu, der du kan kontakte";
$pgv_lang["my_favorites"]		= "Mine favoritter";
$pgv_lang["no_favorites"]		= "Du har ikke valgt noen favoritter. For å legge til en person til dine favoritter, kan du enten finne vedkommende persons detaljer og deretter klikke på \"Legg til i Mine favoritter\" link eller bruge ID-boksen under for å legge til en person ved hjelp av vedkommendes ID-nummer.";
$pgv_lang["add_to_my_favorites"] = "Legg til i Mine favoritter";
$pgv_lang["confirm_fav_remove"]	= "Er du sikker på at du vil fjerne denne fra dine favoritter?";
$pgv_lang["portal"]				= "Portal";
$pgv_lang["invalid_email"]		= "Tast inn en gyldig e-post-adresse.";
$pgv_lang["enter_subject"]		= "Tast inn en tekst i emnelinjen.";
$pgv_lang["enter_body"]			= "Skriv inn en beskjed/tekst før den sendes.";
$pgv_lang["confirm_message_delete"]	= "Er du sikker på du vil slette denne beskjeden? Når først den er slettet, kan den ikke gjenopprettes igjen.";
$pgv_lang["thumbnail"]			= "Minibilde";
$pgv_lang["upload_media"]		= "Upload mediafiler";
$pgv_lang["media_file"]			= "Mediafil";
$pgv_lang["on_this_day"]		= "På denne dag i din familiehistorie";
$pgv_lang["viewday"]			= "Se dag";
$pgv_lang["viewmonth"]			= "Se måned";
$pgv_lang["all_people"]			= "Alle personer";
$pgv_lang["living_only"]		= "Nålevende personer";
$pgv_lang["recent_events"]		= "Tidligere begivenheter (< 100 år)";
$pgv_lang["monday"]				= "mandag";
$pgv_lang["tuesday"]			= "tirsdag";
$pgv_lang["wednesday"]			= "onsdag";
$pgv_lang["thursday"]			= "torsdag";
$pgv_lang["friday"]				= "fredag";
$pgv_lang["saturday"]			= "lørdag";
$pgv_lang["sunday"]				= "søndag";
$pgv_lang["year_anniversary"]	= "årsdag";
$pgv_lang["day"]				= "Dag:";
$pgv_lang["month"]				= "Måned";
$pgv_lang["anniversary_calendar"] = "Merkedager";


$pgv_lang["message_email1"]		= "Følgende beskjed ble sendt til din PhpGedView Brukerkonto:";
$pgv_lang["message_email2"]		= "Du sendte følgende beskjed til en PhpGedView Brukerkonto:";
$pgv_lang["message_email3"]		= "Du sendte følgende beskjed til PhpGedView administrator:";
$pgv_lang["viewing_url"]		= "Denne beskjed ble sendt fra url:";
$pgv_lang["messaging2_help"]	= "Når du sender denne beskjeden, får du tilsendt en kopi via den e-post-adresse du har oppgitt.";
$pgv_lang["random_picture"]		= "Tilfeldig bilde";
$pgv_lang["message_instructions"]	= "<b>PS:</b> Privat informasjon om levende personer vil bare bli gitt til slektninger og nære venner.  Du vil bli spurt om å bekrefte din tilknytning/slektsskap før du vil få se private data.  Av og til kan informasjon om døde personer også være private.  Hvis dette er tilfelle, er det på grunn av at det ikke funnet nok informasjon om personen til å avgjøre om vedkommende lever eller ikke, eller andre opplysninger om personen.<br /><br />Før du gjør en forspørsel, vennligst sjekk opp at det er riktig person ved å se på datoer, steder og nære slektninger.  Dersom du legger inn endringer i slektsdataene, vær vennlig å oppgi kildene der du fant dataene.<br /><br />";

//-- upgrade.php messages
$pgv_lang["upgrade_util"]		= "Oppgraderingsverktøy";
$pgv_lang["no_upgrade"]			= "Det er ingen filer å oppgradere.";
$pgv_lang["upgrade_download"]	= "Download:";
$pgv_lang["upgrade_tar"]		= "TAR";
$pgv_lang["upgrade_zip"]		= "ZIP";
$pgv_lang["options"]			= "Valg:";
$pgv_lang["inc_backup"]			= " Lag sikkerhetskopi";
$pgv_lang["upgrade_help"]		= " Hjelp meg";
$pgv_lang["use_version"]		= "Du bruker versjon: ";
$pgv_lang["current_version"]	= "Nåværende stabile versjon:";
$pgv_lang["backup_copied_success"]		= "sikkerhetskopiering er ferdig.";
$pgv_lang["process_error"]		= "Det har oppstått et problem med å vise siden. En nyere versjon kan ikke determined.";


if (file_exists($PGV_BASE_DIRECTORY . "languages/lang.no.extra.php")) require $PGV_BASE_DIRECTORY . "languages/lang.no.extra.php";

?>