<?php
/*=================================================
   charset=UTF-8
   Project:	phpGedView
   File:	lang.sv.php
   Author:	John Finlay
   Translation:	Daniel Melander
   Continues
   Translation:	Patrik Hansson
   Comments:	Swedish Language file for PHPGedView.
   		Svensk språkfil för PHPGedView.
   Change Log:	See LANG_CHANGELOG.txt
		2003-06-05 - File Created
		2003-10-30 - Updated to v2.52
		2003-12-05 - Updated to v2.61
		2004-01-13 - Updated to v2.65
===================================================*/
# $Id: lang.sv.php,v 1.24.2.3 2004/02/02 15:18:13 yalnifj Exp $
if (preg_match("/lang\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}
//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["page_help"]			= "Hjälp";

//-- CONFIG FILE MESSAGES
$pgv_lang["error_title"]		= "Fel: Kan inte öppna GEDCOM-filen";
$pgv_lang["error_header"] 		= "GEDCOM-filen, [#GEDCOM#], finns inte på den angiva platsen.";
$pgv_lang["for_support"]		= "För teknisk support och information kontakta";
$pgv_lang["for_contact"]		= "Vid frågor om släkten kontakta";
$pgv_lang["for_all_contact"]		= "Vid tekniska frågor eller frågor om släkten kontakta";
$pgv_lang["build_title"]		= "Skapar Index-filer";
$pgv_lang["build_error"]		= "GEDCOM-filen har blivit uppdaterad.";
$pgv_lang["please_wait"]		= "Var snäll och vänta medan Index-filen återskapas.";
$pgv_lang["choose_gedcom"]		= "Välj ett GEDCOM dataset";
$pgv_lang["username"]			= "Användarnamn:";
$pgv_lang["password"]			= "Lösenord:";
$pgv_lang["login"]			= "Logga in";
$pgv_lang["login_aut"]			= "Ändra användarinställningar";
$pgv_lang["logout"]			= "Logga ut";
$pgv_lang["admin"]			= "Admin";
$pgv_lang["logged_in_as"]		= "Inloggad som";
$pgv_lang["my_pedigree"]		= "Mina anor";
$pgv_lang["my_indi"]			= "Mina fakta";
$pgv_lang["yes"]			= "Ja";
$pgv_lang["no"]				= "Nej";
$pgv_lang["add_gedcom"]			= "Lägg till en ny GEDCOM fil";
$pgv_lang["no_support"]			= "Vi har upptäckt att din webläsare inte stödjer standarden som PhpGedview använder. De flesta nyare webläsare stödjer dessa standarder. Var vänlig och uppdatera din webläsare till en nyare version.";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Antavla";
$pgv_lang["gen_ped_chart"]		= "#PEDIGREE_GENERATIONS# Generationers släktkarta";
$pgv_lang["generations"]		= "Generationer";
$pgv_lang["view"]			= "Visa";
$pgv_lang["fam_spouse"]			= "Familj med make/maka:";
$pgv_lang["root_person"]		= "ID för startperson:";
$pgv_lang["hide_details"]		= "Göm detaljer";
$pgv_lang["show_details"]		= "Visa detaljer";
$pgv_lang["person_links"]		= "Länkar till diagram, familjer och nära släktingar till denna person. Klicka på denna ikon för att visa sidan med denna person som startperson. ";
$pgv_lang["zoom_box"]			= "Zomma in/ut denna ruta";
$pgv_lang["portrait"]			= "Stående";
$pgv_lang["landscape"]			= "Liggande";
$pgv_lang["start_at_parents"]	= "Starta vid föräldrarna";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Kan inte hitta familj med id";
$pgv_lang["unable_to_find_indi"]	= "Kan inte hitta person med id";
$pgv_lang["unable_to_find_record"]	= "Kan inte hitta record med id";
$pgv_lang["unable_to_find_source"]	= "Kan inte hitta källa med id";
$pgv_lang["unable_to_find_repo"]	= "Kan inte hitta databas med id";
$pgv_lang["repo_name"]			= "Namn på databas:";
$pgv_lang["address"]			= "Adress:";
$pgv_lang["phone"]			= "Telefon:";
$pgv_lang["source_name"]		= "Källnamn:";
$pgv_lang["title"]			= "Titel:";
$pgv_lang["author"]			= "Författare:";
$pgv_lang["publication"]		= "Publikation:";
$pgv_lang["call_number"]		= "Telefonnummer:";
$pgv_lang["living"]			= "Lever";
$pgv_lang["private"]			= "Privat";
$pgv_lang["foster"]			= "Fosterbarn";
$pgv_lang["sealing"]			= "Försegling";
$pgv_lang["link_as"]			= "Koppla denna person till en existerande familj som en";
$pgv_lang["birth"]			= "Född:";
$pgv_lang["death"]			= "Död:";
$pgv_lang["descend_chart"]		= "Ättlingar";
$pgv_lang["individual_list"]		= "Personer";
$pgv_lang["family_list"]		= "Familjer";
$pgv_lang["source_list"]		= "Källlor";
$pgv_lang["place_list"]			= "Platser";
$pgv_lang["media_list"]			= "Multimediaobjekt";
$pgv_lang["search"]			= "Sök";
$pgv_lang["clippings_cart"]		= "Familjeträd urklippskorg";
$pgv_lang["not_an_array"]		= "Ingen vektor (Array)";
$pgv_lang["print_preview"]		= "Förhandsgranska";
$pgv_lang["change_lang"]		= "Change language";
$pgv_lang["print"]			= "Skriv ut";
$pgv_lang["back"]			= "Tillbaka";
$pgv_lang["total_queries"]		= "Totalt antal databasfrågor:";

//-- INDIVUDUAL FILE MESSAGES
$pgv_lang["male"]			= "Man";
$pgv_lang["female"]			= "Kvinna";
$pgv_lang["temple"]			= "LDS Tempel";
$pgv_lang["temple_code"]		= "LDS Tempel kod:";
$pgv_lang["status"]			= "Status";
$pgv_lang["source"]			= "Källa:";
$pgv_lang["citation"]			= "Hänvisning:";
$pgv_lang["text"]			= "Text:";
$pgv_lang["note"]			= "Anteckning:";
$pgv_lang["unrecognized_code"]		= "Okänd GEDCOM kod";
$pgv_lang["indi_info"]			= "Individuell information";
$pgv_lang["pedigree_chart"]		= "Antavla";
$pgv_lang["desc_chart2"]		= "Stamtavla";
$pgv_lang["family"]			= "Familj";
$pgv_lang["as_spouse"]			= "Familj med make/maka";
$pgv_lang["as_child"]			= "Familj med föräldrar";
$pgv_lang["view_gedcom"]		= "Visa Gedcompost";
$pgv_lang["add_to_cart"]		= "Lägg till i urklippskorg";
$pgv_lang["still_living_error"]		= "Den här personen lever fortfarande eller har inga döds eller födelsedata angiven.  Alla detaljer om levande personer är gömda för allmän beskådan.<br />För mer information kontakta";
$pgv_lang["privacy_error"]		= "Detaljer om denna personen är skyddade.<br />";
$pgv_lang["more_information"]		= "För mer information kontakta";
$pgv_lang["name"]			= "Namn:";
$pgv_lang["given_name"]			= "Förnamn:";
$pgv_lang["surname"]			= "Efternamn:";
$pgv_lang["suffix"]			= "Mellannamn:";
$pgv_lang["object_note"]		= "Objektnotis:";
$pgv_lang["sex"]			= "Kön:";
$pgv_lang["personal_facts"]		= "Personliga fakta och detaljer";
$pgv_lang["type"]			= "Typ";
$pgv_lang["date"]			= "Datum";
$pgv_lang["place_description"]		= "Plats / Beskrivning";
$pgv_lang["parents"] 			= "Föräldrar:";
$pgv_lang["siblings"] 			= "Syskon";
$pgv_lang["father"] 			= "Far";
$pgv_lang["adopted"]			= "Adopterad";
$pgv_lang["mother"] 			= "Mor";
$pgv_lang["surnames"]			= "Efternamn";
$pgv_lang["relatives"]			= "Släktingar";
$pgv_lang["child"]			= "Barn";
$pgv_lang["spouse"]			= "Maka/Make";


//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Familjeinformation";
$pgv_lang["family_group_info"]		= "Familjens gruppinformation";
$pgv_lang["husband"]			= "Make";
$pgv_lang["wife"]			= "Maka:";
$pgv_lang["marriage"]			= "Äktenskap:";
$pgv_lang["lds_sealing"]		= "LDS försegling:";
$pgv_lang["marriage_license"]		= "Äktenskapsbevis:";
$pgv_lang["media_object"]		= "Multimediaobjekt:";
$pgv_lang["children"]			= "Barn";
$pgv_lang["no_children"]		= "Inga barn";
$pgv_lang["parents_timeline"]		= "Visa föräldrar på<br />tidslinjekartan";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Urklippskorg";
$pgv_lang["clip_explaination"]		= "Famljeurklipskorgen gör det möjligt att göra &quot;urklipp&quot; från detta familjeträd och gruppera ihop dem till en enda GEDCOM-fil för nedladning.<br /><br />";
$pgv_lang["item_with_id"]		= "Urklipp med id";
$pgv_lang["error_already"]		= "finns redan in din urklippskorg.";
$pgv_lang["which_links"]		= "Vilka länkar från denna familj vill du också lägga till?";
$pgv_lang["just_family"]		= "Lägg enbart till denna familj.";
$pgv_lang["parents_and_family"]		= "Lägg till föräldrarna till denna familjs post.";
$pgv_lang["parents_and_child"]		= "Lägg till föräldrar och barn till denna familjs post.";
$pgv_lang["parents_desc"]		= "Lägg till föräldrarna samt alla deras ättlingar till denna familj post.";
$pgv_lang["continue"]			= "Fortsätt lägg till";
$pgv_lang["which_p_links"]		= "Vilka länkar från denna personen vill du också lägga till?";
$pgv_lang["just_person"]		= "Lägg enbart till denna person.";
$pgv_lang["person_parents_sibs"]	= "Lägg till denna person samt föräldrar och syskon.";
$pgv_lang["person_ancestors"]		= "Lägg till denna person samt alla rakt stigande anor.";
$pgv_lang["person_ancestor_fams"]	= "Lägg till denna person samt rakt stigande anor och deras familjer.";
$pgv_lang["person_spouse"]		= "lägg till denna person samt maka och barn.";
$pgv_lang["person_desc"]		= "Lägg till denna person samt maka och alla ättlingars poster.";
$pgv_lang["unable_to_open"]		= "Kan inte öppna urklippskatalogen för skrivning";
$pgv_lang["person_living"]		= "Den här personen lever. Personliga detaljer kommer inte inkluderas.";
$pgv_lang["person_private"]		= "Detaljer om den här personen är privata.  Personliga detaljer kommer inte inkluderas.";
$pgv_lang["family_private"]		= "Detaljerna om familjen är privata. Familjedetaljer kommer inte att inkluderas.";
$pgv_lang["download"]			= "Högerklicka (control-click på en Mac) på länkarna under och välj &quot;Spara mål som&quot; för att ladda ner filerna.";
$pgv_lang["latest"]			= "Du kör senaste versionen av PhpGedView.";
$pgv_lang["location"]			= "Plats för uppgraderingsfiler:";
$pgv_lang["include"]			= "Inkludera:";
$pgv_lang["options"]			= "Inställningar:";
$pgv_lang["inc_phpgedview"]		= "PhpGedView";
$pgv_lang["inc_languages"]		= "Språk";
$pgv_lang["inc_config"]			= "Konfigurationsfil";
$pgv_lang["inc_researchlog"]		= "Forskningslog";
$pgv_lang["inc_index"]			= "Index fil";
$pgv_lang["inc_themes"]			= "Tema";
$pgv_lang["inc_docs"]			= "Manualer";
$pgv_lang["inc_privacy"]		= "Integritetsfil(er)";
$pgv_lang["inc_backup"]			= "Skapa backup";
$pgv_lang["upgrade_help"]		= "Hjälp mig";
$pgv_lang["cannot_read"]		= "Det går inte att läsa filen:";
$pgv_lang["not_configured"]		= "Du har inte konfigurerat PhpGedView än.";
$pgv_lang["location_upgrade"]		= "Fyll i platsen för dina uppgraderingsfiler.";
$pgv_lang["new_variable"]		= "Hittade en ny variabel:";
$pgv_lang["config_open_error"]		= "Det har blivit ett fel vid öppnandet av konfigurationsfilen.";
$pgv_lang["config_write_error"]		= "Fel!!! Kan inte skriva till konfigurationsfilen.";
$pgv_lang["config_update_ok"]		= "Lyckad uppdatering av konfigurationsfilen.";
$pgv_lang["config_uptodate"]		= "Konfigurationsfilen är redan uppdaterad.";
$pgv_lang["processing"]			= "Arbetar...";
$pgv_lang["privacy_open_error"]		= "Det har blivit ett fel vid öppnadet av [#PRIVACY_MODULE#] filen.";
$pgv_lang["privacy_write_error"]	= "FEL!!! Kan inte skriva till filen[#PRVACY_MODULE#].<br />Kontrollera att du har skrivrättigheter för filen.<br />Rättigheterna kan återställas när filen blivit sparad.";
$pgv_lang["privacy_update_ok"]		= "Integritetsfil: [#PRIVACY_MODULE#] uppdaterades korrekt.";
$pgv_lang["privacy_uptodate"]		= "Din [#PRIVACY_MODULE#] filen är uppdaterad.";
$pgv_lang["heading_privacy"]		= "Integritetsfil(er):";
$pgv_lang["heading_phpgedview"]		= "PhpGedView filen:";
$pgv_lang["heading_image"]		= "Bildfiler:";
$pgv_lang["heading_index"] 		= "Indexfiler:";
$pgv_lang["heading_language"]		= "Språkfiler:";
$pgv_lang["heading_theme"]		= "Temafiler:";
$pgv_lang["heading_docs"]		= "Manualer:";
$pgv_lang["heading_researchlog"]	= "Forskningsloggfiler:";
$pgv_lang["heading_researchloglang"]	= "Forskningsloggens språkfiler:";
$pgv_lang["copied_success"]		= "Lyckad kopiering.";
$pgv_lang["backup_copied_success"]		= "Skapandet av backupfilen lyckades.";
$pgv_lang["folder_created"]		= "Skapad mapp";
$pgv_lang["process_error"]		= "Det är problem med att processa sidan. Det går inte att avgöra om det finns en nyare version.";
$pgv_lang["media_files"]		= "Mediafiler refererade till i denna GEDCOM-fil";
$pgv_lang["cart_is_empty"]		= "Urklippskorgen för ditt släktträd är tom.";
$pgv_lang["id"]				= "ID";
$pgv_lang["name_description"]		= "Namn / Beskrivning";
$pgv_lang["remove"]			= "Radera";
$pgv_lang["empty_cart"]			= "Töm urklippskorgen";
$pgv_lang["download_now"]		= "Ladda ner nu";
$pgv_lang["indi_downloaded_from"]	= "Individen nedladdades från:";
$pgv_lang["family_downloaded_from"]	= "Familjen nedladdades från:";
$pgv_lang["source_downloaded_from"]	= "Källan nedladdades från:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "Platslänkar<br />Se länkarna nu";
$pgv_lang["top_level"]			= "Topnivån";
$pgv_lang["form"]			= "Platser är angivna på formen:";
$pgv_lang["default_form"]		= "Gård, by, socken, län";
$pgv_lang["default_form_info"]			= "(Standard)";
$pgv_lang["gedcom_form_info"]			= "(Gedcom)";
$pgv_lang["unknown"]			= "Okänd";
$pgv_lang["individuals"]			= "Individer";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]		= "Lista över Multimediaobjekt";
$pgv_lang["media_found"]		= "Mediaobjekt funna";
$pgv_lang["view_person"]		= "Titta på Person";
$pgv_lang["view_family"]		= "Titta på Familj";
$pgv_lang["view_source"]		= "Titta på källa";
$pgv_lang["prev"]			= "< Föregående";
$pgv_lang["next"]			= "Nästa >";
$pgv_lang["file_not_found"]		= "Filen kunde inte hittas.";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]		= "Sök GEDCOM-fil";
$pgv_lang["enter_terms"]		= "Ange sökkriterier:";
$pgv_lang["soundex_search"]		= "Soundex-namnsökning:";
$pgv_lang["search_results"]		= "Sökresultat";
$pgv_lang["sources"]			= "KÄLLOR";
$pgv_lang["firstname_search"]		= "Förnamn:";
$pgv_lang["lastname_search"]		= "Efternamn:";
$pgv_lang["search_place"]		= "Ort:";
$pgv_lang["search_year"]		= "År:";
$pgv_lang["lastname_empty"]		= "Var snäll ange ett efternamn.";
$pgv_lang["soundex_results"]		= "Kanske kan följande soundex träffar vara till hjälp.";
$pgv_lang["no_results"]			= "Inga resultat funna.";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]		= "Funna källor";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Källinformation";
$pgv_lang["other_records"]		= "Andra poster som länkar till denna källa:";
$pgv_lang["people"]			= "Personer";
$pgv_lang["families"]			= "Familjer";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]		= "Skapar Person och familjeindex";
$pgv_lang["building_index"]		= "Skapar indexlistor";
$pgv_lang["importing_records"]		= "Importerar poster till databasen";
$pgv_lang["detected_change"]		= "PHPGedView upptäckte en förändring i GEDCOM-filen #GEDCOM#. Indexfilerna måste återskapas innan det går att fortsätta.";
$pgv_lang["please_be_patient"]		= "VAR GOD VÄNTA";
$pgv_lang["reading_file"]		= "Läser Gedcomfil";
$pgv_lang["flushing"]			= "Rensar innehållet";
$pgv_lang["found_record"]		= "Hittade poster";
$pgv_lang["exec_time"]			= "Exekveringstid:";
$pgv_lang["unable_to_create_index"]	= "Kan inte att skapa indexfil.  Se till så att du har skrivrättigheter i phpGedView-katalogen.  Rättigheterna kan återställas efter att indexfilerna har skapats.";
$pgv_lang["indi_complete"]		= "Updatering av personindex färdigt.";
$pgv_lang["family_complete"]		= "Updaterig av familjeindex färdigt.";
$pgv_lang["source_complete"]		= "Updatering av källindex färdigt.";
$pgv_lang["tables_exist"]		= "PHPGedView-tabellerna finns redan i databasen";
$pgv_lang["you_may"]			= "Du kan:";
$pgv_lang["drop_tables"]		= "Ta bort nuvarande tabeller";
$pgv_lang["import_multiple"]		= "Importera och arbeta med multipla gedcom-filer";
$pgv_lang["explain_options"]		= "Om du väljer att ta bort tabellerna kommer alla data ersättas med data funna i denna gedcomfil.<br />Om du väljer att importera och arbeta med multipla gedcomfiler kommer phpGedView ta bort alla data som importerades i en eventuell tidigare importerad gedcomfil med samma namn.  Det här valet gör det möjligt att spara data från flera GEDCOMfiler i samma tabeller och enkelt byta mellan dem.";
$pgv_lang["path_to_gedcom"]		= "Ange sökväg till din GEDCOM-fil:";
$pgv_lang["gedcom_title"]		= "Ange en titel som beskriver data i denna GEDCOM-fil:";
$pgv_lang["dataset_exists"]		= "En GEDCOM-fil med detta namn är redan importerad i databasen.";
$pgv_lang["empty_dataset"]		= "Vill du tömma databasen?";
$pgv_lang["index_complete"]		= "Index färdigt.";
$pgv_lang["updating_family_names"]	= "Updaterar familjenamnen för FAM";
$pgv_lang["processed_for"]		= "Bearbetade filen för";
$pgv_lang["run_tools"]				= "Vill du köra något av följande verktyg på din Gedcomfil innan den importeras:";
$pgv_lang["addmedia"]				= "Lägg till mediaverktyg";
$pgv_lang["dateconvert"]			= "Datumkonverteringsverktyg";
$pgv_lang["xreftorin"]				= "Konvertera XREF id till RIN nummer";
$pgv_lang["tools_readme"]			= "Se vertygssektionen för #README.TXT# för att få mer information.";
$pgv_lang["import_complete"]		= "Importen är färdig";
$pgv_lang["click_here_to_go_to_pedigree_tree"] = "Klicka här för att gå till antavlan.";
$pgv_lang["updating_is_dead"]		= "Updaterar \"är död\" status för INDI";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= "Totalt antal familjer";
$pgv_lang["all"]			= "Alla";
$pgv_lang["show_surnames"]		= "Visa efternamnslistan";
$pgv_lang["skip_surnames"]		= "Göm efternamnslistan";
$pgv_lang["total_indis"]		= "Totalt antal personer";
$pgv_lang["starts_with"]		= "Börjar med:";
$pgv_lang["person_list"]		= "Personlista:";
$pgv_lang["paste_person"]		= "Klistra in person";
$pgv_lang["notes_sources_media"]	= "Anteckningar, Källor och Media";
$pgv_lang["name_contains"]		= "Namnet innehåller:";
$pgv_lang["filter"]			= "Filtrera";
$pgv_lang["find_individual"]		= "Sök id för person";
$pgv_lang["find_sourceid"]			= "Hitta källid";


//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "Ålder";
$pgv_lang["timeline_title"]		= "phpGedView tidslinje";
$pgv_lang["timeline_chart"]		= "Tidslinjediagram";
$pgv_lang["remove_person"]		= "Ta bort person";
$pgv_lang["show_age"]			= "Visa åldersmarkering";
$pgv_lang["add_another"]		= "Lägg till en ny person till diagrammet:<br />Person ID:";
$pgv_lang["find_id"]			= "Sök ID";
$pgv_lang["show"]			= "Visa";
$pgv_lang["year"]			= "År:";
$pgv_lang["timeline_instructions"]	= "I de flesta nyare webläsare kan man klicka och dra runt lådorna i diagrammet.";
$pgv_lang["zoom_out"]			= "Zooma ut";
$pgv_lang["zoom_in"]			= "Zooma in";

//-- MONTH NAMES
$pgv_lang["jan"]			= "Januari";
$pgv_lang["feb"]			= "Februari";
$pgv_lang["mar"]			= "Mars";
$pgv_lang["apr"]			= "April";
$pgv_lang["may"]			= "Maj";
$pgv_lang["jun"]			= "Juni";
$pgv_lang["jul"]			= "Juli";
$pgv_lang["aug"]			= "Augusti";
$pgv_lang["sep"]			= "September";
$pgv_lang["oct"]			= "Oktober";
$pgv_lang["nov"]			= "November";
$pgv_lang["dec"]			= "December";
$pgv_lang["abt"]			= "omkring";
$pgv_lang["aft"]			= "efter";
$pgv_lang["and"]			= "och";
$pgv_lang["bef"]			= "före";
$pgv_lang["bet"]			= "mellan";
$pgv_lang["cal"]			= "beräknad";
$pgv_lang["est"]			= "uppskattat";
$pgv_lang["from"]			= "från";
$pgv_lang["int"]			= "tolkat";
$pgv_lang["to"]				= "till";
$pgv_lang["cir"]			= "cirka";
$pgv_lang["apx"]			= "Ungefär";

//-- Admin File Messages
$pgv_lang["select_an_option"]		= "Välj alternativ nedan:";
$pgv_lang["readme_documentation"]	= "README-dokumentation";
$pgv_lang["configuration"]		= "Konfiguration";
$pgv_lang["rebuild_indexes"]		= "Återskapa indexfilerna";
$pgv_lang["user_admin"]			= "Användaradministration";
$pgv_lang["user_created"]		= "Ny användare skapad.";
$pgv_lang["user_create_error"]		= "Går inte att skapa användare.  Var snäll gå tillbaka och försök igen.";
$pgv_lang["password_mismatch"]		= "Lösenorden stämmer inte överens.";
$pgv_lang["enter_username"]		= "Du måste mata in ett användarnamn.";
$pgv_lang["enter_fullname"]		= "Du måste ange användarens hela namn.";
$pgv_lang["enter_password"]		= "Du måste ange ett lösenord.";
$pgv_lang["confirm_password"]		= "Du måste bekräfta lösenordet.";
$pgv_lang["update_user"]		= "Updatera användare";
$pgv_lang["save"]			= "Spara";
$pgv_lang["delete"]			= "Radera";
$pgv_lang["edit"]			= "Ändra";
$pgv_lang["username"]			= "Användare";
$pgv_lang["full_name"]			= "Hela namnet";
$pgv_lang["can_admin"]			= "Kan administrera";
$pgv_lang["can_edit"]			= "Kan ändra";
$pgv_lang["confirm_user_delete"]	= "Är det säkert att du vill ta bort denna användare";
$pgv_lang["create_user"]		= "Skapa ny användare";
$pgv_lang["no_login"]			= "Kan inte logga in användaren.";
$pgv_lang["login"]			= "Logga in";
$pgv_lang["import_gedcom"]		= "Importera en GEDCOM-fil";
$pgv_lang["duplicate_username"]		= "Användarnamn upptaget.  En användare med det användarnamnet finns redan.  Gå tillbaka och välj ett annat namn och försök igen.";

$pgv_lang["gedcomid"]			= "Gedcom INDI post ID";
$pgv_lang["enter_gedcomid"]		= "Du måste ange ett Gedcom ID.";
$pgv_lang["user_info"]			= "'Min användare' information";
$pgv_lang["rootid"]			= "Startperson för antavla";
$pgv_lang["download_gedcom"]		= "Ladda ner Gedcomfil";
$pgv_lang["upload_gedcom"]		= "Ladda upp Gedcomfil";
$pgv_lang["add_new_gedcom"]		= "Skapa ny Gedcom fil";
$pgv_lang["gedcom_file"]		= "Gedcomfil:";
$pgv_lang["enter_filename"]		= "Du måste skriva in ett filnamn för Gedcomfilen";
$pgv_lang["file_exists"]		= "Det finns redan en GEDCOMfil med det filnamnet. Välj ett annat namn eller radera den gamla filen.";
$pgv_lang["new_gedcom_title"]		= "Genealogi från [#GEDCOMFILE#]";
$pgv_lang["upload_error"]		= "Det uppstod ett fel vid uppladdningen av din gedcomfil.";
$pgv_lang["upload_help"]		= "Välj en fil på din lokala dator att ladda upp till servern. Alla filer kommer att laddas upp och sparas i indexkatalogen:";
$pgv_lang["add_gedcom_instructions"]	= "Skriv in ett filnamn för den nya GEDCOM filen. Den nya GEDCOM filen kommer att skapas i Indexmappen:";
$pgv_lang["file_success"]		= "Filen laddades upp utan problem";
$pgv_lang["file_too_big"]		= "Uppladdad fil överskrider max tillåtna storlek";
$pgv_lang["file_partial"]		= "Filen blev endast delvis uppladdad, var god försök igen";
$pgv_lang["research_log"]		= "Forskningslogg";
$pgv_lang["administration"]		= "Administration";
$pgv_lang["ansi_to_utf8"]		= "Konvertera denna ANSI(iso-8859-1) kodade GEDCOM till UTF-8?";
$pgv_lang["utf8_to_ansi"]		= "Vill du konvertera denna GEDCOM från UTF-8 till ANSI(ISO-8859-1)?";
$pgv_lang["user_manual"]		= "PhpGegView användarmanual";
$pgv_lang["upgrade"]			= "Uppgradera PhpGedView";
$pgv_lang["view_logs"]			= "Visa loggfiler";
$pgv_lang["step1"]				= "Steg 1 av 5:";
$pgv_lang["step2"]				= "Steg 2 av 5:";
$pgv_lang["step3"]				= "Steg 3 av 5:";
$pgv_lang["step4"]				= "Steg 4 av 5:";
$pgv_lang["step5"]				= "Steg 5 av 5:";
$pgv_lang["file_missing"]		= "Ingen fil mottogs. Ladda upp filen igen.";
$pgv_lang["manage_gedcoms"]		= "Administrera GEDCOM filer";


//-- Relationship chart messages
$pgv_lang["relationship_chart"]		= "Relationer";
$pgv_lang["person1"]			= "Person 1";
$pgv_lang["person2"]			= "Person 2";
$pgv_lang["no_link_found"]		= "Ingen koppling mellan de två individerna kunde hittas.";
$pgv_lang["sibling"]			= "Syskon";
$pgv_lang["follow_spouse"]		= "Kontrollera förhållanden via giftermål.";
$pgv_lang["timeout_error"]		= "Skriptet tog för lång tid före någon relation kunde hittas.";
$pgv_lang["son"]			= "Son";
$pgv_lang["daughter"]			= "Dotter";
$pgv_lang["brother"]			= "Bror";
$pgv_lang["sister"]			= "Syster";
$pgv_lang["relationship_to_me"]		= "Förhållande till mig";
$pgv_lang["next_path"]			= "Visa nästa sökväg";
$pgv_lang["show_path"]			= "Visa sökväg";

//-- gedcom edit utility
$pgv_lang["gedrec_deleted"]		= "GEDCOM post raderad.";
$pgv_lang["gedcom_deleted"]		= "Radering av GEDCOM [#GED#] lyckades.";
$pgv_lang["changes_exist"]		= "Förändringar har gjorts på denna GEDCOM";
$pgv_lang["undo_successful"]		= "Ångra lyckades";
$pgv_lang["undo"]			= "Ångra";
$pgv_lang["find_place"]			= "Sök plats";
$pgv_lang["changes_occurred"]		= "Följande ändringar har inträffat för denna person.";
$pgv_lang["view_change_diff"]		= "Visa förändringar";
$pgv_lang["review_changes"]		= "Granska GEDCOM ändringar";
$pgv_lang["show_changes"]		= "Denna post har uppdaterats. Klicka här för att se ändringarna.";
$pgv_lang["accept_changes"]		= "Acceptera / Förkasta ändringar";
$pgv_lang["access_denied"]		= "<b>Åtkomst nekad</b><br />Du saknar behörighet till denna resurs.";
$pgv_lang["check_delete"]		= "Är du säker på att du vill ta bort denna gedcom tag?";
$pgv_lang["close_window"]		= "Stäng fönster";
$pgv_lang["close_window_without_refresh"]	= "Stäng fönter utan att ladda om";
$pgv_lang["ged_import"]			= "Importera gedcomfil";
$pgv_lang["update_successful"]		= "Uppdatering genomförd";
$pgv_lang["add_child_to_family"]	= "Lägg till barn till denna familj";
$pgv_lang["confirm_delete_person"]	= "Är du säker på att du vill ta bort denna person från GEDCOM-filen?";
$pgv_lang["find_media"]			= "Hitta Media";
$pgv_lang["set_link"]			= "Sätt länk";
$pgv_lang["add_source"]			= "Lägg till källa till fakta";
$pgv_lang["add_note"]			= "Lägg till anteckning till fakta";
$pgv_lang["delete_source"]		= "Radera källa";
$pgv_lang["confirm_delete_source"]	= "Är du säker på att du vill radera denna källa från GEDCOM filen?";
$pgv_lang["add_husb"]			= "Lägg till make";
$pgv_lang["add_husb_to_family"]		= "Lägg till en make till denna familj";
$pgv_lang["add_wife"]			= "Lägg till maka";
$pgv_lang["add_wife_to_family"]		= "Lägg till en maka till denna familj";
$pgv_lang["find_family"]		= "Hitta familj";
$pgv_lang["add_new_wife"]		= "Lägg till en ny maka";
$pgv_lang["add_new_husb"]		= "Lägg till en ny make";
$pgv_lang["edit_name"]			= "Ändra namn";
$pgv_lang["delete_name"]		= "Radera namn";
$pgv_lang["no_temple"]			= "Inget tempel - Living Ordinance";
$pgv_lang["add_unlinked_person"]	= "Lägg till en ny person som inte är kopplad.";
$pgv_lang["delete_person"]		= "Radera denna person";
$pgv_lang["must_provide"]		= "Du måste tillhandahålla";
$pgv_lang["add_child"]			= "Lägg till barn";
$pgv_lang["now_import"]			= "Nu bör du importera gedcom posterna in i phpGedView genom att klicka på import länken nedan.";
$pgv_lang["custom_event"]		= "Special händelse";
$pgv_lang["add"]			= "Lägg till";
$pgv_lang["add_fact"]			= "Lägg till ny fakta tag";
$pgv_lang["accept_gedcom"]		= "För att förkasta en ändring klicka på Ångra länken brevid den. För att acceptera alla ändringar för en gedcom fil, importera den igen.";
$pgv_lang["place_contains"]		= "Platsen består av:";

//-- calendar.php messages
$pgv_lang["viewday"]			= "Visa dag";
$pgv_lang["saturday"]			= "Lördag";
$pgv_lang["friday"]			= "Fredag";
$pgv_lang["thursday"]			= "Torsdag";
$pgv_lang["wednesday"]			= "Onsdag";
$pgv_lang["tuesday"]			= "Tisdag";
$pgv_lang["monday"]			= "Måndag";
$pgv_lang["sunday"]			= "Söndag";
$pgv_lang["day"]			= "Dag:";
$pgv_lang["month"]			= "Månad:";
$pgv_lang["anniversary_calendar"]	= "Historisk kalender";
$pgv_lang["on_this_day"]		= "Historiska händelser denna dag...";
$pgv_lang["in_this_month"]		= "I denna månad, i din historia...";
$pgv_lang["year_anniversary"]		= "#year_var# årsdag";
$pgv_lang["viewmonth"]			= "Visa månad";
$pgv_lang["all_people"]			= "Alla personer";
$pgv_lang["living_only"]		= "Levande Personer";
$pgv_lang["recent_events"]		= "Nyligen inträffade händelser(< 100 år)";

//-- upload media messages
$pgv_lang["upload_media"]		= "Ladda upp mediafiler";
$pgv_lang["media_file"]			= "Mediafiler";
$pgv_lang["thumbnail"]			= "Miniatyrbild";
$pgv_lang["upload_successful"]		= "Uppladdning lyckades";

//-- user self registration module
$pgv_lang["requestpassword"]		= "Begär nytt lösenord";
$pgv_lang["requestaccount"]		= "Begär nytt användarkonto";
$pgv_lang["register_info_01"]		= "Mängden data som kan ses av alla på denna sajt kan vara begränsad pga lagar som rör personers privatliv(PUL). De flesta människor vill inte ha deras personliga data tillgängliga på internet. Den kan missbrukas för spam och identitetsstöld.<br /><br />För att få tillgång till den privata datan måste du ha ett konto på denna sajt. För att få ett konto kan du registrera dig genom att ange den efterfrågade informationen. Efter att administratören har kontrollerat och godkänt din ansökan så kan du logga in och se den privata informationen.<br /><br />Om relationssäkerheten är aktiverad kommer du bara att kunna se privat information om dina egna nära släktingar efter att du har loggat in. Administratören kan också ge rättigheter för att ändra och lägga till information i databasen.<br /><br />Obs: Du kommer bara att få rättighter att läsa den privata datan om du kan bevisa att du är en nära släkting till en person i databasen.<br /><br />Om du inte är en nära släkting kommer du troligen inte att få några rättighter så det är inte värt besväret att försöka.<br />Om du behöver mer hjälp, använd länken nedan och kontakta administratören.<br /><br /> ";
$pgv_lang["pls_note01"]			= "Obs! Detta system skiljer på stora och små bokstäver";
$pgv_lang["min6chars"]			= "Lösenordet måste innehålla minst 6 tecken";
$pgv_lang["pls_note02"]			= "Obs! Lösenordet bör endast innehålla bokstäver och siffror. Andra tecken kan medföra att man inte kan logga in från vissa system.";
$pgv_lang["pls_note03"]			= "Emailadressen kommer att verifieras innan kontot aktiveras. Den kommer inte att visas på sajten. Du kommer att få ett meddelande på den emailadress med din registreringsdata som kommer skickas vidare till denna adress.";
$pgv_lang["emailadress"]		= "Emailadress:";
$pgv_lang["pls_note04"]			= "Fält markerade med * är obligatoriska.";
$pgv_lang["pls_note05"]			= "En avslutning av formuläret på dena sida och verifieringen av dina svar, du kommer att få ett bekräftelseemail till emailadressen du specifierade på denna sida. Använd bekräftelseemailet för att aktivera ditt konto, om du misslyckades med aktivera ditt konto inom sju dagar kommer det att rensas bort (du kan då registrera kontot igen). För att använda denna sajt behöver du känna till ditt användarnamn och ditt lösenord. Du måste ange en giltig emailadress på denna sida för att kunna få kontobekräftelse emailet.<br /><br />om du får problem med registreringen av ett konto på denna sajt. Skicka en begäran om support till webmastern.";
$pgv_lang["mail01_line01"]		= "Hej #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "En begäran om att logga in på (#SERVER_#NAME) med din emailadress (#user_email#) gjordes.";
$pgv_lang["mail01_line03"]		= "Följande data användes.";
$pgv_lang["mail01_line04"]		= "Klicka på länken nedan och fyll i den begärda datan för att verifiera ditt konto och emailadress.";
$pgv_lang["mail01_line05"]		= "Om du inte begärde denna data kan du radera meddelandet.";
$pgv_lang["mail01_line06"]		= "Du kommer inte få några fler mail från detta systemet efterom kontot kommer att raderas inom sju dagar om ingen verifiering görs.";
$pgv_lang["mail01_subject"]		= "Din registrering på #SERVER_NAME#";
$pgv_lang["mail02_line01"]		= "Hej administratör...";
$pgv_lang["mail02_line02"]		= "En ny användare gjorde en ny användarregistrering på (#SERVER_NAME#)";
$pgv_lang["mail02_line03"]		= "Användaren fick ett email med den nödvändiga datan för att kunna verifiera sitt konto.";
$pgv_lang["mail02_line04"]		= "Så snart användaren har gjort sin verifiering kommer du att informeras via email att ge användaren rättigheter att logga in på din sajt.";
$pgv_lang["mail02_subject"]		= "Ny registrering på #SERVER_NAME#";
$pgv_lang["hashcode"]			= "Verifieringskod:";
$pgv_lang["thankyou"]			= "Hej #user_fullname#...<br />Tack för din registrering";
$pgv_lang["pls_note06"]			= "Ni kommer att få en via email till eamiladressen(#user_email#). Använd konformeringsemailet för att akrivera ditt konto, om du misslyckas att aktiver ditt konto inom sju dagar kommer det att raderas(du kan registrera kontot igen då). För att logga in på sajten måste du veta ditt användarnamn och lösenord.";
$pgv_lang["registernew"]		= "Bekräftelse av ett nytt konto";
$pgv_lang["user_verify"]		= "Användarverifiering";
$pgv_lang["send"]			= "Skicka";
$pgv_lang["pls_note07"]			= "Skriv in ditt användarnamn, lösenord och verifieringskoden som du fick via email från systemet för att aktivera ditt konto.";
$pgv_lang["pls_note08"]			= "Datan för användaren #user_name# är kontrollerad.";
$pgv_lang["mail03_line01"]		= "Hej administratör";
$pgv_lang["mail03_line02"]		= "#newuser[username]#(#newuser[fullname]# har verifierat registreringsdatan.";
$pgv_lang["mail03_line03"]		= "Obs! klicka på länken nedan för att logga in till din sajt för att redigera användaren och ge honom rättigheter att logga in på din sajt";
$pgv_lang["mail03_subject"]		= "Ny verifiering på #SERVER_NAME#";
$pgv_lang["pls_note09"]			= "Du identifierades som en registrerad användare.";
$pgv_lang["pls_note10"]			= "Adminstratören har blivit informerad.<br />Så snart han har get dig rättigheter att logga in kan du logga in med ditt användarnamn och lösenord.";
$pgv_lang["data_incorrect"]		= "Datan var inte korrekt!<br />Försök igen!";
$pgv_lang["user_not_found"]		= "Kunde inte verifiera informationen du skrev in. Gå tillbaka och försök igen.";
$pgv_lang["lost_pw_reset"]		= "Förlorat lösenordsförfrågan.";
$pgv_lang["pls_note11"]			= "För att få lösenordet återställt, ange ditt användarnamn och din emailadress för ditt användarkonto.<br /><br />Vi kommer att skicka en speciell URL via email, vilket innehåller en bekräftelse hash för ditt konto. Genom att besöka den sända URLn kommer du att få rättigheter att ändra lösenord och användarnamn för sajten. För att öka saäkerheten skall du inte ge bekräftelse hashen till någon, inklusive administratörerna av denna sajt( vi kommer inta att fråga efter den).<br /><br />Om du behöver hjälp från administratören av denna sajt, kontakta då sajtens administratör.";
$pgv_lang["enter_email"]		= "Du måste skriva in en emailadress.";
$pgv_lang["mail04_line01"]		= "Hej #user_fullname#...";
$pgv_lang["mail04_line02"]		= "Ett nytt lösenord efterfrågas för ditt användarnamn!";
$pgv_lang["mail04_line03"]		= "Rekomendation:";
$pgv_lang["mail04_line04"]		= "Klicka på länken nedan, logga in med ditt nya lösenord. Ändra sedan lösenordet så att säkerheten bibehålls för din data.";
$pgv_lang["mail04_subject"]		= "Dataförfrågan på #SERVER_NAME#";
$pgv_lang["pwreqinfo"]			= "Hej...<br /><br />Ett email sändes till emailadressen(#user[eamil]#) inklusive det nya lösenordet.<br /><br />Kontrollera ditt emailkonto efter några minuter för då bör du fått ditt email.<br /><br />Rekommendation:<br /><br />Efter du fått ditt email bör du logga in och ändra ditt lösenord för att öka integriteten för din datasäkerhet.";
$pgv_lang["editowndata"]		= "Mitt konto";
$pgv_lang["savedata"]			= "Spara ändrade data";
$pgv_lang["datachanged"]		= "Användardata har ändrats!";
$pgv_lang["datachanged_name"]		= "Du kommer kanske att behöva logga in igen med ditt nya användarnamn.";
$pgv_lang["myuserdata"]			= "Mitt konto";
$pgv_lang["verified"]			= "Användaren verifierade sig själv:";
$pgv_lang["verified_by_admin"]		= "Användare godkänd av admin:";
$pgv_lang["user_theme"]			= "Mitt tema";
$pgv_lang["mygedview"]			= "MyGedView";
$pgv_lang["passwordlength"]		= "Lösenordet måste innehålla minst 6 tecken.";
$pgv_lang["admin_approved"]		= "Ditt konto på #SERVER_NAME# har blivit godkänt.";
$pgv_lang["you_may_login"]		= " av sajt administratören. Du kan nu logga in på PhpGedView sajten genom att följa länken nedan.";

//-- mygedview page
$pgv_lang["welcome"]			= "Välkommen";
$pgv_lang["upcoming_events"]		= "Kommande händelser";
$pgv_lang["chat"]			= "Chat";
$pgv_lang["users_logged_in"]		= "Användare inloggad";
$pgv_lang["message"]			= "Skicka meddelande";
$pgv_lang["my_messages"]		= "Mina meddelande";
$pgv_lang["date_created"]		= "Datum skickat:";
$pgv_lang["message_from"]		= "Från:";
$pgv_lang["message_from_name"]		= "Ditt namn:";
$pgv_lang["message_to"]			= "Till:";
$pgv_lang["message_subject"]		= "Ärende:";
$pgv_lang["message_body"]		= "Meddelande:";
$pgv_lang["no_to_user"]			= "Ingen mottagare har angivits. Kan inte fortsätta.";
$pgv_lang["provide_email"]		= "Ange din emailadress så att vi kan kontakta dig för att svara på ditt meddelande. Om du inte anger din emailadress kommer vi inte att kunna besvara din förfrågan. Din emailadress kommer inte att användas på något annat sätt än för att besvara din förfrågan.";
$pgv_lang["reply"]			= "Svara";
$pgv_lang["message_deleted"]		= "Medelande raderat";
$pgv_lang["message_sent"]		= "Meddelandet är skickat";
$pgv_lang["reset"]			= "Återställ";
$pgv_lang["site_default"]		= "Sajt standard";
$pgv_lang["mygedview_desc"]		= "Din MyGedView sida tillåter dig att ha bokmärken över dina favorit personer, spåra kommande händelser, och samarbeta med andra PhpGedView användare.";
$pgv_lang["no_messages"]		= "Du har inga väntande meddelanden.";
$pgv_lang["clicking_ok"]		= "Klicka OK kommer att öppna ett annat fönster där du kan kontakta #user[fullname]#";
$pgv_lang["my_favorites"]		= "Mina favoriter";
$pgv_lang["no_favorites"]		= "Du har inte angett några favoriter. För att lägga till personer till dina favoriter, sök reda på personens detaljer och klicka på 'Lägg till mina favoriter' eller använd ID fältet för att lägga till en person genom att ange dess ID nummer.";
$pgv_lang["add_to_my_favorites"]	= "Lägg till i mina favoriter";
$pgv_lang["confirm_fav_remove"]		= "Är du säker på att du vill radera denna post från dina favoriter?";
$pgv_lang["portal"]			= "Portal";
$pgv_lang["invalid_email"]		= "Obs! Skriv in en giltig emailadress.";
$pgv_lang["enter_subject"]		= "Obs! Skriv ett ärende för meddelandet.";
$pgv_lang["enter_body"]			= "Obs! Skriv någon text i meddelandet innan du skickar det.";
$pgv_lang["confirm_message_delete"]	= "Är du säker på att du vill radera detta meddelandet? Det kan inte återfås senare.";
$pgv_lang["message_email1"]		= "Foljande meddelande har skickats till ditt PhpGedView användarkonto:";
$pgv_lang["message_email2"]		= "Du skickade följande meddelande till ett PhpGedView användarkonto:";
$pgv_lang["message_email3"]		= "Du skickade följande meddelande till en PhpgedView administratör:";
$pgv_lang["viewing_url"]		= "Detta meddelande sändes medan följande url visades:";
$pgv_lang["messaging2_help"]		= "När du skickar detta meddelande så kommer du att få en kopia via email till den emailadress som du har angett.";
$pgv_lang["random_picture"]		= "Slumpvist vald bild";
$pgv_lang["message_instructions"]	= "Observera:<br />Privat information om levande personer kommer endast ges till släktingar och nära vänner. Du kommer att ombedas att verifiera ditt släktskap innan du kommer att erhålla någon information. Ibland är även information om döda personer privat. Om detta är fallet så beror det på att det inte finns tillräckligt med information för att avgöra om personen är död eller fortfarande lever och vi har antagligen inte mer information om denna person.<br /><br />Före du ställer några frågor så kontrollera att det är rätt person genom att kontrollera datumar, platser och nära släktingar. Om du skickar ändringar av den genealogiska datan så inkludera källan var du fått uppgifterna ifrån.<br /><br />";
$pgv_lang["upgrade_util"]		= "Uppgraderingsverktyg";
$pgv_lang["no_upgrade"]			= "Det finns inga filer att uppgradera";
$pgv_lang["use_version"]		= "Du använder version:";
$pgv_lang["current_version"]		= "Nuvarande stabila version:";
$pgv_lang["upgrade_download"]		= "Ladda ner:";
$pgv_lang["upgrade_tar"]		= "TAR";
$pgv_lang["upgrade_zip"]		= "ZIP";

if (file_exists($PGV_BASE_DIRECTORY . "languages/lang.sv.extra.php")) require $PGV_BASE_DIRECTORY . "languages/lang.sv.extra.php";

?>