<?php
/*=================================================
	Project: phpGedView
	File: login_register.php
	Author: John Finlay, Kurt Norgaz
	Comments:
		Register as a new User or request new password if it is lost

	phpGedView: Genealogy Viewer
	Copyright (C) 2002 to 2003  John Finlay and Others

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: login_register.php,v 1.26 2004/01/05 18:01:20 kurtnorgaz Exp $

require "config.php";
require $PGV_BASE_DIRECTORY.$confighelpfile["english"];
if (file_exists($PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE])) require $PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE];

$message="";
if (!isset($action)) $action = "";
if (!isset($url)) $url = "index.php";

switch ($action)
{
  case "pwlost" :	print_header("PhpGedView - " . $pgv_lang["lost_pw_reset"]);
  			?>
  			<script language="JavaScript">
  			  function checkform(frm)
  			  {
  			    if (frm.user_email.value == "")
  			    {
  			      alert("<?php print $pgv_lang["enter_email"]; ?>");
  			      frm.user_email.focus();
  			      return false;
  			    }
  			    return true;
  			  }
  			</script>

  			<center>
  			  <font class="subheaders"><?php print $pgv_lang["lost_pw_reset"]; ?></font><br /><br />
  			  <?php print str_replace("#pgv_lang[lost_pw_reset]#", "\"<b>" . $pgv_lang["lost_pw_reset"] . "</b>\"", $pgv_lang["pls_note11"]); ?><br /><br />
  			  <form name="requestpwform" method="post" onsubmit="t = new Date(); document.requestpwform.time.value=t.toUTCString(); return checkform(this);">
  			  	<input type="hidden" name="time" value="" />
  			    <input type="hidden" name="action" value="requestpw" />
  			    <font class="error"><?php print $message?></font>
  			    <table>
  			      <tr><td align="right"><?php print $pgv_lang["username"]?></td><td><input type="text" name="user_name" value=""></td></tr>
  			      <tr><td align="right"><?php print $pgv_lang["emailadress"]?></td><td><input type="text" name="user_email" value=""></td></tr>
  			    </table>
  			    <input type="submit" value="<?php print $pgv_lang["lost_pw_reset"]; ?>" />
  			  </form>
  			  <br /><br />
  			</center>
  			<?php
  			break;
  case "requestpw" :	$QUERY_STRING = "";
  			print_header("PhpGedView - " . $pgv_lang["lost_pw_reset"]);
  			print "<center>";
  			$users = getUsers();
  			foreach($users as $user) {
	  			if ($user["email"]==$user_email) $newuser = $user;
  			}
  			if (!isset($newuser) || ($newuser["username"]!=$username)) {
  			  print "<font class=\"error\">" . $pgv_lang["user_not_found"] . "</font><br />";
  			}
  			else {
  			  $user_new_pw = md5 (uniqid (rand()));
  			  $newuser = getUser($user_name);
  			  $olduser = $newuser;
  			  deleteUser($user_name);

  			  $newuser["password"] = crypt($user_new_pw, $user_new_pw);
  			  $newuser["pwrequested"] = "1";
  			  $newuser["reg_timestamp"] = date("U");
  			  addUser($newuser);

  			  $mail_body = "";
  			  $mail_body .= str_replace("#user_fullname#", $newuser["fullname"], $pgv_lang["mail04_line01"]) . "\n\n";
  			  $mail_body .= $pgv_lang["mail04_line02"] . "\n\n";
  			  $mail_body .= $pgv_lang["username"] . " " . $newuser["username"] . "\n";

  			  $mail_body .= $pgv_lang["password"] . " " . $user_new_pw . "\n\n";
  			  $mail_body .= $pgv_lang["mail04_line03"] . "\n";
  			  $mail_body .= $pgv_lang["mail04_line04"] . "\n";

  			  $tuser = getUser($CONTACT_EMAIL);
  			  $headers = "From: " . $tuser["fullname"]." <".$tuser["email"].">";
  			  mail($newuser["email"], str_replace("#SERVER_NAME#", $SERVER_URL, $pgv_lang["mail04_subject"]), $mail_body, $headers."\r\nContent-type: text/plain; charset=$CHARACTER_SET\r\n");
  			  print str_replace("#user[email]#", $newuser["email"], $pgv_lang["pwreqinfo"]) . "<br /><br />";
  			  AddToLog("Password request was sent to user: ".$user_name);
  			}
  			print "</center>";
  			break;
  case "register" :	$QUERY_STRING = "";
  			print_header("PhpGedView - " . $pgv_lang["requestaccount"]);
  			?>
  			<script language="JavaScript">
  			  function checkform(frm)
  			  {
  			    if (frm.user_name.value == "")
  			    {
  			      alert("<?php print $pgv_lang["enter_username"]; ?>");
  			      frm.user_name.focus();
  			      return false;
  			    }
  			    if (frm.user_password01.value == "")
  			    {
  			      alert("<?php print $pgv_lang["enter_password"]; ?>");
  			      frm.user_password01.focus();
  			      return false;
  			    }
  			    if (frm.user_password02.value == "")
  			    {
  			      alert("<?php print $pgv_lang["confirm_password"]; ?>");
  			      frm.user_password02.focus();
  			      return false;
  			    }
  			    if (frm.user_password01.value != frm.user_password02.value)
  			    {
  			      alert("<?php print $pgv_lang["password_mismatch"]; ?>");
  			      frm.user_password01.value = "";
  			      frm.user_password02.value = "";
  			      frm.user_password01.focus();
  			      return false;
  			    }
  			    if (frm.user_password01.value.length < 6)
  			    {
  			      alert("<?php print $pgv_lang["passwordlength"]; ?>");
  			      frm.user_password01.value = "";
  			      frm.user_password02.value = "";
  			      frm.user_password01.focus();
  			      return false;
  			    }
  			    if (frm.user_fullname.value == "")
  			    {
  			      alert("<?php print $pgv_lang["enter_fullname"]; ?>");
  			      frm.user_fullname.focus();
  			      return false;
  			    }
  			    if (frm.user_email.value == "")
  			    {
  			      alert("<?php print $pgv_lang["enter_email"]; ?>");
  			      frm.user_email.focus();
  			      return false;
  			    }
  			    return true;
  			  }
  			</script>

  			<center>
  			  <form name="registerform" method="post" onsubmit="t = new Date(); document.registerform.time.value=t.toUTCString(); return checkform(this);">
  			    <input type="hidden" name="action" value="registernew">
  			    <input type="hidden" name="time" value="">
  			    <table width="80%" border="0">
  			      <tr><td align="center" colspan="2"><font class="subheaders"><?php print $pgv_lang["requestaccount"]; ?></font><br /><br /></td></tr>
  			      <tr><td align="center" colspan="2"><?php print $pgv_lang["register_info_01"]; ?></td></tr>
  			      <tr><td align="center" colspan="2"><?php print $pgv_lang["register_info_02"]; ?></td></tr>
  			      <tr><td class="facts_label" valign="top" align="left"><?php print $pgv_lang["username"]; ?></td><td class="facts_value" valign="top"><input type="text" name="user_name" value="" /> <font class="error">*</font><br /><font class="error" size="2"><?php print $pgv_lang["pls_note01"];?></font></td></tr>
  			      <tr><td class="facts_label" valign="top" align="left"><?php print $pgv_lang["password"]; ?></td><td class="facts_value" valign="top"><input type="password" name="user_password01" value="" /> <font class="error">*</font><br /><font class="error" size="2">(<?php print $pgv_lang["min6chars"];?>)</font></td></tr>
  			      <tr><td class="facts_label" valign="top" align="left"><?php print $pgv_lang["confirm"]; ?></td><td class="facts_value" valign="top"><input type="password" name="user_password02" value="" /> <font class="error">*</font><br /><font class="error" size="2"><?php print $pgv_lang["pls_note02"];?></font></td></tr>
  			      <tr><td class="facts_label" valign="top" align="left"><?php print $pgv_lang["fullname"]; ?></td><td class="facts_value" valign="top"><input type="text" name="user_fullname" value="" /> <font class="error">*</font></td></tr>
  			      <tr><td class="facts_label" valign="top" align="left"><?php print $pgv_lang["change_lang"]; ?>:</td><td class="facts_value" valign="top"><?php
  			      	if ($ENABLE_MULTI_LANGUAGE)
  			      	{
  			      	  if (empty($LANG_FORM_COUNT))
  			      	  {
  			      	    $LANG_FORM_COUNT = 1;
  			      	  }
  			      	  else
  			      	  {
  			      	    $LANG_FORM_COUNT++;
  			      	  }
  			      	  print "<select name=\"user_language\" style=\"{ font-size: 9pt; }\">";
  			      	  foreach ($pgv_language as $key => $value)
  			      	  {
  			      	    print "\n\t\t\t<option value=\"$key\"";
  			      	    if ($key == $LANGUAGE)
  			      	    {
  			      	      print " selected";
  			      	    }
  			      	    print ">" . $pgv_lang[$key] . "</option>";
  			      	  }
  			      	  print "</select>\n\t\t";
  			      	}
  			      	else print "&nbsp;";
  			      ?></td></tr>
  			      <tr><td class="facts_label" valign="top" align="left"><?php print $pgv_lang["emailadress"];?></td><td class="facts_value" valign="top"><input type="text" name="user_email" value="" /> <font class="error">*</font><br /><font class="error" size="2"><?php print $pgv_lang["pls_note03"];?></font></td></tr>
  			      <tr><td align="left" colspan="2"><font class="error" size="2"><?php print $pgv_lang["pls_note04"];?></font></td></tr>
  			      <tr><td align="center" colspan="2"><br /><input type="submit" value="<?php print $pgv_lang["requestaccount"]; ?>" /><br /><br /></td></tr>
  			      <tr><td align="center" colspan="2"><?php print $pgv_lang["pls_note05"];?></td></tr>
  			    </table>
  			  </form>
  			</center>
  			<?php
  			break;
  case "registernew" :	$QUERY_STRING = "";
  			print_header("PhpGedView - " . $pgv_lang["registernew"]);

  			print "<center>";

  			$user_created_ok = false;

  			AddToLog("User registration requested for: ".$user_name);

  			if (getUser($user_name)!== false)
  			{
  			  print "<font class=\"error\">" . $pgv_lang["duplicate_username"] . "</font><br />";
  			}
  			else if ($user_password01 == $user_password02)
  			     {
  			       $user = array();
  			       $user["username"] = $user_name;
  			       $user["fullname"] = $user_fullname;
  			       $user["email"] = $user_email;
  			       if (!isset($user_language)) $user_language = "";
  			       $user["language"] = $user_language;
  			       $user["verified"] = "";
  			       $user["verified_by_admin"] = "";
  			       $user["pwrequested"] = "";
  			       $user["reg_timestamp"] = date("U");
  			       # $user["reg_hashcode"] = crypt($user_password01 . $user_name . $user["reg_timestamp"], $user_password01);
  			       srand((double)microtime()*1000000);
  			       $user["reg_hashcode"] = crypt(rand(), $user_password01);
  			       $user["gedcomid"] = array();
  			       $user["rootid"] = array();
  			       $user["canedit"] = array();
  			       $user["theme"] = "";
  			       $user["loggedin"] = "N";
  			       $user["sessiontime"] = 0;
  			       foreach($GEDCOMS as $ged => $gedarray)
  			       {
  			         $file = $ged;
  			         $ged = preg_replace("/\./", "_", $ged);
  			         $varname = "gedcomid_$ged";
  			         if (isset($$varname)) $user["gedcomid"][$file] = $$varname;
  			         $varname = "rootid_$ged";
  			         if (isset($$varname)) $user["rootid"][$file] = $$varname;
  			         $varname = "canedit_$ged";
  			         if ((isset($$varname)) && ($$varname == "yes")) $user["canedit"][$file] = true;
  			         else $user["canedit"][$file] = false;
  			       }
  			       $user["password"] = crypt($user_password01, $user_password01);
  			       if ((isset($canadmin)) && ($canadmin == "yes")) $user["canadmin"] = true;
  			       else $user["canadmin"] = false;
  			       $au = addUser($user);
  			       if ($au)
  			       {
  			         $user_created_ok = true;
  			       }
  			       else
  			       {
  			         print "<font class=\"error\">" . $pgv_lang["user_create_error"] . "<br /></font>";
  			       }
  			     }
  			     else
  			     {
  			       print "<font class=\"error\">" . $pgv_lang["password_mismatch"] . "</font><br />";
  			     }

  			if ($user_created_ok)
  			{
  			  $mail_body = "";
  			  $mail_body .= str_replace("#user_fullname#", $user_fullname, $pgv_lang["mail01_line01"]) . "\n\n";
  			  $mail_body .= str_replace("#user_email#", $user_email, str_replace("#SERVER_NAME#", $SERVER_URL, $pgv_lang["mail01_line02"])) . "\n";
  			  $mail_body .= $pgv_lang["mail01_line03"] . "\n\n";
  			  $mail_body .= $pgv_lang["mail01_line04"] . "\n\n";
  			  $mail_body .= "http://".$_SERVER['SERVER_NAME'] . $PHP_SELF."?action=userverify" . "\n";
  			  $mail_body .= $pgv_lang["username"] . " " . $user_name . "\n";
  			  $mail_body .= $pgv_lang["password"] . " " . $user_password01 . "\n";
  			  $mail_body .= $pgv_lang["hashcode"] . " " . $user["reg_hashcode"] . "\n\n";
  			  $mail_body .= $pgv_lang["mail01_line05"] . "\n";
  			  $mail_body .= $pgv_lang["mail01_line06"] . "\n";

  			  $tuser = getUser($WEBMASTER_EMAIL);
  			  $headers = "From: " . $tuser["fullname"]." <".$tuser["email"].">";
  			  mail($user_email, str_replace("#SERVER_NAME#", $SERVER_URL, $pgv_lang["mail01_subject"]), $mail_body, $headers."\r\nContent-type: text/plain; charset=$CHARACTER_SET\r\n");

  			  $mail_body = "";
  			  $mail_body .= $pgv_lang["mail02_line01"] . "\n\n";
  			  $mail_body .= str_replace("#SERVER_NAME#", $SERVER_URL, $pgv_lang["mail02_line02"]) . "\n\n";
  			  $mail_body .= $pgv_lang["username"] . " " . $user_name . "\n";
  			  $mail_body .= $pgv_lang["fullname"] . " " . $user_fullname . "\n\n";
  			  $mail_body .= $pgv_lang["mail02_line03"] . "\n";
  			  $mail_body .= $pgv_lang["mail02_line04"] . "\n";
  			  $headers = "From: " .$user_email;

  			  if ($SUPPORT_METHOD=="mailto" || $SUPPORT_METHOD=="none") mail($WEBMASTER_EMAIL, str_replace("#SERVER_NAME#", $SERVER_URL, $pgv_lang["mail02_subject"]), $mail_body, $headers."\r\nContent-type: text/plain; charset=$CHARACTER_SET\r\n");
  			  else {
	  			$message = array();
				$message["to"]=$WEBMASTER_EMAIL;
				$message["from"]=$user_email;
				$message["subject"] = str_replace("#SERVER_NAME#", $SERVER_URL, $pgv_lang["mail02_subject"]);
				$message["body"] = $mail_body;
				$message["created"] = $time;
				$message["method"] = $SUPPORT_METHOD;
				$message["no_from"] = true;
				addMessage($message);
  			  }

  			  ?><table width="80%">
  			    <tr><td align="center"><font class="subheaders"><?php print str_replace("#user_fullname#", $user_fullname, $pgv_lang["thankyou"]);?><br /><br /></font></td></tr>
  			    <tr><td align="center"><?php print str_replace("#user_email#", $user_email, $pgv_lang["pls_note06"]);?></td></tr>
  			  </table><?php
  			}
				print "</center>";
				break;
  case "userverify" :	$QUERY_STRING = "";
  			print_header("PhpGedView - " . $pgv_lang["user_verify"]);
  			print "<center>";
  			?><form name="verifyform" method="post" onsubmit="t = new Date(); document.verifyform.time.value=t.toUTCString();">
  			  <input type="hidden" name="action" value="verify_hash">
  			  <input type="hidden" name="time" value="">
  			  <table width="80%">
  			    <tr><td align="center" colspan="2"><font class="subheaders"><?php print $pgv_lang["user_verify"];?><br /><br /></font></td></tr>
  			    <tr><td align="center" colspan="2"><?php print $pgv_lang["pls_note07"];?><br /><br /></td></tr>
  			    <tr><td class="facts_label" valign="top" align="left"><?php print $pgv_lang["username"]; ?></td><td class="facts_value" valign="top"><input type="text" name="user_name" value="" /><br /><font class="error" size="2"><?php print $pgv_lang["pls_note01"];?></font></td></tr>
  			    <tr><td class="facts_label" valign="top" align="left"><?php print $pgv_lang["password"]; ?></td><td class="facts_value" valign="top"><input type="password" name="user_password" value="" /></td></tr>
  			    <tr><td class="facts_label" valign="top" align="left"><?php print $pgv_lang["hashcode"]; ?></td><td class="facts_value" valign="top"><input type="text" name="user_hashcode" value="" /></td></tr>
  			    <tr><td align="left">&nbsp;</td><td><br /><input type="submit" value="<?php print $pgv_lang["send"]; ?>"><br /><br /></td></tr>
  			  </table>
  			</form><?php
				print "</center>";
				break;
  case "verify_hash" :	$QUERY_STRING = "";
  			AddToLog("User attempted to verify hashcode: ".$user_name);
  			print_header("PhpGedView - " . $pgv_lang["user_verify"]);# <-- better verification of authentication code
  			print "<center>";

  			?><table width="80%">
  			  <tr><td align="center"><font class="subheaders"><?php print $pgv_lang["user_verify"];?><br /><br /></font></td></tr>
  			  <tr><td align="center"><?php print str_replace("#user_name#", $user_name, $pgv_lang["pls_note08"]);?><br /><br /></td></tr><?php
  			  $user = getUser($user_name);
  			  if ($user!==false)
  			  {
  			    $pw_ok = ($user["password"] == crypt($user_password, $user["password"]));
  			    $hc_ok = ($user["reg_hashcode"] == $user_hashcode);
  			    if (($pw_ok) and ($hc_ok))
  			    {
  			      $newuser = $user;
  			      $olduser = $user;
  			      deleteUser($user_name);
  			      storeUsers();

  			      $newuser["verified"] = "yes";
  			      $newuser["pwrequested"] = "";
  			      $newuser["reg_timestamp"] = date("U");
  			      $newuser["hashcode"] = "";
  			      addUser($newuser);

  			      $mail_body = "";
  			      $mail_body .= $pgv_lang["mail03_line01"] . "\n\n";
  			      $mail_body .= str_replace("#newuser[username]# ( #newuser[fullname]#", $newuser["username"] . " (" . $newuser["fullname"], $pgv_lang["mail03_line02"]) . "\n\n";
  			      $mail_body .= $pgv_lang["mail03_line03"] . "\n\n";
  			      $path = substr($PHP_SELF, 0, strrpos($PHP_SELF, "/"));
  			      $mail_body .= "http://".$_SERVER['SERVER_NAME'] . $path."/useradmin.php?action=edituser&username=" . $newuser["username"] . "\n";

  			      $tuser = getUser($WEBMASTER_EMAIL);
  			  	  $headers = "From: " . $tuser["fullname"]." <".$tuser["email"].">";
  			      if ($SUPPORT_METHOD=="mailto" || $SUPPORT_METHOD=="none") mail($WEBMASTER_EMAIL, str_replace("#SERVER_NAME#", $SERVER_URL, $pgv_lang["mail03_subject"]), $mail_body, $headers."\r\nContent-type: text/plain; charset=$CHARACTER_SET\r\n");
  			      else {
		  			$message = array();
					$message["to"]=$WEBMASTER_EMAIL;
					$message["from"]=$newuser["username"];
					$message["subject"] = str_replace("#SERVER_NAME#", $SERVER_URL, $pgv_lang["mail03_subject"]);
					$message["body"] = $mail_body;
					$message["created"] = $time;
					$message["method"] = $SUPPORT_METHOD;
					$message["no_from"] = true;
					addMessage($message);
	  			  }

  			      ?><tr><td align="center"><?php print $pgv_lang["pls_note09"];?><br /><br /></td></tr>
  			      <tr><td align="center"><?php print $pgv_lang["pls_note10"];?><br /><br /></td></tr><?php
  			    }
  			    else
  			    {
  			      ?><tr><td align="center"><?php print "<font class=\"error\">" . $pgv_lang["data_incorrect"] . "</font>"; ?><br /><br /></td></tr><?php
  			    }
  			  }
  			  else
  			  {
  			    ?><tr><td align="center"><?php print "<font class=\"error\">" . $pgv_lang["user_not_found"] . "</font>"; ?><br /><br /></td></tr><?php
  			  }
  			?></table><?php
				print "</center>";
				break;
  default :		header("Location: $url"); break;
}

print_footer();
?>