<?php
/*=================================================
	Project: phpGedView
	File: placelist.php
	Author: John Finlay
	Comments:
		Parses gedcom file and displays a place hierachy.

	Change Log:
		6/26/02 - File Created
		9/25/02 - Added support for language files
		10/18/02 - Rebuilt page to work better.
		12/27/02 - Made case insensitive

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: placelist.php,v 1.36.2.2 2004/02/02 15:18:12 yalnifj Exp $

require("config.php");

function case_in_array($value, $array) {
	foreach($array as $key=>$val) {
		if (strcasecmp($value, $val)==0) return true;
	}
	return false;
}


print_header($pgv_lang["place_list"]);
print_help_link("ppp_help", "page_help");
//print "\n\t<div align=\"center\">";
print "\n\t<div class=\"center\">";
print "<h2>".$pgv_lang["place_list"]."</h2>\n\t";

if (empty($action)) $action = "find";
if (!isset($parent)) $parent=array();

if (!isset($level)) {
	$level=0;
}

//-- extract the place form encoded in the gedcom
$header = find_gedcom_record("HEAD");
$hasplaceform = strpos($header, "1 PLAC");

// -- array of names
$placelist = array();
$positions = array();
$numfound = 0;
get_place_list();

//-- create a query string for passing to search page
$tempparent = array_reverse($parent);
if (count($tempparent)>0) $squery = "&query=".urlencode($tempparent[0]);
else $squery="";
for($i=1; $i<$level; $i++) {
	$squery.=", ".urlencode($tempparent[$i]);
}

//-- if the number of places found is 0 then automatically redirect to search page
if ($numfound==0) {
	$action="show";
}

if ($hasplaceform) {
	$placeheader = substr($header, $hasplaceform);
	$ct = preg_match("/2 FORM (.*)/", $placeheader, $match);
	if ($ct>0) {
		print  $pgv_lang["form"].$match[1];
		
	
		print_help_link("ppp_match_one_help", "qm");
	}
}
else {
	print $pgv_lang["form"].$pgv_lang["default_form"]."  ".$pgv_lang["default_form_info"];
	print_help_link("ppp_default_form_help", "qm");
}
print "<br /><br /><br />";
// -- sort the array
uasort($placelist, "placesort");
reset($placelist);

// -- print the breadcrumb hierarchy
if ($level>0) {
	//-- link to search results
	if (($level>1)||($parent[0]!="")) {
		print "\n\t<a href=\"placelist.php?action=show&amp;level=$level";
		foreach($parent as $key=>$value) {
			print "&amp;parent[$key]=".urlencode($value);
		}
		print "\">$numfound ".$pgv_lang["connections"]."</a>";
		print_help_link("ppp_numfound_help", "qm");
		print "<br /><br />";
	}
	//-- breadcrumb
	$numls = count($parent)-1;

	for($i=$numls; $i>=0; $i--) {
		print "\n\t <a href=\"placelist.php?level=".($i+1);
		for ($j=0; $j<=$i; $j++) {
			print "&amp;parent[$j]=".urlencode($parent[$j]);
		}
		print "\">";
		if (trim($parent[$i])=="") print $pgv_lang["unknown"];
		else print $parent[$i];
		print "</a>,";
	}
}
print " <a href=\"placelist.php?level=0\">".$pgv_lang["top_level"]."</a>";
	print_help_link("ppp_levels_help", "qm");
	if ($action=="find") {
	print "\n\t<br /><br />\n\t<table class=\"list_table, $TEXT_DIRECTION\">\n\t\t<tr>\n\t\t<td class=\"list_value\">";
	//-- create a string to hold the variable links
	$linklevels="";
	for($j=0; $j<$level; $j++) {
		$linklevels .= "&amp;parent[$j]=".urlencode($parent[$j]);
	}
	$i=0;
	$ct1=count($placelist);
	if ($ct1<3) $ct1=3;
	// -- print the array
	foreach ($placelist as $key => $value) {
		print "\n\t\t\t<a href=\"placelist.php?level=".($level+1).$linklevels;
		print "&amp;parent[$level]=".urlencode($value)."\"><font class=\"list_item\">";
		if (trim($value)=="") print $pgv_lang["unknown"];
		else print $value;
		print "</font></a><br />\n";
	    if ($i == floor($ct1 / 3)) print "\n\t\t</td>\n\t\t<td class=\"list_value\">";
	    if ($i == floor(($ct1 / 3) *2)) print "\n\t\t</td>\n\t\t<td class=\"list_value\">";
	    $i++;
	}
	print "\n\t\t</td>\n\t\t</tr>\n\t</table>";
	print_help_link("ppp_placelist_help", "qm");
}
else if ($action=="show") {
	// -- array of names
	$myindilist = array();
	$mysourcelist = array();
	$myfamlist = array();

	$positions = get_place_positions($parent, $level);
	for($i=0; $i<count($positions); $i++) {
		$gid = $positions[$i];
		$indirec=find_gedcom_record($gid);
		$ct = preg_match("/0 @(.*)@ (.*)/", $indirec, $match);
		if ($ct>0) {
			$type = trim($match[2]);
			if ($type == "INDI") {
				$myindilist["$gid"] = get_sortable_name($gid);
			}
			else if ($type == "FAM") {
				$myfamlist["$gid"] = get_family_descriptor($gid);
			}
			else if ($type == "SOUR") {
				$mysourcelist["$gid"] = get_source_descriptor($gid);
			}
		}
	}

	natcasesort($myindilist);
	reset($myindilist);
	print "\n\t<br /><br /><table class=\"list_table, $TEXT_DIRECTION\">\n\t\t<tr>";
	if (count($myindilist)>0) print "<td class=\"list_label\"><img src=\"$PGV_IMAGE_DIR/$PGV_INDIS_IMG\" border=\"0\" width=\"25\" alt=\"\"/> ".$pgv_lang["individuals"]."</td>";
	if (count($mysourcelist)>0) print "<td class=\"list_label\"><img src=\"$PGV_IMAGE_DIR/$PGV_SOURCE_IMG\" border=\"0\" width=\"25\" alt=\"\"/> ".$pgv_lang["sources"]."</td>";
	if (count($myfamlist)>0) print "<td class=\"list_label\"><img src=\"$PGV_IMAGE_DIR/$PGV_SFAMILY_IMG\" border=\"0\" width=\"25\" alt=\"\"/> ".$pgv_lang["families"]."</td>";
	$i=0;
	$ct=count($myindilist);
	print "</tr><tr>";
	if ($ct>0) {
		print "\n\t\t<td class=\"list_value\">";
		foreach ($myindilist as $key => $value) {
	    	print_list_person($key, array($value, $GEDCOM));
	    	$i++;
		}
		print "<br />\n\t\t</td>\n\t\t";
	}
	$ct=count($mysourcelist);
	if ($ct>0) {
		print "<td class=\"list_value\">";
		asort($mysourcelist);
		reset($mysourcelist);
		$i=0;
		foreach ($mysourcelist as $key => $value) {
		    print "\n\t\t\t<a href=\"source.php?sid=$key\"><font class=\"list_item\">$value</font></a><br />\n";
		    $i++;
		}
		print "<br />\n\t\t</td>\n\t\t";
	}
	asort($myfamlist);
	reset($myfamlist);
	$i=0;
	$ct=count($myfamlist);
	if ($ct>0) {
		print "<td class=\"list_value\">";
		foreach ($myfamlist as $key => $value) {
			print_list_family($key, array($value, $GEDCOM));
	    	//print "\n\t\t\t<a href=\"family.php?famid=$key\"><font class=\"list_item\">$value</font></a><br />\n";
	    	$i++;
		}
		print "<br />\n\t\t</td>";
	}
	print "</tr>\n\t</table>";
print_help_link("ppp_name_list_help", "qm");
}
print "<br /><br /></div>";
print_footer();

?>