<?php
/*=================================================
	Project: phpGedView
	File: privacy.php
	Author:
		David Bendory   david90@users.sourceforge.net
		John Finlay		yalnifj@users.sourceforge.net
	Comments:
		Extraction of privacy checking for display of data on living
        individuals.

    phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: privacy.php,v 1.42.2.2 2004/01/27 20:49:07 yalnifj Exp $
if (preg_match("/\Wprivacy\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "Now, why would you want to do that.  You're not hacking are you?";
	exit;
}

if (preg_match("/_priv\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "Now, why would you want to do that.  You're not hacking are you?";
	exit;
}

/*
	This is the default privacy.php module that is distributed
	with phpGedView.  To provide your own privacy module simply
	implement the functions in this file and configure phpGedview
	to use your new file.

	See http://www.phpgedview.net/modules.html for more
	information on modules in phpGedView
*/

//----------------------------------- constants
$PRIV_HIDE = -1;			//-- hide for everybody, even for the admin
$PRIV_PUBLIC = 2;		//-- accessible by public
$PRIV_USER = 1;			//-- accessible only by authenticated users
$PRIV_NONE = 0;			//-- accessible only by admin users

//----------------------------------- global variables
$SHOW_DEAD_PEOPLE = $PRIV_PUBLIC;		//-- set the privacy access level for all dead people
$SHOW_LIVING_NAMES = $PRIV_PUBLIC;		//-- should the names of living people be shown to the public
$SHOW_RESEARCH_LOG = $PRIV_USER;		//-- what type of user can view the research log if it is installed
$USE_RELATIONSHIP_PRIVACY = false;		//-- A false value means authenticated users can see the details of all living people
						//-- A true value means users can only see the private information of living people
						//-- they are related to
$MAX_RELATION_PATH_LENGTH = 3;			//-- second cousins
$CHECK_MARRIAGE_RELATIONS = true;		//-- check related by marriage relationships

//-- the person_privacy array provides users with the ability to override default
//-- privacy settings for a particular person in the gedcom
$person_privacy = array();
//$person_privacy["I3"] = $PRIV_NONE;

//-- the user_privacy array provide administrators the ability to override default
//-- privacy settings for individuals in the gedcom based on the users username
$user_privacy = array();
//$user_privacy["john"]["I100"] = $PRIV_NONE;

//-- the global_facts array defines facts on a global level that should be hidden for all
//-- individuals in the gedcom
//-- the ["show"] element determines at what access level the fact is shown
//-- the ["details"] element determins at what access level the details of a fact are shown
$global_facts = array();
$global_facts["SSN"]["show"] = $PRIV_USER;
$global_facts["SSN"]["details"] = $PRIV_USER;

//-- the person_facts array defines facts that are hidden for a specific individual
//-- in the gedcom and the level at which they are hidden
//-- the first element is the ID of the person, the second element is the fact
//-- the ["show"] element determines at what access level the fact is shown
//-- the ["details"] element determins at what access level the details of a fact are shown
$person_facts = array();
//$person_facts["I6909"]["NOTE"]["show"] = $PRIV_USER;
//$person_facts["I6909"]["NOTE"]["details"] = $PRIV_USER;

//----------------------------------- displayDetails
//-- should the details of the given individual be shown
//-- return true to show the persons details,
//-- return false to keep them private
function displayDetails($indirec) {
	global $PRIV_PUBLIC, $PRIV_USER, $PRIV_NONE, $USE_RELATIONSHIP_PRIVACY, $CHECK_MARRIAGE_RELATIONS, $MAX_RELATION_PATH_LENGTH;
	global $global_facts, $person_privacy, $user_privacy, $HIDE_LIVE_PEOPLE, $GEDCOM, $SHOW_DEAD_PEOPLE;

	if (!$HIDE_LIVE_PEOPLE) return true;

	$ct = preg_match("/0 @(.*)@ INDI/", $indirec, $match);
	if ($ct>0) $pid = $match[1];
	else $pid=0;

	return displayDetailsByID($pid);
}

//----------------------------------- displayDetailsByID
//-- should the details of the given individual be shown
//-- return true to show the persons details,
//-- return false to keep them private
function displayDetailsByID($pid) {
	global $PRIV_PUBLIC, $PRIV_USER, $PRIV_NONE, $PRIV_HIDE, $USE_RELATIONSHIP_PRIVACY, $CHECK_MARRIAGE_RELATIONS, $MAX_RELATION_PATH_LENGTH;
	global $global_facts, $person_privacy, $user_privacy, $HIDE_LIVE_PEOPLE, $GEDCOM, $SHOW_DEAD_PEOPLE;

	if (!$HIDE_LIVE_PEOPLE) return true;

	$username = getUserName();
	if (!empty($username)) {
		if (userIsAdmin($username)) return true;
		if (isset($user_privacy[$username]["all"])) {
			if ($user_privacy[$username]["all"] >= $PRIV_USER) return true;
			else return false;
		}
		if (isset($user_privacy[$username][$pid])) {
			if ($user_privacy[$username][$pid] >= $PRIV_USER) return true;
			else return false;
		}
		if (isset($person_privacy[$pid])) {
			if ($person_privacy[$pid]>=$PRIV_USER) return true;
			else return false;
		}
		if (!$USE_RELATIONSHIP_PRIVACY) return true;
		else {
			$isdead = is_dead_id($pid);
			if ($isdead) return true;
			else {
				$user = getUser($username);
				if (empty($user["gedcomid"][$GEDCOM])) return false;
				if ($user["gedcomid"][$GEDCOM]==$pid) return true;
				$relationship = get_relationship($user["gedcomid"][$GEDCOM], $pid, $CHECK_MARRIAGE_RELATIONS, $MAX_RELATION_PATH_LENGTH);
				if ($relationship!==false) return true;
				else return false;
			}
		}
	}

	//-- check the person privacy array for an exception
	if (isset($person_privacy[$pid])) {
		switch ($person_privacy[$pid]) {
			case $PRIV_PUBLIC:
				return true;
				break;
			default:
				return false;
				break;
		}
	}
	if ($SHOW_DEAD_PEOPLE < $PRIV_PUBLIC) return false;
    return is_dead_id($pid);
}

//----------------------------------- showLivingName
//-- should the names of living person be shown
//-- returns true to show the name, returns false
//-- to hide the name.  The default is to show the
//-- names of living people
function showLivingName($indirec) {
	global $SHOW_LIVING_NAMES, $PRIV_PUBLIC, $PRIV_USER, $PRIV_NONE;
	
	//-- get the id from the record
	$ct = preg_match("/0 @(.*)@ INDI/", $indirec, $match);
	if ($ct>0) $pid = $match[1];
	else $pid=0;
	
	return showLivingNameByID($pid);
}

//----------------------------------- showLivingNameByID
//-- should the names of living person be shown
//-- returns true to show the name, returns false
//-- to hide the name.  The default is to show the
//-- names of living people
function showLivingNameByID($pid) {
	global $SHOW_LIVING_NAMES, $PRIV_PUBLIC, $PRIV_USER, $PRIV_NONE, $person_privacy, $user_privacy;

	if ($SHOW_LIVING_NAMES>=$PRIV_PUBLIC) return true;
	
	$username = getUserName();
	if (!empty($username)) {
		if (isset($user_privacy[$username]["all"])) {
			if ($user_privacy[$username]["all"] < $PRIV_USER) return false;
			else return true;
		}
		if (isset($user_privacy[$username][$pid])) {
			if ($user_privacy[$username][$pid] < $PRIV_USER) return false;
			else return true;
		}
		if (isset($person_privacy[$pid])) {
			if ($person_privacy[$pid] < $PRIV_USER) return false;
			else return true;
		}
		if ($SHOW_LIVING_NAMES>=$PRIV_USER) return true;
	}
	//-- admin users can see everything
	if (userIsAdmin($username)) return true;
	//-- check the person privacy array for an exception
	if (isset($person_privacy[$pid])) {
		switch ($person_privacy[$pid]) {
			case $PRIV_PUBLIC:
				return true;
				break;
			default:
				return false;
				break;
		}
	}
	return false;
}

//----------------------------------- showFact
//-- determines if the given fact ($fact) should
//-- be shown for the given individual ($pid).
function showFact($fact, $pid) {
	global $PRIV_PUBLIC, $PRIV_USER, $PRIV_NONE, $PRIV_HIDE;
	global $global_facts, $person_facts;

	//-- if $PRIV_HIDE even admin users won't see everything
	if (isset($global_facts[$fact]))
	{
	  if (isset($global_facts[$fact]["show"]))
	  {
	    if ($global_facts[$fact]["show"] == $PRIV_HIDE) return false;
	  }
	}
	$username = getUserName();
	//-- admin users can see everything
	if (userIsAdmin($username)) return true;

	//-- first check the global facts array
	if (isset($global_facts[$fact]["show"])) {
		switch ($global_facts[$fact]["show"]) {
			case $PRIV_PUBLIC:
				return true;
				break;
			case $PRIV_USER:
				if (!empty($username)) return true;
				else return false;
				break;
			default:
				return false;
				break;
		}
	}
	//-- check the person facts array
	if (isset($person_facts[$pid][$fact]["show"])) {
		switch ($person_facts[$pid][$fact]["show"]) {
			case $PRIV_PUBLIC:
				return true;
				break;
			case $PRIV_USER:
				if (!empty($username)) return true;
				else return false;
				break;
			default:
				return false;
				break;
		}
	}
	if (find_person_record($pid)) return displayDetailsByID($pid);
	else return true;
}

//----------------------------------- showFactDetails
//-- determines if the details for given fact ($fact) should
//-- be shown for the given individual ($pid).
function showFactDetails($fact, $pid) {
	global $PRIV_PUBLIC, $PRIV_USER, $PRIV_NONE, $PRIV_HIDE;
	global $global_facts, $person_facts;

	//-- if $PRIV_HIDE even admin users won't see everything
	if (isset($global_facts[$fact]))
	{
	  if (isset($global_facts[$fact]["details"]))
	  {
	    if ($global_facts[$fact]["details"] == $PRIV_HIDE) return false;
	  }
	}

	$username = getUserName();
	//-- admin users can see everything
	if (userIsAdmin($username)) return true;
	//-- first check the global facts array
	if (isset($global_facts[$fact]["details"])) {
		switch ($global_facts[$fact]["details"]) {
			case $PRIV_PUBLIC:
				return true;
				break;
			case $PRIV_USER:
				if (!empty($username)) return true;
				else return false;
				break;
			default:
				return false;
				break;
		}
	}
	//-- check the person facts array
	if (isset($person_facts[$pid][$fact]["details"])) {
		switch ($person_facts[$pid][$fact]["details"]) {
			case $PRIV_PUBLIC:
				return true;
				break;
			case $PRIV_USER:
				if (!empty($username)) return true;
				else return false;
				break;
			default:
				return false;
				break;
		}
	}
	return true;
}

if ($USE_RELATIONSHIP_PRIVACY) {
	$NODE_CACHE = array();
}

?>