<?php
/*=================================================
	Project: phpGedView
	File: search.php
	Author: John Finlay
	Comments:
		Parses gedcom file and searches based on user query.

	Change Log:
		6/6/02 - File Created
		6/14/02 - Fixed bug in general search where a hit in the last record
			of the gedcom file would send the program into and infinite loop
		7/3/02 - Modified soundex search to use the indilist.ind index
		7/8/02 - Changed to use the indexes in the general search
		1/8/03 - Added firstname to soundex search

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: search.php,v 1.49.2.1 2004/02/02 15:18:12 yalnifj Exp $

require("config.php");

if (!isset($action)) $action="";

print_header($pgv_lang["search"]);
print_help_link("search_page_help", "page_help");
print "\n\t<div align=\"center\"><h2>".$pgv_lang["search_gedcom"]."</h2></div>\n\t";
?>
<table class="facts_table"><tr><td align="center">
<form method="get" action="search.php">
	<font class="label"><?php print $pgv_lang["enter_terms"]?>  </font>
	<?php print_help_link("search_enter_terms_help", "qm");?><br />
	<input type="hidden" name="action" value="general" />
	<input type="text" name="query" value="<?php if ($action=="general") print htmlspecialchars($query); ?>" />
	<input type="submit" value="<?php print $pgv_lang["search"]?>" />
</form>
</td><td align="center">
<script language="JavaScript" type="text/javascript">
	function checknames(frm) {
		if (frm.lastname.value=="") {
			alert("<?php print $pgv_lang["lastname_empty"]?>");
			frm.lastname.focus();
			return false;
		}
		return true;
	}
</script>
<form method="get" onsubmit="return checknames(this);" action="search.php">
	<font class="label"><?php print $pgv_lang["soundex_search"]?>  </font>
	<?php print_help_link("soundex_search_help", "qm");?><br />
	<input type="hidden" name="action" value="soundex" />
	<table><tr><td><?php print $pgv_lang["firstname_search"]?></td><td><input type="text" name="firstname" value="<?php if ($action=="soundex") print $firstname; ?>" /></td></tr>
	<tr><td><?php print $pgv_lang["lastname_search"]?></td><td><input type="text" name="lastname" value="<?php if ($action=="soundex") print $lastname; ?>" /></td></tr>
	<tr><td><?php print $pgv_lang["search_place"]?></td><td><input type="text" name="place" value="<?php if ($action=="soundex") print $place; ?>" /></td></tr>
	<tr><td><?php print $pgv_lang["search_year"]?></td><td><input type="text" name="year" value="<?php if ($action=="soundex") print $year; ?>" /></td></tr>
	</table>
	<input type="submit" value="<?php print $pgv_lang["search"]?>" />
</form>
</td></tr></table>
<?php

// ---- section to search and display results on a general keyword search
if ($action=="general") {
	if ((isset($query)) && ($query!="")) {
			$query = preg_replace("/\s+/", ".*", $query);
			print "<div align=\"center\"><font class=\"label\">".$pgv_lang["search_results"]."</font></div>";
			// -- array of names
			$myindilist = array();
			$mysourcelist = array();
			$myfamlist = array();

			$myindilist = search_indis($query);
			uasort($myindilist, "itemsort");

			$mysourcelist = search_sources($query);
			uasort($mysourcelist, "itemsort");
			reset($mysourcelist);

			$myfamlist = search_fams($query);
			uasort($myfamlist, "famsort");

			print "\n\t<div align=\"center\"><table class=\"list_table\">\n\t\t<tr>";
			if (count($myindilist)>0) print "<td class=\"list_label\"><img src=\"$PGV_IMAGE_DIR/$PGV_INDIS_IMG\" border=\"0\" width=\"25\" /> ".$pgv_lang["people"]."</td>";
			if (count($mysourcelist)>0) print "<td class=\"list_label\"><img src=\"$PGV_IMAGE_DIR/$PGV_SOURCE_IMG\" border=\"0\" width=\"25\" /> ".$pgv_lang["sources"]."</td>";
			if (count($myfamlist)>0) print "<td class=\"list_label\"><img src=\"$PGV_IMAGE_DIR/$PGV_SFAMILY_IMG\" border=\"0\" width=\"25\" /> ".$pgv_lang["families"]."</td>";
			print "</tr>\n\t\t<tr>";
			$i=0;
			$ct=count($myindilist);
			if ($ct>0) {
				print "<td class=\"list_value\">";
				foreach ($myindilist as $key => $value) {
			    	print_list_person($key, array($value["name"], $value["file"]));
			    	$i++;
				}
				print "<br />\n\t\t</td>";
			}
			$i=0;
			$ct=count($mysourcelist);
			if ($ct>0) {
				print "\n\t\t<td class=\"list_value\">";
				foreach ($mysourcelist as $key => $value) {
				    print "\n\t\t\t<a href=\"source.php?sid=$key&GEDCOM=".$value["file"]."\"><font class=\"list_item\">".$value["name"]."</font></a><br />\n";
				    $i++;
				}
				print "<br />\n\t\t</td>";
			}
			$i=0;
			$ct=count($myfamlist);
			if ($ct>0) {
				print "\n\t\t<td class=\"list_value\">";
				foreach ($myfamlist as $key => $value) {
				    print_list_family($key, array($value["name"], $value["file"]));
				    $i++;
				}
				print "<br />\n\t\t</td>";
			}
			print "</tr>\n\t</table></div>";
	}
}

// ----- section to search and display results for a Soundex last name search
if ($action=="soundex") {
	if ((!empty($lastname))||(!empty($firstname))) {
		$indilist = get_indi_list();
		$sindilist = array();
		// -- only get the names who match soundex
		foreach ($indilist as $key => $value) {
			$save = false;
			$name = preg_replace("/ [jJsS]r\.?,/", ",", $value["name"]);
			$names = preg_split("/,/", $name);
			if (soundex($names[0])==soundex($lastname)) {
				$save = true;
				if (!empty($firstname)) {
					$save=false;
					$firstnames = preg_split("/\s/", trim($firstname));
					if (isset($names[1])) $fnames = preg_split("/\s/", trim($names[1]));
					else $fnames = preg_split("/\s/", trim($names[0]));
					for($i=0; $i<count($fnames); $i++) {
						for($j=0; $j<count($firstnames); $j++) {
							if (soundex($fnames[$i])==soundex($firstnames[$j])) $save = true;
						}
					}
				}
				if ((!empty($place))||(!empty($year))) {
					$indirec = find_person_record($key);
					if (!empty($place)) {
						$pt = preg_match("/\d PLAC (.*$place.*)/i", $indirec, $match);
						if ($pt==0) $save = false;
					}
					if (!empty($year)) {
						$yt = preg_match("/\d DATE (.*$year.*)/i", $indirec, $match);
						if ($yt==0) $save = false;
					}
				}
			}
			if ($save) $sindilist["$key"] = $value;
		}

		uasort($sindilist, "itemsort");
		reset($sindilist);

		print "<div align=\"center\"><font class=\"label\">".$pgv_lang["search_results"]."</font>";
		print "\n\t<table class=\"list_table\">\n\t\t<tr>\n\t\t<td class=\"list_value\">";
		$i=0;
		$ct=count($sindilist);
		foreach ($sindilist as $key => $value) {
		    print_list_person($key, array($value["name"], $value["file"]));
			if ($i == floor($ct / 2)) print "\n\t\t</td>\n\t\t<td class=\"list_value\">";
		    $i++;
		}
		print "\n\t\t</td>\n\t\t</tr>\n\t</table></div>";
	}
}
print "<br /><br /><br />";
print_footer();

?>
