<?php
/*=================================================
	Project: phpGedView
	File: source.php
	Author: John Finlay
	Input Variables: $sid
	Comments:
		Parses gedcom file and displays information about a source.  You
		must supply a $sid value with the identifier for the source.

	Change Log:
		6/14/02 - File Created
		7/8/02 - Changed to use index files
		3/4/03 - Fixed where some information in the gedcom record was
			not being displayed (yalnifj)

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: source.php,v 1.41.2.2 2004/02/02 15:18:12 yalnifj Exp $

require("config.php");
require($PGV_BASE_DIRECTORY.$factsfile["english"]);
require($PGV_BASE_DIRECTORY.$factsfile[$LANGUAGE]);

$name = get_source_descriptor($sid);
print_header("$name - $sid - ".$pgv_lang["source_info"]);
print_help_link("sources_help", "page_help");
?>
<script language="JavaScript" type="text/javascript">
	function show_gedcom_record() {
		var recwin = window.open("gedrecord.php?pid=<?php print $sid ?>", "", "top=0,left=0,width=300,height=400,scrollbars=1,scrollable=1,resizable=1");
	}
	function showchanges() {
		window.location = '<?php print $PHP_SELF."?".$QUERY_STRING."&show_changes=yes"; ?>';
	}
</script>
<table width="100%"><tr><td>
<?php
print "\n\t<font class=\"name_head\">$name</font><br />";
if (userCanEdit(getUserName())&&($view!="preview")) {
	if (isset($pgv_changes[$sid."_".$GEDCOM])) {
		print "<a href=\"source.php?sid=$sid&show_changes=yes\">".$pgv_lang["show_changes"]."</a>"."  ";
		print_help_link("show_changes_help", "qm");
		print "<br />";
	}
	print "<a href=\"#\" onclick=\"return deletesource('$sid');\">".$pgv_lang["delete_source"]."</a>";
	print_help_link("delete_source_help", "qm");
	print "<br />\n";
}
print "<br />";
$source = find_source_record($sid);

print "\n<table class=\"facts_table\">";
$ct = preg_match("/1 TITL (.*)/", $source, $match);
if ($ct > 0) {
	$titlerec = get_sub_record(1, $match[0], $source);
	print "<tr><td class=\"facts_label\"><font class=label><font class=label>".$pgv_lang["title"]."</font></td><td class=\"facts_value\"><font class=field>".trim($match[1]);
	print get_cont(2, $titlerec);
	print "</font></td></tr>\n";
}
$ct = preg_match("/1 AUTH (.*)/", $source, $match);
if ($ct > 0) {
	$authrec = get_sub_record(1, $match[0], $source);
	print "<tr><td class=\"facts_label\"><font class=label>".$pgv_lang["author"].":</font></td><td class=\"facts_value\"><font class=field>$match[1]";
	print get_cont(2, $authrec);
	print "</font></td></tr>\n";
}
$ct = preg_match("/1 PUBL (.*)/", $source, $match);
if ($ct > 0) {
	$publrec = get_sub_record(1, $match[0], $source);
	print "<tr><td class=\"facts_label\"><font class=label>".$pgv_lang["publication"]."</font></td><td class=\"facts_value\"><font class=field>$match[1]";
	print get_cont(2, $publrec);
	print "</font></td></tr>\n";
}
$ct = preg_match("/1 REPO @(.*)@/", $source, $match);
if ($ct > 0) {
	$reporec = get_sub_record(1, $match[0], $source);
	print "<tr><td class=\"facts_label\"><font class=label>".$factarray["REPO"]."</font></td><td class=\"facts_value\"><font class=field>";
	$ct = preg_match("/\d CALN (.*)/", $source, $cmatch);
	if ($ct > 0) print "<font class=\"date\">".$factarray["CALN"].":</font> <font class=field>$cmatch[1]</font>";
	print_repository_record($match[1]);
	print_fact_notes($reporec, 2);
	print "</font></td></tr>\n";
}
$cs = preg_match("/1 TEXT (.*)/", $source, $tmatch);
if ($cs>0) {
	$textrec = get_sub_record(1, $tmatch[0], $source);
	print "\n<tr><td class=\"facts_label\"><font class=\"label\">".$pgv_lang["text"]." </font></td><td class=\"facts_value\"><font class=\"field\">".trim($tmatch[1]);
	print get_cont(2, $textrec);
	print "</font>\n</td></tr>\n";
}
$gedlines = preg_split("/\n/", $source);
$lct = count($gedlines);
$factrec = "";	// -- complete fact record
$line = "";	// -- temporary line buffer
$linenum = 0;
for($i=1; $i<=$lct; $i++) {
	if ($i<$lct) $line = $gedlines[$i];
	else $line=" ";
	if (empty($line)) $line=" ";
	if (($i==$lct)||($line{0}==1)) {
		$ft = preg_match("/1\s(_?.{3,4})\s(.*)/", $factrec, $match);
		if ($ft>0) $fact = $match[1];
		else $fact="";
		$fact = trim($fact);
		if ($fact=="OBJE") {
			print_main_media($factrec, 1, $sid, $linenum);
		}
		if ($fact=="NOTE") {
			print_main_notes($factrec, 1, $sid, $linenum);
		}
		$factrec = $line;
		$linenum = $i;
	}
	else $factrec .= "\n".$line;
}

print "</table>\n\n";
print "\n\t\t<br /><br /><dd><font class=\"label\">".$pgv_lang["other_records"]."</font>";
print_help_link("sources_listbox_help", "qm");
flush();

$query = "SOUR @$sid@";
// -- array of names
$myindilist = array();
$myfamlist = array();

$myindilist = search_indis($query);
uasort($myindilist, "itemsort");
print "\n\t\t<dd><table class=\"list_table\">\n\t\t<tr><td class=\"list_label\">".$pgv_lang["individuals"]."</td>\n<td class=\"list_label\">".$pgv_lang["families"]."</td></tr>\n\t\t<tr><td class=\"list_value\">";
$i=0;
$ct=count($myindilist);
foreach ($myindilist as $key => $value) {
	print_list_person($key, array($value["name"], $value["file"]));
	$i++;
}
print "<br />\n\t\t</td>\n\t\t<td class=\"list_value\">";
$myfamlist = search_fams($query);
uasort($myfamlist, "itemsort");
$i=0;
$ct=count($myfamlist);
foreach ($myfamlist as $key => $value) {
	print_list_family($key, array($value["name"], $value["file"]));
    $i++;
}
print "<br />\n\t\t</td></tr>\n\t</table>";
print "</td><td valign=top>";
if ($view!="preview") {
	print "\n\t<table cellspacing=\"10\" align=\"right\"><tr>";
	if ($SHOW_GEDCOM_RECORD) {
		print "\n\t\t<td align=\"center\" valign=\"top\"><span class=\"link\"><a href=\"javascript:show_gedcom_record();\"><img class=\"icon\" src=\"$PGV_IMAGE_DIR/gedcom.gif\" border=\"0\" /><br />".$pgv_lang["view_gedcom"]."</a>";
		print_help_link("show_source_gedcom_help", "qm");
		print "</span></td>";
	}
	if ($ENABLE_CLIPPINGS_CART) {
		print "</tr>\n\t\t<tr><td align=\"center\" valign=\"top\"><span class=\"link\"><a href=\"clippings.php?action=add&id=$sid&type=source\"><img class=\"icon\" src=\"$PGV_IMAGE_DIR/clippings.gif\" border=\"0\" /><br />".$pgv_lang["add_to_cart"]."</a>";
		print_help_link("add_source_clip_help", "qm");
		print "</span></td>";
	}
	print "</tr></table>";
}
print "</td></tr></table>\n";
print_footer();

?>
