<?php
/*=================================================
	Project: phpGedView
	File: sourcelist.php
	Author: John Finlay
	Comments:
		Parses gedcom file and displays a list of the sources in the file.

	Change Log:
		6/14/02 - File Created
		7/8/02 - changed to use index files

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: sourcelist.php,v 1.19.2.3 2004/02/03 22:13:22 yalnifj Exp $

require("config.php");

$sourcelist = get_source_list();
uasort($sourcelist, "itemsort");
$ct = count($sourcelist);

print_header($pgv_lang["source_list"]);
print_help_link("sourcelist_help", "page_help");
print "<div class=\"center\">";
//print "\n\t<center><h2>".$pgv_lang["source_list"]."</h2></center>\n\t";
print "<h2>".$pgv_lang["source_list"]."</h2>\n\t";
//print "\n\t<center>$ct ".$pgv_lang["sources_found"]." <br />\n\t<table class=\"list_table, $TEXT_DIRECTION\\">\n\t\t<tr>\n\t\t<td class=\"list_value\">";
print "\n\t$ct ".$pgv_lang["sources_found"]." <br />\n\t<table class=\"list_table, $TEXT_DIRECTION\">\n\t\t<tr>\n\t\t<td class=\"list_value\">";
$i=0;
// -- print the array
foreach ($sourcelist as $key => $value) {

		if (ord(substr(stripslashes($value["name"]), 0, 2)) == 215){
			//print "hi";//"<div class =\"rtl\"><a href=\"famlist.php?alpha=".$namecount["alpha"]."&amp;surname_sublist=$surname_sublist&amp;surname=".stripslashes($namecount["name"])."\">".stripslashes($namecount["name"])." - &rlm;[".($namecount["match"])."]&rlm;";
			print "\n\t\t\t<div class=\"rtl\"><a href=\"source.php?sid=$key\"><font class=\"list_item\">".stripslashes($value["name"])."</font></a></div>\n";
		} else {
    		print "\n\t\t\t<div class=\"ltr\"><a href=\"source.php?sid=$key\"><font class=\"list_item\">".stripslashes($value["name"])."</font></a></div>\n";
    	}
    $i++;
}
print "\n\t\t</td>\n\t\t</tr>\n\t</table>";
print_help_link("sourcelist_listbox_help", "qm");
print "<br /><br />";
print_footer();

?>