<?php
/*=================================================
	Project: phpGedView
	File: timeline.php
	Author: John Finlay
	Input Variables: $pids[]
	Comments:
		Parses gedcom file and displays timeline information about an individual
		or group of individuals.

	Change Log:
		9/17/02 - File Created
		1/17/03 - Updated for multiple marriages
		3/14/03 - Allow 6 people to be on the timeline at once, append
			"I" to id number if not included (yalnifj)
		2004-1-11 - Question marks added for Help pop-ups (Jans B. Luder)
===================================================*/
# $Id: timeline.php,v 1.56.2.2 2004/02/03 22:13:22 yalnifj Exp $

require("config.php");
require($PGV_BASE_DIRECTORY.$factsfile["english"]);
require($PGV_BASE_DIRECTORY.$factsfile[$LANGUAGE]);

if (!isset($pids)) $pids=array();

// array of GEDCOM elements that will be found but should not be displayed
$nonfacts = array();
$nonfacts[] = "FAMS";
$nonfacts[] = "FAMC";
$nonfacts[] = "MAY";
$nonfacts[] = "BLOB";
$nonfacts[] = "OBJE";
$nonfacts[] = "SEX";
$nonfacts[] = "NAME";
$nonfacts[] = "SOUR";
$nonfacts[] = "NOTE";
$nonfacts[] = "BAPL";
$nonfacts[] = "ENDL";
$nonfacts[] = "SLGC";
$nonfacts[] = "SLGS";
$nonfacts[] = "_TODO";
$nonfacts[] = "CHAN";
$nonfacts[] = "HUSB";
$nonfacts[] = "WIFE";
$nonfacts[] = "CHIL";
$nonfacts[] = "";

if ((isset($view))&&($view=="preview")) $baseyoffset-=240;
if (empty($scale)) $scale = 5;
if ($scale<2) $scale=2;

// function to print details about a fact
function print_time_fact($i, $factitem) {
	global $baseyear, $factarray, $BOXFILLCOLOR, $BOXBORDERCOLOR, $basexoffset, $baseyoffset, $prevyoffset, $yoffset, $bheight, $birthyears, $endoffset, $yoffsetarray,$pgv_lang;
	global $PGV_IMAGE_DIR, $scale, $monthtonum;
	global $PGV_DLINE2_IMG, $PGV_HLINE_IMG, $PGV_DLINE_IMG;
	$xoffset=$basexoffset;

	$factrec=$factitem[1];
	$ft = preg_match("/1 (_?[A-Z]{3,5})(.*)/", $factrec, $match);
	if ($ft>0) {
		$fact = trim($match[1]);
		$event = trim($match[2]);
	}
	else {
		$fact="";
		$event="";
	}
	if (array_key_exists($fact, $factarray)) {
		$ct = preg_match("/2 DATE (.*)/", $factrec, $match);
		if ($ct>0) {
			$adate = trim($match[1]);
			$year = date("Y");
			$month = "jan";
			$day = 1;
			$ct = preg_match("/(\d{1,2})?\s?([a-zA-Z]{3})?\s?(\d{4})/", $adate, $match);
			$fields = preg_split("/\s+/", $adate);
			$num = count($fields);
			$year = $fields[$num-1];
			$month = 1;
			$day = 1;
			if ($ct>0) {
				$day = $match[1];
				$month = strtolower($match[2]);
				if (isset($monthtonum[$month])) $month = $monthtonum[$month];
				else $month = 1;
				$year = $match[3];
			}
			$age = $year-$birthyears[$factitem[0]];
			$yoffset = $baseyoffset+240+(($year-$baseyear) * $scale);
			$yoffset = $yoffset + (($month / 12) * $scale);
			$yoffset = $yoffset + (($day / 30) * ($scale/12));
			$dyoffset = $yoffset + $bheight/2;
			while(in_array(floor($yoffset / ($bheight+2)), $yoffsetarray)) {
				$yoffset+=$bheight+2;
				$xoffset+=$bheight+2;
				if ($yoffset>2000) exit;
			}
			$yoffsetarray[$i]=floor($yoffset / ($bheight+2));
			if (empty($endoffset)) $endoffset=$yoffset;
			if ($yoffset > $endoffset) $endoffset=$yoffset;
			// draw diagnal line box
			print "\n\t\t<div id=\"dbox$i\" style=\"position:absolute; left:".$basexoffset."px; top:".$dyoffset."px; width: ".($yoffset-$dyoffset+($bheight/2))."px; height:".($yoffset-$dyoffset+($bheight/2))."px; background-image: url($PGV_IMAGE_DIR/$PGV_DLINE2_IMG);\">";
			print "\n\t\t\t<img src=\"$PGV_IMAGE_DIR/spacer.gif\" name=\"spaceline$i\" id=\"spaceline$i\" width=\"".($yoffset-$dyoffset)."\" height=\"".($yoffset-$dyoffset)."\" align=\"left\" hspace=\"0\" vspace=\"0\" alt=\"\" />";
			print "\n\t\t</div><br />";
			// draw the box
			print "\n\t\t<div id=\"box$i\" style=\"position:absolute; left:".$xoffset."px; top:".$yoffset."px; height:".$bheight."px; \" onmousedown=\"myMD3(this, $i);\">";
			print "\n\t\t\t<table cellspacing=\"0\" cellpadding=\"0\"><tr><td>";
			print "\n\t\t\t<img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" name=\"boxline$i\" id=\"boxline$i\" height=\"3\" align=\"left\" hspace=\"0\" vspace=\"0\" alt=\"\" />";
			print "\n\t\t\t</td><td valign=\"top\">";
			print "\n\t\t\t<table class=\"person$factitem[0]\" cellspacing=\"0\"><tr><td valign=\"top\"><font class=\"field\">";
			if ($fact!='EVEN') print $factarray[$fact];
			else {
				// find generic type for fact
				$ct = preg_match("/2 TYPE (.*)/", $factrec, $match);
				if ($ct>0) print $match[1];
			}
			if ($event!="") print " - $event";
			print " - <font class=\"date\">".get_changed_date($adate)."</font> - ";
			$ct = preg_match("/2 PLAC (.*)/", $factrec, $match);
			if ($ct>0) print $match[1];
			print " (".$pgv_lang["age"]." $age)";
			print "\n\t\t\t</font></td></tr></table>";
			print "\n\t\t\t</td></tr></table>\n\t\t</div><br />";
		}
	}
}
// end print fact function

print_header($pgv_lang["timeline_title"]);
print_help_link("time_line_help", "page_help");
?>
<script language="JavaScript" type="text/javascript">
//<!-- Modified from Original by Randy Bennett (rbennett@thezone.net) -->
//<!-- Original Web Site:  http://home.thezone.net/~rbennett/sitemap.htm -->
<!--
N = (document.all) ? 0 : 1;
var ob=null;
var Y=0;
var X=0;
var oldx=0;
var personnum=0;
var type=0;
var state=0;
var oldstate=0;

function MD(e) {
	if (N) {
		if (document.layers) {
			ob = document.layers[e.target.name];
		}
		else {
			alert(e.target.name);
			ob = e.target;
		}
		X=e.x;
		Y=e.y;
		return false;
	}
	else {
		ob = event.srcElement.parentElement.style;
		X=event.offsetX;
		Y=event.offsetY;
	}
}

function myMD(divbox, num) {
	ob=divbox.style;
	personnum=num;
	type=0;
	if (N) {
		X=ob.left;
		Y=ob.top;
	}
	else {
		X=ob.pixelLeft;
		Y=ob.pixelTop;
		oldx = event.clientX + document.documentElement.scrollLeft;
	}
}

function myMD2(divbox) {
	ob=document.getElementById(divbox);
	X=ob.style.left;
	Y=ob.style.top;
}

function myMD3(divbox, num) {
	ob=divbox.style;
	personnum=num;
	type=1;
	if (N) {
		oldx=parseInt(ob.left);
		oldlinew=0;
	}
	else {
		oldx = ob.pixelLeft;
		oldlinew = event.clientX + document.documentElement.scrollLeft;
	}
}

function MM(e) {
	if (ob) {
		if (type==0) {
			// age boxes
			newy = 0;
			newx = 0;
			if (N) {
				if ((e.pageY>=topy)&&(e.pageY<=bottomy)) newy = e.pageY;
				else if (e.pageY < topy) newy = topy;
				else newy = bottomy;
				newx = e.pageX;
				if (oldx==0) oldx=newx;
			}
			else {
				newy = event.clientY + document.documentElement.scrollTop;
				newx = event.clientX + document.documentElement.scrollLeft;
				if ((newy >= topy)&&(newy<=bottomy)) newy = newy;
				else if (newy < topy) newy = (topy+1);
				else newy = (bottomy-1);
			}
			ob.top = newy+"px";
			year=Math.round(((newy-topy)/<?php print $scale; ?>)+baseyear);
			age=year-birthyears[personnum];
			eval('document.ageform'+personnum+'.year.value=year;');
			eval('document.ageform'+personnum+'.age.value=age;');
			line = document.getElementById('ageline'+personnum);
			line.width=(line.width+(newx-oldx));
			oldx=newx;
			return false;
		}
		else {
			// event boxes
			if (N) {
				// get mouse Y
				newy = e.pageY;
				// get mouse X
				linewidth = e.pageX;
			}
			else {
				// get mouse Y
				newy = event.clientY + document.documentElement.scrollTop;
				// get mouse X
				linewidth = event.clientX + document.documentElement.scrollLeft;
			}
			// get diagnal line box
			dbox = document.getElementById('dbox'+personnum);
			// get Y coord of diagnal box
			dbtop = parseInt(dbox.style.top);
			if (state==1) {
				dbtop=dbtop+parseInt(dbox.style.height);
			}
			// set up limits
			if (dbtop-175 < topy) etopy = topy;
			else etopy = dbtop-175;
			if (dbtop+175 > bottomy) ebottomy = bottomy;
			else ebottomy = dbtop+175;
			// check if in the bounds of the limits
			if ((newy >= etopy)&&(newy<=ebottomy)) newy = newy;
			else if (newy < etopy) newy = etopy;
			else if (newy >ebottomy) newy = ebottomy;
			// calculate the change in Y position
			dy = newy-parseInt(ob.top);
			// check if we are above the starting point and switch the background image
			if (newy+(bheight/2) < dbtop) {
				dbox.style.backgroundImage = "url('<?php print "$PGV_IMAGE_DIR/$PGV_DLINE_IMG"; ?>')";
				dbox.style.backgroundPosition = "0% 100%";
				dy = (-1)*dy;
				state=1;
			}
			else {
				dbox.style.backgroundImage = "url('<?php print "$PGV_IMAGE_DIR/$PGV_DLINE2_IMG"; ?>')";
				dbox.style.backgroundPosition = "0% 0%";
				state=0;
			}
			// the new X posistion moves the same as the y position
			newx = oldx+dy;
			// get the width for the diagnal box
			newwidth = (parseInt(ob.left)-parseInt(dbox.style.left));
			// set the width
			oldheight = parseInt(dbox.style.height);
			dbox.style.width=newwidth+"px";
			dbox.style.height=newwidth+"px";
			if (state==1) dbox.style.top = (parseInt(dbox.style.top)+oldheight-parseInt(newwidth))+"px";
			// set the X position of the box
			ob.left=newx+"px";
			// set new top positions
			ob.top = newy+"px";
			// change the line width to the change in the mouse X position
			line = document.getElementById('boxline'+personnum);
			if (oldlinew!=0) line.width=line.width+(linewidth-oldlinew);
			oldlinew = linewidth;
			oldx=newx;
			oldstate=state;
			return false;
		}
	}
}

function MU() {
ob = null;
oldx=0;
}

if (N) {
	document.captureEvents(Event.MOUSEDOWN | Event.MOUSEMOVE | Event.MOUSEUP);
	//document.onmousedown = MD;
}
document.onmousemove = MM;
document.onmouseup = MU;

function showhide(divbox, checkbox) {
	if (checkbox.checked) {
		MM_showHideLayers(divbox, ' ', 'show', ' ');
	}
	else {
		MM_showHideLayers(divbox, ' ', 'hide', ' ');
	}
}

var pasteto;
function open_find(textbox) {
	pasteto = textbox;
	findwin = window.open('findid.php', '', 'left=50,top=50,width=450,height=450,resizable=1,scrollbars=1');
}
function paste_id(value) {
	pasteto.value=value;
}
//-->
</script>
<?php
$f=0;		//  counter
$indifacts = array();						// array to store the fact records in for sorting and displaying
$birthyears=array();
$baseyear=date("Y");
print "\n\t<h2>".$pgv_lang["timeline_chart"]."</h2>";

print "\n\t".$pgv_lang['timeline_instructions']."<br />";
print "\n\t\t<form name=\"people\" action=\"timeline.php\">";
if (!empty($newpid)) {
	$indirec = find_person_record($newpid);
	$disp=displayDetails($indirec);
	if (!$disp) {
		print_privacy_error($CONTACT_EMAIL);
	}
	else {
		$pids[count($pids)]=$newpid;
	}
}
print "\n\t\t\t<table class=\"timeline_table\"><tr>";
$pidlinks = "";
$pt = count($pids);
for($pp=0; $pp<$pt; $pp++) {
	$indirec = find_person_record($pids[$pp]);
	if ($indirec!==false) $pidlinks .= "pids[]=$pids[$pp]";
	else {
		$pids[$pp]=$GEDCOM_ID_PREFIX.$pids[$pp];
		$indirec = find_person_record($pids[$pp]);
		if ($indirec!==false) $pidlinks .= "pids[]=$pids[$pp]";
		else unset($pids[$pp]);
	}
}
$pids = array_values($pids);
for($p=0; $p<count($pids); $p++) {
	$pid = $pids[$p];
	if (preg_match("/[A-Za-z]+/", $pid)==0) $pid = $GEDCOM_ID_PREFIX.$pid;
	$indirec = find_person_record($pid);
	if ($indirec!==false) {
		print "<td class=\"person$p\">\n\t\t\t\t";
		print "<a href=\"individual.php?pid=$pid\">".get_sortable_name($pid)."</a>";
		print "<input type=\"hidden\" name=\"pids[$p]\" value=\"$pid\" />";
		print "<br /><a href=\"timeline.php?";
		$j=0;
		for($pp=0; $pp<$p; $pp++) {
			print "pids[$j]=$pids[$pp]&amp;";
			$j++;
		}
		for($pp=$p+1; $pp<count($pids); $pp++) {
			print "pids[$j]=$pids[$pp]&amp;";
			$j++;
		}
		print "scale=$scale";
		print "\"><span class=\"details1\">".$pgv_lang["remove_person"]."</span></a>";
		print_help_link("remove_person_help", "qm");
		print "\n\t\t\t\t<span class=\"details1\"><br /><input type=\"checkbox\" name=\"agebar$p\" value=\"ON\" onclick=\"showhide('agebox$p', this);\" />".$pgv_lang["show_age"]."</span>";
		print_help_link("show_age_marker_help", "qm");
		print "<br />\n\t\t\t</td>";
		// find all the fact information
		$indilines = split("\n", $indirec);	// find the number of lines in the individuals record
		$lct = count($indilines);
		$factrec = "";	// complete fact record
		$line = "";	// temporary line buffer
		for($i=1; $i<$lct; $i++) {
			$line = $indilines[$i];
			if (empty($line)) $line=" ";
			if (($i==$lct)||($line{0}==1)) {
				$fct = preg_match("/1\s(_?.{3,4})\s(.*)/", $factrec, $match);
				if ($fct>0) $fact = $match[1];
				else $fact="";
				$fact = trim($fact);
				if (!in_array($fact, $nonfacts)) {
					$ct = preg_match("/2 DATE (.*)/", $factrec, $match);
					if ($ct>0) $adate = trim($match[1]);
					else $adate="";
					$fields = preg_split("/\s+/", $adate);
					$year=$fields[count($fields)-1];
					if ($year>0) {
						if ($year<$baseyear) $baseyear=$year;
						if (!isset($birthyears[$p])) $birthyears[$p] = $year;
						else if ($year < $birthyears[$p]) $birthyears[$p] = $year;
						$factitem = array();
						$factitem[0]=$p;
						$factitem[1]=$factrec;
						$indifacts[$f]=$factitem;
						$f++;
					}
				}
				$factrec = $line;
			}
			else $factrec .= "\n".$line;
		}
		// find family as spouse
		$ct = preg_match_all("/1\s+FAMS\s+@(.*)@/", $indirec, $match, PREG_SET_ORDER);
		for($i=0; $i<$ct; $i++) {
			$famrec = find_family_record($match[$i][1]);
			$parents=find_parents_in_record($famrec);
			if ($parents['HUSB']==$pid) $spouse=$parents['WIFE'];
			else $spouse=$parents['HUSB'];
			$indilines = split("\n", $famrec);	// find the number of lines in the individuals record
			$lct = count($indilines);
			$factrec = "";	// complete fact record
			$line = "";	// temporary line buffer
			for($i=1; $i<=$lct; $i++) {
				if ($i<$lct) $line = $indilines[$i];
				else $line=" ";
				if (empty($line)) $line=" ";
				if (($i==$lct)||($line{0}==1)) {
					$fct = preg_match("/1\s(_?.{3,4})\s(.*)/", $factrec, $match);
					if ($fct>0) $fact = $match[1];
					else $fact="";
					$fact = trim($fact);
					if (!in_array($fact, $nonfacts)) {
						$ct = preg_match("/2 DATE (.*)/", $factrec, $match);
						if ($ct>0) $adate = trim($match[1]);
						else $adate="";
						$fields = preg_split("/\s+/", $adate);
						$year=$fields[count($fields)-1];
						if ($year>0) {
							if ($year<$baseyear) $baseyear=$year;
							if (!isset($birthyears[$p])) $birthyears[$p] = $year;
							else if ($year < $birthyears[$p]) $birthyears[$p] = $year;
							$factrec.="\nSPOUSE: $spouse\n";
							$factitem = array();
							$factitem[0]=$p;
							$factitem[1]=$factrec;
							$indifacts[$f]=$factitem;
							$f++;
						}
					}
					$factrec = $line;
				}
				else $factrec .= "\n".$line;
			}
		}
	}
}
if ($p<6) print "\n\t\t\t\t<td class=\"person$p\" valign=\"top\">".$pgv_lang["add_another"]."  ";
print_help_link("add_person_help", "qm");
print "<input type=\"text\" size=\"5\" name=\"newpid\" /><font size=\"1\"><a href=\"javascript:open_find(document.people.newpid);\">".$pgv_lang["find_id"]."</a></font> <input type=\"submit\" value=\"".$pgv_lang["show"]."\" /></td>";
print "<td>";
if ($p!=0) {
	print "<a href=\"$PHP_SELF?$pidlinks&amp;scale=".($scale+2)."\">".$pgv_lang["zoom_in"]."</a><br />";
	print "<a href=\"$PHP_SELF?$pidlinks&amp;scale=".($scale-2)."\">".$pgv_lang["zoom_out"]."</a>";
}
print "</td>";
print "</tr></table>\n\t\t</form>";
// if there are no ids coming in then don't try to print info for them
if ($p!=0) {
	$yoffsetarray=array();
	$bheight=20;
	$endoffset=$baseyoffset+240;
	usort($indifacts, "compare_facts");
	foreach ($indifacts as $key => $value) {
		print_time_fact($key, $value);
	}
	$yoffset = $endoffset;
	if ($yoffset < $baseyoffset) $yoffset = $baseyoffset+242;
	print "\n\t\t<div id=\"line$pid\" style=\"position:absolute; left:".($basexoffset)."px; top:".($baseyoffset+242-25+($bheight/2))."px; \"><img src=\"$PGV_IMAGE_DIR/$PGV_VLINE_IMG\" width=\"3\" height=\"".(($yoffset)-($baseyoffset+240-50))."\" alt=\"\" /></div>";
	// print the age boxes
	for($p=0; $p<count($pids); $p++) {
		$ageyoffset = (($yoffset-($yoffset/3))+($bheight * $p));
		if ($ageyoffset < ($baseyoffset+242-25+($bheight/2))) $ageyoffset = ($baseyoffset+242-25+($bheight/2));
		print "\n\t\t<div id=\"agebox$p\" style=\"position:absolute; left:".$basexoffset."px; top:".$ageyoffset."px; height:".$bheight."px; visibility: hidden;\" onmousedown=\"myMD(this, $p);\">";
		print "\n\t\t\t<form name=\"ageform$p\" action=\"timeline.php\"><table cellspacing=\"0\" cellpadding=\"0\"><tr><td>";
		print "\n\t\t\t<img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" name=\"ageline$p\" id=\"ageline$p\" align=\"left\" hspace=\"0\" vspace=\"0\" width=\"25\" height=\"3\" alt=\"\" />";
		print "\n\t\t\t</td><td valign=\"top\">";
		$tyear = round(($ageyoffset-($baseyoffset+242-25+($bheight/2)))/$scale)+$baseyear;
		if (!isset($birthyears[$p])) $birthyears[$p] = 0;
		$tage = $tyear-$birthyears[$p];
		print "\n\t\t\t<table class=\"person$p\"><tr><td valign=\"top\"><span class=\"field\">";
		print $pgv_lang["year"]."<input class=\"label\" style=\"border: none; width:35px; background-color: transparent;\" name=\"year\" size=\"4\" readonly=\"readonly\" value=\"$tyear\" /> (".$pgv_lang["age"]." <input class=\"label\" style=\" border: none; width:20px; background-color: transparent;\" name=\"age\" size=\"2\" readonly=\"readonly\" value=\"$tage\" />) ";
		print "\n\t\t\t</span></td></tr></table>";
		print "\n\t\t\t</td></tr></table>\n\t\t</form></div><br />";
	}
	print "<script language=\"JavaScript\" type=\"text/javascript\">";
	print "\nvar bottomy = $yoffset+25;";
	print "\nvar topy = ".($baseyoffset+240-25).";";
	print "\nvar baseyear = $baseyear-(25/$scale);";
	print "\nvar birthyears = new Array();";
	for($c=0; $c<count($pids); $c++) {
		print "\nbirthyears[$c]=$birthyears[$c];";
	}
	print "\nvar bheight=$bheight;";
	print "\n</script>";
	$yoffset = $yoffset + $bheight;
}
else {
	$yoffset=$baseyoffset+240;
}

$yoffset+=50;
print "\n\t\t<div id=\"footerbox\" style=\"position:absolute; left:0px; top:".$yoffset."px; width:100%;  \">";
$without_close=true;
print_footer();
print "\n\t</div></body>\n</html>";


?>
