<?php
/*=================================================
	Project: phpGedView
	File: uploadgedcom.php
	Author: John Finlay
	Comments:
		Allow admin users to upload a new gedcom using a
		web interface.

	phpGedView: Genealogy Viewer
	Copyright (C) 2002 to 2003  John Finlay and Others

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: uploadgedcom.php,v 1.12.2.3 2004/01/29 21:12:32 yalnifj Exp $

require "config.php";

if (!userIsAdmin(getUserName())) {
	header("Location: login.php?url=uploadgedcom.php");
	exit;
}

if ((isset($action)) && ($action=="upload")) {
	if (move_uploaded_file($_FILES['gedcomfile']['tmp_name'], $INDEX_DIRECTORY.$_FILES['gedcomfile']['name'])) {
		AddToLog("Gedcom ".$INDEX_DIRECTORY.$_FILES['gedcomfile']['name']." uploaded by >".getUserName()."<");
		$sFile = $INDEX_DIRECTORY.basename($_FILES['gedcomfile']['name']);
		// AE - - - - extra code to convert gedcom from ANSI to UTF-8 - - - - -
		if (isset($convert)) {
			$dFile = $sFile;
			$bakFile = $sFile . ".bak";

			rename($sFile, $bakFile);

			$handle = fopen($bakFile, "r");
			$contents = fread ($handle, filesize ($bakFile));
			fclose ($handle);

			$pos = strpos($contents, "1 CHAR ANSI");
			if ($pos === FALSE) {
				rename($bakFile, $dFile);
			}
			else {
				$fxlated = utf8_encode($contents);
				$contents = str_replace("1 CHAR ANSI", "1 CHAR UTF8", $fxlated);
				$handle = fopen($dFile, "w");
				fwrite($handle, $contents);

				fclose($handle);
				unlink($bakFile);
			}
		}
		// AE - - - - - end of extra code - - - - - -
		$ged = array();
		$ged["gedcom"] = $_FILES['gedcomfile']['name'];
		$ged["config"] = "config_gedcom.php";
		$ged["privacy"] = "privacy.php";
		# $ged["title"] = "Genealogy from ".$_FILES['gedcomfile']['name'];
		$ged["title"] = str_replace("#GEDCOMFILE#", basename($_FILES['gedcomfile']['name']), $pgv_lang["new_gedcom_title"]);
		$ged["path"] = $sFile;
		$GEDCOMS[basename($_FILES['gedcomfile']['name'])] = $ged;
		store_gedcoms();
		header("Location: editconfig_gedcom.php?ged=".basename($_FILES['gedcomfile']['name']));
		exit;
	}
	else {
		$upload_errors = array($pgv_lang["file_success"], $pgv_lang["file_too_big"], $pgv_lang["file_too_big"],$pgv_lang["file_partial"], $pgv_lang["file_missing"]);
		$error = $pgv_lang["upload_error"]."<br />".$upload_errors[$_FILES['gedcomfile']['error']];
	}
}

print_header($pgv_lang["upload_gedcom"]);
?>
<center>
<?php print "<font class=\"subheaders\">".$pgv_lang["upload_gedcom"]."</font><br /><br />\n"; ?>
<?php if (!empty($error)) print "<font class=\"error\">".$error."</font><br /><br />\n"; ?>
<?php print $pgv_lang["upload_help"].$INDEX_DIRECTORY; ?>
<br />
<form enctype="multipart/form-data" method="post">
<input type="hidden" name="action" value="upload">
<?php print $pgv_lang["gedcom_file"];?> <input name="gedcomfile" type="file"><br />
<input type="checkbox" name="convert" value="yes" checked> <?php print $pgv_lang["ansi_to_utf8"]; ?><br />
<input type="submit" value="<?php print $pgv_lang["upload_gedcom"];?>">
</form>
<br /><br /><br />
</center>
<?php
print_footer();
?>