<?php
/*=================================================
	Project: phpGedView
	File: uploadmedia.php
	Author: John Finlay
	Comments:
		Allow admin users to upload a new gedcom using a
		web interface.

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
===================================================*/
# $Id: uploadmedia.php,v 1.7 2004/01/14 15:34:22 yalnifj Exp $

require "config.php";

if (!userCanEdit(getUserName())) {
	header("Location: login.php?url=uploadgedcom.php");
	exit;
}

print_header($pgv_lang["upload_media"]);
?>
<center>
<?php 
	print "<font class=\"subheaders\">".$pgv_lang["upload_media"]."</font><br /><br />\n"; 
	if ((isset($action)) && ($action=="upload")) {
		$error="";
		$upload_errors = array($pgv_lang["file_success"], $pgv_lang["file_too_big"], $pgv_lang["file_too_big"],$pgv_lang["file_partial"], $pgv_lang["file_missing"]);
		AddToLog("Media file ".$MEDIA_DIRECTORY.basename($_FILES['mediafile']['name'])." uploaded by >".getUserName()."<");
		if (!move_uploaded_file($_FILES['mediafile']['tmp_name'], $MEDIA_DIRECTORY.basename($_FILES['mediafile']['name']))) {
			$error .= $pgv_lang["upload_error"]."<br />".$upload_errors[$_FILES['mediafile']['error']];
		}
		AddToLog("Media thumbnail ".$MEDIA_DIRECTORY."thumbs/".basename($_FILES['thumbnail']['name'])." uploaded by >".getUserName()."<");
		if (!move_uploaded_file($_FILES['thumbnail']['tmp_name'], $MEDIA_DIRECTORY."thumbs/".basename($_FILES['thumbnail']['name']))) {
			$error .= "<br />".$pgv_lang["upload_error"]."<br />".$upload_errors[$_FILES['thumbnail']['error']];
		}
		if (!empty($error)) print "<font class=\"error\">".$error."</font><br /><br />\n"; 
		else {
			print $pgv_lang["upload_successful"]."<br /><br />";
			$imgsize = getimagesize($MEDIA_DIRECTORY.$_FILES['mediafile']['name']);
			$imgwidth = $imgsize[0]+50;
			$imgheight = $imgsize[1]+50;
			print "<a href=\"#\" onclick=\"return openImage('".$MEDIA_DIRECTORY.$_FILES['mediafile']['name']."',$imgwidth, $imgheight);\">".$_FILES['mediafile']['name']."</a>";
			print"<br /><br />";
		}
	}
	print $pgv_lang["upload_help"].$MEDIA_DIRECTORY;
?>
<br />
<form enctype="multipart/form-data" method="post">
<input type="hidden" name="action" value="upload">
<?php print $pgv_lang["media_file"];?> <input name="mediafile" type="file"><br />
<?php print $pgv_lang["thumbnail"];?> <input name="thumbnail" type="file"><br />
<input type="submit" value="<?php print $pgv_lang["upload_media"];?>">
</form>
<br /><br /><br />
</center>
<?php
print_footer();
?>

