<?php
/*=================================================
	Project: phpGedView
	File: useradmin.php
	Author: John Finlay
	Comments:
		Administrative User Interface.

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: useradmin.php,v 1.49 2004/01/07 18:10:34 yalnifj Exp $

require "config.php";
require $PGV_BASE_DIRECTORY.$confighelpfile["english"];
if (file_exists($PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE])) require $PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE];

if (!isset($action)) $action="";

//-- make sure that they have admin status before they can use this page
//-- otherwise have them login again
if (!userIsAdmin(getUserName())) {
	header("Location: login.php?url=useradmin.php");
	exit;
}
print_header("PhpGedView User Administration");
?>
<script language="JavaScript">
<!--
	function checkform(frm) {
		if (frm.username.value=="") {
			alert("<?php print $pgv_lang["enter_username"]; ?>");
			frm.username.focus();
			return false;
		}
		if (frm.fullname.value=="") {
			alert("<?php print $pgv_lang["enter_fullname"]; ?>");
			frm.fullname.focus();
			return false;
		}
		return true;
	}
	var pasteto;
	function open_find(textbox, gedcom) {
		pasteto = textbox;
		findwin = window.open('findid.php?GEDCOM='+gedcom, '', 'left=50,top=50,width=450,height=450,resizable=1,scrollbars=1');
	}
	function paste_id(value) {
		pasteto.value=value;
	}
//-->
</script>
<?php
print "<div align=\"center\"><table><tr><td align=\"center\">";
//-- section to create a new user
if ($action=="createuser") {
	if (getUser($username)!==false) {
		print "<font class=error>".$pgv_lang["duplicate_username"]."</font><br />";
	}
	else if ($pass1==$pass2) {
		$user = array();
		$user["username"]=$username;
		$user["fullname"]=$fullname;

		/* added by Kurt - start */
		$user["email"]=$emailadress;
		if (!isset($verified)) $verified = "";
		$user["verified"] = $verified;
		if (!isset($verified_by_admin)) $verified_by_admin = "";
		$user["verified_by_admin"] = $verified_by_admin;
		$user["language"] = $language;
		$user["pwrequested"] = $pwrequested;
		$user["reg_timestamp"] = $reg_timestamp;
		$user["reg_hashcode"] = $reg_hashcode;
		/* added by Kurt - end */

		$user["gedcomid"]=array();
		$user["rootid"]=array();
		$user["canedit"]=array();
		foreach($GEDCOMS as $ged=>$gedarray) {
			$file = $ged;
			$ged = preg_replace(array("/\./","/-/"), array("_","_"), $ged);
			$varname = "gedcomid_$ged";
			if (isset($$varname)) $user["gedcomid"][$file]=$$varname;
			$varname = "rootid_$ged";
			if (isset($$varname)) $user["rootid"][$file]=$$varname;
			$varname = "canedit_$ged";
			if ((isset($$varname))&&($$varname=="yes")) $user["canedit"][$file]=true;
			else $user["canedit"][$file]=false;
		}
		$user["password"]=crypt($pass1);
		if ((isset($canadmin))&&($canadmin=="yes")) $user["canadmin"]=true;
		else $user["canadmin"]=false;
		if (!isset($new_user_theme)) $new_user_theme="";
		$user["theme"] = $new_user_theme;
		$user["loggedin"] = "N";
		$user["sessiontime"] = 0;
		$au = addUser($user);
		if ($au) {
			print $pgv_lang["user_created"]."<br />";
		}
		else {
			print "<font class=\"error\">".$pgv_lang["user_create_error"]."<br /></font>";
		}
	}
	else {
		print "<font class=\"error\">".$pgv_lang["password_mismatch"]."</font><br />";
	}
}
//-- section to delete a user
if ($action=="deleteuser") {
	deleteUser($username);
}
//-- section to update a user by first deleting them
//-- and then adding them again
if ($action=="edituser2") {
	if (($username!=$oldusername)&&(getUser($username)!==false)) {
		print "<font class=\"error\">".$pgv_lang["duplicate_username"]."</font><br />";
		$action="edituser";
	}
	else if ($pass1==$pass2) {
		$newuser = array();
		$olduser = getUser($oldusername);
		$newuser = $olduser;

		if (empty($pass1)) $newuser["password"]=$olduser["password"];
		else $newuser["password"]=crypt($pass1);
		deleteUser($oldusername);
		$newuser["username"]=$username;
		$newuser["fullname"]=$fullname;

		/* added by Kurt - start */
		$newuser["email"]=$emailadress;
		if (!isset($verified)) $verified = "";
		$newuser["verified"] = $verified;
		if (!isset($verified_by_admin)) $verified_by_admin = "";
		$newuser["verified_by_admin"] = $verified_by_admin;
		/* added by Kurt - end */

		if (!isset($user_theme)) $user_theme="";
		$newuser["theme"] = $user_theme;
		$newuser["gedcomid"]=array();
		$newuser["rootid"]=array();
		$newuser["canedit"]=array();
		foreach($GEDCOMS as $ged=>$gedarray) {
			$file = $ged;
			$ged = preg_replace(array("/\./","/-/"), array("_","_"), $ged);
			$varname = "gedcomid_$ged";
			if (isset($$varname)) $newuser["gedcomid"][$file]=$$varname;
			$varname = "rootid_$ged";
			if (isset($$varname)) $newuser["rootid"][$file]=$$varname;
			$varname = "canedit_$ged";
			if ((isset($$varname))&&($$varname=="yes")) $newuser["canedit"][$file]=true;
			else $newuser["canedit"][$file]=false;
		}
		if ($olduser["username"]!=getUserName()) {
			if ((isset($canadmin))&&($canadmin=="yes")) $newuser["canadmin"]=true;
			else $newuser["canadmin"]=false;
		}
		else $newuser["canadmin"]=$olduser["canadmin"];
		addUser($newuser);
		if ($olduser["verified_by_admin"]!=$newuser["verified_by_admin"]) {
			$message = array();
			$message["to"] = $newuser["username"];
			$message["from"] = $WEBMASTER_EMAIL;
			//$message["subject"] = $pgv_lang["admin_approved"];
			$message["subject"] = str_replace("#SERVER_NAME#", $SERVER_URL, $pgv_lang["admin_approved"]);
			$path = substr($PHP_SELF, 0, strrpos($PHP_SELF, "/"));
			//$message["body"] = $pgv_lang["admin_approved"].$pgv_lang["you_may_login"]."\r\n\r\n$SERVER_URL.$path."/login.php\r\n";
			$message["body"] = str_replace("#SERVER_NAME#", $SERVER_URL, $pgv_lang["admin_approved"]).$pgv_lang["you_may_login"]."\r\n\r\n".$SERVER_URL.$path."/login.php\r\n";
			$message["created"] = "";
			$message["method"] = "messaging2";
			addMessage($message);
		}
	}
	else {
		print "<font class=\"error\">".$pgv_lang["password_mismatch"]."</font><br />";
		$action="edituser";
	}
}
//-- print the form to edit a user
if ($action=="edituser") {
	$user = getUser($username);
?>
<form name="editform" method="post" onsubmit="return checkform(this);">
<input type="hidden" name="action" value="edituser2" />
<input type="hidden" name="oldusername" value="<?php print $username; ?>" />
<table>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["username"]?></td><td class="facts_value"><input type="text" name="username" value="<?php print $user['username']?>" /></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["fullname"]?></td><td class="facts_value"><input type="text" name="fullname" value="<?php print $user['fullname']?>" size="50" /></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["gedcomid"]?></td><td class="facts_value">
	<?php
	print "<table>";
	foreach($GEDCOMS as $ged=>$gedarray) {
		$file = $ged;
		$ged = preg_replace(array("/\./","/-/"), array("_","_"), $ged);
		print "<tr><td align=\"right\">$file :</td><td> <input type=\"text\" name=\"gedcomid_$ged\" value=\"";
		if (isset($user['gedcomid'][$file])) print $user['gedcomid'][$file];
		print "\" /><font size=\"1\"><a href=\"javascript:open_find(document.editform.gedcomid_$ged, '$file');\">".$pgv_lang["find_id"]."</a></font><br />\n";
		print "</td></tr>";
	}
	print "</table>";
	?>
	</td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["rootid"]?></td><td class="facts_value">
	<?php
	print "<table>";
	foreach($GEDCOMS as $ged=>$gedarray) {
		$file = $ged;
		$ged = preg_replace(array("/\./","/-/"), array("_","_"), $ged);
		print "<tr><td align=\"right\">$file : </td><td><input type=\"text\" name=\"rootid_$ged\" value=\"";
		if (isset($user['rootid'][$file])) print $user['rootid'][$file];
		print "\" /><font size=\"1\"><a href=\"javascript:open_find(document.editform.rootid_$ged, '$file');\">".$pgv_lang["find_id"]."</a></font><br />\n";
		print "</td></tr>\n";
	}
	print "</table>";
	?>
	</td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["password"]?></td><td class="facts_value"><input type="password" name="pass1"></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["confirm"]?></td><td class="facts_value"><input type="password" name="pass2"></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["can_admin"]?></td><td class="facts_value"><input type="checkbox" name="canadmin" value="yes" <?php if ($user['canadmin']) print "checked"; if ($user["username"]==getUserName()) print " disabled"; ?>></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["can_edit"]?></td><td class="facts_value">
	<?php
	foreach($GEDCOMS as $ged=>$gedarray) {
		$file = $ged;
		$ged = preg_replace(array("/\./","/-/"), array("_","_"), $ged);
		print "<input type=\"checkbox\" name=\"canedit_$ged\" value=\"yes\"";
		if ((isset($user['canedit'][$file]))&&($user['canedit'][$file])) print " checked";
		print "> $file<br />\n";
	}
	?>
	</td></tr>

	<?php /* added by Kurt - start */ ?>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["emailadress"]?></td><td class="facts_value"><input type="text" name="emailadress" value="<?php print $user['email']?>" size="50"></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["verified"]?></td><td class="facts_value"><input type="checkbox" name="verified" value="yes" <?php if ($user['verified']) print "checked";?>></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["verified_by_admin"]?></td><td class="facts_value"><input type="checkbox" name="verified_by_admin" value="yes" <?php if ($user['verified_by_admin']) print "checked"; ?>></td></tr>
	<?php /* added by Kurt - end */ ?>
	<?php if ($ALLOW_USER_THEMES) { ?>
    <tr><td class="facts_label" valign="top" align=left><?php print $pgv_lang["user_theme"];?></td><td class="facts_value" valign="top">
    	<select name="user_theme">
    	<option value=""><?php print $pgv_lang["site_default"]; ?></option>
				<?php
					$themes = get_theme_names();
					foreach($themes as $themedir) {
						print "<option value=\"".$themedir["dir"]."\"";
						if ($themedir["dir"] == $user["theme"]) print " selected=\"selected\"";
						print ">".$themedir["name"]."</option>\n";
					}
				?>
			</select>
	</td></tr>
	<?php } ?>

</table>
<input type="submit" value="<?php print $pgv_lang["update_user"]; ?>">
</form>
<?php
	print $pgv_lang["leave_blank"];
	print_footer();
	exit;
}
//-- end of $action=='edituser'

//-- print out a list of the current users
?>
<font class="subheaders"><?php print $pgv_lang["current_users"]; ?></font><br />
<table class="list_table">
<tr>
	<td class="list_label"><?php print $pgv_lang["delete"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["edit"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["username"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["full_name"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["can_admin"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["can_edit"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["verified"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["verified_by_admin"]; ?></td>
</tr>
<?php
$users = getUsers();
foreach($users as $username=>$user) {
	print "<tr>\n";
	print "\t<td class=\"list_value\"><a href=\"useradmin.php?action=deleteuser&username=$username\" onclick=\"return confirm('".$pgv_lang["confirm_user_delete"]." $username?');\">".$pgv_lang["delete"]."</a></td>\n";
	print "\t<td class=\"list_value\"><a href=\"useradmin.php?action=edituser&username=$username\">".$pgv_lang["edit"]."</a></td>\n";
	print "\t<td class=\"list_value\">$username</td>\n";
	print "\t<td class=\"list_value\">".$user["fullname"]."</td>\n";
	print "\t<td class=\"list_value\">";
	if ($user["canadmin"]) print $pgv_lang["yes"];
	else print $pgv_lang["no"];
	print "</td>\n";
	print "\t<td class=\"list_value\">";
	$count = 0;
	foreach($user["canedit"] as $gedfile=>$value) {
		if ($value) {
			print $gedfile."<br />";
			$count++;
		}
	}
	if ($count==0) print "<br />";
	print "\t<td class=\"list_value\">";
	if ($user["verified"]=="yes") print $pgv_lang["yes"];
	else print $pgv_lang["no"];
	print "</td>\n";
	print "\t<td class=\"list_value\">";
	if ($user["verified_by_admin"]=="yes") print $pgv_lang["yes"];
	else print $pgv_lang["no"];
	print "</td>\n";
	print "</td>\n";
	print "</tr>\n";
}

//-- print out the form to add a new user
?>
</table>
<script language="JavaScript">
	function checkform(frm) {
		if (frm.username.value=="") {
			alert("<?php print $pgv_lang["enter_username"]; ?>");
			frm.username.focus();
			return false;
		}
		if (frm.fullname.value=="") {
			alert("<?php print $pgv_lang["enter_fullname"]; ?>");
			frm.fullname.focus();
			return false;
		}
		if (frm.pass1.value=="") {
			alert("<?php print $pgv_lang["enter_password"]; ?>");
			frm.pass1.focus();
			return false;
		}
		if (frm.pass2.value=="") {
			alert("<?php print $pgv_lang["confirm_password"]; ?>");
			frm.pass2.focus();
			return false;
		}
		return true;
	}
</script>
<br /><br />
<form name="newform" method="post" onsubmit="return checkform(this);">
<font class="subheaders"><?php print $pgv_lang["add_user"]?></font><br />
<input type="hidden" name="action" value="createuser">
<table>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["username"]?></td><td class="facts_value"><input type="text" name="username" tabindex="1" /></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["fullname"]?></td><td class="facts_value"><input type="text" name="fullname" tabindex="2" size="50" /></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["gedcomid"]?></td><td class="facts_value">
	<?php
	print "<table>";
	foreach($GEDCOMS as $ged=>$gedarray) {
		$file = $ged;
		$ged = preg_replace(array("/\./","/-/"), array("_","_"), $ged);
		print "<tr><td align=\"right\">$file : </td><td><input type=\"text\" name=\"gedcomid_$ged\" value=\"";
		print "\" tabindex=\"3\"><font size=\"1\"><a href=\"javascript:open_find(document.newform.gedcomid_$ged, '$file');\">".$pgv_lang["find_id"]."</a></font><br />\n";
		print "</td></tr>\n";
	}
	print "</table>";
	?>
	</td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["rootid"]?></td><td class="facts_value">
	<?php
	print "<table>";
	foreach($GEDCOMS as $ged=>$gedarray) {
		$file = $ged;
		$ged = preg_replace(array("/\./","/-/"), array("_","_"), $ged);
		print "<tr><td align=\"right\">$file : </td><td><input type=\"text\" name=\"rootid_$ged\" value=\"";
		print "\" tabindex=\"4\"><font size=\"1\"><a href=\"javascript:open_find(document.newform.rootid_$ged, '$file');\">".$pgv_lang["find_id"]."</a></font><br />\n";
		print "</td></tr>\n";
	}
	print "</table>";
	?>
	</td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["password"]?></td><td class="facts_value"><input type="password" name="pass1" tabindex="5"></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["confirm"]?></td><td class="facts_value"><input type="password" name="pass2" tabindex="6"></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["can_admin"]?></td><td class="facts_value"><input type="checkbox" name="canadmin" value="yes" tabindex="7"></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["can_edit"]?></td><td class="facts_value">
	<?php
	foreach($GEDCOMS as $ged=>$gedarray) {
		$file = $ged;
		$ged = preg_replace(array("/\./","/-/"), array("_","_"), $ged);
		print "<input type=\"checkbox\" name=\"canedit_$ged\" value=\"yes\"";
		print "tabindex=\"8\"> $file<br />\n";
	}
	?>
	</td></tr>

	<?php /* added by Kurt - start */ ?>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["emailadress"]?></td><td class="facts_value"><input type="text" name="emailadress" value="" size="50" tabindex="9"></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["verified"]?></td><td class="facts_value"><input type="checkbox" name="verified" value="yes" tabindex="10"></td></tr>
	<tr><td class="facts_label" valign="top" align="right"><?php print $pgv_lang["verified_by_admin"]?></td><td class="facts_value"><input type="checkbox" name="verified_by_admin" value="yes" tabindex="11"></td></tr>
	<?php /* added by Kurt - end */ ?>

	<?php if ($ALLOW_USER_THEMES) { ?>
    <tr><td class="facts_label" valign="top" align=left><?php print $pgv_lang["user_theme"];?></td><td class="facts_value" valign="top">
    	<select name="new_user_theme" tabindex="12">
    	<option value="" selected="selected"><?php print $pgv_lang["site_default"]; ?></option>
				<?php
					$themes = get_theme_names();
					foreach($themes as $themedir) {
						print "<option value=\"".$themedir["dir"]."\"";
						print ">".$themedir["name"]."</option>\n";
					}
				?>
			</select>
	</td></tr>
	<?php } ?>
</table>

<?php /* added by Kurt - start */ ?>
<input type="hidden" name="language" value="<?php print $LANGUAGE;?>" />
<input type="hidden" name="pwrequested" value="" />
<input type="hidden" name="reg_timestamp" value="<?php print date("U");?>" />
<input type="hidden" name="reg_hashcode" value="" />
<?php /* added by Kurt - end */ ?>

<input type="submit" value="<?php print $pgv_lang["create_user"]; ?>" tabindex="13" />
</form>
</td></tr></table></div>
<?php
print_footer();
?>
