/*
	Copyright (C) 2002 Kunimasa Noda/PM9.com, Inc.
                                      (http://www.pm9.com,  kuni@pm9.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "php.h"
#include "php_ini.h"
#include "php_globals.h"

#include "zend.h"
#include "zend_API.h"
#include "zend_execute.h"
#include "zend_compile.h"
#include "zend_extensions.h"
#include "zend_hash.h"

#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <string.h>
#include <unistd.h>

extern zend_module_entry dyn_module_entry;
#define dyn_module_ptr &dyn_module_entry

#undef TRACE_ZEND_COMPILE

#include "ext/standard/info.h"

int _dyn_profiler_mode;
char _dyn_log_dir[256];
FILE *_dyn_log_file_fp;

#define	MAX_LEVEL_STACK 500
int _dyn_fcall_level;
char _dyn_pre_file_name[MAX_LEVEL_STACK][256];
int _dyn_pre_line_no[MAX_LEVEL_STACK];
int _dyn_after_fcall[MAX_LEVEL_STACK];

int _dyn_after_return;
int _dyn_after_return_p;
int _dyn_statement_pre_lineno;

int _dyn_rinit;
struct timeval _dyn_tv;

FILE *dyn_fopen0() {
	char tmp[256];

	sprintf(tmp, "%s/php_dyn.log.%d", _dyn_log_dir, getpid());
	return fopen(tmp, "a");
}

FILE *dyn_fopen() {
	if (_dyn_profiler_mode == 1) return _dyn_log_file_fp;

	return dyn_fopen0();
}

void dyn_fclose(FILE *fp) {
fflush(_dyn_log_file_fp);
	if (_dyn_profiler_mode == 1) return;

	fclose(fp);
}

void dyn_fclose0(FILE *fp) {
	if (_dyn_profiler_mode == 0) return;

	fclose(fp);
}

void dyn_tv_print() {
	struct timeval tv;
	int usec;

	gettimeofday(&tv, NULL);
	usec = (tv.tv_sec - _dyn_tv.tv_sec) * 1000000 + (tv.tv_usec - _dyn_tv.tv_usec);
	fprintf(_dyn_log_file_fp, "time:%3.3d.%6.6d", usec / 1000000, usec % 1000000);
}

void dyn_print_indent(level) {
	int i;

	fprintf(_dyn_log_file_fp, " ");
	for(i=0; i<level; i++) {
		fprintf(_dyn_log_file_fp, "   ");
	}
}

void dyn_my_var_dump(pval **struc, int level);
#define COMMON ((*struc)->is_ref?"&":"")

static int dyn_array_element_dump(zval **zv, int num_args, va_list args, zend_hash_key *hash_key)
{
	int level;

	level = va_arg(args, int);

	if (hash_key->nKeyLength==0) {
		fprintf(_dyn_log_file_fp, "$%*c[%ld]=>\n", level + 1, ' ', hash_key->h);
	} else {
		fprintf(_dyn_log_file_fp, "$%*c[\"%s\"]=>\n", level + 1, ' ', hash_key->arKey);
	}
	dyn_my_var_dump(zv, level + 2);
	return 0;
}

void dyn_my_var_dump(pval **struc, int level)
{
	HashTable *myht;

	fprintf(_dyn_log_file_fp, "$%*c", level-1, ' ');

	switch ((*struc)->type) {
		case IS_BOOL:
			fprintf(_dyn_log_file_fp, "%sbool:%s\n", COMMON, ((*struc)->value.lval?"true":"false"));
			break;
		case IS_NULL:
			fprintf(_dyn_log_file_fp, "%sNULL\n", COMMON);
			break;
		case IS_LONG:
			fprintf(_dyn_log_file_fp, "%sint:%ld\n", COMMON, (*struc)->value.lval);
			break;
		case IS_DOUBLE: {
				ELS_FETCH();

				fprintf(_dyn_log_file_fp, "%sfloat:%.*G\n", COMMON, (int) EG(precision), (*struc)->value.dval);
			}
			break;
		case IS_STRING:
			fprintf(_dyn_log_file_fp, "%sstring(length=%d): \"", COMMON, (*struc)->value.str.len);
			fwrite((*struc)->value.str.val, (*struc)->value.str.len, 1, _dyn_log_file_fp);
			fprintf(_dyn_log_file_fp, "\"\n");
			break;
		case IS_ARRAY:
			myht = HASH_OF(*struc);
			fprintf(_dyn_log_file_fp, "%sarray(size=%d) {\n", COMMON, zend_hash_num_elements(myht));
			goto head_done;
		case IS_OBJECT:
			myht = HASH_OF(*struc);
			fprintf(_dyn_log_file_fp, "%sobject(name='%s')(elements=%d) {\n", COMMON, (*struc)->value.obj.ce->name, zend_hash_num_elements(myht));
head_done:
			zend_hash_apply_with_arguments(myht, (apply_func_args_t) dyn_array_element_dump, 1, level);
			if (level>1) {
				fprintf(_dyn_log_file_fp, "$%*c", level-1, ' ');
			}
			fprintf(_dyn_log_file_fp, "}\n");
			break;
		case IS_RESOURCE: {
			char *type_name;
			type_name = zend_rsrc_list_get_rsrc_type((*struc)->value.lval);
			fprintf(_dyn_log_file_fp, "%sresource(%ld) of type (%s)\n", COMMON, (*struc)->value.lval, type_name ? type_name : "Unknown");
			break;
		}
		default:
			fprintf(_dyn_log_file_fp, "%sUNKNOWN:0\n",COMMON);
			break;
	}
}

void dyn_my_print(pval **struc, int level, FILE *out)
{
	switch ((*struc)->type) {
		case IS_STRING:
			fwrite((*struc)->value.str.val, (*struc)->value.str.len, 1, out);
			break;
		case IS_NULL:
			fprintf(out, "(null)\n");
			break;
		case IS_LONG:
			fprintf(out, "%ld\n", (*struc)->value.lval); break;
			break;
		case IS_DOUBLE:
			fprintf(out, "%g\n", (*struc)->value.dval); break;
			break;
		case IS_BOOL:
			fprintf(out, "%d\n", (*struc)->value.lval); break;
			break;
		case IS_CONSTANT:
			fprintf(out, "%s\n", (*struc)->value.str.val); break;
			break;
	}
}

void _dyn_rinit_print() {
	char tmp[256];
	struct stat stat_buf;

	if (_dyn_rinit == 0) return;
	_dyn_rinit = 0;
	_dyn_statement_pre_lineno = 0;
	_dyn_log_file_fp = dyn_fopen0();
	if (_dyn_log_file_fp == NULL) return;

	fstat(fileno(_dyn_log_file_fp), &stat_buf);
	if (stat_buf.st_size == 0) {
		fprintf(_dyn_log_file_fp, "# ");
		fprintf(_dyn_log_file_fp, "PHP Dynamic Script Tracer version 1.0");
		fprintf(_dyn_log_file_fp, "\n");
		fprintf(_dyn_log_file_fp, "# ");
		fprintf(_dyn_log_file_fp, "Copyright (c) 2002 Kunimasa Noda/PM9.com, Inc.");
		fprintf(_dyn_log_file_fp, "\n");
		fprintf(_dyn_log_file_fp, "# ");
		fprintf(_dyn_log_file_fp, "  contact: http://www.pm9.com, kuni@pm9.com");
		fprintf(_dyn_log_file_fp, "\n");
	}

	gettimeofday(&_dyn_tv, NULL);

	fprintf(_dyn_log_file_fp, "#------------------------------------------------------------------------------\n");
	fprintf(_dyn_log_file_fp, "@ ");
	fprintf(_dyn_log_file_fp, "time:%3.3d.%6.6d", 0, 0);
	fprintf(_dyn_log_file_fp, " (");
	sprintf(tmp, "__dyn_print($DOCUMENT_ROOT.$PHP_SELF);");
	zend_eval_string(tmp, NULL, "foo" CLS_CC ELS_CC);
	fprintf(_dyn_log_file_fp, ") -- %s", ctime(&_dyn_tv.tv_sec));

	if (_dyn_profiler_mode == 0) {
		fprintf(_dyn_log_file_fp, "$ $HTTP_POST_VARS=>\n");
		sprintf(tmp, "__dyn_var_dump($HTTP_POST_VARS);");
		zend_eval_string(tmp, NULL, "foo" CLS_CC ELS_CC);

		fprintf(_dyn_log_file_fp, "$ $HTTP_POST_FILES=>\n");
		sprintf(tmp, "__dyn_var_dump($HTTP_POST_FILES);");
		zend_eval_string(tmp, NULL, "foo" CLS_CC ELS_CC);

		fprintf(_dyn_log_file_fp, "$ $HTTP_GET_VARS=>\n");
		sprintf(tmp, "__dyn_var_dump($HTTP_GET_VARS);");
		zend_eval_string(tmp, NULL, "foo" CLS_CC ELS_CC);

		fprintf(_dyn_log_file_fp, "$ $HTTP_COOKIE_VARS=>\n");
		sprintf(tmp, "__dyn_var_dump($HTTP_COOKIE_VARS);");
		zend_eval_string(tmp, NULL, "foo" CLS_CC ELS_CC);
	}

	dyn_fclose(_dyn_log_file_fp);
}

PHP_FUNCTION(__dyn_var_dump);
PHP_FUNCTION(dyn_var_dump);
PHP_FUNCTION(__dyn_print);
PHP_FUNCTION(dyn_print);

function_entry dyn_functions[] = {
	PHP_FE(__dyn_var_dump, NULL)
	PHP_FE(dyn_var_dump, NULL)
	PHP_FE(__dyn_print, NULL)
	PHP_FE(dyn_print, NULL)
	{NULL, NULL, NULL}
};

PHP_FUNCTION(__dyn_var_dump)
{
	zval ***args;
	int argc;
	int	i;
	
	argc = ZEND_NUM_ARGS();
	
	args = (zval ***)emalloc(argc * sizeof(zval **));
	if (ZEND_NUM_ARGS() == 0 || zend_get_parameters_array_ex(argc, args) == FAILURE) {
		efree(args);
		WRONG_PARAM_COUNT;
	}
	
	for (i=0; i<argc; i++)
		dyn_my_var_dump(args[i], 6);
	
	efree(args);
}

PHP_FUNCTION(dyn_var_dump)
{
	zval ***args;
	int argc;
	int	i;
	
	argc = ZEND_NUM_ARGS();
	
	args = (zval ***)emalloc(argc * sizeof(zval **));
	if (ZEND_NUM_ARGS() == 0 || zend_get_parameters_array_ex(argc, args) == FAILURE) {
		efree(args);
		WRONG_PARAM_COUNT;
	}
	
	_dyn_log_file_fp = dyn_fopen();
	if (_dyn_log_file_fp == NULL) return;

	for (i=0; i<argc; i++)
		dyn_my_var_dump(args[i], 3);
	
	dyn_fclose(_dyn_log_file_fp);
	efree(args);
}

PHP_FUNCTION(__dyn_print)
{
	zval ***args;
	int argc;
	int	i;
	
	argc = ZEND_NUM_ARGS();
	
	args = (zval ***)emalloc(argc * sizeof(zval **));
	if (ZEND_NUM_ARGS() == 0 || zend_get_parameters_array_ex(argc, args) == FAILURE) {
		efree(args);
		WRONG_PARAM_COUNT;
	}
	
	for (i=0; i<argc; i++)
		dyn_my_print(args[i], 1, _dyn_log_file_fp);
	
	efree(args);
}

PHP_FUNCTION(dyn_print)
{
	zval ***args;
	int argc;
	int	i;
	
	argc = ZEND_NUM_ARGS();
	
	args = (zval ***)emalloc(argc * sizeof(zval **));
	if (ZEND_NUM_ARGS() == 0 || zend_get_parameters_array_ex(argc, args) == FAILURE) {
		efree(args);
		WRONG_PARAM_COUNT;
	}
	
	_dyn_log_file_fp = dyn_fopen();
	if (_dyn_log_file_fp == NULL) return;

	for (i=0; i<argc; i++)
		dyn_my_print(args[i], 1, _dyn_log_file_fp);
	
	dyn_fclose(_dyn_log_file_fp);
	efree(args);
}

PHP_MINIT_FUNCTION(dyn);
PHP_RINIT_FUNCTION(dyn);
PHP_RSHUTDOWN_FUNCTION(dyn);
PHP_MINFO_FUNCTION(dyn);

zend_module_entry dyn_module_entry = {
#if ZEND_MODULE_API_NO >= 20010901
    STANDARD_MODULE_HEADER,
#endif
	"dyn",
	dyn_functions,
	PHP_MINIT(dyn),
	NULL,
	PHP_RINIT(dyn),
	PHP_RSHUTDOWN(dyn),
	PHP_MINFO(dyn),
	NULL,
	NULL,
#if ZEND_MODULE_API_NO >= 20010901
    NO_VERSION_YET,
#endif
	STANDARD_MODULE_PROPERTIES_EX
};

#if COMPILE_DL_dyn
ZEND_GET_MODULE(dyn)
#endif

static PHP_INI_MH(set_logdir)
{
    struct stat stat_buf;
    if (stat(new_value, &stat_buf)) {
    } else {
        strcpy(_dyn_log_dir, new_value);
    }
    return SUCCESS;
}

static PHP_INI_MH(set_profiler_mode)
{
    if (strcmp(new_value, "1") == 0) {
	_dyn_profiler_mode = 1;
    }
    return SUCCESS;
}

PHP_INI_BEGIN()
    PHP_INI_ENTRY("dyn.log_dir",    "/tmp",   PHP_INI_ALL, set_logdir)
    PHP_INI_ENTRY("dyn.profiler_mode",    "Off",   PHP_INI_ALL, set_profiler_mode)
PHP_INI_END()

PHP_MINIT_FUNCTION(dyn)
{
        strcpy(_dyn_log_dir, "/tmp");
	_dyn_profiler_mode = 0;

	REGISTER_INI_ENTRIES();

	return SUCCESS;
}

PHP_RINIT_FUNCTION(dyn)
{
	_dyn_rinit = 1;

	_dyn_fcall_level = 0;

	memset(_dyn_pre_file_name, 0, sizeof _dyn_pre_file_name);
	memset(_dyn_pre_line_no, 0, sizeof _dyn_pre_line_no);
	_dyn_after_fcall[_dyn_fcall_level] = 2;

	return SUCCESS;
}

PHP_RSHUTDOWN_FUNCTION(dyn)
{
	dyn_fclose0(_dyn_log_file_fp);

	return SUCCESS;
}

PHP_MINFO_FUNCTION(dyn)
{
	php_info_print_table_start();
	php_info_print_table_header(2, "Dynamic Script Tracer", "Enabled");
	php_info_print_table_row(2, "Version", "1.2.1");
	php_info_print_table_end();
}

ZEND_DLEXPORT void dyn_fcall_begin(zend_op_array *op_array)
{
	zend_op* current;

	_dyn_fcall_level++;

	_dyn_rinit_print();
	_dyn_log_file_fp = dyn_fopen();
	if (_dyn_log_file_fp == NULL) return;

	_dyn_statement_pre_lineno = 0;

	current = *EG(opline_ptr);
	_dyn_after_fcall[_dyn_fcall_level] = 1;
	_dyn_pre_line_no[_dyn_fcall_level - 1] = current->lineno;
	strcpy(_dyn_pre_file_name[_dyn_fcall_level - 1], op_array->filename);

	dyn_fclose(_dyn_log_file_fp);
}

void dyn_get_return_lineno(zend_op_array *op_array) {
	int i, cur;

	cur = *EG(opline_ptr) - op_array->opcodes;

	for (i = cur; i < op_array->last; i++) {
		if (op_array->opcodes[i].opcode == ZEND_RETURN) {
			_dyn_pre_line_no[_dyn_fcall_level] = op_array->opcodes[i].lineno;
			strcpy(_dyn_pre_file_name[_dyn_fcall_level], op_array->filename);
			break;
		}
	}
}

ZEND_DLEXPORT void dyn_fcall_end(zend_op_array *op_array)
{
	zend_op* current;

	_dyn_fcall_level--;

	_dyn_rinit_print();
	_dyn_log_file_fp = dyn_fopen();
	if (_dyn_log_file_fp == NULL) return;

	_dyn_statement_pre_lineno = 0;

	_dyn_after_return = 1;
	_dyn_after_return_p = *EG(opline_ptr) - op_array->opcodes;

	current = *EG(opline_ptr);

	if (_dyn_after_fcall[_dyn_fcall_level + 1] == 2){
		fprintf(_dyn_log_file_fp, "< ");
		dyn_tv_print();
		dyn_print_indent(_dyn_fcall_level + 1);
		fprintf(_dyn_log_file_fp, "RETURN (%s line:%d) <- (%s line:%d)\n",
			op_array->filename, current->lineno,
			_dyn_pre_file_name[_dyn_fcall_level + 1], _dyn_pre_line_no[_dyn_fcall_level + 1]);

	}
	dyn_get_return_lineno(op_array);
	dyn_fclose(_dyn_log_file_fp);
}

ZEND_DLEXPORT void dyn_statement(zend_op_array *op_array)
{
	int i, cur;
	zend_op* current;

	_dyn_rinit_print();

	if (!op_array) {
		return;
	}
	_dyn_log_file_fp = dyn_fopen();
	if (_dyn_log_file_fp == NULL) return;

	current = *EG(opline_ptr);
	cur = *EG(opline_ptr) - op_array->opcodes;

	if (_dyn_profiler_mode == 0) {
		if (_dyn_after_return == 1
		&& op_array->last > _dyn_after_return_p + 2
		&& _dyn_after_fcall[_dyn_fcall_level] == 2
		&& op_array->opcodes[_dyn_after_return_p + 1].opcode == ZEND_FETCH_W
		&& op_array->opcodes[_dyn_after_return_p + 1].op1.op_type == IS_CONST
		&& op_array->opcodes[_dyn_after_return_p + 2].opcode == ZEND_ASSIGN) {
			char tmp[256];

			fprintf(_dyn_log_file_fp, "$ return=>\n");
			sprintf(tmp, "__dyn_var_dump($%s);",
				op_array->opcodes[_dyn_after_return_p + 1].op1.u.constant.value.str.val);
			zend_eval_string(tmp, NULL, "foo" CLS_CC ELS_CC);
		}
	}

	if (_dyn_after_fcall[_dyn_fcall_level] == 2) {
		if (_dyn_statement_pre_lineno > op_array->opcodes[cur].lineno) {
			fprintf(_dyn_log_file_fp, "- ");
		} else {
			fprintf(_dyn_log_file_fp, "| ");
		}
		dyn_tv_print();
		dyn_print_indent(_dyn_fcall_level);
		fprintf(_dyn_log_file_fp, "(line:%d)\n",
			op_array->opcodes[cur].lineno);
	}

	_dyn_statement_pre_lineno = op_array->opcodes[cur].lineno;

	if (_dyn_after_fcall[_dyn_fcall_level] == 1) {
		_dyn_after_fcall[_dyn_fcall_level] = 2;

		fprintf(_dyn_log_file_fp, "> ");
		dyn_tv_print();
		dyn_print_indent(_dyn_fcall_level);
		if (CG(class_entry).name) {
			fprintf(_dyn_log_file_fp, "CALL %s::%s ",
				CG(class_entry).name,
				op_array->function_name);
		} else {
			fprintf(_dyn_log_file_fp, "CALL %s ",
				op_array->function_name);
		}
		fprintf(_dyn_log_file_fp, "(%s line:%d) -> (%s line:%d)\n",
			_dyn_pre_file_name[_dyn_fcall_level - 1], _dyn_pre_line_no[_dyn_fcall_level - 1],
			op_array->filename, op_array->opcodes[0].lineno);
		if (_dyn_profiler_mode == 0) {
			for (i = 0; i < cur; i++) {
				if (op_array->opcodes[i].opcode == ZEND_FETCH_W) {
					char tmp[256];
					fprintf(_dyn_log_file_fp, "$ arg: $%s=>\n", op_array->opcodes[i].op1.u.constant.value.str.val);
					sprintf(tmp, "__dyn_var_dump($%s);", op_array->opcodes[i].op1.u.constant.value.str.val);
					zend_eval_string(tmp, NULL, "foo" CLS_CC ELS_CC);
				}
			}
		}

	}

	dyn_get_return_lineno(op_array);

	dyn_fclose(_dyn_log_file_fp);
}

int dyn_zend_startup(zend_extension *extension)
{
	CG(extended_info) = 1;
	return zend_startup_module(&dyn_module_entry);
}

#ifndef ZEND_EXT_API
#define ZEND_EXT_API	ZEND_DLEXPORT
#endif
ZEND_EXTENSION();

ZEND_DLEXPORT zend_extension zend_extension_entry = {
	"PHP Dynamic Script Tracer",
	"1.2.1",
	"kuni@pm9.com",
	"http://www.pm9.com/",
	"Copyright (c) 2001-2003 Kunimasa Noda/PM9.com, Inc.",
	dyn_zend_startup,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	dyn_statement,
	dyn_fcall_begin,
	dyn_fcall_end,
	NULL,
	NULL,
#ifdef COMPAT_ZEND_EXTENSION_PROPERTIES
	NULL,
	COMPAT_ZEND_EXTENSION_PROPERTIES
#else
	STANDARD_ZEND_EXTENSION_PROPERTIES
#endif
};

