<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: manageservers.inc,v 1.6 2004/02/27 12:07:26 mad-x Exp $
    // Created by Kris Splittgerber (kris@phpua.com)
    
    startBenchmark(__FILE__, __FUNCTION__);
    
    // !!! SECURITY !!!
    if (!$_SESSION["authenticated"]) displayErrorMessage($phpUA["LANGUAGE"]["ERROR_ACCESSDENIED"]);
    
    if (!empty($_REQUEST["action"])) {
        switch ($_REQUEST["action"]) {
            case $phpUA["LANGUAGE"]["Add"]:
                if (empty($_REQUEST["new_ip"]))   displayErrorMessage($phpUA["LANGUAGE"]["ERROR_BADIP"]);
                if (empty($_REQUEST["new_port"])) displayErrorMessage($phpUA["LANGUAGE"]["ERROR_BADPORT"]);
                if (empty($_REQUEST["new_game"])) displayErrorMessage($phpUA["LANGUAGE"]["ERROR_BADGAME"]);
                configAddServer($_REQUEST["new_ip"], $_REQUEST["new_port"], $_REQUEST["new_game"]);
                break;
            case $phpUA["LANGUAGE"]["Modify"]:
                if ($_REQUEST["server_id"] == "")    displayErrorMessage($phpUA["LANGUAGE"]["ERROR_SERVERID"]);
                if (empty($_REQUEST["server_ip"]))   displayErrorMessage($phpUA["LANGUAGE"]["ERROR_BADIP"]);
                if (empty($_REQUEST["server_port"])) displayErrorMessage($phpUA["LANGUAGE"]["ERROR_BADPORT"]);
                if (empty($_REQUEST["server_game"])) displayErrorMessage($phpUA["LANGUAGE"]["ERROR_BADGAME"]);
                configRemoveServer($_REQUEST["server_id"]);
                configAddServer($_REQUEST["server_ip"], $_REQUEST["server_port"], $_REQUEST["server_game"]);
                break;
            case $phpUA["LANGUAGE"]["Remove"]:
                if ($_REQUEST["server_id"] == "") displayErrorMessage($phpUA["LANGUAGE"]["ERROR_SERVERID"]);
                configRemoveServer($_REQUEST["server_id"]);
                break;
        }
    }
    reloadConfig();
    $server_array = array();
    $games_array = array();
    // Create an array of existing servers
    $i = -1;
    $x = -1;
    foreach ($phpUA["CONFIG"]["SERVER"] as $value) {
        $i++;
        // Decode server line (GAME:IP:PORT)
        $temp = explode(":", $value);
        $server_game = $temp[0];
        $server_ip   = $temp[1];
        $server_port = $temp[2];
        if (isset($phpUA["PLUGINS"][$server_game]["NAME"])) {
            $x++;
            $server_array[$x] = array("id"  =>$i,
                                      "ip"  =>$server_ip,
                                      "port"=>$server_port,
                                      "game"=>$server_game);
        }
    }
    // Create an array of games
    $no_plugins = true;
    $i = -1;
    foreach ($phpUA["PLUGINS"] as $key => $value) {
        if (!empty($phpUA["PLUGINS"][$key]["NAME"])) {
            $no_plugins = false;
            $i++;
            $games_array[$i] = array("id"  =>$key,
                                     "name"=>$phpUA["PLUGINS"][$key]["NAME"]);
        }
    }
    // Output template
    if (empty($phpUA["CONFIG"]["SERVER"])) $phpUA["TEMPLATE"]->assign("NO_SERVERS", true);
    else $phpUA["TEMPLATE"]->assign("NO_SERVERS", false);
    $phpUA["TEMPLATE"]->assign("NO_PLUGINS", $no_plugins);
    $phpUA["TEMPLATE"]->assign("SERVERS", $server_array);
    $phpUA["TEMPLATE"]->assign("GAMES", $games_array);
    $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/admin/manageservers.tpl");
    
    endBenchmark(__FILE__, __FUNCTION__);
?>