<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: install.php,v 1.10 2004/03/10 10:45:44 mad-x Exp $
    // Created by Kris Splittgerber (kris@phpua.com)
    
    // ------------------------------
    // PHP VERSION CHECK
    // ------------------------------
    // This check will work from PHP 3.0.7 onwards, and will check that the version is at least 4.1.0,
    // which is when the function version_compare() was implemented. We will check for a higher PHP
    // version later on (if needed).
    if (!function_exists("version_compare")) {
        die("phpUA requires PHP version 4.1.0 or greater. You are running version "  . phpversion() . ".");
    }
    
    // ------------------------------
    // DEFINE CONSTANTS
    // ------------------------------
    define("VERSION", "1.1.0b");
    define("MINPHPVERSION", "4.1.0");
    define("VERSIONCHECKURL", "http://phpua.sourceforge.net/latest-version.txt");
    define("CONFIGFILE", "phpua.cfg.php");
    define("LOGFILE", "phpua.log.php");
    define("ABSOLUTEPATH", substr(__FILE__, 0, -11));
    define("DEBUG", 0);
    
    // ------------------------------
    // DEFINE VARIABLES
    // ------------------------------
    $phpUA["INSTALL"]["ERROR"] = NULL;
    $phpUA["INSTALL"]["WARNING"] = NULL;
    
    // ------------------------------
    // FUNCTION PLACEHOLDERS
    // ------------------------------
    function startBenchmark($string) { }
    function endBenchmark($string) { }
    function addCredits($string, $string) { }
    
    // ------------------------------
    // SESSION MANAGEMENT
    // ------------------------------
    session_start();
    
    // ------------------------------
    // LANGUAGE SUPPORT
    // ------------------------------
    if (!isset($_SESSION["LANG"])) {
        if (isset($_REQUEST["LANG"])) {
            $_SESSION["LANG"] = $_REQUEST["LANG"];
        } else {
            $_SESSION["LANG"] = "en-us";
        }
    }
    if (!file_exists(ABSOLUTEPATH . "languages/lang_" . $_SESSION["LANG"] . ".inc")) {
        die("Unable to locate or open the file: " . ABSOLUTEPATH . "languages/lang_" . $_SESSION["LANG"] . ".inc");
    } else {
        require_once ABSOLUTEPATH . "languages/lang_" . $_SESSION["LANG"] . ".inc";
        $phpUA["LANGUAGE"] = $_LANG[$_SESSION["LANG"]];
    }
    
    // ------------------------------
    // INSTALLATION STEP
    // ------------------------------
    if (isset($_REQUEST["step"])) $_SESSION["step"] = $_REQUEST["step"];
    else $_SESSION["step"] = 0;
    if (isset($_REQUEST["btnNext"])) $_SESSION["step"]++;
    
    // ------------------------------
    // INPUT VALIDATION
    // ------------------------------
    switch ( $_SESSION["step"] ) {
        case 5:
            if (empty($_REQUEST["step4_username"])) $phpUA["INSTALL"]["ERROR"] .= $phpUA["LANGUAGE"]["ERROR_BADUSERNAME"] . "<br>";
            if (empty($_REQUEST["step4_password"])) $phpUA["INSTALL"]["ERROR"] .= $phpUA["LANGUAGE"]["ERROR_BADPASSWORD"] . "<br>";
            if (empty($_REQUEST["step4_confirm_password"])) $phpUA["INSTALL"]["ERROR"] .= $phpUA["LANGUAGE"]["ERROR_BADPASSWORDMATCH"] . "<br>";
            if ($_REQUEST["step4_password"] != $_REQUEST["step4_confirm_password"]) $phpUA["INSTALL"]["ERROR"] .= $phpUA["LANGUAGE"]["ERROR_BADPASSWORDMATCH"] . "<br>";
            if ((strstr($_REQUEST["step4_username"], "#")) || (strstr($_REQUEST["step4_password"], "#")) ||
                (strstr($_REQUEST["step4_username"], "=")) || (strstr($_REQUEST["step4_password"], "=")) ||
                (strstr($_REQUEST["step4_username"], ":")) || (strstr($_REQUEST["step4_password"], ":"))
               ) $phpUA["INSTALL"]["ERROR"] .= $phpUA["LANGUAGE"]["ERROR_BADCHARS"] . "<br>";
            if (!empty($phpUA["INSTALL"]["ERROR"])) $_SESSION["step"] = 4;
            break;
    }
    
    // ------------------------------
    // OUTPUT HEADER
    // ------------------------------
    outputHeader($phpUA);
    
    // ------------------------------
    // INSTALLATION
    // ------------------------------
    switch ( $_SESSION["step"] ) {
        // ------------------------------
        // LANGUAGE SELECTION
        // ------------------------------
        case 0:
            if (file_exists(ABSOLUTEPATH . "languages/lang_" . $_SERVER["HTTP_ACCEPT_LANGUAGE"] . ".inc")) {
                $_REQUEST["LANG"] = $_SERVER["HTTP_ACCEPT_LANGUAGE"];
                $_SESSION["step"] = "1";
            } else {
                if ($handle = opendir(ABSOLUTEPATH . "languages/")) {
                    while (false !== ($file = readdir($handle))) {
                        if (($file != ".") && ($file != "..") && (substr($file,0,5) == "lang_") && (substr($file,-4) == ".inc")) { 
                            require_once ABSOLUTEPATH . "languages/" . $file;
                        }
                    }
                    closedir($handle);
                } else {
                    $phpUA["INSTALL"]["ERROR"] = "Unable to locate or open the directory: languages";
                }
            }
            ?>
            <table width="100%" border="0" cellspacing="0" cellpadding="10">
              <tr>
                <td>
                  <form name="form1" method="post" action="install.php">
                  <input type="hidden" name="step" value="0">
                  <p>
                  <div align="center">
                  <select name="step0_lang" size="1">
                  <?php foreach ($_LANG as $key => $value) { ?>
                  <option value="<?php echo $key;?>"><?php echo $value[0];?></option>
                  <?php } ?>
                  </select>
                  <input name="btnNext" type="submit" value="&gt;">
                  </div>
                  </p>
                </td>
              </tr>
            </table>
            <?php
            break;
        // ------------------------------
        // STEP 1: WELCOME
        // ------------------------------
        case 1:
            ?>
            <table width="100%" border="0" cellspacing="0" cellpadding="10">
              <tr>
                <td>
                  <form name="install" method="post" action="install.php">
                  <input type="hidden" name="step" value="1">
                  <p><span class="title"><?php echo $phpUA["LANGUAGE"]["Overview"]; ?> (<?php echo $phpUA["LANGUAGE"]["Step"]; ?> 1/5) </span></p>
                  <table width="50%" border="0" cellspacing="1" cellpadding="3">
                    <tr>
                      <td class="darkcell"><?php echo $phpUA["LANGUAGE"]["Package"]; ?>:</td>
                      <td class="lightcell">phpUA</td>
                    </tr>
                    <tr>
                      <td class="darkcell"><?php echo $phpUA["LANGUAGE"]["Version"]; ?>:</td>
                      <td class="lightcell"><?php echo VERSION; ?></td>
                    </tr>
                    <tr>
                      <td class="darkcell"><?php echo $phpUA["LANGUAGE"]["Distributor"]; ?>:</td>
                      <td class="lightcell"><a href="http://www.unitedadmins.com/" target="_blank">United Admins</a></td>
                    </tr>
                  </table>
                  <p><?php echo $phpUA["LANGUAGE"]["MSG_PACKAGEDESC"]; ?></p>
                  <p><?php echo $phpUA["LANGUAGE"]["MSG_CONTINUE"]; ?></p>
                  <p><input name="btnNext" type="submit" value="<?php echo $phpUA["LANGUAGE"]["Next"]; ?> &gt;"></p>
                  </form>
                </td>
              </tr>
            </table>
            <?php
            break;
        // ------------------------------
        // STEP 2: LICENSE AGREEMENT
        // ------------------------------
        case 2:
            ?>
            <table width="100%" border="0" cellspacing="0" cellpadding="10">
              <tr>
                <td>
                  <form name="install" method="post" action="install.php">
                  <input type="hidden" name="step" value="2">
                  <p><span class="title"><?php echo $phpUA["LANGUAGE"]["LicenseAgreement"]; ?> (<?php echo $phpUA["LANGUAGE"]["Step"]; ?> 2/5) </span></p>
                  <table width="50%" border="0" cellpadding="3" cellspacing="1">
                    <tr>
                      <td class="style7">
                        <span class="style4">
                        This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.<br>
                        <br>
                        This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.<br>
                        <br>
                        You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
                        </span>
                      </td>
                    </tr>
                  </table>
                  <p><?php echo $phpUA["LANGUAGE"]["MSG_AGREEORDISAGREE"]; ?></p>
                  <p><input name="btnNext" type="submit" value="<?php echo $phpUA["LANGUAGE"]["IAgree"]; ?>"></p>
                  </form>
                </td>
              </tr>
            </table>
            <?php
            break;
        // ------------------------------
        // STEP 3: SYSTEM REQUIREMENTS
        // ------------------------------
        case 3:
            // Latest phpUA Version
            if ($handle = @fopen(VERSIONCHECKURL, "r")) {
                $phpua_version_latest = fgets($handle,1024);
                if (version_compare(VERSION, $phpua_version_latest, "<")) {
                    $phpUA["INSTALL"]["PHPUAVER"] = $phpUA["LANGUAGE"]["No"];
                    $phpUA["INSTALL"]["WARNING"] .= $phpUA["LANGUAGE"]["ERROR_OLDPHPUA"] . " <a href=\"http://www.unitedadmins.com/\" target=\"_blank\">http://www.unitedadmins.com/</a><br><br>";
                } else {
                    $phpUA["INSTALL"]["PHPUAVER"] = $phpUA["LANGUAGE"]["Yes"];
                }
            } else {
                $phpUA["INSTALL"]["PHPUAVER"] = $phpUA["LANGUAGE"]["Unknown"];
                $phpUA["INSTALL"]["WARNING"] .= $phpUA["LANGUAGE"]["ERROR_UACONTACTFAILED"] . " " . $phpUA["LANGUAGE"]["ERROR_OLDPHPUA"] . " <a href=\"http://www.unitedadmins.com/\" target=\"_blank\">http://www.unitedadmins.com/</a><br><br>";
            }
            
            // PHP Version >= MINPHPVERSION
            if (version_compare(phpversion(), MINPHPVERSION, "<")) {
                $phpUA["INSTALL"]["PHPVER"] = "No (" . phpversion() . ")";
                $phpUA["INSTALL"]["ERROR"] .= "Your server must be running PHP Version " . MINPHPVERSION . " or later to install phpUA. You are currently running version " . phpversion() . ".<br><br>";
            } else {
                $phpUA["INSTALL"]["PHPVER"] = "Yes (" . phpversion() . ")";
            }
            
            // mod_gzip
            if (strstr("mod_gzip", $_SERVER["SERVER_SOFTWARE"])) {
                $phpUA["INSTALL"]["WARNING"] .= $phpUA["LANGUAGE"]["ERROR_MOD_GZIP"] . "<br><br>";
            }
            
            // Safe Mode warning about Max Execution Time
            if (ini_get("safe_mode")) {
                $phpUA["INSTALL"]["WARNING"] .= $phpUA["LANGUAGE"]["ERROR_SAFEMODE"] . " " . ini_get("max_execution_time") . " " . $phpUA["LANGUAGE"]["sec"] . ".<br><br>";
            }
            
            // install.php Permissions
            $phpUA["INSTALL"]["PERMISSIONS"] = "Yes";
            !@chmod(CONFIGFILE, 0666);
            !@chmod(LOGFILE, 0666);
            !@chmod("includes/templates_c", 0777);
            !@chmod("includes/smarty/cache", 0777);
            if (!is_writable(CONFIGFILE)) {
                $phpUA["INSTALL"]["PERMISSIONS"] = "No";
                $phpUA["INSTALL"]["ERROR"] .= "install.php " . $phpUA["LANGUAGE"]["ERROR_FILEPERM"] . " " . CONFIGFILE . "'.<br><br>";
            }
            if (!is_writable(LOGFILE)) {
                $phpUA["INSTALL"]["PERMISSIONS"] = "No";
                $phpUA["INSTALL"]["ERROR"] .= "install.php " . $phpUA["LANGUAGE"]["ERROR_FILEPERM"] . " " . LOGFILE . ".<br><br>";
            }
            if (!is_writable("includes/smarty/templates_c")) {
                $phpUA["INSTALL"]["PERMISSIONS"] = "No";
                $phpUA["INSTALL"]["ERROR"] .= "install.php " . $phpUA["LANGUAGE"]["ERROR_DIRPERM"] . " includes/smarty/templates_c.<br><br>";
            }
            if (!is_writable("includes/smarty/cache")) {
                $phpUA["INSTALL"]["PERMISSIONS"] = "No";
                $phpUA["INSTALL"]["ERROR"] .= "install.php " . $phpUA["LANGUAGE"]["ERROR_DIRPERM"] . " includes/smarty/cache.<br><br>";
            }
            ?>
            <table width="100%" border="0" cellspacing="0" cellpadding="10">
              <tr>
                <td>
                  <form name="install" method="post" action="install.php">
                  <input type="hidden" name="step" value="3">
                  <p><span class="title"><?php echo $phpUA["LANGUAGE"]["SystemRequirements"]; ?> (<?php echo $phpUA["LANGUAGE"]["Step"]; ?> 3/5) </span></p>
                  <table width="50%" border="0" cellpadding="3" cellspacing="1">
                    <tr>
                      <td class="darkcell"><?php echo $phpUA["LANGUAGE"]["MSG_LATESTPHPUA"]; ?></td>
                      <td class="lightcell"><?php echo $phpUA["INSTALL"]["PHPUAVER"];?></td>
                    </tr>
                    <tr>
                      <td class="darkcell">PHP &gt;= <?php echo $phpUA["LANGUAGE"]["Version"]; ?> <?php echo MINPHPVERSION; ?>: </td>
                      <td class="lightcell"><?php echo $phpUA["INSTALL"]["PHPVER"];?></td>
                      </tr>
                    <tr>
                      <td class="darkcell"><?php echo $phpUA["LANGUAGE"]["MSG_FILEDIRPERM"]; ?></td>
                      <td class="lightcell"><?php echo $phpUA["INSTALL"]["PERMISSIONS"];?></td>
                      </tr>
                  </table>
                  <br>
                  <?php if ( !empty($phpUA["INSTALL"]["WARNING"]) ) { ?>
                  <table width="100%" border="1" cellpadding="4" cellspacing="0" bordercolor="#FF0000">
                    <tr>
                      <td bordercolor="#660000" bgcolor="#660000"><p class="style3 style8"><?php echo $phpUA["LANGUAGE"]["WARNING"]; ?></p>
                        <p class="style3"><?php echo $phpUA["INSTALL"]["WARNING"]; ?></p>
                      </td>
                    </tr>
                  </table>
                  <br>
                  <?php } ?>
                  <?php if ( !empty($phpUA["INSTALL"]["ERROR"]) ) { ?>
                  <table width="100%" border="1" cellpadding="4" cellspacing="0" bordercolor="#FF0000">
                    <tr>
                      <td bordercolor="#660000" bgcolor="#660000"><p class="style3 style8"><?php echo $phpUA["LANGUAGE"]["ERROR"]; ?></p>
                        <p class="style3"><?php echo $phpUA["INSTALL"]["ERROR"]; ?></p>
                      </td>
                    </tr>
                  </table>
                  <br>
                  <?php } else { ?>
                  <p><?php echo $phpUA["LANGUAGE"]["MSG_CONTINUE"]; ?></p>
                  <p><input name="btnNext" type="submit" value="<?php echo $phpUA["LANGUAGE"]["Next"]; ?> &gt;"></p>
                  <?php } ?>
                  </form>
                </td>
              </tr>
            </table>
            <?php
            break;
        // ------------------------------
        // STEP 4: ADMINISTRATION
        // ------------------------------
        case 4:
            if (!isset($_REQUEST["step4_username"])) $_REQUEST["step4_username"] = NULL;
            ?>
            <table width="100%" border="0" cellspacing="0" cellpadding="10">
              <tr>
                <td>
                  <form name="install" method="post" action="install.php">
                  <input type="hidden" name="step" value="4">
                  <p><span class="title"><?php echo $phpUA["LANGUAGE"]["Administration"]; ?> (<?php echo $phpUA["LANGUAGE"]["Step"]; ?> 4/5) </span></p>
                  <p><?php echo $phpUA["LANGUAGE"]["MSG_CREATEADMIN"]; ?></p>
                  <table width="50%" border="0" cellpadding="3" cellspacing="1">
                    <tr>
                      <td class="darkcell"><?php echo $phpUA["LANGUAGE"]["Username"]; ?>:</td>
                      <td class="lightcell"><input name="step4_username" value="<?php echo $_REQUEST["step4_username"];?>" type="text"></td>
                    </tr>
                    <tr>
                      <td class="darkcell"><?php echo $phpUA["LANGUAGE"]["Password"]; ?>:</td>
                      <td class="lightcell"><input name="step4_password" type="password"></td>
                      </tr>
                    <tr>
                      <td class="darkcell"><?php echo $phpUA["LANGUAGE"]["ConfirmPassword"]; ?>:</td>
                      <td class="lightcell"><input name="step4_confirm_password" type="password"></td>
                      </tr>
                  </table>
                  <br>
                  <?php if (!empty($phpUA["INSTALL"]["ERROR"])) { ?>
                  <table width="100%" border="1" cellpadding="4" cellspacing="0" bordercolor="#FF0000">
                    <tr>
                      <td bordercolor="#660000" bgcolor="#660000"><p class="style3 style8"><?php echo $phpUA["LANGUAGE"]["ERROR"]; ?></p>
                        <p class="style3"><?php echo $phpUA["INSTALL"]["ERROR"]; ?></p>
                      </td>
                    </tr>
                  </table>
                  <br>
                  <?php } ?>
                  <p><?php echo $phpUA["LANGUAGE"]["MSG_CONTINUE"]; ?>.</p>
                  <p><input name="btnNext" type="submit" value="<?php echo $phpUA["LANGUAGE"]["Next"]; ?> &gt;"></p>
                  </form>
                </td>
              </tr>
            </table>
            <?php
            break;
        // ------------------------------
        // STEP 5: INSTALLATION COMPLETE
        // ------------------------------
        case 5:
            $_SESSION["step4_username"] = $_REQUEST["step4_username"];
            $_SESSION["step4_password"] = md5($_REQUEST["step4_password"]);
            
            if (!writeConfigFile()) $phpUA["INSTALL"]["ERROR"] = "Unable to write configuration file.";
            if (!writeLogFile()) $phpUA["INSTALL"]["ERROR"] = "Unable to write log file.";
            if (DEBUG == 0) if (!@unlink("install.php")) $phpUA["INSTALL"]["WARNING"] .= $phpUA["LANGUAGE"]["ERROR_REMOVEFAILED"];
            ?>
            <table width="100%" border="0" cellspacing="0" cellpadding="10">
              <tr>
                <td>
                  <form name="install" method="post" action="install.php">
                  <input type="hidden" name="step" value="5">
                  <p><span class="title"><?php echo $phpUA["LANGUAGE"]["InstallationComplete"]; ?> (<?php echo $phpUA["LANGUAGE"]["Step"]; ?> 5/5) </span></p>
                  <?php if (!empty($phpUA["INSTALL"]["WARNING"])) { ?>
                  <table width="100%" border="1" cellpadding="4" cellspacing="0" bordercolor="#FF0000">
                    <tr>
                      <td bordercolor="#660000" bgcolor="#660000"><p class="style3 style8"><?php echo $phpUA["LANGUAGE"]["WARNING"]; ?></p>
                        <p class="style3"><?php echo $phpUA["INSTALL"]["WARNING"]; ?></p>
                      </td>
                    </tr>
                  </table>
                  <br>
                  <?php } ?>
                  <?php if (!empty($phpUA["INSTALL"]["ERROR"])) { ?>
                  <table width="100%" border="1" cellpadding="4" cellspacing="0" bordercolor="#FF0000">
                    <tr>
                      <td bordercolor="#660000" bgcolor="#660000"><p class="style3 style8"><?php echo $phpUA["LANGUAGE"]["ERROR"]; ?></p>
                        <p class="style3"><?php echo $phpUA["INSTALL"]["ERROR"]; ?></p>
                      </td>
                    </tr>
                  </table>
                  <br>
                  <?php } else { ?>
                  <table width="100%" border="1" cellpadding="4" cellspacing="0" bordercolor="#FF0000">
                   <tr>
                    <td bordercolor="#660000" bgcolor="#660000">
                      <p class="style3"><?php echo $phpUA["LANGUAGE"]["READTHISPAGE"]; ?></p>
                    </td>
                   </tr>
                  </table>
                  <br>
                  <?php echo $phpUA["LANGUAGE"]["MSG_FINALWORDS"]; ?>
                  <input type="button" name="Button" value="<?php echo $phpUA["LANGUAGE"]["Finish"]; ?>" onClick="javascript:document.location.href='index.php'">
                  <?php } ?>
                  </form>
                </td>
              </tr>
            </table>
            <?php
            break;
    }
    outputFooter($phpUA);
    
    function writeConfigFile()
    {
        if ($handle = @fopen(CONFIGFILE, "w")) {
            fwrite($handle, "<?php header(\"Location: index.php\"); exit; ?>" . "\n");
            fwrite($handle, "# " . "\n");
            fwrite($handle, "# phpua.cfg.php" . "\n");
            fwrite($handle, "# phpUA Configuration File" . "\n");
            fwrite($handle, "# NOTE: This file is NOT subject to Copyright." . "\n");
            fwrite($handle, "# " . "\n");
            fwrite($handle, "# ============================================================ #" . "\n");
            fwrite($handle, "# WARNING: DO NOT MODIFY THIS FILE.                            #" . "\n");
            fwrite($handle, "#          MODIFICATION WILL RESULT IN CORRUPTION.             #" . "\n");
            fwrite($handle, "#          READ THE DOCUMENTATION FOR INSTALLATION PROCEEDURE. #" . "\n");
            fwrite($handle, "# ============================================================ #" . "\n");
            fwrite($handle, "#" . "\n");
            fwrite($handle, "\n");
            fwrite($handle, "STYLE=default" . "\n");
            fwrite($handle, "SITE_HOME_NAME=United Admins" . "\n");
            fwrite($handle, "SITE_HOME_URL=http://www.unitedadmins.com/" . "\n");
            fwrite($handle, "LANG=" . $_SESSION["LANG"] . "\n");
            fwrite($handle, "ADMIN=" . $_SESSION["step4_username"] . ":" . $_SESSION["step4_password"] . "\n");
            fwrite($handle, "TIMEOUT=3" . "\n");
            fwrite($handle, "INTERVAL=5" . "\n");
            if (ini_get("safe_mode")) {
                fwrite($handle, "TIMELIMIT=" . ini_get("max_execution_time") . "\n");
            } else {
                fwrite($handle, "TIMELIMIT=300" . "\n");
            }
            fclose($handle);
            return true;
        } else {
            return false;
        }
    }
    
    function writeLogFile()
    {
        if ($handle = @fopen(LOGFILE, "w")) {
            fwrite($handle, "<?php header(\"Location: index.php\"); exit; ?>" . "\n");
            fwrite($handle, "# " . "\n");
            fwrite($handle, "# phpua.log.php" . "\n");
            fwrite($handle, "# phpUA Log File" . "\n");
            fwrite($handle, "# NOTE: This file is NOT subject to Copyright." . "\n");
            fwrite($handle, "# " . "\n");
            fwrite($handle, "\n");
            fclose($handle);
            return true;
        } else {
            return false;
        }
    }
    
    function outputHeader($phpUA) {
        ?>
        <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
        "http://www.w3.org/TR/html4/loose.dtd">
        <html>
        <head>
        <title><?php echo $phpUA["LANGUAGE"]["Installation"]; ?></title>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
        <style type="text/css">
        <!--
        body,td,th {
            font-family: Verdana, Arial, Helvetica, sans-serif;
            font-size: 12px;
            color: #C6C6C6;
        }
        body {
            background-color: #253546;
            margin-left: 0px;
            margin-top: 0px;
            margin-right: 0px;
            margin-bottom: 0px;
        }
        a:link {
            color: #FFFFFF;
            text-decoration: none;
        }
        a:visited {
            text-decoration: none;
            color: #FFFFFF;
        }
        a:hover {
            text-decoration: underline;
            color: #FFFFFF;
        }
        a:active {
            text-decoration: none;
            color: #FFFFFF;
        }
        .style1 {
            font-size: 18px;
            font-weight: bold;
            color: #C6C6C6;
        }
        .style2 {
            font-size: 18px;
            font-weight: bold;
            color: #FFFFFF;
        }
        .style3 {
            font-size: 12px;
            font-weight: bold;
            color: #FFFFFF;
        }
        .style4 {
            font-size: 10px;
        }
        .title {
            font-size: 16px;
            font-weight: bold;
        }
        .darkcell {
            background-color: #071728; 
            font-weight: bold; 
        }
        .lightcell {
            background-color: #39495A;
        }
        .style8 {color: #FF0000}
        .footerhr {
            color: #39495A;
        }
        -->
        </style>
        </head>
        <body>
        <table width="100%" border="0" cellspacing="0" cellpadding="10">
        <tr>
            <td background="images/templates/default/header_tile.gif">
            <p>
            <br>
            <span class="style1">php</span><span class="style2">UA</span><span class="style1"> Installation </span><br>
            <br>
            </p>
            </td>
        </tr>
        </table>
        <table width="100%" border="0" cellspacing="0" cellpadding="4">
        <tr>
            <td bgcolor="#071728"><span class="style4">Copyright &copy; <a href="http://www.unitedadmins.com/" target="_blank">United Admins</a> 2004</span></td>
        </tr>
        </table>
        <br>
        <?php
    }
    
    function outputFooter($phpUA) {
        ?>
            <br>
            <table width="100%" border="0" cellspacing="0" cellpadding="10">
              <tr>
                <td>
                  <hr class="footerhr" align="center" width="50%" size="1" noshade>
                  <div align="center"><span class="style4"><strong>phpUA</strong> <?php echo $phpUA["LANGUAGE"]["poweredby"]; ?> <a href="http://www.unitedadmins.com/" target="_blank">United Admins</a> &copy; 2004</span></div>
                </td>
              </tr>
            </table>
          </body>
        </html>
        <?php
    }
?>