<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: log.inc,v 1.5 2004/02/27 12:00:40 mad-x Exp $
    // Created by Kris Splittgerber (kris@phpua.com)
    
    startBenchmark(__FILE__, __FUNCTION__);
    
    // !!! SECURITY !!!
    if (!$_SESSION["authenticated"]) displayErrorMessage($phpUA["LANGUAGE"]["ERROR_ACCESSDENIED"]);
    
    if (!empty($_REQUEST["action"])) {
        switch ($_REQUEST["action"]) {
            case $phpUA["LANGUAGE"]["Clear"]:
                clearLog();
                break;
        }
    }
    
    // Read Log File
    $log_array = array();
    if ($handle = @fopen(ABSOLUTEPATH . LOGFILE, "r")) {
        clearstatcache();
        $contents = fread($handle, filesize(ABSOLUTEPATH . LOGFILE));
        $lines = explode("\n", $contents);
        for ($i=0; $i<count($lines); $i++) {
            if (!empty($lines[$i]) && 
                substr($lines[$i],0,2) != "<?" &&
                substr($lines[$i],0,1) != "#") {
                $event = explode("\t", $lines[$i]);
                $log_array[] = array("timestamp"=>$event[0],
                                     "username" =>$event[1],
                                     "event"    =>$event[2]);
            }
        }
    } else {
        displayErrorMessage($phpUA["LANGUAGE"]["ERROR_FILEERROR"] . LOGFILE);
    }
    
    // Output template
    $phpUA["TEMPLATE"]->assign("LOG", $log_array);
    $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/admin/log.tpl");
    
    endBenchmark(__FILE__, __FUNCTION__);
?>