<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: languages.inc,v 1.6 2004/03/10 10:44:47 mad-x Exp $
    // Created by Kris Splittgerber (kris@phpua.com)
    
    startBenchmark(__FILE__, __FUNCTION__);
    
    // Decide which file to use.
    if (isset($_REQUEST["language"])) $language = $_REQUEST["language"];
    else $language = $_SERVER["HTTP_ACCEPT_LANGUAGE"];
    
    // Ensure that we can use that file, if not, default to config setting.
    if (!file_exists(ABSOLUTEPATH . "languages/lang_" . $language . ".inc")) {
        $language = $phpUA["CONFIG"]["LANG"];
        if (!file_exists(ABSOLUTEPATH . "languages/lang_" . $language . ".inc")) {
            if (file_exists(ABSOLUTEPATH . "languages/lang_en-us.inc")) {
                configRemoveLine("LANG");
                configAddLine("LANG", "en-us");
                $language = $phpUA["CONFIG"]["LANG"];
            } else {
                displayErrorMessage("Unable to find the requested/configured/default language file.");
            }
        }
    }
    
    // Use the $language file for translation.
    require_once ABSOLUTEPATH . "languages/lang_" . $language . ".inc";
    $phpUA["LANGUAGE"] = $_LANG[$language];
    $phpUA["TEMPLATE"]->assign("LANG", $_LANG[$language]);
    
    endBenchmark(__FILE__, __FUNCTION__);
?>