<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: plugin_bf.inc,v 1.3 2004/02/26 09:39:02 mad-x Exp $
    // Created by Kris Splittgerber (kris@phpua.com)
    
    pluginRegisterGame("BF", "Battlefield 1942", "plugin_bf", basename(__FILE__));
    addCredits($phpUA["LANGUAGE"]["Plugin"] . ": Battlefield 1942", "Kris Splittgerber");
    
    class plugin_bf {
        var $_id;
        var $_ip;
        var $_port;
        var $_info;
        
        function plugin_bf($id, $ip = "127.0.0.1", $port = "14567")
        {
            $this->_id = $id;
            $this->_ip = $ip;
            $this->_port = $port;
        }
        
        function isOnline()
        {
            startBenchmark(__FILE__, __CLASS__ . " -> " . __FUNCTION__);
            require_once(ABSOLUTEPATH . "plugins/shared/plugin_gs_query.inc");
            
            $server_query = new plugin_gs_query($this->_ip, $this->_port + 8433);
            
            endBenchmark(__FILE__, __CLASS__ . " -> " . __FUNCTION__);
            if (!$this->info = $server_query->info()) return false;
            if (empty($this->info["hostname"])) return false;
            
            return true;
        }
        
        function getInfo()
        {
            startBenchmark(__FILE__, __CLASS__ . " -> " . __FUNCTION__);
            global $phpUA;
            require_once(ABSOLUTEPATH . "plugins/shared/plugin_gs_query.inc");
            
            if ( $this->info["version"] == "v1.6" ) {
                endBenchmark(__FILE__, __CLASS__ . " -> " . __FUNCTION__);
                return array("name"=>$this->info["hostname"],
                             "desc"=>$this->info["gameId"] . ": " . $this->info["numplayers"] . "/" . $this->info["maxplayers"] . " " . $phpUA["LANGUAGE"]["on"] . " " . $this->info["mapname"]);
            } else {
                endBenchmark(__FILE__, __CLASS__ . " -> " . __FUNCTION__);
                return array("name"=>$this->info["hostname"],
                             "desc"=>$this->info["gametype"] . ": " . $this->info["numplayers"] . "/" . $this->info["maxplayers"] . " " . $phpUA["LANGUAGE"]["on"] . " " . $this->info["mapname"]);
            }
        }
    }
?>