<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: plugin_bf_mode_watch.inc,v 1.3 2004/02/26 10:15:18 mad-x Exp $
    // Created by Kris Splittgerber (kris@phpua.com)
    
    pluginRegisterMode("BF", "watch", $phpUA["LANGUAGE"]["Watch"], "plugin_bf_mode_watch", 1, 1, 0, "plugin_bf_mode_watch.inc");
    
    function plugin_bf_mode_watch($id, $ip, $port)
    {
        startBenchmark(__FILE__, __FUNCTION__);
        
        global $phpUA;
        require_once(ABSOLUTEPATH . "plugins/shared/plugin_gs_query.inc");
        $server_query = new plugin_gs_query($ip, $port + 8433);
        
        if ($info = $server_query->info()) {
            $phpUA["TEMPLATE"]->assign("SERVER_ID", $id);
            $phpUA["TEMPLATE"]->assign("SERVER_IP", $ip);
            $phpUA["TEMPLATE"]->assign("SERVER_PORT", $port);
            
            $phpUA["TEMPLATE"]->assign("SERVER_HOSTNAME", $info["hostname"]);
            $phpUA["TEMPLATE"]->assign("SERVER_VERSION", $info["version"]);
            $phpUA["TEMPLATE"]->assign("SERVER_MAPNAME", "<span id=\"server_mapname\">&nbsp</span>");
            $phpUA["TEMPLATE"]->assign("SERVER_TICKETS1", "<span id=\"server_tickets1\">&nbsp</span>");
            $phpUA["TEMPLATE"]->assign("SERVER_TICKETS2", "<span id=\"server_tickets2\">&nbsp</span>");
            $phpUA["TEMPLATE"]->assign("SERVER_NUMPLAYERS", "<span id=\"server_numplayers\">&nbsp</span>");
            $phpUA["TEMPLATE"]->assign("SERVER_MAXPLAYERS", "<span id=\"server_maxplayers\">&nbsp</span>");
            $phpUA["TEMPLATE"]->assign("SERVER_ROUNDTIMEREMAIN", "<span id=\"server_roundTimeRemain\">&nbsp</span>");
            for($i=0; $i<$info["maxplayers"]; $i++) {
                $players_array[$i] = array("name"=>"<span id=\"player_" . $i . "_name\">&nbsp</span>",
                                           "team"=>"<span id=\"player_" . $i . "_team\">&nbsp</span>",
                                           "score"=>"<span id=\"player_" . $i . "_score\">&nbsp</span>",
                                           "kills"=>"<span id=\"player_" . $i . "_kills\">&nbsp</span>",
                                           "deaths"=>"<span id=\"player_" . $i . "_deaths\">&nbsp</span>",
                                           "ping"=>"<span id=\"player_" . $i . "_ping\">&nbsp</span>");
            }
            $phpUA["TEMPLATE"]->assign("SERVER_PLAYERS", $players_array);
            
            $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/plugin_bf/watch.tpl");
            $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/body_footer.tpl");
            
            endBenchmark(__FILE__, __FUNCTION__);
            printBenchmark();
            
            while (!connection_aborted()) {
                if (!$info = $server_query->info()) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
                if (!$players = $server_query->players()) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
                echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                if ( $info["version"] == "v1.6" ) {
                    $server_roundTimeRemain = date("i:s", $info["roundTimeRemain"]+86400);
                } else {
                    $server_roundTimeRemain = 0;
                }
                plugin_bf_mode_watch_updateserver($info["mapname"], $info["numplayers"], $info["maxplayers"], $info["tickets1"], $info["tickets2"], $server_roundTimeRemain);
                $players_sorted = array();
                for($i=0; $i<$info["numplayers"]; $i++) {
                    if ( $info["version"] == "v1.6" ) {
                        $name = $players["playername"][$i];
                        $kills = $players["kills"][$i];
                    } else {
                        $name = $players["player"][$i];
                        $kills = $players["frags"][$i];
                    }
                    $players_sorted[] = array("name"=>$name,
                                              "team"=>$players["teamname"][$players["team"][$i]-1],
                                              "score"=>$players["score"][$i],
                                              "kills"=>$kills,
                                              "deaths"=>$players["deaths"][$i],
                                              "ping"=>$players["ping"][$i]);
                }
                foreach ($players_sorted as $key => $row) {
                    $team[$key] = $row["team"];
                    $score[$key] = $row["score"];
                    $kills[$key] = $row["kills"];
                    $deaths[$key] = $row["deaths"];
                    $name[$key] = $row["name"];
                }
                @array_multisort($team, SORT_ASC, $score, SORT_DESC, $kills, SORT_DESC, $deaths, SORT_ASC, $name, SORT_ASC, $players_sorted);
                for ($i=0; $i<count($players_sorted); $i++) {
                    plugin_bf_mode_watch_updateplayer($i, $players_sorted[$i]["name"], $players_sorted[$i]["team"], $players_sorted[$i]["score"], $players_sorted[$i]["kills"], $players_sorted[$i]["deaths"], $players_sorted[$i]["ping"]);
                }
                plugin_bf_mode_watch_clearplayer($info["numplayers"]);
                echo "</script>\n";
                if (time() >= ($phpUA["ENGINE"]["TIME"] + $phpUA["CONFIG"]["TIMELIMIT"] - $phpUA["CONFIG"]["TIMEOUT"])) {
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    echo "if ( confirm('" . $phpUA["LANGUAGE"]["ERROR_TIMELIMITREACHED"] . "') ) {\n";
                    echo "  document.location.href = '" . INDEXFILE . "?mode=watch&server=" . $id . "';\n";
                    echo "} else {\n";
                    echo "  document.location.href = '" . INDEXFILE . "?mode=index';\n";
                    echo "}\n";
                    echo "</script>\n";
                    $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/html_footer.tpl");
                    exit;
                }
                flush();
                sleep($phpUA["CONFIG"]["INTERVAL"]);
                if (!ini_get("safe_mode")) set_time_limit(ini_get("max_execution_time"));
            }
        }
        else {
            displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
        }
    }
    
    function plugin_bf_mode_watch_updateplayer($id, $name, $team, $score, $kills, $deaths, $ping)
    {
        // p(id, name, team, score, kills, deaths, ping)
        echo "p('" . $id . "', '" . htmlentities($name, ENT_QUOTES) . "', '" . $team . "', '" . $score . "', '" . $kills . "', '" . $deaths . "', '" . $ping . "');\n";
    }
    
    function plugin_bf_mode_watch_clearplayer($count)
    {
        // c(count)
        echo "c('" . $count . "');\n";
    }
    
    function plugin_bf_mode_watch_updateserver($mapname, $numplayers, $maxplayers, $tickets1, $tickets2, $roundTimeRemain)
    {
        // s(mapname, numplayers, maxplayers, tickets1, tickets2, roundTimeRemain)
        echo "s('" . $mapname . "', '" . $numplayers . "', '" . $maxplayers . "', '" . $tickets1 . "', '" . $tickets2 . "', '" . $roundTimeRemain . "');\n";
    }
?>