<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: plugin_bf_mode_info.inc,v 1.3 2004/02/26 10:15:18 mad-x Exp $
    // Created by Kris Splittgerber (kris@phpua.com)
    
    startBenchmark(__FILE__, __FUNCTION__);
    pluginRegisterMode("BF", "info", $phpUA["LANGUAGE"]["Info"], "plugin_bf_mode_info", 1, 1, 0, "plugin_bf_mode_info.inc");
    
    function plugin_bf_mode_info($id, $ip, $port)
    {
        startBenchmark(__FILE__, __FUNCTION__);
        
        global $phpUA;
        require_once(ABSOLUTEPATH . "plugins/shared/plugin_gs_query.inc");
        $server_query = new plugin_gs_query($ip, $port + 8433);
        
        if ($info = $server_query->info()) {
            // Generic Assignments
            $phpUA["TEMPLATE"]->assign("SERVER_ID", $id);
            $phpUA["TEMPLATE"]->assign("SERVER_IP", $ip);
            $phpUA["TEMPLATE"]->assign("SERVER_PORT", $port);
            
            // 'info' Assignments
            $phpUA["TEMPLATE"]->assign("SERVER_HOSTNAME", $info["hostname"]);
            $phpUA["TEMPLATE"]->assign("SERVER_HOSTPORT", $info["hostport"]);
            $phpUA["TEMPLATE"]->assign("SERVER_MAPNAME", $info["mapname"]);
            $phpUA["TEMPLATE"]->assign("SERVER_GAMETYPE", $info["gametype"]);
            $phpUA["TEMPLATE"]->assign("SERVER_NUMPLAYERS", $info["numplayers"]);
            $phpUA["TEMPLATE"]->assign("SERVER_MAXPLAYERS", $info["maxplayers"]);
            $phpUA["TEMPLATE"]->assign("SERVER_GAMEMODE", $info["gamemode"]);
            switch ($info["password"]) { 
                case 0:
                    $server_password = "None";
                    break;
                case 1:
                    $server_password = "Required";
                    break;
            }
            $phpUA["TEMPLATE"]->assign("SERVER_PASSWORD", $server_password);
            switch ($info["dedicated"]) { 
                case 0:
                    $server_dedicated = "No";
                    break;
                case 1:
                    $server_dedicated = "Yes (Windows)";
                    break;
                case 2:
                    $server_dedicated = "Yes (Linux)";
                    break;
            }
            $phpUA["TEMPLATE"]->assign("SERVER_DEDICATED", $server_dedicated);
            $phpUA["TEMPLATE"]->assign("SERVER_STATUS", $info["status"]); // ?
            $phpUA["TEMPLATE"]->assign("SERVER_VERSION", $info["version"]);
            $phpUA["TEMPLATE"]->assign("SERVER_GAMEID", $info["gameId"]);
            $phpUA["TEMPLATE"]->assign("SERVER_MAPID", $info["mapId"]);
            $phpUA["TEMPLATE"]->assign("SERVER_AVERAGEFPS", $info["averageFPS"]); // ?
            $phpUA["TEMPLATE"]->assign("SERVER_TICKETS1", $info["tickets1"]);
            $phpUA["TEMPLATE"]->assign("SERVER_TICKETS2", $info["tickets2"]);
            $phpUA["TEMPLATE"]->assign("SERVER_ROUNDTIME", date("i:s", $info["roundTime"]+86400));
            $phpUA["TEMPLATE"]->assign("SERVER_RESERVEDSLOTS", $info["reservedslots"]);
            if ($info["version"] == "v1.6") {
                $phpUA["TEMPLATE"]->assign("SERVER_UNPURE_MODS", $info["unpure_mods"]); // ?
                $phpUA["TEMPLATE"]->assign("SERVER_CONTENT_CHECK", $info["content_check"]); // ?
                $phpUA["TEMPLATE"]->assign("SERVER_ROUNDTIMEREMAIN", date("i:s", $info["roundTimeRemain"]+86400));
                switch ($info["sv_punkbuster"]) {
                    case 0:
                        $server_sv_punkbuster = "No";
                        break;
                    case 1:
                        $server_sv_punkbuster = "Yes";
                        break;
                }
                $phpUA["TEMPLATE"]->assign("SERVER_SV_PUNKBUSTER", $server_sv_punkbuster);
            }
            $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/plugin_bf/info.tpl");
        } else {
            displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
        }
        
        endBenchmark(__FILE__, __FUNCTION__);
    }
    
    endBenchmark(__FILE__, __FUNCTION__);
?>