<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: plugin_cod_mode_info.inc,v 1.4 2004/02/27 12:52:18 mad-x Exp $
    // Created by Hendrik Leppkes (punisher@unitedadmins.com)
    
    pluginRegisterMode("CoD", "info", $phpUA["LANGUAGE"]["Info"], "plugin_cod_mode_info", 1, 1, 0, "plugin_cod_mode_info.inc");
    
    function plugin_cod_mode_info($id, $ip, $port)
    {
        startBenchmark(__FILE__, __FUNCTION__);
        
        global $phpUA;
        require_once(ABSOLUTEPATH . "plugins/shared/plugin_q3_query.inc");
        $server_query = new plugin_q3_query($ip, $port);
        
        $phpUA["TEMPLATE"]->assign("SERVER_ID", $id);
        $phpUA["TEMPLATE"]->assign("SERVER_IP", $ip);
        $phpUA["TEMPLATE"]->assign("SERVER_PORT", $port);
        
        if ( !$status = $server_query->getstatus() ) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
        if ( !$info = $server_query->getinfo() ) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
        $phpUA["TEMPLATE"]->assign("SERVER_HOSTNAME", $server_query->stripColorCodes($status["sv_hostname"]));
        $phpUA["TEMPLATE"]->assign("SERVER_MAP", $status["mapname"]);
        
        $image = "images/plugin_cod/maps/" . $status["mapname"] . ".jpg";
        if (!file_exists($image)) {
            $image = "images/templates/" . $phpUA["STYLE"] . "/plugin_cod/unavailable.jpg";
        }
        $imagesize = getimagesize(ABSOLUTEPATH . $image);
        
        $phpUA["TEMPLATE"]->assign("SERVER_MAP_IMG", "<img src=\"" . $image . "\" width=\"" . $imagesize[0] . "\" height=\"" . $imagesize[1] . "\" alt=\"Map Image\">");
        $phpUA["TEMPLATE"]->assign("SERVER_MAP_IMG_TITLE", $status["mapname"]);
        $phpUA["TEMPLATE"]->assign("SERVER_GAME_DIR", $status["gamename"]);
        $phpUA["TEMPLATE"]->assign("SERVER_PLAYERS_CURRENT", (isset($info["clients"])) ? $info["clients"] : 0);
        $phpUA["TEMPLATE"]->assign("SERVER_PLAYERS_MAX", ($status["sv_maxclients"] - $status["sv_privateclients"])." (".$status["sv_maxclients"].")");
        $phpUA["TEMPLATE"]->assign("SERVER_PROTOCOL", $status["protocol"]);
        $phpUA["TEMPLATE"]->assign("SERVER_VERSION", $status["shortversion"]);
        if (empty($status["gameversion"])) {
            $phpUA["TEMPLATE"]->assign("SERVER_GAME_VERSION", "");
        } else {
            $phpUA["TEMPLATE"]->assign("SERVER_GAME_VERSION", $status["gameversion"]);
        }
        if (empty($status["g_needpass"])) {
            $phpUA["TEMPLATE"]->assign("SERVER_PASSWORD", "");
        } else {
            $phpUA["TEMPLATE"]->assign("SERVER_PASSWORD", $status["g_needpass"] ? $phpUA["LANGUAGE"]["Required"] : $phpUA["LANGUAGE"]["None"]);
        }
        if (empty($status["sv_punkbuster"])) {
            $phpUA["TEMPLATE"]->assign("SERVER_PUNKBUSTER", "");
        } else {
            $phpUA["TEMPLATE"]->assign("SERVER_PUNKBUSTER", $status["sv_punkbuster"] ? $phpUA["LANGUAGE"]["Yes"] : $phpUA["LANGUAGE"]["No"]);
        }
        
		$gametype = array(
			'dm' => 'Death Match',
			'tdm' => 'Team DeathMatch',
			'sd' => 'Search and Destroy',
			're' => 'Retrieval',
			'bel' => 'Behind Enemy Lines',
			'hq' => 'Headquarters');
			
        $phpUA["TEMPLATE"]->assign("SERVER_TYPE", $gametype[$info['gametype']]);

        
        // Display Template
        $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/plugin_cod/info.tpl");
        
        endBenchmark(__FILE__, __FUNCTION__);
    }
?>