<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: plugin_hl.inc,v 1.3 2004/02/26 09:39:02 mad-x Exp $
    // Created by Kris Splittgerber (kris@phpua.com)
    
    pluginRegisterGame("HL", "Half-Life", "plugin_hl", basename(__FILE__));
    addCredits($phpUA["LANGUAGE"]["Plugin"] . ": Half-Life", "Kris Splittgerber, Brian A. Stumm");
    
    class plugin_hl {
        var $_id;
        var $_ip;
        var $_port;
        
        function plugin_hl($id, $ip, $port)
        {
            $this->_id = $id;
            $this->_ip = $ip;
            $this->_port = $port;
        }
        
        function isOnline()
        {
            require_once(ABSOLUTEPATH . "plugins/plugin_hl/plugin_hl_query.inc");
            
            $server_query = new plugin_hl_query($this->_ip, $this->_port);
            if ($server_query->ping()) return true;
            else return false;
        }
        
        function getInfo()
        {
            global $phpUA;
            require_once(ABSOLUTEPATH . "plugins/plugin_hl/plugin_hl_query.inc");
            
            $server_query = new plugin_hl_query($this->_ip, $this->_port);
            if (!$info = $server_query->info()) return false;
            
            if ($info["mod_name"] == "Half-Life") $info["mod_name"] = "Deathmatch";
            
            return array("name"=>$info["hostname"],
                         "desc"=>$info["mod_name"] .": " . $info["cur_players"] . "/" . $info["max_players"] . " " . $phpUA["LANGUAGE"]["on"] . " " . $info["map"]);
        }
    }
?>
