<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: plugin_hl_mode_info.inc,v 1.5 2004/02/27 12:46:10 mad-x Exp $
    // Created by Kris Splittgerber (kris@phpua.com)
    
    pluginRegisterMode("HL", "info", $phpUA["LANGUAGE"]["Info"], "plugin_hl_mode_info", 1, 1, 0, "plugin_hl_mode_info.inc");
    
    function plugin_hl_mode_info($id, $ip, $port)
    {
        startBenchmark(__FILE__, __FUNCTION__);
        
        global $phpUA;
        require_once(ABSOLUTEPATH . "plugins/plugin_hl/plugin_hl_query.inc");
        $server_query = new plugin_hl_query($ip, $port);
        
        // Generic Assignments
        $phpUA["TEMPLATE"]->assign("SERVER_ID", $id);
        $phpUA["TEMPLATE"]->assign("SERVER_IP", $ip);
        $phpUA["TEMPLATE"]->assign("SERVER_PORT", $port);
        
        // Complete "infostring" Assignment
        if ( !$infostring = $server_query->infostring() ) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
        $phpUA["TEMPLATE"]->assign("SERVER_ADDRESS", $infostring["address"]);
        $phpUA["TEMPLATE"]->assign("SERVER_HOSTNAME", $infostring["hostname"]);
        $phpUA["TEMPLATE"]->assign("SERVER_MAP", $infostring["map"]);
        $phpUA["TEMPLATE"]->assign("SERVER_MAP_IMG_TITLE", $infostring["map"]);
        $phpUA["TEMPLATE"]->assign("SERVER_GAMEDIR", $infostring["gamedir"]);
        $phpUA["TEMPLATE"]->assign("SERVER_MOD_NAME", $infostring["description"]);
        $phpUA["TEMPLATE"]->assign("SERVER_PLAYERS_CURRENT", $infostring["players"]);
        $phpUA["TEMPLATE"]->assign("SERVER_PLAYERS_MAX", $infostring["max"]);
        $phpUA["TEMPLATE"]->assign("SERVER_PROTOCOL", $infostring["protocol"]);
        $phpUA["TEMPLATE"]->assign("SERVER_BOTS", $infostring["bots"]);
        $phpUA["TEMPLATE"]->assign("SERVER_PROXYTARGET", $infostring["proxytarget"]); // ?
        $phpUA["TEMPLATE"]->assign("SERVER_PASSWORD", $infostring["password"] ? $phpUA["LANGUAGE"]["Required"] : $phpUA["LANGUAGE"]["None"]);
        $phpUA["TEMPLATE"]->assign("SERVER_LAN", $infostring["lan"] ? $phpUA["LANGUAGE"]["Yes"] : $phpUA["LANGUAGE"]["No"]);
        $phpUA["TEMPLATE"]->assign("SERVER_SECURE", $infostring["secure"] ? $phpUA["LANGUAGE"]["Yes"] : $phpUA["LANGUAGE"]["No"]);
        $phpUA["TEMPLATE"]->assign("SERVER_MOD_ENABLED", $infostring["mod"] ? $phpUA["LANGUAGE"]["Yes"] : $phpUA["LANGUAGE"]["No"]);
        if ($infostring["mod"]) {
            $phpUA["TEMPLATE"]->assign("SERVER_MOD_VER", $infostring["modversion"]);
            $phpUA["TEMPLATE"]->assign("SERVER_MOD_SERVERSIDE", $infostring["svonly"] ? $phpUA["LANGUAGE"]["Yes"] : $phpUA["LANGUAGE"]["No"]);
            $phpUA["TEMPLATE"]->assign("SERVER_MOD_CUSTOMDLL", $infostring["cldll"] ? $phpUA["LANGUAGE"]["Yes"] : $phpUA["LANGUAGE"]["No"]);
        }
        switch ($infostring["type"]) {
            case "d":
                $phpUA["TEMPLATE"]->assign("SERVER_TYPE", $phpUA["LANGUAGE"]["Dedicated"]);
                break;
            case "l":
                $phpUA["TEMPLATE"]->assign("SERVER_TYPE", $phpUA["LANGUAGE"]["Listen"]);
                break;
        }
        switch ($infostring["os"]) {
            case "w":
                $phpUA["TEMPLATE"]->assign("SERVER_OS", "Windows");
                break;
            case "l":
                $phpUA["TEMPLATE"]->assign("SERVER_OS", "Linux");
                break;
        }
        
        $image = "images/plugin_hl/maps/" . $infostring["gamedir"] . "/" . $infostring["map"] . ".jpg";
        if (!file_exists($image)) $image = "images/templates/" . $phpUA["CONFIG"]["STYLE"] . "/plugin_hl/unavailable.jpg";
        $imagesize = getimagesize(ABSOLUTEPATH . $image);
        $phpUA["TEMPLATE"]->assign("SERVER_MAP_IMG", "<img src=\"" . $image . "\" width=\"" . $imagesize[0] . "\" height=\"" . $imagesize[1] . "\" alt=\"Map Image\">");
        
        // Additional "addons" Assignment (custom built)
        $addons = "";
        if ( !$rules = $server_query->rules() ) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
        if ( !empty($rules["amx_version"]) ) {
            $phpUA["TEMPLATE"]->assign("SERVER_AMXVERSION", $rules["amx_version"]);
            $addons .= ", AMX " . $rules["amx_version"];
        }
        if ( !empty($rules["metamod_version"]) ) {
            $phpUA["TEMPLATE"]->assign("SERVER_METAMODVERSION", $rules["metamod_version"]);
            $addons .= ", Metamod " . $rules["metamod_version"];
        }
        if ( !empty($rules["admin_mod_version"]) ) {
            $phpUA["TEMPLATE"]->assign("SERVER_ADMINMODVERSION", $rules["admin_mod_version"]);
            $addons .= ", AdminMod " . $rules["admin_mod_version"];
        }
        if ( !empty($rules["hlguard_version"]) ) {
            $phpUA["TEMPLATE"]->assign("SERVER_HLGUARDVERSION", $rules["hlguard_version"]);
            $addons .= ", HLGuard " . $rules["hlguard_version"];
        }
        if ( !empty($rules["cdversion"]) ) {
            $phpUA["TEMPLATE"]->assign("SERVER_CDVERSION", $rules["cdversion"]);
            $addons .= ", Cheating-Death " . $rules["cdversion"];
        }
        if ( !empty($rules["statsme_version"]) ) {
            $phpUA["TEMPLATE"]->assign("SERVER_STATSMEVERSION", $rules["statsme_version"]);
            $addons .= ", StatsMe " . $rules["statsme_version"];
        }
        if ( !empty($rules["clanmod_version"]) ) {
            $phpUA["TEMPLATE"]->assign("SERVER_CLANMODVERSION", $rules["clanmod_version"]);
            $addons .= ", ClanMod " . $rules["clanmod_version"];
        }
        $phpUA["TEMPLATE"]->assign("SERVER_ADDONS", substr($addons,2));
        
        // Display Template
        $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/plugin_hl/info.tpl");
        
        endBenchmark(__FILE__, __FUNCTION__);
    }
?>