<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: plugin_hl_mode_watch_mm.inc,v 1.8 2004/03/10 05:26:39 mad-x Exp $
    // Created by Brian A. Stumm (brian@phpua.com)
    //            Kris Splittgerber (kris@phpua.com)
    
    function plugin_hl_mode_watch_mm_updateinfo ($players, $timeleft, $scores)
    {
        // i(players, timeleft, scores)
        echo "i('" . $players  .  "', '" . $timeleft  .  "','" . $scores . "');\n";
    }
    
    function plugin_hl_mode_watch_mm_updatemap ($name, $img, $imgwidth, $imgheight, $visibility)
    {
        // m(name, img, imgwidth, imgheight)
        echo "m('" . strtolower($name)  .  "', '" . $img  .  "','" . $imgwidth . "','" . $imgheight . "','" . $visibility . "');\n";
    }
    
    function plugin_hl_mode_watch_mm_entity_on ($id, $x, $y, $img, $name)
    {
        // e1(id, x, y, img, name)
        echo "e1('" . $id  .  "', '" . $x  .  "', '" . $y  .  "', '" . $img  .  "', '" . $name . "');\n";
    }
    
    function plugin_hl_mode_watch_mm_entity_off ($id)
    {
        // e0(id)
        echo "e0('" . $id  .  "');\n";
    }
    
    function plugin_hl_mode_watch_mm_updateplayer ($id, $img, $visibility, $toX, $toY, $name, $team, $color, $model, $weapon, $kills, $deaths, $health, $armor, $ping, $time)
    {
        // p(id, imgid, img, visibility, toX, toY, name, team, color, model, weapon, kills, deaths, health, armor, ping, time)
        echo "p('" . $id  .  "', '" . $img  .  "', '" . $visibility  .  "', '" . $toX  .  "', '" . $toY  .  "', \"" . htmlentities($name, ENT_QUOTES)  .  "\", '" . $team  .  "', '" . $color  .  "', '" . $model  .  "', '" . $weapon  .  "', '" . $kills  .  "', '" . $deaths .  "', '" . $health  .  "', '" . $armor  .  "', '" . $ping  .  "', '" . $time . "');\n";
    }
    function plugin_hl_mode_watch_mm_clearplayer ($id)
    {
        // c(id)
        echo "c('" . $id  .  "');\n";
    }
    
    function plugin_hl_mode_watch_mm_addchat ($color, $line)
    {
        // ch0(color, line)
        echo "ch('" . $color  .  "', '" . htmlentities($line, ENT_QUOTES)  .  "');\n";
    }
    
    function plugin_hl_mode_watch_mm($id, $ip, $port, $rules)
    {
        global $phpUA;
        
        startBenchmark(__FILE__, __FUNCTION__);
        
        // Included by: plugin_hl_mode_watch.inc
        require_once(ABSOLUTEPATH . "plugins/plugin_hl/plugin_hl_mm.inc");
        $server_mm = new plugin_hl_mm($ip, $rules["phpua_mm_port"]);
        if (!$server_mm->connect()) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
        
        // Basic Template Assignments
        $phpUA["TEMPLATE"]->assign("SERVER_ID", $id);
        $phpUA["TEMPLATE"]->assign("SERVER_IP", $ip);
        $phpUA["TEMPLATE"]->assign("SERVER_PORT", $port);
        
        // Info
        if (!$data = $server_mm->getServer()) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
        $phpUA["TEMPLATE"]->assign("SERVER_HOSTNAME", $data["SERVER"]["HOST_NAME"][0]);
        $phpUA["TEMPLATE"]->assign("SERVER_ADDRESS", $data["SERVER"]["NET_ADDR"][0]);
        $phpUA["TEMPLATE"]->assign("SERVER_GAME_DIR", $data["SERVER"]["GAME_DIR"][0]);
        $phpUA["TEMPLATE"]->assign("SERVER_MAP", "<span id=\"server_map\">&nbsp</span>");
        $phpUA["TEMPLATE"]->assign("SERVER_PLAYER_CNT", "<span id=\"server_player_cnt\">&nbsp</span>");
        $phpUA["TEMPLATE"]->assign("SERVER_TIMELEFT", "<span id=\"server_timeleft\">&nbsp</span>");
        $phpUA["TEMPLATE"]->assign("SERVER_SCORES", "<span id=\"server_scores\">&nbsp</span>");
        
        // Overview
        $current_map = "";
        $overview_image = false;
        $phpUA["TEMPLATE"]->assign("SERVER_OVERVIEW_IMG", "<img id=\"server_overview_img\" width=\"24\" height=\"24\" alt=\"Overview Image\">");
        
        $overview_entities_array = array();
        // Overview Template Assignments
        switch ($data["SERVER"]["GAME_DIR"][0]) {
            case "cstrike":
                // Modification: Counter-Strike
                if (substr($data["SERVER"]["MAP_NAME"][0], 0, 2) == "de") {
                    // Bomb (only one)
                    $overview_entities_array[] = array("id"=>"bomb_0_img", "img"=>"<img id=\"bomb_0_img\" width=\"24\" height=\"24\" alt=\"" . $phpUA["LANGUAGE"]["Bomb"] . "\" style=\"position : absolute; visibility : hidden;\">");
                } elseif (substr($data["SERVER"]["MAP_NAME"][0], 0, 2) == "cs") {
                    // Hostages (assuming no more than 8)
                    for ($i=0; $i<8; $i++) {
                        $overview_entities_array[] = array("id"=>"hostage_" . $i . "_img", "img"=>"<img id=\"hostage_" . $i . "_img\" width=\"24\" height=\"24\" alt=\"" . $phpUA["LANGUAGE"]["Hostage"] . "\" style=\"position : absolute; visibility : hidden;\">");
                    }
                }
                break;
            case "tfc":
                // Modification: Team Fortress Classic
                // Flags (assuming no more than 8)
                for ($i=0; $i<8; $i++) {
                    $overview_entities_array[] = array("id"=>"flag_" . $i . "_img", "img"=>"<img id=\"flag_" . $i . "_img\" width=\"24\" height=\"24\" alt=\"" . $phpUA["LANGUAGE"]["Flag"] . "\" style=\"position : absolute; visibility : hidden;\">");
                }
                // Dispensers and Sentrys (one per player)
                for ($i=0; $i<$data["SERVER"]["MAX_PLAYERS"][0]; $i++) {
                    $overview_entities_array[] = array("id"=>"dispenser_" . $i . "_img", "img"=>"<img id=\"dispenser_" . $i . "_img\" width=\"24\" height=\"24\" alt=\"" . $phpUA["LANGUAGE"]["Dispenser"] . "\" style=\"position : absolute; visibility : hidden;\">");
                    $overview_entities_array[] = array("id"=>"sentry_" . $i . "_img", "img"=>"<img id=\"sentry_" . $i . "_img\" width=\"24\" height=\"24\" alt=\"" . $phpUA["LANGUAGE"]["Sentry"] . "\" style=\"position : absolute; visibility : hidden;\">");
                }
                // Teleporters (two per player - entry and exit)
                for ($i=0; $i<$data["SERVER"]["MAX_PLAYERS"][0]*2; $i++) {
                    $overview_entities_array[] = array("id"=>"teleporter_" . $i . "_img", "img"=>"<img id=\"teleporter_" . $i . "_img\" width=\"24\" height=\"24\" alt=\"" . $phpUA["LANGUAGE"]["Teleporter"] . "\" style=\"position : absolute; visibility : hidden;\">");
                }
                break;
            case "dod":
                // Modification: Day of Defeat
                // Flags (assuming no more than 8)
                for ($i=0; $i<8; $i++) {
                    $overview_entities_array[] = array("id"=>"flag_" . $i . "_img", "img"=>"<img id=\"flag_" . $i . "_img\" width=\"24\" height=\"24\" alt=\"" . $phpUA["LANGUAGE"]["Flag"] . "\" style=\"position : absolute; visibility : hidden;\">");
                }
                break;
            case "nsp":
                // Modification: Natural Selection
                // Command (only one)
                $overview_entities_array[] = array("id"=>"command_0_img", "img"=>"<img id=\"command_0_img\" width=\"24\" height=\"24\" alt=\"" . $phpUA["LANGUAGE"]["Command"] . "\" style=\"position : absolute; visibility : hidden;\">");
                // Hive (assuming no more than 3)
                for ($i=0; $i<3; $i++) {
                    $overview_entities_array[] = array("id"=>"hive_" . $i . "_img", "img"=>"<img id=\"hive_" . $i . "_img\" width=\"24\" height=\"24\" alt=\"" . $phpUA["LANGUAGE"]["Hive"] . "\" style=\"position : absolute; visibility : hidden;\">");
                }
                // Resource (assuming no more than 10)
                for ($i=0; $i<10; $i++) {
                    $overview_entities_array[] = array("id"=>"resource_" . $i . "_img", "img"=>"<img id=\"resource_" . $i . "_img\" width=\"24\" height=\"24\" alt=\"" . $phpUA["LANGUAGE"]["Resource"] . "\" style=\"position : absolute; visibility : hidden;\">");
                }
        }
        
        // Players
        for ($i=0; $i<$data["SERVER"]["MAX_PLAYERS"][0]; $i++) {
            $overview_entities_array[] = array("id"=>"player_" . $i . "_img", "img"=>"<img id=\"player_" . $i . "_img\" width=\"24\" height=\"24\" alt=\"Player\" style=\"position : absolute; visibility : hidden\">");
            $players_array[$i] = array("id"    =>$i,
                                       "name"  =>"<span id=\"player_" . $i . "_name\">&nbsp</span>",
                                       "team"  =>"<span id=\"player_" . $i . "_team\">&nbsp</span>",
                                       "model" =>"<span id=\"player_" . $i . "_model\">&nbsp</span>",
                                       "weapon"=>"<span id=\"player_" . $i . "_weapon\">&nbsp</span>",
                                       "kills" =>"<span id=\"player_" . $i . "_kills\">&nbsp</span>",
                                       "deaths"=>"<span id=\"player_" . $i . "_deaths\">&nbsp</span>",
                                       "health"=>"<span id=\"player_" . $i . "_health\">&nbsp</span>",
                                       "armor" =>"<span id=\"player_" . $i . "_armor\">&nbsp</span>",
                                       "ping"  =>"<span id=\"player_" . $i . "_ping\">&nbsp</span>",
                                       "time"  =>"<span id=\"player_" . $i . "_time\">&nbsp</span>");
        }
        $phpUA["TEMPLATE"]->assign("OVERVIEW_ENTITIES", $overview_entities_array);
        $phpUA["TEMPLATE"]->assign("SERVER_PLAYERS", $players_array);
        
        // Display Template
        $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/plugin_hl/watch_mm.tpl");
        $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/body_footer.tpl");
        flush();
        
        switch ($data["SERVER"]["GAME_DIR"][0]) {
            case "cstrike":
                $teams[0]["name"] = "Terrorist";
                $teams[0]["color"] = "red";
                $teams[0]["fontcolor"] = "#FE3636";
                $teams[1]["name"] = "Counter-Terrorist";
                $teams[1]["color"] = "blue";
                $teams[1]["fontcolor"] = "#858BFB";
                break;
            case "dod":
                $teams[0]["name"] = "Allied";
                $teams[0]["color"] = "green";
                $teams[0]["fontcolor"] = "#03E303";
                $teams[0]["flagcolor"] = "red";
                $teams[1]["name"] = "Axis";
                $teams[1]["color"] = "red";
                $teams[1]["fontcolor"] = "#FE3636";
                $teams[1]["flagcolor"] = "green";
                $teams[2]["flagcolor"] = "green";
                $teams[3]["flagcolor"] = "gray";
                $teams[4]["flagcolor"] = "red";
                $teams[5]["flagcolor"] = "green";
                $teams[6]["flagcolor"] = "green";
                $teams[7]["flagcolor"] = "gray";
                $classname[0] = "(" . $phpUA["LANGUAGE"]["none"] . ")";
                $classname[1] = "LightInf Garand";
                $classname[2] = "LightInf Carbine";
                $classname[3] = "Assualt Tommy";
                $classname[4] = "Assualt Grease";
                $classname[5] = "Sniper";
                $classname[6] = "Heavy Weapons";
                $classname[7] = "Machine Gunner";
                $classname[8] = "LeichtInf Kar";
                $classname[9] = "LeichtInf K43";
                $classname[10] = "German Sniper";
                $classname[11] = "Sturmtrup";
                $classname[12] = "Heavy Weapons";
                $classname[13] = "MG34";
                $classname[14] = "MG42";
                $classname[15] = "Brit LightInf";
                $classname[16] = "Brit AssaultInf";
                $classname[17] = "Brit Sniper";
                $classname[18] = "Brit Machine Gunner";
                $classname[19] = "Para Garand";
                $classname[20] = "Para Carbine";
                $classname[21] = "Para Thompson";
                $classname[22] = "Para Greasegun";
                $classname[23] = "Para Springfield";
                $classname[24] = "Para Bar";
                $classname[25] = "Para 30Cal";
                $classname[26] = "Para Kar";
                $classname[27] = "Para K43";
                $classname[28] = "Para Scoped Kar";
                $classname[29] = "Para MP40";
                $classname[30] = "para MP44";
                $classname[31] = "Para FG42 Bipod";
                $classname[32] = "Para FG42 Scope";
                $classname[33] = "Para MG34";
                $classname[34] = "Para MG42";
                $classname[35] = "Random";
                break;
            case "tfc":
                $teams[0]["name"] = "Blue";
                $teams[0]["color"] = "blue";
                $teams[0]["fontcolor"] = "#858BFB";
                $teams[0]["flagcolor"] = "gray";
                $teams[1]["name"] = "Red";
                $teams[1]["color"] = "red";
                $teams[1]["fontcolor"] = "#FE3636";
                $teams[1]["flagcolor"] = "red";
                $teams[2]["name"] = "Green";
                $teams[2]["color"] = "green";
                $teams[2]["fontcolor"] = "#009800";
                $teams[2]["flagcolor"] = "blue";
                $teams[3]["name"] = "Yellow";
                $teams[3]["color"] = "yellow";
                $teams[3]["fontcolor"] = "yellow";
                $teams[3]["flagcolor"] = "green";
                $teams[4]["flagcolor"] = "yellow";
                break;
            case "nsp":
                $teams[0]["name"] = "Marines";
                $teams[0]["color"] = "blue";
                $teams[0]["fontcolor"] = "#858BFB";
                $teams[1]["name"] = "Aliens";
                $teams[1]["color"] = "yellow";
                $teams[1]["fontcolor"] = "yellow";
                break;
            case "si":
                $teams[0]["name"] = "MCL";
                $teams[0]["color"] = "blue";
                $teams[1]["name"] = "AFD";
                $teams[1]["color"] = "green";
                break;
            default:
                $teams[0]["name"] = "Team 1";
                $teams[0]["color"] = "blue";
                $teams[1]["name"] = "Team 2";
                $teams[1]["color"] = "red";
                $teams[2]["name"] = "Team 3";
                $teams[2]["color"] = "green";
                $teams[3]["name"] = "Team 4";
                $teams[3]["color"] = "yellow";
        }
        
        // DEBUG: Test Offsets
        // echo "<img src=./images/templates/default/plugin_hl/flag_red.gif style=position:absolute;top:91;left:10;>";
        
        // Define Interval (for the purpose of the SlideTo JavaScript function)
        echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
        echo "interval = '" . $phpUA["CONFIG"]["INTERVAL"] . "';\n";
        echo "</script>\n";
        flush();
        
        // DEBUG: View the $data array
        /*    echo "<br><pre>";
            print_r($data);
            echo "</pre><br><br>";
            flush();
        */
        
        printBenchmark();
        
        // Stream Updates
        while (!connection_aborted()) {
            // The first time through, we evaluate TYPE SERVER (from getServer above)
            // then get another packet at the end of this while(){} loop.
            switch ($data["TYPE"]) {
                case "SAY":
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    for ($i=0; $i<$data["SERVER"]["MAX_PLAYERS"][0]; $i++) {
                        if ( $data["PLAYER"]["USER_ID"][$i] == $data["SAY"]["USER_ID"][0] ) {
                            plugin_hl_mode_watch_mm_addchat($teams[$data["PLAYER"]["TEAM"][$i]]["fontcolor"], $data["SAY"]["CHAT"][0]);
                            break;
                        }
                    }
                    echo "</script>\n";
                    flush();
                    break;
                case "SAY_TEAM":
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    for ($i=0; $i<$data["SERVER"]["MAX_PLAYERS"][0]; $i++) {
                        if ( $data["PLAYER"]["USER_ID"][$i] == $data["SAY_TEAM"]["USER_ID"][0] ) {
                            plugin_hl_mode_watch_mm_addchat($teams[$data["PLAYER"]["TEAM"][$i]]["fontcolor"], $data["SAY_TEAM"]["CHAT"][0]);
                            break;
                        }
                    }
                    echo "</script>\n";
                    flush();
                    break;
                case "SERVER_SAY":
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    plugin_hl_mode_watch_mm_addchat("#FFFFFF", str_replace("\"", "", $data["SERVER_SAY"]["CHAT"][0]));
                    echo "</script>\n";
                    flush();
                    break;
                case "HIVE":
                    if (!$overview_image) break;
                    // TYPE HIVE data relates to NSP
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    // Move hive images
                    if (!empty($data["HIVE"]["HIVE_NUM"])) {
                        for ($i=0; $i<count($data["HIVE"]["HIVE_NUM"]); $i++) {
                            $x = round($x_origin + ($data["HIVE"]["X_COORD"][$i] * $scale)-16);
                            $y = round($y_origin + ($data["HIVE"]["Y_COORD"][$i] * $scale)-16);
                            plugin_hl_mode_watch_mm_entity_on("hive_" . $i . "_img", $x, $y, "images/templates/" . $phpUA["STYLE"] . "/plugin_hl/icon_hive.png", $phpUA["LANGUAGE"]["Hive"]);
                        }
                    } else {
                        $data["HIVE"]["HIVE_NUM"] = array();
                    }
                    // Hide the rest
                    for ($i=count($data["HIVE"]["HIVE_NUM"]); $i<3; $i++) {
                        plugin_hl_mode_watch_mm_entity_off("hive_" . $i . "_img");
                    }
                    echo "</script>\n";
                    flush();
                    break;
                case "COMMAND":
                    if (!$overview_image) break;
                    // TYPE COMMAND data relates to NSP
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    // Move command image
                    if ( $data["COMMAND"]["COMMAND_NUM"][0] == "0" ) {
                        $x = round($x_origin + ($data["COMMAND"]["X_COORD"][0] * $scale)-16);
                        $y = round($y_origin + ($data["COMMAND"]["Y_COORD"][0] * $scale)-16);
                        plugin_hl_mode_watch_mm_entity_on("command_0_img", $x, $y, "images/templates/" . $phpUA["STYLE"] . "/plugin_hl/icon_command.png", $phpUA["LANGUAGE"]["Command"]);
                    } else {
                        plugin_hl_mode_watch_mm_entity_off("command_0_img");
                    }
                    echo "</script>\n";
                    flush();
                    break;
                case "RESOURCE":
                    if (!$overview_image) break;
                    // TYPE RESOURCE data relates to NSP
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    // Move resource images
                    if (!empty($data["RESOURCE"]["RESOURCE_NUM"])) {
                        for ($i=0; $i<count($data["RESOURCE"]["RESOURCE_NUM"]); $i++) {
                            $x = round($x_origin + ($data["RESOURCE"]["X_COORD"][$i] * $scale)-16);
                            $y = round($y_origin + ($data["RESOURCE"]["Y_COORD"][$i] * $scale)-16);
                            plugin_hl_mode_watch_mm_entity_on("resource_" . $i . "_img", $x, $y, "images/templates/" . $phpUA["STYLE"] . "/plugin_hl/icon_resource.png", $phpUA["LANGUAGE"]["Resource"]);
                        }
                    } else {
                        $data["RESOURCE"]["RESOURCE_NUM"] = array();
                    }
                    // Hide the rest
                    for ($i=count($data["RESOURCE"]["RESOURCE_NUM"]); $i<10; $i++) {
                        plugin_hl_mode_watch_mm_entity_off("resource_" . $i . "_img");
                    }
                    echo "</script>\n";
                    flush();
                    break;
                case "HOSTAGE":
                    if (!$overview_image) break;
                    if (substr($data["SERVER"]["MAP_NAME"][0], 0, 2) != "cs") break;
                    // TYPE HOSTAGE data relates to CSTRIKE
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    // Move hostage images
                    if (!empty($data["HOSTAGE"]["HOSTAGE_NUM"])) {
                        for ($i=0; $i<count($data["HOSTAGE"]["HOSTAGE_NUM"]); $i++) {
                            $x = round($x_origin + ($data["HOSTAGE"]["X_COORD"][$i] * $scale)-16);
                            $y = round($y_origin + ($data["HOSTAGE"]["Y_COORD"][$i] * $scale)-16);
                            plugin_hl_mode_watch_mm_entity_on("hostage_" . $i . "_img", $x, $y, "images/templates/" . $phpUA["STYLE"] . "/plugin_hl/icon_hostage.png", $phpUA["LANGUAGE"]["Hostage"] . " (" . $phpUA["LANGUAGE"]["Health"] . ": " . round($data["HOSTAGE"]["HEALTH"][$i], 0) . "%)");
                        }
                    } else {
                        $data["HOSTAGE"]["HOSTAGE_NUM"] = array();
                    }
                    // Hide the rest
                    for ($i=count($data["HOSTAGE"]["HOSTAGE_NUM"]); $i<8; $i++) {
                        plugin_hl_mode_watch_mm_entity_off("hostage_" . $i . "_img");
                    }
                    echo "</script>\n";
                    flush();
                    break;
                case "BOMB":
                    if (!$overview_image) break;
                    if (substr($data["SERVER"]["MAP_NAME"][0], 0, 2) != "de") break;
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    // Move bomb image (if it exists)
                    if ( $data["BOMB"]["BOMB_NUM"][0] == "0" ) {
                        $x = round($x_origin + ($data["BOMB"]["X_COORD"][0] * $scale)-16);
                        $y = round($y_origin + ($data["BOMB"]["Y_COORD"][0] * $scale)-16);
                        if ( $data["BOMB"]["PLANTED"][0] == 1 ) {
                            $thisimg = "bomb_planted.png";
                            $altmsg = $phpUA["LANGUAGE"]["Bomb"] . " (" . $phpUA["LANGUAGE"]["Planted"] . ")";
                        } else {
                            $thisimg = "bomb.png";
                            $altmsg = $phpUA["LANGUAGE"]["Bomb"] . " (" . $phpUA["LANGUAGE"]["NotPlanted"] . ")";
                        }
                        plugin_hl_mode_watch_mm_entity_on("bomb_0_img", $x, $y, "images/templates/" . $phpUA["STYLE"] . "/plugin_hl/" . $thisimg, $altmsg);
                    } else {
                        plugin_hl_mode_watch_mm_entity_off("bomb_0_img");
                    }
                    echo "</script>\n";
                    flush();
                    break;
                case "DISPENSER":
                    if (!$overview_image) break;
                    // TYPE DISPENSER data relates to TFC
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    // Move dispenser images
                    if (!empty($data["DISPENSER"]["DISPENSER_NUM"])) {
                        for ($i=0; $i<count($data["DISPENSER"]["DISPENSER_NUM"]); $i++) {
                            $x = round($x_origin + ($data["DISPENSER"]["DISPENSER_X_COORD"][$i] * $scale)-12);
                           $y = round($y_origin + ($data["DISPENSER"]["DISPENSER_Y_COORD"][$i] * $scale)-12);
                           plugin_hl_mode_watch_mm_entity_on("dispenser_" . $i . "_img", $x, $y, "images/templates/" . $phpUA["STYLE"] . "/plugin_hl/dispenser.png", $phpUA["LANGUAGE"]["Dispenser"] . " (" . $phpUA["LANGUAGE"]["Health"] . ": " . round($data["DISPENSER"]["DISPENSER_HEALTH"][$i]*100, 0) . "%)");
                        }
                    } else {
                        $data["DISPENSER"]["DISPENSER_NUM"] = array();
                    }
                    // Hide the rest
                    for ($i=count($data["DISPENSER"]["DISPENSER_NUM"]); $i<$data["SERVER"]["MAX_PLAYERS"][0]; $i++) {
                        plugin_hl_mode_watch_mm_entity_off("dispenser_" . $i . "_img");
                    }
                    echo "</script>\n";
                    flush();
                    break;
                case "SENTRY":
                    if (!$overview_image) break;
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    // Move sentry images
                    if (!empty($data["SENTRY"]["SG_NUM"])) {
                        for ($i=0; $i<count($data["SENTRY"]["SG_NUM"]); $i++) {
                            $x = round($x_origin + ($data["SENTRY"]["SG_X_COORD"][$i] * $scale)-12);
                            $y = round($y_origin + ($data["SENTRY"]["SG_Y_COORD"][$i] * $scale)-12);
                            $sentrylevel = "1";
                            // Possible Bug: SG_LEVEL not always defined (Mad-X)
                            if ( !empty($DATA["SENTRY"]["SG_LEVEL"][$i]) ) {
                                if (strstr($DATA["SENTRY"]["SG_LEVEL"][$i], "sentry1")) {
                                    $sentrylevel = "1";
                                }
                                if (strstr($DATA["SENTRY"]["SG_LEVEL"][$i], "sentry2")) { 
                                    $sentrylevel = "2";
                                }
                                if (strstr($DATA["SENTRY"]["SG_LEVEL"][$i], "sentry3")) {
                                    $sentrylevel = "3";
                                }
                            }
                            // SENTRY GUN ROTATION ANGLE
                            $sentryangle = 0;
                            // Possible Bug: SG_ANGLE not always defined (Mad-X)
                            if (!empty($DATA["SENTRY"]["SG_ANGLE"][$i])) {
                                if (($DATA["SENTRY"]["SG_ANGLE"][$i] > 0) && ($DATA["SENTRY"]["SG_ANGLE"][$i] <= 90)) {
                                    $sentryangle = 0;
                                } elseif (($DATA["SENTRY"]["SG_ANGLE"][$i] > 90) && ($DATA["SENTRY"]["SG_ANGLE"][$i] <= 180)) {
                                    $sentryangle = 3;
                                } elseif (($DATA["SENTRY"]["SG_ANGLE"][$i] > 180) && ($DATA["SENTRY"]["SG_ANGLE"][$i] <= 270)) {
                                    $sentryangle = 2;
                                } else {
                                    $sentryangle = 1;
                                }
                            }
                            plugin_hl_mode_watch_mm_entity_on("sentry_" . $i . "_img", $x, $y, "images/templates/" . $phpUA["STYLE"] . "/plugin_hl/sentry" . $sentrylevel . "_" . $data["SENTRY"]["SG_TEAM"][$i] . ".png", $phpUA["LANGUAGE"]["SentryLevel"] . " " . $sentrylevel . " (" . $phpUA["LANGUAGE"]["Health"] . ": " . round($data["SENTRY"]["SG_HEALTH"][$i]*100, 0) . "%)");
                            // this is for rotation of sentry guns but mm currently not providing this data... It broke at some point :(
                            echo "xGetElementById(\"sentry_" . $i . "_img\").style.filter=\"progid:DXImageTransform.Microsoft.BasicImage(rotation=" . $sentryangle . ")\";\n";
                        }
                    } else {
                        $data["SENTRY"]["SG_NUM"] = array();
                    }
                    // Hide the rest
                    for ($i=count($data["SENTRY"]["SG_NUM"]); $i<$data["SERVER"]["MAX_PLAYERS"][0]; $i++) {
                        plugin_hl_mode_watch_mm_entity_off("sentry_" . $i . "_img");
                    }
                    echo "</script>\n";
                    flush();
                    break;
                case "TELEPORTER":
                    if (!$overview_image) break;
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    // Move teleporter images
                    if (!empty($data["TELEPORTER"]["TELEPORTER_NUM"])) {
                        for ($i=0; $i<count($data["TELEPORTER"]["TELEPORTER_NUM"]); $i++) {
                            $x = round($x_origin + ($data["TELEPORTER"]["TELEPORTER_X_COORD"][$i] * $scale)-12);
                            $y = round($y_origin + ($data["TELEPORTER"]["TELEPORTER_Y_COORD"][$i] * $scale)-12);
                            plugin_hl_mode_watch_mm_entity_on("teleporter_" . $i . "_img", $x, $y, "images/templates/" . $phpUA["STYLE"]  . "/plugin_hl/teleporter" . $data["TELEPORTER"]["TELEPORTER_TEAM"][$i] . ".png", $phpUA["LANGUAGE"]["Teleporter"] . " (" . $phpUA["LANGUAGE"]["Health"] . ": " . round($data["TELEPORTER"]["TELEPORTER_HEALTH"][$i]*100, 0) . "%)");
                        }
                    } else {
                        $data["TELEPORTER"]["TELEPORTER_NUM"] = array();
                    }
                    // Hide the rest
                    for ($i=count($data["TELEPORTER"]["TELEPORTER_NUM"]); $i<$data["SERVER"]["MAX_PLAYERS"][0]*2; $i++) {
                        plugin_hl_mode_watch_mm_entity_off("teleporter_" . $i . "_img");
                    }
                    echo "</script>\n";
                    flush();
                    break;
                case "FLAG":
                    if (!$overview_image) break;
                    // TYPE FLAG data relates to TFC and DoD (currently)
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    if (!empty($data["FLAG"]["FLAG_NUM"])) {
                        for ($i=0; $i<count($data["FLAG"]["FLAG_NUM"]); $i++) {
                            $x = round($x_origin + ($data["FLAG"]["X_COORD"][$i] * $scale)-16);
                            $y = round($y_origin + ($data["FLAG"]["Y_COORD"][$i] * $scale)-16);
                            if ( $data["FLAG"]["NAME"][$i] == "stripper2") {
                                plugin_hl_mode_watch_mm_entity_off("flag_" . $i . "_img");
                            } else {
                                plugin_hl_mode_watch_mm_entity_on("flag_" . $i . "_img", $x, $y, "images/templates/" . $phpUA["STYLE"] . "/plugin_hl/flag_" . $teams[$data["FLAG"]["TEAM"][$i]]["flagcolor"] . ".gif", $data["FLAG"]["NAME"][$i]);
                            }
                        }
                    } else {
                        $data["FLAG"]["FLAG_NUM"] = array();
                    }
                    for ($i=count($data["FLAG"]["FLAG_NUM"]); $i<8; $i++) {
                        plugin_hl_mode_watch_mm_entity_off("flag_" . $i . "_img");
                    }
                    echo "</script>\n";
                    flush();
                    break;
                case "SERVER":
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    if ($current_map != $data["SERVER"]["MAP_NAME"][0]) {
                        unset($data);
                        if (!$data = $server_mm->getServer()) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
                        $current_map = $data["SERVER"]["MAP_NAME"][0];
                        // Update Overview Image
                        $image = "images/plugin_hl/overviews/" . strtolower($data["SERVER"]["GAME_DIR"][0]) . "/" . strtolower($data["SERVER"]["MAP_NAME"][0]) . ".png";
                        foreach ($overview_entities_array as $value) {
                            plugin_hl_mode_watch_mm_entity_off($value["id"]);
                        }
                        if (!file_exists($image)) {
                            $overview_image = false;
                            plugin_hl_mode_watch_mm_updatemap($data["SERVER"]["MAP_NAME"][0], "", 0, 0, "hidden");
                        } else {
                            $overview_image = true;
                            unset($imagesize);
                            $imagesize = GetImageSize(ABSOLUTEPATH . $image);
                            // Determine scale based on image size compared to world size.
                            $scale = $imagesize[1] / $data["SERVER"]["WORLDSIZE_X"][0];
                            // Find the center of the image on the screen and compensate for the co-ord offset.
                            // Page offsets are now handled by JavaScript.
                            $x_origin = ($imagesize[1] / 2); // x = height
                            $y_origin = ($imagesize[0] / 2); // y = width
                            plugin_hl_mode_watch_mm_updatemap($data["SERVER"]["MAP_NAME"][0], $image, $imagesize[0], $imagesize[1], "visible");
                        }
                    }
                    // Update Info
                    // - Players
                    if (!empty($data["PLAYER"])) {
                        $server_player_cnt = count($data["PLAYER"]["USER_ID"]) . " / " . $data["SERVER"]["MAX_PLAYERS"][0];
                    } else {
                        $server_player_cnt = "0 / " . $data["SERVER"]["MAX_PLAYERS"][0];
                    }
                    // - Time Left
                    if (!$rules["mp_timelimit"] == 0) {
                        if ( $data["SERVER"]["TIMELEFT"][0] < 0) $timeleft = "0:00";
                        else $timeleft = date("i:s", $data["SERVER"]["TIMELEFT"][0]);
                    } else {
                        $timeleft = $phpUA["LANGUAGE"]["Infinite"];
                    }
                    // - Scores
                    $server_scores = "";
                    for ($i=0; $i<4; $i++) {
                        if ((isset($data["SERVER"]["TEAM_NAMES"][$i])) && (isset($data["SERVER"]["TEAM_SCORES"][$i]))) {
                            $server_scores .= $data["SERVER"]["TEAM_NAMES"][$i] . ": " . $data["SERVER"]["TEAM_SCORES"][$i] . "  ";
                        }
                    }
                    plugin_hl_mode_watch_mm_updateinfo($server_player_cnt, $timeleft, $server_scores);
                    echo "</script>\n";
                    flush();
                    break;
                case "PLAYER":
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    // Move player images and fill table
                      for ($i=0; $i<count($data["PLAYER"]["USER_ID"]); $i++) {
                          if ($overview_image) {
                            // Determine image icon
                            if ( $data["PLAYER"]["DEAD"][$i] == 1 ) {
                                $data["PLAYER"]["IMG"][$i] = "images/templates/" . $phpUA["STYLE"] . "/plugin_hl/icon_dead.png";
                            } elseif ($data["PLAYER"]["MODEL"][$i] == "vip") {
                                $data["PLAYER"]["IMG"][$i] = "images/templates/" . $phpUA["STYLE"] . "/plugin_hl/icon_vip.png";
                            } elseif ($data["PLAYER"]["TEAM"][$i] != -1) {
                                $data["PLAYER"]["IMG"][$i] = "images/templates/" . $phpUA["STYLE"] . "/plugin_hl/icon_" . $teams[$data["PLAYER"]["TEAM"][$i]]["color"] . ".png";
                            } else {
                                $data["PLAYER"]["IMG"][$i] = "";
                            }
                            // Determine image position
                            $y = round($y_origin + ($data["PLAYER"]["Y_COORD"][$i] * $scale)-12);
                            $x = round($x_origin + ($data["PLAYER"]["X_COORD"][$i] * $scale)-12);
                            // Determine visibility (dead?)
                            if ($data["PLAYER"]["DEAD"][$i] > 1) $visibility = "hidden";
                            else $visibility = "visible";
                        } else {
                            $data["PLAYER"]["IMG"][$i] = "";
                            $y = 0;
                            $x = 0;
                            $visibility = "hidden";
                        }
                        // Fill table
                        $data["PLAYER"]["KILLS"][$i] = round($data["PLAYER"]["KILLS"][$i]);
                        $data["PLAYER"]["HEALTH"][$i] = round($data["PLAYER"]["HEALTH"][$i] * 100);
                        if ($data["PLAYER"]["HEALTH"][$i] < 0) $data["PLAYER"]["HEALTH"][$i] = 0;
                          $data["PLAYER"]["ARMOR"][$i] = round($data["PLAYER"]["ARMOR"][$i] * 100);
                        if ($data["PLAYER"]["ARMOR"][$i] < 0) $data["PLAYER"]["ARMOR"][$i] = 0;
                        $data["PLAYER"]["TIMES"][$i] = date("i", $data["PLAYER"]["TIMES"][$i]+86400) . "min " . date("s", $data["PLAYER"]["TIMES"][$i]+86400) . "sec";
                        if ($data["PLAYER"]["TEAM"][$i] == "-1") {
                            // p(id, img, visibility, toX, toY, name, team, color, model, weapon, kills, deaths, health, armor, ping, time)
                            plugin_hl_mode_watch_mm_updateplayer($i, "", "hidden", "0", "0", $data["PLAYER"]["NAMES"][$i], "SPEC", "silver", "", "", "", "", "", "", "", $data["PLAYER"]["TIMES"][$i]);
                         } else {
                            if (!isset($data["PLAYER"]["WEAPON"][$i])) $data["PLAYER"]["WEAPON"][$i] = "(" . $phpUA["LANGUAGE"]["none"] . ")";
                            elseif ($data["PLAYER"]["WEAPON"][$i] == "models/null") $data["PLAYER"]["WEAPON"][$i] = "(" . $phpUA["LANGUAGE"]["none"] . ")";
                            
                            switch ($data["SERVER"]["GAME_DIR"][0]) {
                                case "cstrike":
                                case "nsp":
                                case "tfc":
                                    $data["PLAYER"]["MODELNAME"][$i] = $data["PLAYER"]["MODEL"][$i];
                                    break;
                                case "dod":
                                    $data["PLAYER"]["MODELNAME"][$i] = $classname[$data["PLAYER"]["MODEL"][$i]];
                                    break;
                            }
                            if (($data["PLAYER"]["HEALTH"][$i] <= 0) || (($data["SERVER"]["GAME_DIR"][0] == "cstrike") && ($data["PLAYER"]["WEAPON"][$i] == "(" . $phpUA["LANGUAGE"]["none"] . ")"))) {
                                $data["PLAYER"]["HEALTH"][$i] = $phpUA["LANGUAGE"]["DEAD"];
                            }
                            // p(id, img, visibility, toX, toY, name, team, color, model, weapon, kills, deaths, health, armor, ping, time)
                            plugin_hl_mode_watch_mm_updateplayer($i, $data["PLAYER"]["IMG"][$i], $visibility, $x, $y, $data["PLAYER"]["NAMES"][$i], $teams[$data["PLAYER"]["TEAM"][$i]]["name"], $teams[$data["PLAYER"]["TEAM"][$i]]["fontcolor"], $data["PLAYER"]["MODELNAME"][$i], $data["PLAYER"]["WEAPON"][$i], $data["PLAYER"]["KILLS"][$i], $data["PLAYER"]["DEATHS"][$i], $data["PLAYER"]["HEALTH"][$i], $data["PLAYER"]["ARMOR"][$i], $data["PLAYER"]["PINGS"][$i], $data["PLAYER"]["TIMES"][$i]);
                        }
                    }
                    // Hide the rest
                    for ($i=count($data["PLAYER"]["NAMES"]); $i<$data["SERVER"]["MAX_PLAYERS"][0]; $i++) {
                        plugin_hl_mode_watch_mm_clearplayer($i);
                    }
                    echo "</script>\n";
                    flush();
                    break;
            }
            // TimeLimit Exceeded?
            if (time() >= ($phpUA["ENGINE"]["TIME"] + $phpUA["CONFIG"]["TIMELIMIT"] - $phpUA["CONFIG"]["TIMEOUT"])) {
                $server_mm->disconnect();
                plugin_hl_mode_watch_timelimitreached($id);
            }
            // Rinse & Repeat
            flush();
            if (!ini_get("safe_mode")) set_time_limit(ini_get("max_execution_time"));
            if (is_null($packet = $server_mm->getPacket())) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
            $data["TYPE"] = $packet["TYPE"];
            if (empty($packet[$packet["TYPE"]])) $packet[$packet["TYPE"]] = array("TYPE"=>"");
            $data[$packet["TYPE"]] = $packet[$packet["TYPE"]];
        }
    }
?>