/*
* phpUA
* United Admins  2004
* http://www.unitedadmins.com/
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*/

// $Id: watch_mm.js,v 1.1 2004/02/28 03:14:00 mad-x Exp $
// watch.js: Created by Kris Splittgerber (kris@phpua.com)

// Definition Defaults (external -- to be set by phpUA)
var interval = 1; // Interval between updates in seconds

// Info (external -- called by phpUA)
function i(players, timeleft, scores) {
	xGetElementById("server_player_cnt").childNodes[0].nodeValue = players;
	xGetElementById("server_timeleft").childNodes[0].nodeValue = timeleft;
	xGetElementById("server_scores").childNodes[0].nodeValue = scores;
}

// Map (external -- called by phpUA)
function m(name, img, imgwidth, imgheight, visibility) {
	xGetElementById("server_map").childNodes[0].nodeValue = name;
	xGetElementById("server_overview_img").src = img;
	xGetElementById("server_overview_img").width = imgwidth;
	xGetElementById("server_overview_img").height = imgheight;
	xGetElementById("server_overview_img").style.visibility = visibility;
}

// Entity On (external -- called by phpUA)
function e1(id, x, y, img, name) {
	x = parseInt(x) + parseInt(findPosY(xGetElementById("server_overview_img")));
	y = parseInt(y) + parseInt(findPosX(xGetElementById("server_overview_img")));
	xGetElementById(id).alt = name;
	xGetElementById(id).title = name;
	xGetElementById(id).src = img;
	xGetElementById(id).style.visibility = "visible";
	xSlideTo(id,y, x, interval * 1000);
}

// Entity Off (external -- called by phpUA)
function e0(id) {
	xGetElementById(id).style.visibility = "hidden";
}

// Add Player (external -- called by phpUA)
function p(id, img, visibility, toX, toY, name, team, color, model, weapon, kills, deaths, health, armor, ping, time) {
	toX = parseInt(toX) + parseInt(findPosY(xGetElementById("server_overview_img")));
	toY = parseInt(toY) + parseInt(findPosX(xGetElementById("server_overview_img")));
	xGetElementById("player_" + id + "_img").src = img;
	xGetElementById("player_" + id + "_img").style.visibility = visibility;
	xGetElementById("player_" + id + "_img").alt = name;
	xGetElementById("player_" + id + "_img").title = name;
	xGetElementById("player_" + id + "_name").innerHTML = name;
	xGetElementById("player_" + id + "_name").style.color = color;
	xGetElementById("player_" + id + "_team").childNodes[0].nodeValue = team;
	xGetElementById("player_" + id + "_team").style.color = color;
	xGetElementById("player_" + id + "_model").childNodes[0].nodeValue = model;
	xGetElementById("player_" + id + "_model").style.color = color;
	xGetElementById("player_" + id + "_weapon").childNodes[0].nodeValue = weapon;
	xGetElementById("player_" + id + "_weapon").style.color = color;
	xGetElementById("player_" + id + "_kills").childNodes[0].nodeValue = kills;
	xGetElementById("player_" + id + "_kills").style.color = color;
	xGetElementById("player_" + id + "_deaths").childNodes[0].nodeValue = deaths;
	xGetElementById("player_" + id + "_deaths").style.color = color;
	xGetElementById("player_" + id + "_health").childNodes[0].nodeValue = health;
	xGetElementById("player_" + id + "_health").style.color = color;
	xGetElementById("player_" + id + "_armor").childNodes[0].nodeValue = armor;
	xGetElementById("player_" + id + "_armor").style.color = color;
	xGetElementById("player_" + id + "_ping").childNodes[0].nodeValue = ping;
	xGetElementById("player_" + id + "_ping").style.color = color;
	xGetElementById("player_" + id + "_time").childNodes[0].nodeValue = time;
	xGetElementById("player_" + id + "_time").style.color = color;
	xSlideTo("player_" + id + "_img", toY, toX, interval * 1000);
}

// Clear Player (external -- called by phpUA)
function c(id) {
	xGetElementById("player_" + id + "_img").visibility = "hidden";
	xGetElementById("player_" + id + "_name").innerHTML = " ";
	xGetElementById("player_" + id + "_team").childNodes[0].nodeValue = " ";
	xGetElementById("player_" + id + "_model").childNodes[0].nodeValue = " ";
	xGetElementById("player_" + id + "_weapon").childNodes[0].nodeValue = " ";
	xGetElementById("player_" + id + "_kills").childNodes[0].nodeValue = " ";
	xGetElementById("player_" + id + "_deaths").childNodes[0].nodeValue = " ";
	xGetElementById("player_" + id + "_health").childNodes[0].nodeValue = " ";
	xGetElementById("player_" + id + "_armor").childNodes[0].nodeValue = " ";
	xGetElementById("player_" + id + "_ping").childNodes[0].nodeValue = " ";
	xGetElementById("player_" + id + "_time").childNodes[0].nodeValue = " ";
}

// Grow (internal)
function grow(id) {
	xGetElementById("player_" + id + "_name_td").className = "selectedcell";
	xGetElementById("player_" + id + "_team_td").className = "selectedcell";
	xGetElementById("player_" + id + "_model_td").className = "selectedcell";
	xGetElementById("player_" + id + "_weapon_td").className = "selectedcell";
	xGetElementById("player_" + id + "_kills_td").className = "selectedcell";
	xGetElementById("player_" + id + "_deaths_td").className = "selectedcell";
	xGetElementById("player_" + id + "_health_td").className = "selectedcell";
	xGetElementById("player_" + id + "_armor_td").className = "selectedcell";
	xGetElementById("player_" + id + "_ping_td").className = "selectedcell";
	xGetElementById("player_" + id + "_time_td").className = "selectedcell";
	xGetElementById("player_" + id + "_img").width = 48;
	xGetElementById("player_" + id + "_img").height = 48;
}

// Shrink (internal)
function shrink(id) {
	xGetElementById("player_" + id + "_name_td").className = "lightcell";
	xGetElementById("player_" + id + "_team_td").className = "lightcell";
	xGetElementById("player_" + id + "_model_td").className = "lightcell";
	xGetElementById("player_" + id + "_weapon_td").className = "lightcell";
	xGetElementById("player_" + id + "_kills_td").className = "lightcell";
	xGetElementById("player_" + id + "_deaths_td").className = "lightcell";
	xGetElementById("player_" + id + "_health_td").className = "lightcell";
	xGetElementById("player_" + id + "_armor_td").className = "lightcell";
	xGetElementById("player_" + id + "_ping_td").className = "lightcell";
	xGetElementById("player_" + id + "_time_td").className = "lightcell";
	xGetElementById("player_" + id + "_img").width = 24;
	xGetElementById("player_" + id + "_img").height = 24;
}

// Add Chat (external -- called by phpUA)
function ch(color, line) {
	xGetElementById("player_chat").innerHTML += "<br><font color='" + color + "'>" + line + "</font>";
	xGetElementById("player_chat").scrollTop += "100";
}

// Peter-Paul Koch (http://www.quirksmode.org/)
function findPosX(obj)
{
	var curleft = 0;
	if (obj.offsetParent)
	{
		while (obj.offsetParent)
		{
			curleft += obj.offsetLeft
			obj = obj.offsetParent;
		}
	}
	else if (obj.x)
		curleft += obj.x;
	return curleft;
}

function findPosY(obj)
{
	var curtop = 0;
	if (obj.offsetParent)
	{
		while (obj.offsetParent)
		{
			curtop += obj.offsetTop
			obj = obj.offsetParent;
		}
	}
	else if (obj.y)
		curtop += obj.y;
	return curtop;
}
