<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: plugin_hl_mm.inc,v 1.2 2004/02/26 09:05:35 mad-x Exp $
    // Created by Brian A. Stumm (brian@phpua.com)
    //            Kris Splittgerber (kris@phpua.com)
    
    addCredits("plugin_hl_mm.inc", "Brian A. Stumm");
    
    class plugin_hl_mm {
        var $_ip;
        var $_port;
        var $_socket;
        var $_timeout;
        var $_interval;
        
        function plugin_hl_mm($ip = "127.0.0.1", $port = "40015") // Default port is HLDS port (27015) + 13000.
        {
            global $phpUA;
            $this->_ip = $ip;
            $this->_port = $port;
            $this->_timeout = $phpUA["CONFIG"]["TIMEOUT"];
            $this->_interval = $phpUA["CONFIG"]["INTERVAL"];
        }
        
        function connect() // Connects to the Metamod Plug-in.
        {
            if (!$this->_socket = fsockopen($this->_ip, $this->_port, $errno, $errstr, $this->_timeout)) return false;
            if (!$this->_writeData("SET_REFRESH " . $this->_interval)) return false;
            return true;
        }
        
        function disconnect() // Disconnects from the Metamod Plug-in.
        {
            if (!fclose($this->_socket)) return false;
            return true;
        }
        
        function _writeData($data) // Sends a packet of data to the Metamod Plug-in.
        {
            if (!fwrite($this->_socket, $data . "\n")) return false;
            return true;
        }
        
        function _readLine() // Reads just one line of data from the Metamod Plug-in.
        {
            socket_set_timeout($this->_socket, $this->_timeout + $this->_interval);
            $line = trim(fgets($this->_socket, 1024), " \t\n\r\0");
            if (socket_timeout($this->_socket)) return NULL;
            return $line;
        }
        
        function getServer() // Wait until we receive a packet of TYPE GET_SERVER and return it.
        {
            startBenchmark(__FILE__, __FUNCTION__);
            if (!$this->_writeData("GET_SERVER"));
            if (is_null($data = $this->getPacket())) return false;
            while ($data["TYPE"] != "SERVER") {
                if (is_null($data = $this->getPacket())) return false;
            }
            $array = array();
            $array["TYPE"] = "SERVER";
            $array["SERVER"] = $data["SERVER"];
            endBenchmark(__FILE__, __FUNCTION__);
            return $array;
        }
		
		function getPacket() // Returns a single TYPE message. PLAYER data is sorted by TEAM then KILLS then DEATHS.
        {
			startBenchmark(__FILE__, __FUNCTION__);
            
			global $phpUA;
            
			if (is_null($header = $this->_readLine())) return NULL;
			$columns = explode("\t", $header);
			$type = $columns[1];
			$data["TYPE"] = $type;
            
			if (is_null($line = $this->_readLine())) return NULL;
			while (!empty($line)) {
				$columns = explode("\t", $line);
				for ($i=1; $i<count($columns); $i++) {
					$data[$type][$columns[0]][$i-1] = $columns[$i];
				}
				if (is_null($line = $this->_readLine())) return NULL;
			}
            
			if (($type == "PLAYER") && (!empty($data["PLAYER"]))) {
				for ($i=0; $i<count($data["PLAYER"]["USER_ID"]); $i++) {
					if (!empty($data["PLAYER"]["WEAPON"][$i])) $data["PLAYER"]["WEAPON"][$i] = trim($data["PLAYER"]["WEAPON"][$i]);
					if (empty($data["PLAYER"]["WEAPON"][$i])) $data["PLAYER"]["WEAPON"][$i] = "(" . $phpUA["LANGUAGE"]["none"] . ")";
					$data["PLAYER"]["WEAPON"][$i] = str_replace(".mdl", "", $data["PLAYER"]["WEAPON"][$i]);
					$data["PLAYER"]["WEAPON"][$i] = str_replace("models/p_", "", $data["PLAYER"]["WEAPON"][$i]);
				}
                
	 			// SORT PLAYER ARRAY BY TEAM THEN KILLS THEN DEATHS -bs
				@array_multisort(
					$data["PLAYER"]["TEAM"], SORT_ASC,
					$data["PLAYER"]["KILLS"], SORT_DESC,
					$data["PLAYER"]["DEATHS"], SORT_ASC, 
					$data["PLAYER"]["NAMES"],
					$data["PLAYER"]["MODEL"],
					$data["PLAYER"]["HEALTH"],
					$data["PLAYER"]["ARMOR"],
					$data["PLAYER"]["PINGS"],
					$data["PLAYER"]["PACKET_LOSS"],
					$data["PLAYER"]["TIMES"],
					$data["PLAYER"]["STEAM_ID"],
					$data["PLAYER"]["USER_ID"],
					$data["PLAYER"]["INDEX_NUM"],
					$data["PLAYER"]["IP"],
					$data["PLAYER"]["WEAPON"],
					$data["PLAYER"]["X_COORD"],
					$data["PLAYER"]["Y_COORD"],
					$data["PLAYER"]["Z_COORD"],
					$data["PLAYER"]["ANGLE"],
					$data["PLAYER"]["DEAD"]);
			}
            
			endBenchmark(__FILE__, __FUNCTION__);
			return $data;
		}
	}
?>


