<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: plugin_hl_mode_watch_query.inc,v 1.7 2004/02/29 00:19:26 mad-x Exp $
    // Created by Kris Splittgerber (kris@phpua.com)
    
    function plugin_hl_mode_watch_query_updateinfo ($cur_players, $max_players)
    {
        // s(cur_players, max_players)
        echo "s('" . $cur_players . "', '" . $max_players . "');\n";
    }
    
    function plugin_hl_mode_watch_query_updatemap ($map, $mapimg, $mapimgwidth, $mapimgheight)
    {
        // m(map, mapimg, mapimgwidth, mapimgheight)
        echo "m('" . strtolower($map) . "', '" . $mapimg . "', '" . $mapimgwidth . "', '" . $mapimgheight . "');\n";
    }
    
    function plugin_hl_mode_watch_query_updateplayer ($id, $name, $frags, $time)
    {
        // p(id, name, frags, time)
        echo "p('" . $id . "', '" . htmlentities($name, ENT_QUOTES) . "', '" . $frags . "', '" . $time . "');\n";
    }
    
    function plugin_hl_mode_watch_query_clearplayer ($count)
    {
        // c(count)
        echo "c('" . $count . "');\n";
    }
    
    function plugin_hl_mode_watch_query($id, $ip, $port, $server_query)
    {
        startBenchmark(__FILE__, __FUNCTION__);
        global $phpUA;
        
        // Basic Template Assignments
        $phpUA["TEMPLATE"]->assign("SERVER_ID", $id);
        $phpUA["TEMPLATE"]->assign("SERVER_IP", $ip);
        $phpUA["TEMPLATE"]->assign("SERVER_PORT", $port);
        
        // Info
        $current_map = "";
        if (!$details = $server_query->details()) return false;
        $phpUA["TEMPLATE"]->assign("SERVER_HOSTNAME", $details["hostname"]);
        $phpUA["TEMPLATE"]->assign("SERVER_ADDRESS", $details["address"]);
        $phpUA["TEMPLATE"]->assign("SERVER_CUR_PLAYERS", "<span id=\"server_cur_players\">&nbsp</span>");
        $phpUA["TEMPLATE"]->assign("SERVER_MAX_PLAYERS", "<span id=\"server_max_players\">&nbsp</span>");
        
        // Players
        for ($i=0; $i<$details["max_players"]; $i++) {
            $players_array[$i] = array("name"=>"<span id=\"player_" . $i . "_name\">&nbsp</span>",
                                       "frags"=>"<span id=\"player_" . $i . "_frags\">&nbsp</span>",
                                       "time"=>"<span id=\"player_" . $i . "_time\">&nbsp</span>");
        }
        $phpUA["TEMPLATE"]->assign("SERVER_PLAYERS", $players_array);
        
        // Map
        $phpUA["TEMPLATE"]->assign("SERVER_MAP", "<span id=\"server_map\">&nbsp</span>");
        $phpUA["TEMPLATE"]->assign("SERVER_MAP_IMG", "<img id=\"server_map_img\" alt=\"Map Image\">");
        $phpUA["TEMPLATE"]->assign("SERVER_MAP_IMG_TITLE", "<span id=\"server_map_img_title\">&nbsp</span>");
        
        // Display Template
        $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/plugin_hl/watch_query.tpl");
        $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/body_footer.tpl");
        
        endBenchmark(__FILE__, __FUNCTION__);
        printBenchmark();
        flush();
        
        // Stream Updates
        while (!connection_aborted()) {
            echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
            
            // Info
            if (!$details = $server_query->details()) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>" . __FILE__ . ":" . __LINE__);
            plugin_hl_mode_watch_query_updateinfo($details["cur_players"], $details["max_players"]);
            
            // Players
            $players = $server_query->players();
            $players_sorted = array();
            for ($i=0; $i<$details["cur_players"]; $i++) {
                if ( empty($players["id"][$i]) ) {
                    $players["id"][$i] = "";
                    $players["name"][$i] = "(" . $phpUA["LANGUAGE"]["connecting"] . ")";
                    $players["frags"][$i] = " ";
                    $players["time"][$i] = "";
                }
                $players_sorted[] = array("id"=>$players["id"][$i],
                                          "name"=>$players["name"][$i],
                                          "frags"=>$players["frags"][$i],
                                          "time"=>$players["time"][$i]);
            }
            foreach ($players_sorted as $key => $row) {
                $frags[$key] = $row["frags"];
                $name[$key] = $row["name"];
            }
            @array_multisort($frags, SORT_DESC, $name, SORT_ASC, $players_sorted);
            for ($i=0; $i<count($players_sorted); $i++) {
                plugin_hl_mode_watch_query_updateplayer($i, $players_sorted[$i]["name"], $players_sorted[$i]["frags"], $players_sorted[$i]["time"]);
            }
            plugin_hl_mode_watch_query_clearplayer($details["cur_players"]);
            
            // Map
            if ($details["map"] != $current_map) {
                $mapimg = "images/plugin_hl/maps/" . strtolower($details["mod_dir"]) . "/" . strtolower($details["map"]) . ".jpg";
                if ( !file_exists(ABSOLUTEPATH . $mapimg) ) {
                    $mapimg = "images/templates/" . $phpUA["STYLE"] . "/plugin_hl/unavailable.jpg";
                }
                $mapimgsize = getimagesize(ABSOLUTEPATH . $mapimg);
                plugin_hl_mode_watch_query_updatemap($details["map"], $mapimg, $mapimgsize[0], $mapimgsize[1]);
                $current_map = $details["map"];
            }
            
            echo "</script>\n";
            
            // Rinse and Repeat
            flush();
            sleep($phpUA["CONFIG"]["INTERVAL"]);
            if (!ini_get("safe_mode")) set_time_limit(ini_get("max_execution_time"));
            if (time() >= ($phpUA["ENGINE"]["TIME"] + $phpUA["CONFIG"]["TIMELIMIT"] - $phpUA["CONFIG"]["TIMEOUT"])) {
                plugin_hl_mode_watch_timelimitreached($id);
            }
        }
    }
?>