<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: plugin_q3_mode_info.inc,v 1.6 2004/02/27 12:51:26 mad-x Exp $
    // Created by Hendrik Leppkes (punisher@unitedadmins.com)
    
    pluginRegisterMode("Q3", "info", $phpUA["LANGUAGE"]["Info"], "plugin_q3_mode_info", 1, 1, 0, "plugin_q3_mode_info.inc");
    
    function plugin_q3_mode_info($id, $ip, $port)
    {
        startBenchmark(__FILE__, __FUNCTION__);
        
        global $phpUA;
        require_once(ABSOLUTEPATH . "plugins/shared/plugin_q3_query.inc");
        $server_query = new plugin_q3_query($ip, $port);
        
        $phpUA["TEMPLATE"]->assign("SERVER_ID", $id);
        $phpUA["TEMPLATE"]->assign("SERVER_IP", $ip);
        $phpUA["TEMPLATE"]->assign("SERVER_PORT", $port);
        
        if ( !$status = $server_query->getstatus() ) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
        if ( !$info = $server_query->getinfo() ) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
        $phpUA["TEMPLATE"]->assign("SERVER_HOSTNAME", $server_query->stripColorCodes($status["sv_hostname"]));
        $phpUA["TEMPLATE"]->assign("SERVER_MAP", $status["mapname"]);
        
        $image = "images/plugin_q3/maps/" . $status["mapname"] . ".jpg";
        if (!file_exists($image)) {
            $image = "images/templates/" . $phpUA["STYLE"] . "/plugin_q3/unavailable.jpg";
        }
        $imagesize = getimagesize(ABSOLUTEPATH . $image);
        $phpUA["TEMPLATE"]->assign("SERVER_MAP_IMG", "<img src=\"" . $image . "\" width=\"" . $imagesize[0] . "\" height=\"" . $imagesize[1] . "\" alt=\"Map Image\">");
        
        $phpUA["TEMPLATE"]->assign("SERVER_MAP_IMG_TITLE", $status["mapname"]);
        $phpUA["TEMPLATE"]->assign("SERVER_GAME_DIR", $status["gamename"]);
        if (empty($status["gameversion"])) {
            $phpUA["TEMPLATE"]->assign("SERVER_GAME_VERSION", "");
        } else {
            $phpUA["TEMPLATE"]->assign("SERVER_GAME_VERSION", $status["gameversion"]);
        }
        $phpUA["TEMPLATE"]->assign("SERVER_PLAYERS_CURRENT", $info["clients"]);
        $phpUA["TEMPLATE"]->assign("SERVER_PLAYERS_MAX", ($status["sv_maxclients"] - $status["sv_privateclients"]) ." (" . $status["sv_maxclients"] . ")");
        $phpUA["TEMPLATE"]->assign("SERVER_PROTOCOL", $status["protocol"]);
        $phpUA["TEMPLATE"]->assign("SERVER_VERSION", $status["version"]);
        $phpUA["TEMPLATE"]->assign("SERVER_PASSWORD", $status["g_needpass"] ? $phpUA["LANGUAGE"]["Required"] : $phpUA["LANGUAGE"]["None"]);
        $phpUA["TEMPLATE"]->assign("SERVER_PUNKBUSTER", $status["sv_punkbuster"] ? $phpUA["LANGUAGE"]["Yes"] : $phpUA["LANGUAGE"]["No"]);
        
        // 0 = "Free for All"
	    // 1 = "Duel Arena"
	    // 2 = "Free for All" (yes, it's listed again)
	    // 3 = "Team Deathmatch"
	    // 4 = "Capture The Flag"
	    // 5 = "Clan Arena" // not on baseq3, but OSP or CPMA
	    switch($status["g_gametype"]) {
            case 1:
                $phpUA["TEMPLATE"]->assign("SERVER_TYPE", "Duel Arena");
                break;
            case 3:
                $phpUA["TEMPLATE"]->assign("SERVER_TYPE", "Team Deathmatch");
                break;
            case 4:
                $phpUA["TEMPLATE"]->assign("SERVER_TYPE", "Capture The Flag");
                break;
            case 5:
                $phpUA["TEMPLATE"]->assign("SERVER_TYPE", "Clan Arena");
                break;
            default:
                $phpUA["TEMPLATE"]->assign("SERVER_TYPE", "Free for All");
                break;
        }
        
        // Display Template
        $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/plugin_q3/info.tpl");
        
        endBenchmark(__FILE__, __FUNCTION__);
    }
?>