<?php
   /*
    * phpUA
    * United Admins  2004
    * http://www.unitedadmins.com/
    *
    * This program is free software; you can redistribute it and/or
    * modify it under the terms of the GNU General Public License
    * as published by the Free Software Foundation; either version 2
    * of the License, or (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    *
    */
    
    // $Id: plugin_ut_mode_watch.inc,v 1.4 2004/02/27 13:22:51 mad-x Exp $
    // Created by Kris Splittgerber (kris@phpua.com)
    
    pluginRegisterMode("UT", "watch", $phpUA["LANGUAGE"]["Watch"], "plugin_ut_mode_watch",1,1,0, "plugin_ut_mode_watch.inc");
    
    function plugin_ut_mode_watch($id, $ip, $port)
    {
        startBenchmark(__FILE__, __FUNCTION__);
        
        global $phpUA;
        require_once(ABSOLUTEPATH . "plugins/shared/plugin_gs_query.inc");
        $server_query = new plugin_gs_query($ip, $port + 1);
        
        if ($info = $server_query->info()) {
            $phpUA["TEMPLATE"]->assign("SERVER_ID", $id);
            $phpUA["TEMPLATE"]->assign("SERVER_IP", $ip);
            $phpUA["TEMPLATE"]->assign("SERVER_PORT", $port);
            
            $phpUA["TEMPLATE"]->assign("SERVER_HOSTNAME", $info["hostname"]);
            $phpUA["TEMPLATE"]->assign("SERVER_MAPNAME", "<span id=\"server_mapname\">&nbsp</span>");
            $phpUA["TEMPLATE"]->assign("SERVER_NUMPLAYERS", "<span id=\"server_numplayers\">&nbsp</span>");
            $phpUA["TEMPLATE"]->assign("SERVER_MAXPLAYERS", "<span id=\"server_maxplayers\">&nbsp</span>");
            
            for($i=0; $i<$info["maxplayers"]; $i++) {
                $players_array[$i] = array("name"=>"<span id=\"player_" . $i . "_name\">&nbsp</span>",
                                           "team"=>"<span id=\"player_" . $i . "_team\">&nbsp</span>",
                                           "frags"=>"<span id=\"player_" . $i . "_frags\">&nbsp</span>",
                                           "mesh"=>"<span id=\"player_" . $i . "_mesh\">&nbsp</span>",
                                           "skin"=>"<span id=\"player_" . $i . "_skin\">&nbsp</span>",
                                           "face"=>"<span id=\"player_" . $i . "_face\">&nbsp</span>",
                                           "face_img"=>"<img id=\"player_" . $i . "_face_img\" width=\"0\" height=\"0\" alt=\"None\">",
                                           "ping"=>"<span id=\"player_" . $i . "_ping\">&nbsp</span>");
            }
            $phpUA["TEMPLATE"]->assign("SERVER_PLAYERS", $players_array);
            
            $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/plugin_ut/watch.tpl");
            $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/body_footer.tpl");
            
            endBenchmark(__FILE__, __FUNCTION__);
            printBenchmark();
            
            $startTimeLimit = time();
            while (!connection_aborted()) {
                if (!$info = $server_query->info()) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
                if (!$players = $server_query->players()) displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
                echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                plugin_ut_mode_watch_updateserver($info["mapname"], $info["numplayers"], $info["maxplayers"]);
                $players_sorted = array();
                for($i=0; $i<$info["numplayers"]; $i++) {
                    $player_team = $players["team"][$i] + 1;
                    if ( $info["gametype"] == "CTFGame" ) {
                        switch ( $player_team ) {
                            case 1:
                                $player_team = "Red";
                                break;
                            case 2:
                                $player_team = "Blue";
                                break;
                        }
                    }
                    if ($player_team == "256") {
                        $face_img = "";
                        $players["player"][$i] = "(" . $phpUA["LANGUAGE"]["connecting"] . ")";
                        $players["team"][$i] = "";
                        $player_team = "";
                        $players["frags"][$i] = "";
                        $players["mesh"][$i] = "";
                        $players["skin"][$i] = "";
                        $players["face"][$i] = "";
                        $players["ping"][$i] = "";
                    }
                    $face_img = "images/plugin_ut/faces/" . $players["face"][$i] . ".jpg";
                    if (!file_exists($face_img)) $face_img = "images/plugin_ut/faces/unknown.jpg";
                    $players_sorted[] = array("face_img"=>$face_img,
                                              "name"=>$players["player"][$i],
                                              "team"=>$players["team"][$i],
                                              "teamname"=>$player_team,
                                              "frags"=>$players["frags"][$i],
                                              "mesh"=>$players["mesh"][$i],
                                              "skin"=>$players["skin"][$i],
                                              "face"=>$players["face"][$i],
                                              "ping"=>$players["ping"][$i]);
                }
                foreach ($players_sorted as $key => $row) {
                    $team[$key] = $row["team"];
                    $frags[$key] = $row["frags"];
                    $name[$key] = $row["name"];
                }
                @array_multisort($team, SORT_ASC, $frags, SORT_DESC, $name, SORT_ASC, $players_sorted);
                for ($i=0; $i<count($players_sorted); $i++) {
                    plugin_ut_mode_watch_updateplayer($i, $players_sorted[$i]["face_img"], $players_sorted[$i]["name"], $players_sorted[$i]["teamname"], $players_sorted[$i]["frags"], $players_sorted[$i]["mesh"], $players_sorted[$i]["skin"], $players_sorted[$i]["face"], $players_sorted[$i]["ping"]);
                }
                plugin_ut_mode_watch_clearplayer($info["numplayers"]);
                echo "</script>\n";
                if (time() >= ($phpUA["ENGINE"]["TIME"] + $phpUA["CONFIG"]["TIMELIMIT"] - $phpUA["CONFIG"]["TIMEOUT"])) {
                    echo "<script language=\"JavaScript\" type=\"text/javascript\">\n";
                    echo "if ( confirm('" . $phpUA["LANGUAGE"]["ERROR_TIMELIMITREACHED"] . "') ) {\n";
                    echo "  document.location.href = '" . INDEXFILE . "?mode=watch&server=" . $id . "';\n";
                    echo "} else {\n";
                    echo "  document.location.href = '" . INDEXFILE . "?mode=index';\n";
                    echo "}\n";
                    echo "</script>\n";
                    $phpUA["TEMPLATE"]->display($phpUA["STYLE"] . "/html_footer.tpl");
                    exit;
                }
                flush();
                sleep($phpUA["CONFIG"]["INTERVAL"]);
                if (!ini_get("safe_mode")) set_time_limit(ini_get("max_execution_time"));
            }
        }
        else {
            displayErrorMessage($phpUA["LANGUAGE"]["ConnectionTimeout"] . "<br>(" . basename(__FILE__) . ":" . __LINE__ . ")");
        }
        
    }
    
    function plugin_ut_mode_watch_updateplayer($id, $face_img, $name, $team, $frags, $mesh, $skin, $face, $ping)
    {
        // p(id, face_img, name, team, frags, mesh, skin, face, ping)
        echo "p('" . $id . "', '" . $face_img . "', '" . htmlentities($name, ENT_QUOTES) . "', '" . $team . "', '" . $frags . "', '" . $mesh . "', '" . $skin . "', '" . $face . "', '" . $ping . "');\n";
    }
    
    function plugin_ut_mode_watch_clearplayer($count)
    {
        // c(count)
        echo "c('" . $count . "');\n";
    }
    
    function plugin_ut_mode_watch_updateserver($mapname, $numplayers, $maxplayers)
    {
        // s(mapname, numplayers, maxplayers)
        echo "s('" . $mapname . "', '" . $numplayers . "', '" . $maxplayers . "');\n";
    }
?>