<?php
/*
Copyright 2001,2002,2003 Dashamir Hoxha, dashohoxha@users.sourceforge.net

This file is part of phpWebApp.

phpWebApp is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

phpWebApp is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with phpWebApp; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  
*/


/**
 * Class MenuTopElem represents a top element of a menu.
 *
 * @package     boxes
 * @subpackage  editMenus
 */
class MenuTopElem extends MenuElem
{
  var $left_position;
  var $top_position;

  /** eft_position="null", $top_position="null") */
  function MenuTopElem($id =UNDEFINED, $descr ="menu top element", $act="",
    {
      MenuElem::MenuElem($id, $descr, $act);
      $this->left_position    = $left_position;
      $this->top_position             = $top_position;
    }
        
  /** builds a menu top element from a DOMXML node */
  function build_from_dom($elem)
    {
      //get the attributes
      $this->id                               = $elem->getattr("id");
      $this->description              = $elem->getattr("description");
      $this->action                   = $elem->getattr("action");
      $this->top_position             = $elem->getattr("topPos");
      $this->left_position    = $elem->getattr("leftPos");
      if ($this->description=="")             $this->description = $this->id;
      if ($this->action=="")                  $this->action = $this->id;
                
      //add the child elements
      $children = $elem->children();
      while ( list($i,$child) = each($children) )
        {
          if ($child->name=="MenuElem")
            {
              $sub_elem = new MenuElem;
              $sub_elem->build_from_dom($child);
              $this->addChild($sub_elem);
            }
        }
    }
        
  /** returns the object as an XML string */
  function to_xml($indent)
    {
      $xml_menu = $indent.'<MenuTopElem id="'.$this->id."\"\n"
        . "\t\t".$indent.'description="'.$this->description."\"\n"
        . "\t\t".$indent.'action="'.$this->action."\"\n"
        . "\t\t".$indent.'topPos="'.$this->top_position."\"\n"
        . "\t\t".$indent.'leftPos="'.$this->left_position."\">\n";
      $xml_menu .= $this->children_to_xml("\t".$indent);
      $xml_menu .= $indent."</MenuTopElem>\n";
      return $xml_menu;
    }

  ///////////////////////////////////////////////////
  //returns the menu starting with this top element
  //in the JavaScript format required by hierMenus
  //
  /**
   * idth="null",
   * ont_color="", $mouseover_font_color="",
   * g_color="", $mouseover_bg_color="",
   * order_color="", $separator_color="")
   * 
   */
  function to_arrMenus($menu_name,
    {
      $js_menu = $menu_name . " = new Array(\n"
        . "\t" . $width.",\n"
        . "\t" . $this->left_position   . ", " . $this->top_position . ",\n"
        . "\t\"" . $font_color          . "\", \"" . $mouseover_font_color . "\",\n"
        . "\t\"" . $bg_color            . "\", \"" . $mouseover_bg_color . "\",\n"
        . "\t\"" . $border_color        . "\", \"" . $separator_color . "\",\n";
                
      $nrCh = $this->nrChildren();
      for ($i=0; $i < $nrCh-1; $i++)
        {
          $ch = $this->children[$i];
          $js_menu .= "\t\"" . $ch->description . "\", \"" . $ch->action."\", "
            . ($ch->hasChildren() ? "1" : "0") . ",\n";
        }
      //last child
      $ch = $this->children[$i];
      $js_menu .= "\t\"" . $ch->description . "\", \"" . $ch->action."\", "
        . ($ch->hasChildren() ? "1" : "0") . "\n";      //without a comma
      $js_menu .= ");\n\n";
      $js_menu .= $this->children_to_arrMenus($menu_name."_");
                
      return $js_menu;
    }
}

?>
